/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.dialogs.CalledBasicProgramSelectionDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.InterfaceSelectionDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.InterfaceSelectionListWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.ServiceWizard;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.ServiceConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ServiceWizardPage
extends InterfaceSelectionListWizardPage {
    private int nColumns = 5;
    private StringDialogField fServiceDialogField;
    private Button fGenAsWebService;
    private Button fGenAsRestService;
    private ServiceFieldAdapter adapter = new ServiceFieldAdapter();
    private StatusInfo fServiceStatus;
    protected ListDialogField fCalledBasicPgmDialogField;

    protected ServiceWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLServiceWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLServiceWizardPageDescription);
        this.fServiceStatus = new StatusInfo();
        this.initSuperInterfacesControl(this.adapter);
        this.initCalledBatchPgmControl(this.adapter);
    }

    private ServiceConfiguration getConfiguration() {
        return (ServiceConfiguration)((ServiceWizard)this.getWizard()).getConfiguration();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_SERVICE_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.createServiceControls(composite);
        String interfaceLabel = NewWizardMessages.NewTypeWizardPageInterfacesClassLabel;
        this.createEGLInterfacesControls(composite, this.nColumns, interfaceLabel);
        this.createGenAsRestServiceChkbox(composite, this.nColumns);
        this.createAdvancedComposite(composite, this.nColumns);
        this.modifyFileListeners();
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    protected void createGenAsRestServiceChkbox(Composite parent, int nColumns) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        this.fGenAsRestService = new Button(parent, 32);
        this.fGenAsRestService.setLayoutData((Object)gd);
        this.fGenAsRestService.setText(NewWizardMessages.CreateAsRestService);
        this.fGenAsRestService.setSelection(this.getConfiguration().isGenAsRestService());
        this.fGenAsRestService.addSelectionListener(new SelectionListener(){

            private void setOverwriteSelection(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    Button btn = (Button)e.getSource();
                    ServiceWizardPage.this.getConfiguration().setGenAsRestService(btn.getSelection());
                    ServiceWizardPage.this.validatePage();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.setOverwriteSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.setOverwriteSelection(e);
            }
        });
    }

    protected void createServiceControls(Composite parent) {
        this.fServiceDialogField = new StringDialogField();
        this.fServiceDialogField.setDialogFieldListener(this.adapter);
        this.fServiceDialogField.setLabelText(NewWizardMessages.NewEGLServiceWizardPagePartlabel);
        this.fServiceDialogField.setText(this.getConfiguration().getServiceName());
        this.fServiceDialogField.setEnabled(false);
        this.fServiceDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fServiceDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fServiceDialogField.getTextControl(null));
    }

    protected void initCalledBatchPgmControl(IListAdapter listadapter) {
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.NewTypeWizardPageInterfacesAdd;
        stringArray[2] = NewWizardMessages.NewTypeWizardPageInterfacesRemove;
        String[] addButtons = stringArray;
        this.fCalledBasicPgmDialogField = new ListDialogField(listadapter, addButtons, (ILabelProvider)new CalledBatchPgmListLabelProvider());
        this.fCalledBasicPgmDialogField.setRemoveButtonIndex(2);
    }

    public List getCalledBasicPrograms() {
        return this.fCalledBasicPgmDialogField.getElements();
    }

    @Override
    protected void addToAdvancedComposite(Composite parent) {
        String callBatchPgmLabel = NewWizardMessages.NewTypeWizardPageBasicPgmLabel;
        this.createEGLCalledBasicPgmControls(parent, this.nColumns, callBatchPgmLabel);
    }

    protected void createEGLCalledBasicPgmControls(Composite composite, int nColumns, String InterfaceLabel) {
        Label advaceLabelMsg = new Label(composite, 0);
        advaceLabelMsg.setText(NewWizardMessages.NewTypeWizardPageBasicPgmAdvanceMessage);
        GridData gd1 = new GridData(0);
        gd1.horizontalSpan = nColumns;
        advaceLabelMsg.setLayoutData((Object)gd1);
        this.fCalledBasicPgmDialogField.setLabelText(InterfaceLabel);
        this.fCalledBasicPgmDialogField.doFillIntoGrid(composite, nColumns);
        GridData gd = (GridData)this.fCalledBasicPgmDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
    }

    @Override
    protected void typePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fCalledBasicPgmDialogField) {
            this.chooseCalledBasicPgm();
        }
        super.typePageCustomButtonPressed(field, index);
    }

    private void chooseCalledBasicPgm() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IEGLProject project = root.getEGLProject();
        CalledBasicProgramSelectionDialog dialog = new CalledBasicProgramSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this.fCalledBasicPgmDialogField, this.getConfiguration(), project);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPageBasicPgmDialogTitle);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPageBasicPgmDialogMessage);
        dialog.open();
    }

    @Override
    protected InterfaceSelectionDialog getInterfaceSelectionDialog(IEGLProject project) {
        InterfaceSelectionDialog dialog = new InterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this.fSuperInterfacesDialogField, 2048, null, this.getConfiguration(), project);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPageInterfacesDialogClassTitle);
        return dialog;
    }

    protected void modifyFileListeners() {
        this.fEGLFileDialogField.getTextControl(null).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceWizardPage.this.fServiceDialogField.setText(ServiceWizardPage.this.fEGLFileDialogField.getText());
            }
        });
    }

    private void handleServiceDialogFieldChanged() {
        this.getConfiguration().setServiceName(this.fServiceDialogField.getText());
        this.validatePage();
    }

    @Override
    protected boolean validatePage() {
        if (super.validatePage()) {
            this.fServiceStatus.setOK();
            String partName = this.getConfiguration().getServiceName();
            if (partName.length() == 0) {
                this.fServiceStatus.setError(NewWizardMessages.NewTypeWizardPageErrorEnterPartName);
            } else if (partName.indexOf(46) != -1) {
                this.fServiceStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
            } else {
                this.validateEGLName(partName, 22, this.fServiceStatus);
            }
            this.updateStatus(new IStatus[]{this.fServiceStatus});
            return this.fServiceStatus.getSeverity() != 4;
        }
        return false;
    }

    private class CalledBatchPgmListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = PluginImages.DESC_OBJS_PGM.createImage();

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }

    private class ServiceFieldAdapter
    extends InterfaceSelectionListWizardPage.InterfaceListFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private ServiceFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ServiceWizardPage.this.handleServiceDialogFieldChanged();
        }
    }
}

