/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.INullableTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Parameter;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;
import org.eclipse.edt.ide.ui.wizards.InterfaceConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class ExtractInterfaceConfiguration
extends InterfaceConfiguration {
    private Part fTheBoundPart;
    private SourcePart fTheSourcePart = null;
    private String originalServicePackage = "";
    private List fFunctions = new ArrayList();
    private List fFunctionsSelectionState = new ArrayList();

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        IEGLFile serviceFile = this.getSelectedIEGLFile(selection);
        if (serviceFile != null) {
            IPart sourcepart;
            String fileName;
            String partSimpleName = fileName = this.initFile_Package(serviceFile);
            if (serviceFile.exists() && this.fTheSourcePart == null && (sourcepart = serviceFile.getPart(partSimpleName)) instanceof SourcePart) {
                this.fTheSourcePart = (SourcePart)sourcepart;
            }
            if (this.fTheSourcePart != null && this.fTheSourcePart.isService()) {
                partSimpleName = this.fTheSourcePart.getElementName();
            }
            this.setInterface(this.getFileName());
            Part boundPart = ExtractInterfaceConfiguration.getBoundPart(serviceFile, partSimpleName);
            if (boundPart instanceof Service) {
                this.initBoundPart_FunctionList(boundPart);
                return;
            }
        }
    }

    protected String initFile_Package(IEGLFile eglFile) {
        IEGLElement parentElem = eglFile.getParent();
        this.originalServicePackage = parentElem.getElementName();
        this.setFPackage(this.originalServicePackage);
        String fileName = eglFile.getElementName();
        int dot = fileName.indexOf(46);
        fileName = fileName.substring(0, dot);
        this.setFileName("I" + fileName);
        return fileName;
    }

    protected void initBoundPart_FunctionList(Part boundPart) {
        this.fTheBoundPart = boundPart;
        this.initFunctionList(this.fTheBoundPart);
    }

    protected void setInterface(String name) {
        this.setInterfaceName(name);
    }

    protected IEGLFile getSelectedIEGLFile(IStructuredSelection selection) {
        IEGLFile serviceFile = null;
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof IFile) {
            IEGLElement eglElem = EGLCore.create((IFile)((IFile)selectedElement));
            if (eglElem instanceof IEGLFile) {
                serviceFile = (IEGLFile)eglElem;
            }
        } else if (selectedElement instanceof IEGLFile) {
            serviceFile = (IEGLFile)selectedElement;
        } else if (selectedElement instanceof SourcePart) {
            this.fTheSourcePart = (SourcePart)selectedElement;
            serviceFile = this.fTheSourcePart.getEGLFile();
        }
        return serviceFile;
    }

    private void initFunctionList(Part part) {
        this.fFunctions.clear();
        this.fFunctionsSelectionState.clear();
        part.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(Service service) {
                return true;
            }

            public boolean visit(ExternalType externaltype) {
                return true;
            }

            public boolean visit(NestedFunction nestedFunction) {
                if (!nestedFunction.isPrivate()) {
                    ExtractInterfaceConfiguration.this.fFunctions.add(nestedFunction);
                    ExtractInterfaceConfiguration.this.fFunctionsSelectionState.add(new Boolean(true));
                }
                return false;
            }
        });
    }

    public static String getFunctionSimpleSignature(NestedFunction eglfunc, boolean resolveQualifier, String currFilePkg) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(eglfunc.getName().getCanonicalName());
        strbuf.append("(");
        List params = eglfunc.getFunctionParameters();
        Iterator it = params.iterator();
        boolean bFirst = true;
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof FunctionParameter)) continue;
            if (!bFirst) {
                strbuf.append(", ");
            }
            FunctionParameter eglfuncparam = (FunctionParameter)obj;
            strbuf.append(eglfuncparam.getName().getCanonicalName());
            strbuf.append(" ");
            String strParamType = ExtractInterfaceConfiguration.getQualifiedTypeString((Parameter)eglfuncparam, currFilePkg, resolveQualifier);
            strbuf.append(strParamType);
            strbuf.append(" ");
            if (eglfuncparam.getUseType() == FunctionParameter.UseType.IN) {
                strbuf.append("in");
            } else if (eglfuncparam.getUseType() == FunctionParameter.UseType.OUT) {
                strbuf.append("out");
            } else if (eglfuncparam.getUseType() == FunctionParameter.UseType.INOUT) {
                strbuf.append("inOut");
            }
            bFirst = false;
        }
        strbuf.append(")");
        return strbuf.toString();
    }

    public static String getFunctionSimpleSignature(IFunction func, boolean resolveQualifier, String currFilePkg) throws EGLModelException {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(func.getElementName());
        strbuf.append("(");
        String[] paramNames = func.getParameterNames();
        String[] paramTypes = func.getParameterTypes();
        String[] useTypes = func.getUseTypes();
        String[] paramPkgs = func.getParameterPackages();
        boolean isFirst = true;
        int i = 0;
        while (i < func.getNumberOfParameters()) {
            if (!isFirst) {
                strbuf.append(", ");
            } else {
                isFirst = false;
            }
            strbuf.append(paramNames[i]);
            strbuf.append(" ");
            strbuf.append(ExtractInterfaceConfiguration.getQualifiedTypeString(Signature.toString((String)paramTypes[i]), paramPkgs[i], currFilePkg));
            if (useTypes.length > i && useTypes[i].trim().length() > 0) {
                strbuf.append(" ");
                strbuf.append(useTypes[i]);
            }
            ++i;
        }
        strbuf.append(")");
        return strbuf.toString();
    }

    public static String getQualifiedTypeString(Parameter egltypedElem, String currFilePkg, boolean resolveQualifier) {
        Type paramType = egltypedElem.getType();
        return ExtractInterfaceConfiguration.getQualifiedTypeString(paramType, currFilePkg, resolveQualifier);
    }

    public static String getQualifiedTypeString(Type elemType, String currFilePkg, boolean resolveQualifier) {
        String qualifier;
        ITypeBinding elemTypeBinding = elemType.resolveTypeBinding();
        StringBuffer qualifiedTypeString = new StringBuffer();
        String typeName = elemType.getCanonicalName();
        if (resolveQualifier && (qualifier = ExtractInterfaceConfiguration.getReferenceTypeParamQualifier(elemTypeBinding, currFilePkg)).length() > 0) {
            qualifiedTypeString.append(qualifier);
            qualifiedTypeString.append(".");
        }
        if (elemTypeBinding != null && elemTypeBinding != IBinding.NOT_FOUND_BINDING) {
            ExtractInterfaceConfiguration.getSimpleTypeString(elemTypeBinding, qualifiedTypeString);
        } else {
            qualifiedTypeString.append(typeName);
        }
        return qualifiedTypeString.toString();
    }

    public static String getQualifiedTypeString(String elemTypeName, String elemTypePkg, String currFilePkg) {
        if (elemTypePkg == null || elemTypePkg.trim().length() == 0) {
            return elemTypeName;
        }
        if (elemTypePkg.equalsIgnoreCase(currFilePkg)) {
            return elemTypeName;
        }
        return String.valueOf(elemTypePkg) + "." + elemTypeName;
    }

    public static void getSimpleTypeString(ITypeBinding elemTypeBinding, StringBuffer simpleTypeString) {
        int bindingtypeKind = elemTypeBinding.getKind();
        if (elemTypeBinding.isNullable()) {
            INullableTypeBinding nullableTypeBinding = (INullableTypeBinding)elemTypeBinding;
            ExtractInterfaceConfiguration.getSimpleTypeString(nullableTypeBinding.getValueType(), simpleTypeString);
            simpleTypeString.append('?');
        } else if (bindingtypeKind == 2) {
            ArrayTypeBinding arrayTypeBinding = (ArrayTypeBinding)elemTypeBinding;
            ExtractInterfaceConfiguration.getSimpleTypeString(arrayTypeBinding.getElementType(), simpleTypeString);
            simpleTypeString.append("[]");
        } else {
            simpleTypeString.append(elemTypeBinding.getName());
        }
    }

    public static String getReferenceTypeParamQualifier(ITypeBinding typeBinding, String currFilePkg) {
        String qualifier = "";
        if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING) {
            while (typeBinding instanceof ArrayTypeBinding) {
                ArrayTypeBinding arrayTypeBinding = (ArrayTypeBinding)typeBinding;
                typeBinding = arrayTypeBinding.getElementType();
            }
            String[] stringArray = typeBinding.getPackageName();
        }
        if (currFilePkg.equalsIgnoreCase(qualifier)) {
            return "";
        }
        return qualifier;
    }

    public List getFFunctions() {
        return this.fFunctions;
    }

    public boolean getFunctionSelectionState(int i) {
        Boolean B = (Boolean)this.fFunctionsSelectionState.get(i);
        return B;
    }

    public void setFunctionsSelectionState(int i, boolean bState) {
        this.fFunctionsSelectionState.set(i, new Boolean(bState));
    }

    public List getFFunctionsSelectionState() {
        return this.fFunctionsSelectionState;
    }

    public Part getTheBoundPart() {
        return this.fTheBoundPart;
    }

    public String getOriginalServicePackage() {
        return this.originalServicePackage;
    }

    protected void setTheBoundPart(Part boundPart) {
        this.fTheBoundPart = boundPart;
    }
}

