/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.internal.templates.TemplateEngine;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLFileOperation;
import org.eclipse.edt.ide.ui.wizards.InterfaceConfiguration;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;

public class InterfaceOperation
extends EGLFileOperation {
    private InterfaceConfiguration configuration;
    private List interfaces;

    public InterfaceOperation(InterfaceConfiguration configuration, List superInterfaces) {
        super(configuration);
        this.configuration = configuration;
        this.interfaces = superInterfaces;
    }

    @Override
    protected String getFileContents() throws PartTemplateException {
        String interfaceOutputString = "";
        StringBuffer importString = new StringBuffer();
        String templateName = "interface";
        String templateid = "org.eclipse.edt.ide.ui.templates.interface";
        String templateVariableInterfaceName = "${interfaceName}";
        String templateVariableSuperInterfaceName = "${superInterfaces}";
        if (this.configuration.getInterfaceType() == 0) {
            templateid = "org.eclipse.edt.ide.ui.templates.interface";
        }
        if (this.configuration.getChosenTemplateSelection() == 1) {
            interfaceOutputString = TemplateEngine.getCustomizedTemplateString(templateName, templateid);
        } else if (this.configuration.getChosenTemplateSelection() == 0) {
            interfaceOutputString = TemplateEngine.getDefaultTemplateString(templateName, templateid);
        }
        if (interfaceOutputString.compareTo("") != 0) {
            String newVariableValue = this.configuration.getInterfaceName();
            int variableBegin = interfaceOutputString.indexOf(templateVariableInterfaceName);
            if (variableBegin == -1) {
                throw new PartTemplateException(templateName, templateid, EGLFileConfiguration.TEMPLATE_CORRUPTED);
            }
            String firstHalfOutputString = interfaceOutputString.substring(0, variableBegin);
            String secondHalfOutputString = interfaceOutputString.substring(variableBegin + templateVariableInterfaceName.length(), interfaceOutputString.length());
            interfaceOutputString = String.valueOf(firstHalfOutputString) + newVariableValue + secondHalfOutputString;
            if (this.configuration.getInterfaceType() == 1) {
                String myInterfacePkgName = this.configuration.getFPackage();
                if (this.interfaces != null && this.interfaces.size() > 0) {
                    StringBuffer superInterfacesVarValue = new StringBuffer();
                    Iterator it = this.interfaces.iterator();
                    while (it.hasNext()) {
                        String interfaceFQName = (String)it.next();
                        IPart interfaceobj = this.configuration.getInterface(interfaceFQName);
                        if (interfaceobj == null || !(interfaceobj instanceof IPart)) continue;
                        IPart interfacepart = interfaceobj;
                        if (!myInterfacePkgName.equalsIgnoreCase(interfacepart.getPackageFragment().getElementName())) {
                            importString.append("import");
                            importString.append(" ");
                            importString.append(interfaceFQName);
                            importString.append(";");
                            importString.append(newLine);
                        }
                        superInterfacesVarValue.append(interfacepart.getElementName());
                        if (it.hasNext()) {
                            superInterfacesVarValue.append(", ");
                            continue;
                        }
                        superInterfacesVarValue.append(" ");
                    }
                    int varBegin = interfaceOutputString.indexOf(templateVariableSuperInterfaceName);
                    if (varBegin == -1) {
                        throw new PartTemplateException(templateName, templateid, EGLFileConfiguration.TEMPLATE_CORRUPTED);
                    }
                    String leftHalf = interfaceOutputString.substring(0, varBegin);
                    String rightHalf = interfaceOutputString.substring(varBegin + templateVariableSuperInterfaceName.length(), interfaceOutputString.length());
                    interfaceOutputString = String.valueOf(importString.toString()) + leftHalf + superInterfacesVarValue.toString() + rightHalf;
                }
            }
            interfaceOutputString = this.RemoveRemainingTemplateTags(interfaceOutputString, firstHalfOutputString, secondHalfOutputString);
            return interfaceOutputString;
        }
        throw new PartTemplateException(templateName, templateid, EGLFileConfiguration.TEMPLATE_NOT_FOUND);
    }
}

