/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.project.features.operations.EGLFeatureOperationsUtilities;
import org.eclipse.edt.ide.ui.wizards.AddProjectDependencyOperation;
import org.eclipse.edt.ide.ui.wizards.IWidgetLibraryImporter;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.edt.ide.ui.wizards.ProjectConfigurationOperation;
import org.eclipse.edt.ide.ui.wizards.ProjectCreationOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ProjectFinishUtility {
    public static final String EXTENSIONPOINT_WIDGET_LIBRARY_PROVIDER = "org.eclipse.edt.ide.ui.widgetLibraryProvider";
    public static final String PROVIDER = "provider";
    public static final String PROVIDER_IMPORT_CLASS = "importClass";
    public static final String PROVIDER_LIBRARY_NAME = "libname";
    public static final String PROVIDER_PROJECT_NAME = "projectName";
    public static final String PROVIDER_RESOURCE_PLUGIN_NAME = "resourcePluginName";
    public static final String PROVIDER_RESOURCE_FOLDER = "resourceFolder";
    public static final String PROVIDER_SELECTED = "selected";

    public static List<WorkspaceModifyOperation> getCreateProjectFinishOperations(ProjectConfiguration eglProjConfiguration, int eglFeatureMask, ISchedulingRule rule) {
        ArrayList<WorkspaceModifyOperation> listOps = new ArrayList<WorkspaceModifyOperation>();
        ArrayList<AddProjectDependencyOperation> dependencyOps = new ArrayList<AddProjectDependencyOperation>();
        IConfigurationElement[] widgetLibraryContributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONPOINT_WIDGET_LIBRARY_PROVIDER);
        if (widgetLibraryContributions != null) {
            IConfigurationElement[] iConfigurationElementArray = widgetLibraryContributions;
            int n = widgetLibraryContributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement currContribution = iConfigurationElementArray[n2];
                String libName = currContribution.getAttribute(PROVIDER_LIBRARY_NAME);
                String projectName = currContribution.getAttribute(PROVIDER_PROJECT_NAME);
                String resourcePluginName = currContribution.getAttribute(PROVIDER_RESOURCE_PLUGIN_NAME);
                String resourceFolder = currContribution.getAttribute(PROVIDER_RESOURCE_FOLDER);
                if (eglProjConfiguration.getSelectedWidgetLibraries().contains(libName)) {
                    try {
                        Object o = currContribution.createExecutableExtension(PROVIDER_IMPORT_CLASS);
                        if (o instanceof IWidgetLibraryImporter) {
                            IWidgetLibraryImporter widgetLibraryImporter = (IWidgetLibraryImporter)o;
                            listOps.add(widgetLibraryImporter.getImportRUIProjectsOperation(rule, resourcePluginName, resourceFolder, projectName));
                            dependencyOps.add(widgetLibraryImporter.getAddProjectDependencyOperation(eglProjConfiguration, rule, projectName));
                        }
                    }
                    catch (CoreException ce) {
                        EDTUIPlugin.log(ce);
                    }
                }
                ++n2;
            }
        }
        ProjectCreationOperation creationOperation = new ProjectCreationOperation(eglProjConfiguration, rule);
        listOps.add(creationOperation);
        ProjectConfigurationOperation configureOperation = new ProjectConfigurationOperation(eglProjConfiguration, rule);
        listOps.add(configureOperation);
        listOps.addAll(dependencyOps);
        EGLFeatureOperationsUtilities.getEGLFeatureOperations(eglProjConfiguration.getProjectName(), listOps, rule, 0, eglFeatureMask, false, false);
        return listOps;
    }

    public static URL getWidgetProjectURL(String resourcePluginName, String libraryResourceFolder, String projectName) throws IOException {
        URL url = FileLocator.resolve((URL)Platform.getBundle((String)resourcePluginName).getEntry(String.valueOf(libraryResourceFolder) + projectName + ".zip"));
        return url;
    }
}

