/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MemoryObjectStore;
import org.eclipse.edt.mof.serialization.MofLookupDelegate;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.ProxyEObject;
import org.eclipse.edt.mof.serialization.SerializationException;

public abstract class AbstractEnvironment
implements IEnvironment {
    private Map<Object, EObject> objectCache;
    protected Map<String, List<ObjectStore>> objectStores;
    private Map<String, IEnvironment.LookupDelegate> lookupDelegates;
    private Map<String, ObjectStore> defaultSerializeStores;

    public AbstractEnvironment() {
        this.reset();
    }

    public void reset() {
        this.objectCache = new HashMap<Object, EObject>();
        this.objectStores = new HashMap<String, List<ObjectStore>>();
        this.lookupDelegates = new HashMap<String, IEnvironment.LookupDelegate>();
        this.defaultSerializeStores = new HashMap<String, ObjectStore>();
        MemoryObjectStore mofStore = new MemoryObjectStore(this);
        this.setDefaultSerializeStore("mof", mofStore);
        this.registerLookupDelegate("mof", new MofLookupDelegate());
        this.registerLookupDelegate("dynMof", new MofLookupDelegate());
        this.registerObjectStore("mof", mofStore);
    }

    @Override
    public void registerObjectStore(String scheme, ObjectStore objectStore) {
        List<ObjectStore> stores = this.objectStores.get(scheme);
        if (stores == null) {
            stores = new ArrayList<ObjectStore>();
            this.objectStores.put(scheme, stores);
        }
        if (stores.contains(objectStore)) {
            return;
        }
        IEnvironment.LookupDelegate delegate = this.lookupDelegates.get(scheme);
        objectStore.setProxyClass(delegate.getProxyClass());
        stores.add(objectStore);
    }

    @Override
    public long lastModified(String key) {
        String scheme = this.getKeySchemeFromKey(key);
        List<ObjectStore> stores = this.objectStores.get(scheme);
        if (stores != null) {
            for (ObjectStore store : stores) {
                if (!store.containsKey(key)) continue;
                return store.lastModified(key);
            }
        }
        return -1L;
    }

    @Override
    public void registerLookupDelegate(String scheme, IEnvironment.LookupDelegate delegate) {
        this.lookupDelegates.put(scheme, delegate);
    }

    @Override
    public ObjectStore getDefaultSerializeStore(String keyScheme) {
        return this.defaultSerializeStores.get(keyScheme);
    }

    @Override
    public void setDefaultSerializeStore(String keyScheme, ObjectStore store) {
        this.defaultSerializeStores.put(keyScheme, store);
    }

    @Override
    public EObject get(String key) {
        return this.objectCache.get(key);
    }

    @Override
    public EObject find(String key) throws MofObjectNotFoundException, DeserializationException {
        return this.find(key, false);
    }

    @Override
    public EObject find(String key, boolean useProxies) throws MofObjectNotFoundException, DeserializationException {
        IEnvironment.LookupDelegate delegate = this.getDelegateForKey(key);
        EObject object = this.objectCache.get(key = delegate.normalizeKey(key));
        if (object == null && (object = delegate.find(key, useProxies, this)) == null) {
            if (useProxies) {
                try {
                    Class<? extends ProxyEObject> proxyClass = delegate.getProxyClass();
                    Constructor<? extends ProxyEObject> constructor = proxyClass.getConstructor(String.class);
                    object = constructor.newInstance(key);
                    this.objectCache.put(key, object);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                throw new MofObjectNotFoundException("MofObject not found: " + key);
            }
        }
        return object;
    }

    @Override
    public EObject lookup(String key) throws DeserializationException {
        String scheme;
        List<ObjectStore> stores;
        EObject object = this.objectCache.get(key);
        if (object == null && (stores = this.objectStores.get(scheme = this.getKeySchemeFromKey(key))) != null) {
            for (ObjectStore store : stores) {
                object = store.get(key);
                if (object != null) break;
            }
        }
        return object;
    }

    @Override
    public void save(MofSerializable object) throws SerializationException {
        String key = object.getMofSerializationKey();
        ObjectStore defaultStore = this.getDefaultSerializeStore(this.getKeySchemeFromKey(key));
        if (defaultStore == null) {
            throw new SerializationException("No default serialization ObjectStore set for keyScheme:" + this.getKeySchemeFromKey(key));
        }
        this.save(key, (EObject)object, defaultStore);
    }

    @Override
    public void save(MofSerializable object, boolean serialize) throws SerializationException {
        if (serialize) {
            this.save(object);
        } else {
            this.save(object.getMofSerializationKey(), (EObject)object, null);
        }
    }

    @Override
    public void save(String key, EObject object) throws SerializationException {
        ObjectStore defaultStore = this.getDefaultSerializeStore(this.getKeySchemeFromKey(key));
        if (defaultStore == null) {
            throw new SerializationException("No default serialization ObjectStore set for keyScheme:" + this.getKeySchemeFromKey(key));
        }
        this.save(key, object, defaultStore);
    }

    @Override
    public void save(String key, EObject object, boolean serialize) throws SerializationException {
        if (serialize) {
            this.save(key, object);
        } else {
            this.save(key, object, null);
        }
    }

    @Override
    public void remove(String key) {
        IEnvironment.LookupDelegate delegate = this.getDelegateForKey(key);
        String storeKey = delegate.normalizeKey(key);
        this.objectCache.remove(storeKey);
    }

    @Override
    public IEnvironment.LookupDelegate getLookupDelegateForKey(String key) {
        return this.getDelegateForKey(key);
    }

    protected void save(String key, EObject object, ObjectStore store) throws SerializationException {
        IEnvironment.LookupDelegate delegate = this.getDelegateForKey(key);
        String storeKey = delegate.normalizeKey(key);
        this.objectCache.put(storeKey, object);
        if (store != null) {
            store.put(storeKey, object);
        }
    }

    protected IEnvironment.LookupDelegate getDelegateForKey(String key) {
        String scheme = this.getKeySchemeFromKey(key);
        return this.lookupDelegates.get(scheme);
    }

    protected String getKeySchemeFromKey(String key) {
        int i = key.indexOf(":");
        if (i == -1) {
            return "mof";
        }
        int j = key.indexOf(60);
        return j != -1 && i > j ? "mof" : key.substring(0, i);
    }

    @Override
    public Map<String, List<ObjectStore>> getObjectStores() {
        return this.objectStores;
    }

    @Override
    public Map<String, IEnvironment.LookupDelegate> getLookupDelegates() {
        return this.lookupDelegates;
    }
}

