/*******************************************************************************
 * Copyright © 2008, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
/* Generated By:JavaCC: Do not edit this line. JsonParser.java */
package org.eclipse.edt.javart.json;

public class JsonParser implements JsonParserConstants {

  public static void main(String args[]) throws ParseException {
    JsonParser parser = new JsonParser(System.in);
    parser.ObjectParse();
  }

  public static ObjectNode parse(String parseString) throws ParseException {
        java.io.StringReader reader = new java.io.StringReader(parseString);
        JsonParser parser = new JsonParser(reader);
        return parser.ObjectParse();
  }

  public static ObjectNode parse(java.io.InputStream stream) throws ParseException {
        JsonParser parser = new JsonParser(stream);
        return parser.ObjectParse();
  }

  final public ObjectNode ObjectParse() throws ParseException {
        ObjectNode node;
    node = Object();
          {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public ObjectNode Object() throws ParseException {
        ObjectNode obj = new ObjectNode();
        NameValuePairNode pair;
    jj_consume_token(10);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      pair = Pair();
          obj.addPair(pair);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 11:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        jj_consume_token(11);
        pair = Pair();
        obj.addPair(pair);
      }
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    jj_consume_token(12);
      {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public NameValuePairNode Pair() throws ParseException {
        StringNode string;
        ValueNode value;
    string = String();
    jj_consume_token(13);
    value = Value();
      {if (true) return new NameValuePairNode(string, value);}
    throw new Error("Missing return statement in function");
  }

  final public StringNode String() throws ParseException {
        Token t;
    t = jj_consume_token(STRING);
          String str = t.image;
          {if (true) return new StringNode(str.substring(1, str.length() - 1), true);}
    throw new Error("Missing return statement in function");
  }

  final public ValueNode Value() throws ParseException {
        Token t;
        ValueNode value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      value = String();
          {if (true) return value;}
      break;
    case NUMBER:
      t = jj_consume_token(NUMBER);
          String str = t.image;
          if (str.indexOf("e") > 0 || str.indexOf("E") > 0) {
                {if (true) return new FloatingPointNode(str);}
          }
          if (str.indexOf(".") > 0) {
                {if (true) return new DecimalNode(str);}
          }
          {if (true) return new IntegerNode(str);}
      break;
    case 10:
      value = Object();
          {if (true) return value;}
      break;
    case 14:
      jj_consume_token(14);
      value = Array();
      jj_consume_token(15);
          {if (true) return value;}
      break;
    case TRUE:
      t = jj_consume_token(TRUE);
          {if (true) return BooleanNode.TRUE;}
      break;
    case FALSE:
      t = jj_consume_token(FALSE);
          {if (true) return BooleanNode.FALSE;}
      break;
    case NULL:
      t = jj_consume_token(NULL);
          {if (true) return NullNode.NULL;}
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ArrayNode Array() throws ParseException {
        ArrayNode array = new ArrayNode();
        ValueNode value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
    case STRING:
    case TRUE:
    case FALSE:
    case NULL:
    case 10:
    case 14:
      value = Value();
          array.addValue(value);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 11:
          ;
          break;
        default:
          jj_la1[3] = jj_gen;
          break label_2;
        }
        jj_consume_token(11);
        value = Value();
        array.addValue(value);
      }
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
      {if (true) return array;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public JsonParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[5];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x800,0x40,0x47e0,0x800,0x47e0,};
   }

  /** Constructor with InputStream. */
  public JsonParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public JsonParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new JsonParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public JsonParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new JsonParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public JsonParser(JsonParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(JsonParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List jj_expentries = new java.util.ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[16];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 5; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 16; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
