/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.javart.messages;

/**
 * Message defines constants for message IDs.  Each ID is an 8-character String
 * of the form EGLnnnnx, where the n's are the digits of the message number and
 * the x is E, I, or W (for Error, Information, or Warning).
 */
public class Message
{
	public static final String PROGRAM_ERROR_INFO = "EGL0001I";
	public static final String FUNCTION_ERROR_INFO = "EGL0002I";
	public static final String FILE_ERROR_INFO = "EGL0003I";
	public static final String PROPERTIES_FILE_MISSING = "EGL0004E";
	public static final String LOAD_LIBRARY_FAILED = "EGL0005E";
	public static final String CREATE_OBJECT_FAILED = "EGL0006E";
	public static final String INITIAL_CONTEXT_ERROR = "EGL0007E";
	public static final String LISTENER_ERROR = "EGL0008E";
	public static final String REQUIRED_PROPERTY_MISSING = "EGL0009E";
	public static final String EXTERNAL_DEPENDENCY_MISSING = "EGL0010E";
	public static final String UNSUPPORTED_COMPARE = "EGL0048E";	
	public static final String ASSIGNMENT_OVERFLOW = "EGL0049E";
	public static final String EXPRESSION_OVERFLOW = "EGL0050E";
	public static final String UNSUPPORTED_OPERANDS = "EGL0051E";
	public static final String UNSUPPORTED_OPERAND = "EGL0052E";
	public static final String UNSUPPORTED_SUBSCRIPT_OPERAND = "EGL0053E";
	public static final String UNSUPPORTED_SUBSTRING_OPERAND = "EGL0054E";
	public static final String UNSUPPORTED_SET_EMPTY_OPERAND = "EGL0055E";
	public static final String INVALID_REGULAR_EXPRESSION = "EGL0056E";
	public static final String CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED = "EGL0057E";
	public static final String INVALID_CTGPORT = "EGL0058E";
	public static final String CTG_CONNECT_FAILED = "EGL0059E";
	public static final String CTG_DISCONNECT_FAILED = "EGL0060E";
	public static final String NO_CICS = "EGL0061E";
	public static final String CICS_DIED = "EGL0062E";
	public static final String CICS_TIMEOUT = "EGL0063E";
	public static final String CICS_TRANSACTION_ABEND = "EGL0064E";
	public static final String CICS_UNKNOWN_SERVER = "EGL0065E";
	public static final String CICS_SECURITY_ERROR = "EGL0066E";
	public static final String CICS_MAX_SYSTEMS = "EGL0067E";
	public static final String CICS_NONZERO_RETURN_CODE = "EGL0068E";
	public static final String CICS_COMMIT_FAILED = "EGL0069E";
	public static final String CICS_ROLLBACK_FAILED = "EGL0070E";
	public static final String CICS_ECI_FLOW_FAILED = "EGL0071E";
	public static final String SERVICE_PARAMETER_ERROR = "EGL0072E";
	public static final String RECURSIVE_CALL_NOT_ALLOWED = "EGL0074E";
	public static final String ARRAY_MAXSIZE_EXCEEDED = "EGL0075E";
	public static final String WRONG_NUMBER_OF_PARMS = "EGL0076E";
	public static final String FUNCTION_NOT_FOUND = "EGL0077E";
	public static final String SHARED_LIBRARY_NOT_FOUND = "EGL0078E";
	public static final String CALL_NONZERO_RETURN_CODE = "EGL0079E";
	public static final String REMOTE_PROGRAM_ERROR = "EGL0080E";
	public static final String UNKNOWN_TCPIP_HOSTNAME = "EGL0081E";
	public static final String SERVERID_IS_INVALID_PORT = "EGL0082E";
	public static final String TCPIP_SERVER_ERROR = "EGL0083E";
	public static final String INVALID_REMOTECOMTYPE = "EGL0084E";
	public static final String CANNOT_OPEN_LINKAGE_FILE = "EGL0085E";
	public static final String NAME_NOT_FOUND_IN_LINKAGE = "EGL0086E";
	public static final String AS400_UNKNOWN_HOST = "EGL0087E";
	public static final String AS400_PASSWORD_OR_USER_INVALID = "EGL0088E";
	public static final String AS400_EXCEPTION_CAUGHT = "EGL0089E";
	public static final String AS400_NO_AUTHORITY = "EGL0090E";
	public static final String REMOTE_COMMIT_FAILED = "EGL0091E";
	public static final String REMOTE_ROLLBACK_FAILED = "EGL0092E";
	public static final String AS400_CONNECTION_ERROR = "EGL0093E";
	public static final String AS400_SERVER_NOT_FOUND = "EGL0094E";
	public static final String AS400_APPLICATION_ERROR = "EGL0095E";
	public static final String NULL_REFERENCE_VARIABLE = "EGL0098E";
	public static final String CAUGHT_JAVA_EXCEPTION = "EGL0099E";
	public static final String UNHANDLED_EXCEPTION = "EGL0100E";
	public static final String DATA_FORMAT_ERROR = "EGL0101E";
	public static final String CONVERSION_ERROR = "EGL0102E";
	public static final String INVALID_DATE_FORMAT_PATTERN = "EGL0103E";
	public static final String INVALID_TIME_FORMAT_PATTERN = "EGL0104E";
	public static final String INVALID_TIMESTAMP_FORMAT_PATTERN = "EGL0105E";
	public static final String NULL_REFERENCE = "EGL0106E";
	public static final String DYNAMIC_ACCESS_NOT_SUPPORTED = "EGL0107E";
	public static final String DYNAMIC_ACCESS_FAILED = "EGL0108E";
	public static final String INVALID_NUMERIC_FORMAT_PATTERN = "EGL0109E";
	public static final String EXCEPTION_IN_LOB_ASSIGNMENT = "EGL0110E";
	public static final String EXCEPTION_IN_LOB_SET_EMPTY = "EGL0111E";
	public static final String EXCEPTION_IN_DELEGATE_INVOKE = "EGL0112E";
	public static final String RUN_COMMAND_FAILED = "EGL0113E";	
	public static final String MDY_ERROR = "EGL0114E";
	public static final String NON_NUMERIC_STRING = "EGL0115E";
	public static final String SYSTEM_FUNCTION_ERROR = "EGL0117E";
	public static final String INT_AS_CHAR_ERROR = "EGL0118E";
	public static final String INVALID_LOB_LENGTH = "EGL0119E";
	public static final String INVALID_LOB_POSITION = "EGL0120E";
	public static final String LOB_ERROR = "EGL0121E";
	public static final String START_TRANSACTION_ERROR = "EGL0122E";
	public static final String INT_AS_UNICODE_ERROR = "EGL0123E";
	public static final String EXCEPTION_CALLING_CICS = "EGL0124E";
	public static final String CALLING_CICS_UNSUCCESSFUL = "EGL0125E";
	public static final String INVALID_ARRAY_SIZE = "EGL0140E";
	public static final String ARRAY_INDEX_OUT_OF_BOUNDS = "EGL0141E";
	public static final String INVALID_SUBSTRING_INDEX = "EGL0142E";
	public static final String INVALID_ARRAY_FUNCTION_ARGUMENT = "EGL0143E";
	public static final String INDEX_OUT_OF_BOUNDS = "EGL0144E";
	public static final String UNSUPPORTED_CONVERSION_TABLE = "EGL0145E";
	public static final String CANNOT_READ_CSOUIDPWD_FILE = "EGL0146E";
	public static final String CALL_PARMS_TOO_LARGE = "EGL0147E";	
	public static final String INVALID_PARMFORM = "EGL0148E";	
	public static final String PARM_PASSING_ERROR = "EGL0149E";	
	public static final String CALL_ERROR = "EGL0150E";
	public static final String ERROR_GETTING_CONNECTION_FACTORY = "EGL0151E";
	public static final String ERROR_CLOSING_INTERACTION_OR_CONNECTION = "EGL0152E";
	public static final String ERROR_GETTING_CONNECTION = "EGL0153E";
	public static final String ERROR_GETTING_INTERACTION = "EGL0154E";
	public static final String ERROR_SETTING_INTERACTION_VERB = "EGL0155E";
	public static final String EXCEPTION_CALLING_IMS = "EGL0156E";
	public static final String CALLING_IMS_UNSUCCESSFUL = "EGL0157E";
	public static final String ERROR_GETTING_LOCAL_TRANSACTION = "EGL0160E";
	public static final String ERROR_SETTING_TIMEOUT = "EGL0161E";
	public static final String NO_DEBUG_LISTENER = "EGL0162E";
	public static final String DEBUG_LISTENER_PROBLEM = "EGL0163E";
	public static final String NOT_DEBUG_MODE = "EGL0164E";
	public static final String LIBRARY_NOT_SPECIFIED = "EGL0165E";
	public static final String REMOTE_PROGRAM_ERROR2 = "EGL0166E";
	public static final String UNSUPPORTED_SRVPGM_PARAM_TYPE = "EGL0167E";
	public static final String UNSUPPORTED_SRVPGM_RETURN_TYPE = "EGL0168E";

	public static final String MATH_DOMAIN_ERROR = "EGL0180E";
	public static final String MATH_ACOS_ASIN_DOMAIN_ERROR = "EGL0181E";
	public static final String MATH_FLQUO_FLMOD_DOMAIN_ERROR = "EGL0183E";
	public static final String MATH_LOG_LOG10_DOMAIN_ERROR = "EGL0184E";
	public static final String MATH_POW_1_DOMAIN_ERR = "EGL0185E";
	public static final String MATH_POW_2_DOMAIN_ERR = "EGL0186E";
	public static final String MATH_SQRT_DOMAIN_ERROR = "EGL0187E";
	public static final String MATH_RANGE_ERROR = "EGL0188E";

	public static final String STRING_INDEX_ERROR = "EGL0200E";
	public static final String STRING_LENGTH_ERROR = "EGL0201E";
	public static final String STRING_NULT_ERROR = "EGL0202E";
	public static final String STRING_DOUBLE_BYTE_INDEX_ERROR = "EGL0203E";
	public static final String STRING_DOUBLE_BYTE_LENGTH_ERROR = "EGL0204E";
	
	/* Message table errors */
	public static final String MSG_TBL_MSG_MISSING_ERR					= "EGL0330E";
	public static final String MSG_TBL_LOAD_ERR							= "EGL0331E";
	public static final String MSG_TBL_AS_BUNDLE_LOAD_ERR				= "EGL0332E";
	
	public static final String FILETYPE_MISSING = "EGL0751E";
	public static final String FILETYPE_INVALID = "EGL0752E";
 	public static final String INVALID_RECORD_LENGTH = "EGL0754E";
 	public static final String RECORD_LENGTH_TOO_LARGE = "EGL0755E";
 	public static final String IO_ERROR = "EGL0756E";
	
	public static final String SQL_PREPARED_STATEMENT_NOT_FOUND = "EGL0500E";
	public static final String SQL_RESULT_SET_NOT_FOUND = "EGL0501E";
	public static final String SQL_ERROR = "EGL0502E";
	public static final String SQL_NO_RECORD_FOUND = "EGL0503E";
	public static final String SQL_EXCEPTION_CAUGHT = "EGL0504E";
	public static final String SQL_CONNECTION_FAILED = "EGL0505E";
	public static final String SQL_NO_JDBC_DRIVER = "EGL0506E";
	public static final String SQL_JDBC_DRIVER_LOAD_ERROR = "EGL0507E";
	public static final String SQL_RESULT_SET_NOT_SCROLLABLE = "EGL0508E";
	public static final String SQL_NO_DEFAULT_DATABASE = "EGL0509E";
	public static final String SQL_NO_DATABASE_CONNECTION = "EGL0510E";
	public static final String SQL_DISCONNECT_ERROR = "EGL0511E";
	public static final String SQL_CONNECTION_SET_ERROR = "EGL0512E";
	public static final String SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR = "EGL0513E";
	public static final String SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR = "EGL0514E";
	public static final String SQL_HOST_VAR_NOT_NULLABLE = "EGL0515E";
	
	public static final String EDIT_INPUT_REQUIRED_ERR					= "EGL0700E";
	public static final String EDIT_INVALID_NUMERIC_DATA_ERR			= "EGL0702E";
	public static final String EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR		= "EGL0703E";
	public static final String EDIT_NUMERIC_RANGE_ERR					= "EGL0704E";
	public static final String EDIT_MINIMUM_INPUT_ERR					= "EGL0705E";
	public static final String EDIT_TABLE_VALIDATION_ERR				= "EGL0706E";
	public static final String EDIT_MODULUS_VALIDATION_ERR				= "EGL0707E";
	public static final String EDIT_INVALID_DATE_TIME_ERR				= "EGL0708E";
	public static final String EDIT_BOOLEAN_CHECK_ERR					= "EGL0710E";
	public static final String EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR		= "EGL0711E";
	public static final String EDIT_INVALID_HEXIDECIMAL_DATA_ERR 		= "EGL0712E";
	public static final String EDIT_INVALID_PATTERN_ERR				    = "EGL0713E";
	public static final String EDIT_MAXIMUM_INPUT_ERR					= "EGL0714E";
	public static final String EDIT_TEXT_RANGE_ERR						= "EGL0715E";
	public static final String EDIT_VALID_VALUES_ERR					= "EGL0716E";
	public static final String EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR		= "EGL0717E";
	public static final String EDIT_VALIDATION_ERR						= "EGL0718E";
	public static final String EDIT_INPUT_ERR							= "EGL0719E";
	public static final String EDIT_OUTPUT_FORMATTING_ERR				= "EGL0720E";
	public static final String EDIT_SOSI_INPUT_LENGTH_ERR				= "EGL0721E";
	
	public static final String ACTION_REQUEST_ERROR						= "EGL0730E";
	public static final String ACTION_SESSION_ERROR						= "EGL0731E";
	public static final String ACTION_APPLICATION_ERROR					= "EGL0732E";
	public static final String ACTION_NO_J2EE_ERROR						= "EGL0733E";
	
	public static final String PORTALLIB_SESSION_ERROR                  = "EGL0760E";
	public static final String PORTALLIB_MODE_ERROR                     = "EGL0761E";
	public static final String PORTALLIB_WINDOWSTATE_ERROR              = "EGL0762E";
	public static final String PORTALLIB_RENDERREQUEST_MODE_ERROR       = "EGL0763E";
	public static final String PORTALLIB_RENDERREQUEST_STATE_ERROR      = "EGL0764E";
	public static final String PORTALLIB_PORTLETSESSION_ERROR           = "EGL0765E";
	public static final String PORTALLIB_INVALIDKEY                     = "EGL0766E";
	public static final String PORTALLIB_PORTLETREQUEST_ERROR           = "EGL0767E";
	public static final String PORTALLIB_PREFERENCE_RESET_ERROR         = "EGL0768E";
	public static final String PORTALLIB_PREFERENCE_STORE_ERROR         = "EGL0769E";
	public static final String PORTALLIB_PREFERENCE_SET_ERROR           = "EGL0770E";
	public static final String PORTALLIB_PREFERENCE_GET_ERROR           = "EGL0771E";
	public static final String PORTALLIB_CREDENTIAL_VAULT_ERROR         = "EGL0772E";
	public static final String PORTALLIB_CREDENTIAL_ACCESS_ERROR        = "EGL0773E";
	public static final String PORTALLIB_CREDENTIAL_CREATE_ERROR        = "EGL0774E";
	public static final String PORTALLIB_CREDENTIAL_DELETE_ERROR        = "EGL0775E";
	public static final String PORTALLIB_CREDENTIAL_SET_ERROR           = "EGL0776E";
	
	public static final String JAVALIB_CAUGHT_EXCEPTION = "EGL1000E";
	public static final String JAVALIB_NULL_ID = "EGL1001E";
	public static final String JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS = "EGL1002E";
	public static final String JAVALIB_ARG_TYPE_MISMATCH = "EGL1003E";
	public static final String JAVALIB_NULL_RETURNED = "EGL1004E";
	public static final String JAVALIB_NO_CLASS_FOR_NULL_ARG = "EGL1006E";
	public static final String JAVALIB_ACCESS_ERROR = "EGL1007E";
	public static final String JAVALIB_INSTANTIATION_ERROR = "EGL1008E";
	public static final String JAVALIB_NOT_STATIC = "EGL1009E";
	
	public static final String CUI_E_ACTION_FIELD_DOES_NOT_EXIST = "EGL1148E";
	public static final String CUI_E_ARRAY_FULL = "EGL1149E";
	public static final String CUI_E_ARRAY_NOT_FOUND = "EGL1150E";
	public static final String CUI_E_ASSIGN_RESULT = "EGL1151E";
	public static final String CUI_E_BAD_ARRAY_SIZE = "EGL1152E";
	public static final String CUI_E_BAD_BOX_PARAMS = "EGL1153E";
	public static final String CUI_E_BAD_COORDINATES = "EGL1154E";
	public static final String CUI_E_BAD_KEYNAME = "EGL1155E";
	public static final String CUI_E_BAD_PICTURE_EDIT = "EGL1156E";
	public static final String CUI_E_BAD_WINDOW_NAME = "EGL1157E";
	public static final String CUI_E_BAD_WINDOW_POS_SIZE = "EGL1158E";
	public static final String CUI_E_CMDSTACK_SYNC = "EGL1159E";
	public static final String CUI_E_CONSOLELLIB_NOT_INITIALIZED = "EGL1160E";
	public static final String CUI_E_CONSTRUCT_ILL_TYPE = "EGL1161E";
	public static final String CUI_E_CONSTRUCT_WITH_VARLIST = "EGL1162E";
	public static final String CUI_E_DISABLE_INVISIBLE = "EGL1163E";
	public static final String CUI_E_EDIT_FAILED = "EGL1164E";
	public static final String CUI_E_EXEC_HOTKEY = "EGL1165E";
	public static final String CUI_E_EXIT_NO_CMD = "EGL1166E";
	public static final String CUI_E_EXIT_NO_CONTINUE = "EGL1167E";
	public static final String CUI_E_FATALERROR = "EGL1168E";
	public static final String CUI_E_FIELD_DOES_NOT_EXIST = "EGL1169E";
	public static final String CUI_E_FIELD_NOT_ARRAY = "EGL1170E";
	public static final String CUI_E_FIELD_NOT_FOUND = "EGL1171E";
	public static final String CUI_E_FIELD_NO_WINDOW = "EGL1172E";
	public static final String CUI_E_FIELD_COUNT = "EGL1173E";
	public static final String CUI_E_FORM_DOES_NOT_EXIST = "EGL1174E";
	public static final String CUI_E_FORM_DOES_NOT_FIT = "EGL1175E";
	public static final String CUI_E_FORM_FLDLIST_MISMATCH = "EGL1176E";
	public static final String CUI_E_FORM_IN_USE = "EGL1177E";
	public static final String CUI_E_FORM_NAME_USED = "EGL1178E";
	public static final String CUI_E_FORM_NOT_OPEN = "EGL1179E";
	public static final String CUI_E_FORM_NO_WINDOW = "EGL1180E";
	public static final String CUI_E_GETCHAR_VIRTUAL = "EGL1181E";
	public static final String CUI_E_GETCOOKED_VIRTUAL = "EGL1182E";
	public static final String CUI_E_INTERNAL = "EGL1187E";
	public static final String CUI_E_INTR_RECEIVED = "EGL1188E";
	public static final String CUI_E_INVIS_NO_MNEMONIC = "EGL1189E";
	public static final String CUI_E_LABEL_NO_WINDOW = "EGL1190E";
	public static final String CUI_E_MENU_DOES_NOT_FIT = "EGL1191E";
	public static final String CUI_E_MISSING_ITEM = "EGL1192E";
	public static final String CUI_E_MNEMONIC_CONFLICT = "EGL1193E";
	public static final String CUI_E_NO_ACTIVE_FORM = "EGL1194E";
	public static final String CUI_E_NO_EDITOR = "EGL1198E";
	public static final String CUI_E_NO_HELP_FILE = "EGL1200E";
	public static final String CUI_E_NO_HELP_MSG = "EGL1201E";
	public static final String CUI_E_NO_NUMPAGES = "EGL1202E";
	public static final String CUI_E_NO_SCREENARRAY = "EGL1203E";
	public static final String CUI_E_NO_VISIBLE_ITEMS = "EGL1204E";
	public static final String CUI_E_NULL_WNDOW_NAME = "EGL1205E";
	public static final String CUI_E_OPEN_NULL_WINDOW = "EGL1206E";
	public static final String CUI_E_PROMPT_EXCEPTION = "EGL1207E";
	public static final String CUI_E_QUIT_RECEIVED = "EGL1208E";
	public static final String CUI_E_SCROLL_FAILED = "EGL1211E";
	public static final String CUI_E_UNKNOWN_ATTRIBUTE = "EGL1212E";
	public static final String CUI_E_VALIDATE_FIELD = "EGL1213E";
	public static final String CUI_E_VAR_LIST_SHORT = "EGL1214E";
	public static final String CUI_E_WINDOW_NAME_USED = "EGL1215E";
	public static final String CUI_E_WINDOW_TOO_SMALL = "EGL1216E";
	public static final String CUI_E_MISSING_BINDING = "EGL1217E";
	public static final String CUI_E_SCREENARRAY_INVALID_CONTENTS = "EGL1218E";
	public static final String CUI_E_SCREENARRAY_SEGMENTED_FIELD = "EGL1219E";
	public static final String CUI_E_SCREENARRAY_INCOMPATIBLE = "EGL1220E";
	public static final String CUI_E_FIELD_NAME_DUP = "EGL1221E";
	public static final String CUI_E_FIELD_LENGTH_INVALID = "EGL1222E";
	public static final String CUI_E_LABEL_NOT_FIT = "EGL1223E";
	public static final String CUI_E_FIELD_NOT_FIT = "EGL1224E";
	public static final String CUI_E_PROMPT_TOO_LONG = "EGL1225E";
	public static final String CUI_E_OPENUI_ARRAY_ARGS_INVALID = "EGL1226E";
	public static final String CUI_E_OPENUI_FIELD_ARGS_INVALID = "EGL1227E";
	public static final String CUI_E_PROMPT_SINGLE_VAR = "EGL1228E";
	public static final String CUI_E_OPENUI_MISSING_BINDING = "EGL1229E";
	public static final String CUI_E_VALID_VALUES = "EGL1230E";
	public static final String CUI_W_NO_MORE_FIELDS = "EGL1100W";
	public static final String CUI_W_NO_MORE_ROWS = "EGL1101W";
	public static final String CUI_E_LOADING_MESSAGE = "EGL1420E";
	public static final String CUI_W_CLOB_DATA_HAS_NULLS = "EGL1243W";
	public static final String CUI_I_STR_WINDOWTITLE = "EGL1244I";
	public static final String CUI_E_MISSING_FORMAT = "EGL1245E";
	public static final String CUI_E_VERIFY_FIELD_MISMATCH = "EGL1246E";
	public static final String CUI_I_STR_VERIFY_INPUT = "EGL1247I";
	public static final String CUI_I_STR_HELP = "EGL1251I";
	public static final String CUI_I_STR_RESUME = "EGL1252I";
	public static final String CUI_I_STR_RESUME_COMMENT = "EGL1253I";
	public static final String CUI_I_STR_SCROLL = "EGL1254I";
	public static final String CUI_I_STR_LAST_PAGE = "EGL1255I";
	public static final String CUI_I_STR_SCROLL_COMMENT = "EGL1256I";
	public static final String CUI_I_STR_SELECT = "EGL1257I";
	public static final String CUI_E_INSERT_FIRST_ARRAY_ROW = "EGL1259E";
	public static final String CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED = "EGL1260E";
	public static final String CUI_E_UNIMP_FN_KEYS = "EGL1261E";
	public static final String CUI_E_STR_MULTIPLE_CANVAS = "EGL1262E";
	public static final String CUI_E_STR_CANVAS_NOT_INITIALIZED = "EGL1263E";
	public static final String CUI_E_STR_CANVAS_TOO_SMALL = "EGL1264E";
	public static final String CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED = "EGL1265E";
	public static final String CUI_W_MINIMUM_INPUT_REQUIRED = "EGL1267W";
	public static final String CUI_W_MAXIMUM_INPUT_EXCEEDED = "EGL1268W";
	public static final String CUI_E_AUTOMATION_OPENING_SCRIPT_FILE = "EGL1269E";
	public static final String CUI_E_AUTOMATION_READING_SCRIPT_FILE = "EGL1270E";
	public static final String CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR = "EGL1271E";
	public static final String CUI_W_AUTOMATION_BAD_CLICK_SYNTAX = "EGL1272W";
	public static final String CUI_E_AUTOMATION_GETTING_PROPERTY = "EGL1273E";
	public static final String CUI_E_AUTOMATION_INVALID_PANIC_KEY = "EGL1274E";
	public static final String CUI_E_AUTOMATION_EXECUTING_CLICK = "EGL1275E";
	public static final String CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE = "EGL1276E";
	public static final String CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST = "EGL1277E";
	public static final String CUI_E_AUTOMATION_CREATING_SCENARIODIR = "EGL1278E";
	public static final String CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY = "EGL1279W";
	public static final String CUI_I_AUTOMATION_COMPARE_OK = "EGL1280I";
	public static final String CUI_E_RCP_DISPLAYLINEMODE = "EGL1281E";

	public static final String TUI_E_FIELD_OUTSIDE_FORM = "EGL1401E";
	public static final String TUI_E_FIELD_OVERLAP = "EGL1402E";
	public static final String TUI_E_NO_FORMGROUP = "EGL1403E";
	public static final String TUI_E_FLOATING_FORM_DOES_NOT_FIT = "EGL1404E";
	public static final String TUI_E_BAD_FIELD_COORDS = "EGL1405E";
	public static final String TUI_E_NO_PRINTASSOCIATION = "EGL1406E";
	public static final String TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE = "EGL1407E";
	public static final String TUI_E_PRINTER_NOT_FOUND = "EGL1408E";
	public static final String TUI_E_NO_DISPLAY = "EGL1409E";
	public static final String TUI_E_NO_SUITABLE_DEVICE_SIZE = "EGL1410E";
	public static final String TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST = "EGL1411E";
	public static final String TUI_E_UNKNOWN_ATTRIBUTE = "EGL1412E";
	public static final String TUI_E_INVALID_VALID_VALUE = "EGL1413E";
	public static final String TUI_E_CANT_CREATE_HELP_FORM = "EGL1414E";
	public static final String TUI_E_INTERNAL = "EGL1415E";
	public static final String TUI_E_NO_PRINTERS = "EGL1416E";
	public static final String TUI_E_NO_DEFAULT_PRINTER = "EGL1417E";
	public static final String TUI_E_LOADING_MESSAGE = "EGL1418E";
	public static final String TUI_E_WRONG_INPUT_FORM_ERR = "EGL1419E";	
	public static final String TUI_CONTENT_CONVERSION_ERR = "EGL0125E";
	public static final String TUI_E_PRINTJOB_PRINTER_NOT_FOUND = "EGL1450E";
	public static final String TUI_I_PRINTPREVIEW_STR_NEXT = "EGL1451I";
	public static final String TUI_I_PRINTPREVIEW_STR_PAGE = "EGL1452I";
	public static final String TUI_I_PRINTPREVIEW_STR_PREV = "EGL1453I";
	public static final String TUI_I_PRINTPREVIEW_STR_PRINT = "EGL1454I";
	public static final String TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW = "EGL1455I";
	public static final String TUI_I_PRINTPREVIEW_STR_SAVE = "EGL1456I";
	public static final String TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB = "EGL1457I";
	public static final String TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE = "EGL1458I";
	public static final String TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER = "EGL1459I";
	public static final String TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO = "EGL1460I";
	public static final String TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD = "EGL1461I";
	public static final String TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM = "EGL1462I";
	public static final String TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR = "EGL1463I";
	public static final String TUI_E_INVALID_CURSOR_POSITION = "EGL1464E";
	
	public static final String LOG_E_UTILITY_CREATING_LOGWRITER = "EGL1471E";
	public static final String LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE = "EGL1472W";
	public static final String LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST = "EGL1473E";
	public static final String LOG_E_UTILITY_LOGDIR_NOT_WRITABLE = "EGL1474E";
	public static final String LOG_E_UTILITY_CREATING_LOGFILE = "EGL1475E";
	public static final String LOG_E_UTILITY_LOGFILE_NOT_WRITABLE = "EGL1476E";
	
	public static final String SOA_E_LOAD_SERVICE = "EGL1600E";
	public static final String SOA_E_WS_CREATE_CALL_OBJECT = "EGL1601E";
	public static final String SOA_E_WS_MALFORMED_URL = "EGL1602E";
	public static final String SOA_E_LOAD_LOCAL_SERVICE = "EGL1603E";
	public static final String SOA_E_LOAD_WEB_PROXY = "EGL1604E";
	public static final String SOA_E_MISSING_REQUIRED_PROPERTY = "EGL1605E";
	public static final String SOA_E_MISSING_REFERENCE_TARGET = "EGL1606E";
	public static final String SOA_E_MISSING_BINDING = "EGL1607E";
	public static final String SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER = "EGL1608E";
	public static final String SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL = "EGL1609E";
	public static final String SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA = "EGL1610E";
	public static final String SOA_E_WS_FIXED_RECORD_INITIALIZATION = "EGL1611E";
	public static final String SOA_E_WS_INVALID_CALENDAR_VALUE = "EGL1612E";
	public static final String SOA_E_WS_INVALID_BOOLEAN_VALUE = "EGL1613E";
	public static final String SOA_E_WS_INVALID_BYTE_VALUE = "EGL1614E";
	public static final String SOA_E_WS_INVALID_SHORT_VALUE = "EGL1615E";
	public static final String SOA_E_WS_INVALID_URI_VALUE = "EGL1616E";
	public static final String SOA_E_WS_UNSUPPORTED_EGL_TYPE = "EGL1617E";
	public static final String SOA_E_WS_CONTAINER_ARRAY_FAILED = "EGL1618E";
	public static final String SOA_E_METHOD_NOT_FOUND = "EGL1619E";
	public static final String SOA_E_NOT_WEB_SERVICE = "EGL1620E";
	public static final String SOA_E_WEB_SERVICE_INVOCATION = "EGL1621E";
	public static final String SOA_E_EGL_SERVICE_INVOCATION = "EGL1622E";
	public static final String SOA_E_EGL_TCPIP_SERVICE_INVOCATION = "EGL1623E";
	public static final String SOA_E_WS_TYPE_MAPPING_REGISTER = "EGL1624E";
	public static final String SOA_E_NOT_TCPIP_SERVICE = "EGL1625E";
	public static final String SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION = "EGL1626E";
	public static final String SOA_E_SERVICE_BINDING_ERROR = "EGL1627E";
	public static final String SOA_E_CICS_SERVICE_INVOCATION = "EGL1628E";
	public static final String SOA_E_NOT_CICS_SERVICE = "EGL1629E";
	public static final String SOA_E_WS_GET_OPERATION = "EGL1630E";
	public static final String SOA_E_ISERIES_SERVICE_INVOCATION = "EGL1631E";
	public static final String SOA_E_REMOTE_SERVICE_ERROR = "EGL1632E";
	public static final String SOA_E_AS400_APPLICATION_ERROR = "EGL1633E";
	public static final String SOA_E_AS400_EXCEPTION_CAUGHT = "EGL1634E";
	public static final String SOA_E_REMOTE_SERVICE_ERROR2 = "EGL1635E";
	public static final String SOA_E_WEBSPHERE_BINDING_ERROR = "EGL1636E";
	public static final String SOA_E_USER_ID_NOT_SET = "EGL1537E";
	public static final String SOA_E_WS_PROXY_UNIDENTIFIED = "EGL1538E";
	public static final String SOA_E_WS_PROXY_COMMUNICATION = "EGL1539E";
	public static final String SOA_E_WS_PROXY_REST = "EGL1540E";
	public static final String SOA_E_WS_PROXY_SOAP = "EGL1541E";
	public static final String SOA_E_WS_PROXY_PARMETERS_JSON2EGL = "EGL1542E";
	public static final String SOA_E_WS_PROXY_PARMETERS_EGL2JSON = "EGL1544E";
	public static final String SOA_E_WS_REST_NO_SERVICE = "EGL1543E";
	public static final String SOA_E_WS_REST_NO_RESPONSE = "EGL1545E";
	public static final String SOA_E_WS_REST_BAD_CONTENT = "EGL1546E";
	public static final String SOA_E_WS_PROXY_SERVICE_TIMEOUT = "EGL1547E";
	public static final String SOA_E_NOT_REST_SERVICE = "EGL1548E";
	public static final String SOA_E_REST_SERVICE = "EGL1549E";
	public static final String SOA_E_REST_DATA_CONVERSION = "EGL1550E";
	public static final String SOA_E_REST_UNSUPPORTED = "EGL1551E";
	public static final String SOA_E_WS_PROXY_PARMETERS_XML_MISSING = "EGL1552E";
	public static final String SOA_E_WS_PROXY_PARMETERS_XML2EGL = "EGL1553E";
	public static final String SOA_E_WS_PROXY_PARMETERS_EGL2XML = "EGL1554E";
	public static final String SOA_E_WS_PROXY_XML_PARSE_EXCEPTION = "EGL1555E";
	public static final String SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION = "EGL1556E";
	public static final String SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION = "EGL1557E";
	public static final String SOA_E_WS_PROXY_INVALID_URL_EXCEPTION = "EGL1558E";
	public static final String SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION = "EGL1559E";
	public static final String SOA_E_WS_GATEWAY_EXCEPTION = "EGL1560E";
	public static final String SOA_E_JSON_CONVERSION_EXCEPTION = "EGL1561E";
	public static final String SOA_E_JSON_TYPE_EXCEPTION = "EGL1562E";
	public static final String SOA_E_NOT_JAXWS_WEB_SERVICE = "EGL1563E";
	public static final String SOA_E_JAXWS_SOAP_HEADER_EXCEPTION = "EGL1564E";
	public static final String SOA_E_WS_PROXY_XML_PARSE_ELEMENT_EXCEPTION = "EGL1565E";
	public static final String SOA_E_WS_PROXY_UNSUPPORTED_OPERATION = "EGL1566E";
	public static final String SOA_E_WS_PROXY_NO_J2EE_OPERATION = "EGL1567E";
	
	public static final String REPORT_E_FILL_WITH_CONNECTION_ERROR = "EGL1700E";
	public static final String REPORT_E_FILL_WITH_SQL_ERROR = "EGL1702E";
	public static final String REPORT_E_FILL_WITH_DATA_ERROR = "EGL1703E";
	public static final String REPORT_E_FILL_ERROR = "EGL1704E";
	public static final String REPORT_E_EXPORT_ERROR = "EGL1705E";
	public static final String REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR = "EGL1706E";
	public static final String REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR = "EGL1707E";
	public static final String REPORT_E_ADD_REPORT_PARAMETER_ERROR = "EGL1708E";
	public static final String REPORT_E_RESET_REPORT_PARAMETER_ERROR = "EGL1709E";
	public static final String REPORT_E_FIELD_NAME_ERROR = "EGL1710E";
	public static final String REPORT_E_SUBREPORT_NAME_ERROR = "EGL1711E";
	public static final String REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR = "EGL1712E";
	public static final String REPORT_E_COMPLEX_TYPE_ERROR = "EGL1713E";
	
	public static final String BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR = "EGL1721E";
	public static final String BIRT_TABLE_ROW_NOT_FOUND_ERROR = "EGL1722E";
	public static final String BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR = "EGL1723E";
	public static final String BIRT_HANDLER_TYPE_ERROR = "EGL1724E";
	public static final String BIRT_EGL_TO_JAVA_CONVERSION_ERROR = "EGL1725E";
	public static final String BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR = "EGL1726E";
	public static final String BIRT_CREATE_DOCUMENT_ERROR = "EGL1727E";
	public static final String BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR = "EGL1728E";
	public static final String BIRT_CREATE_REPORT_FROM_DESIGN_ERROR = "EGL1729E";
	public static final String BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR = "EGL1730E";
	public static final String BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR = "EGL1731E";
	public static final String BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR = "EGL1732E";
	public static final String BIRT_ELEMENT_NOT_FOUND_ERROR = "EGL1733E";
	public static final String BIRT_GROUP_NOT_FOUND_ERROR = "EGL1734E";
	public static final String BIRT_GROUP_ROW_NOT_FOUND_ERROR = "EGL1735E";
	public static final String BIRT_TABLE_COLUMN_NOT_FOUND_ERROR = "EGL1736E";
	public static final String BIRT_GROUP_COLUMN_NOT_FOUND_ERROR = "EGL1737E";
	public static final String BIRT_JAVA_TO_EGL_CONVERSION_ERROR = "EGL1738E";
	public static final String BIRT_DATA_SET_NOT_FOUND_ERROR = "EGL1739E";
	public static final String BIRT_SCRIPTED_DATA_SET_ERROR = "EGL1740E";
	public static final String BIRT_DATA_SOURCE_NOT_FOUND_ERROR = "EGL1741E";
	public static final String BIRT_SCRIPTED_DATA_SOURCE_ERROR = "EGL1742E";
	public static final String BIRT_DATA_SET_COLUMN_NUMBER_ERROR = "EGL1743E";
	public static final String BIRT_DATA_SET_ROW_GET_COLUMN_ERROR = "EGL1744E";
	public static final String BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR = "EGL1745E";
	public static final String BIRT_GET_BINDING_ERROR = "EGL1746E";
	public static final String BIRT_GRID_ROW_NOT_FOUND_ERROR = "EGL1747E";
	public static final String BIRT_GRID_COLUMN_NOT_FOUND_ERROR = "EGL1748E";
	
	public static final String CINTERFACE_E_NATIVELIB_ERROR="EGL1800E";
	public static final String CINTERFACE_E_NATIVELIBLOAD_ERROR="EGL1801E";
	public static final String CINTERFACE_E_PARAMCOUNT_ERROR="EGL1802E";
	public static final String CINTERFACE_E_MEMORY_ALLOCATION_ERROR="EGL1803E";
	public static final String CINTERFACE_E_CONVERSION_ERROR="EGL1804E";
	public static final String CINTERFACE_E_INVALID_PRECISION_ERROR = "EGL1805E";
	public static final String CINTERFACE_E_CHAR_TOO_SHORT="EGL1806E";
	public static final String CINTERFACE_E_FUNCTION_NOT_FOUND="EGL1807E";
	public static final String CINTERFACE_E_IMPROPER_LOC = "EGL1808E";
	public static final String CINTERFACE_E_CONVERSION_TO_VALUE = "EGL1809E";
	public static final String CINTERFACE_E_CONVERSION_TO_ANY = "EGL1809E";
	public static final String CINTERFACE_E_POP_ERROR = "EGL1810E";
	public static final String CINTERFACE_E_PUSH_ERROR = "EGL1820E";
	public static final String CINTERFACE_E_PUSH_POP_ERROR = "EGL1830E";
	public static final String CINTERFACE_E_POP_LOCATOR_ERROR = "EGL1831E";
	public static final String CINTERFACE_E_STACK_EMPTY_ERROR = "EGL1832E";
	public static final String CINTERFACE_E_LOC_COPY_ERROR = "EGL1833E";
	public static final String CINTERFACE_E_NULL_REF_ERROR = "EGL1834E";
	public static final String CINTERFACE_E_PUSH_ANY_ERROR = "EGL1835E";
	public static final String CINTERFACE_E_ASSIGN_ANY_ERROR = "EGL1836E";
	
	// Messages 1901 and 1902 are not referenced by the runtime, but we do
	// need them.  They are referenced by generated code.
	public static final String DELEGATE_E_RETURN_TYPE_MISMATCH = "EGL1901E";
	public static final String DELEGATE_E_PARAM_TYPE_MISMATCH = "EGL1902E";
	
	public static final String DEBUG_SOURCE_NOT_FOUND = "EGL2001E";
	public static final String DEBUG_WEBTRANS_SOURCE_NOT_FOUND = "EGL2002E";
	public static final String DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE = "EGL2003W";
	public static final String DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE = "EGL2004W";
	public static final String DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE = "EGL2005W";
	public static final String DEBUG_UIPROGRAM_SOURCE_NOT_FOUND = "EGL2006E";
	
	public static final String WEBTRANS_E_PROGRAM_NOT_WEBTRANS = "EGL2101E";
	public static final String WEBTRANS_E_WRONG_FIRST_UI = "EGL2150E";
	public static final String WEBTRANS_E_INVALID_BOOLEAN_INPUT = "EGL2151E";
	public static final String WEBTRANS_E_INACTIVITY_TIMEOUT = "EGL2153E";
	public static final String WEBTRANS_E_UI_TOO_LARGE = "EGL2154E";
	public static final String WEBTRANS_E_UI_VERIFY_FAILED = "EGL2155E";
	
	public static final String IMS_HOST_ABORT = "EGL2100E";
	public static final String IMS_HOST_TCPIP_ERROR = "EGL2101E";  
	public static final String IMS_HOST_REMOTE_INITIALIZATION_ERROR = "EGL2102E";
	public static final String IMS_HOST_PACKET_ERROR = "EGL2103E";
	public static final String IMS_HOST_STORED_PROCEDURE_IOEXCEPTION = "EGL2104E";
	public static final String IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION = "EGL2105E";
	public static final String IMS_HOST_FINALIZE_ERROR = "EGL2106E";
	public static final String IMS_HOST_DLI_ERROR = "EGL2107E";
	public static final String IMS_HOST_DLI_PCB_ERROR = "EGL2108E";
	public static final String IMS_HOST_TCPIP_EXCEPTION = "EGL2109E";
	public static final String IMS_HOST_ABEND_EXCEPTION = "EGL2110E"; 
	public static final String IMS_HOST_OTHER_EXCEPTION = "EGL2111E";
	public static final String IMS_HOST_UNSUPPORTED_OPERATION = "EGL2112E";
	public static final String IMS_HOST_DLI_NO_IMSID_EXCEPTION = "EGL2113E";
	public static final String IMS_HOST_CATCHER_EXCEPTION = "EGL2114E";
	public static final String IMS_EMPTY_PSBNAME_EXCEPTION = "EGL2115E";
	public static final String IMS_CATCHER_CONVERSION_EXCEPTION = "EGL2116E";
	public static final String IMS_HOST_VERSION_EXCEPTION = "EGL2117E";
	public static final String IMS_HOST_BAD_PCB_EXCEPTION = "EGL2118E";
	public static final String IMS_HOST_DLI_ERROR_EXTD = "EGL2119E";
	
	public static final String WRAPPER_ARRAY_EXPAND_BEYOND_MAX = "EGL2202E";
	public static final String WRAPPER_ARRAY_INVALID_INDEX = "EGL2203E";
	public static final String WRAPPER_ARRAY_INVALID_MAX_SIZE = "EGL2204E";
	public static final String WRAPPER_ARRAY_INVALID_OBJECT_TYPE = "EGL2205E";
	
	public static final String UIPGM_GATEWAY_INFO_BOUND = "EGL2300I";
	public static final String UIPGM_GATEWAY_INFO_UNBOUND = "EGL2301I";
	public static final String UIPGM_SESSIONID_PREFIX_TOO_LONG = "EGL2302E";
	public static final String UIPGM_NO_PROGRAM_NAME = "EGL2303E";

}
