/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_cs extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "Do\u0161lo k chyb\u011b v {0}." },
		{ Message.FUNCTION_ERROR_INFO, "Do\u0161lo k chyb\u011b ve {0} zpracov\u00e1n\u00ed funkce {1}." },
		{ Message.FILE_ERROR_INFO, "Do\u0161lo k chyb\u011b ve {0} zpracov\u00e1n\u00ed funkce {1} na \u0159\u00e1dku {2}." },
		{ Message.PROPERTIES_FILE_MISSING, "Soubor vlastnost\u00ed {0} nebyl na\u010dten." },
		{ Message.LOAD_LIBRARY_FAILED, "Knihovnu {0} nelze na\u010d\u00edst. Vyskytla se n\u00e1sleduj\u00edc\u00ed chyba: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "Vyskytla se chyba b\u011bhem vytv\u00e1\u0159en\u00ed objektu typu {0}. Vyskytla se n\u00e1sleduj\u00edc\u00ed chyba: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "Vyskytla se chyba b\u011bhem vytv\u00e1\u0159en\u00ed po\u010d\u00e1te\u010dn\u00edho kontextu (InitialContext) nebo vyhled\u00e1v\u00e1n\u00ed prost\u0159ed\u00ed java:comp/env. Vyskytla se n\u00e1sleduj\u00edc\u00ed chyba: {0}" },
		{ Message.LISTENER_ERROR, "Vyskytla se n\u00e1sleduj\u00edc\u00ed v\u00fdjimka a zpr\u00e1va. V\u00fdjimka: {0} Zpr\u00e1va: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "Je po\u017eadov\u00e1na hodnota pro vlastnost {0}." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "Chyb\u00ed extern\u00ed z\u00e1vislost. Vyskytla se n\u00e1sleduj\u00edc\u00ed v\u00fdjimka. V\u00fdjimka: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "Operandy {0} a {1} nelze porovnat." },
		{ Message.ASSIGNMENT_OVERFLOW, "Do\u0161lo k chyb\u011b p\u0159ete\u010den\u00ed p\u0159i p\u0159i\u0159azen\u00ed hodnoty {0} do {1}." },
		{ Message.EXPRESSION_OVERFLOW, "Do\u0161lo k chyb\u011b p\u0159ete\u010den\u00ed p\u0159i v\u00fdpo\u010dtu n\u00e1sleduj\u00edc\u00edho v\u00fdrazu: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "Oper\u00e1tor {0} nen\u00ed podporov\u00e1n pro operandy {1} a {2}." },
		{ Message.UNSUPPORTED_OPERAND, "Oper\u00e1tor {0} nen\u00ed podporov\u00e1n pro operand {1} typu {2}." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "Oper\u00e1tor na doln\u00edch indexech nen\u00ed podporov\u00e1n pro operand {0} typu {1}." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "Oper\u00e1tor na pod\u0159et\u011bzc\u00edch nen\u00ed podporov\u00e1n pro operand {0} typu {1}." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "P\u0159\u00edkaz SET EMPTY nen\u00ed podporov\u00e1n pro operand {0} typu {1}." },
		{ Message.INVALID_REGULAR_EXPRESSION, "Vyskytla se chyba v b\u011b\u017en\u00e9m v\u00fdrazu {0}. Chyba: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "Kdy\u017e pou\u017e\u00edv\u00e1te protokol CICSSSL, mus\u00ed b\u00fdt zadan\u00e9 ctgKeyStore i ctgKeyStorePassword." },
		{ Message.INVALID_CTGPORT, "Hodnota {0} pro zad\u00e1n\u00ed ctgport nen\u00ed spr\u00e1vn\u00e1." },
		{ Message.CTG_CONNECT_FAILED, "Vyskytla se chyba b\u011bhem p\u0159ipojov\u00e1n\u00ed k CTG. Um\u00edst\u011bn\u00ed CTG je {0}. Port CTG je {1}. Vyskytla se n\u00e1sleduj\u00edc\u00ed chyba: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "Vyskytla se chyba b\u011bhem odpojov\u00e1n\u00ed od CTG. Um\u00edst\u011bn\u00ed CTG je {0}. Port CTG je {1}. Vyskytla se n\u00e1sleduj\u00edc\u00ed chyba: {2}" },
		{ Message.NO_CICS, "Vyskytla se chyba b\u011bhem vol\u00e1n\u00ed programu {0}, kter\u00fd pou\u017e\u00edv\u00e1 CICS ECI. N\u00e1vratov\u00fd k\u00f3d je -3 (ECI_ERR_NO_CICS). Syst\u00e9mov\u00fd identifik\u00e1tor CICS je {1}." },
		{ Message.CICS_DIED, "Vyskytla se chyba b\u011bhem vol\u00e1n\u00ed programu {0}, kter\u00fd pou\u017e\u00edv\u00e1 CICS ECI. N\u00e1vratov\u00fd k\u00f3d je -4 (ECI_ERR_CICS_DIED). Syst\u00e9mov\u00fd identifik\u00e1tor CICS je {1}." },
		{ Message.CICS_TIMEOUT, "Vyskytla se chyba b\u011bhem vol\u00e1n\u00ed programu {0}, kter\u00fd pou\u017e\u00edv\u00e1 CICS ECI. N\u00e1vratov\u00fd k\u00f3d je -6 (ECI_ERR_RESPONSE_TIMEOUT). Syst\u00e9mov\u00fd identifik\u00e1tor CICS je {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "Vyskytla se chyba b\u011bhem vol\u00e1n\u00ed programu {0}, kter\u00fd pou\u017e\u00edv\u00e1 CICS ECI. N\u00e1vratov\u00fd k\u00f3d je  -7 (ECI_ERR_TRANSACTION_ABEND). Syst\u00e9mov\u00fd identifik\u00e1tor CICS je {1}. K\u00f3d nestandardn\u00edho ukon\u010den\u00ed je {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "Vyskytla se chyba b\u011bhem vol\u00e1n\u00ed programu {0}, kter\u00fd pou\u017e\u00edv\u00e1 CICS ECI. N\u00e1vratov\u00fd k\u00f3d je -22 (ECI_ERR_UNKNOWN_SERVER). Syst\u00e9mov\u00fd identifik\u00e1tor CICS je {1}." },
		{ Message.CICS_SECURITY_ERROR, "Vyskytla se chyba b\u011bhem vol\u00e1n\u00ed programu {0}, kter\u00fd pou\u017e\u00edv\u00e1 CICS ECI. N\u00e1vratov\u00fd k\u00f3d je -27 (ECI_ERR_SECURITY_ERROR). Syst\u00e9mov\u00fd identifik\u00e1tor CICS je {1}." },
		{ Message.CICS_MAX_SYSTEMS, "Vyskytla se chyba b\u011bhem vol\u00e1n\u00ed programu {0}, kter\u00fd pou\u017e\u00edv\u00e1 CICS ECI. N\u00e1vratov\u00fd k\u00f3d je -28 (ECI_ERR_MAX_SYSTEMS). Syst\u00e9mov\u00fd identifik\u00e1tor CICS je {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "Vyskytla se chyba b\u011bhem vol\u00e1n\u00ed programu {0} syst\u00e9mu {1} pro u\u017eivatele {2}. Z vol\u00e1n\u00ed CICS ECI byly vr\u00e1ceny n\u00e1vratov\u00fd k\u00f3d {3} a k\u00f3d nestandardn\u00edho ukon\u010den\u00ed {4}." },
		{ Message.CICS_COMMIT_FAILED, "B\u011bhem vol\u00e1n\u00ed CICS ECI se vyskytla chyba p\u0159i potvrzen\u00ed jednotky \u010dinnosti. N\u00e1vratov\u00fd k\u00f3d CICS je {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "B\u011bhem vol\u00e1n\u00ed CICS ECI se vyskytla chyba p\u0159i n\u00e1vratu jednotky \u010dinnosti do p\u0159edchoz\u00edho stavu. N\u00e1vratov\u00fd k\u00f3d CICS je {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "Do\u0161lo k v\u00fdjimce na toku po\u017eadavku ECI na syst\u00e9m CICS {0}. V\u00fdjimka: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "Chyba v d\u00e9lce parametru. Tok m\u00e1 {0} parametr\u016f a lok\u00e1ln\u00ed funkce jich m\u00e1 {1}." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "U pole {0} byla p\u0159ekro\u010dena maxim\u00e1ln\u00ed velikost." },
		{ Message.WRONG_NUMBER_OF_PARMS, "Volan\u00fd program {0} o\u010dek\u00e1val {1} parametr\u016f, ale obdr\u017eel jich {2}." },
		{ Message.FUNCTION_NOT_FOUND, "Vyskytla se chyba b\u011bhem z\u00edsk\u00e1v\u00e1n\u00ed adresy vstupn\u00edho bodu {0} v r\u00e1mci sd\u00edlen\u00e9 knihovny {1}. N\u00e1vratov\u00fd k\u00f3d je {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "Vyskytla se chyba b\u011bhem na\u010d\u00edt\u00e1n\u00ed sd\u00edlen\u00e9 knihovny {0}. N\u00e1vratov\u00fd k\u00f3d je {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "Do\u0161lo k selh\u00e1n\u00ed volan\u00e9ho programu, n\u00e1vratov\u00fd k\u00f3d je {0}." },
		{ Message.REMOTE_PROGRAM_ERROR, "Vyskytla se chyba ve vzd\u00e1len\u00e9m programu {0} na syst\u00e9mu {3}. Do\u0161lo k chyb\u011b na {1} v {2}. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "Vyskytla se chyba ve vzd\u00e1len\u00e9m programu {0} na syst\u00e9mu {1}. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "N\u00e1zev hostitele {0} je nezn\u00e1m\u00fd TCP/IP n\u00e1zev hostitele." },
		{ Message.SERVERID_IS_INVALID_PORT, "ID serveru {0} nen\u00ed platn\u00e9 \u010d\u00edslo portu." },
		{ Message.TCPIP_SERVER_ERROR, "Klient obdr\u017eel upozorn\u011bn\u00ed, \u017ee server nen\u00ed schopen spustit vzd\u00e1len\u00fd volan\u00fd program. K\u00f3d p\u0159\u00ed\u010diny: {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "Hodnota remoteComType chyb\u00ed nebo je neplatn\u00e1." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "Soubor vlastnost\u00ed propojen\u00ed {0} nelze otev\u0159\u00edt." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "V souboru vlastnost\u00ed propojen\u00ed {1} nelze naj\u00edt vstup odpov\u00eddaj\u00edc\u00ed volan\u00e9mu programu {0}." },
		{ Message.AS400_UNKNOWN_HOST, "Hostitele {0} nelze naj\u00edt nebo je nezn\u00e1m\u00fd." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "Heslo nebo ID u\u017eivatele je nespr\u00e1vn\u00e9 pro p\u0159ipojen\u00ed do syst\u00e9mu {0}. Chyba: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "Do\u0161lo k {0} AS400Toolbox prov\u00e1d\u011bc\u00ed chyb\u011b p\u0159i vol\u00e1n\u00ed programu {2} v syst\u00e9mu {3}. Chyba: {1}" },
		{ Message.AS400_NO_AUTHORITY, "Do\u0161lo k chyb\u011b vzd\u00e1len\u00e9ho p\u0159\u00edstupu zabezpe\u010den\u00ed na syst\u00e9mu {0} pro u\u017eivatele {1}. Chyba: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "Funkce potvrzen\u00ed se na syst\u00e9mu {0} nezda\u0159ila. Chyba: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "Funkce n\u00e1vratu do p\u0159edchoz\u00edho stavu se na syst\u00e9mu {0} nezda\u0159ila. Chyba: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "Do\u0161lo k chyb\u011b p\u0159i p\u0159\u00edstupu vzd\u00e1len\u00e9ho p\u0159ipojen\u00ed k syst\u00e9mu {0}. Chyba: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "Vyskytla se chyba slu\u017eeb OS/400 hostitele EGL. Po\u017eadovan\u00e9 soubory nebyly na syst\u00e9mu {0} nalezeny." },
		{ Message.AS400_APPLICATION_ERROR, "Spu\u0161t\u011bn\u00e1 jednotka byla zastavena, proto\u017ee se vyskytla aplika\u010dn\u00ed chyba na syst\u00e9mu {0} p\u0159i pokusu zavolat program{1}. Zpr\u00e1va: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "Referen\u010dn\u00ed prom\u011bnn\u00e1 s n\u00e1zvem {0} je null." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "Do\u0161lo k neo\u0161et\u0159en\u00e9 chyb\u011b. Chyba: {0}." },
		{ Message.DATA_FORMAT_ERROR, "Hodnota prom\u011bnn\u00e9 {0} nen\u00ed ve spr\u00e1vn\u00e9m form\u00e1tu." },
		{ Message.CONVERSION_ERROR, "Hodnotu {0} typu {1} nelze p\u0159ev\u00e9st na typ {2}." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "Vzor form\u00e1tu data {0} je neplatn\u00fd." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "Vzor form\u00e1tu \u010dasu {0} je neplatn\u00fd." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "Vzor form\u00e1tu \u010dasov\u00e9ho ozna\u010den\u00ed {0} je neplatn\u00fd." },
		{ Message.NULL_REFERENCE, "Byl pou\u017eit nulov\u00fd odkaz." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "Dynamick\u00fd p\u0159\u00edstup nen\u00ed pro {0} podporov\u00e1n." },
		{ Message.DYNAMIC_ACCESS_FAILED, "V {1} nelze naj\u00edt pole s identifik\u00e1torem {0}." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "Vzor numerick\u00e9ho form\u00e1tu {0} je neplatn\u00fd." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "Vyskytla se chyba b\u011bhem p\u0159i\u0159azen\u00ed {0} k {1}. Chyba: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "Chyba v p\u0159\u00edkazu SET {0} EMPTY. Chyba: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "Do\u0161lo k chyb\u011b {0} p\u0159i vyvol\u00e1n\u00ed metody s podpisem {1}." },
		{ Message.RUN_COMMAND_FAILED, "Chyba spu\u0161t\u011bn\u00ed p\u0159\u00edkazu {0}. Chyba: {1}." },
		{ Message.MDY_ERROR, "Funkce DateTimeLib.mdy nem\u016f\u017ee p\u0159ev\u00e9st hodnoty {0}, {1}, a {2} na m\u011bs\u00edc, den a rok." },
		{ Message.NON_NUMERIC_STRING, "{0} byl p\u0159ed\u00e1n nenumerick\u00fd \u0159et\u011bzec {1}. V\u0161echny znaky v \u010d\u00e1sti \u0159et\u011bzce definovan\u00e9 d\u00e9lkou argumentu mus\u00ed b\u00fdt mus\u00ed b\u00fdt \u010d\u00edseln\u00e9." },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} se nezda\u0159ilo; v\u00fdsledn\u00e1 chybov\u00e1 zpr\u00e1va je {1}." },
		{ Message.INT_AS_CHAR_ERROR, "Argument funkce StrLib.intAsChar mus\u00ed b\u00fdt \u010d\u00edslo mezi 0 a 255." },
		{ Message.INVALID_LOB_LENGTH, "{0} nen\u00ed platn\u00e1 d\u00e9lka pro {1}, kter\u00fd m\u00e1 velikost {2}." },
		{ Message.INVALID_LOB_POSITION, "{0} nen\u00ed platn\u00e1 poloha pro {1}. M\u00e1 velikost {2}." },
		{ Message.LOB_ERROR, "Vyskytla se chyba b\u011bhem zpracov\u00e1v\u00e1n\u00ed polo\u017eky Blob nebo Clob. Chybov\u00e1 zpr\u00e1va je {0}" },
		{ Message.START_TRANSACTION_ERROR, "Metoda VGLib.startTransaction na t\u0159\u00edd\u011b {0} se nezda\u0159ila. V\u00fdjimka je {1}" },
		{ Message.INT_AS_UNICODE_ERROR, "Argument funkce StrLib.intAsUnicode mus\u00ed b\u00fdt \u010d\u00edslo mezi 0 a 65535." },
		{ Message.INVALID_ARRAY_SIZE, "Rozm\u011br hodnoty {0} je neplatn\u00fd pro pole {1}. Maxim\u00e1ln\u00ed velikost je {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "Index {0} je mimo rozsah pole {1}. Velikost pole je {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "Neplatn\u00e9 indexy pod\u0159et\u011bzc\u016f {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "Argument k funkci pole {0} je neplatn\u00fd." },
		{ Message.INDEX_OUT_OF_BOUNDS, "Hodnota indexu {0} je mimo rozsah." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} je nepodporovan\u00e1 p\u0159evodn\u00ed tabulka." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "Soubor csouidpwd.properties nelze p\u0159e\u010d\u00edst. Chyba: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "Vyrovn\u00e1vac\u00ed pam\u011b\u0165 klienta je p\u0159\u00edli\u0161 mal\u00e1 pro objem dat p\u0159ed\u00e1van\u00fdch vol\u00e1n\u00edm. Kumulativn\u00ed velikost proch\u00e1zen\u00fdch parametr\u016f je {0} bajt\u016f a p\u0159ekra\u010duje maxim\u00e1ln\u00ed povolenou, kter\u00e1 je {1} bajt\u016f." },
		{ Message.INVALID_PARMFORM, "Vlastnost propojen\u00ed parmForm mus\u00ed b\u00fdt nastavena na COMMPTR, aby volala program {0}, pon\u011bvad\u017e alespo\u0148 jeden parametr je dynamick\u00e9 pole." },
		{ Message.PARM_PASSING_ERROR, "Vyskytla se chyba b\u011bhem proch\u00e1zen\u00ed parametr\u016f k volan\u00e9mu programu {0}. Chyba: {1}" },
		{ Message.CALL_ERROR, "Vyskytla se chyba p\u0159i vol\u00e1n\u00ed programu {0}. Chyba: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} je nepodporovan\u00fd typ parametru pro servisn\u00ed programy syst\u00e9mu System i." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} je nepodporovan\u00fd n\u00e1vratov\u00fd typ pro servisn\u00ed programy syst\u00e9mu System i." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "Nelze z\u00edskat prost\u0159edek zaji\u0161\u0165uj\u00edc\u00ed p\u0159ipojen\u00ed (ConnectionFactory). V\u00fdjimka je {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "Interakci nebo p\u0159ipojen\u00ed nelze zav\u0159\u00edt. Chyba: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "P\u0159ipojen\u00ed nelze zav\u00e9st. Chyba: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "Nelze z\u00edskat interakci. V\u00fdjimka je: {0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "Nelze nastavit interak\u010dn\u00ed sloveso. V\u00fdjimka je {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "Nelze z\u00edskat lok\u00e1ln\u00ed transkaci pro jednotku pr\u00e1ce klienta. V\u00fdjimka je {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "Nelze nastavit hodnotu prodlevy vol\u00e1n\u00ed CICSJ2C. V\u00fdjimka je {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "Vyskytla se chyba p\u0159i pokusu o komunikaci s CICS. V\u00fdjimka je {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "Pokus o proveden\u00ed vzd\u00e1len\u00e9 transakce CICS se nezda\u0159il." },
		{ Message.EXCEPTION_CALLING_IMS, "B\u011bhem pokusu komunikovat s IMS se vyskytla chyba. V\u00fdjimka je {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "B\u011bhem pokusu komunikovat s IMS se vyskytla chyba." },
		{ Message.MATH_DOMAIN_ERROR, "{0} se nezda\u0159ilo; k\u00f3d chyby je 8 (chyba dom\u00e9ny). Argument k funkci nen\u00ed platn\u00fd." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} se nezda\u0159ilo; k\u00f3d chyby je 8 (chyba dom\u00e9ny). Argument mus\u00ed b\u00fdt mezi -1 a 1." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} se nezda\u0159ilo; k\u00f3d chyby je 8 (chyba dom\u00e9ny). Druh\u00fd argument nesm\u00ed b\u00fdt 0." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} se nezda\u0159ilo; k\u00f3d chyby je 8 (chyba dom\u00e9ny). Argument mus\u00ed b\u00fdt v\u011bt\u0161\u00ed ne\u017e 0." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "Funkce MathLib.pow selhala, k\u00f3d chyby 8 (chyba dom\u00e9ny). Kdy\u017e je prvn\u00ed argument nula, druh\u00fd mus\u00ed b\u00fdt v\u011bt\u0161\u00ed ne\u017e 0." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "Funkce MathLib.pow selhala, k\u00f3d chyby 8 (chyba dom\u00e9ny). Kdy\u017e je prvn\u00ed argument nula, druh\u00fd mus\u00ed b\u00fdt typu integer." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "Funkce MathLib.sqrt selhala, k\u00f3d chyby 8 (chyba dom\u00e9ny). Argument mus\u00ed b\u00fdt v\u011bt\u0161\u00ed nebo rovn\u00fd 0." },
		{ Message.MATH_RANGE_ERROR, "{0} se nezda\u0159ilo; k\u00f3d chyby je 12 (chyba rozsahu)." },		
		{ Message.STRING_INDEX_ERROR, "{0} se nezda\u0159ilo; k\u00f3d chyby je 8. Index mus\u00ed b\u00fdt mezi 1 a d\u00e9lkou \u0159et\u011bzce." },
		{ Message.STRING_LENGTH_ERROR, "{0} se nezda\u0159ilo; k\u00f3d chyby je 12. D\u00e9lka mus\u00ed b\u00fdt v\u011bt\u0161\u00ed ne\u017e 0." },
		{ Message.STRING_NULT_ERROR, "Metoda StrLib.setNullTerminator se nezda\u0159ila; k\u00f3d chyby je 16. Posledn\u00ed bajt c\u00edlov\u00e9ho \u0159et\u011bzce mus\u00ed b\u00fdt pr\u00e1zdn\u00fd nebo znaku null." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} se nezda\u0159ilo; k\u00f3d chyby je 20. Index d\u00edl\u010d\u00edho \u0159et\u011bzce STRING, DBCHAR nebo UNICODE mus\u00ed b\u00fdt lich\u00fd, aby index identifikoval prvn\u00ed bajt znaku." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} se nezda\u0159ilo; k\u00f3d chyby je 24. D\u00e9lka d\u00edl\u010d\u00edho \u0159et\u011bzce STRING, DBCHAR nebo UNICODE mus\u00ed b\u00fdt sud\u00e1, aby odkazovala na celkov\u00fd po\u010det znak\u016f." },
		{ Message.NO_DEBUG_LISTENER, "Nelze kontaktovat ladic\u00ed program EGL na n\u00e1zvu hostitele {0} a portu {1}. V\u00fdjimka je {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "P\u0159i komunikaci s ladic\u00edm programem EGL do\u0161lo k chyb\u011b na n\u00e1zvu hostitele {0} a portu {1}. V\u00fdjimka je {2}" },
		{ Message.NOT_DEBUG_MODE, "Spojen\u00ed zadalo vol\u00e1n\u00ed DEBUG uvnit\u0159 serveru J2EE. Toto vol\u00e1n\u00ed nebylo provedeno na server J2EE, server J2EE nen\u00ed v re\u017eimu lad\u011bn\u00ed nebo nebyl zp\u0159\u00edstupn\u011bn pro lad\u011bn\u00ed programu EGL." },
		{ Message.LIBRARY_NOT_SPECIFIED, "Spojen\u00ed zadalo vol\u00e1n\u00ed DEBUG listeneru EGL, ale nezadalo vlastnosti knihovny." },
		
		{ Message.FILETYPE_MISSING, "Vlastnost b\u011bhu programu vgj.ra.fileName.fileType nelze nal\u00e9zt pro soubor {0}." },
		{ Message.FILETYPE_INVALID, "Hodnota vlastnosti b\u011bhu programu vgj.ra.fileName.fileType je neplatn\u00e1 pro soubor {0}." },
		{ Message.INVALID_RECORD_LENGTH, "Polo\u017eka d\u00e9lky z\u00e1znamu mus\u00ed obsahovat hodnotu, kter\u00e1 rozd\u011bl\u00ed data bez znaku na hranic\u00edch polo\u017eky." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "Hodnota v occursItem alebo v lengthItem je p\u0159\u00edli\u0161 velk\u00e1." },
		{ Message.IO_ERROR, "{0}: I/O s {1} selhal z tohoto d\u016fvodu: {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: nebyl nalezen p\u0159ipravovan\u00fd p\u0159\u00edkaz {1}[stav sql:{2}][k\u00f3d sql:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: nebyla nalezena sada v\u00fdsledk\u016f {1} [stav sql:{2}][k\u00f3d sql:{3}]" },
		{ Message.SQL_ERROR, "{0}: chyba [stav sql:{1}][k\u00f3d sql:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [stav sql:02000][k\u00f3d sql:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[stav sql:{2}][k\u00f3d sql:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "Nelze se p\u0159ipojit k {0}: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "Nelze se p\u0159ipojit k {0}, mo\u017en\u00e1 kv\u016fli \u0161patn\u00e9 adrese URL datab\u00e1ze: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "Vyskytla se chyba b\u011bhem na\u010d\u00edt\u00e1n\u00ed  ovlada\u010d\u016f JDBC. Chyba: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "Sada v\u00fdsledk\u016f {0} nen\u00ed posouvateln\u00e1." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "Nelze se p\u0159ipojit k v\u00fdchoz\u00ed datab\u00e1zi. Nebyl zad\u00e1n n\u00e1zev v\u00fdchoz\u00ed datab\u00e1ze." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "P\u0159ed prov\u00e1d\u011bn\u00edm operac\u00ed se vstupem/v\u00fdstupem pomoc\u00ed SQL mus\u00ed b\u00fdt ustanoveno p\u0159ipojen\u00ed k datab\u00e1zi." },
		{ Message.SQL_DISCONNECT_ERROR, "B\u011bhem odpojov\u00e1n\u00ed z datab\u00e1ze {0} se vyskytla chyba. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "Nelze ustanovit p\u0159ipojen\u00ed k datab\u00e1zi {0}. P\u0159ipojen\u00ed neexistuje." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "Do\u0161lo k chyb\u011b SQL ve funkci SQLLib.{0}: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "Do\u0161lo k chyb\u011b mimo SQL ve funkci SQLLib.{0}: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "Z datab\u00e1ze byla obdr\u017eena hodnota Null, ale hostitelsk\u00e1 prom\u011bnn\u00e1 {0} nen\u00ed s povolenou hodnotou Null." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "Nebyl p\u0159ijat \u017e\u00e1dn\u00fd vstup u pole, kde je po\u017eadov\u00e1n - zadejte znovu." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "Je chyba v datov\u00e9m typu na vstupu - zadejte znovu." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "Byl p\u0159ekro\u010den po\u010det p\u0159\u00edpustn\u00fdch v\u00fdznamn\u00fdch \u010d\u00edslic - zadejte znovu." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "Vstup nen\u00ed v definovan\u00e9m rozsahu od {0} do {1} - zadejte znovu." },
		{ Message.EDIT_VALID_VALUES_ERR, "Vstup nen\u00ed v definovan\u00e9m seznamu platn\u00fdch hodnot - zadejte znovu." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "Zadan\u00fd form\u00e1t data a \u010dasu {0} je neplatn\u00fd." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "Je chyba v minim\u00e1ln\u00ed d\u00e9lce vstupu - zadejte znovu." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "Je chyba v maxim\u00e1ln\u00ed d\u00e9lce vstupu - zadejte znovu." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "Do\u0161lo k chyb\u011b v platnosti tabulky \u00faprav - zadejte znovu." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "Na vstupu do\u0161lo k chyb\u011b kontroly modulu - zadejte znovu." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "Vstup nen\u00ed pro definovan\u00fd datov\u00fd nebo \u010dasov\u00fd form\u00e1t {0} platn\u00fd." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "Vstup nen\u00ed jako pole s logickou hodnotou platn\u00fd." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "Zadan\u00e1 hodnota je neplatn\u00e1, pon\u011bvad\u017e neodpov\u00edd\u00e1 nastaven\u00e9mu vzorku." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "Tabulka \u00faprav {0} nen\u00ed pro {1} definov\u00e1na." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "Hexadecim\u00e1ln\u00ed data nejsou platn\u00e1." },
		{ Message.EDIT_VALIDATION_ERR, "Do\u0161lo k chyb\u011b v ov\u011b\u0159en\u00ed platnosti str\u00e1nky. Chyba: {0}." },
		{ Message.EDIT_INPUT_ERR, "Do\u0161lo k chyb\u011b v anal\u00fdze vstupn\u00ed hodnoty."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "Chyba p\u0159i form\u00e1tov\u00e1n\u00ed hodnoty pro zobrazen\u00ed: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "Vstupn\u00ed data se znaky SO/SI jsou pro definovanou d\u00e9lku polo\u017eky p\u0159\u00edli\u0161 dlouh\u00e1."},
		
		{ Message.ACTION_REQUEST_ERROR, "Funkce J2EELib RequestAttr se nezda\u0159ila; kl\u00ed\u010d je {0}. Chyba: {1}" },
		{ Message.ACTION_SESSION_ERROR, "Funkce J2EELib SessionAttr se nezda\u0159ila; kl\u00ed\u010d je {0}. Chyba: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "Funkce J2EELib ApplicationAttr se nezda\u0159ila; kl\u00ed\u010d je {0}. Chyba: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib lze pou\u017e\u00edt pouze v prost\u0159ed\u00ed J2EE." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "Funkce PortalLib PortletSessionAttr selhala s kl\u00ed\u010dem {0}. Chyba: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode selhala. Chyba: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState selhala. Chyba: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "Neplatn\u00fd pokus o zm\u011bnu re\u017eimu portletu b\u011bhem po\u017eadavku vykreslov\u00e1n\u00ed" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "Neplatn\u00fd pokus o zm\u011bnu stavu okna portletu b\u011bhem po\u017eadavku vykreslov\u00e1n\u00ed" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "Nepoda\u0159ilo se z\u00edskat PortletSession" }, 
		{ Message.PORTALLIB_INVALIDKEY, "Funkci {0} byl p\u0159ed\u00e1n neplatn\u00fd kl\u00ed\u010d" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "Nepoda\u0159ilo se z\u00edskat PortletRequest" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "Funkce PortalLib resetPreferenceValue selhala s kl\u00ed\u010dem {0}. Chyba: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "Funkce PortalLib savePreferences selhala. Chyba: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "Funkci PortalLib se nepoda\u0159ilo nastavit preference pro kl\u00ed\u010d {0}. Chyba: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "Funkce PortalLib selhala p\u0159i z\u00edsk\u00e1n\u00ed preference pro kl\u00ed\u010d {0}. Chyba: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "P\u0159\u00edstup ke slu\u017eb\u011b bezpe\u010dn\u00e9ho \u00falo\u017ei\u0161t\u011b pov\u011b\u0159en\u00ed se nezda\u0159il. Chyba: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "P\u0159\u00edstup k po\u017eadovan\u00e9mu pov\u011b\u0159en\u00ed ve slotu {0} se nezda\u0159il. Chyba: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "Vytvo\u0159en\u00ed slotu bezpe\u010dn\u00e9ho \u00falo\u017ei\u0161t\u011b pov\u011b\u0159en\u00ed v u\u017eivatelsk\u00e9m prostoru selhalo. Chyba: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "Odstran\u011bn\u00ed slotu bezpe\u010dn\u00e9ho \u00falo\u017ei\u0161t\u011b pov\u011b\u0159en\u00ed v u\u017eivatelsk\u00e9m prostoru selhalo. Chyba: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "Nastaven\u00ed hodnot pov\u011b\u0159en\u00ed selhalo. Chyba: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} se nezda\u0159ilo. Vyvol\u00e1n\u00ed metody nebo p\u0159\u00edstup k volan\u00e9mu poli {1} zp\u016fsobil neo\u0161et\u0159enou chybu. Chybov\u00e1 zpr\u00e1va je {2}" },
		{ Message.JAVALIB_NULL_ID, "{0} se nezda\u0159ilo. {1} nen\u00ed identifik\u00e1tor nebo je identifik\u00e1torem objektu s nulovou hodnotou." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} se nezda\u0159ilo. Ve\u0159ejn\u00e1 metoda, pole nebo t\u0159\u00edda n\u00e1zvem {1} neexistuje nebo nem\u016f\u017ee b\u00fdt na\u010dtena nebo nejsou uvedeny nespr\u00e1vn\u00e9 typy parametr\u016f. Chybov\u00e1 zpr\u00e1va je {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} se nezda\u0159ilo. Typ hodnoty v EGL neodpov\u00edd\u00e1 o\u010dek\u00e1van\u00e9mu v Java pro {1}. Chybov\u00e1 zpr\u00e1va je {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "{0} se nezda\u0159ilo. C\u00edl je metoda, kter\u00e1 navr\u00e1tila hodnotu null, metoda, kter\u00e1 nevr\u00e1tila hodnotu nebo pole, jeho\u017e hodnota je null." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} se nezda\u0159ilo. T\u0159\u00edda {1} argumentu null nebyla na\u010dtena. Chybov\u00e1 zpr\u00e1va je {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} se nezda\u0159ilo. Nelze z\u00edskat informace o metod\u011b nebo poli jm\u00e9nem {1} nebo byl u\u010din\u011bn pokus nastavit kone\u010dn\u011b deklarovanou hodnotu pole. Chybov\u00e1 zpr\u00e1va je {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} se nezda\u0159ilo. {1} je rozhran\u00ed nebo abstraktn\u00ed t\u0159\u00edda, a tak nelze volat konstruktor." },
		{ Message.JAVALIB_NOT_STATIC, "{0} se nezda\u0159ilo. Metoda nebo pole {1} nen\u00ed statick\u00e9. Mus\u00ed b\u00fdt pou\u017eit identifik\u00e1tor nam\u00edsto n\u00e1zvu t\u0159\u00eddy." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "Pole akce {0} neexistuje." },
		{ Message.CUI_E_ARRAY_FULL, "Nelze vlo\u017eit dal\u0161\u00ed \u0159\u00e1dek, proto\u017ee vstupn\u00ed pole je ji\u017e pln\u00e9.." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "Pole {0} nelze nal\u00e9zt." },
		{ Message.CUI_E_ASSIGN_RESULT, "Nezda\u0159ilo se p\u0159i\u0159azen\u00ed k v\u00fdsledkov\u00e9 prom\u011bnn\u00e9 v\u00fdzvy." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "Velikost {0} pole obrazovky nen\u00ed spr\u00e1vn\u00e1."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "Parametry DrawBox jsou mimo rozsah." },
		{ Message.CUI_E_BAD_COORDINATES, "Sou\u0159adnice na obrazovce jsou mimo rozm\u011bry okna." },
		{ Message.CUI_E_BAD_KEYNAME, "Po\u0161kozen\u00fd n\u00e1zev kl\u00ed\u010de ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "Tuto funkci k upravov\u00e1n\u00ed nem\u016f\u017eete pou\u017e\u00edt, proto\u017ee ji\u017e existuje obr\u00e1zek." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "Nelze naj\u00edt okno ''{0}''." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "Hodnoty polohy nov\u00e9ho okna [{0},{1}]/rozm\u011br[{2},{3}] jsou neplatn\u00e9." },
		{ Message.CUI_E_CMDSTACK_SYNC, "Z\u00e1sobn\u00edk p\u0159\u00edkaz\u016f p\u0159estal b\u00fdt synchronn\u00edm." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "Knihovna UI konzoly nen\u00ed inicializovan\u00e1." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "Neplatn\u00fd typ pole pro obrazec." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "ConstructQuery nelze volat se seznamem prom\u011bnn\u00fdch." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "Nelze znep\u0159\u00edstupnit neviditelnou polo\u017eku nab\u00eddky." },
		{ Message.CUI_E_EDIT_FAILED, "Akce \u00faprav se nezda\u0159ila." },
		{ Message.CUI_E_EXEC_HOTKEY, "Do\u0161lo k chyb\u011b b\u011bhem prov\u00e1d\u011bn\u00ed akce p\u0159idru\u017een\u00e9 k aktiva\u010dn\u00ed kl\u00e1vese." },
		{ Message.CUI_E_EXIT_NO_CMD, "Nen\u00ed \u017e\u00e1dn\u00fd aktivn\u00ed p\u0159\u00edkaz, kter\u00fd by se ukon\u010dil." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "Nen\u00ed \u017e\u00e1dn\u00fd aktivn\u00ed p\u0159\u00edkaz, ve kter\u00e9m by se mohlo pokra\u010dovat." },
		{ Message.CUI_E_FATALERROR, "Z\u00e1va\u017en\u00e1 chyba: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "Pole {0} neexistuje." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "Pole obrazovky ''{0}'' nen\u00ed pole." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "Pole {0} nelze nal\u00e9zt." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "Nelze vytvo\u0159it pole ConsoleField bez okna." },
		{ Message.CUI_E_FIELD_COUNT, "Po\u010det prvk\u016f pole se neshoduje." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "Formul\u00e1\u0159 {0} neexistuje." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "Formul\u00e1\u0159 {0} se nevm\u011bstn\u00e1 do okna {1}." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "Seznamy pol\u00ed se neshoduj\u00ed." },
		{ Message.CUI_E_FORM_IN_USE, "Formul\u00e1\u0159 {0} je pou\u017e\u00edvan\u00fd." },
		{ Message.CUI_E_FORM_NAME_USED, "Formul\u00e1\u0159 s n\u00e1zvem {0} ji\u017e existuje." },
		{ Message.CUI_E_FORM_NOT_OPEN, "Formul\u00e1\u0159 {0} nen\u00ed otev\u0159en." },
		{ Message.CUI_E_FORM_NO_WINDOW, "Nelze vytvo\u0159it formul\u00e1\u0159 ConsoleForm bez okna." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "Funkci KeyObject.getChar() nelze pou\u017e\u00edt na virtu\u00e1ln\u00ed kl\u00ed\u010de." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "Funkci KeyObject.getCookedChar() nelze pou\u017e\u00edt na virtu\u00e1ln\u00ed kl\u00ed\u010de." },
		{ Message.CUI_E_INTERNAL, "VNIT\u0158N\u00cd CHYBA: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "Byl obdr\u017een sign\u00e1l INTERRUPT." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "Nelze m\u00edt neviditelnou polo\u017eku nab\u00eddky, ani\u017e by m\u011bla akcelera\u010dn\u00ed kl\u00e1vesu." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "Nelze vytvo\u0159it formul\u00e1\u0159 ConsoleForm bez okna." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "Polo\u017eka nab\u00eddky {0}se nevm\u011bstn\u00e1 do okna." },
		{ Message.CUI_E_MISSING_ITEM, "Polo\u017eka nab\u00eddky {0} neexistuje." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "Konflikt v mnemonice nab\u00eddky (kl\u00ed\u010d={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "Nen\u00ed \u017e\u00e1dn\u00fd aktivn\u00ed formul\u00e1\u0159." },
		{ Message.CUI_E_NO_EDITOR, "Nebyl zad\u00e1n \u017e\u00e1dn\u00fd editor blob." },
		{ Message.CUI_E_NO_HELP_FILE, "Nebyl zad\u00e1n \u017e\u00e1dn\u00fd soubor n\u00e1pov\u011bdy." },
		{ Message.CUI_E_NO_HELP_MSG, "Nebyla uvedena \u017e\u00e1dn\u00e1 zpr\u00e1va n\u00e1pov\u011bdy." },
		{ Message.CUI_E_NO_NUMPAGES, "Nab\u00eddka nen\u00ed rozvr\u017eena." },
		{ Message.CUI_E_NO_SCREENARRAY, "Nen\u00ed \u017e\u00e1dn\u00e9 aktivn\u00ed pole obrazovky." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "K dispozici nejsou \u017e\u00e1dn\u00e9 viditeln\u00e9 polo\u017eky nab\u00eddky." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "N\u00e1zev nov\u00e9ho okna byl null." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "Pokus otev\u0159\u00edt nulov\u00e9 okno." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "V p\u0159\u00edkazov\u00e9m \u0159\u00e1dku do\u0161lo k v\u00fdjimce." },
		{ Message.CUI_E_QUIT_RECEIVED, "Byl obdr\u017een sign\u00e1l QUIT." },
		{ Message.CUI_E_SCROLL_FAILED, "Nab\u00eddka se nem\u016f\u017ee posunout tak, aby byla vid\u011bt aktu\u00e1ln\u00ed polo\u017eka." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "Nezn\u00e1m\u00fd atribut ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "Chyba v poli {0}." },
		{ Message.CUI_E_VAR_LIST_SHORT, "Nebylo dod\u00e1no dostatek prom\u011bnn\u00fdch." },
		{ Message.CUI_E_WINDOW_NAME_USED, "N\u00e1zev okna {0} je ji\u017e pou\u017e\u00edv\u00e1n." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "Velikost okna je na obrazovku n\u00e1pov\u011bdy p\u0159\u00edli\u0161 mal\u00e1." },
		{ Message.CUI_E_VALID_VALUES, "Zadan\u00e1 hodnota nen\u00ed platn\u00e1 hodnota." },
		{ Message.CUI_W_NO_MORE_FIELDS, "Ve sm\u011bru, kter\u00fdm se vyd\u00e1v\u00e1te, nejsou \u017e\u00e1dn\u00e1 dal\u0161\u00ed pole." },
		{ Message.CUI_W_NO_MORE_ROWS, "Ve sm\u011bru, kter\u00fdm se vyd\u00e1v\u00e1te, nejsou \u017e\u00e1dn\u00e9 dal\u0161\u00ed \u0159\u00e1dky." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "Obsahy obrazovky {0} nejsou platn\u00e9." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "Pole obrazovky {0} nemohou obsahovat {1} rozd\u011blen\u00e9 pole."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "Pole obrazovky {0} nen\u00ed kompatibiln\u00ed s datov\u00fdm polem." },
		{ Message.CUI_E_FIELD_NAME_DUP, "N\u00e1zev pole {0} je pou\u017e\u00edv\u00e1n v\u00edce ne\u017e jednou." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "{0} d\u00e9lka pole konzoly je neplatn\u00e1." },
		{ Message.CUI_E_LABEL_NOT_FIT, "\u0160t\u00edtek na [{0}, {1}] se nevejde do dostupn\u00e9ho prostoru." },
		{ Message.CUI_E_FIELD_NOT_FIT, "Segment pole  {0} v ({1}, {2}) se nevejde do dostupn\u00e9ho prostoru." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"\u0158et\u011bzec v\u00fdzvy je na aktivn\u00ed okno p\u0159\u00edli\u0161 dlouh\u00fd."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"Argumenty pole OpenUI jsou neplatn\u00e9."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "Argumenty pole OpenUI jsou neplatn\u00e9."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "Do p\u0159\u00edkazu v\u00fdzvy lze sv\u00e1zat pouze jednoduchou prom\u011bnnou." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "Vazbu dat pro pole konzoly {0} nelze ur\u010dit." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "Varov\u00e1n\u00ed: v datech parametru clob byly nalezeny znaky NUL" },
		{ Message.CUI_I_STR_WINDOWTITLE , "Okno konzoly EGL" },
		{ Message.CUI_E_MISSING_FORMAT , "Pole {0} nem\u00e1 \u017e\u00e1dn\u00fd form\u00e1t objektu." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "Dv\u011b zad\u00e1n\u00ed nebyla stejn\u00e1 -- pros\u00edm, pokuste se znovu" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "Pro ov\u011b\u0159en\u00ed napi\u0161te znovu, pros\u00edm" },
		{ Message.CUI_I_STR_HELP,"N\u00e1pov\u011bda"},
		{ Message.CUI_I_STR_RESUME,"Obnovit"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"Ukon\u010d\u00ed tuto relaci n\u00e1pov\u011bdy."},
		{ Message.CUI_I_STR_SCROLL , "Posouvat" },
		{ Message.CUI_I_STR_LAST_PAGE, "Dos\u00e1hli jste konce textu n\u00e1pov\u011bdy. Pro pokra\u010dov\u00e1n\u00ed stiskn\u011bte RETURN."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "Zobrazuje dal\u0161\u00ed str\u00e1nku textu n\u00e1pov\u011bdy."},
		{ Message.CUI_I_STR_SELECT , "VYBRAT"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "Chyba vkl\u00e1d\u00e1n\u00ed prvn\u00edho \u0159\u00e1dku do pr\u00e1zdn\u00e9ho pole."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 nen\u00ed implementov\u00e1no."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "INTERN\u00cd: F25-64 nen\u00ed implementov\u00e1no" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "Nelze m\u00edt hromadn\u00e9 v\u00fdskyty CursesCanvas" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas nen\u00ed inicializov\u00e1n" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas je p\u0159\u00edli\u0161 mal\u00fd"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "Zobrazen\u00ed pole podle n\u00e1zvu nen\u00ed implementov\u00e1no."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "Je po\u017eadovan\u00fd minim\u00e1ln\u00ed vstup {0} - zadejte znovu." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "Maxim\u00e1ln\u00ed vstup {0} byl p\u0159ekro\u010den - zadejte znovu." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "Nelze otev\u0159\u00edt soubor skriptu ''{0}''." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "Nelze \u010d\u00edst soubor skriptu."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "Vlastnost automation.scenario ''{0}'' nen\u00ed adres\u00e1\u0159."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "Po\u0161kozen\u00e1 direktiva <click> ve skriptu pro zp\u011btn\u00e9 prom\u00edt\u00e1n\u00ed."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "Nelze z\u00edskat automatizaci vlastnosti ''{0}''."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "Neplatn\u00fd n\u00e1zev nouzov\u00e9ho kl\u00ed\u010de ''{0}''"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "V\u00fdjimka v direktiv\u011b <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "Nelze otev\u0159\u00edt soubor v\u00fdpisu obrazovky ''{0}''"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "Sada vlastnost\u00ed pro automation.scriptdir ''{0}'' neexistuje."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "Sada vlastnost\u00ed pro adres\u00e1\u0159 automation.scenario ''{0}'' nelze vytvo\u0159it."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "Neplatn\u00fd n\u00e1zev kl\u00ed\u010de sn\u00edmku ''{0}''"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "Porovn\u00e1n\u00ed ok."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "Pou\u017eit\u00ed zobrazen\u00ed I/O operac\u00ed nen\u00ed povoleno p\u0159i spu\u0161t\u011bn\u00ed v re\u017eimu RCP."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "Zpr\u00e1va s ID {0} neexistuje v tabulce zpr\u00e1vy {1}." },
		{ Message.MSG_TBL_LOAD_ERR, "Soubor s tabulkou zpr\u00e1v {0} nelze na\u010d\u00edst." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "Nen\u00ed definov\u00e1na u\u017eivatelsk\u00e1 tabulka zpr\u00e1v pro {0} VGUIRecord." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "Pole ''{0}'' na pozici({1},{2}) nele\u017e\u00ed uvnit\u0159 formul\u00e1\u0159e." },
		{ Message.TUI_E_FIELD_OVERLAP, "Pole ''{0}'' se p\u0159ekr\u00fdv\u00e1 ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "Intern\u00ed chyba: nelze ur\u010dit formul\u00e1\u0159 skupiny." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "Formul\u00e1\u0159 ''{0}'' se nevejde do \u017e\u00e1dn\u00e9 plovouc\u00ed oblasti." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "Sou\u0159adnice pole ''{0}'' nejsou platn\u00e9." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "Nelze z\u00edskat p\u0159idru\u017een\u00ed tisku." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "Neexistuj\u00ed vhodn\u00e9 velikosti tiskov\u00fdch za\u0159\u00edzen\u00ed." },
		{ Message.TUI_E_NO_DISPLAY, "Pro formul\u00e1\u0159 neexistuje \u017e\u00e1dn\u00e9 zobrazen\u00e9 za\u0159\u00edzen\u00ed." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "Pro zobrazen\u00e9 formul\u00e1\u0159e neexistuje \u017e\u00e1dn\u00e9 zobrazen\u00e9 za\u0159\u00edzen\u00ed." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "N\u00e1pov\u011bda ze t\u0159\u00eddy ''{0}'' neexistuje." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "Nezn\u00e1m\u00fd atribut ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "Hodnota uveden\u00e1 v atributu platn\u00fdch hodnot je neplatn\u00e1 a nelze ji analyzovat." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "Nelze vytvo\u0159it formul\u00e1\u0159 n\u00e1pov\u011bdy ''{0}''" },
		{ Message.TUI_E_INTERNAL, "VNIT\u0158N\u00cd CHYBA: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "K dispozici nejsou \u017e\u00e1dn\u00e9 tisk\u00e1rny." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "\u017d\u00e1dn\u00e1 tisk\u00e1rna nen\u00ed v\u00fdchoz\u00ed." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "Tisk\u00e1rna ''{0}'' nebyla nalezena.\nTyto tisk\u00e1rny jsou k dispozici:\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "Chyba p\u0159i na\u010d\u00edt\u00e1n\u00ed zpr\u00e1vy ''{0}''" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "Obsah {0} nelze pou\u017e\u00edt jako pole." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "Tisk\u00e1rna ''{0}'' nebyla nalezena" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "Program {0} o\u010dek\u00e1val textov\u00fd formul\u00e1\u0159 {1}, ale dostal textov\u00fd formul\u00e1\u0159 {2} na p\u0159\u00edkazu show." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "Dal\u0161\u00ed" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "Str\u00e1nka {0} z {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "P\u0159edchoz\u00ed" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "Tisk" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "Uk\u00e1zka p\u0159ed tiskem - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "Ulo\u017eit" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "Ulo\u017eit PrintJob - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "Chyba tisku do souboru: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "Chyba tisku na tisk\u00e1rnu: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "Nastaven\u00ed EZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "Prob\u00edh\u00e1 kontrola platnosti pole ''{0}''" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "Prob\u00edh\u00e1 kontrola platnosti textform" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "Prob\u00edh\u00e1 kontrola platnosti textform - je spu\u0161t\u011bna funkce kontroly ''{0}''" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "Nelze vytvo\u0159it logwriter." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "Protokolovan\u00ed parametru ''{0}'' nelze nastavit po spu\u0161t\u011bn\u00ed." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "Logdir ''{0}'' neexistuje." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "Nelze zapisovat do logdir ''{0}''." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "Nelze vytvo\u0159it logfile ''{0}''." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "Nelze zapisovat do logfile ''{0}''." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Nastaly probl\u00e9my v na\u010d\u00edt\u00e1n\u00ed slu\u017eby pro slu\u017ebu komponent/extern\u00ed slu\u017ebu {0}." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "Vyskytla se chyba b\u011bhem vytv\u00e1\u0159en\u00ed p\u0159ipojen\u00ed k operaci webov\u00fdch slu\u017eeb ''{0}''. {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "Vyskytla se chyba p\u0159i z\u00edsk\u00e1v\u00e1n\u00ed operace:''{0}'' ze souboru wsdl:''{1}''." },
		{ Message.SOA_E_WS_MALFORMED_URL, "C\u00edl URL pro operaci webov\u00e9 slu\u017eby {1} je neplatn\u00fd. URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "Vyskytla se chyba b\u011bhem na\u010d\u00edt\u00e1n\u00ed slu\u017eby {0}. Chyba: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "Vyskytla se chyba b\u011bhem pokusu na\u010d\u00edst webovou slu\u017ebu. Nebylo mo\u017en\u00e9 rozli\u0161it port WSDL pro extern\u00ed slu\u017ebu {0}." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "Komponenta {0} postr\u00e1d\u00e1 vlastnost {1}, kterou implementace slu\u017eby po\u017eaduje." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "Odkaz na slu\u017ebu ''{0}'' bu\u010f chyb\u00ed, nebo nem\u00e1 c\u00edlovou hodnotu." },
		{ Message.SOA_E_MISSING_BINDING, "Vazba slu\u017eby:''{0}'' v deskriptoru implementace neexistuje:''{1}''" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "B\u011bhem pokusu p\u0159ev\u00e9st z\u00e1znam ''{0}'' na zpr\u00e1vu SOAP se vyskytla chyba. V z\u00e1znamu nelze nal\u00e9zt pole ''{1}''." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "B\u011bhem pokusu p\u0159ev\u00e9st ''{0}'' na zpr\u00e1vu SOAP se vyskytla chyba."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "Vyskytla se chyba b\u011bhem zpracov\u00e1n\u00ed p\u0159\u00edchoz\u00ed sv\u00e1zan\u00e9 zpr\u00e1vy od webov\u00e9 slu\u017eby. Typ Java je nekompatibiln\u00ed s typem EGL." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "B\u011bhem zpracov\u00e1n\u00ed odchoz\u00ed sv\u00e1zan\u00e9 zpr\u00e1vy pro webovou slu\u017ebu se vyskytla chyba. Typ EGL je nekompatibiln\u00ed s typem Java." },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "Nelze inicializovat z\u00e1znam ''{0}''." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "Hodnotu ''{0}'' nelze p\u0159ev\u00e9st na Calendar." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "Hodnotu ''{0}'' nelze p\u0159ev\u00e9st na logickou hodnotu." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "Hodnotu ''{0}'' nelze p\u0159ev\u00e9st na typ Byte." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "Hodnotu ''{0}'' nelze p\u0159ev\u00e9st na typ short." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "Hodnotu ''{0}'' nelze p\u0159ev\u00e9st na identifik\u00e1tor URI." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "Typ EGL nen\u00ed podporov\u00e1n jako parametr webov\u00e9 slu\u017eby." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "B\u011bhem pokusu o vytvo\u0159en\u00ed pole z\u00e1znam\u016f se vyskytla chyba. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "Metoda {0} nebyla pod slu\u017ebou {1} nalezena." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "Tato slu\u017eba nen\u00ed webov\u00e1 slu\u017eba." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "Vyskytla se chyba b\u011bhem pokusu o vyvol\u00e1n\u00ed funkce:{0} na webov\u00e9 slu\u017eb\u011b:{1}." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "Vyskytla se chyba b\u011bhem pokusu o vyvol\u00e1n\u00ed funkce:{0} na slu\u017eb\u011b EGL:{1}." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "Vyskytla se chyba b\u011bhem pokusu o vyvol\u00e1n\u00ed funkce:{0} na slu\u017eb\u011b EGL:{1} pomoc\u00ed {2}:{3}." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "Slu\u017eba nen\u00ed slu\u017ebou protokolu TCP/IP." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "Vyskytla se chyba b\u011bhem pokusu o vyvol\u00e1n\u00ed funkce:{0} na vstupn\u00edm bodu:{1}." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "Vyskytla se chyba b\u011bhem pokusu o na\u010dten\u00ed souboru vazby slu\u017eby {0}. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "Vyskytla se chyba b\u011bhem pokusu o vyvol\u00e1n\u00ed funkce:{0} na slu\u017eb\u011b CICS:{1}. K\u00f3d chyby:{2}, Zpr\u00e1va:{3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "Vyskytla se chyba b\u011bhem pokusu o vyvol\u00e1n\u00ed funkce:{0} na slu\u017eb\u011b iSeries:{1}. K\u00f3d chyby:{2}, Zpr\u00e1va:{3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "Slu\u017eba nen\u00ed slu\u017ebou CISC." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "Vyskytla se chyba ve vzd\u00e1len\u00e9 slu\u017eb\u011b {0}, datum {1}, \u010das {2}, na syst\u00e9mu {3}." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "Ve vzd\u00e1len\u00e9 slu\u017eb\u011b {0}, na syst\u00e9mu {1} se vyskytla chyba." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "Spou\u0161t\u011bn\u00ed jednotky skon\u010dilo kv\u016fli chyb\u011b aplikace na syst\u00e9mu {0}, kter\u00e1 se pokou\u0161ela volat slu\u017ebu {1}. Zpr\u00e1va: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "Chyba v prov\u00e1d\u011bn\u00ed AS400Toolbox: {0}, {1} p\u0159i vol\u00e1n\u00ed slu\u017eby {2} na syst\u00e9mu {3}." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "Nepodporovan\u00e1 vazba klient\u016f slu\u017eby. {0} se vygenerovala z Websphere, ale vol\u00e1 se z jin\u00e9ho prost\u0159ed\u00ed ne\u017e J2EE. Vygenerujte ji znovu do jin\u00e9ho projektu ne\u017e J2EE." },
		{ Message.SOA_E_USER_ID_NOT_SET, "ID a heslo vzd\u00e1len\u00e9ho u\u017eivatele je t\u0159eba nastavit p\u0159ed vyvol\u00e1n\u00edm webov\u00e9 slu\u017eby:{0} funkce:{1}." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "Do\u0161lo k v\u00fdjimce p\u0159i vol\u00e1n\u00ed slu\u017eby." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "Do\u0161lo k v\u00fdjimce p\u0159i komunikaci se slu\u017ebou. URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "Do\u0161lo k v\u00fdjimce p\u0159i vol\u00e1n\u00ed slu\u017eby REST. Vazba:{0}, operace:{0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "Do\u0161lo k v\u00fdjimce p\u0159i vol\u00e1n\u00ed slu\u017eby protokolu SOAP. Vazba:{0}, slu\u017eba:{1}, port:{2}, um\u00edst\u011bn\u00ed WSDL:{3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "Do\u0161lo k v\u00fdjimce p\u0159i p\u0159evodu z JSON. parametr:{0}, json:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "Do\u0161lo k v\u00fdjimce p\u0159i p\u0159evodu na JSON. parametr:{0}, hodnota:{1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "Nebyla nalezena \u017e\u00e1dn\u00e1 slu\u017eba REST-RPC. URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "\u017d\u00e1dn\u00e1 odezva nebyla od slu\u017eby p\u0159ijata. URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "\u017d\u00e1dost nelze p\u0159ev\u00e9st na vol\u00e1n\u00ed slu\u017eby. P\u0159ijat\u00e1 \u017e\u00e1dost byla ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "Vyvol\u00e1n\u00ed slu\u017eby vypr\u0161elo. v\u00fdjimka: Chyba p\u0159i vypr\u0161en\u00ed \u010dasu \u010dten\u00ed p\u0159ipojen\u00ed. url:{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "Slu\u017eba nen\u00ed slu\u017eba REST." },
		{ Message.SOA_E_REST_SERVICE, "Vol\u00e1n\u00ed do vyvol\u00e1n\u00ed slu\u017eby REST selhalo. Vazba:{0}, operace:{1}, metoda HTTP:{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "Do\u0161lo k v\u00fdjimce b\u011bhem p\u0159evodu dat do parametr\u016f EGL. Vazba:{0}, data k p\u0159evodu {1}, v\u00fdjimka:{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "Vyvol\u00e1n\u00ed slu\u017eby REST bylo provedeno na odkazu na slu\u017ebu jin\u00e9ho typu ne\u017e REST. Odkaz na slu\u017ebu: {0}, operace {1}, metoda HTTP: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "Do\u0161lo k v\u00fdjimce p\u0159i p\u0159evodu z XML. Po\u017eadovan\u00fd prvek {0} chyb\u00ed." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "Do\u0161lo k v\u00fdjimce p\u0159i p\u0159evodu z XML. Parametr:{0}, xml:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "Do\u0161lo k v\u00fdjimce p\u0159i p\u0159evodu do XML. Parametr:{0}, hodnota:{1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "Do\u0161lo k v\u00fdjimce p\u0159i anal\u00fdze XML p\u0159i p\u0159evodu {0} z XML." },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "Do\u0161lo k v\u00fdjimce p\u0159evodu XML p\u0159i p\u0159evodu {0} do XML." },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "Adresa URL ''{0}'' pou\u017eit\u00e1 k vyvol\u00e1n\u00ed slu\u017eby je neplatn\u00e1. Neobsahuje protokol http:// ." },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "Adresa URL ''{0}'' pou\u017eit\u00e1 k vyvol\u00e1n\u00ed slu\u017eby je neplatn\u00e1. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "Adresa URL pou\u017eit\u00e1 k vyvol\u00e1n\u00ed slu\u017eby je pr\u00e1zdn\u00e1. Uve\u010fte adresu URL, kter\u00e1 ukazuje na slu\u017ebu." },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "Z\u00e1znam nelze za pou\u017eit\u00ed p\u0159ipojen\u00ed {0} naplnit"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "Z\u00e1znam nelze naplnit za pou\u017eit\u00ed p\u0159\u00edkazu sql {0}"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "Z\u00e1znam nelze naplnit za pou\u017eit\u00ed dynamick\u00e9ho pole {0}"},
		{ Message.REPORT_E_FILL_ERROR , "Nelze naplnit z\u00e1znam {0}"},
		{ Message.REPORT_E_EXPORT_ERROR, "Nelze exportovat z\u00e1znam {0}" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "Nelze p\u0159ev\u00e1d\u011bt mezi typy EGL {0} a Java {1}" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "Nelze p\u0159ev\u00e1d\u011bt mezi typy Java {0} a EGL {1}" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "Nelze p\u0159idat parametr z\u00e1znamu" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "Nelze resetovat seznam parametr\u016f z\u00e1znamu" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "Nespr\u00e1vn\u00fd n\u00e1zev pole {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "Nespr\u00e1vn\u00fd n\u00e1zev podz\u00e1znamu {0}" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "Ve vytv\u00e1\u0159en\u00ed zpr\u00e1v se pou\u017e\u00edv\u00e1 nepodporovan\u00fd typ" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "T\u00e9to funkci nelze p\u0159ed\u00e1vat komplexn\u00ed typy" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "N\u00e1zev souboru n\u00e1vrhu by m\u011bl b\u00fdt nastaven p\u0159ed vol\u00e1n\u00edm funkce getParameterDefaultValue()." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "Nelze z\u00edskat v\u00fdchoz\u00ed hodnotu parametru {0}. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "Parametr sestavy s n\u00e1zvem {0} neexistuje." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "N\u00e1zev souboru n\u00e1vrhu by m\u011bl b\u00fdt nastaven p\u0159ed vol\u00e1n\u00edm funkce createReportFromDesign() nebo createDocument()." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, ".N\u00e1zev souboru dokument\u016f by m\u011bl b\u00fdt nastaven p\u0159ed vol\u00e1n\u00edm funkce createReportFromDocument()." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "Nelze vytvo\u0159it soubor s dokumentem sestavy. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "Nelze vytvo\u0159it sestavu ze souboru n\u00e1vrh\u016f. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "Nelze vytvo\u0159it sestavu ze souboru s dokumentem. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "Objekt popisova\u010de pro BirtReport mus\u00ed b\u00fdt typu BirtHandler." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "Prvek {0} neexistuje v n\u00e1vrhu sestavy, nebo to nen\u00ed uveden\u00fd typ." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "{0} \u010d\u00edslo \u0159\u00e1dku {1} neexistuje v tabulce {2}." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "\u010d\u00edslo \u0159\u00e1dku {0} neexistuje v prvku m\u0159\u00ed\u017eky {1}." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "Skupina {0} neexistuje v tabulce {1}." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "{0} \u010d\u00edslo \u0159\u00e1dku {1} neexistuje ve skupin\u011b {2} v tabulce {3}." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "\u010c\u00edslo sloupce {0} neexistuje v \u0159\u00e1dku {1} v tabulce {2}." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "\u010c\u00edslo sloupce  {0} neexistuje v m\u0159\u00ed\u017ece {1}." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "\u010c\u00edslo sloupce {0} neexistuje v \u0159\u00e1dku {1} ve skupin\u011b {2} v tabulce {3}." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "Vlastnost ''RowType'' mus\u00ed b\u00fdt zadan\u00e1 pro funkci obslu\u017en\u00e1 rutina ud\u00e1lost\u00ed pro \u0159\u00e1dek(-y) nebo bu\u0148ku(-y) v tabulce {0}." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "Nelze p\u0159ev\u00e9st typ Java {0} na typ EGL." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "Nelze p\u0159ev\u00e9st typ EGL {0} na typ Java." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "Mno\u017eina dat {0} neexistuje v n\u00e1vrhu sestavy." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "Mno\u017eina dat {0} je skriptov\u00e1 mno\u017eina dat, ale \u017e\u00e1dn\u00fd z n\u00e1sleduj\u00edc\u00edch eventTypes nebyl o\u0161et\u0159en: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "Zdroj dat {0} neexistuje v n\u00e1vrhu sestavy." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "Zdroj dat {0} je skriptov\u00fd zdroj dat, ale \u017e\u00e1dn\u00fd z n\u00e1sleduj\u00edc\u00edch eventTypes nebyl o\u0161et\u0159en: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "\u010c\u00edslo sloupce {0} neexistuje  v mno\u017ein\u011b dat {1}." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "Vyskytla se v\u00fdjimka p\u0159i z\u00edsk\u00e1v\u00e1n\u00ed sloupce {0} z mno\u017einy dat {1}. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "Vyskytla se v\u00fdjimka p\u0159i nastaven\u00ed sloupce {0} skriptov\u00e9 mno\u017einy dat {1}. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "Vyskytla se v\u00fdjimka p\u0159i z\u00edsk\u00e1v\u00e1n\u00ed vazby sloupce {0}. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "Nen\u00ed zad\u00e1na vlastnost vgj.defaultI4GLNativeLibrary" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "Na\u010dten\u00ed knihovny {0} selhalo {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "Navr\u00e1cen\u00e9 parametry neodpov\u00eddaj\u00ed funkci" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "Nelze alokovat pam\u011b\u0165"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "Nelze p\u0159ev\u00e1d\u011bt mezi typy"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "Neplatn\u00e1 p\u0159esnost Data/\u010dasu nebo Intervalu"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "Prom\u011bnn\u00e1 hostitele znak\u016f je pro data p\u0159\u00edli\u0161 kr\u00e1tk\u00e1"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "Funkci nelze v tabulce symbol\u016f nel\u00e9zt"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "V r\u00e1mci tohoto kontextu mus\u00ed b\u00fdt dod\u00e1ny datov\u00e9 typy TEXT nebo BYTE"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "Hodnotu v z\u00e1sobn\u00edku nelze p\u0159ev\u00e9st na typ hodnoty"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "Hodnotu v z\u00e1sobn\u00edku nelze p\u0159ev\u00e9st na ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "Nelze vyjmout hodnotu typu {0} ze z\u00e1sobn\u00edku"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "Do z\u00e1sobn\u00edku nelze vlo\u017eit hodnotu typu {1}"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "Nen\u00ed nic, co by bylo lze zasadit/vypustit"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "Ze sady nelze vypustit lok\u00e1tor"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "Sada je pr\u00e1zdn\u00e1"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "Nelze zkop\u00edrovat lok\u00e1tor"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "Do sady byl zasazen nulov\u00fd odkaz"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "Do sady nelze zasadit Any"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "Prvek sady nelze p\u0159i\u0159adit typu Any"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "Nastala neshoda mezi n\u00e1vratov\u00fdmi typy"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "Nastala neshoda mezi typy parametr\u016f"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "Nelze nal\u00e9zt zdrojov\u00fd soubor EGL {0}. M\u00edsto n\u011bho bude spu\u0161t\u011bn generovan\u00fd k\u00f3d. " },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "Nelze nal\u00e9zt zdrojov\u00fd soubor EGL pro webovou transakci nazvanou {0}." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "Do\u0161lo k n\u00e1sleduj\u00edc\u00edmu probl\u00e9mu form\u00e1tov\u00e1n\u00ed na poli \"{0}\" p\u0159i zobrazov\u00e1n\u00ed formul\u00e1\u0159e \"{1}\":" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\nO\u010dek\u00e1van\u00fd vnit\u0159n\u00ed form\u00e1t pole je \"{1}\". Zkontrolujte vlastnosti form\u00e1tu data ve vlastnostech prost\u0159ed\u00ed JRE EGL v r\u00e1mci deskriptoru sestaven\u00ed lad\u011bn\u00ed nebo vlastnosti JDBC, kter\u00e9 ovliv\u0148uj\u00ed form\u00e1ty dat." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\nForm\u00e1t zobrazen\u00ed pole je \"{1}\". Zkontrolujte vlastnost \"{2}\" v poli formul\u00e1\u0159e." },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "Nelze spustit program, {0}, jako webovou transakci." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "Webov\u00e1 transakce z\u00edskala z\u00e1znam UI vstupu {0}, ale byl definov\u00e1n se z\u00e1znamem UI vstupu {1}." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "Vstup nen\u00ed jako pole s logickou hodnotou platn\u00fd." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "Do\u0161lo k p\u0159ekro\u010den\u00ed \u010dasov\u00e9ho limitu v programu {0} kv\u016fli ne\u010dinnosti." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "Z\u00e1znam u\u017eivatelsk\u00e9ho rozhran\u00ed {0} obsahuje p\u0159\u00edli\u0161 mnoho dat, aby mohl b\u00fdt odesl\u00e1n do servletu br\u00e1ny." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "Program nemohl ov\u011b\u0159it data ze servletu br\u00e1ny. Identifik\u00e1tor dat je {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "Obal pole {0} nelze roz\u0161\u00ed\u0159it mimo svou maxim\u00e1ln\u00ed velikost. Do\u0161lo k chyb\u011b v metod\u011b {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} je neplatn\u00fd index pro obal pole {1}. Maxim\u00e1ln\u00ed velikost: {2}. Aktu\u00e1ln\u00ed velikost: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} nen\u00ed platn\u00e1 maxim\u00e1ln\u00ed velikost pro obal pole {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} je neplatn\u00fd typ objektu, kter\u00fd se m\u00e1 p\u0159idat k obalu pole typu {1}." },
		
		{ Message.IMS_HOST_ABORT, "Byl p\u0159ijat paket p\u0159ed\u010dasn\u00e9ho ukon\u010den\u00ed ze vzd\u00e1len\u00e9ho hostitele."},
		{ Message.IMS_HOST_TCPIP_ERROR, "Do\u0161lo k chyb\u011b TCPIP na vzd\u00e1len\u00e9m hostiteli. Sekce:{0} TCPIP-Operace:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "B\u011bhem vol\u00e1n\u00ed se vyskytla chyba na hostiteli:{0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "Od hostitele byl p\u0159ijat chybn\u00fd paket s odezvou. O\u010dek\u00e1v\u00e1n:{0} P\u0159ijat:{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "Chyba IO p\u0159i prov\u00e1d\u011bn\u00ed ulo\u017een\u00e9 procedury. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "Chyba SQL p\u0159i prov\u00e1d\u011bn\u00ed ulo\u017een\u00e9 procedury. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "Chyba na vzd\u00e1len\u00e9m hostiteli p\u0159i prov\u00e1d\u011bn\u00ed:{0} RETCODE:{1} ID \u00falohy serveru proxy DLI:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "Chyba DLI na vzd\u00e1len\u00e9m hostiteli. Funkce DLI:{0} AIB-n\u00e1vrat:0x{1} AIB-p\u0159\u00ed\u010dina:0x{2} stavov\u00fd k\u00f3d:{3} ID \u00falohy serveru proxy DLI:{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "Chyba DLI na vzd\u00e1len\u00e9m hostiteli. Funkce DLI:{0} AIB-n\u00e1vrat:0x{1} AIB-p\u0159\u00ed\u010dina:0x{2} DLIVar.statusCode:{3} DLIVar.DbName:{4} DLIVar.SegmentName:{5} DLIVar.SegmentLevel:{6} ID \u00falohy serveru proxy DLI:{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "AIB-n\u00e1vratov\u00fd k\u00f3d ozna\u010duje PCB-stavov\u00fd k\u00f3d, ale bez n\u00e1vratu PCB. AIB-funkce:{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "Do\u0161lo k v\u00fdjimce v CALL EZEDBTCP na vzd\u00e1len\u00e9m hostiteli. Sekce:{0} TCPIP-Operace:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "Do\u0161lo k nestandardn\u00edmu konci na vzd\u00e1len\u00e9m hostiteli. Rutina:{0} Zpr\u00e1va:{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "Do\u0161lo k v\u00fdjimce na vzd\u00e1len\u00e9m hostiteli. VOL\u00c1N\u00cd:{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "Ladic\u00ed program nepodporuje funkci DLI. Funkce:{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "Vol\u00e1n\u00ed DL/I se vyd\u00e1v\u00e1, ale deskriptor sestaven\u00ed nen\u00ed konfigurov\u00e1n pro p\u0159\u00edstup DL/I."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "Vzd\u00e1len\u00e1 v\u00fdjimka: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "P\u0159i pokus o p\u0159id\u011blen\u00ed PSB se vyskytla chyba. IMSID je nastaveno k ozna\u010den\u00ed, kde je p\u0159\u00edstup DL/I, ale nen\u00ed zde zad\u00e1no \u017e\u00e1dn\u00e9 PSB."},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "Verze hostitele a klienta RBD nejsou kompatibiln\u00ed. Verze klienta RBD:{0} verze hostitele:{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "P\u0159i z\u00edsk\u00e1v\u00e1n\u00ed dat vr\u00e1cen\u00fdch z vol\u00e1n\u00ed hostitelsk\u00e9mu programu do\u0161lo k chyb\u011b. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "Do\u0161lo k chyb\u011b p\u0159i na\u010d\u00edt\u00e1n\u00ed n\u00e1zvu PCB. Index PCB:{0}, po\u010det PCB:{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
