/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_de extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "Der Fehler ist in {0} aufgetreten." },
		{ Message.FUNCTION_ERROR_INFO, "Der Fehler ist in {0} bei der Verarbeitung der Funktion {1} aufgetreten." },
		{ Message.FILE_ERROR_INFO, "Der Fehler ist in {0} bei der Verarbeitung der Funktion {1} in Zeile {2} aufgetreten." },
		{ Message.PROPERTIES_FILE_MISSING, "Die Eigenschaftendatei {0} konnte nicht geladen werden." },
		{ Message.LOAD_LIBRARY_FAILED, "Die Bibliothek {0} kann nicht geladen werden. Folgender Fehler ist aufgetreten: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "Bei der Erstellung eines Objekts vom Typ {0} ist ein Fehler aufgetreten. Folgender Fehler ist aufgetreten: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "Beim Erstellen von InitialContext oder beim Suchen der Umgebung java:comp/env ist ein Fehler aufgetreten. Folgender Fehler ist aufgetreten: {0}" },
		{ Message.LISTENER_ERROR, "Die folgende Ausnahmebedingung mit Nachricht ist aufgetreten. Ausnahmebedingung: {0}. Nachricht: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "F\u00fcr die Eigenschaft {0} ist ein Wert erforderlich." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "Eine externe Abh\u00e4ngigkeit fehlt. Die folgende Ausnahmebedingung ist aufgetreten. Ausnahmebedingung: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "Die Operanden {0} und {1} k\u00f6nnen nicht verglichen werden." },
		{ Message.ASSIGNMENT_OVERFLOW, "Bei der Zuordnung eines Werts von {0} zu {1} ist ein \u00dcberlauffehler aufgetreten." },
		{ Message.EXPRESSION_OVERFLOW, "Bei der Berechnung des folgenden Ausdrucks ist ein \u00dcberlauffehler aufgetreten: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "Der Operator {0} wird f\u00fcr die Operanden {1} und {2} nicht unterst\u00fctzt." },
		{ Message.UNSUPPORTED_OPERAND, "Der Operator {0} wird f\u00fcr den Operand {1} vom Typ {2} nicht unterst\u00fctzt." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "Der tiefgestellte Operator wird f\u00fcr den Operand {0} vom Typ {1} nicht unterst\u00fctzt." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "Der Unterzeichenfolgenoperator wird f\u00fcr den Operand {0} vom Typ {1} nicht unterst\u00fctzt." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "Die Anweisung SET EMPTY wird f\u00fcr den Operand {0} vom Typ {1} nicht unterst\u00fctzt." },
		{ Message.INVALID_REGULAR_EXPRESSION, "Im regul\u00e4ren Ausdruck {0} ist ein Fehler aufgetreten. Fehler: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "Bei Verwendung des Protokolls CICSSSL m\u00fcssen ctgKeyStore und ctgKeyStorePassword angegeben werden." },
		{ Message.INVALID_CTGPORT, "Der Wert {0} f\u00fcr den Eintrag ctgport ist falsch." },
		{ Message.CTG_CONNECT_FAILED, "Bei der Herstellung der Verbindung zu CTG ist ein Fehler aufgetreten. Die CTG-Position lautet {0}. Der CTG-Port ist {1}. Folgender Fehler ist aufgetreten: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "Beim Unterbrechen der Verbindung von CTG ist ein Fehler aufgetreten. Die CTG-Position lautet {0}. Der CTG-Port ist {1}. Folgender Fehler ist aufgetreten: {2}" },
		{ Message.NO_CICS, "Beim Aufruf des Programms {0}, das CICS ECI verwendet, ist ein Fehler aufgetreten. Der R\u00fcckkehrcode lautet -3 (ECI_ERR_NO_CICS). Die CICS-Systemkennung lautet {1}." },
		{ Message.CICS_DIED, "Beim Aufruf des Programms {0}, das CICS ECI verwendet, ist ein Fehler aufgetreten. Der R\u00fcckkehrcode lautet -4 (ECI_ERR_CICS_DIED). Die CICS-Systemkennung lautet {1}." },
		{ Message.CICS_TIMEOUT, "Beim Aufruf des Programms {0}, das CICS ECI verwendet, ist ein Fehler aufgetreten. Der R\u00fcckkehrcode lautet -6 (ECI_ERR_RESPONSE_TIMEOUT). Die CICS-Systemkennung lautet {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "Beim Aufruf des Programms {0}, das CICS ECI verwendet, ist ein Fehler aufgetreten. Der R\u00fcckkehrcode lautet -7 (ECI_ERR_TRANSACTION_ABEND). Die CICS-Systemkennung lautet {1}. Der Abbruchcode lautet {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "Beim Aufruf des Programms {0}, das CICS ECI verwendet, ist ein Fehler aufgetreten. Der R\u00fcckkehrcode lautet -22 (ECI_ERR_UNKNOWN_SERVER). Die CICS-Systemkennung lautet {1}." },
		{ Message.CICS_SECURITY_ERROR, "Beim Aufruf des Programms {0}, das CICS ECI verwendet, ist ein Fehler aufgetreten. Der R\u00fcckkehrcode lautet -27 (ECI_ERR_SECURITY_ERROR). Die CICS-Systemkennung lautet {1}." },
		{ Message.CICS_MAX_SYSTEMS, "Beim Aufruf des Programms {0}, das CICS ECI verwendet, ist ein Fehler aufgetreten. Der R\u00fcckkehrcode lautet -28 (ECI_ERR_MAX_SYSTEMS). Die CICS-Systemkennung lautet {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "Beim Aufruf des Programms {0} auf dem System {1} ist f\u00fcr den Benutzer {2} ein Fehler aufgetreten. Vom CICS-ECI-Aufruf wurden der R\u00fcckkehrcode {3} und der Abbruchcode {4} zur\u00fcckgegeben." },
		{ Message.CICS_COMMIT_FAILED, "Beim Aufrufen der CICS-ECI zum Festschreiben einer Arbeitseinheit ist ein Fehler aufgetreten. Der CICS-R\u00fcckkehrcode ist {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "Beim Aufrufen der CICS-ECI f\u00fcr die ROLLBACK-Operation einer Arbeitseinheit ist ein Fehler aufgetreten. Der CICS-R\u00fcckkehrcode ist {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "Im Datenfluss von einer ECI-Anforderung zum CICS-System {0} ist eine Ausnahmebedingung aufgetreten. Die Ausnahmenbedingung lautet: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "Bei der Parameterl\u00e4nge ist ein Fehler aufgetreten. Der Datenstrom weist {0} Parameter auf, und die lokale Funktion verf\u00fcgt \u00fcber {1} Parameter." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "Die maximale Gr\u00f6\u00dfe wird f\u00fcr die Feldgruppe {0} \u00fcberschritten." },
		{ Message.WRONG_NUMBER_OF_PARMS, "Das aufgerufene Programm {0} hat {1} Parameter erwartet, ihm wurden jedoch {2} \u00fcbergeben." },
		{ Message.FUNCTION_NOT_FOUND, "Beim Abrufen der Adresse des Eingangspunkts {0} innerhalb der gemeinsam genutzten Bibliothek {1} ist ein Fehler aufgetreten. Der R\u00fcckkehrcode ist {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "Beim Laden der gemeinsam genutzten Bibliothek {0} ist ein Fehler aufgetreten. Der R\u00fcckkehrcode ist {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "Das aufgerufene Programm ist mit dem R\u00fcckkehrcode {0} fehlgeschlagen." },
		{ Message.REMOTE_PROGRAM_ERROR, "Fehler im Programm {0} auf dem fernen System {3}. Der Fehler ist auf {1} bei {2} aufgetreten. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "Fehler im Programm {0} auf dem fernen System {1}. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "Der Hostname {0} ist ein unbekannter TCP/IP-Hostname." },
		{ Message.SERVERID_IS_INVALID_PORT, "Die ServerID {0} ist keine g\u00fcltige Portnummer." },
		{ Message.TCPIP_SERVER_ERROR, "Der Client hat die Benachrichtigung erhalten, dass der Server das aufgerufene ferne Programm nicht starten kann. Ursachencode: {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "Der Wert f\u00fcr remoteComType fehlt oder ist falsch." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "Die Verbindungseigenschaftendatei {0} kann nicht ge\u00f6ffnet werden." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "Ein Eintrag f\u00fcr das aufgerufene Programm {0} wurde in der Verbindungseigenschaftendatei {1} nicht gefunden." },
		{ Message.AS400_UNKNOWN_HOST, "Der Host {0} wurde nicht gefunden oder ist unbekannt." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "Das Kennwort oder die Benutzer-ID ist f\u00fcr die Herstellung der Verbindung zum System {0} falsch. Fehler: {1}." },
		{ Message.AS400_EXCEPTION_CAUGHT, "AS400Toolbox-Ausf\u00fchrungsfehler {0} beim Aufruf des Programms {2} auf dem System {3}. Fehler: {1}." },
		{ Message.AS400_NO_AUTHORITY, "Beim Remotezugriff auf dem System {0} f\u00fcr den Benutzer {1} ist ein Sicherheitsfehler aufgetreten. Fehler: {2}." },
		{ Message.REMOTE_COMMIT_FAILED, "Eine Festschreibungsfunktion ist auf dem System {0} fehlgeschlagen. Fehler: {1}." },
		{ Message.REMOTE_ROLLBACK_FAILED, "Die ROLLBACK-Funktion ist auf dem System {0} fehlgeschlagen. Fehler: {1}." },
		{ Message.AS400_CONNECTION_ERROR, "Beim Zugriff auf das System {0} ist ein Remoteverbindungsfehler aufgetreten. Fehler: {1}." },
		{ Message.AS400_SERVER_NOT_FOUND, "Fehler bei EGL OS/400-Host-Services. Die erforderlichen Dateien wurden auf dem System {0} nicht gefunden." },
		{ Message.AS400_APPLICATION_ERROR, "Die Ausf\u00fchrungseinheit wurde gestoppt, da auf dem System {0} ein Anwendungsfehler aufgetreten ist, w\u00e4hrend das Programm {1} aufgerufen wurde. Nachricht: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "Die Referenzvariable mit dem Namen {0} ist null." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "Nicht behandelter Fehler. Fehler: {0}." },
		{ Message.DATA_FORMAT_ERROR, "Der Wert der Variable {0} weist das falsche Format auf." },
		{ Message.CONVERSION_ERROR, "Der Wert von {0} vom Typ {1} kann nicht in den Typ {2} konvertiert werden." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "Das Datumsformatmuster {0} ist ung\u00fcltig." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "Das Zeitformatmuster {0} ist ung\u00fcltig." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "Das Zeitmarkenformatmuster {0} ist ung\u00fcltig." },
		{ Message.NULL_REFERENCE, "Ein Nullverweis wurde verwendet." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "Der dynamische Zugriff wird f\u00fcr {0} nicht unterst\u00fctzt." },
		{ Message.DYNAMIC_ACCESS_FAILED, "Ein Feld mit der Kennung {0} wurde in {1} nicht gefunden." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "Das numerische Formatmuster {0} ist ung\u00fcltig." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "Bei der Zuordnung von {0} zu {1} ist ein Fehler aufgetreten. Fehler: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "In der Anweisung SET {0} EMPTY ist ein Fehler aufgetreten. Fehler: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "Fehler {0} beim Aufruf der Methode mit einer Signatur {1}." },
		{ Message.RUN_COMMAND_FAILED, "Bei der Ausf\u00fchrung des Befehls {0} ist ein Fehler aufgetreten.  Fehler: {1}." },
		{ Message.MDY_ERROR, "Die Funktion DateTimeLib.mdy kann die Werte {0}, {1} und {2} nicht in einen Monat, einen Tag und ein Jahr konvertieren." },
		{ Message.NON_NUMERIC_STRING, "{0} hat die nichtnumerische Zeichenfolge {1} \u00fcbergeben. In dem vom L\u00e4ngenargument definierten Teil der Zeichenfolge sind nur Zahlen zul\u00e4ssig." },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} ist mit der Fehlernachricht {1} fehlgeschlagen." },
		{ Message.INT_AS_CHAR_ERROR, "Das Argument f\u00fcr StrLib.intAsChar muss eine Zahl zwischen 0 und 255 sein." },
		{ Message.INVALID_LOB_LENGTH, "{0} ist keine g\u00fcltige L\u00e4nge f\u00fcr {1} mit der Gr\u00f6\u00dfe {2}." },
		{ Message.INVALID_LOB_POSITION, "{0} ist keine g\u00fcltige Position f\u00fcr {1}. Die zugeh\u00f6rige Gr\u00f6\u00dfe ist {2}." },
		{ Message.LOB_ERROR, "Beim Verarbeiten eines BLOB- oder CLOB-Elements ist ein Fehler aufgetreten.  Die Fehlernachricht lautet {0}." },
		{ Message.START_TRANSACTION_ERROR, "VGLib.startTransaction f\u00fcr die Klasse {0} ist fehlgeschlagen. Die Ausnahmebedingung ist {1}." },
		{ Message.INT_AS_UNICODE_ERROR, "Das Argument f\u00fcr StrLib.intAsUnicode muss eine Zahl zwischen 0 und 65535 sein." },
		{ Message.INVALID_ARRAY_SIZE, "Der Gr\u00f6\u00dfenwert {0} ist f\u00fcr die Feldgruppe {1} ung\u00fcltig. Die maximale Gr\u00f6\u00dfe betr\u00e4gt {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "Der Index {0} ist au\u00dferhalb des g\u00fcltigen Bereichs f\u00fcr die Feldgruppe {1}. Die Feldgruppengr\u00f6\u00dfe betr\u00e4gt {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "Ung\u00fcltige Substring-Indizes {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "Das Argument f\u00fcr die Funkton f\u00fcr die Feldgruppe {0} ist ung\u00fcltig." },
		{ Message.INDEX_OUT_OF_BOUNDS, "Der Wert f\u00fcr den Index {0} befindet sich au\u00dferhalb des g\u00fcltigen Bereichs." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} ist eine nicht unterst\u00fctzte Konvertierungstabelle." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "Die Datei csouidpwd.properties k\u00f6nnte nicht gelesen werden. Fehler: {0}." },
		{ Message.CALL_PARMS_TOO_LARGE, "Der Puffer f\u00fcr den Client ist f\u00fcr die an den Aufruf \u00fcbergebene Datenmenge zu klein. Die Gesamtgr\u00f6\u00dfe der \u00fcbergebenen Parameter ist {0} Byte und \u00fcberschreitet die zul\u00e4ssige Maximalgr\u00f6\u00dfe von {1} Byte." },
		{ Message.INVALID_PARMFORM, "Die Verbindungseigenschaft parmForm muss zum Aufrufen des Programms {0} auf COMMPTR gesetzt werden, weil mindestens ein Parameter eine dynamische Feldgruppe ist." },
		{ Message.PARM_PASSING_ERROR, "Bei der \u00dcbergabe von Parametern an das aufgerufene Programm {0} ist ein Fehler aufgetreten. Fehler: {1}." },
		{ Message.CALL_ERROR, "Beim Aufrufen des Programms {0} ist ein Fehler aufgetreten. Fehler: {1}." },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} ist ein nicht unterst\u00fctzter Parametertyp f\u00fcr System i-Serviceprogramme." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} ist ein nicht unterst\u00fctzter R\u00fcckgabetyp f\u00fcr System i-Serviceprogramme." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "Beim Abrufen eines Elements ConnectionFactory ist ein Fehler aufgetreten. Die Ausnahmebedingung ist {0}." },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "Die Interaktion oder die Verbindung kann nicht geschlossen werden. Fehler: {0}." },
		{ Message.ERROR_GETTING_CONNECTION, "Es kann keine Verbindung hergestellt werden. Fehler: {0}." },
		{ Message.ERROR_GETTING_INTERACTION, "Eine Interaktion kann nicht abgerufen werden. Die Ausnahmebedingung lautet: {0}." },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "Ein Interaktionsverb kann nicht festgelegt werden. Die Ausnahmebedingung ist {0}." },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "F\u00fcr die Clientarbeitseinheit kann keine LocalTransaction abgerufen werden. Die Ausnahmebedingung ist {0}." },
		{ Message.ERROR_SETTING_TIMEOUT, "F\u00fcr einen CICSJ2C-Aufruf konnte der Zeitlimitwert nicht festgesetzt werden. Die Ausnahmebedingung ist {0}." },
		{ Message.EXCEPTION_CALLING_CICS, "Bei einem Kommunikationsversuch mit CICS ist ein Fehler aufgetreten. Die Ausnahmebedingung ist {0}." },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "Der Versuch, die ferne CICS-Transaktion auszuf\u00fchren, ist fehlgeschlagen." },
		{ Message.EXCEPTION_CALLING_IMS, "Bei einem Kommunikationsversuch mit IMS ist ein Fehler aufgetreten. Die Ausnahmebedingung ist {0}." },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "Bei einem Kommunikationsversuch mit IMS ist ein Fehler aufgetreten." },
		{ Message.MATH_DOMAIN_ERROR, "{0} ist mit Fehlercode 8 (Dom\u00e4nenfehler) fehlgeschlagen. Ein Argument f\u00fcr die Funktion ist nicht g\u00fcltig." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} ist mit Fehlercode 8 (Dom\u00e4nenfehler) fehlgeschlagen. Das Argument muss einen Wert zwischen -1 und 1 besitzen." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} ist mit Fehlercode 8 (Dom\u00e4nenfehler) fehlgeschlagen. Das zweite Argument muss ungleich null sein." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} ist mit Fehlercode 8 (Dom\u00e4nenfehler) fehlgeschlagen. Das Argument muss gr\u00f6\u00dfer als null sein." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "''MathLib.pow'' ist mit Fehlercode 8 (Dom\u00e4nenfehler) fehlgeschlagen. Wenn der Wert des ersten Arguments null ist, muss der Wert des zweiten Arguments gr\u00f6\u00dfer als null sein." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "''MathLib.pow'' ist mit Fehlercode 8 (Dom\u00e4nenfehler) fehlgeschlagen. Wenn der Wert des ersten Arguments kleiner als null ist, muss das zweite Argument eine ganze Zahl sein." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "''MathLib.sqrt'' ist mit Fehlercode 8 (Dom\u00e4nenfehler) fehlgeschlagen. Der Wert des Arguments muss gr\u00f6\u00dfer-gleich null sein." },
		{ Message.MATH_RANGE_ERROR, "{0} ist mit Fehlercode 12 (Bereichsfehler) fehlgeschlagen." },		
		{ Message.STRING_INDEX_ERROR, "{0} ist mit Fehlercode 8 fehlgeschlagen. Der Index muss zwischen 1 und der L\u00e4nge der Zeichenfolge liegen." },
		{ Message.STRING_LENGTH_ERROR, "{0} ist mit Fehlercode 12 fehlgeschlagen. Die L\u00e4nge muss gr\u00f6\u00dfer als null sein." },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator ist mit dem Fehlercode 16 fehlgeschlagen. Das letzte Byte der Zielzeichenfolge muss ein Leerzeichen oder ein Nullzeichen sein." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} ist mit Fehlercode 20 fehlgeschlagen. Der Index einer Unterzeichenfolge STRING, DBCHAR oder UNICODE muss ungerade sein, damit der Index das erste Byte eines Zeichens identifiziert." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} ist mit Fehlercode 24 fehlgeschlagen. Die L\u00e4nge einer Unterzeichenfolge STRING, DBCHAR oder UNICODE muss gerade sein, um auf eine ganze Zahl von Zeichen zu verweisen." },
		{ Message.NO_DEBUG_LISTENER, "Kontakt zum EGL-Debugger kann nicht unter Verwendung von Hostnamen {0} und Port {1} hergestellt werden. Die Ausnahmebedingung ist {2}." },
		{ Message.DEBUG_LISTENER_PROBLEM, "W\u00e4hrend der Kommunikation mit dem EGL-Debugger unter Verwendung von Hostname {0} und Port {1} ist ein Fehler aufgetreten. Die Ausnahmebedingung ist {2}." },
		{ Message.NOT_DEBUG_MODE, "Von der Verbindung wurde ein Debugaufruf in einem J2EE-Server angegeben. Der Aufruf wurde nicht auf einem J2EE-Server ausgef\u00fchrt, der J2EE-Server befindet sich nicht im Debugmodus oder der J2EE-Server wurde nicht f\u00fcr EGL-Debugging aktiviert." },
		{ Message.LIBRARY_NOT_SPECIFIED, "Von der Verbindung wurde ein Debugaufruf an ein EGL-Empfangsprogramm angegeben, aber nicht die Bibliothekseigenschaft." },
		
		{ Message.FILETYPE_MISSING, "Die Laufzeiteigenschaft vgj.ra.fileName.fileType wurde f\u00fcr die Datei {0} nicht gefunden." },
		{ Message.FILETYPE_INVALID, "Der Wert der Laufzeiteigenschaft vgj.ra.fileName.fileType ist f\u00fcr die Datei {0} ung\u00fcltig." },
		{ Message.INVALID_RECORD_LENGTH, "Das Satzl\u00e4ngenelement muss einen Wert enthalten, der Nicht-Zeichen-Daten an den Elementgrenzen trennt." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "Der Wert in occursItem oder lengthItem ist zu gro\u00df." },
		{ Message.IO_ERROR, "{0}: E/A mit {1} fehlgeschlagen. Ursache: {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: Die ausf\u00fchrbare Anweisung {1} wurde nicht gefunden [sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: Die Ergebnisliste {1} wurde nicht gefunden [sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0}: Fehler [sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "Die Verbindung zu {0} kann nicht hergestellt werden: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "Die Verbindung zu {0} kann nicht hergestellt werden, m\u00f6glicherweise ist die Datenbank-URL nicht korrekt: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "Beim Laden der JDBC-Treiber ist ein Fehler aufgetreten.  Fehler: {0}." },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "Die Ergebnismenge (ResultSet) {0} ist nicht verschiebbar." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "Die Verbindung zur Standarddatenbank kann nicht hergestellt werden. Der Name der Standarddatenbank wurde nicht angegeben." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "Vor einer SQL-E/A-Operation muss eine Datenbankverbindung hergestellt werden." },
		{ Message.SQL_DISCONNECT_ERROR, "Beim Unterbrechen der Verbindung von der Datenbank {0} ist ein Fehler aufgetreten. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "Die Verbindung zur Datenbank {0} kann nicht eingerichtet werden. Die Verbindung ist nicht vorhanden." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "In Funktion SQLLib.{0} ist ein SQL-Fehler aufgetreten: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "In Funktion SQLLib.{0} ist ein Nicht-SQL-Fehler aufgetreten: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "Null wurd aus der Datenbank empfangen, aber die Hostvariable {0} darf keine Nullwerte enthalten." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "F\u00fcr ein erforderliches Feld wurde keine Eingabe empfangen. Wiederholen Sie die Eingabe." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "Datentypfehler in der Eingabe. Wiederholen Sie die Eingabe." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "Die Anzahl der zul\u00e4ssigen signifikanten Ziffern wurde \u00fcberschritten. Wiederholen Sie die Eingabe." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "Die Eingabe liegt au\u00dferhalb des definierten Bereichs von {0} bis {1}. Wiederholen Sie die Eingabe." },
		{ Message.EDIT_VALID_VALUES_ERR, "Die Eingabe befindet sich nicht in der definierten Liste g\u00fcltiger Werte. Wiederholen Sie die Eingabe." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "Das angegebene Datums- und Zeitformat von {0} ist ung\u00fcltig." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "Bei der Minimall\u00e4nge der Eingabe ist ein Fehler aufgetreten. Wiederholen Sie die Eingabe." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "Bei der Maximall\u00e4nge der Eingabe ist ein Fehler aufgetreten. Wiederholen Sie die Eingabe." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "Bei der Tabellenbearbeitung ist ein G\u00fcltigkeitsfehler aufgetreten. Wiederholen Sie die Eingabe." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "Bei der Eingabe ist ein Moduluspr\u00fcffehler aufgetreten. Wiederholen Sie die Eingabe." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "Die Eingabe ist f\u00fcr das definierte Datums- oder Zeitformat {0} ung\u00fcltig." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "Die Eingabe f\u00fcr das Boolesche Feld ist ung\u00fcltig." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "Der eingegebene Wert ist ung\u00fcltig, weil er nicht mit dem festgelegten Muster \u00fcbereinstimmt." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "Die Editiertabelle {0} ist f\u00fcr {1} nicht definiert." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "Die hexadezimalen Daten sind ung\u00fcltig." },
		{ Message.EDIT_VALIDATION_ERR, "Es ist ein Seitenauswertungsfehler aufgetreten.  Fehler: {0}." },
		{ Message.EDIT_INPUT_ERR, "Bei der Syntaxanalyse des Eingabewerts ist ein Fehler aufgetreten."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "Beim Formatieren des Werts f\u00fcr die Anzeige ist ein Fehler aufgetreten: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "Eingabedaten mit SO/SI-Zeichen sind f\u00fcr die definierte Elementl\u00e4nge zu lang."},
		
		{ Message.ACTION_REQUEST_ERROR, "Die Funktion J2EELib RequestAttr ist mit dem Schl\u00fcssel {0} fehlgeschlagen. Fehler: {1}." },
		{ Message.ACTION_SESSION_ERROR, "Die Funktion J2EELib SessionAttr ist mit dem Schl\u00fcssel {0} fehlgeschlagen. Fehler: {1}." },
		{ Message.ACTION_APPLICATION_ERROR, "Die Funktion J2EELib ApplicationAttr ist mit Schl\u00fcssel {0} fehlgeschlagen. Fehler: {1}." },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib darf nur in der J2EE-Umgebung verwendet werden." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "Die Funktion PortalLib PortletSessionAttr ist mit Schl\u00fcssel {0} fehlgeschlagen. Fehler: {1}." },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode ist fehlgeschlagen. Fehler: {0}." },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState ist fehlgeschlagen. Fehler: {0}." },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "Unzul\u00e4ssiger Versuch, den Portlet-Modus w\u00e4hrend Wiedergabeanforderung zu \u00e4ndern." },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "Unzul\u00e4ssiger Versuch, den Portlet-Fensterstatus w\u00e4hrend Wiedergabeanforderung zu \u00e4ndern." },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "PortletSession konnte nicht abgerufen werden" }, 
		{ Message.PORTALLIB_INVALIDKEY, "Der Funktion {0} wurde ein ung\u00fcltiger Schl\u00fcssel \u00fcbergeben." }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "PortletRequest konnte nicht abgerufen werden" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "Die Funktion PortalLib resetPreferenceValue ist mit Schl\u00fcssel {0} fehlgeschlagen. Fehler: {1}." },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "Die Funktion PortalLib savePreferences ist fehlgeschlagen. Fehler: {0}." },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib konnte f\u00fcr Schl\u00fcssel {0} keine Einstellung setzen. Fehler: {1}." }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib konnte f\u00fcr Schl\u00fcssel {0} keine Einstellung abrufen. Fehler: {1}." },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "Auf den Credential Vault Service (Vault f\u00fcr Berechtigungsnachweise) konnte nicht zugegriffen werden. Fehler: {0}." },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "Auf den Credential (Berechtigungsnachweis) in Slot {0} konnte nicht zugegriffen werden. Fehler: {1}." },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "Credential Vault (Vault f\u00fcr Berechtigungsnachweise) konnte im Benutzeradressbereich nicht erstellt werden. Fehler: {0}." },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "Credential Vault (Vault f\u00fcr Berechtigungsnachweise) konnte im Benutzeradressbereich nicht gel\u00f6scht werden. Fehler: {0}." },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "Credential-Werte (Werte f\u00fcr Berechtigungsnachweise) konnte nicht gesetzt werden. Fehler: {0}." },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} ist fehlgeschlagen. Das Aufrufen einer Methode oder das Zugreifen auf ein Feld mit dem Namen {1} hat einen nicht behandelten Fehler verursacht. Die Fehlernachricht lautet {2}." },
		{ Message.JAVALIB_NULL_ID, "{0} ist fehlgeschlagen. {1} ist keine Kennung, oder es ist die Kennung eines Nullobjekts." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} ist fehlgeschlagen. Eine allgemein zug\u00e4ngliche Methode, ein Feld oder eine Klasse mit dem Namen {1} ist nicht vorhanden oder kann nicht geladen werden, oder die Anzahl bzw. die Typen der Parameter sind falsch. Die Fehlernachricht lautet {2}." },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} ist fehlgeschlagen. Der Typ eines Werts in EGL entspricht nicht dem in Java f\u00fcr {1} erwarteten Typ. Die Fehlernachricht lautet {2}." },
		{ Message.JAVALIB_NULL_RETURNED, "{0} ist fehlgeschlagen. Das Ziel ist eine Methode, die null zur\u00fcckgab, eine Methode, die keinen Wert zur\u00fcckgibt oder ein Feld, dessen Wert null ist." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} ist fehlgeschlagen. Die Klasse {1} eines Nullarguments konnte nicht geladen werden. Die Fehlernachricht lautet {2}." },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} ist fehlgeschlagen. Es konnten keine Informationen zur Methode oder dem Feld mit dem Namen {1} abgerufen werden, oder es wurde versucht, den Wert eines als final deklarierten Felds festzulegen. Die Fehlernachricht lautet {2}." },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} ist fehlgeschlagen. {1} ist eine Schnittstelle oder eine abstrakte Klasse, daher kann die Konstruktorfunktion nicht aufgerufen werden." },
		{ Message.JAVALIB_NOT_STATIC, "{0} ist fehlgeschlagen. Die Methode oder das Feld {1} ist nicht statisch. Statt eines Klassennamens muss eine Kennung verwendet werden." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "Das Aktionsfeld {0} ist nicht vorhanden." },
		{ Message.CUI_E_ARRAY_FULL, "Es kann keine weitere Zeile eingef\u00fcgt werden, da die Eingabefeldgruppe voll ist." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "Die Feldgruppe {0} wurde nicht gefunden." },
		{ Message.CUI_E_ASSIGN_RESULT, "Zuordnung zur Ergebnisvariablen der Systemanfragen ist fehlgeschlagen." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "Die Gr\u00f6\u00dfe {0} f\u00fcr die Anzeigefeldgruppe ist falsch."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "Die DrawBox-Parameter liegen au\u00dferhalb des g\u00fcltigen Bereichs." },
		{ Message.CUI_E_BAD_COORDINATES, "Die Anzeigekoordinaten befinden sich au\u00dferhalb der Fenstergrenzen." },
		{ Message.CUI_E_BAD_KEYNAME, "Fehlerhafter Schl\u00fcsselname ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "Diese Bearbeitungsfunktion kann nicht verwendet werden, weil ein Bild vorhanden ist." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "Das Fenster ''{0}'' kann nicht gefunden werden." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "Die neue Fensterwerte position[{0},{1}]/dimension[{2},{3}] sind ung\u00fcltig." },
		{ Message.CUI_E_CMDSTACK_SYNC, "Der Befehlspuffer ist nicht mehr synchron." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "Die Konsol-UI-Bibliothek ist nicht initialisiert." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "Unzul\u00e4ssiger Feldtyp f\u00fcr Konstrukt." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "ConstructQuery darf nicht mit einer Variablenliste aufgerufen werden." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "Ein unsichtbarer Men\u00fcpunkt kann nicht inaktiviert werden." },
		{ Message.CUI_E_EDIT_FAILED, "Der Editiervorgang ist fehlgeschlagen." },
		{ Message.CUI_E_EXEC_HOTKEY, "Beim Ausf\u00fchren der Hot-Key-Aktion ist ein Fehler aufgetreten." },
		{ Message.CUI_E_EXIT_NO_CMD, "Es ist kein aktiver Befehl vorhanden, der beendet werden kann." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "Es ist kein aktiver Befehl vorhanden, der fortgesetzt werden kann." },
		{ Message.CUI_E_FATALERROR, "Schwer wiegender Fehler: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "Das Feld {0} ist nicht vorhanden." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "Das Feld {0} f\u00fcr Anzeigefeldgruppe ist keine Feldgruppe." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "Das Feld {0} wurde nicht gefunden." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "Konsolfeld kann nicht ohne Fenster erstellt werden." },
		{ Message.CUI_E_FIELD_COUNT, "Abweichung bei der Anzahl der Feldgruppenfelder." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "Das Formular {0} ist nicht vorhanden." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "Das Formular {0} passt nicht in das Fenster {1}." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "Die Feldlisten stimmen nicht \u00fcberein." },
		{ Message.CUI_E_FORM_IN_USE, "Das Formular {0} ist belegt." },
		{ Message.CUI_E_FORM_NAME_USED, "Das Formular mit dem Namen {0} ist bereits vorhanden." },
		{ Message.CUI_E_FORM_NOT_OPEN, "Das Formular {0} ist nicht ge\u00f6ffnet." },
		{ Message.CUI_E_FORM_NO_WINDOW, "Konsolformular (ConsoleForm) kann ohne Fenster nicht erstellt werden." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "KeyObject.getChar() kann nicht f\u00fcr virtuelle Schl\u00fcssel verwendet werden." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "KeyObject.getCookedChar() kann nicht f\u00fcr virtuelle Schl\u00fcssel verwendet werden." },
		{ Message.CUI_E_INTERNAL, "INTERNER FEHLER: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "Ein Unterbrechungssignal (INTERRUPT) wurde empfangen." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "Es kann keinen unsichtbaren Men\u00fcpunkt ohne Direktaufruf geben." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "Konsolkennsatz (ConsoleLabel) kann ohne Fenster nicht erstellt werden." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "Der Men\u00fcpunkt {0} passt nicht ins Fenster." },
		{ Message.CUI_E_MISSING_ITEM, "Der Men\u00fcpunkt {0} ist nicht vorhanden." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "Konflikt bei mnemonischen Zeichen in Men\u00fc (Schl\u00fcssel={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "Es gibt kein aktives Formular." },
		{ Message.CUI_E_NO_EDITOR, "Es wurde kein BLOB-Editor angegeben." },
		{ Message.CUI_E_NO_HELP_FILE, "Es wurde keine Hilfedatei angegeben." },
		{ Message.CUI_E_NO_HELP_MSG, "Es wurde keine Hilfenachricht angegeben." },
		{ Message.CUI_E_NO_NUMPAGES, "Das Men\u00fc ist nicht formatiert." },
		{ Message.CUI_E_NO_SCREENARRAY, "Es ist keine aktive Anzeigefeldgruppe vorhanden." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "Es gibt keine sichtbaren Men\u00fcpunkte." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "Der Name f\u00fcr das neue Fenster war leer." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "Versuch, ein Nullfenster zu \u00f6ffnen." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "In der Systemanfrage ist eine Ausnahmebedingung aufgetreten." },
		{ Message.CUI_E_QUIT_RECEIVED, "Ein Abbruchsignal wurde empfangen." },
		{ Message.CUI_E_SCROLL_FAILED, "Im Men\u00fc kann nicht zum aktuellen Element gebl\u00e4ttert werden." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "Unbekanntes Attribut ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "Im Feld {0} ist ein Fehler aufgetreten." },
		{ Message.CUI_E_VAR_LIST_SHORT, "Es wurden nicht genug Variablen angegeben." },
		{ Message.CUI_E_WINDOW_NAME_USED, "Der Fenstername {0} wird bereits verwendet." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "Die Fenstergr\u00f6\u00dfe ist zu gering f\u00fcr die Hilfetextanzeige." },
		{ Message.CUI_E_VALID_VALUES, "Der angegebene Wert ist kein g\u00fcltiger Wert." },
		{ Message.CUI_W_NO_MORE_FIELDS, "In der gew\u00e4hlten Richtung sind keine weiteren Felder vorhanden." },
		{ Message.CUI_W_NO_MORE_ROWS, "In der gew\u00e4hlten Richtung sind keine weiteren Zeilen vorhanden." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "Der Inhalt der Anzeigefeldgruppe {0} ist ung\u00fcltig." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "Die Anzeigefeldgruppe {0} darf das Segmentfeld {1} nicht enthalten."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "Die Anzeigefeldgruppe {0} ist inkompatibel mit der Datenfeldgruppe." },
		{ Message.CUI_E_FIELD_NAME_DUP, "Der Feldname {0} wird mehrfach verwendet." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "Die Konsolenfeldl\u00e4nge {0} ist ung\u00fcltig." },
		{ Message.CUI_E_LABEL_NOT_FIT, "Der Kennsatz bei [{0}, {1}] passt nicht in den verf\u00fcgbaren Platz." },
		{ Message.CUI_E_FIELD_NOT_FIT, "Das Feldsegment {0} bei ({1}, {2}) passt nicht in den verf\u00fcgbaren Platz." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"Die Zeichenfolge f\u00fcr die Systemanfrage ist f\u00fcr das aktive Fenster zu lang."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"Die OpenUI-Feldgruppenargumente sind ung\u00fcltig."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "Die OpenUI-Feldargumente sind ung\u00fcltig."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "An eine Systemanfrageanweisung kann nur eine einzige Variable gebunden werden." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "Die Datenbindung f\u00fcr das Konsolenfeld {0} kann nicht bestimmt werden." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "Warnung: NUL-Zeichen wurden in CLOB-Daten gefunden" },
		{ Message.CUI_I_STR_WINDOWTITLE , "EGL-Konsolenfenster" },
		{ Message.CUI_E_MISSING_FORMAT , "Das Feld {0} weist kein Formatobjekt auf." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "Die zwei Eintr\u00e4ge waren nicht identisch -- versuchen Sie es erneut" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "Bitte zur \u00dcberpr\u00fcfung erneut eingeben" },
		{ Message.CUI_I_STR_HELP,"Hilfe"},
		{ Message.CUI_I_STR_RESUME,"Wieder aufnehmen"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"Beendet diese Hilfesitzung."},
		{ Message.CUI_I_STR_SCROLL , "Bl\u00e4ttern" },
		{ Message.CUI_I_STR_LAST_PAGE, "Sie haben das Ende des Hilfetexts erreicht. Dr\u00fccken Sie zum Fortfahren die Eingabetaste."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "Zeigt die n\u00e4chste Seite des Hilfetexts an."},
		{ Message.CUI_I_STR_SELECT , "AUSW\u00c4HLEN"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "Beim Einf\u00fcgen der ersten Zeile in eine leere Feldgruppe ist ein Fehler aufgetreten."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 nicht implementiert."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "INTERN: F25-64 nicht implementiert" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "Mehrere Exemplare von CursesCanvas d\u00fcrfen nicht vorhanden sein" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas nicht initialisiert" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas ist zu klein"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "Anzeigefelder nach Namen nicht implementiert."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "Mindesteingabe {0} erforderlich. Wiederholen Sie die Eingabe." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "Maximaleingabe {0} \u00fcberschritten. Wiederholen Sie die Eingabe." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "Scriptdatei ''{0}'' kann nicht ge\u00f6ffnet werden." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "Scriptdatei kann nicht gelesen werden."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "Die Eigenschaft automation.scenario ''{0}'' ist kein Verzeichnis."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "Fehlerhafte <click>-Anweisung im Wiedergabescript."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "Automatisierungseigenschaft ''{0}'' kann nicht abgerufen werden."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "Ung\u00fcltiger panic-Schl\u00fcsselname ''{0}''."},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "Ausnahmebedingung in <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "Snapshot-Datei ''{0}'' kann nicht ge\u00f6ffnet werden."},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "Die Eigenschaftengruppe f\u00fcr automation.scriptdir ''{0}'' ist nicht vorhanden."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "Die Eigenschaftengruppe f\u00fcr das automation.scenario-Verzeichnis ''{0}'' kann nicht erstellt werden."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "Ung\u00fcltiger Snapshot-Schl\u00fcsselname ''{0}''."},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "Vergleich ok."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "Die Verwendung von Anzeige-E/A-Operationen ist w\u00e4hrend der Ausf\u00fchrung im RCP-Modus unzul\u00e4ssig."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "Ein Nachricht mit der ID {0} ist in der Nachrichtentabelle {1} nicht vorhanden." },
		{ Message.MSG_TBL_LOAD_ERR, "Die Nachrichtentabellendatei {0} kann nicht geladen werden." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "F\u00fcr den VGUIRecord {0} ist keine Benutzernachrichtentabelle definiert." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "Das Feld ''{0}'' an Position ({1},{2}) befindet sich nicht innerhalb des Formulars." },
		{ Message.TUI_E_FIELD_OVERLAP, "Feld ''{0}'' \u00fcberschneidet ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "Interner Fehler: Formulargruppe kann nicht ermittelt werden." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "Das Formular ''{0}'' passt in keinen Gleitbereich." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "Die Koordinaten f\u00fcr das Feld ''{0}'' sind ung\u00fcltig." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "Die Druck-Zuordnung kann nicht abgerufen werden." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "Es ist keine geeignete Druckeinheitengr\u00f6\u00dfe vorhanden." },
		{ Message.TUI_E_NO_DISPLAY, "Es ist keine Bildschirmeinheit f\u00fcr Formulare vorhanden." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "F\u00fcr die angezeigten Formulare ist keine kompatible Einheitengr\u00f6\u00dfe vorhanden." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "Die Hilfeformularklasse ''{0}'' ist nicht vorhanden." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "Unbekanntes Attribut ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "Der im g\u00fcltigen Werteattribut angegebene Wert ist nicht korrekt und konnte nicht syntaktisch analysiert werden." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "Hilfeformular ''{0}'' kann nicht erstellt werden." },
		{ Message.TUI_E_INTERNAL, "INTERNER FEHLER: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "Es sind keine Drucker verf\u00fcgbar." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "Es ist kein Standarddrucker vorhanden." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "Drucker ''{0}'' wurde nicht gefunden.\nDiese Drucker sind verf\u00fcgbar:\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "Beim Laden der Nachricht ''{0}'' ist ein Fehler aufgetreten." },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "Der Inhalt von {0} kann nicht als Feld verwendet werden." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "Drucker ''{0}'' wurde nicht gefunden" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "Programm {0} erwartete Textformat {1}, es erhielt jedoch Textformat {2} bei einer show-Anweisung." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "N\u00e4chste/s/r" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "Seite {0} von {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "Vorherige/s/r" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "Drucken" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "Druckvoranzeige - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "Speichern" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "PrintJob - {0} sichern " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "Fehler beim Drucken in Datei: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "Fehler beim Drucken auf Drucker: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "EZEMNO festlegen" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "Feld ''{0}'' \u00fcberpr\u00fcfen" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "textform \u00fcberpr\u00fcfen" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "textform \u00fcberpr\u00fcfen - Validator-Funktion ''{0}'' wird ausgef\u00fchrt" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "logwriter kann nicht erstellt werden." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "Protokollierungsparameter ''{0}'' kann nach dem Start nicht gesetzt werden." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "Logdir ''{0}'' ist nicht vorhanden." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "In logdir ''{0}'' kann nicht geschrieben werden." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "logfile ''{0}'' kann nicht erstellt werden." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "In logfile ''{0}'' kann nicht geschrieben werden." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Beim Laden des Service f\u00fcr Component/ExternalService {0} ist ein Fehler aufgetreten." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "Beim Herstellen einer Verbindung zur Web-Service-Operation ''{0}'' ist ein Fehler aufgetreten.  {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "Beim Abrufen der Operation ''{0}'' von der WSDL-Datei ''{1}'' ist ein Fehler aufgetreten." },
		{ Message.SOA_E_WS_MALFORMED_URL, "Die Ziel-URL f\u00fcr die Web-Service-Operation {1} ist ung\u00fcltig. URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "Beim Laden des Service {0} ist ein Fehler aufgetreten. Fehler: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "Bei dem Versuch, einen Web-Service zu laden, ist ein Fehler aufgetreten. Der WSDL-Port f\u00fcr den externen Service {0} konnte nicht aufgel\u00f6st werden." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "Die Komponente {0} verf\u00fcgt nicht \u00fcber die Eigenschaft {1}, die f\u00fcr die Serviceimplementierung erforderlich ist." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "Der Serviceverweis ''{0}'' fehlt oder enth\u00e4lt keinen Zielwert." },
		{ Message.SOA_E_MISSING_BINDING, "Service-Bindung ''{0}'' ist nicht im Implementierungsdeskriptor ''{1}'' vorhanden." },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "Bei dem Versuch, den Datensatz ''{0}'' in eine SOAP-Nachricht umzuwandeln, ist ein Fehler aufgetreten.  Das Feld ''{1}'' konnte im Datensatz nicht gefunden werden." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "Bei dem Versuch, ''{0}'' in eine SOAP-Nachricht umzuwandeln, ist ein Fehler aufgetreten."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "Bei der Verarbeitung einer ankommenden Nachricht von einem Web-Service ist ein Fehler aufgetreten. Der Java-Typ ist nicht kompatibel mit dem EGL-Typ." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "Bei der Verarbeitung einer abgehenden Nachricht f\u00fcr einen Web-Service ist ein Fehler aufgetreten. Der EGL-Typ ist nicht kompatibel mit dem Java-Typ." },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "Der Datensatz ''{0}'' kann nicht initialisiert werden." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "Der Wert ''{0}'' kann nicht in einen Kalenderwert umgewandelt werden." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "Der Wert ''{0}'' kann nicht in einen Booleschen Wert umgewandelt werden." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "Der Wert ''{0}'' kann nicht in ein Byte umgewandelt werden." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "Der Wert ''{0}'' kann nicht in ein Kurzzeichen umgewandelt werden." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "Der Wert ''{0}'' kann nicht in eine URI umgewandelt werden." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "Der EGL-Typ wird als Web-Service-Parameter nicht unterst\u00fctzt." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "Bei dem Versuch, eine Datensatzfeldgruppe zu erstellen, ist ein Fehler aufgetreten. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "Die Methode {0} wurde im Service {1} nicht gefunden." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "Der Service ist kein Web-Service." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "Bei dem Versuch, Funktion {0} f\u00fcr Web-Service {1} aufzurufen, ist ein Fehler aufgetreten." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "Bei dem Versuch, Funktion {0} f\u00fcr EGL-Service {1} aufzurufen, ist ein Fehler aufgetreten." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "Bei dem Versuch, unter Verwendung von {2}:{3} die Funktion {0} f\u00fcr EGL-Service {1} aufzurufen, ist ein Fehler aufgetreten." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "Der Service ist kein TCP/IP-Service." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "Bei dem Versuch, Funktion {0} f\u00fcr den Eingangspunkt {1} aufzurufen, ist ein Fehler aufgetreten." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "Bei dem Versuch, die Servicebindungsdatei {0} zu importieren, ist ein Fehler aufgetreten. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "Bei dem Versuch, Funktion {0} f\u00fcr CICS-Service {1} aufzurufen, ist ein Fehler aufgetreten. Fehlercode: {2}, Nachricht: {3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "Bei dem Versuch, Funktion {0} f\u00fcr iSeries-Service {1} aufzurufen, ist ein Fehler aufgetreten. Fehlercode: {2}, Nachricht: {3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "Der Service ist kein CICS-Service." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "F\u00fcr den fernen Service {0} (Datum {1}, Zeit {2}) auf dem System {3} ist ein Fehler aufgetreten." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "Im fernen Service {0} auf dem System {1} ist ein Fehler aufgetreten." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "Die Ausf\u00fchrungseinheit wurde auf Grund eines Anwendungsfehlers auf dem System {0} bei dem Versuch zum Aufrufen des Service {1} beendet. Nachricht: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "AS400Toolbox-Ausf\u00fchrungsfehler: {0}, {1} beim Aufrufen des Service {2} auf dem System {3}." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "Nicht unterst\u00fctztes Service-Client-Binding. {0} wurde f\u00fcr WebSphere generiert, wird jedoch aus einer Umgebung ohne J2EE aufgerufen. Nehmen Sie eine erneute Generierung in einem J2EE-Projekt vor." },
		{ Message.SOA_E_USER_ID_NOT_SET, "Die ID und das Kennwort des fernen Benutzers m\u00fcssen vor dem Aufruf von WebService: {0}, Funktion: {1} festgelegt werden." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "Beim Aufruf eines Services trat eine Ausnahmebedingung auf." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "Bei der Kommunikation mit dem Service trat eine Ausnahmebedingung auf. URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "Beim REST-Serviceaufruf trat eine Ausnahmebedingung auf. Binding: {0}, Operation: {0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "Beim SOAP-Serviceaufruf trat eine Ausnahmebedingung auf. Binding: {0}, Service: {1}, Port: {2}, WSDL-Position: {3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "Bei der Konvertierung aus JSON trat eine Ausnahmebedingung auf. Parameter: {0}, JSON: {1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "Bei der Konvertierung in JSON trat eine Ausnahmebedingung auf. Parameter: {0}, Wert: {1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "Es wurde kein REST-RPC-Service gefunden. URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "Vom Service wurde keine Antwort empfangen. URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "Die Anforderung konnte in keinen Serviceaufruf konvertiert werden. Die empfangene Anforderung war ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "Der Serviceaufruf hat das zul\u00e4ssige Zeitlimit \u00fcberschritten. Ausnahmebedingung: Verbindung - Zeitlimitfehler beim Lesen. URL: {0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "Der Service ist kein REST-Service." },
		{ Message.SOA_E_REST_SERVICE, "Der Aufruf f\u00fcr den REST-Serviceaufruf ist fehlgeschlagen. Binding:{0}, Operation:{1}, HTTP-Methode:{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "Bei der Konvertierung der Daten in EGL-Parameter ist eine Ausnahme aufgetreten. Binding:{0}, zu konvertierende Daten {1}, Ausnahme:{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "Ein REST-Serviceaufruf wurde auf einer Nicht-REST-Servicereferenz vorgenommen. Servicereferenz: {0}, Operation {1}, HTTP-Methode: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "Bei der Konvertierung aus XML ist eine Ausnahme aufgetreten. Das erforderliche Element {0} fehlt." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "Bei der Konvertierung aus XML ist eine Ausnahme aufgetreten. Parameter:{0}, XML:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "Bei der Konvertierung in XML ist eine Ausnahme aufgetreten. Parameter: {0}, Wert: {1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "Bei der Konvertierung von {0} aus XML ist eine XML-Parsing-Ausnahme aufgetreten." },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "Bei der Konvertierung von {0} in XML ist eine XML-Konvertierungsausnahme aufgetreten." },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "Die f\u00fcr den Aufruf des Service verwendete URL ''{0}'' ist ung\u00fcltig. Sie enth\u00e4lt nicht das Protokoll ''http://''." },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "Die f\u00fcr den Aufruf des Service verwendete URL ''{0}'' ist ung\u00fcltig. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "Die f\u00fcr den Aufruf des Service verwendete URL ist leer. Geben Sie eine URL an, die auf den Service verweist." },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "Der Bericht konnte \u00fcber die Verbindung {0} nicht gef\u00fcllt werden."},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "Der Bericht konnte mit der SQL-Anweisung {0} nicht gef\u00fcllt werden."},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "Der Bericht konnte mit der dynamischen Feldgruppe {0} nicht gef\u00fcllt werden."},
		{ Message.REPORT_E_FILL_ERROR , "Der Bericht {0} konnte nicht gef\u00fcllt werden."},
		{ Message.REPORT_E_EXPORT_ERROR, "Der Bericht {0} konnte nicht exportiert werden." },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "Die Umwandlung zwischen dem EGL-Typ {0} und dem Java-Typ {1} konnte nicht ausgef\u00fchrt werden." },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "Die Umwandlung zwischen dem Java-Typ {0} und dem EGL-Typ {1} konnte nicht ausgef\u00fchrt werden." },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "Der Berichtsparameter konnte nicht hinzugef\u00fcgt werden." },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "Die Berichtsparameterliste konnte nicht zur\u00fcckgesetzt werden." },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "Falscher Feldname {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "Falscher Unterberichtsname {0}" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "Bei der Berichterstellung wird ein nicht unterst\u00fctzter Typ verwendet." },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "Komplexe Typen k\u00f6nnen nicht an diese Funktion \u00fcbergeben werden." },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "Der Designdateiname muss vor dem Aufruf der Funktion getParameterDefaultValue() gesetzt sein." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "Der Standardwert f\u00fcr den Parameter {0} konnte nicht abgerufen werden. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "Kein Berichtsparameter mit dem Namen {0} vorhanden." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "Der Designdateiname muss vor dem Aufruf der Funktionen createReportFromDesign() oder createDocument() gesetzt sein." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "Der Dokumentdateiname muss vor dem Aufruf der Funktion createReportFromDocument() gesetzt sein." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "Berichtsdokumentdatei konnte nicht erstellt werden. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "Bericht konnte nicht aus der Designdatei erstellt werden. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "Bericht konnte nicht aus der Dokumentdatei erstellt werden. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "Das f\u00fcr einen BirtReport angegebene Handler-Objekt muss den Typ BirtHandler haben." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "Element {0} ist im Berichtsdesign nicht vorhanden, oder es hat nicht den angegebenen Typ." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "{0}-Zeilennummer {1} ist in der Tabelle {2} nicht vorhanden." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "Die Zeilennummer {0} ist im Rasterelement {1} nicht vorhanden." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "Gruppe {0} ist in der Tabelle {1} nicht vorhanden." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "{0}-Zeilennummer {1} ist in Gruppe {2} der Tabelle {3} nicht vorhanden." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "Die Spaltennummer {0} ist in der Zeile {1} in der Tabelle {2} nicht vorhanden." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "Die Spaltennummer {0} ist im Raster {1} nicht vorhanden." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "Spaltennummer {0} ist in der {1}-Zeile in der Gruppe {2} der Tabelle {3} nicht vorhanden." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "Die Eigenschaft ''RowType'' muss f\u00fcr eine Ereignishandlerfunktion f\u00fcr Zeile(n) oder Zelle(n) in der Tabelle {0} angegeben werden." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "Java-Typ {0} kann nicht in einen EGL-Typ konvertiert werden." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "EGL-Typ {0} kann nicht in Java-Typ konvertiert werden." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "Der Datensatz {0} ist im Berichtsdesign nicht vorhanden." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "Der Datensatz {0} befindet sich in einem auf Scripts basierenden Satz. Es wurde jedoch keiner der folgenden eventTypes bearbeitet: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "Die Datenquelle {0} ist im Berichtsdesign nicht vorhanden." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "Die Datenquelle {0} befindet sich in einer auf Scripts basierenden Datenquelle. Es wurde jedoch keiner der folgenden eventTypes bearbeitet: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "Die Spaltennummer {0} ist im Datensatz {1} nicht vorhanden." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "Beim Abruf der Spalte {0} aus dem Datensatz {1} ist eine Ausnahmebedingung aufgetreten. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "Bei der Festlegung der Spalten {0} des auf Scripts basierenden Datensatzes {1} ist eine Ausnahmebedingung aufgetreten. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "Beim Abruf der Spaltenbindung {0} ist eine Ausnahmebedingung aufgetreten. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "Die Eigenschaft vgj.defaultI4GLNativeLibrary ist nicht angegeben." },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "Das Laden der Bibliothek {0} ist fehlgeschlagen {1}." },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "Die zur\u00fcckgegebenen Parameter stimmen nicht mit der Funktion \u00fcberein." },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "Es konnte kein Speicher reserviert werden."},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "Die Umwandlung zwischen den Typen konnte nicht ausgef\u00fchrt werden."},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "Ung\u00fcltige Genauigkeit f\u00fcr Datum/Zeit oder Intervall"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "Die Hostzeichenvariable ist zu kurz f\u00fcr die Daten."},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "Die Funktion wurde in der Symboltabelle nicht gefunden."},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "In diesem Kontext muss ein Datentyp TEXT oder BYTE bereitgestellt werden."},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "Der Wert im Stack konnte in keinen Wertetyp konvertiert werden."},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "Der Wert im Stack konnte nicht in ANY konvertiert werden."},
		{ Message.CINTERFACE_E_POP_ERROR, "Aus dem Stack konnte kein Wert vom Typ {0} abgerufen werden."},
		{ Message.CINTERFACE_E_PUSH_ERROR, "In den Stack konnte kein Wert vom Typ {1} geschrieben werden."},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "Nichts zum Einf\u00fcgen/Entfernen vorhanden."},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "Die Zeigereinheit konnte nicht aus dem Stack entfernt werden."},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "Der Stack ist leer."},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "Die Zeigereinheit konnte nicht kopiert werden."},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "Ein Nullverweis wurde in den Stapel eingef\u00fcgt."},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "''Any'' konnte nicht in den Stapel eingef\u00fcgt werden."},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "Das Stack-Element konnte nicht dem Typ ''Any'' zugeordnet werden."},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "Abweichung beim R\u00fcckgabetyp"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "Abweichung beim Parametertyp"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "Die EGL-Quellendatei {0} konnte nicht gefunden werden.  Stattdessen wird generierter Code ausgef\u00fchrt." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "Die EGL-Quellendatei f\u00fcr die Webtransaktion mit dem Namen {0} wurde nicht gefunden." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "In Feld \"{0}\" ist bei der Anzeige von Formular \"{1}\" folgender Formatierungsfehler aufgetreten:" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\nDas erwartete interne Format des Felds ist \"{1}\". \u00dcberpr\u00fcfen Sie die Datumsformateigenschaften in den EGL-Java-Laufzeiteigenschaften, die die Datenformate beeinflussen." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\nDas Anzeigeformat des Felds ist \"{1}\". \u00dcberpr\u00fcfen Sie die Eigenschaft \"{2}\" im Formularfeld." },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "Programm {0} kann nicht als Webtransaktion ausgef\u00fchrt werden." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "Der Webtransaktion wurde Eingabe-UI-Datensatz {0} \u00fcbergeben, sie wurde jedoch mit Eingabe-UI-Datensatz {1} definiert." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "Die Eingabe f\u00fcr das Boolesche Feld ist ung\u00fcltig." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "In Programm {0} trat aufgrund von Inaktivit\u00e4t eine Zeitlimit\u00fcberschreitung aus." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "Benutzerschnittstellensatz {0} enth\u00e4lt zuviele Daten, die an das Gateway-Servlet gesendet werden sollen." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "Das Programm konnte keine Daten vom Gateway-Servlet pr\u00fcfen.  Die Datenkennung lautet {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "Array-Wrapper {0} kann nicht \u00fcber die maximale Gr\u00f6\u00dfe hinaus erweitert werden. Der Fehler trat in Methode {1} auf." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} ist ein ung\u00fcltiger Index f\u00fcr Array-Wrapper {1}. Maximale Gr\u00f6\u00dfe: {2}. Aktuelle Gr\u00f6\u00dfe: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} ist keine g\u00fcltige Maximalgr\u00f6\u00dfe f\u00fcr Array-Wrapper {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} ist ein ung\u00fcltiger Objekttyp, der einem Array-Wrapper des Typs {1} hinzugef\u00fcgt werden soll." },
		
		{ Message.IMS_HOST_ABORT, "Abbruchpaket wurde vom fernen Host empfangen."},
		{ Message.IMS_HOST_TCPIP_ERROR, "TCPIP-Fehler trat beim fernen Host auf. Abschnitt: {0}, TCPIP-Operation: {1}, TCPIP-RETCODE: {2}, TCPIP-ERRNO: {3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "Fehler beim Host aufgetreten beim Aufruf von: {0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "Das falsche Antwortpaket wurde vom Host empfangen. Erwartet: {0}, Empfangen: {1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "Beim Ausf\u00fchren der gespeicherten Prozedur ist ein Ein-/Ausgabefehler aufgetreten. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "Beim Ausf\u00fchren der gespeicherten Prozedur ist ein SQL-Fehler aufgetreten. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "Fehler beim fernen Host beim Ausf\u00fchren von:{0} RETCODE:{1} DLI-Proxy-Job-ID:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "Beim fernen Host ist ein DLI-Fehler aufgetreten. DLI-Funktion:{0} AIB-return:0x{1} AIB-reason:0x{2} statusCode:{3} DLI-Proxy-Job-ID:{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "Beim fernen Host ist ein DLI-Fehler aufgetreten. DLI-Funktion:{0} AIB-return:0x{1} AIB-reason:0x{2} DLIVar.statusCode:{3} DLIVar.DbName:{4} DLIVar.SegmentName:{5} DLIVar.SegmentLevel:{6} DLI-Proxy-Job-ID:{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "Der AIB-return-Code weist auf einen PCB-status-Code hin, es wurde jedoch kein PCB zur\u00fcckgegeben. AIB-Funktion: {0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "Ausnahmebedingung in CALL EZEDBTCP beim fernen Host. Abschnitt: {0}, TCPIP-Operation: {1}, TCPIP-RETCODE: {2}, TCPIP-ERRNO: {3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "Abbruchcode (ABEND) beim fernen Host. Routine:{0} Nachricht:{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "Ausnahmebedingung beim fernen Host. Aufruf (CALL): {0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "Der Debugger unterst\u00fctzt die DLI-Funktion nicht. Funktion: {0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "Ein DL/I-Aufruf wird abgesetzt, aber der Builddeskriptor ist nicht f\u00fcr DL/I-Zugriff konfiguriert."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "Ausnahmebedingung auf fernem System: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "Bei dem Versuch, einen Programmspezifikationsblock zuzuordnen, ist ein Fehler aufgetreten. Die festgelegte IMSID gibt an, dass ein DL/I-Zugriff stattfindet, aber es wurde kein Programmspezifikationsblock angegeben."},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "Die RBD-Client- und die Hostversion sind nicht kompatibel. RBD-Clientversion:{0} Hostversion:{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "Beim Abrufen der Daten, die von einem Aufruf eines Hostprogramms zur\u00fcckgegeben wurden, ist ein Fehler aufgetreten. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "Beim Abrufen des PCB-Namens ist ein Fehler aufgetreten. PCB-Index:{0}, Anzahl der PCBs:{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
