/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_es extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "El error ha producido en {0}." },
		{ Message.FUNCTION_ERROR_INFO, "El error se ha producido en {0} al procesar la funci\u00f3n {1}." },
		{ Message.FILE_ERROR_INFO, "El error se ha producido en {0} al procesar la funci\u00f3n {1} en la l\u00ednea {2}." },
		{ Message.PROPERTIES_FILE_MISSING, "No se ha podido cargar el archivo de propiedades {0}." },
		{ Message.LOAD_LIBRARY_FAILED, "No se ha podido cargar la biblioteca {0}. Se ha producido el error siguiente: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "Se ha producido un error al crear un objeto del tipo {0}. Se ha producido el error siguiente: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "Se ha producido un error al crear InitialContext o al buscar el entorno java:comp/env. Se ha producido el error siguiente: {0}" },
		{ Message.LISTENER_ERROR, "Se han producido la excepci\u00f3n y el mensaje siguientes. Excepci\u00f3n: {0}. Mensaje: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "Se necesita un valor para la propiedad {0}." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "Falta una dependencia externa. Se ha producido la excepci\u00f3n siguiente. Excepci\u00f3n: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "No se pueden comparar los operando {0} y {1}." },
		{ Message.ASSIGNMENT_OVERFLOW, "Se ha producido un error de desbordamiento al asignar un valor de {0} a {1}." },
		{ Message.EXPRESSION_OVERFLOW, "Se ha producido un error de desbordamiento al calcular la expresi\u00f3n siguiente: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "El operador {0} no est\u00e1 soportado para los operandos {1} y {2}." },
		{ Message.UNSUPPORTED_OPERAND, "El operador {0} no est\u00e1 soportado para el operando {1} del tipo {2}." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "El operador subscript no est\u00e1 soportado para el operando {0} del tipo {1}." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "El operador de subserie no est\u00e1 soportado para el operando {0} del tipo {1}." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "La sentencia SET EMPTY no est\u00e1 soportada para el operando {0} del tipo {1}." },
		{ Message.INVALID_REGULAR_EXPRESSION, "Se ha producido un error en la expresi\u00f3n regular {0}. Error: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "Al utilizar el protocolo CICSSSL, es necesario especificar ctgKeyStore y ctgKeyStorePassword." },
		{ Message.INVALID_CTGPORT, "El valor {0} para la entrada ctgport no es correcto." },
		{ Message.CTG_CONNECT_FAILED, "Se ha producido un error al conectar CTG. La ubicaci\u00f3n de CTG es {0}. El puerto de CTG es {1}. Se ha producido el error siguiente: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "Se ha producido un error al desconectar de CTG. La ubicaci\u00f3n de CTG es {0}. El puerto de CTG es {1}. Se ha producido el error siguiente: {2}" },
		{ Message.NO_CICS, "Se ha producido un error al llamar al programa {0} que utiliza ECI CICS. El c\u00f3digo de retorno es -3 (ECI_ERR_NO_CICS). El identificador del sistema CICS es {1}." },
		{ Message.CICS_DIED, "Se ha producido un error al llamar al programa {0} que utiliza ECI CICS. El c\u00f3digo de retorno es -4 (ECI_ERR_CICS_DIED). El identificador del sistema CICS es {1}." },
		{ Message.CICS_TIMEOUT, "Se ha producido un error al llamar al programa {0} que utiliza ECI CICS. El c\u00f3digo de retorno es -6 (ECI_ERR_RESPONSE_TIMEOUT). El identificador del sistema CICS es {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "Se ha producido un error al llamar al programa {0} que utiliza ECI CICS. El c\u00f3digo de retorno es -7 (ECI_ERR_TRANSACTION_ABEND). El identificador del sistema CICS es {1}. El c\u00f3digo de abandono es {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "Se ha producido un error al llamar al programa {0} que utiliza ECI CICS. El c\u00f3digo de retorno es -22 (ECI_ERR_UNKNOWN_SERVER). El identificador del sistema CICS es {1}." },
		{ Message.CICS_SECURITY_ERROR, "Se ha producido un error al llamar al programa {0} que utiliza ECI CICS. El c\u00f3digo de retorno es -27 (ECI_ERR_SECURITY_ERROR). El identificador del sistema CICS es {1}." },
		{ Message.CICS_MAX_SYSTEMS, "Se ha producido un error al llamar al programa {0} que utiliza ECI CICS. El c\u00f3digo de retorno es -28 (ECI_ERR_MAX_SYSTEMS). El identificador del sistema CICS es {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "Se ha producido un error al llamar al programa {0} en el sistema {1} para el usuario llamado {2}. Se ha devuelto un c\u00f3digo de retorno {3} y un c\u00f3digo de terminaci\u00f3n an\u00f3mala {4} de la llamada ECI CICS." },
		{ Message.CICS_COMMIT_FAILED, "Se ha producido un error al llamar a ECI CICS para comprometer una unidad de trabajo. El c\u00f3digo de retorno de CICS es {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "Se ha producido un error al llamar a ECI CICS para retrotraer una unidad de trabajo. El c\u00f3digo de retorno de CICS es {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "Se ha producido una excepci\u00f3n en el flujo de una petici\u00f3n de ECI al sistema CICS {0}. Excepci\u00f3n: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "Un error de longitud de par\u00e1metro. La corriente tiene {0} par\u00e1metros y la funci\u00f3n local tiene {1} par\u00e1metros." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "Se ha sobrepasado el tama\u00f1o m\u00e1ximo para la matriz {0}." },
		{ Message.WRONG_NUMBER_OF_PARMS, "El programa de llamada {0} esperaba {1} par\u00e1metros pero se han pasado {2}." },
		{ Message.FUNCTION_NOT_FOUND, "Se ha producido un error al obtener la direcci\u00f3n del punto de entrada {0} en la biblioteca compartida {1}. El c\u00f3digo de retorno es {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "Se ha producido un error al cargar la biblioteca compartida {0}. El c\u00f3digo de retorno es {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "El programa ha fallado con un c\u00f3digo de retorno {0}." },
		{ Message.REMOTE_PROGRAM_ERROR, "Se ha producido un error en el programa remoto {0}, en el sistema {3}. Se ha producido un error en {1}, en {2}. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "Se ha producido un error en el programa remoto {0}, en el sistema {1}. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "El nombre de host {0} es un nombre de host TCP/IP desconocido." },
		{ Message.SERVERID_IS_INVALID_PORT, "El ServerID {0} no es un n\u00famero de puerto v\u00e1lido." },
		{ Message.TCPIP_SERVER_ERROR, "El cliente ha recibido la notificaci\u00f3n de que el servidor no puede iniciar el programa llamado remotamente. C\u00f3digo de raz\u00f3n: {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "Falta el valor remoteComType o no es correcto." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "No se puede abrir el archivo de propiedades de enlace {0}." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "No se puede encontrar una entrada para el programa llamado {0} en el archivo de propiedades de enlace {1}." },
		{ Message.AS400_UNKNOWN_HOST, "No se puede encontrar el host {0} o es desconocido." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "La contrase\u00f1a o el ID de usuario no son correctos para conectarse al sistema {0}. Error: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "Se ha producido un error de ejecuci\u00f3n de AS400Toolbox {0} al llamar al programa {2} en el sistema {3}. Error: {1}" },
		{ Message.AS400_NO_AUTHORITY, "Se ha producido un error de seguridad de acceso remoto en el sistema {0} para el usuario {1}. Error: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "Una funci\u00f3n de compromiso ha fallado en el sistema {0}. Error: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "La funci\u00f3n de retrotracci\u00f3n ha fallado en el sistema {0}. Error: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "Se ha producido un error de conexi\u00f3n remota al acceder al sistema {0}. Error: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "Se ha producido un error de OS/400 Host Services de EGL. Los campos necesarios no se encuentran en el sistema {0}." },
		{ Message.AS400_APPLICATION_ERROR, "La unidad de ejecuci\u00f3n se ha detenido porque se ha producido un error de aplicaci\u00f3n en el sistema {0} al intentar llamar al programa {1}. Mensaje: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "La variable de referencia llamada {0} es nula." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "Se ha producido un error no manejado. Error: {0}." },
		{ Message.DATA_FORMAT_ERROR, "El valor de la variable {0} no tiene el formato correcto." },
		{ Message.CONVERSION_ERROR, "El valor {0} del tipo {1} no puede convertirse al tipo {2}." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "El patr\u00f3n de formato de fecha {0} no es v\u00e1lido." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "El patr\u00f3n de formato de fecha {0} no es v\u00e1lido." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "El patr\u00f3n de formato de indicaci\u00f3n de la hora {0} no es v\u00e1lido." },
		{ Message.NULL_REFERENCE, "Se ha utilizado una referencia nula." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "El acceso din\u00e1mico no est\u00e1 soportado para {0}." },
		{ Message.DYNAMIC_ACCESS_FAILED, "No se puede encontrar un campo con el identificador {0} en {1}." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "El patr\u00f3n de formato num\u00e9rico {0} no es v\u00e1lido." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "Se ha producido un error al asignar {0} a {1}. Error: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "Un error en la sentencia SET {0} EMPTY. Error: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "Se ha producido un error {0} al invocar el m\u00e9todo con una firma {1}." },
		{ Message.RUN_COMMAND_FAILED, "Se ha producido un error al ejecutar el mandato {0}.  Error: {1}." },
		{ Message.MDY_ERROR, "La funci\u00f3n DateTimeLib.mdy no puede convertir los valores {0}, {1} y {2} en mes, d\u00eda y a\u00f1o." },
		{ Message.NON_NUMERIC_STRING, "Se ha pasado a {0} la serie no num\u00e9rica {1}. Todos los caracteres de la parte de la serie definida por el argumento length debe ser num\u00e9rico." },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} ha fallado con el mensaje de error {1}." },
		{ Message.INT_AS_CHAR_ERROR, "El argumento de StrLib.intAsChar debe ser un n\u00famero entre 0 y 255." },
		{ Message.INVALID_LOB_LENGTH, "{0} no es una longitud v\u00e1lida para {1}, que tiene un tama\u00f1o de {2}." },
		{ Message.INVALID_LOB_POSITION, "{0} no es una posici\u00f3n v\u00e1lida para {1}. Su tama\u00f1o es {2}." },
		{ Message.LOB_ERROR, "Se ha producido un error al procesar un elemento Blob o Clob.  El mensaje de error es {0}" },
		{ Message.START_TRANSACTION_ERROR, "VGLib.startTransaction para la clase {0} ha fallado. La excepci\u00f3n es {1}" },
		{ Message.INT_AS_UNICODE_ERROR, "El argumento de StrLib.intAsUnicode debe ser un n\u00famero entre 0 y 65535." },
		{ Message.INVALID_ARRAY_SIZE, "El valor de tama\u00f1o {0} no es v\u00e1lido para la matriz {1}. El tama\u00f1o m\u00e1ximo es {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "El \u00edndice {0} est\u00e1 fuera de l\u00edmites para la matriz {1}. El tama\u00f1o de la matriz es {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "\u00cdndices de subserie no v\u00e1lidos {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "El argumento de la funci\u00f3n para la matriz {0} no es v\u00e1lido." },
		{ Message.INDEX_OUT_OF_BOUNDS, "El valor del \u00edndice {0} est\u00e1 fuera de l\u00edmites." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} es una tabla de conversi\u00f3n no soportada." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "No se puede leer el archivo csouidpwd.properties. Error: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "El almacenamiento intermedio del cliente era demasiado peque\u00f1o para la cantidad de datos que se pasan en la llamada. El tama\u00f1o acumulado de los par\u00e1metros que se pasan es {0} bytes y sobrepasa el m\u00e1ximo permitido, que es {1} bytes." },
		{ Message.INVALID_PARMFORM, "La propiedad de enlace parmForm debe establecerse en COMMPTR para llamar al programa {0} ya que como m\u00ednimo hay un par\u00e1metro que es una matriz din\u00e1mica." },
		{ Message.PARM_PASSING_ERROR, "Se ha producido un error al pasar par\u00e1metros al programa llamado {0}. Error: {1}" },
		{ Message.CALL_ERROR, "Se ha producido un error al llamar al programa {0}. Error: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} es un tipo de par\u00e1metro no soportado para los programas de servicio de System i." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} es un tipo de retorno no soportado para los programas de servicio de System i." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "No se puede obtener un ConnectionFactory. La excepci\u00f3n es {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "No se puede cerrar la Interacci\u00f3n o la Conexi\u00f3n. Error: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "No se puede establecer una conexi\u00f3n. Error: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "No se puede obtener una interacci\u00f3n. La excepci\u00f3n es: {0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "No se puede establecer un verbo de interacci\u00f3n. La excepci\u00f3n es {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "No se ha podido obtener un LocalTransaction para la unidad de trabajo cliente. La excepci\u00f3n es {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "No se puede establecer el valor de tiempo de espera en una llamada CICSJ2C. La excepci\u00f3n es {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "Se ha producido un error al intentar establecer una comunicaci\u00f3n con CICS. La excepci\u00f3n es {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "El intento de ejecutar la transacci\u00f3n CICS remota ha fallado." },
		{ Message.EXCEPTION_CALLING_IMS, "Se ha producido un error al intentar establecer una comunicaci\u00f3n con IMS. La excepci\u00f3n es {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "Se ha producido un error al intentar establecer una comunicaci\u00f3n con IMS." },
		{ Message.MATH_DOMAIN_ERROR, "{0} ha fallado con el c\u00f3digo de error 8 (error de dominio.) Un argumento de la funci\u00f3n no es v\u00e1lido." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} ha fallado con el c\u00f3digo de error 8 (error de dominio.) El argumento debe estar entre -1 y 1." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} ha fallado con el c\u00f3digo de error 8 (error de dominio.) El segundo argumento no debe ser cero." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} ha fallado con el c\u00f3digo de error 8 (error de dominio.) El argumento debe ser mayor que cero." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "MathLib.pow ha fallado con el c\u00f3digo de error (error de dominio.) Si el primer argumento es cero, el segundo debe ser mayor que cero." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "MathLib.pow ha fallado con el c\u00f3digo de error (error de dominio.) Si el primer argumento es menor que cero, el segundo debe ser un entero." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "MathLib.sqrt ha fallado con el c\u00f3digo de error (error de dominio.) El argumento debe ser mayor o igual que cero." },
		{ Message.MATH_RANGE_ERROR, "{0} ha fallado con el c\u00f3digo de error 12 (error de rango.)" },		
		{ Message.STRING_INDEX_ERROR, "{0} ha fallado con el c\u00f3digo de error 8. El \u00edndice debe estar entre 1 y la longitud de la serie." },
		{ Message.STRING_LENGTH_ERROR, "{0} ha fallado con el c\u00f3digo de error 12. La longitud debe ser mayor que cero." },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator ha fallado con el c\u00f3digo de error 16. El \u00faltimo byte de la serie de destino debe ser un car\u00e1cter en blanco o nulo." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} ha fallado con el c\u00f3digo de error 20. El \u00edndice de una subserie a STRING, DBCHAR o UNICODE debe ser impar para que el \u00edndice identifique el primer byte de un car\u00e1cter." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} ha fallado con el c\u00f3digo de error 24. La longitud de una subserie a STRING, DBCHAR o UNICODE debe ser par para referirse a un todo un n\u00famero de caracteres." },
		{ Message.NO_DEBUG_LISTENER, "No se puede contactar con el depurador de EGL con el nombre de host {0} y el puerto {1}. La excepci\u00f3n es {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "Se ha producido un error al comunicar con el depurador EGL con el nombre de host {0} y el puerto {1}. La excepci\u00f3n es {2}" },
		{ Message.NOT_DEBUG_MODE, "El enlace especificaba una llamada DEBUG dentro de un servidor J2EE. No se ha hecho la llamada en un servidor J2EE, el servidor J2EE no est\u00e1 en modalidad de depuraci\u00f3n o el servidor J2EE no se ha habilitado para la depuraci\u00f3n EGL." },
		{ Message.LIBRARY_NOT_SPECIFIED, "El enlace especificaba una llamada DEBUG a un escucha EGL pero no especifica la propiedad de biblioteca." },
		
		{ Message.FILETYPE_MISSING, "No se puede establecer la propiedad de tiempo de ejecuci\u00f3n vgj.ra.fileName.fileType para el archivo {0}." },
		{ Message.FILETYPE_INVALID, "El valor de la propiedad de tiempo de ejecuci\u00f3n vgj.ra.fileName.fileType no es v\u00e1lido para el archivo {0}." },
		{ Message.INVALID_RECORD_LENGTH, "La longitud del elemento de registro debe contener un valor que divida los datos que no son de caracteres en los l\u00edmites de elemento." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "El valor de occursItem o lengthItem es demasiado grande." },
		{ Message.IO_ERROR, "{0}: E/S con {1} ha fallado por este motivo: {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: la sentencia preparada {1} no se ha encontrado[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: el conjunto de resultados {1} no se ha encontrado[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0}: error[sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "No se puede conectar con {0}: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "No se puede conectar con {0}, el URL de base de datos puede estar equivocado: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "Se ha producido un error al cargar los controladores JDBC.  Error: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "El ResultSet {0} no puede desplazarse." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "No se puede conectar con la base de datos predeterminada. No se ha especificado el nombre de la base de datos predeterminada." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "Es necesario establecer una conexi\u00f3n de base de datos antes de una operaci\u00f3n de E/S de SQL." },
		{ Message.SQL_DISCONNECT_ERROR, "Se ha producido un error al desconectarse de la base de datos {0}. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "No se puede establecer la conexi\u00f3n con la base de datos {0}. La conexi\u00f3n no existe." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "Se ha producido un error de SQL en la funci\u00f3n SQLLib.{0}: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "Se ha producido un error que no es de SQL en la funci\u00f3n SQLLib.{0}: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "Se ha recibido nulo de la base de datos, pero la variable de lenguaje principal {0} no tiene capacidad para nulos. " },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "No se ha recibido ninguna entrada para el campo necesario; vuelva a realizar la entrada." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "Error de tipo de datos en la entrada; vuelva a realizar la entrada." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "Se ha sobrepasado el n\u00famero de d\u00edgitos significativos permitidos; vuelva a realizar la entrada." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "La entrada no est\u00e1 en el rango definido de {0} a {1}: vuelva a realizar la entrada." },
		{ Message.EDIT_VALID_VALUES_ERR, "La entrada no est\u00e1 en la lista definida de valores v\u00e1lidos: vuelva a realizar la entrada." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "El formato de fecha y hora especificado de {0} no es v\u00e1lido." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "Error de longitud m\u00ednima de entrada; vuelva a realizar la entrada." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "Error de longitud m\u00e1xima de entrada; vuelva a realizar la entrada." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "Error de validez de edici\u00f3n de tabla; vuelva a realizar la entrada." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "Error de comprobaci\u00f3n de m\u00f3dulo en la entrada; vuelva a realizar la entrada." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "La entrada no es v\u00e1lida para el formato de fecha u hora definido {0}." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "La entrada no es v\u00e1lida para el campo booleano." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "El valor entrado no es v\u00e1lido y no coincide con el patr\u00f3n establecido." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "La tabla de edici\u00f3n {0} no est\u00e1 definida para {1}." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "Los datos hexadecimales no son v\u00e1lidos." },
		{ Message.EDIT_VALIDATION_ERR, "Se ha producido un error de validaci\u00f3n de p\u00e1gina.  Error: {0}." },
		{ Message.EDIT_INPUT_ERR, "Error al analizar el valor de entrada."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "Error al formatear el valor para visualizar: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "Los datos de entrada con caracteres SO/SI son demasiado largos para la longitud del elemento definida."},
		
		{ Message.ACTION_REQUEST_ERROR, "La funci\u00f3n RequestAttr de J2EELib ha fallado con la clave {0}. Error: {1}" },
		{ Message.ACTION_SESSION_ERROR, "La funci\u00f3n SessionAttr de J2EELib ha fallado con la clave {0}. Error: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "La funci\u00f3n ApplicationAttr de J2EELib ha fallado con la clave {0}. Error: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib solo debe utilizarse en un entorno J2EE." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "La funci\u00f3n PortletSessionAttr de PortalLib ha fallado con la clave {0}. Error: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "setPortletMode de PortalLib ha fallado. Error: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "setWindowState de PortalLib ha fallado. Error: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "Intento no permitido de cambiar la modalidad de Portlet durante la petici\u00f3n de representaci\u00f3n" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "Intento no permitido de cambiar el estado de la ventana de Portlet durante la petici\u00f3n de representaci\u00f3n" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "No se ha podido obtener PortletSession" }, 
		{ Message.PORTALLIB_INVALIDKEY, "Se ha pasado una clave no v\u00e1lida a la funci\u00f3n {0}" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "No se ha podido obtener PortletRequest" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "La funci\u00f3n resetPreferenceValue de PortalLib ha fallado con la clave {0}. Error: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "La funci\u00f3n savePreferences de PortalLib ha fallado. Error: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib no ha podido establecer la preferencia para la clave {0}. Error: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib no ha podido obtener la preferencia para la clave {0}. Error: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "No ha sido posible acceder al Servicio de almacenamiento de credenciales. Error: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "No se ha podido acceder a la credencial solicitada en la ranura {0}. Error: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "No se ha podido crear la ranura de Almacenamiento de credenciales en el espacio de usuario. Error: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "No se ha podido suprimir la ranura de Almacenamiento de credenciales en el espacio de usuario. Error: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "No se han podido establecer los valores de Credencial. Error: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} ha fallado. La invocaci\u00f3n de un m\u00e9todo o el acceso a un campo llamado {1} ha resultado en un error no manejado. El mensaje de error es {2}" },
		{ Message.JAVALIB_NULL_ID, "{0} ha fallado. {1} no es un identificador o es el identificador de un objeto nulo." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} ha fallado. Un m\u00e9todo, campo o clase p\u00fablico llamado {1} no existe o no puede cargarse o el n\u00famero de tipos de par\u00e1metros no es correcto. El mensaje de error es {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} ha fallado. El tipo de un valor de EGL no coincide con el tipo esperado en Java para {1}. El mensaje de error es {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "{0} ha fallado. El destino es un m\u00e9todo que ha devuelto nulo, un m\u00e9todo que no devuelve un valor o un campo cuyo valor es nulo." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} ha fallado. No se ha podido cargar la clase {1} de un argumento nulo. El mensaje de error es {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} ha fallado. No se ha podido obtener informaci\u00f3n acerca del m\u00e9todo o del campo llamado {1} o se ha intentado establecer el valor de un campo declarado final. El mensaje de error es {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} ha fallado. {1} es una interfaz o una clase abstracta de forma que no se puede llamar al constructor." },
		{ Message.JAVALIB_NOT_STATIC, "{0} ha fallado. El m\u00e9todo o el campo {1} no es est\u00e1tico. Debe utilizarse un identificador en lugar de un nombre de clase." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "El campo de acci\u00f3n {0} no existe." },
		{ Message.CUI_E_ARRAY_FULL, "No puede insertarse otra fila porque la matriz de entrada est\u00e1 llena." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "No se puede encontrar la matriz {0}." },
		{ Message.CUI_E_ASSIGN_RESULT, "La asignaci\u00f3n a la variable de resultado de solicitud ha fallado." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "El tama\u00f1o {0} para el campo Matriz de pantalla no es correcto."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "Los par\u00e1metros DrawBox est\u00e1n fuera de rango." },
		{ Message.CUI_E_BAD_COORDINATES, "Las coordenadas de visualizaci\u00f3n est\u00e1n fuera de los l\u00edmites de la ventana." },
		{ Message.CUI_E_BAD_KEYNAME, "Nombre de clave mal formado ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "No puede utilizar esta caracter\u00edstica de edici\u00f3n porque existe una imagen." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "No se puede encontrar la ventana ''{0}''." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "Los valores de posici\u00f3n[{0},{1}]/dimensi\u00f3n[{2},{3}] de la ventana nueva no son v\u00e1lidos." },
		{ Message.CUI_E_CMDSTACK_SYNC, "La pila de mandatos est\u00e1 desincronizada." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "La biblioteca de UI de consola no est\u00e1 inicializada." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "Tipo de campo no permitido para una construcci\u00f3n." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "No se puede llamar a ConstructQuery con una lista de variable." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "No se puede inhabilitar un elemento de men\u00fa invisible." },
		{ Message.CUI_E_EDIT_FAILED, "La acci\u00f3n de edici\u00f3n ha fallado." },
		{ Message.CUI_E_EXEC_HOTKEY, "Se ha producido un error al ejecutar la acci\u00f3n de tecla de cambio de modalidad." },
		{ Message.CUI_E_EXIT_NO_CMD, "No hay ning\u00fan mandato activo del que salir." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "No hay ning\u00fan mandato activo para continuar." },
		{ Message.CUI_E_FATALERROR, "Error muy grave: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "El campo {0} no existe." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "El campo de la matriz de pantalla {0} no es una matriz." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "No se puede encontrar el campo {0}." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "No se puede crear ConsoleField sin una ventana." },
		{ Message.CUI_E_FIELD_COUNT, "Discrepancia en la cuenta del campo de matriz" },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "No existe el formulario {0}." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "El formulario {0} no cabe en la ventana {1}." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "Las listas de campos no coinciden." },
		{ Message.CUI_E_FORM_IN_USE, "El formulario {0} est\u00e1 ocupado." },
		{ Message.CUI_E_FORM_NAME_USED, "Ya existe un formulario con el nombre {0}." },
		{ Message.CUI_E_FORM_NOT_OPEN, "El formulario {0} no est\u00e1 abierto." },
		{ Message.CUI_E_FORM_NO_WINDOW, "No se puede crear ConsoleForm sin una ventana." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "No se puede utilizar KeyObject.getChar() para claves virtuales." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "No se puede utilizar KeyObject.getCookedChar() para claves virtuales." },
		{ Message.CUI_E_INTERNAL, "ERROR INTERNO: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "Se ha recibido una se\u00f1al INTERRUPT." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "No se puede tener un elemento de men\u00fa invisible sin acelerador." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "No se puede crear ConsoleLabel sin una ventana." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "El elemento de men\u00fa {0} no cabe en la ventana." },
		{ Message.CUI_E_MISSING_ITEM, "El elemento de men\u00fa {0} no existe." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "Conflicto de mnem\u00f3nicos (key={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "No hay un formulario activo." },
		{ Message.CUI_E_NO_EDITOR, "No se ha especificado un editor blob." },
		{ Message.CUI_E_NO_HELP_FILE, "No se ha especificado un archivo de ayuda." },
		{ Message.CUI_E_NO_HELP_MSG, "No se ha especificado un mensaje de ayuda." },
		{ Message.CUI_E_NO_NUMPAGES, "El men\u00fa no est\u00e1 dispuesto." },
		{ Message.CUI_E_NO_SCREENARRAY, "No hay ninguna matriz de pantalla activa." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "No hay elementos de men\u00fa visibles." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "El nombre para la ventana nueva era nulo." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "Se ha intentado abrir una ventana nula." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "Se ha producido una excepci\u00f3n en la solicitud." },
		{ Message.CUI_E_QUIT_RECEIVED, "Se ha recibido una se\u00f1al QUIT." },
		{ Message.CUI_E_SCROLL_FAILED, "El men\u00fa no puede desplazarse al elemento actual." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "Atributo desconocido ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "Hay un error en el campo {0}." },
		{ Message.CUI_E_VAR_LIST_SHORT, "No se han proporcionado variables suficientes." },
		{ Message.CUI_E_WINDOW_NAME_USED, "Ya se est\u00e1 utilizando el nombre de la ventana {0}." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "El tama\u00f1o de la ventana es demasiado peque\u00f1o para la ventana de ayuda." },
		{ Message.CUI_E_VALID_VALUES, "El valor especificado no es un valor v\u00e1lido." },
		{ Message.CUI_W_NO_MORE_FIELDS, "No hay m\u00e1s campos en la direcci\u00f3n que est\u00e1 siguiendo." },
		{ Message.CUI_W_NO_MORE_ROWS, "No hay m\u00e1s filas en la direcci\u00f3n que est\u00e1 siguiendo." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "El contenido de la matriz de la pantalla {0} no es v\u00e1lido." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "La matriz de la pantalla {0} no puede contener el campo segmentado {1}."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "La matriz de la pantalla {0} no es compatible con la matriz de datos." },
		{ Message.CUI_E_FIELD_NAME_DUP, "El nombre del campo {0} se est\u00e1 utilizando m\u00e1s de una vez." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "La longitud del campo de consola {0} no es v\u00e1lida." },
		{ Message.CUI_E_LABEL_NOT_FIT, "La etiqueta de [{0}, {1}] no cabe en el espacio disponible." },
		{ Message.CUI_E_FIELD_NOT_FIT, "El segmento del campo {0} de ({1}, {2}) no cabe en el espacio disponible." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"La serie de solicitud es demasiado larga para la ventana activa."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"Los argumentos de la matriz OpenUI no son v\u00e1lidos."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "Los argumentos del campo OpenUI no son v\u00e1lidos."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "Solo se puede enlazar una variable a una sentencia de solicitud." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "El enlace de datos para el campo de consola {0} no puede determinarse." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "Aviso: se han encontrado caracteres NUL en datos clob" },
		{ Message.CUI_I_STR_WINDOWTITLE , "Ventana de consola EGL" },
		{ Message.CUI_E_MISSING_FORMAT , "El campo {0} no tiene objeto de formato." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "Las dos entradas no coinciden -- por favor, int\u00e9ntelo de nuevo" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "Por favor, escriba de nuevo para la verificaci\u00f3n" },
		{ Message.CUI_I_STR_HELP,"Ayuda"},
		{ Message.CUI_I_STR_RESUME,"Reanudar"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"Finaliza esta sesi\u00f3n de ayuda."},
		{ Message.CUI_I_STR_SCROLL , "Desplazar" },
		{ Message.CUI_I_STR_LAST_PAGE, "Ha llegado al final del texto de ayuda. Pulse en RETURN para continuar."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "Visualiza la p\u00e1gina siguiente del texto de ayuda."},
		{ Message.CUI_I_STR_SELECT , "SELECCIONAR"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "Error al insertar la primera fila en una matriz vac\u00eda."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 no implementado."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "INTERNO: F25-64 no implementado" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "No puede tener m\u00faltiples instancias de CursesCanvas" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "No se ha inicializado CursesCanvas" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas es demasiado peque\u00f1o"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "La visualizaci\u00f3n de campos por nombre no se ha implementado."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "Entrada m\u00ednima {0} necesaria; vuelva a realizar la entrada." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "Entrada m\u00e1xima {0} sobrepasada; vuelva a realizar la entrada." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "No se puede abrir el archivo de script ''{0}''." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "No se puede leer el archivo de script."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "La propiedad automation.scenario ''{0}'' no es un directorio."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "Directiva <click> mal formada en el script de reproducci\u00f3n."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "No se puede obtener la propiedad de automatizaci\u00f3n ''{0}''."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "Nombre de tecla de p\u00e1nico no v\u00e1lido ''{0}''"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "Excepci\u00f3n en <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "No se puede abrir el archivo de instant\u00e1neas ''{0}''"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "La propiedad establecida para automation.scriptdir ''{0}'' no existe."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "La propiedad establecida para el directorio automation.scenario ''{0}'' no se puede crear."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "Nombre de tecla de instant\u00e1nea no v\u00e1lido ''{0}''"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "Comparaci\u00f3n satisfactoria."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "No est\u00e1 permitido utilizar las operaciones de E/S de visualizaci\u00f3n al ejecutar en modalidad RCP."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "No existe un mensaje con el ID {0} en la tabla de mensajes {1}." },
		{ Message.MSG_TBL_LOAD_ERR, "No se puede cargar el archivo de tabla de mensajes {0}." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "No hay una tabla de mensaje de usuario definida para el VGUIRecord {0}." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "El campo ''{0}'' en la posici\u00f3n ({1},{2}) no est\u00e1 presente dentro del formulario." },
		{ Message.TUI_E_FIELD_OVERLAP, "El campo ''{0}'' se superpone a ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "Error interno: no se puede determinar el grupo del formulario." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "El formulario ''{0}'' no cabe en ninguna \u00e1rea flotante." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "Las coordenadas del campo ''{0}'' no son v\u00e1lidas." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "No se puede obtener la asociaci\u00f3n de impresi\u00f3n." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "No existe un tama\u00f1o de dispositivo de impresi\u00f3n adecuado." },
		{ Message.TUI_E_NO_DISPLAY, "No existe ning\u00fan dispositivo de pantalla para formularios." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "No existe un tama\u00f1o de dispositivo compatible para los formularios visualizados." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "La clase de formulario de ayuda ''{0}'' no existe." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "Atributo desconocido ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "El valor especificado en el atributo de valores v\u00e1lidos no es correcto y no ha podido analizarse." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "No se puede crear el formulario de ayuda ''{0}''" },
		{ Message.TUI_E_INTERNAL, "ERROR INTERNO: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "No hay impresoras disponibles." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "No hay ninguna impresora predeterminada." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "No se ha encontrado la impresora ''{0}''.\nEstas impresoras est\u00e1n disponibles:\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "Error al cargar el mensaje ''{0}''" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "El contenido de {0} no puede utilizarse como un campo." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "No se ha encontrado la impresora ''{0}''" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "El programa {0} esperaba el formulario de texto {1} pero ha recibido el formulario de texto {2} en una sentencia show." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "Siguiente" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "P\u00e1gina {0} de {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "Anterior" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "Imprimir" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "Vista previa - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "Guardar" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "Guardar PrintJob - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "Error al imprimir en el archivo: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "Error al imprimir en la impresora: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "Establecer EZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "Validando el campo ''{0}''" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "Validando textform" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "Validando textform - ejecutando la funci\u00f3n de validaci\u00f3n ''{0}''" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "No se puede crear el escritor de anotaciones." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "El par\u00e1metro de anotaciones ''{0}'' no se puede establecer despu\u00e9s del inicio." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "Logdir ''{0}'' no existe." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "No se puede escribir en el directorio de anotaciones ''{0}''." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "No se puede crear el archivo de anotaciones ''{0}''." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "No se puede escribir en el archivo de anotaciones ''{0}''." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Se ha producido un problema al cargar el servicio para Component/ExternalService {0}." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "Se ha producido un error al crear una conexi\u00f3n a la operaci\u00f3n del servicio Web ''{0}''.  {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "Se ha producido un error al obtener la operaci\u00f3n ''{0}'' del archivo wsdl ''{1}''." },
		{ Message.SOA_E_WS_MALFORMED_URL, "El URL destino para la operaci\u00f3n de servicio Web {1} no es v\u00e1lido. URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "Se ha producido un error al cargar el servicio {0}. Error: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "Se ha producido un error al intentar cargar un servicio Web. No se ha podido resolver el puerto WSDL para el servicio externo {0}." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "Al componente {0} le falta la propiedad {1} necesaria para la implementaci\u00f3n del servicio." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "La referencia de servicio ''{0}'' falta o no tiene un valor destino." },
		{ Message.SOA_E_MISSING_BINDING, "El enlace de servicio ''{0}'' no existe en el descriptor de despliegue ''{1}''" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "Se ha producido un error al intentar convertir el registro ''{0}'' en un mensaje SOAP.  No se ha podido encontrar el campo ''{1}'' en el registro." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "Se ha producido un error al intentar convertir ''{0}'' en un mensaje SOAP."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "Se ha producido un error al procesar un mensaje entrante de un servicio Web. El tipo Java no es compatible con el tipo EGL." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "Se ha producido un error al procesar un mensaje saliente para un servicio Web. El tipo EGL no es compatible con el tipo Java" },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "No se puede inicializar el registro ''{0}''." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "No se puede convertir el valor ''{0}'' en un calendario." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "No se puede convertir el valor ''{0}'' en un booleano." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "No se puede convertir el valor ''{0}'' en un byte." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "No se puede convertir el valor ''{0}'' en un short." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "No se puede convertir el valor ''{0}'' en un URI." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "Tipo EGL no soportado como par\u00e1metro de servicio Web." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "Se ha producido un error al intentar crear la matriz de registro. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "No se ha encontrado el m\u00e9todo {0} en el servicio {1}." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "El servicio no est\u00e1 en un servicio Web." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "Se ha producido un error al intentar invocar la funci\u00f3n {0} en el servicio Web {1}." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "Se ha producido un error al intentar invocar la funci\u00f3n {0} en el servicio EGL {1}." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "Se ha producido un error al intentar invocar la funci\u00f3n {0} en el servicio EGL {1} utilizando {2}:{3}." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "El servicio no es un servicio tcpip." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "Se ha producido un error al intentar invocar la funci\u00f3n {0} en el punto de entrada {1}." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "Se ha producido un error al intentar cargar el archivo de enlace de servicio {0}. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "Se ha producido un error al intentar invocar la funci\u00f3n {0} en el servicio CICS {1}. C\u00f3digo de error {2}, Mensaje {3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "Se ha producido un error al intentar invocar la funci\u00f3n {0} en el servicio iSeries {1}. C\u00f3digo de error {2}, Mensaje {3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "El servicio no es un servicio CICS." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "Se ha producido un error en el servicio remoto {0}, en fecha {1}, a la hora {2} en el sistema {3}." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "Se ha producido un error en el servicio remoto {0}, en el sistema {1}." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "La unidad de ejecuci\u00f3n ha terminado debido a un error de aplicaci\u00f3n en el sistema {0} que intenta llamar al servicio {1}. Mensaje: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "Error de ejecuci\u00f3n AS400Toolbox: {0}, {1} al llamar al servicio {2} en el sistema {3}." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "Enlace de cliente de servicio no soportado. {0} se gener\u00f3 para Websphere, pero se est\u00e1 llamando desde un entorno no J2EE. Regen\u00e9relo en un proyecto no J2EE." },
		{ Message.SOA_E_USER_ID_NOT_SET, "Hay que establecer el ID de usuario y la contrase\u00f1a remotos para poder invocar WebService:{0} function:{1}." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "Se ha producido una excepci\u00f3n al llamar a un servicio. " },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "Se ha producido una excepci\u00f3n al comunicar con el servicio. URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "Se ha producido una excepci\u00f3n durante una llamada al servicio REST. Enlace{0}, Operaci\u00f3n:{0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "Se ha producido una excepci\u00f3n durante una llamada al servicio SOAP. Enlace:{0}, Servicio:{1}, Puerto:{2}, Ubicaci\u00f3n WSDL:{3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "Se ha producido una excepci\u00f3n al convertir desde JSON. par\u00e1metro:{0}, json:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "Se ha producido una excepci\u00f3n al convertir a JSON. par\u00e1metro:{0}, valor:{1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "No se ha encontrado el servicio REST-RPC. URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "No se ha recibido respuesta del servicio. URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "La solicitud no ha podido convertirse en una llamada de servicio. La solicitud recibida es ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "La invocaci\u00f3n del servicio ha agotado el tiempo de espera. Excepci\u00f3n: error de tiempo de espera de lectura de conexi\u00f3n. url:{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "El servicio no es un servicio REST." },
		{ Message.SOA_E_REST_SERVICE, "La llamada a la invocaci\u00f3n del servicio REST ha fallado. Enlace:{0}, Operaci\u00f3n:{1}, M\u00e9todo HTTP:{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "Se ha producido una excepci\u00f3n al convertir datos en par\u00e1metros EGL. Enlace:{0}, datos a convertir {1}, excepci\u00f3n: {2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "Se ha efectuado una invocaci\u00f3n de servicio REST en una referencia de servicio no REST. Referencia de servicio: {0}, Operaci\u00f3n {1}, M\u00e9todo HTTP: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "Se ha producido una excepci\u00f3n al convertir desde XML. Falta el elemento obligatorio {0}. " },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "Se ha producido una excepci\u00f3n al convertir desde XML. Par\u00e1metro: {0}, xml: {1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "Se ha producido una excepci\u00f3n al convertir a XML. Par\u00e1metro:{0}, valor:{1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "Se ha producido una excepci\u00f3n de an\u00e1lisis XML al convertir {0} desde XML. " },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "Se ha producido una excepci\u00f3n de conversi\u00f3n XML al convertir {0} a XML. " },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "El URL ''{0}'' utilizado para invocar el servicio no es v\u00e1lido. No contiene el protocolo http://." },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "El URL ''{0}'' utilizado para invocar el servicio no es v\u00e1lido. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "El URL utilizado para invocar el servicio est\u00e1 vac\u00edo. Especifique un URL que se\u00f1ale al servicio. " },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "No se ha podido cumplimentar el informe utilizando la conexi\u00f3n {0}"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "No se ha podido cumplimentar el informe utilizando la sentencia SQL {0}"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "No se ha podido cumplimentar el informe utilizando la matriz din\u00e1mica {0}"},
		{ Message.REPORT_E_FILL_ERROR , "No se ha podido cumplimentar el informe {0}"},
		{ Message.REPORT_E_EXPORT_ERROR, "No se ha podido exportar el informe {0}" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "No se ha podido realizar la conversi\u00f3n entre los tipos EGL {0} y Java {1}" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "No se ha podido realizar la conversi\u00f3n entre los tipos Java {0} y EGL {1}" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "No se ha podido a\u00f1adir el par\u00e1metro de informe" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "No se ha podido restablecer la lista de par\u00e1metros de informe" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "Nombre de campo incorrecto {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "Nombre de subinforme incorrecto {0}" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "Se est\u00e1 utilizando un tipo no soportado en la creaci\u00f3n del informe" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "No se pueden pasar tipos complejos a esta funci\u00f3n" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "Debe establecerse el nombre del archivo de dise\u00f1o antes de llamar a la funci\u00f3n getParameterDefaultValue()." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "No se ha podido obtener el valor predeterminado para el par\u00e1metro {0}. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "No existe un par\u00e1metro de informe llamado {0}." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "Debe establecerse el archivo de dise\u00f1o antes de llamar a las funciones createReportFromDesign() o createDocument()." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "Debe establecerse el nombre del archivo de documento antes de llamar a la funci\u00f3n createReportFromDocument()." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "No se ha podido crear el archivo de documento de informe. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "No se ha podido crear el informe del archivo de dise\u00f1o. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "No se ha podido crear el informe a partir del archivo de documento. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "El objeto de manejador especificado para un BirtReport debe ser del tipo BirtHandler." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "El elemento {0} no existe en el dise\u00f1o de informe o no est\u00e1 en el tipo especificado." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "El n\u00famero de fila {0} {1} no existe en la tabla {2}." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "El n\u00famero de fila {0} no existe en el elemento de cuadr\u00edcula {1}." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "El grupo {0} no existe en la tabla {1}." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "El n\u00famero de fila {0} {1} no existe en el grupo {2} de la tabla {3}." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "El n\u00famero de columna {0} no existe en una fila {1}, en la tabla {2}." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "El n\u00famero de columna {0} no existe en la cuadr\u00edcula {1}." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "El n\u00famero de columna {0} no existe en la fila {1} del grupo {2} de la tabla {3}." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "La propiedad ''RowType'' debe especificarse para una funci\u00f3n de manejador de eventos para fila(s) o celda(s) en la tabla {0}." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "No se ha podido convertir el tipo Java {0} a un tipo EGL." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "No se ha podido convertir el tipo EGL {0} a un tipo Java." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "El conjunto de datos {0} no existe en el dise\u00f1o de informe." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "El conjunto de datos {0} es un conjunto de datos en script, pero no se han manejado ninguno de los eventTypes siguientes: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "El origen de datos {0} no existe en el dise\u00f1o de informe." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "El origen de datos {0} es un origen de datos en script, pero no se han manejado ninguno de los eventTypes siguientes: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "El n\u00famero de columna {0} no existe en el conjunto de datos {1}." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "Se ha producido una excepci\u00f3n al obtener la columna {0} del conjunto de datos {1}. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "Se ha producido una excepci\u00f3n al establecer la columna {0} del conjunto de datos en script {1}. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "Se ha producido una excepci\u00f3n al obtener el enlace de columna {0}. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "No se ha especificado la propiedad vgj.defaultI4GLNativeLibrary" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "La carga de la biblioteca {0} ha fallado {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "Los par\u00e1metros devueltos no coinciden con la funci\u00f3n" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "No se ha podido asignar la memoria"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "No se ha podido realizar la conversi\u00f3n entre tipos"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "Precisi\u00f3n de intervalo o fecha y hora no v\u00e1lida"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "La variable de sistema principal de caracteres es demasiado corta para los datos"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "No se puede encontrar la funci\u00f3n en la tabla de s\u00edmbolos"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "Es necesario proporcionar un tipo de datos TEXT o BYTE en este contexto"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "El valor de la pila no se puede convertir en un tipo de valor"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "El valor de la pila no se puede convertir en ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "No se ha podido sacar un valor de tipo {0} de la pila"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "No se ha podido meter un valor de tipo {1} en la pila"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "Nada que meter/sacar"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "No se ha podido sacar Locator de la pila"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "La pila est\u00e1 vac\u00eda"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "No se ha podido copiar el ubicador"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "Se ha metido una referencia nula en la pila"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "No se ha podido meter Any en la pila"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "No se ha podido asignar el elemento de la pila al tipo Any"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "Discrepancia de tipo de retorno"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "Discrepancia de tipo de par\u00e1metro"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "No se ha podido encontrar el archivo fuente EGL {0}.  En su lugar se ejecutar\u00e1 el c\u00f3digo generado." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "No se ha podido encontrar el archivo fuente EGL para la transacci\u00f3n web llamada {0}." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "Se ha producido el siguiente problema de formato en el campo \"{0}\" al visualizar el formulario \"{1}\":" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\nEl formato interno esperado del campo es \"{1}\". Compruebe las propiedades de formato de fecha en las propiedades de EGL Java Runtime dentro del descriptor de despliegue de depuraci\u00f3n o las propiedades JDBC que afectan a los formatos de fecha." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\nEl formato de visualizaci\u00f3n del campo es \"{1}\". Compruebe la propiedad \"{2}\" en el campo del formulario. " },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "No se puede ejecutar el programa {0} como una transacci\u00f3n web." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "La transacci\u00f3n web ha recibido el registro de UI de entrada {0} pero se hab\u00eda definido con el registro de UI de entrada {1}." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "La entrada no es v\u00e1lida para el campo booleano." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "Se ha producido un tiempo de espera en el programa {0} debido a la inactividad." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "El registro de la interfaz de usuario {0} contiene demasiados datos a enviar al servlet de la pasarela." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "El programa no ha podido verificar los datos del servlet de la pasarela.  El identificador de los datos es {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "El envoltorio de matriz {0} no puede ampliarse m\u00e1s all\u00e1 de su tama\u00f1o m\u00e1ximo. El error se ha producido en el m\u00e9todo {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} es un \u00edndice no v\u00e1lido para el envoltorio de matriz {1}. Tama\u00f1o m\u00e1ximo: {2}. Tama\u00f1o actual: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} no es un tama\u00f1o m\u00e1ximo v\u00e1lido para el envoltorio de matriz {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} es un tipo de objeto no v\u00e1lido para a\u00f1adir a un envoltorio de matriz de tipo {1}." },
		
		{ Message.IMS_HOST_ABORT, "Se ha recibido una cancelaci\u00f3n anormal de paquete del host remoto. "},
		{ Message.IMS_HOST_TCPIP_ERROR, "Se ha producido un error de TCPIP en el host remoto. Secci\u00f3n:{0} Operaci\u00f3n de TCPIP:{1} C\u00d3DIGO DE RETORNO DE TCPIP:{2} N\u00daMERO DE ERROR DE TCPIP:{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "Se ha producido un error en el host al invocar:{0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "Se ha recibido el paquete de respuesta equivocado del host. Se esperaba:{0} Se ha recibido:{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "Se ha producido un error de E/S al ejecutar el procedimiento almacenado. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "Se ha producido un error de SQL al ejecutar el procedimiento almacenado. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "Error en el host remoto que est\u00e1 ejecutando:{0} C\u00d3DIGO DE RETORNO:{1} ID de trabajo proxy DLI:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "Error de DLI en el host remoto. Funci\u00f3n DLI:{0} Retorno-_AIB:0x{1} Raz\u00f3n-AIB:0x{2} C\u00f3digoEstado:{3} ID de trabajo proxy DLI:{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "Error de DLI en el host remoto. Funci\u00f3n DLI:{0} Retorno-AIB:0x{1} Raz\u00f3n-AIB:0x{2} DLIVar.statusCode:{3} DLIVar.DbName:{4} DLIVar.SegmentName:{5} DLIVar.SegmentLevel:{6} ID de trabajo proxy DLI:{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "El c\u00f3digo de retorno de AIB indica un c\u00f3digo de estado de PCB, pero no se ha devuelto ning\u00fan PCB. Funci\u00f3n de AIB:{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "Se ha producido una excepci\u00f3n en CALL EZEDBTCP en el host remoto. Secci\u00f3n:{0} Operaci\u00f3n de TCPIP:{1} C\u00d3DIGO DE RETORNO DE TCPIP:{2} N\u00daMERO DE ERROR DE TCPIP:{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "Se ha producido una TERMINACI\u00d3N AN\u00d3MALA en el host remoto. Rutina:{0} Mensaje:{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "Se ha producido una excepci\u00f3n en el host remoto. LLAMADA:{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "El depurador no soporta la funci\u00f3n DLI. Funci\u00f3n:{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "Se est\u00e1 emitiendo una llamada de DL/I, pero el descriptor de construcci\u00f3n no est\u00e1 configurado para el acceso a DL/I."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "Excepci\u00f3n remota: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "Se ha producido un error al intentar asignar un PSB. El IMSID indica que existe acceso a DL/I, pero no existe ning\u00fan PSB especificado."},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "Las versiones del cliente RBD y del host no son compatibles. Versi\u00f3n de cliente RBD: {0} Versi\u00f3n de host: {1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "Se ha producido un error al recuperar los datos devueltos por una llamada a un programa de host. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "Se ha producido un error al recuperar el nombre de PCB. \u00cdndice PCB:{0}, N\u00famero de PCBs:{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
