/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_ja extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "{0} \u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.FUNCTION_ERROR_INFO, "{0} \u3067 {1} \u95a2\u6570\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.FILE_ERROR_INFO, "{0} \u3067 {1} \u95a2\u6570\u306e\u51e6\u7406\u4e2d\u306b\u884c {2} \u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.PROPERTIES_FILE_MISSING, "{0} \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u3092\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.LOAD_LIBRARY_FAILED, "{0} \u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u3092\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3002 \u6b21\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {1}" },
		{ Message.CREATE_OBJECT_FAILED, "{0} \u30bf\u30a4\u30d7\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u4f5c\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u6b21\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {1}" },
		{ Message.INITIAL_CONTEXT_ERROR, "InitialContext \u306e\u4f5c\u6210\u4e2d\u3001\u307e\u305f\u306f java:comp/env \u74b0\u5883\u306e\u691c\u7d22\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u6b21\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {0}" },
		{ Message.LISTENER_ERROR, "\u6b21\u306e\u4f8b\u5916\u304a\u3088\u3073\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u4f8b\u5916: {0}\u3002 \u30e1\u30c3\u30bb\u30fc\u30b8: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "{0} \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306e\u5024\u304c\u5fc5\u8981\u3067\u3059\u3002" },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "\u5916\u90e8\u4f9d\u5b58\u95a2\u4fc2\u304c\u6b20\u843d\u3057\u3066\u3044\u307e\u3059\u3002 \u6b21\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u4f8b\u5916: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "{0} \u30aa\u30da\u30e9\u30f3\u30c9\u3068 {1} \u30aa\u30da\u30e9\u30f3\u30c9\u3092\u6bd4\u8f03\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.ASSIGNMENT_OVERFLOW, "\u5024 {0} \u3092 {1} \u306b\u5272\u308a\u5f53\u3066\u308b\u969b\u306b\u3001\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.EXPRESSION_OVERFLOW, "\u6b21\u306e\u5f0f\u3092\u8a08\u7b97\u3059\u308b\u969b\u306b\u3001\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {0}" },
		{ Message.UNSUPPORTED_OPERANDS, "{1} \u30aa\u30da\u30e9\u30f3\u30c9\u304a\u3088\u3073 {2} \u30aa\u30da\u30e9\u30f3\u30c9\u3067\u306f\u3001{0} \u6f14\u7b97\u5b50\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002" },
		{ Message.UNSUPPORTED_OPERAND, "\u578b {2} \u306e {1} \u30aa\u30da\u30e9\u30f3\u30c9\u3067\u306f\u3001{0} \u6f14\u7b97\u5b50\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002" },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "\u578b {1} \u306e\u30aa\u30da\u30e9\u30f3\u30c9 {0} \u3067\u306f\u3001\u6dfb\u3048\u5b57\u6f14\u7b97\u5b50\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002" },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "\u578b {1} \u306e\u30aa\u30da\u30e9\u30f3\u30c9 {0} \u3067\u306f\u3001\u30b5\u30d6\u30b9\u30c8\u30ea\u30f3\u30b0\u6f14\u7b97\u5b50\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002" },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "\u578b {1} \u306e\u30aa\u30da\u30e9\u30f3\u30c9 {0} \u3067\u306f\u3001SET EMPTY \u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002" },
		{ Message.INVALID_REGULAR_EXPRESSION, "{0} \u6b63\u898f\u8868\u73fe\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "CICSSSL \u30d7\u30ed\u30c8\u30b3\u30eb\u3092\u4f7f\u7528\u3059\u308b\u3068\u304d\u306f\u3001ctgKeyStore \u304a\u3088\u3073 ctgKeyStorePassword \u306e\u4e21\u65b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.INVALID_CTGPORT, "ctgport \u30a8\u30f3\u30c8\u30ea\u30fc\u306e\u5024 {0} \u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CTG_CONNECT_FAILED, "CTG \u306b\u63a5\u7d9a\u3059\u308b\u969b\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 CTG \u30ed\u30b1\u30fc\u30b7\u30e7\u30f3\u306f {0} \u3067\u3059\u3002 CTG \u30dd\u30fc\u30c8\u306f {1} \u3067\u3059\u3002 \u6b21\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "CTG \u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3059\u308b\u969b\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 CTG \u30ed\u30b1\u30fc\u30b7\u30e7\u30f3\u306f {0} \u3067\u3059\u3002 CTG \u30dd\u30fc\u30c8\u306f {1} \u3067\u3059\u3002 \u6b21\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {2}" },
		{ Message.NO_CICS, "CICS ECI \u3092\u4f7f\u7528\u3059\u308b {0} \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9\u306f -3 (ECI_ERR_NO_CICS) \u3067\u3059\u3002 CICS \u30b7\u30b9\u30c6\u30e0\u8b58\u5225\u5b50\u306f {1} \u3067\u3059\u3002" },
		{ Message.CICS_DIED, "CICS ECI \u3092\u4f7f\u7528\u3059\u308b {0} \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9\u306f -4 (ECI_ERR_CICS_DIED) \u3067\u3059\u3002 CICS \u30b7\u30b9\u30c6\u30e0\u8b58\u5225\u5b50\u306f {1} \u3067\u3059\u3002" },
		{ Message.CICS_TIMEOUT, "CICS ECI \u3092\u4f7f\u7528\u3059\u308b {0} \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9\u306f -6 (ECI_ERR_RESPONSE_TIMEOUT) \u3067\u3059\u3002 CICS \u30b7\u30b9\u30c6\u30e0\u8b58\u5225\u5b50\u306f {1} \u3067\u3059\u3002" },
		{ Message.CICS_TRANSACTION_ABEND, "CICS ECI \u3092\u4f7f\u7528\u3059\u308b {0} \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9\u306f -7 (ECI_ERR_TRANSACTION_ABEND) \u3067\u3059\u3002 CICS \u30b7\u30b9\u30c6\u30e0\u8b58\u5225\u5b50\u306f {1} \u3067\u3059\u3002 \u7570\u5e38\u7d42\u4e86\u30b3\u30fc\u30c9\u306f {2} \u3067\u3059\u3002" },
		{ Message.CICS_UNKNOWN_SERVER, "CICS ECI \u3092\u4f7f\u7528\u3059\u308b {0} \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9\u306f -22 (ECI_ERR_UNKNOWN_SERVER) \u3067\u3059\u3002 CICS \u30b7\u30b9\u30c6\u30e0\u8b58\u5225\u5b50\u306f {1} \u3067\u3059\u3002" },
		{ Message.CICS_SECURITY_ERROR, "CICS ECI \u3092\u4f7f\u7528\u3059\u308b {0} \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9\u306f -27 (ECI_ERR_SECURITY_ERROR) \u3067\u3059\u3002 CICS \u30b7\u30b9\u30c6\u30e0\u8b58\u5225\u5b50\u306f {1} \u3067\u3059\u3002" },
		{ Message.CICS_MAX_SYSTEMS, "CICS ECI \u3092\u4f7f\u7528\u3059\u308b {0} \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9\u306f -28 (ECI_ERR_MAX_SYSTEMS) \u3067\u3059\u3002 CICS \u30b7\u30b9\u30c6\u30e0\u8b58\u5225\u5b50\u306f {1} \u3067\u3059\u3002" },
		{ Message.CICS_NONZERO_RETURN_CODE, "{1} \u30b7\u30b9\u30c6\u30e0\u3067\u30e6\u30fc\u30b6\u30fc\u540d {2} \u3092\u4f7f\u3063\u3066 {0} \u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u547c\u3073\u51fa\u3059\u969b\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9 {3} \u304a\u3088\u3073\u7570\u5e38\u7d42\u4e86\u30b3\u30fc\u30c9 {4} \u304c\u3001CICS ECI \u547c\u3073\u51fa\u3057\u304b\u3089\u623b\u3055\u308c\u307e\u3057\u305f\u3002" },
		{ Message.CICS_COMMIT_FAILED, "\u4f5c\u696d\u5358\u4f4d\u3092\u30b3\u30df\u30c3\u30c8\u3059\u308b\u305f\u3081\u306e CICS ECI \u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 CICS \u623b\u308a\u30b3\u30fc\u30c9\u306f {0} \u3067\u3059\u3002" },
		{ Message.CICS_ROLLBACK_FAILED, "\u4f5c\u696d\u5358\u4f4d\u3092\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u3059\u308b\u305f\u3081\u306e CICS ECI \u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 CICS \u623b\u308a\u30b3\u30fc\u30c9\u306f {0} \u3067\u3059\u3002" },
		{ Message.CICS_ECI_FLOW_FAILED, "CICS \u30b7\u30b9\u30c6\u30e0 {0} \u3078\u306e ECI \u8981\u6c42\u306e\u30d5\u30ed\u30fc\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u4f8b\u5916: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u9577\u30a8\u30e9\u30fc\u3067\u3059\u3002 \u30b9\u30c8\u30ea\u30fc\u30e0\u306b {0} \u500b\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u304c\u3042\u308a\u3001\u30ed\u30fc\u30ab\u30eb\u95a2\u6570\u306b {1} \u500b\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u304c\u3042\u308a\u307e\u3059\u3002" },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "{0} \u914d\u5217\u306e\u6700\u5927\u30b5\u30a4\u30ba\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002" },
		{ Message.WRONG_NUMBER_OF_PARMS, "\u547c\u3073\u51fa\u3057\u5148\u30d7\u30ed\u30b0\u30e9\u30e0 {0} \u306b\u5fc5\u8981\u306a\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306f {1} \u500b\u3067\u3059\u304c\u3001\u6e21\u3055\u308c\u305f\u306e\u306f {2} \u500b\u3067\u3057\u305f\u3002" },
		{ Message.FUNCTION_NOT_FOUND, "{1} \u5171\u6709\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u5185\u306b\u3042\u308b {0} \u30a8\u30f3\u30c8\u30ea\u30fc\u30fb\u30dd\u30a4\u30f3\u30c8\u306e\u30a2\u30c9\u30ec\u30b9\u306e\u53d6\u5f97\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9\u306f {2} \u3067\u3059\u3002" },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "{0} \u5171\u6709\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u306e\u30ed\u30fc\u30c9\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u623b\u308a\u30b3\u30fc\u30c9\u306f\u3001{1} \u3067\u3059\u3002" },
		{ Message.CALL_NONZERO_RETURN_CODE, "\u547c\u3073\u51fa\u3057\u5148\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u623b\u308a\u30b3\u30fc\u30c9\u306f {0} \u3067\u3059\u3002" },
		{ Message.REMOTE_PROGRAM_ERROR, "{3} \u30b7\u30b9\u30c6\u30e0\u306e {0} \u30ea\u30e2\u30fc\u30c8\u30fb\u30d7\u30ed\u30b0\u30e9\u30e0\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {2} \u306e {1} \u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "{1} \u30b7\u30b9\u30c6\u30e0\u306e {0} \u30ea\u30e2\u30fc\u30c8\u30fb\u30d7\u30ed\u30b0\u30e9\u30e0\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "{0} \u30db\u30b9\u30c8\u540d\u306f\u3001\u4e0d\u660e\u306a TCP/IP \u30db\u30b9\u30c8\u540d\u3067\u3059\u3002" },
		{ Message.SERVERID_IS_INVALID_PORT, "\u30b5\u30fc\u30d0\u30fc ID {0} \u306f\u3001\u6709\u52b9\u306a\u30dd\u30fc\u30c8\u756a\u53f7\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.TCPIP_SERVER_ERROR, "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306f\u3001\u30b5\u30fc\u30d0\u30fc\u304c\u30ea\u30e2\u30fc\u30c8\u547c\u3073\u51fa\u3057\u5148\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u958b\u59cb\u3067\u304d\u306a\u3044\u3068\u3044\u3046\u901a\u77e5\u3092\u53d7\u3051\u53d6\u308a\u307e\u3057\u305f\u3002 \u7406\u7531\u30b3\u30fc\u30c9: {0}\u3002" },
		{ Message.INVALID_REMOTECOMTYPE, "remoteComType \u5024\u304c\u6b20\u843d\u3057\u3066\u3044\u308b\u304b\u3001\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "{0} \u30ea\u30f3\u30b1\u30fc\u30b8\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "{0} \u547c\u3073\u51fa\u3057\u5148\u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u30a8\u30f3\u30c8\u30ea\u30fc\u304c\u3001{1} \u30ea\u30f3\u30b1\u30fc\u30b8\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u3067\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" },
		{ Message.AS400_UNKNOWN_HOST, "{0} \u30db\u30b9\u30c8\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u304b\u3001\u4e0d\u660e\u3067\u3059\u3002" },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "{0} \u30b7\u30b9\u30c6\u30e0\u306b\u63a5\u7d9a\u3059\u308b\u305f\u3081\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u307e\u305f\u306f\u30e6\u30fc\u30b6\u30fc ID \u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "{3} \u30b7\u30b9\u30c6\u30e0\u3067 {2} \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001{0} AS400Toolbox \u5b9f\u884c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.AS400_NO_AUTHORITY, "{1} \u30e6\u30fc\u30b6\u30fc\u3067 {0} \u30b7\u30b9\u30c6\u30e0\u306b\u5bfe\u3059\u308b\u30ea\u30e2\u30fc\u30c8\u30fb\u30a2\u30af\u30bb\u30b9\u30fb\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30fc\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "{0} \u30b7\u30b9\u30c6\u30e0\u3067\u30b3\u30df\u30c3\u30c8\u95a2\u6570\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "{0} \u30b7\u30b9\u30c6\u30e0\u3067\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "{0} \u30b7\u30b9\u30c6\u30e0\u3078\u306e\u30a2\u30af\u30bb\u30b9\u4e2d\u306b\u3001\u30ea\u30e2\u30fc\u30c8\u63a5\u7d9a\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "EGL OS/400 \u30db\u30b9\u30c8\u30fb\u30b5\u30fc\u30d3\u30b9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u5fc5\u9808\u30d5\u30a1\u30a4\u30eb\u304c {0} \u30b7\u30b9\u30c6\u30e0\u3067\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" },
		{ Message.AS400_APPLICATION_ERROR, "{0} \u30b7\u30b9\u30c6\u30e0\u3067 {1} \u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u547c\u3073\u51fa\u3059\u969b\u306b\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u305f\u305f\u3081\u3001\u5b9f\u884c\u5358\u4f4d\u304c\u505c\u6b62\u3057\u307e\u3057\u305f\u3002 \u30e1\u30c3\u30bb\u30fc\u30b8: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "{0} \u3068\u3044\u3046\u540d\u524d\u306e\u53c2\u7167\u5909\u6570\u306f\u30cc\u30eb\u3067\u3059\u3002" },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "\u672a\u51e6\u7406\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.DATA_FORMAT_ERROR, "{0} \u5909\u6570\u306e\u5024\u306e\u5f62\u5f0f\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CONVERSION_ERROR, "{1} \u578b\u306e\u5024 {0} \u306f\u3001{2} \u578b\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "\u65e5\u4ed8\u5f62\u5f0f\u30d1\u30bf\u30fc\u30f3 {0} \u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "\u6642\u523b\u5f62\u5f0f\u30d1\u30bf\u30fc\u30f3 {0} \u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "\u30bf\u30a4\u30e0\u30fb\u30b9\u30bf\u30f3\u30d7\u5f62\u5f0f\u30d1\u30bf\u30fc\u30f3 {0} \u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.NULL_REFERENCE, "NULL \u53c2\u7167\u304c\u4f7f\u7528\u3055\u308c\u307e\u3057\u305f\u3002" },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "\u52d5\u7684\u30a2\u30af\u30bb\u30b9\u306f {0} \u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002" },
		{ Message.DYNAMIC_ACCESS_FAILED, "\u8b58\u5225\u5b50\u304c {0} \u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u304c {1} \u3067\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "\u6570\u5024\u5f62\u5f0f\u30d1\u30bf\u30fc\u30f3 {0} \u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "{0} \u3092 {1} \u306b\u5272\u308a\u5f53\u3066\u308b\u969b\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {2}" },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "SET {0} EMPTY \u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "{1} \u30b7\u30b0\u30cb\u30c1\u30e3\u30fc\u3092\u4f7f\u3063\u3066\u30e1\u30bd\u30c3\u30c9\u3092\u547c\u3073\u51fa\u3059\u969b\u306b\u3001{0} \u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.RUN_COMMAND_FAILED, "{0} \u30b3\u30de\u30f3\u30c9\u306e\u5b9f\u884c\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002  \u30a8\u30e9\u30fc: {1}" },
		{ Message.MDY_ERROR, "DateTimeLib.mdy \u95a2\u6570\u306f\u3001\u5024 {0}\u3001{1}\u3001\u304a\u3088\u3073 {2} \u3092\u6708\u3001\u65e5\u3001\u304a\u3088\u3073\u5e74\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.NON_NUMERIC_STRING, "\u975e\u6570\u5024\u30b9\u30c8\u30ea\u30f3\u30b0 {1} \u304c {0} \u306b\u6e21\u3055\u308c\u307e\u3057\u305f\u3002 \u9577\u3055\u5f15\u6570\u306b\u3088\u3063\u3066\u5b9a\u7fa9\u3055\u308c\u305f\u30b9\u30c8\u30ea\u30f3\u30b0\u90e8\u5206\u306e\u6587\u5b57\u306f\u3001\u3059\u3079\u3066\u6570\u5024\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8 {1} \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002" },
		{ Message.INT_AS_CHAR_ERROR, "StrLib.intAsChar \u3078\u306e\u5f15\u6570\u306f\u30010 \u304b\u3089 255 \u306e\u9593\u306e\u6570\u5b57\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.INVALID_LOB_LENGTH, "{0} \u306f\u3001\u30b5\u30a4\u30ba\u304c {2} \u3067\u3042\u308b {1} \u306e\u6709\u52b9\u306a\u9577\u3055\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.INVALID_LOB_POSITION, "{0} \u306f\u3001{1} \u306e\u4f4d\u7f6e\u3068\u3057\u3066\u6709\u52b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002 \u30b5\u30a4\u30ba\u306f {2} \u3067\u3059\u3002" },
		{ Message.LOB_ERROR, "Blob \u9805\u76ee\u307e\u305f\u306f Clob \u9805\u76ee\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002  \u30a8\u30e9\u30fc\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u306f {0} \u3067\u3059\u3002" },
		{ Message.START_TRANSACTION_ERROR, "\u30af\u30e9\u30b9 {0} \u3078\u306e VGLib.startTransaction \u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u4f8b\u5916\u306f {1} \u3067\u3059\u3002" },
		{ Message.INT_AS_UNICODE_ERROR, "StrLib.intAsUnicode \u3078\u306e\u5f15\u6570\u306f\u30010 \u304b\u3089 65535 \u306e\u9593\u306e\u6570\u5b57\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.INVALID_ARRAY_SIZE, "\u30b5\u30a4\u30ba\u5024 {0} \u306f {1} \u914d\u5217\u3067\u306f\u7121\u52b9\u3067\u3059\u3002 \u6700\u5927\u30b5\u30a4\u30ba\u306f {2} \u3067\u3059\u3002" },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "\u30a4\u30f3\u30c7\u30c3\u30af\u30b9 {0} \u306f {1} \u914d\u5217\u306e\u9650\u754c\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002 \u914d\u5217\u30b5\u30a4\u30ba\u306f {2} \u3067\u3059\u3002" },
		{ Message.INVALID_SUBSTRING_INDEX, "\u30b5\u30d6\u30b9\u30c8\u30ea\u30f3\u30b0\u7d22\u5f15 {0} \u304c\u7121\u52b9\u3067\u3059:{1}\u3002" },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "{0} \u914d\u5217\u306b\u5bfe\u3059\u308b\u95a2\u6570\u306e\u5f15\u6570\u304c\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.INDEX_OUT_OF_BOUNDS, "\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024 {0} \u304c\u9650\u754c\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002" },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} \u306f\u3001\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u306a\u3044\u5909\u63db\u30c6\u30fc\u30d6\u30eb\u3067\u3059\u3002" },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "csouidpwd.properties \u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u53d6\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306e\u30d0\u30c3\u30d5\u30a1\u30fc\u304c\u3001\u547c\u3073\u51fa\u3057\u3067\u6e21\u3055\u308c\u308b\u30c7\u30fc\u30bf\u306e\u91cf\u306b\u5bfe\u3057\u3066\u5c0f\u3055\u3059\u304e\u307e\u3059\u3002 \u6e21\u3055\u308c\u308b\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u7d2f\u7a4d\u30b5\u30a4\u30ba\u306f {0} \u30d0\u30a4\u30c8\u3067\u3001\u8a31\u53ef\u3055\u308c\u3066\u3044\u308b\u6700\u5927\u5024 {1} \u30d0\u30a4\u30c8\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002" },
		{ Message.INVALID_PARMFORM, "\u5c11\u306a\u304f\u3068\u3082 1 \u3064\u306e\u52d5\u7684\u914d\u5217\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u304c\u3042\u308b\u305f\u3081\u3001\u30d7\u30ed\u30b0\u30e9\u30e0 {0} \u3092\u547c\u3073\u51fa\u3059\u306b\u306f parmForm \u30ea\u30f3\u30b1\u30fc\u30b8\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092 COMMPTR \u306b\u8a2d\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" },
		{ Message.PARM_PASSING_ERROR, "\u547c\u3073\u51fa\u3057\u5148\u30d7\u30ed\u30b0\u30e9\u30e0 {0} \u306b\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u3092\u6e21\u3059\u969b\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.CALL_ERROR, "{0} \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} \u306f System i \u30b5\u30fc\u30d3\u30b9\u30fb\u30d7\u30ed\u30b0\u30e9\u30e0\u3067\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u578b\u3067\u3059\u3002" },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} \u306f System i \u30b5\u30fc\u30d3\u30b9\u30fb\u30d7\u30ed\u30b0\u30e9\u30e0\u3067\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u623b\u308a\u306e\u578b\u3067\u3059\u3002" },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "ConnectionFactory \u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002 \u4f8b\u5916\u306f {0} \u3067\u3059\u3002" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "\u76f8\u4e92\u4f5c\u7528\u307e\u305f\u306f\u63a5\u7d9a\u3092\u9589\u3058\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "\u63a5\u7d9a\u3092\u78ba\u7acb\u3067\u304d\u307e\u305b\u3093\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "\u76f8\u4e92\u4f5c\u7528\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002 \u4f8b\u5916\u306f {0} \u3067\u3059\u3002" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "\u5bfe\u8a71 Verb \u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 \u4f8b\u5916\u306f {0} \u3067\u3059\u3002" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306e\u4f5c\u696d\u5358\u4f4d\u306b\u5bfe\u3059\u308b LocalTransaction \u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002 \u4f8b\u5916\u306f {0} \u3067\u3059\u3002" },
		{ Message.ERROR_SETTING_TIMEOUT, "CICSJ2C \u547c\u3073\u51fa\u3057\u306b\u5bfe\u3059\u308b\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u5024\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 \u4f8b\u5916\u306f {0} \u3067\u3059\u3002" },
		{ Message.EXCEPTION_CALLING_CICS, "CICS \u3068\u306e\u901a\u4fe1\u306e\u8a66\u884c\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u4f8b\u5916\u306f {0} \u3067\u3059\u3002" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "\u30ea\u30e2\u30fc\u30c8 CICS \u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u3092\u5b9f\u884c\u3057\u3088\u3046\u3068\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002" },
		{ Message.EXCEPTION_CALLING_IMS, "IMS \u3068\u306e\u901a\u4fe1\u306e\u8a66\u884c\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u4f8b\u5916\u306f {0} \u3067\u3059\u3002" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "IMS \u3068\u306e\u901a\u4fe1\u306e\u8a66\u884c\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.MATH_DOMAIN_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 8 (\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc) \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u95a2\u6570\u306b\u5bfe\u3059\u308b\u5f15\u6570\u304c\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 8 (\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc) \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u5f15\u6570\u306f\u3001-1 \u304b\u3089 1 \u306e\u9593\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 8 (\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc) \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 2 \u756a\u76ee\u306e\u5f15\u6570\u306f\u3001\u30bc\u30ed\u3067\u3042\u3063\u3066\u306f\u3044\u3051\u307e\u305b\u3093\u3002" },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 8 (\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc) \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u5f15\u6570\u306f\u30bc\u30ed\u3088\u308a\u5927\u304d\u304f\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.MATH_POW_1_DOMAIN_ERR, "MathLib.pow \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 8 (\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc) \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 1 \u756a\u76ee\u306e\u5f15\u6570\u304c\u30bc\u30ed\u3067\u3042\u308b\u5834\u5408\u30012 \u756a\u76ee\u306e\u5f15\u6570\u306f\u30bc\u30ed\u3088\u308a\u5927\u304d\u304f\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.MATH_POW_2_DOMAIN_ERR, "MathLib.pow \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 8 (\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc) \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 1 \u756a\u76ee\u306e\u5f15\u6570\u304c\u30bc\u30ed\u3088\u308a\u5c0f\u3055\u3044\u5834\u5408\u30012 \u756a\u76ee\u306e\u5f15\u6570\u306f\u6574\u6570\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "MathLib.sqrt \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 8 (\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc) \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u5f15\u6570\u306f\u30bc\u30ed\u4ee5\u4e0a\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.MATH_RANGE_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 12 (\u7bc4\u56f2\u30a8\u30e9\u30fc) \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002" },		
		{ Message.STRING_INDEX_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 8 \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306f\u30011 \u3068\u30b9\u30c8\u30ea\u30f3\u30b0\u306e\u9577\u3055\u306e\u9593\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.STRING_LENGTH_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 12 \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u9577\u3055\u306f\u30bc\u30ed\u3088\u308a\u5927\u304d\u304f\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 16 \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30bf\u30fc\u30b2\u30c3\u30c8\u30fb\u30b9\u30c8\u30ea\u30f3\u30b0\u306e\u6700\u5f8c\u306e\u30d0\u30a4\u30c8\u306f\u3001\u30d6\u30e9\u30f3\u30af\u304b\u30cc\u30eb\u6587\u5b57\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 20 \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 STRING\u3001DBCHAR\u3001\u307e\u305f\u306f UNICODE \u30b5\u30d6\u30b9\u30c8\u30ea\u30f3\u30b0\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306f\u5947\u6570\u306b\u3057\u3066\u3001\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u304c\u6587\u5b57\u306e\u6700\u521d\u306e\u30d0\u30a4\u30c8\u3092\u8b58\u5225\u3059\u308b\u3088\u3046\u306b\u3057\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} \u306f\u3001\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9 24 \u3092\u51fa\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u6587\u5b57\u306e\u6574\u6570\u5024\u3092\u53c2\u7167\u3059\u308b\u306b\u306f\u3001STRING\u3001DBCHAR\u3001\u307e\u305f\u306f UNICODE \u30b5\u30d6\u30b9\u30c8\u30ea\u30f3\u30b0\u306e\u9577\u3055\u306f\u5076\u6570\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.NO_DEBUG_LISTENER, "\u30db\u30b9\u30c8\u540d {0} \u304a\u3088\u3073\u30dd\u30fc\u30c8 {1} \u3067 EGL \u30c7\u30d0\u30c3\u30ac\u30fc\u3068\u901a\u4fe1\u3067\u304d\u307e\u305b\u3093\u3002 \u4f8b\u5916\u306f {2} \u3067\u3059\u3002" },
		{ Message.DEBUG_LISTENER_PROBLEM, "\u30db\u30b9\u30c8\u540d {0} \u304a\u3088\u3073\u30dd\u30fc\u30c8 {1} \u3067\u306e EGL \u30c7\u30d0\u30c3\u30ac\u30fc\u3068\u306e\u901a\u4fe1\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u4f8b\u5916\u306f {2} \u3067\u3059\u3002" },
		{ Message.NOT_DEBUG_MODE, "\u30ea\u30f3\u30b1\u30fc\u30b8\u306b\u3088\u3063\u3066 J2EE \u30b5\u30fc\u30d0\u30fc\u5185\u3067\u306e DEBUG \u547c\u3073\u51fa\u3057\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002 \u3053\u306e\u547c\u3073\u51fa\u3057\u306f J2EE \u30b5\u30fc\u30d0\u30fc\u3067\u884c\u308f\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002J2EE \u30b5\u30fc\u30d0\u30fc\u304c\u30c7\u30d0\u30c3\u30b0\u30fb\u30e2\u30fc\u30c9\u3067\u306a\u3044\u304b\u3001J2EE \u30b5\u30fc\u30d0\u30fc\u304c EGL \u30c7\u30d0\u30c3\u30b0\u306b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.LIBRARY_NOT_SPECIFIED, "\u30ea\u30f3\u30b1\u30fc\u30b8\u306b\u3088\u3063\u3066 EGL \u30ea\u30b9\u30ca\u30fc\u3078\u306e DEBUG \u547c\u3073\u51fa\u3057\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		
		{ Message.FILETYPE_MISSING, "{0} \u30d5\u30a1\u30a4\u30eb\u306e\u30e9\u30f3\u30bf\u30a4\u30e0\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc vgj.ra.fileName.fileType \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" },
		{ Message.FILETYPE_INVALID, "{0} \u30d5\u30a1\u30a4\u30eb\u306e\u30e9\u30f3\u30bf\u30a4\u30e0\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc vgj.ra.fileName.fileType \u306e\u5024\u304c\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.INVALID_RECORD_LENGTH, "\u30ec\u30b3\u30fc\u30c9\u9577\u306e\u9805\u76ee\u306f\u3001\u9805\u76ee\u306e\u5883\u754c\u306b\u975e\u6587\u5b57\u30c7\u30fc\u30bf\u3092\u533a\u5207\u308b\u5024\u3092\u542b\u3080\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" },
		{ Message.RECORD_LENGTH_TOO_LARGE, "occursItem \u307e\u305f\u306f lengthItem \u306e\u5024\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002" },
		{ Message.IO_ERROR, "{0}: {1} \u3067\u306e I/O \u304c\u6b21\u306e\u7406\u7531\u3067\u5931\u6557\u3057\u307e\u3057\u305f: {2}\u3002" },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: \u6e96\u5099\u6e08\u307f\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8 {1} \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 [sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: \u7d50\u679c\u30bb\u30c3\u30c8 {1} \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 [sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0}: \u30a8\u30e9\u30fc [sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "{0} \u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "{0} \u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 URL \u304c\u9593\u9055\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "JDBC \u30c9\u30e9\u30a4\u30d0\u30fc\u306e\u30ed\u30fc\u30c9\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002  \u30a8\u30e9\u30fc: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "{0} ResultSet \u306f\u30b9\u30af\u30ed\u30fc\u30eb\u4e0d\u80fd\u3067\u3059\u3002" },
		{ Message.SQL_NO_DEFAULT_DATABASE, "\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002 \u30c7\u30d5\u30a9\u30eb\u30c8\u30fb\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u540d\u524d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.SQL_NO_DATABASE_CONNECTION, "SQL \u5165\u51fa\u529b\u64cd\u4f5c\u306e\u524d\u306b\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u304c\u78ba\u7acb\u3055\u308c\u3066\u3044\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.SQL_DISCONNECT_ERROR, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 {0} \u304b\u3089\u306e\u5207\u65ad\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 {0} \u3078\u306e\u63a5\u7d9a\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 \u63a5\u7d9a\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "\u95a2\u6570 SQLLib \u3067 SQL \u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002{0}: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "\u95a2\u6570 SQLLib \u3067\u975e SQL \u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002{0}: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304b\u3089 NULL \u304c\u53d7\u4fe1\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u30db\u30b9\u30c8\u5909\u6570 {0} \u306f NULL \u4e0d\u53ef\u3067\u3059\u3002" },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "\u5fc5\u9808\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u5165\u529b\u304c\u53d7\u4fe1\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "\u5165\u529b\u306e\u30c7\u30fc\u30bf\u578b\u30a8\u30e9\u30fc - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "\u8a31\u5bb9\u6709\u52b9\u6570\u5b57\u306e\u6570\u3092\u8d85\u3048\u3066\u3044\u307e\u3059 - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "{0} \u304b\u3089 {1} \u306e\u5b9a\u7fa9\u3055\u308c\u305f\u7bc4\u56f2\u3092\u8d85\u3048\u305f\u5165\u529b\u3067\u3059 - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.EDIT_VALID_VALUES_ERR, "\u6709\u52b9\u306a\u5024\u306e\u5b9a\u7fa9\u30ea\u30b9\u30c8\u306b\u542b\u307e\u308c\u306a\u3044\u5165\u529b\u3067\u3059 - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "\u6307\u5b9a\u3055\u308c\u305f\u65e5\u4ed8/\u6642\u523b\u5f62\u5f0f {0} \u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "\u5165\u529b\u6700\u5c0f\u9577\u30a8\u30e9\u30fc - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "\u6700\u5927\u5165\u529b\u6587\u5b57\u6570\u30a8\u30e9\u30fc - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "\u8868\u306e\u7de8\u96c6\u306e\u6709\u52b9\u671f\u9593\u30a8\u30e9\u30fc - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "\u5165\u529b\u306e\u30e2\u30b8\u30e5\u30e9\u30b9\u30fb\u30c1\u30a7\u30c3\u30af\u30fb\u30a8\u30e9\u30fc - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "\u5b9a\u7fa9\u3055\u308c\u305f\u65e5\u4ed8\u307e\u305f\u306f\u6642\u523b\u5f62\u5f0f {0} \u306b\u5bfe\u3059\u308b\u5165\u529b\u304c\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "\u5165\u529b\u306f\u30d6\u30fc\u30eb\u5024\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.EDIT_INVALID_PATTERN_ERR, "\u5165\u529b\u3055\u308c\u305f\u5024\u306f\u3001\u8a2d\u5b9a\u3055\u308c\u305f\u30d1\u30bf\u30fc\u30f3\u3068\u4e00\u81f4\u3057\u306a\u3044\u305f\u3081\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "\u8868\u306e\u7de8\u96c6 {0} \u306f {1} \u3067\u306f\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "16 \u9032\u30c7\u30fc\u30bf\u304c\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.EDIT_VALIDATION_ERR, "\u30da\u30fc\u30b8\u306e\u691c\u8a3c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002  \u30a8\u30e9\u30fc: {0}" },
		{ Message.EDIT_INPUT_ERR, "\u5165\u529b\u5024\u306e\u69cb\u6587\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002"},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "\u8868\u793a\u3059\u308b\u5024\u3092\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {0}\u3002"},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "SO/SI \u6587\u5b57\u3092\u4f7f\u7528\u3057\u305f\u5165\u529b\u30c7\u30fc\u30bf\u304c\u3001\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u308b\u9805\u76ee\u306e\u9577\u3055\u306b\u5bfe\u3057\u3066\u9577\u3059\u304e\u307e\u3059\u3002"},
		
		{ Message.ACTION_REQUEST_ERROR, "J2EELib RequestAttr \u95a2\u6570\u304c\u30ad\u30fc {0} \u3067\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.ACTION_SESSION_ERROR, "J2EELib SessionAttr \u95a2\u6570\u304c\u30ad\u30fc {0} \u3067\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "J2EELib ApplicationAttr \u95a2\u6570\u304c\u30ad\u30fc {0} \u3067\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib \u306f J2EE \u74b0\u5883\u3067\u306e\u307f\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002" },
		
		{ Message.PORTALLIB_SESSION_ERROR, "PortalLib PortletSessionAttr \u95a2\u6570\u304c\u3001\u30ad\u30fc {0} \u3067\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode \u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState \u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u8981\u6c42\u4e2d\u306b\u30dd\u30fc\u30c8\u30ec\u30c3\u30c8\u30fb\u30e2\u30fc\u30c9\u3092\u5909\u66f4\u3059\u308b\u3053\u3068\u3092\u8a66\u307f\u307e\u3057\u305f\u304c\u3001\u3053\u308c\u306f\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u305b\u3093" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u8981\u6c42\u4e2d\u306b\u30dd\u30fc\u30c8\u30ec\u30c3\u30c8\u30fb\u30a6\u30a3\u30f3\u30c9\u30a6\u72b6\u614b\u3092\u5909\u66f4\u3059\u308b\u3053\u3068\u3092\u8a66\u307f\u307e\u3057\u305f\u304c\u3001\u3053\u308c\u306f\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u305b\u3093" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "PortletSession \u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f" }, 
		{ Message.PORTALLIB_INVALIDKEY, "\u7121\u52b9\u306a\u30ad\u30fc\u304c\u95a2\u6570 {0} \u306b\u6e21\u3055\u308c\u307e\u3057\u305f" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "PortletRequest \u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "PortalLib resetPreferenceValue \u95a2\u6570\u304c\u3001\u30ad\u30fc {0} \u3067\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "PortalLib savePreferences \u95a2\u6570\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib \u304c\u3001\u30ad\u30fc {0} \u306e\u8a2d\u5b9a\u3092\u6307\u5b9a\u3059\u308b\u306e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib \u304c\u3001\u30ad\u30fc {0} \u306e\u8a2d\u5b9a\u3092\u53d6\u5f97\u3059\u308b\u306e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "\u8cc7\u683c\u60c5\u5831\u30dc\u30fc\u30eb\u30c8\u30fb\u30b5\u30fc\u30d3\u30b9\u3078\u306e\u30a2\u30af\u30bb\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "\u30b9\u30ed\u30c3\u30c8 {0} \u3067\u8981\u6c42\u3057\u305f\u8cc7\u683c\u60c5\u5831\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "\u30e6\u30fc\u30b6\u30fc\u30fb\u30b9\u30da\u30fc\u30b9\u306b\u8cc7\u683c\u60c5\u5831\u30dc\u30fc\u30eb\u30c8\u30fb\u30b9\u30ed\u30c3\u30c8\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "\u30e6\u30fc\u30b6\u30fc\u30fb\u30b9\u30da\u30fc\u30b9\u3067\u8cc7\u683c\u60c5\u5831\u30dc\u30fc\u30eb\u30c8\u30fb\u30b9\u30ed\u30c3\u30c8\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "\u8cc7\u683c\u60c5\u5831\u306e\u5024\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} \u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002 {1} \u3068\u3044\u3046\u540d\u524d\u306e\u30e1\u30bd\u30c3\u30c9\u306e\u8d77\u52d5\u307e\u305f\u306f\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u5bfe\u3059\u308b\u30a2\u30af\u30bb\u30b9\u306b\u3088\u308a\u3001\u672a\u51e6\u7406\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u306f {2} \u3067\u3059\u3002" },
		{ Message.JAVALIB_NULL_ID, "{0} \u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002 {1} \u306f\u8b58\u5225\u5b50\u3067\u306f\u306a\u3044\u304b\u3001NULL \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u8b58\u5225\u5b50\u3067\u3059\u3002" },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} \u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002 {1} \u3068\u3044\u3046\u540d\u524d\u306e public \u30e1\u30bd\u30c3\u30c9\u3001\u30d5\u30a3\u30fc\u30eb\u30c9\u3001\u307e\u305f\u306f\u30af\u30e9\u30b9\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\u30ed\u30fc\u30c9\u4e0d\u80fd\u3067\u3042\u308b\u304b\u3001\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u6570\u307e\u305f\u306f\u578b\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002 \u30a8\u30e9\u30fc\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u306f {2} \u3067\u3059\u3002" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} \u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002 {1} \u306e EGL \u3067\u306e\u5024\u306e\u578b\u306f\u3001Java \u3067\u4e88\u671f\u3055\u308c\u308b\u578b\u3068\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002 \u30a8\u30e9\u30fc\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u306f {2} \u3067\u3059\u3002" },
		{ Message.JAVALIB_NULL_RETURNED, "{0} \u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30bf\u30fc\u30b2\u30c3\u30c8\u306f NULL \u3092\u623b\u3057\u305f\u30e1\u30bd\u30c3\u30c9\u3067\u3042\u308b\u304b\u3001\u5024\u3092\u623b\u3055\u306a\u3044\u30e1\u30bd\u30c3\u30c9\u3067\u3042\u308b\u304b\u3001\u5024\u304c NULL \u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3067\u3059\u3002" },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} \u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002 NULL \u5f15\u6570\u306e\u30af\u30e9\u30b9 {1} \u306f\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 \u30a8\u30e9\u30fc\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u306f {2} \u3067\u3059\u3002" },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} \u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002 {1} \u3068\u3044\u3046\u540d\u524d\u306e\u30e1\u30bd\u30c3\u30c9\u307e\u305f\u306f\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u3064\u3044\u3066\u306e\u60c5\u5831\u3092\u53d6\u5f97\u3067\u304d\u306a\u304b\u3063\u305f\u304b\u3001final \u3068\u5ba3\u8a00\u3055\u308c\u305f\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u5024\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u306f {2} \u3067\u3059\u3002" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} \u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002 {1} \u306f\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u307e\u305f\u306f\u62bd\u8c61\u30af\u30e9\u30b9\u3067\u3042\u308b\u305f\u3081\u3001\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u30fc\u3092\u547c\u3073\u51fa\u3059\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.JAVALIB_NOT_STATIC, "{0} \u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002 \u30e1\u30bd\u30c3\u30c9\u307e\u305f\u306f\u30d5\u30a3\u30fc\u30eb\u30c9 {1} \u306f\u9759\u7684\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002 \u30af\u30e9\u30b9\u540d\u306e\u4ee3\u308f\u308a\u306b\u8b58\u5225\u5b50\u3092\u4f7f\u7528\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "\u30a2\u30af\u30b7\u30e7\u30f3\u30fb\u30d5\u30a3\u30fc\u30eb\u30c9 {0} \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_ARRAY_FULL, "\u5225\u306e\u884c\u3092\u633f\u5165\u3067\u304d\u307e\u305b\u3093\u3002\u5165\u529b\u914d\u5217\u304c\u30d5\u30eb\u3067\u3059\u3002" },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "{0} \u914d\u5217\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_ASSIGN_RESULT, "\u30d7\u30ed\u30f3\u30d7\u30c8\u7d50\u679c\u5909\u6570\u3078\u306e\u5272\u308a\u5f53\u3066\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002" },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "\u753b\u9762\u914d\u5217\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u30b5\u30a4\u30ba {0} \u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002"	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "DrawBox \u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002" },
		{ Message.CUI_E_BAD_COORDINATES, "\u8868\u793a\u5ea7\u6a19\u304c\u30a6\u30a3\u30f3\u30c9\u30a6\u5883\u754c\u306e\u5916\u90e8\u306b\u3042\u308a\u307e\u3059\u3002" },
		{ Message.CUI_E_BAD_KEYNAME, "\u30ad\u30fc\u540d ''{0}'' \u306e\u5f62\u5f0f\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "\u30d4\u30af\u30c1\u30e3\u30fc\u304c\u5b58\u5728\u3059\u308b\u305f\u3081\u3001\u3053\u306e\u7de8\u96c6\u6a5f\u80fd\u3092\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_BAD_WINDOW_NAME, "\u30a6\u30a3\u30f3\u30c9\u30a6 ''{0}'' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "\u65b0\u898f\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u4f4d\u7f6e [{0},{1}]/\u30c7\u30a3\u30e1\u30f3\u30b7\u30e7\u30f3 [{2},{3}] \u306e\u5024\u304c\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.CUI_E_CMDSTACK_SYNC, "\u30b3\u30de\u30f3\u30c9\u30fb\u30b9\u30bf\u30c3\u30af\u306e\u540c\u671f\u304c\u53d6\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "\u30b3\u30f3\u30bd\u30fc\u30eb UI \u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "\u30d5\u30a3\u30fc\u30eb\u30c9\u30fb\u30bf\u30a4\u30d7\u304c\u69cb\u6210\u306b\u5bfe\u3057\u3066\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "\u5909\u6570\u30ea\u30b9\u30c8\u3092\u4f7f\u7528\u3057\u3066 ConstructQuery \u3092\u547c\u3073\u51fa\u3059\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_DISABLE_INVISIBLE, "\u96a0\u3057\u30e1\u30cb\u30e5\u30fc\u9805\u76ee\u3092\u4f7f\u7528\u4e0d\u53ef\u306b\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_EDIT_FAILED, "\u7de8\u96c6\u30a2\u30af\u30b7\u30e7\u30f3\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002" },
		{ Message.CUI_E_EXEC_HOTKEY, "\u30db\u30c3\u30c8\u30fb\u30ad\u30fc\u30fb\u30a2\u30af\u30b7\u30e7\u30f3\u306e\u5b9f\u884c\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.CUI_E_EXIT_NO_CMD, "\u7d42\u4e86\u3059\u308b\u30a2\u30af\u30c6\u30a3\u30d6\u30fb\u30b3\u30de\u30f3\u30c9\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "\u7d9a\u884c\u3059\u308b\u30a2\u30af\u30c6\u30a3\u30d6\u30fb\u30b3\u30de\u30f3\u30c9\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FATALERROR, "\u81f4\u547d\u7684\u30a8\u30e9\u30fc: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "\u30d5\u30a3\u30fc\u30eb\u30c9 {0} \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "\u753b\u9762\u914d\u5217\u30d5\u30a3\u30fc\u30eb\u30c9 {0} \u304c\u914d\u5217\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FIELD_NOT_FOUND, "\u30d5\u30a3\u30fc\u30eb\u30c9 {0} \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FIELD_NO_WINDOW, "\u30a6\u30a3\u30f3\u30c9\u30a6\u306a\u3057\u3067 ConsoleField \u3092\u4f5c\u6210\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FIELD_COUNT, "\u914d\u5217\u30d5\u30a3\u30fc\u30eb\u30c9\u30fb\u30ab\u30a6\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "\u30d5\u30a9\u30fc\u30e0 {0} \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "\u30d5\u30a9\u30fc\u30e0 {0} \u304c\u30a6\u30a3\u30f3\u30c9\u30a6 {1} \u306b\u9069\u5408\u3057\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "\u30d5\u30a3\u30fc\u30eb\u30c9\u30fb\u30ea\u30b9\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FORM_IN_USE, "\u30d5\u30a9\u30fc\u30e0 {0} \u306f\u4f7f\u7528\u4e2d\u3067\u3059\u3002" },
		{ Message.CUI_E_FORM_NAME_USED, "\u540d\u524d\u304c {0} \u306e\u30d5\u30a9\u30fc\u30e0\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002" },
		{ Message.CUI_E_FORM_NOT_OPEN, "\u30d5\u30a9\u30fc\u30e0 {0} \u304c\u958b\u3044\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FORM_NO_WINDOW, "\u30a6\u30a3\u30f3\u30c9\u30a6\u306a\u3057\u3067 ConsoleForm \u3092\u4f5c\u6210\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "KeyObject.getChar() \u306f\u4eee\u60f3\u30ad\u30fc\u306b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "KeyObject.getCookedChar() \u306f\u4eee\u60f3\u30ad\u30fc\u306b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_INTERNAL, "\u5185\u90e8\u30a8\u30e9\u30fc: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "\u5272\u308a\u8fbc\u307f\u4fe1\u53f7\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002" },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "\u30a2\u30af\u30bb\u30e9\u30ec\u30fc\u30bf\u30fc\u306a\u3057\u306e\u96a0\u3057\u30e1\u30cb\u30e5\u30fc\u9805\u76ee\u306f\u8a31\u53ef\u3055\u308c\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_LABEL_NO_WINDOW, "\u30a6\u30a3\u30f3\u30c9\u30a6\u306a\u3057\u3067 ConsoleLabel \u3092\u4f5c\u6210\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "\u30e1\u30cb\u30e5\u30fc\u9805\u76ee {0} \u304c\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u9069\u5408\u3057\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_MISSING_ITEM, "\u30e1\u30cb\u30e5\u30fc\u9805\u76ee {0} \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "\u30e1\u30cb\u30e5\u30fc\u7c21\u7565\u8a18\u53f7\u304c\u77db\u76fe\u3057\u3066\u3044\u307e\u3059 (key={0})\u3002" },
		{ Message.CUI_E_NO_ACTIVE_FORM, "\u30a2\u30af\u30c6\u30a3\u30d6\u306a\u30d5\u30a9\u30fc\u30e0\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_NO_EDITOR, "blob \u30a8\u30c7\u30a3\u30bf\u30fc\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_NO_HELP_FILE, "\u30d8\u30eb\u30d7\u30fb\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_NO_HELP_MSG, "\u30d8\u30eb\u30d7\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_NO_NUMPAGES, "\u30e1\u30cb\u30e5\u30fc\u304c\u30ec\u30a4\u30a2\u30a6\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_NO_SCREENARRAY, "\u30a2\u30af\u30c6\u30a3\u30d6\u753b\u9762\u914d\u5217\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "\u8868\u793a\u53ef\u80fd\u306a\u30e1\u30cb\u30e5\u30fc\u9805\u76ee\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_NULL_WNDOW_NAME, "\u65b0\u3057\u3044\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u540d\u524d\u304c\u30cc\u30eb\u3067\u3057\u305f\u3002" },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "null \u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u958b\u3053\u3046\u3068\u3057\u307e\u3057\u305f\u3002" },
		{ Message.CUI_E_PROMPT_EXCEPTION, "\u30d7\u30ed\u30f3\u30d7\u30c8\u3067\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.CUI_E_QUIT_RECEIVED, "\u7d42\u4e86\u4fe1\u53f7\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002" },
		{ Message.CUI_E_SCROLL_FAILED, "\u30e1\u30cb\u30e5\u30fc\u3092\u73fe\u5728\u306e\u9805\u76ee\u306b\u30b9\u30af\u30ed\u30fc\u30eb\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "\u4e0d\u660e\u306a\u5c5e\u6027 ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "\u30d5\u30a3\u30fc\u30eb\u30c9 {0} \u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.CUI_E_VAR_LIST_SHORT, "\u5341\u5206\u306a\u6570\u306e\u5909\u6570\u304c\u6307\u5b9a\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.CUI_E_WINDOW_NAME_USED, "\u30a6\u30a3\u30f3\u30c9\u30a6\u540d {0} \u306f\u65e2\u306b\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002" },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "\u30d8\u30eb\u30d7\u753b\u9762\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u30fb\u30b5\u30a4\u30ba\u304c\u5c0f\u3055\u3059\u304e\u307e\u3059\u3002" },
		{ Message.CUI_E_VALID_VALUES, "\u6307\u5b9a\u3055\u308c\u305f\u5024\u306f\u3001\u6709\u52b9\u306a\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_W_NO_MORE_FIELDS, "\u9032\u3093\u3067\u3044\u308b\u65b9\u5411\u306b\u306f\u3053\u308c\u4ee5\u4e0a\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_W_NO_MORE_ROWS, "\u9032\u3093\u3067\u3044\u308b\u65b9\u5411\u306b\u306f\u3053\u308c\u4ee5\u4e0a\u884c\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "\u753b\u9762\u914d\u5217 {0} \u306e\u5185\u5bb9\u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "\u753b\u9762\u914d\u5217 {0} \u306b\u30bb\u30b0\u30e1\u30f3\u30c8\u5316\u30d5\u30a3\u30fc\u30eb\u30c9 {1} \u3092\u5165\u308c\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002"	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "\u753b\u9762\u914d\u5217 {0} \u306f\u30c7\u30fc\u30bf\u914d\u5217\u3068\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FIELD_NAME_DUP, "\u30d5\u30a3\u30fc\u30eb\u30c9\u540d {0} \u304c\u8907\u6570\u56de\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002" },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "\u30b3\u30f3\u30bd\u30fc\u30eb\u30fb\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u9577\u3055 {0} \u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.CUI_E_LABEL_NOT_FIT, "[{0}, {1}] \u306e\u30e9\u30d9\u30eb\u304c\u4f7f\u7528\u53ef\u80fd\u306a\u30b9\u30da\u30fc\u30b9\u306b\u9069\u5408\u3057\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_FIELD_NOT_FIT, "({1}, {2}) \u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u30fb\u30bb\u30b0\u30e1\u30f3\u30c8 {0} \u304c\u4f7f\u7528\u53ef\u80fd\u306a\u30b9\u30da\u30fc\u30b9\u306b\u9069\u5408\u3057\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_PROMPT_TOO_LONG,"\u30d7\u30ed\u30f3\u30d7\u30c8\u30fb\u30b9\u30c8\u30ea\u30f3\u30b0\u304c\u3001\u30a2\u30af\u30c6\u30a3\u30d6\u30fb\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u5bfe\u3057\u3066\u9577\u3059\u304e\u307e\u3059\u3002"},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"OpenUI \u914d\u5217\u5f15\u6570\u304c\u7121\u52b9\u3067\u3059\u3002"},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "OpenUI \u30d5\u30a3\u30fc\u30eb\u30c9\u5f15\u6570\u304c\u7121\u52b9\u3067\u3059\u3002"},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "\u5358\u4e00\u306e\u5909\u6570\u306e\u307f\u304c\u30d7\u30ed\u30f3\u30d7\u30c8\u30fb\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3078\u30d0\u30a4\u30f3\u30c9\u3055\u308c\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "\u30b3\u30f3\u30bd\u30fc\u30eb\u30fb\u30d5\u30a3\u30fc\u30eb\u30c9 {0} \u306e\u30c7\u30fc\u30bf\u30fb\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "\u8b66\u544a: NUL \u6587\u5b57\u304c clob \u30c7\u30fc\u30bf\u3067\u691c\u51fa\u3055\u308c\u307e\u3057\u305f" },
		{ Message.CUI_I_STR_WINDOWTITLE , "EGL \u30b3\u30f3\u30bd\u30fc\u30eb\u30fb\u30a6\u30a3\u30f3\u30c9\u30a6" },
		{ Message.CUI_E_MISSING_FORMAT , "\u30d5\u30a3\u30fc\u30eb\u30c9 {0} \u306b\u5f62\u5f0f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "\u4e8c\u3064\u306e\u30a8\u30f3\u30c8\u30ea\u30fc\u304c\u540c\u3058\u3067\u3042\u308a\u307e\u305b\u3093 -- \u518d\u8a66\u884c\u3057\u3066\u304f\u3060\u3055\u3044" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "\u78ba\u8a8d\u306e\u305f\u3081\u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044" },
		{ Message.CUI_I_STR_HELP,"\u30d8\u30eb\u30d7"},
		{ Message.CUI_I_STR_RESUME,"\u518d\u958b"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"\u30d8\u30eb\u30d7\u30fb\u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002"},
		{ Message.CUI_I_STR_SCROLL , "\u30b9\u30af\u30ed\u30fc\u30eb" },
		{ Message.CUI_I_STR_LAST_PAGE, "\u30d8\u30eb\u30d7\u30fb\u30c6\u30ad\u30b9\u30c8\u306e\u6700\u5f8c\u3067\u3059\u3002 \u7d9a\u884c\u3059\u308b\u306b\u306f\u300c\u623b\u308b\u300d\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002"},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "\u30d8\u30eb\u30d7\u30fb\u30c6\u30ad\u30b9\u30c8\u306e\u6b21\u306e\u30da\u30fc\u30b8\u3092\u8868\u793a\u3057\u307e\u3059\u3002"},
		{ Message.CUI_I_STR_SELECT , "\u9078\u629e"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "\u7a7a\u306e\u914d\u5217\u3078\u306e\u6700\u521d\u306e\u884c\u306e\u633f\u5165\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002"},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 \u304c\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"},
		{ Message.CUI_E_UNIMP_FN_KEYS , "\u5185\u90e8: F25-64 \u304c\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "CursesCanvas \u306e\u8907\u6570\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u6301\u3064\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas \u306f\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas \u304c\u5c0f\u3055\u3059\u304e\u307e\u3059"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "\u540d\u524d\u9806\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u8868\u793a\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "\u6700\u5c0f\u5165\u529b {0} \u304c\u5fc5\u9808\u3067\u3059 - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "\u6700\u5927\u5165\u529b {0} \u3092\u8d85\u3048\u3066\u3044\u307e\u3059 - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "\u30b9\u30af\u30ea\u30d7\u30c8\u30fb\u30d5\u30a1\u30a4\u30eb ''{0}'' \u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "\u30b9\u30af\u30ea\u30d7\u30c8\u30fb\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u53d6\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002"},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc automation.scenario ''{0}'' \u304c\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002"},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "\u518d\u751f\u30b9\u30af\u30ea\u30d7\u30c8\u5185\u306e <click> \u30c7\u30a3\u30ec\u30af\u30c6\u30a3\u30d6\u306e\u5f62\u5f0f\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002"},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "\u81ea\u52d5\u5316\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc ''{0}'' \u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002"},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "\u7121\u52b9\u306a\u30d1\u30cb\u30c3\u30af\u30fb\u30ad\u30fc\u540d ''{0}''"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "<click> \u3067\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002"},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a1\u30a4\u30eb ''{0}'' \u3092\u958b\u3051\u307e\u305b\u3093\u3002"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "automation.scriptdir \u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30bb\u30c3\u30c8 ''{0}'' \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002"},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "automation.scenario \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30bb\u30c3\u30c8 ''{0}'' \u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002"},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "\u7121\u52b9\u306a\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u30fb\u30ad\u30fc\u540d ''{0}''"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "\u6bd4\u8f03\u306f\u6b63\u5e38\u306b\u884c\u308f\u308c\u307e\u3057\u305f\u3002"},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "RCP \u30e2\u30fc\u30c9\u3067\u306e\u5b9f\u884c\u4e2d\u306f\u3001\u8868\u793a\u5165\u51fa\u529b\u64cd\u4f5c\u306e\u4f7f\u7528\u306f\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "ID \u304c {0} \u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u30e1\u30c3\u30bb\u30fc\u30b8\u30fb\u30c6\u30fc\u30d6\u30eb {1} \u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.MSG_TBL_LOAD_ERR, "\u30e1\u30c3\u30bb\u30fc\u30b8\u30fb\u30c6\u30fc\u30d6\u30eb\u30fb\u30d5\u30a1\u30a4\u30eb {0} \u3092\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "VGUIRecord {0} \u306b\u5bfe\u3057\u3066\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u308b\u30e6\u30fc\u30b6\u30fc\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u30fb\u30c6\u30fc\u30d6\u30eb\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "\u4f4d\u7f6e ({1},{2}) \u306e\u30d5\u30a3\u30fc\u30eb\u30c9 ''{0}'' \u304c\u30d5\u30a9\u30fc\u30e0\u5185\u306b\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_FIELD_OVERLAP, "\u30d5\u30a3\u30fc\u30eb\u30c9 ''{0}'' \u304c ''{1}'' \u3068\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3057\u3066\u3044\u307e\u3059\u3002" },
		{ Message.TUI_E_NO_FORMGROUP, "\u5185\u90e8\u30a8\u30e9\u30fc: \u66f8\u5f0f\u30b0\u30eb\u30fc\u30d7\u3092\u5224\u5225\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "\u30d5\u30a9\u30fc\u30e0 ''{0}'' \u306f\u3069\u306e\u6d6e\u52d5\u57df\u306b\u3082\u9069\u5408\u3057\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_BAD_FIELD_COORDS, "\u30d5\u30a3\u30fc\u30eb\u30c9 ''{0}'' \u306e\u5ea7\u6a19\u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "\u5370\u5237\u95a2\u9023\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "\u9069\u5207\u306a\u5370\u5237\u88c5\u7f6e\u30b5\u30a4\u30ba\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_NO_DISPLAY, "\u66f8\u5f0f\u306e\u305f\u3081\u306e\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4\u88c5\u7f6e\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "\u8868\u793a\u3055\u308c\u305f\u66f8\u5f0f\u306b\u306f\u77db\u76fe\u3057\u306a\u3044\u88c5\u7f6e\u30b5\u30a4\u30ba\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "\u30d8\u30eb\u30d7\u30fb\u30d5\u30a9\u30fc\u30e0\u30af\u30e9\u30b9 ''{0}'' \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "\u4e0d\u660e\u306a\u5c5e\u6027 ''{0}''\u3002" },
		{ Message.TUI_E_INVALID_VALID_VALUE, "\u6709\u52b9\u306a\u5024\u5c5e\u6027\u306b\u6307\u5b9a\u3055\u308c\u305f\u5024\u304c\u8aa4\u3063\u3066\u3044\u308b\u305f\u3081\u69cb\u6587\u89e3\u6790\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "\u30d8\u30eb\u30d7\u66f8\u5f0f ''{0}'' \u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093" },
		{ Message.TUI_E_INTERNAL, "\u5185\u90e8\u30a8\u30e9\u30fc: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "\u4f7f\u7528\u53ef\u80fd\u306a\u30d7\u30ea\u30f3\u30bf\u30fc\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "\u30c7\u30d5\u30a9\u30eb\u30c8\u30fb\u30d7\u30ea\u30f3\u30bf\u30fc\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "\u30d7\u30ea\u30f3\u30bf\u30fc ''{0}'' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n\u6b21\u306e\u30d7\u30ea\u30f3\u30bf\u30fc\u304c\u4f7f\u7528\u53ef\u80fd\u3067\u3059\u3002\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "\u30e1\u30c3\u30bb\u30fc\u30b8 ''{0}'' \u306e\u30ed\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "{0} \u306e\u5185\u5bb9\u306f\u30d5\u30a3\u30fc\u30eb\u30c9\u3068\u3057\u3066\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "\u5370\u5237\u88c5\u7f6e ''{0}'' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "\u30d7\u30ed\u30b0\u30e9\u30e0 {0} \u3067\u306f\u3001show \u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u306b\u30c6\u30ad\u30b9\u30c8\u66f8\u5f0f {1} \u304c\u5fc5\u8981\u3067\u3059\u304c\u3001\u30c6\u30ad\u30b9\u30c8\u66f8\u5f0f {2} \u304c\u63d0\u4f9b\u3055\u308c\u307e\u3057\u305f\u3002" },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "\u6b21\u3078" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "{0}/{1} \u30da\u30fc\u30b8" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "\u524d\u3078" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "\u5370\u5237" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "\u5370\u5237\u30d7\u30ec\u30d3\u30e5\u30fc - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "\u4fdd\u5b58" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "\u5370\u5237\u30b8\u30e7\u30d6\u306e\u4fdd\u5b58 - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "\u30d5\u30a1\u30a4\u30eb {0} \u3078\u306e\u51fa\u529b\u4e2d\u306e\u30a8\u30e9\u30fc" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "\u30d7\u30ea\u30f3\u30bf\u30fc {0} \u3078\u306e\u51fa\u529b\u4e2d\u306e\u30a8\u30e9\u30fc" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "EZEMNO \u306e\u8a2d\u5b9a" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "\u30d5\u30a3\u30fc\u30eb\u30c9 ''{0}'' \u306e\u691c\u67fb" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "\u30c6\u30ad\u30b9\u30c8\u30fb\u30d5\u30a9\u30fc\u30e0\u306e\u691c\u8a3c" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "\u30c6\u30ad\u30b9\u30c8\u30fb\u30d5\u30a9\u30fc\u30e0\u306e\u691c\u8a3c - \u30d0\u30ea\u30c7\u30fc\u30bf\u30fc\u95a2\u6570 ''{0}'' \u306e\u5b9f\u884c" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "\u30ed\u30b0\u51fa\u529b\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "\u30ed\u30ae\u30f3\u30b0\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc ''{0}'' \u3092\u59cb\u52d5\u5f8c\u306b\u8a2d\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "\u30ed\u30b0\u30fb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc ''{0}'' \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "\u30ed\u30b0\u30fb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc ''{0}'' \u3078\u306e\u66f8\u304d\u8fbc\u307f\u304c\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "\u30ed\u30b0\u30fb\u30d5\u30a1\u30a4\u30eb ''{0}'' \u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "\u30ed\u30b0\u30fb\u30d5\u30a1\u30a4\u30eb ''{0}'' \u3078\u306e\u66f8\u304d\u8fbc\u307f\u304c\u3067\u304d\u307e\u305b\u3093\u3002" },
		
		{ Message.SOA_E_LOAD_SERVICE, "Component/ExternalService {0} \u306e\u30b5\u30fc\u30d3\u30b9\u306e\u30ed\u30fc\u30c9\u4e2d\u306b\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "Web \u30b5\u30fc\u30d3\u30b9\u64cd\u4f5c ''{0}'' \u3078\u306e\u63a5\u7d9a\u3092\u4f5c\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002  {1}\u3002" },
		{ Message.SOA_E_WS_GET_OPERATION, "Wsdl \u30d5\u30a1\u30a4\u30eb ''{1}'' \u304b\u3089\u306e\u64cd\u4f5c ''{0}'' \u306e\u53d6\u5f97\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_WS_MALFORMED_URL, "Web \u30b5\u30fc\u30d3\u30b9\u64cd\u4f5c {1} \u306e\u30bf\u30fc\u30b2\u30c3\u30c8 URL \u306f\u7121\u52b9\u3067\u3059\u3002 URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "{0} \u30b5\u30fc\u30d3\u30b9\u306e\u30ed\u30fc\u30c9\u4e2d\u306b\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc: {1}" },
		{ Message.SOA_E_LOAD_WEB_PROXY, "Web \u30b5\u30fc\u30d3\u30b9\u3092\u30ed\u30fc\u30c9\u3057\u3088\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u5916\u90e8\u30b5\u30fc\u30d3\u30b9 {0} \u306e WSDL \u30dd\u30fc\u30c8\u3092\u89e3\u6c7a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "{0} \u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u306b\u3001\u30b5\u30fc\u30d3\u30b9\u5b9f\u88c5\u306b\u5fc5\u8981\u306a {1} \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u304c\u6b20\u843d\u3057\u3066\u3044\u307e\u3059\u3002" },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "\u30b5\u30fc\u30d3\u30b9\u53c2\u7167 ''{0}'' \u306f\u3001\u6b20\u843d\u3057\u3066\u3044\u308b\u304b\u3001\u30bf\u30fc\u30b2\u30c3\u30c8\u5024\u3092\u6709\u3057\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_MISSING_BINDING, "\u30b5\u30fc\u30d3\u30b9\u30fb\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0 ''{0}'' \u304c\u30c7\u30d7\u30ed\u30a4\u30e1\u30f3\u30c8\u8a18\u8ff0\u5b50 ''{1}'' \u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "\u30ec\u30b3\u30fc\u30c9 ''{0}'' \u3092 SOAP \u30e1\u30c3\u30bb\u30fc\u30b8\u306b\u5909\u63db\u3057\u3088\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002  \u30ec\u30b3\u30fc\u30c9\u306b\u30d5\u30a3\u30fc\u30eb\u30c9 ''{1}'' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "''{0}'' \u3092 SOAP \u30e1\u30c3\u30bb\u30fc\u30b8\u306b\u5909\u63db\u3057\u3088\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002"},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "Web \u30b5\u30fc\u30d3\u30b9\u304b\u3089\u306e\u30a4\u30f3\u30d0\u30a6\u30f3\u30c9\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 Java \u30bf\u30a4\u30d7\u306f EGL \u30bf\u30a4\u30d7\u3068\u975e\u4e92\u63db\u3067\u3059\u3002" },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "Web \u30b5\u30fc\u30d3\u30b9\u3078\u306e\u30a2\u30a6\u30c8\u30d0\u30a6\u30f3\u30c9\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 EGL \u30bf\u30a4\u30d7\u306f Java \u30bf\u30a4\u30d7\u3068\u975e\u4e92\u63db\u3067\u3059\u3002" },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "\u30ec\u30b3\u30fc\u30c9 ''{0}'' \u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "\u5024 ''{0}'' \u3092 Calendar \u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "\u5024 ''{0}'' \u3092\u30d6\u30fc\u30eb\u5024\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "\u5024 ''{0}'' \u3092\u30d0\u30a4\u30c8\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "\u5024 ''{0}'' \u3092 short \u578b\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "\u5024 ''{0}'' \u3092 URI \u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "EGL \u30bf\u30a4\u30d7\u306f Web \u30b5\u30fc\u30d3\u30b9\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u3068\u3057\u3066\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "\u30ec\u30b3\u30fc\u30c9\u914d\u5217\u3092\u4f5c\u6210\u3057\u3088\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {0}" },
		{ Message.SOA_E_METHOD_NOT_FOUND, "\u30e1\u30bd\u30c3\u30c9 {0} \u304c\u30b5\u30fc\u30d3\u30b9 {1} \u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.SOA_E_NOT_WEB_SERVICE, "\u30b5\u30fc\u30d3\u30b9\u304c Web \u30b5\u30fc\u30d3\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "\u95a2\u6570 {0} \u3092 Web \u30b5\u30fc\u30d3\u30b9 {1} \u3067\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "\u95a2\u6570 {0} \u3092 EGL \u30b5\u30fc\u30d3\u30b9 {1} \u3067\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "\u95a2\u6570 {0} \u3092 EGL \u30b5\u30fc\u30d3\u30b9 {1} \u3067 {2}:{3} \u3092\u4f7f\u7528\u3057\u3066\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "\u30b5\u30fc\u30d3\u30b9\u304c tcpip \u30b5\u30fc\u30d3\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "\u95a2\u6570 {0} \u3092\u30a8\u30f3\u30c8\u30ea\u30fc\u30fb\u30dd\u30a4\u30f3\u30c8 {1} \u3067\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "\u30b5\u30fc\u30d3\u30b9\u30fb\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0\u30fb\u30d5\u30a1\u30a4\u30eb {0} \u3092\u30ed\u30fc\u30c9\u3057\u3088\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "\u95a2\u6570 {0} \u3092 CICS \u30b5\u30fc\u30d3\u30b9 {1} \u3067\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9:{2}\u3001\u30e1\u30c3\u30bb\u30fc\u30b8:{3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "\u95a2\u6570 {0} \u3092 iSeries \u30b5\u30fc\u30d3\u30b9 {1} \u3067\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30c9:{2}\u3001\u30e1\u30c3\u30bb\u30fc\u30b8:{3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "\u30b5\u30fc\u30d3\u30b9\u304c CICS \u30b5\u30fc\u30d3\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "\u30b7\u30b9\u30c6\u30e0 {3} \u306e\u30ea\u30e2\u30fc\u30c8\u30fb\u30b5\u30fc\u30d3\u30b9 {0} \u3067\u65e5\u4ed8 {1}\u3001\u6642\u523b {2} \u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "\u30b7\u30b9\u30c6\u30e0 {1} \u306e\u30ea\u30e2\u30fc\u30c8\u30fb\u30b5\u30fc\u30d3\u30b9 {0} \u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "\u30b5\u30fc\u30d3\u30b9 {1} \u306e\u547c\u3073\u51fa\u3057\u3092\u8a66\u884c\u3059\u308b\u30b7\u30b9\u30c6\u30e0 {0} \u4e0a\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u30fb\u30a8\u30e9\u30fc\u306e\u305f\u3081\u3001\u5b9f\u884c\u5358\u4f4d\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002 \u30e1\u30c3\u30bb\u30fc\u30b8: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "\u30b7\u30b9\u30c6\u30e0 {3} \u306e\u30b5\u30fc\u30d3\u30b9 {2} \u3092\u547c\u3073\u51fa\u3057\u4e2d\u306e AS400Toolbox \u5b9f\u884c\u30a8\u30e9\u30fc: {0}\u3001{1}\u3002" },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u306a\u3044\u30b5\u30fc\u30d3\u30b9\u30fb\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30fb\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0\u3067\u3059\u3002 Websphere \u3067 {0} \u304c\u751f\u6210\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u3053\u308c\u306f\u975e J2EE \u74b0\u5883\u304b\u3089\u547c\u3073\u51fa\u3055\u308c\u3066\u3044\u307e\u3059\u3002 \u975e J2EE \u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u5185\u306b\u518d\u751f\u6210\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.SOA_E_USER_ID_NOT_SET, "Web \u30b5\u30fc\u30d3\u30b9:{0} \u95a2\u6570:{1} \u3092\u547c\u3073\u51fa\u3059\u524d\u306b\u3001\u30ea\u30e2\u30fc\u30c8\u30fb\u30e6\u30fc\u30b6\u30fc ID \u304a\u3088\u3073\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u8a2d\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "\u30b5\u30fc\u30d3\u30b9\u306e\u547c\u3073\u51fa\u3057\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "\u30b5\u30fc\u30d3\u30b9\u3068\u901a\u4fe1\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "REST \u30b5\u30fc\u30d3\u30b9\u547c\u3073\u51fa\u3057\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0: {0}\u3001\u64cd\u4f5c: {0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "SOAP \u30b5\u30fc\u30d3\u30b9\u547c\u3073\u51fa\u3057\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0: {0}\u3001\u30b5\u30fc\u30d3\u30b9: {1}\u3001\u30dd\u30fc\u30c8: {2}\u3001WSDL \u30ed\u30b1\u30fc\u30b7\u30e7\u30f3: {3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "JSON \u304b\u3089\u306e\u5909\u63db\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30d1\u30e9\u30e1\u30fc\u30bf\u30fc: {0}\u3001JSON: {1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "JSON \u3078\u306e\u5909\u63db\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30d1\u30e9\u30e1\u30fc\u30bf\u30fc: {0}\u3001\u5024: {1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "REST-RPC \u30b5\u30fc\u30d3\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002 URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "\u30b5\u30fc\u30d3\u30b9\u304b\u3089\u306e\u5fdc\u7b54\u3092\u53d7\u4fe1\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002 URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "\u8981\u6c42\u3092\u30b5\u30fc\u30d3\u30b9\u547c\u3073\u51fa\u3057\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 \u53d7\u4fe1\u3057\u305f\u8981\u6c42\u306f\u300c{0}\u300d\u3067\u3059\u3002 " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "\u30b5\u30fc\u30d3\u30b9\u547c\u3073\u51fa\u3057\u304c\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u306b\u306a\u308a\u307e\u3057\u305f\u3002 \u4f8b\u5916: \u63a5\u7d9a\u306e\u8aad\u307f\u53d6\u308a\u306e\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u30fb\u30a8\u30e9\u30fc\u3002 URL:{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "\u30b5\u30fc\u30d3\u30b9\u304c REST \u30b5\u30fc\u30d3\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_REST_SERVICE, "REST \u30b5\u30fc\u30d3\u30b9\u306e\u547c\u3073\u51fa\u3057\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0:{0}\u3001\u64cd\u4f5c:{1}\u3001HTTP \u30e1\u30bd\u30c3\u30c9:{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "\u30c7\u30fc\u30bf\u306e EGL \u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u3078\u306e\u5909\u63db\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0:{0}\u3001\u5909\u63db\u3059\u308b\u30c7\u30fc\u30bf{1}\u3001\u4f8b\u5916:{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "REST \u30b5\u30fc\u30d3\u30b9\u547c\u3073\u51fa\u3057\u304c\u975e REST \u30b5\u30fc\u30d3\u30b9\u53c2\u7167\u3067\u884c\u308f\u308c\u307e\u3057\u305f\u3002\u30b5\u30fc\u30d3\u30b9\u30fb\u53c2\u7167: {0}\u3001\u64cd\u4f5c {1}\u3001HTTP \u30e1\u30bd\u30c3\u30c9: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "XML \u304b\u3089\u306e\u5909\u63db\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u5fc5\u9808\u8981\u7d20 {0} \u304c\u6b20\u843d\u3057\u3066\u3044\u307e\u3059\u3002" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "XML \u304b\u3089\u306e\u5909\u63db\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc:{0}\u3001XML:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "XML \u3078\u306e\u5909\u63db\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc: {0}\u3001\u5024: {1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "XML \u304b\u3089 {0} \u3092\u5909\u63db\u4e2d\u306b XML \u69cb\u6587\u89e3\u6790\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "{0} \u3092 XML \u306b\u5909\u63db\u4e2d\u306b XML \u5909\u63db\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "\u30b5\u30fc\u30d3\u30b9\u306e\u547c\u3073\u51fa\u3057\u306b\u4f7f\u7528\u3055\u308c\u308b URL \u300c{0}\u300d\u304c\u7121\u52b9\u3067\u3059\u3002http:// \u30d7\u30ed\u30c8\u30b3\u30eb\u304c\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "\u30b5\u30fc\u30d3\u30b9\u306e\u547c\u3073\u51fa\u3057\u306b\u4f7f\u7528\u3055\u308c\u308b URL \u300c{0}\u300d\u304c\u7121\u52b9\u3067\u3059\u3002{1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "\u30b5\u30fc\u30d3\u30b9\u306e\u547c\u3073\u51fa\u3057\u306b\u4f7f\u7528\u3055\u308c\u308b URL \u304c\u7a7a\u767d\u3067\u3059\u3002\u305d\u306e\u30b5\u30fc\u30d3\u30b9\u3092\u6307\u3059 URL \u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "\u63a5\u7d9a {0} \u3092\u4f7f\u7528\u3057\u305f\u30ec\u30dd\u30fc\u30c8\u306b\u5145\u3066\u3093\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "SQL \u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8 {0} \u3092\u4f7f\u7528\u3057\u305f\u30ec\u30dd\u30fc\u30c8\u306b\u5145\u3066\u3093\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "\u52d5\u7684\u914d\u5217 {0} \u3092\u4f7f\u7528\u3057\u305f\u30ec\u30dd\u30fc\u30c8\u306b\u5145\u3066\u3093\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"},
		{ Message.REPORT_E_FILL_ERROR , "\u30ec\u30dd\u30fc\u30c8 {0} \u3092\u5145\u3066\u3093\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"},
		{ Message.REPORT_E_EXPORT_ERROR, "\u30ec\u30dd\u30fc\u30c8 {0} \u3092\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "EGL {0} \u30bf\u30a4\u30d7\u3068 Java {1} \u30bf\u30a4\u30d7\u3068\u306e\u9593\u306e\u5909\u63db\u306f\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "Java {0} \u30bf\u30a4\u30d7\u3068 EGL {1} \u30bf\u30a4\u30d7\u3068\u306e\u9593\u306e\u5909\u63db\u306f\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "\u30ec\u30dd\u30fc\u30c8\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "\u30ec\u30dd\u30fc\u30c8\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u30fb\u30ea\u30b9\u30c8\u3092\u30ea\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "\u30d5\u30a3\u30fc\u30eb\u30c9\u540d {0} \u306f\u8aa4\u308a\u3067\u3059" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "\u30b5\u30d6\u30ec\u30dd\u30fc\u30c8\u540d {0} \u306f\u8aa4\u308a\u3067\u3059\u3002" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "\u30ec\u30dd\u30fc\u30c8\u5185\u3067\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u306a\u3044\u578b\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "\u3053\u306e\u95a2\u6570\u306b\u8907\u5408\u578b\u3092\u6e21\u3059\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "\u8a2d\u8a08\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u3001getParameterDefaultValue() \u95a2\u6570\u3092\u547c\u3073\u51fa\u3059\u524d\u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc {0} \u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "\u30ec\u30dd\u30fc\u30c8\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc {0} \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "\u8a2d\u8a08\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u3001createReportFromDesign() \u95a2\u6570\u307e\u305f\u306f createDocument() \u95a2\u6570\u3092\u547c\u3073\u51fa\u3059\u524d\u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "\u6587\u66f8\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u3001createReportFromDocument() \u95a2\u6570\u3092\u547c\u3073\u51fa\u3059\u524d\u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "\u30ec\u30dd\u30fc\u30c8\u6587\u66f8\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "\u8a2d\u8a08\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u30ec\u30dd\u30fc\u30c8\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "\u6587\u66f8\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u30ec\u30dd\u30fc\u30c8\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "BirtReport \u306b\u6307\u5b9a\u3057\u305f\u30cf\u30f3\u30c9\u30e9\u30fc\u30fb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u30bf\u30a4\u30d7 BirtHandler \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "\u8981\u7d20 {0} \u306f\u3001\u30ec\u30dd\u30fc\u30c8\u8a2d\u8a08\u306b\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\u6307\u5b9a\u3057\u305f\u30bf\u30a4\u30d7\u306e\u8981\u7d20\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "{0} \u884c\u756a\u53f7 {1} \u306f\u3001\u8868 {2} \u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "\u884c\u756a\u53f7 {0} \u306f\u3001\u30b0\u30ea\u30c3\u30c9\u8981\u7d20 {1} \u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "\u30b0\u30eb\u30fc\u30d7 {0} \u306f\u3001\u8868 {1} \u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "{0} \u884c\u756a\u53f7 {1} \u306f\u3001\u8868 {3} \u306e\u30b0\u30eb\u30fc\u30d7 {2} \u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "\u5217\u756a\u53f7 {0} \u306f\u3001\u30c6\u30fc\u30d6\u30eb {2} \u306e {1} \u884c\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "\u5217\u756a\u53f7 {0} \u306f\u3001\u30b0\u30ea\u30c3\u30c9 {1} \u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "\u5217\u756a\u53f7 {0} \u306f\u3001\u8868 {3} \u5185\u306e\u30b0\u30eb\u30fc\u30d7 {2} \u306e {1} \u884c\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "\u30c6\u30fc\u30d6\u30eb {0} \u306e\u884c\u307e\u305f\u306f\u30bb\u30eb\u306e\u30a4\u30d9\u30f3\u30c8\u30fb\u30cf\u30f3\u30c9\u30e9\u30fc\u95a2\u6570\u3067\u306f\u3001''RowType'' \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u6307\u5b9a\u3057\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "Java \u306e\u30bf\u30a4\u30d7 {0} \u3092 EGL \u30bf\u30a4\u30d7\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "EGL \u30bf\u30a4\u30d7 {0} \u3092 Java \u30bf\u30a4\u30d7\u306b\u5909\u63db\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "\u30c7\u30fc\u30bf\u30fb\u30bb\u30c3\u30c8 {0} \u304c\u30ec\u30dd\u30fc\u30c8\u8a2d\u8a08\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "\u30c7\u30fc\u30bf\u30fb\u30bb\u30c3\u30c8 {0} \u306f\u30b9\u30af\u30ea\u30d7\u30c8\u30fb\u30c7\u30fc\u30bf\u30fb\u30bb\u30c3\u30c8\u3067\u3059\u304c\u3001\u6b21\u306e eventType \u306e\u3044\u305a\u308c\u3082\u51e6\u7406\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f: openEvent\u3001fetchEvent\u3001closeEvent" },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "\u30c7\u30fc\u30bf\u30fb\u30bd\u30fc\u30b9 {0} \u304c\u30ec\u30dd\u30fc\u30c8\u8a2d\u8a08\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "\u30c7\u30fc\u30bf\u30fb\u30bd\u30fc\u30b9 {0} \u306f\u30b9\u30af\u30ea\u30d7\u30c8\u30fb\u30c7\u30fc\u30bf\u30fb\u30bd\u30fc\u30b9\u3067\u3059\u304c\u3001\u6b21\u306e eventType \u306e\u3044\u305a\u308c\u3082\u51e6\u7406\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f: openEvent\u3001closeEvent" },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "\u5217\u756a\u53f7 {0} \u306f\u3001\u30c7\u30fc\u30bf\u30fb\u30bb\u30c3\u30c8 {1} \u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "\u30c7\u30fc\u30bf\u30fb\u30bb\u30c3\u30c8 {1} \u304b\u3089\u5217 {0} \u3092\u53d6\u5f97\u3059\u308b\u969b\u306b\u3001\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "\u30b9\u30af\u30ea\u30d7\u30c8\u30fb\u30c7\u30fc\u30bf\u30fb\u30bb\u30c3\u30c8 {1} \u306e\u5217 {0} \u3092\u8a2d\u5b9a\u3059\u308b\u969b\u306b\u3001\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "\u5217\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0 {0} \u3092\u53d6\u5f97\u3059\u308b\u969b\u306b\u3001\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc vgj.defaultI4GLNativeLibrary \u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc {0} \u306e\u30ed\u30fc\u30c9\u304c\u5931\u6557\u3057\u307e\u3057\u305f {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "\u623b\u3055\u308c\u305f\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u304c\u95a2\u6570\u3068\u4e00\u81f4\u3057\u307e\u305b\u3093" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "\u30e1\u30e2\u30ea\u30fc\u3092\u5272\u308a\u632f\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "\u30bf\u30a4\u30d7\u9593\u306e\u5909\u63db\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "\u65e5\u6642\u307e\u305f\u306f\u9593\u9694\u306e\u7cbe\u5ea6\u304c\u7121\u52b9\u3067\u3059"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "\u30c7\u30fc\u30bf\u306b\u5bfe\u3057\u3066\u6587\u5b57\u30db\u30b9\u30c8\u5909\u6570\u304c\u77ed\u3059\u304e\u307e\u3059"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "\u95a2\u6570\u304c\u30b7\u30f3\u30dc\u30eb\u30fb\u30c6\u30fc\u30d6\u30eb\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "TEXT \u307e\u305f\u306f BYTE \u30c7\u30fc\u30bf\u578b\u304c\u3053\u306e\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u5185\u306b\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "\u30b9\u30bf\u30c3\u30af\u306e\u5024\u3092\u3001\u5024\u306e\u30bf\u30a4\u30d7\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "\u30b9\u30bf\u30c3\u30af\u306e\u5024\u3092 ANY \u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"},
		{ Message.CINTERFACE_E_POP_ERROR, "\u30b9\u30bf\u30c3\u30af\u304b\u3089\u578b {0} \u306e\u5024\u3092\u30dd\u30c3\u30d7\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "\u30b9\u30bf\u30c3\u30af\u306b\u578b {1} \u306e\u5024\u3092\u30d7\u30c3\u30b7\u30e5\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "\u30d7\u30c3\u30b7\u30e5/\u30dd\u30c3\u30d7\u3059\u308b\u3082\u306e\u304c\u3042\u308a\u307e\u305b\u3093"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "\u30ed\u30b1\u30fc\u30bf\u30fc\u3092\u30b9\u30bf\u30c3\u30af\u304b\u3089\u30dd\u30c3\u30d7\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "\u30b9\u30bf\u30c3\u30af\u304c\u7a7a\u3067\u3059"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "\u30ed\u30b1\u30fc\u30bf\u30fc\u3092\u30b3\u30d4\u30fc\u3067\u304d\u307e\u305b\u3093"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "null \u53c2\u7167\u304c\u30b9\u30bf\u30c3\u30af\u306b\u30d7\u30c3\u30b7\u30e5\u3055\u308c\u307e\u3057\u305f"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "Any \u3092\u30b9\u30bf\u30c3\u30af\u306b\u30d7\u30c3\u30b7\u30e5\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "\u30b9\u30bf\u30c3\u30af\u306e\u8981\u7d20\u3092\u4efb\u610f\u578b\u306b\u5272\u308a\u5f53\u3066\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "\u623b\u308a\u306e\u578b\u306e\u4e0d\u4e00\u81f4\u3067\u3059"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u578b\u306e\u4e0d\u4e00\u81f4\u3067\u3059"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "EGL \u30bd\u30fc\u30b9\u30fb\u30d5\u30a1\u30a4\u30eb {0} \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002  \u751f\u6210\u3055\u308c\u305f\u30b3\u30fc\u30c9\u304c\u4ee3\u308f\u308a\u306b\u5b9f\u884c\u3055\u308c\u307e\u3059\u3002" },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "Web \u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3 {0} \u306e EGL \u30bd\u30fc\u30b9\u30fb\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "\u30d5\u30a9\u30fc\u30e0 \"{1}\" \u3092\u8868\u793a\u4e2d\u306b\u3001\u30d5\u30a3\u30fc\u30eb\u30c9 \"{0}\" \u3067\u6b21\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u8a2d\u5b9a\u306e\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, " {0}\n\n\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u4e88\u671f\u3055\u308c\u308b\u5185\u90e8\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u306f \"{1}\" \u3067\u3059\u3002\u30c7\u30d0\u30c3\u30b0\u30fb\u30d3\u30eb\u30c9\u8a18\u8ff0\u5b50\u5185\u306e EGL Java \u30e9\u30f3\u30bf\u30a4\u30e0\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u5185\u306b\u3042\u308b\u65e5\u4ed8\u5f62\u5f0f\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3001\u307e\u305f\u306f\u3001\u65e5\u4ed8\u5f62\u5f0f\u306b\u5f71\u97ff\u3092\u4e0e\u3048\u308b JDBC \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\n\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u8868\u793a\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u306f \"{1}\" \u3067\u3059\u3002\u66f8\u5f0f\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u3042\u308b \"{2}\" \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002" },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "\u30d7\u30ed\u30b0\u30e9\u30e0 {0} \u306f\u3001Web \u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u3068\u3057\u3066\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002" },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "Web \u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u306b\u5165\u529b UI \u30ec\u30b3\u30fc\u30c9 {0} \u304c\u63d0\u4f9b\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u5165\u529b UI \u30ec\u30b3\u30fc\u30c9 {1} \u3067\u5b9a\u7fa9\u3055\u308c\u307e\u3057\u305f\u3002" },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "\u5165\u529b\u306f\u30d6\u30fc\u30eb\u5024\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u7121\u52b9\u3067\u3059\u3002" },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "\u30d7\u30ed\u30b0\u30e9\u30e0 {0} \u306f\u975e\u30a2\u30af\u30c6\u30a3\u30d6\u3067\u3042\u308b\u305f\u3081\u3001\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "\u30e6\u30fc\u30b6\u30fc\u30fb\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u30fb\u30ec\u30b3\u30fc\u30c9 {0} \u306b\u542b\u307e\u308c\u3066\u3044\u308b\u3001\u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u30fb\u30b5\u30fc\u30d6\u30ec\u30c3\u30c8\u306b\u9001\u4fe1\u3055\u308c\u308b\u30c7\u30fc\u30bf\u304c\u591a\u3059\u304e\u307e\u3059\u3002" },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u3001\u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u30fb\u30b5\u30fc\u30d6\u30ec\u30c3\u30c8\u304b\u3089\u306e\u30c7\u30fc\u30bf\u3092\u691c\u67fb\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002  \u30c7\u30fc\u30bf ID \u306f {0} \u3067\u3059\u3002" },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "\u914d\u5217\u30e9\u30c3\u30d1\u30fc {0} \u3092\u3001\u6700\u5927\u30b5\u30a4\u30ba\u3088\u308a\u62e1\u5f35\u3055\u305b\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002 \u30e1\u30bd\u30c3\u30c9 {1} \u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} \u306f\u3001\u914d\u5217\u30e9\u30c3\u30d1\u30fc {1} \u306b\u5bfe\u3057\u3066\u7121\u52b9\u306a\u7d22\u5f15\u3067\u3059\u3002 \u6700\u5927\u30b5\u30a4\u30ba: {2}\u3002 \u73fe\u884c\u30b5\u30a4\u30ba: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} \u306f\u3001\u914d\u5217\u30e9\u30c3\u30d1\u30fc {1} \u306e\u6709\u52b9\u306a\u6700\u5927\u30b5\u30a4\u30ba\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} \u306f\u3001\u30bf\u30a4\u30d7 {1} \u306e\u914d\u5217\u30e9\u30c3\u30d1\u30fc\u306b\u8ffd\u52a0\u3059\u308b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30fb\u30bf\u30a4\u30d7\u3068\u3057\u3066\u7121\u52b9\u3067\u3059\u3002" },
		
		{ Message.IMS_HOST_ABORT, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30db\u30b9\u30c8\u304b\u3089\u4e2d\u65ad\u30d1\u30b1\u30c3\u30c8\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002"},
		{ Message.IMS_HOST_TCPIP_ERROR, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30db\u30b9\u30c8\u3067 TCPIP \u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30bb\u30af\u30b7\u30e7\u30f3:{0} TCPIP \u64cd\u4f5c:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "\u547c\u3073\u51fa\u3057\u4e2d\u306b\u30db\u30b9\u30c8\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002{0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "\u30db\u30b9\u30c8\u304b\u3089\u8aa4\u3063\u305f\u5fdc\u7b54\u30d1\u30b1\u30c3\u30c8\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002 \u4e88\u671f\u3055\u308c\u308b\u5024:{0} \u53d7\u4fe1\u3057\u305f\u5024:{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "\u30b9\u30c8\u30a2\u30fc\u30c9\u30fb\u30d7\u30ed\u30b7\u30fc\u30b8\u30e3\u30fc\u306e\u5b9f\u884c\u4e2d\u306e\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u3002 {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "\u30b9\u30c8\u30a2\u30fc\u30c9\u30fb\u30d7\u30ed\u30b7\u30fc\u30b8\u30e3\u30fc\u306e\u5b9f\u884c\u4e2d\u306e SQL \u30a8\u30e9\u30fc\u3002 {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "\u5b9f\u884c\u4e2d\u306e\u30ea\u30e2\u30fc\u30c8\u30fb\u30db\u30b9\u30c8\u3067\u306e\u30a8\u30e9\u30fc:{0} RETCODE:{1} DLI \u30d7\u30ed\u30ad\u30b7\u30fc\u30fb\u30b8\u30e7\u30d6 ID:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30db\u30b9\u30c8\u3067\u306e DLI \u30a8\u30e9\u30fc\u3002 DLI \u95a2\u6570:{0} AIB \u623b\u308a:0x{1} AIB \u7406\u7531:0x{2} statusCode:{3} DLI \u30d7\u30ed\u30ad\u30b7\u30fc\u30fb\u30b8\u30e7\u30d6 ID:{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30db\u30b9\u30c8\u3067\u306e DLI \u30a8\u30e9\u30fc\u3002 DLI \u95a2\u6570:{0} AIB \u623b\u308a:0x{1} AIB \u7406\u7531:0x{2} DLIVar.statusCode:{3} DLIVar.DbName:{4} DLIVar.SegmentName:{5} DLIVar.SegmentLevel:{6} DLI \u30d7\u30ed\u30ad\u30b7\u30fc\u30fb\u30b8\u30e7\u30d6 ID:{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "AIB \u623b\u308a\u30b3\u30fc\u30c9\u306f\u3001PCB \u30b9\u30c6\u30fc\u30bf\u30b9\u30fb\u30b3\u30fc\u30c9\u3092\u793a\u3057\u3066\u3044\u307e\u3059\u304c\u3001PCB \u306f\u8fd4\u308a\u307e\u305b\u3093\u3002 AIB \u95a2\u6570:{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30db\u30b9\u30c8\u4e0a\u306e CALL EZEDBTCP \u3067\u767a\u751f\u3057\u305f\u4f8b\u5916\u3002 \u30bb\u30af\u30b7\u30e7\u30f3:{0} TCPIP \u64cd\u4f5c:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30db\u30b9\u30c8\u3067\u7570\u5e38\u7d42\u4e86\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 \u30eb\u30fc\u30c1\u30f3:{0} \u30e1\u30c3\u30bb\u30fc\u30b8:{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30db\u30b9\u30c8\u3067\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 CALL:{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "\u30c7\u30d0\u30c3\u30ac\u30fc\u306f\u3001\u3053\u306e DLI \u95a2\u6570\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u307e\u305b\u3093\u3002 \u95a2\u6570:{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "DL/I \u547c\u3073\u51fa\u3057\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u304c\u3001DL/I \u30a2\u30af\u30bb\u30b9\u306b\u306f\u30d3\u30eb\u30c9\u8a18\u8ff0\u5b50\u304c \u69cb\u6210\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "\u30ea\u30e2\u30fc\u30c8\u4f8b\u5916: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "PSB \u3092\u5272\u308a\u632f\u308d\u3046\u3068\u3057\u305f\u969b\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 IMSID \u306f DL/I \u30a2\u30af\u30bb\u30b9 \u304c\u3042\u308b\u3088\u3046\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u304c\u3001PSB \u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "RBD \u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3068\u30db\u30b9\u30c8\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002 RBD \u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30fb\u30d0\u30fc\u30b8\u30e7\u30f3:{0} \u30db\u30b9\u30c8\u30fb\u30d0\u30fc\u30b8\u30e7\u30f3:{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "\u30db\u30b9\u30c8\u30fb\u30d7\u30ed\u30b0\u30e9\u30e0\u3078\u306e\u547c\u3073\u51fa\u3057\u304b\u3089\u623b\u3055\u308c\u305f\u30c7\u30fc\u30bf\u306e\u53d6\u5f97\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "PCB \u540d\u306e\u53d6\u5f97\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002PCB \u30a4\u30f3\u30c7\u30c3\u30af\u30b9:{0}\u3001PCB \u6570:{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
