/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_ko extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "{0}\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.FUNCTION_ERROR_INFO, "{1} \ud568\uc218\ub97c \ucc98\ub9ac\ud558\ub294 \uc911\uc5d0 {0}\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.FILE_ERROR_INFO, "{2} \ud589\uc5d0\uc11c {1} \ud568\uc218\ub97c \ucc98\ub9ac\ud558\ub294 \uc911\uc5d0 {0}\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.PROPERTIES_FILE_MISSING, "{0} \ud2b9\uc131 \ud30c\uc77c\uc744 \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.LOAD_LIBRARY_FAILED, "{0} \ub77c\uc774\ube0c\ub7ec\ub9ac\ub97c \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ub2e4\uc74c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "{0} \uc720\ud615\uc758 \uc624\ube0c\uc81d\ud2b8\ub97c \uc791\uc131\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub2e4\uc74c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "InitialContext\ub97c \uc791\uc131\ud558\uac70\ub098 java:comp/env environment\ub97c \uac80\uc0c9\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub2e4\uc74c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {0}" },
		{ Message.LISTENER_ERROR, "\ub2e4\uc74c \uc608\uc678 \ubc0f \uba54\uc2dc\uc9c0\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc608\uc678: {0}. \uba54\uc2dc\uc9c0: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "{0} \ud2b9\uc131\uc758 \uac12\uc774 \ud544\uc694\ud569\ub2c8\ub2e4." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "\uc678\ubd80 \uc885\uc18d\uc131\uc774 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc74c \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc608\uc678: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "{0} \ubc0f {1} \ud53c\uc5f0\uc0b0\uc790\ub97c \ube44\uad50\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.ASSIGNMENT_OVERFLOW, "{0}\uc758 \uac12\uc744 {1}\uc5d0 \uc9c0\uc815\ud558\ub294 \ub3d9\uc548 \uc624\ubc84\ud50c\ub85c\uc6b0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.EXPRESSION_OVERFLOW, "\ub2e4\uc74c \ud45c\ud604\uc2dd\uc744 \uacc4\uc0b0\ud558\ub294 \uc911\uc5d0 \uc624\ubc84\ud50c\ub85c\uc6b0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "{1} \ubc0f {2} \ud53c\uc5f0\uc0b0\uc790\uc5d0 \ub300\ud574 {0} \uc5f0\uc0b0\uc790\uac00 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.UNSUPPORTED_OPERAND, "{2} \uc720\ud615\uc758 {1} \ud53c\uc5f0\uc0b0\uc790\uc5d0 \ub300\ud574 {0} \uc5f0\uc0b0\uc790\uac00 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "{1} \uc720\ud615\uc758 {0} \ud53c\uc5f0\uc0b0\uc790\uc5d0 \ub300\ud574 \uc11c\ube0c\uc2a4\ud06c\ub9bd\ud2b8 \uc5f0\uc0b0\uc790\uac00 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "{1} \uc720\ud615\uc758 {0} \ud53c\uc5f0\uc0b0\uc790\uc5d0 \ub300\ud574 \ud558\uc704 \ubb38\uc790\uc5f4 \uc5f0\uc0b0\uc790\uac00 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "{1} \uc720\ud615\uc758 {0} \ud53c\uc5f0\uc0b0\uc790\uc5d0 \ub300\ud574 SET EMPTY \ubb38\uc774 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.INVALID_REGULAR_EXPRESSION, "{0} \uc77c\ubc18 \ud45c\ud604\uc2dd\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "CICSSSL \ud504\ub85c\ud1a0\ucf5c\uc744 \uc0ac\uc6a9\ud560 \ub54c ctgKeyStore\uc640 ctgKeyStorePassword\ub97c \ubaa8\ub450 \uc9c0\uc815\ud574\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.INVALID_CTGPORT, "CTG \ud3ec\ud2b8 \ud56d\ubaa9\uc758 {0} \uac12\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CTG_CONNECT_FAILED, "CTG\uc5d0 \uc5f0\uacb0\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. CTG \uc704\uce58\ub294 {0}\uc785\ub2c8\ub2e4. CTG \ud3ec\ud2b8\ub294 {1}\uc785\ub2c8\ub2e4. \ub2e4\uc74c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "CTG \uc5f0\uacb0\uc744 \ub04a\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. CTG \uc704\uce58\ub294 {0}\uc785\ub2c8\ub2e4. CTG \ud3ec\ud2b8\ub294 {1}\uc785\ub2c8\ub2e4. \ub2e4\uc74c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {2}" },
		{ Message.NO_CICS, "CICS ECI\ub97c \uc0ac\uc6a9\ud558\ub294 {0} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9ac\ud134 \ucf54\ub4dc\ub294 -3(ECI_ERR_NO_CICS)\uc785\ub2c8\ub2e4. CICS \uc2dc\uc2a4\ud15c ID\ub294 {1}\uc785\ub2c8\ub2e4." },
		{ Message.CICS_DIED, "CICS ECI\ub97c \uc0ac\uc6a9\ud558\ub294 {0} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9ac\ud134 \ucf54\ub4dc\ub294 -4(ECI_ERR_CICS_DIED)\uc785\ub2c8\ub2e4. CICS \uc2dc\uc2a4\ud15c ID\ub294 {1}\uc785\ub2c8\ub2e4." },
		{ Message.CICS_TIMEOUT, "CICS ECI\ub97c \uc0ac\uc6a9\ud558\ub294 {0} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9ac\ud134 \ucf54\ub4dc\ub294 -6(ECI_ERR_RESPONSE_TIMEOUT)\uc785\ub2c8\ub2e4. CICS \uc2dc\uc2a4\ud15c ID\ub294 {1}\uc785\ub2c8\ub2e4." },
		{ Message.CICS_TRANSACTION_ABEND, "CICS ECI\ub97c \uc0ac\uc6a9\ud558\ub294 {0} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9ac\ud134 \ucf54\ub4dc\ub294 -7(ECI_ERR_TRANSACTION_ABEND)\uc785\ub2c8\ub2e4. CICS \uc2dc\uc2a4\ud15c ID\ub294 {1}\uc785\ub2c8\ub2e4. \uc774\uc0c1 \uc885\ub8cc \ucf54\ub4dc\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.CICS_UNKNOWN_SERVER, "CICS ECI\ub97c \uc0ac\uc6a9\ud558\ub294 {0} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9ac\ud134 \ucf54\ub4dc\ub294 -22(ECI_ERR_UNKNOWN_SERVER)\uc785\ub2c8\ub2e4. CICS \uc2dc\uc2a4\ud15c ID\ub294 {1}\uc785\ub2c8\ub2e4." },
		{ Message.CICS_SECURITY_ERROR, "CICS ECI\ub97c \uc0ac\uc6a9\ud558\ub294 {0} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9ac\ud134 \ucf54\ub4dc\ub294 -27(ECI_ERR_SECURITY_ERROR)\uc785\ub2c8\ub2e4. CICS \uc2dc\uc2a4\ud15c ID\ub294 {1}\uc785\ub2c8\ub2e4." },
		{ Message.CICS_MAX_SYSTEMS, "CICS ECI\ub97c \uc0ac\uc6a9\ud558\ub294 {0} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9ac\ud134 \ucf54\ub4dc\ub294 -28(ECI_ERR_MAX_SYSTEMS)\uc785\ub2c8\ub2e4. CICS \uc2dc\uc2a4\ud15c ID\ub294 {1}\uc785\ub2c8\ub2e4." },
		{ Message.CICS_NONZERO_RETURN_CODE, "\uc774\ub984\uc774 {2}\uc778 \uc0ac\uc6a9\uc790\uc5d0 \ub300\ud574 {1} \uc2dc\uc2a4\ud15c\uc5d0\uc11c {0} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. CICS ECI \ud638\ucd9c\uc5d0\uc11c \ub9ac\ud134 \ucf54\ub4dc {3} \ubc0f \uc774\uc0c1 \uc885\ub8cc \ucf54\ub4dc {4}\uc774(\uac00) \ub9ac\ud134\ub418\uc5c8\uc2b5\ub2c8\ub2e4." },
		{ Message.CICS_COMMIT_FAILED, "\uc791\uc5c5 \ub2e8\uc704\ub97c \ud655\uc57d\ud558\ub294 CICS ECI\ub97c \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. CICS \ub9ac\ud134 \ucf54\ub4dc\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.CICS_ROLLBACK_FAILED, "\uc791\uc5c5 \ub2e8\uc704\ub97c \ub864\ubc31\ud558\ub294 CICS ECI\ub97c \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. CICS \ub9ac\ud134 \ucf54\ub4dc\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.CICS_ECI_FLOW_FAILED, "CICS \uc2dc\uc2a4\ud15c {0}\uc5d0 \ub300\ud55c ECI \uc694\uccad \ud50c\ub85c\uc6b0\uc5d0\uc11c \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc608\uc678: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "\ub9e4\uac1c\ubcc0\uc218 \uae38\uc774 \uc624\ub958\uc785\ub2c8\ub2e4. \uc2a4\ud2b8\ub9bc\uc5d0 {0}\uac1c \ub9e4\uac1c\ubcc0\uc218\uac00 \uc788\uace0 \ub85c\uceec \ud568\uc218\uc5d0\ub294 {1}\uac1c \ub9e4\uac1c\ubcc0\uc218\uac00 \uc788\uc2b5\ub2c8\ub2e4." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "{0} \ubc30\uc5f4\uc758 \ucd5c\ub300 \ud06c\uae30\ub97c \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.WRONG_NUMBER_OF_PARMS, "\ud638\ucd9c\ub41c \ud504\ub85c\uadf8\ub7a8 {0}\uc5d0 {1}\uac1c\uc758 \ub9e4\uac1c\ubcc0\uc218\uac00 \ud544\uc694\ud558\uc9c0\ub9cc {2}\uac1c\uac00 \uc804\ub2ec\ub418\uc5c8\uc2b5\ub2c8\ub2e4." },
		{ Message.FUNCTION_NOT_FOUND, "\uacf5\uc720 \ub77c\uc774\ube0c\ub7ec\ub9ac {1}\uc5d0\uc11c \uc2dc\uc791\uc810 {0}\uc758 \uc8fc\uc18c\ub97c \uac00\uc838\uc624\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9ac\ud134 \ucf54\ub4dc\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "\uacf5\uc720 \ub77c\uc774\ube0c\ub7ec\ub9ac {0}\uc744(\ub97c) \ub85c\ub4dc\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9ac\ud134 \ucf54\ub4dc\ub294 {1}\uc785\ub2c8\ub2e4." },
		{ Message.CALL_NONZERO_RETURN_CODE, "\ub9ac\ud134 \ucf54\ub4dc {0}\uacfc(\uc640) \ud568\uaed8 \ud638\ucd9c\ub41c \ud504\ub85c\uadf8\ub7a8\uc774 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.REMOTE_PROGRAM_ERROR, "{3} \uc2dc\uc2a4\ud15c\uc758 \uc6d0\uaca9 \ud504\ub85c\uadf8\ub7a8 {0}\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {2}\uc758 {1}\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "{1} \uc2dc\uc2a4\ud15c\uc758 \uc6d0\uaca9 \ud504\ub85c\uadf8\ub7a8 {0}\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "\ud638\uc2a4\ud2b8 \uc774\ub984 {0}\uc774(\uac00) \uc54c \uc218 \uc5c6\ub294 TCP/IP \ud638\uc2a4\ud2b8 \uc774\ub984\uc785\ub2c8\ub2e4." },
		{ Message.SERVERID_IS_INVALID_PORT, "\uc11c\ubc84 ID {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \ud3ec\ud2b8 \ubc88\ud638\uc785\ub2c8\ub2e4." },
		{ Message.TCPIP_SERVER_ERROR, "\uc11c\ubc84\uc5d0\uc11c \uc6d0\uaca9 \ud638\ucd9c\ub41c \ud504\ub85c\uadf8\ub7a8\uc744 \uc2dc\uc791\ud560 \uc218 \uc5c6\ub2e4\ub294 \uc54c\ub9bc\uc774 \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0 \uc218\uc2e0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774\uc720 \ucf54\ub4dc: {0}" },
		{ Message.INVALID_REMOTECOMTYPE, "remoteComType \uac12\uc774 \ub204\ub77d\ub418\uc5c8\uac70\ub098 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "\ub9c1\ud06c \ud2b9\uc131 \ud30c\uc77c {0}\uc744(\ub97c) \uc5f4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "\ub9c1\ud06c \ud2b9\uc131 \ud30c\uc77c {1}\uc5d0\uc11c \ud638\ucd9c\ub41c \ud504\ub85c\uadf8\ub7a8 {0}\uc758 \ud56d\ubaa9\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.AS400_UNKNOWN_HOST, "{0} \ud638\uc2a4\ud2b8\ub97c \ucc3e\uc744 \uc218 \uc5c6\uac70\ub098 \uc54c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "\uc554\ud638 \ub610\ub294 \uc0ac\uc6a9\uc790 ID\uac00 {0} \uc2dc\uc2a4\ud15c \uc5f0\uacb0\uc5d0 \ub300\ud574 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "{3} \uc2dc\uc2a4\ud15c\uc5d0\uc11c {2} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 {0} AS400Toolbox \uc2e4\ud589 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.AS400_NO_AUTHORITY, "{1} \uc0ac\uc6a9\uc790\uc5d0 \ub300\ud574 {0} \uc2dc\uc2a4\ud15c\uc5d0 \uc6d0\uaca9 \uc561\uc138\uc2a4 \ubcf4\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "{0} \uc2dc\uc2a4\ud15c\uc5d0\uc11c \ud655\uc57d \ud568\uc218\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "{0} \uc2dc\uc2a4\ud15c\uc5d0\uc11c \ub864\ubc31 \ud568\uc218\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "{0} \uc2dc\uc2a4\ud15c\uc5d0 \uc561\uc138\uc2a4\ud558\ub294 \ub3d9\uc548 \uc6d0\uaca9 \uc5f0\uacb0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "EGL OS/400 \ud638\uc2a4\ud2b8 \uc11c\ube44\uc2a4 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {0} \uc2dc\uc2a4\ud15c\uc5d0\uc11c \ud544\uc218 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.AS400_APPLICATION_ERROR, "{1} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub824\uace0 \uc2dc\ub3c4\ud558\ub294 \ub3d9\uc548 {0} \uc2dc\uc2a4\ud15c\uc5d0\uc11c \uc751\uc6a9\ud504\ub85c\uadf8\ub7a8 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc5ec \uc2e4\ud589 \uc7a5\uce58\uac00 \uc911\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uba54\uc2dc\uc9c0: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "{0}\uc73c\ub85c \uba85\uba85\ub41c \ucc38\uc870 \ubcc0\uc218\uac00 \ub110\uc785\ub2c8\ub2e4." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "\ucc98\ub9ac\ub418\uc9c0 \uc54a\uc740 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}." },
		{ Message.DATA_FORMAT_ERROR, "{0} \ubcc0\uc218 \uac12\uc774 \uc62c\ubc14\ub978 \ud615\uc2dd\uc774 \uc544\ub2d9\ub2c8\ub2e4." },
		{ Message.CONVERSION_ERROR, "{1} \uc720\ud615\uc758 {0} \uac12\uc744 {2} \uc720\ud615\uc73c\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "\ub0a0\uc9dc \ud615\uc2dd \ud328\ud134 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "\uc2dc\uac04 \ud615\uc2dd \ud328\ud134 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "\uc2dc\uac04\uc18c\uc778 \ud615\uc2dd \ud328\ud134 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.NULL_REFERENCE, "\ub110(null) \ucc38\uc870\ub97c \uc0ac\uc6a9\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "{0}\uc5d0 \ub3d9\uc801 \uc561\uc138\uc2a4\uac00 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.DYNAMIC_ACCESS_FAILED, "ID\uac00 {0}\uc778 \ud544\ub4dc\ub97c {1}\uc5d0\uc11c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "\uc22b\uc790 \ud615\uc2dd \ud328\ud134 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "{0}\uc744(\ub97c) {1}\uc5d0 \uc9c0\uc815\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "SET {0} EMPTY \ubb38\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "{1} \uc11c\uba85\uc73c\ub85c \uba54\uc18c\ub4dc\ub97c \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 {0} \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.RUN_COMMAND_FAILED, "{0} \uba85\ub839\uc744 \uc2e4\ud589\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}." },
		{ Message.MDY_ERROR, "DateTimeLib.mdy \ud568\uc218\uac00 {0}, {1} \ubc0f {2} \uac12\uc744 \uc6d4, \uc77c \ubc0f \uc5f0\ub3c4\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.NON_NUMERIC_STRING, "{0}\uc774(\uac00) \uc22b\uc790\uac00 \uc544\ub2cc \ubb38\uc790\uc5f4 {1}\uc5d0 \uc804\ub2ec\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uae38\uc774 \uc778\uc218\uc5d0\uc11c \uc815\uc758\ud55c \ubb38\uc790\uc5f4\uc758 \ubaa8\ub4e0 \ubb38\uc790\ub294 \uc22b\uc790\uc5ec\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \uba54\uc2dc\uc9c0 {1})." },
		{ Message.INT_AS_CHAR_ERROR, "StrLib.intAsChar \uc778\uc218\ub294 0 - 255 \uc0ac\uc774\uc758 \uc22b\uc790\uc5ec\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.INVALID_LOB_LENGTH, "{0}\uc740(\ub294) \ud06c\uae30\uac00 {2}\uc778 {1}\uc5d0 \ub300\ud574 \uc62c\ubc14\ub978 \uae38\uc774\uac00 \uc544\ub2d9\ub2c8\ub2e4." },
		{ Message.INVALID_LOB_POSITION, "{0}\uc740(\ub294) {1}\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \uc704\uce58\uc785\ub2c8\ub2e4. \ud06c\uae30\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.LOB_ERROR, "Blob \ub610\ub294 Clob \ud56d\ubaa9\uc744 \ucc98\ub9ac\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958 \uba54\uc2dc\uc9c0\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.START_TRANSACTION_ERROR, "{0} \ud074\ub798\uc2a4\uc5d0 \ub300\ud55c VGLib.startTransaction\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {1}\uc785\ub2c8\ub2e4." },
		{ Message.INT_AS_UNICODE_ERROR, "StrLib.intAsUnicode \uc778\uc218\ub294 0 - 65535 \uc0ac\uc774\uc758 \uc22b\uc790\uc5ec\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.INVALID_ARRAY_SIZE, "{0} \ud06c\uae30 \uac12\uc740 {1} \ubc30\uc5f4\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ucd5c\ub300 \ud06c\uae30\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "{0} \uc0c9\uc778\uc774 {1} \ubc30\uc5f4\uc758 \ud55c\uacc4\ub97c \ucd08\uacfc\ud569\ub2c8\ub2e4. \ubc30\uc5f4 \ud06c\uae30\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.INVALID_SUBSTRING_INDEX, "\uc798\ubabb\ub41c \ubd80\ubd84 \ubb38\uc790\uc5f4 \uc0c9\uc778 {0}: {1}" },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "{0} \ubc30\uc5f4\uc5d0 \ub300\ud55c \ud568\uc218\uc758 \uc778\uc218\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.INDEX_OUT_OF_BOUNDS, "\uc0c9\uc778 \uac12 {0}\uc774(\uac00) \ud55c\uacc4\ub97c \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0}\uc740(\ub294) \uc9c0\uc6d0\ub418\uc9c0 \uc54a\ub294 \ubcc0\ud658\ud45c\uc785\ub2c8\ub2e4." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "csouidpwd.properties \ud30c\uc77c\uc744 \uc77d\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "\ud638\ucd9c\uc5d0\uc11c \uc804\ub2ec \uc911\uc778 \ub370\uc774\ud130\ub7c9\uc5d0 \ube44\ud574 \ud074\ub77c\uc774\uc5b8\ud2b8 \ubc84\ud37c\uac00 \ub108\ubb34 \uc791\uc2b5\ub2c8\ub2e4. \uc804\ub2ec\ub418\ub294 \ub9e4\uac1c\ubcc0\uc218\uc758 \ub204\uc801 \ud06c\uae30\uac00 {0}\ubc14\uc774\ud2b8\ub85c, \ucd5c\ub300 \ud5c8\uc6a9 \ud06c\uae30\uc778 {1}\ubc14\uc774\ud2b8\ub97c \ucd08\uacfc\ud569\ub2c8\ub2e4." },
		{ Message.INVALID_PARMFORM, "\ub3d9\uc801 \ubc30\uc5f4 \ub9e4\uac1c\ubcc0\uc218\uac00 \ud558\ub098 \uc774\uc0c1 \uc788\uc73c\ubbc0\ub85c parmForm \ub9c1\ud06c \ud2b9\uc131\uc740 {0} \ud504\ub85c\uadf8\ub7a8 \ud638\ucd9c\uc744 \uc704\ud574\uc11c COMMPTR\ub85c \uc124\uc815\ud574\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.PARM_PASSING_ERROR, "\ud638\ucd9c\ub41c \ud504\ub85c\uadf8\ub7a8 {0}\uc5d0 \ub9e4\uac1c\ubcc0\uc218\ub97c \uc804\ub2ec\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.CALL_ERROR, "{0} \ud504\ub85c\uadf8\ub7a8\uc744 \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0}\uc740(\ub294) System i \uc11c\ube44\uc2a4 \ud504\ub85c\uadf8\ub7a8\uc5d0\uc11c \uc9c0\uc6d0\ub418\uc9c0 \uc54a\ub294 \ub9e4\uac1c\ubcc0\uc218 \uc720\ud615\uc785\ub2c8\ub2e4." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0}\uc740(\ub294) System i \uc11c\ube44\uc2a4 \ud504\ub85c\uadf8\ub7a8\uc5d0\uc11c \uc9c0\uc6d0\ub418\uc9c0 \uc54a\ub294 \ub9ac\ud134 \uc720\ud615\uc785\ub2c8\ub2e4." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "ConnectionFactory\ub97c \uac00\uc838\uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "\uc0c1\ud638\uc791\uc6a9 \ub610\ub294 \uc5f0\uacb0\uc744 \ub2eb\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "\uc5f0\uacb0\uc744 \uc124\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "\uc0c1\ud638\uc791\uc6a9\uc744 \uac00\uc838\uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "\uc0c1\ud638\uc791\uc6a9 verb\ub97c \uc124\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "\ud074\ub77c\uc774\uc5b8\ud2b8 \uc791\uc5c5 \ub2e8\uc704\uc5d0 \ub300\ud55c LocalTransaction\uc744 \uac00\uc838\uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.ERROR_SETTING_TIMEOUT, "CICSJ2C \ud638\ucd9c\uc5d0 \uc81c\ud55c\uc2dc\uac04 \uac12\uc744 \uc124\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.EXCEPTION_CALLING_CICS, "CICS\uc640 \ud1b5\uc2e0\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "\uc6d0\uaca9 CICS \ud2b8\ub79c\uc7ad\uc158 \uc2e4\ud589\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.EXCEPTION_CALLING_IMS, "IMS\uc640 \ud1b5\uc2e0\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {0}\uc785\ub2c8\ub2e4." },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "IMS\uc640 \ud1b5\uc2e0\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.MATH_DOMAIN_ERROR, "{0}\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 8: \ub3c4\uba54\uc778 \uc624\ub958). \ud568\uc218\uc758 \uc778\uc218\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0}\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 8: \ub3c4\uba54\uc778 \uc624\ub958). \uc778\uc218\ub294 -1\uacfc 1 \uc0ac\uc774\uc5ec\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0}\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 8: \ub3c4\uba54\uc778 \uc624\ub958). \ub450 \ubc88\uc9f8 \uc778\uc218\ub294 0\uc774 \uc544\ub2c8\uc5b4\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0}\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 8: \ub3c4\uba54\uc778 \uc624\ub958). \uc778\uc218\ub294 0\ubcf4\ub2e4 \ucee4\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "MathLib.pow\uac00 \uc624\ub958 \ucf54\ub4dc 8(\ub3c4\uba54\uc778 \uc624\ub958)\ub85c \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uccab \ubc88\uc9f8 \uc778\uc218\uac00 0\uc778 \uacbd\uc6b0 \ub450 \ubc88\uc9f8\ub294 0\ubcf4\ub2e4 \ucee4\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "MathLib.pow\uac00 \uc624\ub958 \ucf54\ub4dc 8(\ub3c4\uba54\uc778 \uc624\ub958)\ub85c \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uccab \ubc88\uc9f8 \uc778\uc218\uac00 0\ubcf4\ub2e4 \uc791\uc740 \uacbd\uc6b0 \ub450 \ubc88\uc9f8\ub294 \uc815\uc218\uc5ec\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "MathLib.sqrt\uac00 \uc624\ub958 \ucf54\ub4dc 8(\ub3c4\uba54\uc778 \uc624\ub958)\ub85c \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc778\uc218\ub294 0\ubcf4\ub2e4 \ud06c\uac70\ub098 \uac19\uc544\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.MATH_RANGE_ERROR, "{0}\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 12: \ubc94\uc704 \uc624\ub958)." },		
		{ Message.STRING_INDEX_ERROR, "{0}\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 8). \uc0c9\uc778\uc740 1\uacfc \ubb38\uc790\uc5f4 \uae38\uc774 \uc0ac\uc774\uc5ec\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.STRING_LENGTH_ERROR, "{0}\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 12). \uae38\uc774\ub294 0\ubcf4\ub2e4 \ucee4\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 16). \ub300\uc0c1 \ubb38\uc790\uc5f4\uc758 \ub9c8\uc9c0\ub9c9 \ubc14\uc774\ud2b8\ub294 \uacf5\ubc31\uc774\uac70\ub098 \ub110 \ubb38\uc790\uc5ec\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0}\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 20). STRING, DBCHAR \ub610\ub294 UNICODE \ubd80\ubd84 \ubb38\uc790\uc5f4 \uc0c9\uc778\uc740 \ubb38\uc790\uc758 \uccab \ubc88\uc9f8 \ubc14\uc774\ud2b8\ub97c \uc2dd\ubcc4\ud560 \uc218 \uc788\ub3c4\ub85d \ud640\uc218\uc5ec\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0}\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\uc624\ub958 \ucf54\ub4dc 24). STRING, DBCHAR \ub610\ub294 UNICODE \ubd80\ubd84 \ubb38\uc790\uc5f4\uc758 \uae38\uc774\ub294 \ubb38\uc790\uc758 \uc815\uc218\ub85c \uac04\uc8fc\ud558\ub3c4\ub85d \uc9dd\uc218\uc5ec\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.NO_DEBUG_LISTENER, "\ud638\uc2a4\ud2b8 \uc774\ub984 {0} \ubc0f \ud3ec\ud2b8 {1}(\uc73c)\ub85c EGL \ub514\ubc84\uac70\uc5d0 \uc5f0\uacb0\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.DEBUG_LISTENER_PROBLEM, "\ud638\uc2a4\ud2b8 \uc774\ub984 {0} \ubc0f \ud3ec\ud2b8 {1}(\uc73c)\ub85c EGL \ub514\ubc84\uac70\uc640 \ud1b5\uc2e0 \ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc608\uc678\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.NOT_DEBUG_MODE, "\ub9c1\ud06c\uc5d0\uc11c J2EE \uc11c\ubc84\ub0b4\uc758 DEBUG \ud638\ucd9c\uc744 \uc9c0\uc815\ud588\uc2b5\ub2c8\ub2e4. J2EE \uc11c\ubc84\uc5d0\uc11c \ud638\ucd9c\ub418\uc9c0 \uc54a\uc558\uac70\ub098 J2EE \uc11c\ubc84\uac00 \ub514\ubc84\uadf8 \ubaa8\ub4dc\uac00 \uc544\ub2c8\uac70\ub098 J2EE \uc11c\ubc84\ub97c EGL \ub514\ubc84\uae45\uc5d0 \uc0ac\uc6a9\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.LIBRARY_NOT_SPECIFIED, "\ub9c1\ud06c\uc5d0\uc11c EGL \ub9ac\uc2a4\ub108\uc5d0 DEBUG \ud638\ucd9c\uc744 \uc9c0\uc815\ud588\uc9c0\ub9cc \ub77c\uc774\ube0c\ub7ec\ub9ac \ud2b9\uc131\uc744 \uc9c0\uc815\ud558\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		
		{ Message.FILETYPE_MISSING, "{0} \ud30c\uc77c\uc5d0 \ub300\ud574 \ub7f0\ud0c0\uc784 \ud2b9\uc131 vgj.ra.fileName.fileType\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.FILETYPE_INVALID, "\ub7f0\ud0c0\uc784 \ud2b9\uc131 vgj.ra.fileName.fileType\uc758 \uac12\uc774 {0} \ud30c\uc77c\uc5d0 \ub300\ud574 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.INVALID_RECORD_LENGTH, "\ub808\ucf54\ub4dc \uae38\uc774 \ud56d\ubaa9\uc740 \ud56d\ubaa9 \uacbd\uacc4\uc5d0\uc11c \ubb38\uc790\uac00 \uc544\ub2cc \ub370\uc774\ud130\ub97c \ubd84\ud560\ud558\ub294 \uac12\uc744 \ud3ec\ud568\ud574\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "occursItem \ub610\ub294 lengthItem\uc758 \uac12\uc774 \ub108\ubb34 \ud07d\ub2c8\ub2e4." },
		{ Message.IO_ERROR, "{0}: {1}\uc744(\ub97c) \uac16\ub294 I/O\uac00 {2} \uc774\uc720 \ub54c\ubb38\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: \uc900\ube44\ub41c \uba85\ub839\ubb38 {1}\uc744(\ub97c) \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. [sqlstate: {2}][sqlcode: {3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: \uacb0\uacfc \uc138\ud2b8 {1}\uc744(\ub97c) \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. [sqlstate: {2}][sqlcode: {3}]" },
		{ Message.SQL_ERROR, "{0}: \uc624\ub958[sqlstate: {1}][sqlcode: {2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [sqlstate: 02000][sqlcode: 100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[sqlstate: {2}][sqlcode: {3}]" },
		{ Message.SQL_CONNECTION_FAILED, "{0}\uc5d0 \uc5f0\uacb0 \ubd88\uac00\ub2a5: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "{0}\uc5d0 \uc5f0\uacb0\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc798\ubabb\ub41c \ub370\uc774\ud130\ubca0\uc774\uc2a4 URL: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "JDBC \ub4dc\ub77c\uc774\ubc84\ub97c \ub85c\ub4dc\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "\uacb0\uacfc \uc138\ud2b8 {0}\uc744(\ub97c) \uc2a4\ud06c\ub864\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "\uae30\ubcf8 \ub370\uc774\ud130\ubca0\uc774\uc2a4\uc5d0 \uc5f0\uacb0\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uae30\ubcf8 \ub370\uc774\ud130\ubca0\uc774\uc2a4 \uc774\ub984\uc744 \uc9c0\uc815\ud558\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "SQL I/O \uc870\uc791 \uc804\uc5d0 \ub370\uc774\ud130\ubca0\uc774\uc2a4 \uc5f0\uacb0\uc744 \uc124\uc815\ud574\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.SQL_DISCONNECT_ERROR, "{0} \ub370\uc774\ud130\ubca0\uc774\uc2a4 \uc5f0\uacb0\uc744 \ub04a\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "{0} \ub370\uc774\ud130\ubca0\uc774\uc2a4 \uc5f0\uacb0\uc744 \uc124\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc5f0\uacb0\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "\ud568\uc218 SQLLib.{0}\uc5d0\uc11c SQL \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "\ud568\uc218 SQLLib.{0}\uc5d0\uc11c \ube44SQL \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "\ub110(null)\uc774 \ub370\uc774\ud130\ubca0\uc774\uc2a4\uc5d0\uc11c \uc218\uc2e0\ub418\uc5c8\uc73c\ub098 \ud638\uc2a4\ud2b8 \ubcc0\uc218 {0}\uc5d0 \ub110\uc744 \uc785\ub825\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "\ud544\uc218 \ud544\ub4dc\uc5d0 \ub300\ud55c \uc785\ub825\uc744 \uc218\uc2e0\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "\uc785\ub825\ud55c \ub370\uc774\ud130 \uc720\ud615\uc5d0 \uc624\ub958\uac00 \uc788\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "\ud5c8\uc6a9 \uac00\ub2a5\ud55c \uc911\uc694 \uc22b\uc790 \uc790\ub9bf\uc218\ub97c \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "\uc815\uc758\ub41c \ubc94\uc704 {0} - {1}\uc5d0 \uc785\ub825\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624. " },
		{ Message.EDIT_VALID_VALUES_ERR, "\uc785\ub825\uc774 \uc815\uc758\ub41c \uc62c\ubc14\ub978 \uac12 \ubaa9\ub85d\uc5d0 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "{0}\uc758 \uc9c0\uc815\ub41c \ub0a0\uc9dc \ubc0f \uc2dc\uac04 \ud615\uc2dd\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. " },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "\uc785\ub825 \ucd5c\uc18c \uae38\uc774 \uc624\ub958\uc785\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "\uc785\ub825 \ucd5c\ub300 \uae38\uc774 \uc624\ub958\uc785\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "\ud14c\uc774\ube14 \ud3b8\uc9d1 \uc720\ud6a8\uc131 \uc624\ub958\uc785\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "\uc785\ub825\uc5d0 \ubaa8\ub4c8 \ud655\uc778 \uc624\ub958\uac00 \uc788\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "\uc815\uc758\ub41c \ub0a0\uc9dc \ub610\ub294 \uc2dc\uac04 \ud615\uc2dd {0}\uc5d0 \ub300\ud574 \uc785\ub825\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "\ubd80\uc6b8 \ud544\ub4dc\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \uc785\ub825\uc785\ub2c8\ub2e4." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "\uc785\ub825\ud55c \uac12\uc774 \uc124\uc815\ub41c \ud328\ud134\uacfc \uc77c\uce58\ud558\uc9c0 \uc54a\uc73c\ubbc0\ub85c \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "\ud3b8\uc9d1 \ud14c\uc774\ube14 {0}\uc774(\uac00) {1}\uc5d0 \ub300\ud574 \uc815\uc758\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "16\uc9c4 \ub370\uc774\ud130\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.EDIT_VALIDATION_ERR, "\ud398\uc774\uc9c0 \uc720\ud6a8\uc131 \uac80\uc99d \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}." },
		{ Message.EDIT_INPUT_ERR, "\uc785\ub825 \uac12\uc744 \uad6c\ubb38 \ubd84\uc11d\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "\ud45c\uc2dc\ud560 \uac12\uc744 \ud615\uc2dd\ud654\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "SO/SI \ubb38\uc790\ub97c \uac16\ub294 \uc785\ub825 \ub370\uc774\ud130\uac00 \uc815\uc758\ub41c \ud56d\ubaa9 \uae38\uc774\uc5d0 \ube44\ud574 \ub108\ubb34 \uae41\ub2c8\ub2e4."},
		
		{ Message.ACTION_REQUEST_ERROR, "J2EELib RequestAttr \ud568\uc218\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\ud0a4: {0}). \uc624\ub958: {1}" },
		{ Message.ACTION_SESSION_ERROR, "J2EELib SessionAttr \ud568\uc218\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4(\ud0a4: {0}). \uc624\ub958: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "J2EELib ApplicationAttr \ud568\uc218\uac00 {0} \ud0a4\uc640 \ud568\uaed8 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib\ub294 J2EE \ud658\uacbd\uc5d0\uc11c\ub9cc \uc0ac\uc6a9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. " },
		
		{ Message.PORTALLIB_SESSION_ERROR, "PortalLib PortletSessionAttr \ud568\uc218\uac00 {0} \ud0a4\uc640 \ud568\uaed8 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode\uac00 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState\uac00 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "\uc694\uccad \ub80c\ub354\ub9c1 \uc911\uc5d0 \ud3ec\ud2c0\ub81b \ubaa8\ub4dc\ub97c \ubcc0\uacbd\ud558\ub824\ub294 \uc798\ubabb\ub41c \uc2dc\ub3c4\uac00 \uc788\uc5c8\uc2b5\ub2c8\ub2e4." },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "\uc694\uccad \ub80c\ub354\ub9c1 \uc911\uc5d0 \ud3ec\ud2c0\ub81b \ucc3d \uc0c1\ud0dc\ub97c \ubcc0\uacbd\ud558\ub824\ub294 \uc798\ubabb\ub41c \uc2dc\ub3c4\uac00 \uc788\uc5c8\uc2b5\ub2c8\ub2e4." },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "PortletSession \uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4." }, 
		{ Message.PORTALLIB_INVALIDKEY, "{0} \ud568\uc218\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \ud0a4\uac00 \uc804\ub2ec\ub418\uc5c8\uc2b5\ub2c8\ub2e4." }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "PortletRequest \uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4." }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "PortalLib resetPreferenceValue \ud568\uc218\uac00 {0} \ud0a4\uc640 \ud568\uaed8 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "PortalLib savePreferences \ud568\uc218\uac00 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib\uc774 {0} \ud0a4\uc5d0 \ub300\ud55c \ud658\uacbd\uc744 \uc124\uc815\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib\uc774 {0} \ud0a4\uc5d0 \ub300\ud55c \ud658\uacbd \uc124\uc815\uc744 \uac00\uc838\uc624\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "\uc2e0\uc784 \uae08\uace0 \uc11c\ube44\uc2a4\uc5d0 \uc561\uc138\uc2a4\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "{0} \uc2ac\ub86f\uc758 \uc694\uccad\ub41c \uc2e0\uc784\uc5d0 \uc561\uc138\uc2a4\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "\uc0ac\uc6a9\uc790 \uacf5\uac04\uc5d0 \uc2e0\uc784 \uae08\uace0 \uc2ac\ub86f\uc744 \uc791\uc131\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "\uc0ac\uc6a9\uc790 \uacf5\uac04\uc5d0\uc11c \uc2e0\uc784 \uae08\uace0 \uc2ac\ub86f\uc744 \uc0ad\uc81c\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "\uc2e0\uc784 \uac12\uc744 \uc124\uc815\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. {1}(\uc774)\ub77c\ub294 \uba54\uc18c\ub4dc\ub97c \ud638\ucd9c\ud558\uac70\ub098 \ud544\ub4dc\uc5d0 \uc561\uc138\uc2a4\ud558\uba74 \ucc98\ub9ac\ub418\uc9c0 \uc54a\ub294 \uc624\ub958\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \uc624\ub958 \uba54\uc2dc\uc9c0\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.JAVALIB_NULL_ID, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. {1}\uc774(\uac00) ID\uac00 \uc544\ub2c8\uac70\ub098, \ub110(null) \uc624\ube0c\uc81d\ud2b8\uc758 ID\uc785\ub2c8\ub2e4." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uacf5\uc6a9 \uba54\uc18c\ub4dc, \ud544\ub4dc \ub610\ub294 {1} \ud074\ub798\uc2a4\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uac70\ub098 \ub85c\ub4dc\ud560 \uc218 \uc5c6\uac70\ub098, \ub9e4\uac1c\ubcc0\uc218 \uc218\ub098 \uc720\ud615\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc624\ub958 \uba54\uc2dc\uc9c0\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. EGL\uc5d0 \uc788\ub294 \uac12\uc758 \uc720\ud615\uc774 {1}\uc5d0 \ub300\ud55c Java\uc5d0\uc11c \uc608\uc0c1\ub418\ub294 \uc720\ud615\uacfc \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc624\ub958 \uba54\uc2dc\uc9c0\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.JAVALIB_NULL_RETURNED, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \ub300\uc0c1\uc740 \ub110(null)\uc744 \ub9ac\ud134\ud55c \uba54\uc18c\ub4dc, \uac12\uc744 \ub9ac\ud134\ud558\uc9c0 \uc54a\ub294 \uba54\uc18c\ub4dc \ub610\ub294 \uadf8\uc758 \uac12\uc774 \ub110(null)\uc778 \ud544\ub4dc\uc785\ub2c8\ub2e4." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \ub110(null) \uc778\uc218\uc758 {1} \ud074\ub798\uc2a4\ub97c \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc624\ub958 \uba54\uc2dc\uc9c0\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.JAVALIB_ACCESS_ERROR, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. {1}(\uc774)\ub77c\ub294 \uba54\uc18c\ub4dc \ub610\ub294 \ud544\ub4dc\uc5d0 \ub300\ud55c \uc815\ubcf4\ub97c \uac00\uc838\uc62c \uc218 \uc5c6\uac70\ub098, final\uc744 \uc120\uc5b8\ud55c \ud544\ub4dc\uc758 \uac12\uc744 \uc124\uc815\ud558\ub824\uace0 \ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958 \uba54\uc2dc\uc9c0\ub294 {2}\uc785\ub2c8\ub2e4." },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. {1}\uc774(\uac00) \uc778\ud130\ud398\uc774\uc2a4 \ub610\ub294 \ucd94\uc0c1 \ud074\ub798\uc2a4\uc774\ubbc0\ub85c, \uc0dd\uc131\uc790\ub97c \ud638\ucd9c\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.JAVALIB_NOT_STATIC, "{0}\uc774(\uac00) \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. {1} \ud544\ub4dc \ub610\ub294 \uba54\uc18c\ub4dc\uac00 \uc815\uc801\uc774 \uc544\ub2d9\ub2c8\ub2e4. \ud074\ub798\uc2a4 \uc774\ub984 \ub300\uc2e0 ID\ub97c \uc0ac\uc6a9\ud574\uc57c \ud569\ub2c8\ub2e4." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "\uc870\uce58 \ud544\ub4dc {0}\uc774(\uac00) \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_ARRAY_FULL, "\uc785\ub825 \ubc30\uc5f4\uc774 \uac00\ub4dd \ucc28 \uc788\uae30 \ub54c\ubb38\uc5d0 \ub2e4\ub978 \ud589\uc744 \uc0bd\uc785\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "{0} \ubc30\uc5f4\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_ASSIGN_RESULT, "\ud504\ub86c\ud504\ud2b8 \uacb0\uacfc \ubcc0\uc218\uc5d0 \ub300\ud55c \uc9c0\uc815\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "\ud654\uba74 \ubc30\uc5f4 \ud544\ub4dc\uc758 {0} \ud06c\uae30\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "DrawBox \ub9e4\uac1c\ubcc0\uc218\uac00 \ubc94\uc704\ub97c \ubc97\uc5b4\ub0a9\ub2c8\ub2e4." },
		{ Message.CUI_E_BAD_COORDINATES, "\ud45c\uc2dc \uc88c\ud45c\uac00 \ucc3d \uacbd\uacc4\ub97c \ubc97\uc5b4\ub0a9\ub2c8\ub2e4." },
		{ Message.CUI_E_BAD_KEYNAME, "\uc798\ubabb\ub41c \ud0a4 \uc774\ub984 ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "\uadf8\ub9bc\uc774 \uc788\uc73c\ubbc0\ub85c \uc774 \ud3b8\uc9d1 \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "''{0}'' \ucc3d\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "\uc0c8 \ucc3d \uc704\uce58[{0},{1}]/\ucc28\uc6d0[{2},{3}] \uac12\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_CMDSTACK_SYNC, "\uba85\ub839 \uc2a4\ud0dd\uc774 \ube44\ub3d9\uae30\uc785\ub2c8\ub2e4." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "\ucf58\uc194 UI \ub77c\uc774\ube0c\ub7ec\ub9ac\uac00 \ucd08\uae30\ud654\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "\uad6c\uc131\ud560 \ud544\ub4dc \uc720\ud615\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "ConstructQuery\ub97c \ubcc0\uc218 \ubaa9\ub85d\uc73c\ub85c \ud638\ucd9c\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "\ud45c\uc2dc\ub418\uc9c0 \uc54a\uc740 \uba54\ub274 \ud56d\ubaa9\uc744 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_EDIT_FAILED, "\ud3b8\uc9d1 \uc870\uce58\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_EXEC_HOTKEY, "Hotkey \uc870\uce58\ub97c \uc2e4\ud589\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_EXIT_NO_CMD, "\uc885\ub8cc\ud560 \ud65c\uc131 \uba85\ub839\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "\uacc4\uc18d\ud560 \ud65c\uc131 \uba85\ub839\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FATALERROR, "\uc2ec\uac01\ud55c \uc624\ub958: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "{0} \ud544\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "\ud654\uba74 \ubc30\uc5f4 \ud544\ub4dc {0}\uc774(\uac00) \ubc30\uc5f4\uc774 \uc544\ub2d9\ub2c8\ub2e4." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "{0} \ud544\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "\ucc3d \uc5c6\uc774 ConsoleField\ub97c \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FIELD_COUNT, "\ubc30\uc5f4 \ud544\ub4dc \uacc4\uc218\uac00 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "{0} \uc591\uc2dd\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "{0} \uc591\uc2dd\uc774 {1} \ucc3d\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "\ud544\ub4dc \ubaa9\ub85d\uc774 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FORM_IN_USE, "{0} \uc591\uc2dd\uc774 \uc0ac\uc6a9 \uc911\uc785\ub2c8\ub2e4." },
		{ Message.CUI_E_FORM_NAME_USED, "\uc774\ub984\uc774 {0}\uc778 \uc591\uc2dd\uc774 \uc774\ubbf8 \uc788\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FORM_NOT_OPEN, "{0} \uc591\uc2dd\uc774 \uc5f4\ub824 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FORM_NO_WINDOW, "\ucc3d \uc5c6\uc774 ConsoleForm\uc744 \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "\uac00\uc0c1 \ud0a4\uc5d0 \ub300\ud574 KeyObject.getChar()\uc744 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "\uac00\uc0c1 \ud0a4\uc5d0 \ub300\ud574 KeyObject.getCookedChar()\uc744 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_INTERNAL, "\ub0b4\ubd80 \uc624\ub958: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "INTERRUPT \uc2e0\ud638\ub97c \uc218\uc2e0\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "\ub2e8\ucd95\ud0a4\uac00 \uc5c6\ub294 \uc0c1\ud0dc\uc758 \ud45c\uc2dc\ub418\uc9c0 \uc54a\uc740 \uba54\ub274 \ud56d\ubaa9\uc744 \ud3ec\ud568\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "\ucc3d \uc5c6\uc774 ConsoleLabel\uc744 \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "\uba54\ub274 \ud56d\ubaa9 {0}\uc774(\uac00) \ucc3d\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_MISSING_ITEM, "\uba54\ub274 \ud56d\ubaa9 {0}\uc774(\uac00) \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "\uba54\ub274 \ub2c8\ubaa8\ub2c9\uc774 \ucda9\ub3cc\uc774 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4(\ud0a4={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "\ud65c\uc131 \uc591\uc2dd\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_NO_EDITOR, "Blob \ud3b8\uc9d1\uae30\ub97c \uc9c0\uc815\ud558\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_NO_HELP_FILE, "\ub3c4\uc6c0\ub9d0 \ud30c\uc77c\uc744 \uc9c0\uc815\ud558\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_NO_HELP_MSG, "\ub3c4\uc6c0\ub9d0 \uba54\uc2dc\uc9c0\ub97c \uc9c0\uc815\ud558\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_NO_NUMPAGES, "\uba54\ub274\uac00 \ub808\uc774\uc544\uc6c3\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_NO_SCREENARRAY, "\ud65c\uc131 \ud654\uba74 \ubc30\uc5f4 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "\ubcfc \uc218 \uc788\ub294 \uba54\ub274 \ud56d\ubaa9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "\uc0c8 \ucc3d\uc758 \uc774\ub984\uc774 \ub110(null)\uc785\ub2c8\ub2e4." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "\ub110(null) \ucc3d\uc744 \uc5f4\ub824\uace0 \uc2dc\ub3c4\ud569\ub2c8\ub2e4." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "\ud504\ub86c\ud504\ud2b8\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_QUIT_RECEIVED, "QUIT \uc2e0\ud638\ub97c \uc218\uc2e0\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_SCROLL_FAILED, "\uba54\ub274\uc5d0\uc11c \ud604\uc7ac \ud56d\ubaa9\uc73c\ub85c \uc2a4\ud06c\ub864\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "\uc54c \uc218 \uc5c6\ub294 \uc18d\uc131 ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "{0} \ud544\ub4dc\uc5d0 \uc624\ub958\uac00 \uc788\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_VAR_LIST_SHORT, "\uc81c\uacf5\ub41c \ubcc0\uc218\uac00 \ucda9\ubd84\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_WINDOW_NAME_USED, "\ucc3d \uc774\ub984 {0}\uc774(\uac00) \uc774\ubbf8 \uc0ac\uc6a9 \uc911\uc785\ub2c8\ub2e4." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "\ub3c4\uc6c0\ub9d0 \ud654\uba74\uc758 \ucc3d \ud06c\uae30\uac00 \ub108\ubb34 \uc791\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_VALID_VALUES, "\uc9c0\uc815\ub41c \uac12\uc774 \uc62c\ubc14\ub978 \uac12\uc774 \uc544\ub2d9\ub2c8\ub2e4." },
		{ Message.CUI_W_NO_MORE_FIELDS, "\uc774\ub3d9 \uc911\uc778 \ubc29\ud5a5\uc5d0 \ucd94\uac00 \ud544\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_W_NO_MORE_ROWS, "\uc774\ub3d9 \uc911\uc778 \ubc29\ud5a5\uc5d0 \ucd94\uac00 \ud589\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "\ud654\uba74 \ubc30\uc5f4 \ucee8\ud150\uce20 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "\ud654\uba74 \ubc30\uc5f4 {0}\uc5d0 \uc138\uadf8\uba3c\ud2b8 \ud544\ub4dc {1}\uc774(\uac00) \ud3ec\ud568\ub420 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "\ud654\uba74 \ubc30\uc5f4 {0}\uc740(\ub294) \ub370\uc774\ud130 \ubc30\uc5f4\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FIELD_NAME_DUP, "\ud544\ub4dc \uc774\ub984 {0}\uc774(\uac00) \ub450 \ubc88 \uc774\uc0c1 \uc0ac\uc6a9\ub429\ub2c8\ub2e4." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "\ucf58\uc194 \ud544\ub4dc \uae38\uc774 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_LABEL_NOT_FIT, "[{0}, {1}]\uc758 \ub808\uc774\ube14\uc774 \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac04\uaca9\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_FIELD_NOT_FIT, "({1}, {2})\uc758 \ud544\ub4dc \uc138\uadf8\uba3c\ud2b8 {0}\uc774(\uac00) \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac04\uaca9\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"\ud65c\uc131 \ucc3d\uc5d0 \ube44\ud574 \ud504\ub86c\ud504\ud2b8 \ubb38\uc790\uc5f4\uc774 \ub108\ubb34 \uae41\ub2c8\ub2e4."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"OpenUI \ubc30\uc5f4 \uc778\uc218\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "OpenUI \ud544\ub4dc \uc778\uc218\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "\ub2e8\uc77c \ubcc0\uc218\ub9cc prompt \ubb38\uc5d0 \ubc14\uc778\ub4dc\ub420 \uc218 \uc788\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "\ucf58\uc194 \ud544\ub4dc {0}\uc758 \ub370\uc774\ud130 \ubc14\uc778\ub529\uc744 \ud310\ubcc4\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "\uacbd\uace0: clob \ub370\uc774\ud130\uc5d0\uc11c NUL \ubb38\uc790\ub97c \ubc1c\uacac\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_I_STR_WINDOWTITLE , "EGL \ucf58\uc194 \ucc3d" },
		{ Message.CUI_E_MISSING_FORMAT , "{0} \ud544\ub4dc\uc5d0 \ud615\uc2dd \uc624\ube0c\uc81d\ud2b8\uac00 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "\ub450 \ud56d\ubaa9\uc774 \ub3d9\uc77c\ud558\uc9c0 \uc54a\uc74c - \ub2e4\uc2dc \uc2dc\ub3c4\ud558\uc2ed\uc2dc\uc624." },
		{ Message.CUI_I_STR_VERIFY_INPUT, "\uac80\uc99d\uc744 \uc704\ud574 \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.CUI_I_STR_HELP,"\ub3c4\uc6c0\ub9d0"},
		{ Message.CUI_I_STR_RESUME,"\uc7ac\uac1c"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"\uc774 \ub3c4\uc6c0\ub9d0 \uc138\uc158\uc744 \uc885\ub8cc\ud569\ub2c8\ub2e4."},
		{ Message.CUI_I_STR_SCROLL , "\uc2a4\ud06c\ub864" },
		{ Message.CUI_I_STR_LAST_PAGE, "\ub3c4\uc6c0\ub9d0 \ud14d\uc2a4\ud2b8\uc758 \ub05d\uc5d0 \ub3c4\ub2ec\ud588\uc2b5\ub2c8\ub2e4. \uacc4\uc18d\ud558\ub824\uba74 RETURN\uc744 \ub204\ub974\uc2ed\uc2dc\uc624."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "\ub3c4\uc6c0\ub9d0 \ud14d\uc2a4\ud2b8\uc758 \ub2e4\uc74c \ud398\uc774\uc9c0\ub97c \ud45c\uc2dc\ud569\ub2c8\ub2e4."},
		{ Message.CUI_I_STR_SELECT , "\uc120\ud0dd"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "\ube48 \ubc30\uc5f4\uc5d0 \uccab \ud589\uc744 \uc0bd\uc785\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64\uac00 \uad6c\ud604\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "\ub0b4\ubd80: F25-64\uac00 \uad6c\ud604\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "CursesCanvas\uc758 \ub2e4\uc911 \uc778\uc2a4\ud134\uc2a4\ub97c \uac00\uc9c8 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas\uac00 \ucd08\uae30\ud654\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas\uac00 \ub108\ubb34 \uc791\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "\uc774\ub984\ubcc4 \ud544\ub4dc \ud45c\uc2dc\uac00 \uad6c\ud604\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "\ucd5c\uc18c \uc785\ub825\uc218 {0}\uc774(\uac00) \ud544\uc694\ud569\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "\ucd5c\ub300 \uc785\ub825\uc218 {0}\uc744(\ub97c) \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "\uc2a4\ud06c\ub9bd\ud2b8 \ud30c\uc77c ''{0}''\uc744(\ub97c) \uc5f4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "\uc2a4\ud06c\ub9bd\ud2b8 \ud30c\uc77c\uc744 \uc77d\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "\ud2b9\uc131 automation.scenario ''{0}''\uc774(\uac00)\ub514\ub809\ud1a0\ub9ac\uac00 \uc544\ub2d9\ub2c8\ub2e4."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "\uc7ac\uc0dd \uc2a4\ud06c\ub9bd\ud2b8\uc758 <click> \uc9c0\uc2dc\ubb38\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "\uc790\ub3d9\ud654 \ud2b9\uc131 ''{0}''\uc744(\ub97c) \uac00\uc838\uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "\uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \ud328\ub2c9 \ud0a4 \uc774\ub984 ''{0}''"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "<\ud074\ub9ad>\uc5d0\uc11c \uc608\uc678\ub97c \ubc1c\uacac\ud588\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "\uc2a4\ub0c5\uc0f7 \ud30c\uc77c ''{0}''\uc744(\ub97c) \uc5f4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "automation.scriptdir ''{0}''\uc758 \ud2b9\uc131 \uc138\ud2b8\uac00 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "automation.scenario \ub514\ub809\ud1a0\ub9ac ''{0}''\uc758 \ud2b9\uc131 \uc138\ud2b8\ub97c \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "\uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \uc2a4\ub0c5\uc0f7 \ud0a4 \uc774\ub984 ''{0}''"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "\ube44\uad50 \ud655\uc778"},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "RCP \ubaa8\ub4dc\ub85c \uc2e4\ud589 \uc911\uc77c \ub54c\ub294 \ud45c\uc2dc I/O \uc624\ud37c\ub808\uc774\uc158\uc744 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "ID\uac00 {0}\uc778 \uba54\uc2dc\uc9c0\uac00 \uba54\uc2dc\uc9c0 \ud14c\uc774\ube14 {1}\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.MSG_TBL_LOAD_ERR, "\uba54\uc2dc\uc9c0 \ud14c\uc774\ube14 \ud30c\uc77c {0}\uc744(\ub97c) \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "{0} VGUIRecord\uc5d0 \uc815\uc758\ub41c \uc0ac\uc6a9\uc790 \uba54\uc2dc\uc9c0 \ud14c\uc774\ube14\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "({1},{2}) \uc704\uce58\uc758 ''{0}'' \ud544\ub4dc\uac00 \uc591\uc2dd \ub0b4\uc5d0 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_FIELD_OVERLAP, "''{0}'' \ud544\ub4dc\uac00 ''{1}''\uc744(\ub97c) \uacb9\uccd0\uc501\ub2c8\ub2e4." },
		{ Message.TUI_E_NO_FORMGROUP, "\ub0b4\ubd80 \uc624\ub958: \uc591\uc2dd \uadf8\ub8f9\uc744 \ud310\ubcc4\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "''{0}'' \uc591\uc2dd\uc774 \ub9de\ub294 \ubd80\ub3d9 \uc601\uc5ed\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "''{0}'' \ud544\ub4dc \uc88c\ud45c\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "\uc778\uc1c4 \uc5f0\uad00\uc744 \uac00\uc838\uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "\uc801\ud569\ud55c \uc778\uc1c4 \uc7a5\uce58 \ud06c\uae30\uac00 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_NO_DISPLAY, "\uc591\uc2dd \ud45c\uc2dc \uc7a5\uce58\uac00 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "\ud45c\uc2dc\ub41c \uc591\uc2dd\uc5d0 \ud638\ud658 \uac00\ub2a5\ud55c \uc7a5\uce58 \ud06c\uae30\uac00 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "\ub3c4\uc6c0\ub9d0 \uc591\uc2dd \ud074\ub798\uc2a4 ''{0}''\uc774(\uac00) \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "\uc54c \uc218 \uc5c6\ub294 \uc18d\uc131 ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "\uc62c\ubc14\ub978 \uac12 \uc18d\uc131\uc5d0 \uc9c0\uc815\ub41c \uac12\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uac70\ub098 \uad6c\ubb38 \ubd84\uc11d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "\ub3c4\uc6c0\ub9d0 \uc591\uc2dd ''{0}''\uc744(\ub97c) \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_INTERNAL, "\ub0b4\ubd80 \uc624\ub958: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "\uc0ac\uc6a9 \uac00\ub2a5\ud55c \ud504\ub9b0\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "\uae30\ubcf8 \ud504\ub9b0\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "''{0}'' \ud504\ub9b0\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.\n\ub2e4\uc74c \ud504\ub9b0\ud130\ub97c \uc0ac\uc6a9 \uac00\ub2a5\ud569\ub2c8\ub2e4.\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "''{0}'' \uba54\uc2dc\uc9c0\ub97c \ub85c\ub4dc\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "{0} \ub0b4\uc6a9\uc744 \ud544\ub4dc\ub85c \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "''{0}'' \ud504\ub9b0\ud130\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "{0} \ud504\ub85c\uadf8\ub7a8\uc5d0\ub294 \ud14d\uc2a4\ud2b8 \uc591\uc2dd {1}\uc774(\uac00) \uc608\uc0c1\ub418\uc9c0\ub9cc, \ud45c\uc2dc \uba85\ub839\ubb38\uc5d0 \ud14d\uc2a4\ud2b8 \uc591\uc2dd {2}\uc774(\uac00) \uc81c\uacf5\ub418\uc5c8\uc2b5\ub2c8\ub2e4." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "\ub2e4\uc74c" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "{0}/{1} \ud398\uc774\uc9c0" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "\uc774\uc804" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "\uc778\uc1c4" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "\uc778\uc1c4 \ubbf8\ub9ac\ubcf4\uae30 - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "\uc800\uc7a5" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "\uc778\uc1c4 \uc791\uc5c5 \uc800\uc7a5 - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "\ud30c\uc77c \uc778\uc1c4 \uc624\ub958: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "\ud504\ub9b0\ud130 \uc778\uc1c4 \uc624\ub958: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "EZEMNO \uc124\uc815" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "''{0}'' \ud544\ub4dc \uc720\ud6a8\uc131 \uac80\uc99d" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "\ud14d\uc2a4\ud2b8 \uc591\uc2dd \uc720\ud6a8\uc131 \uac80\uc99d" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "\ud14d\uc2a4\ud2b8 \uc591\uc2dd \uc720\ud6a8\uc131 \uac80\uc99d - \uc720\ud6a8\uc131 \uac80\uc99d\uae30 \ud568\uc218 ''{0}'' \uc2e4\ud589" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "\ub85c\uadf8 \uc4f0\uae30 \ud504\ub85c\uadf8\ub7a8(logwriter)\uc744 \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "\ub85c\uae45 \ub9e4\uac1c\ubcc0\uc218 ''{0}''\uc740(\ub294) \uc2dc\uc791 \ud6c4\uc5d0\ub294 \uc124\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "\ub85c\uadf8 \ub514\ub809\ud1a0\ub9ac(Logdir) ''{0}''\uc774(\uac00) \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "\ub85c\uadf8 \ub514\ub809\ud1a0\ub9ac ''{0}''\uc5d0 \uc4f8 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "\ub85c\uadf8 \ud30c\uc77c ''{0}''\uc744(\ub97c) \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "\ub85c\uadf8 \ud30c\uc77c ''{0}''\uc5d0 \uc4f8 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Component/ExternalService {0}\uc5d0 \ub300\ud55c \uc11c\ube44\uc2a4\ub97c \ub85c\ub4dc\ud558\ub294 \uc911\uc5d0 \ubb38\uc81c\uc810\uc774 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "\uc6f9 \uc11c\ube44\uc2a4 \uc624\ud37c\ub808\uc774\uc158 ''{0}'' \uc5f0\uacb0 \uc791\uc131 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {1}" },
		{ Message.SOA_E_WS_GET_OPERATION, "wsdl \ud30c\uc77c ''{1}''\uc5d0\uc11c ''{0}'' \uc624\ud37c\ub808\uc774\uc158\uc744 \uac00\uc838\uc624\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_MALFORMED_URL, "\uc6f9 \uc11c\ube44\uc2a4 \uc624\ud37c\ub808\uc774\uc158 {1}\uc758 \ub300\uc0c1 URL\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "{0} \uc11c\ube44\uc2a4\ub97c \ub85c\ub4dc\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "\uc6f9 \uc11c\ube44\uc2a4\ub97c \ub85c\ub4dc\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc678\ubd80 \uc11c\ube44\uc2a4 {0}\uc5d0 \ub300\ud574 WSDL \ud3ec\ud2b8\ub97c \ud574\uacb0\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "{0} \ucef4\ud3ec\ub10c\ud2b8\uc5d0\ub294 \uc11c\ube44\uc2a4 \uad6c\ud604\uc5d0 \ud544\uc694\ud55c {1} \ud2b9\uc131\uc774 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "\uc11c\ube44\uc2a4 \ucc38\uc870 ''{0}''\uc774(\uac00) \ub204\ub77d\ub418\uc5c8\uac70\ub098 \ub300\uc0c1 \uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_MISSING_BINDING, "\uc11c\ube44\uc2a4 \ubc14\uc778\ub529: ''{0}''\uc774(\uac00) \ubc30\uce58 \uc124\uba85\uc790 ''{1}''\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "''{0}'' \ub808\ucf54\ub4dc\ub97c SOAP \uba54\uc2dc\uc9c0\ub85c \ubcc0\ud658\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub808\ucf54\ub4dc\uc5d0\uc11c ''{1}'' \ud544\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "''{0}''\uc744(\ub97c) SOAP \uba54\uc2dc\uc9c0\ub85c \ubcc0\ud658\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "\uc6f9 \uc11c\ube44\uc2a4\uc5d0\uc11c \uc778\ubc14\uc6b4\ub4dc \uba54\uc2dc\uc9c0\ub97c \ucc98\ub9ac\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. Java \uc720\ud615\uc740 EGL \uc720\ud615\uacfc \ud638\ud658\ub420 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "\uc6f9 \uc11c\ube44\uc2a4\uc5d0\uc11c \uc544\uc6c3\ubc14\uc6b4\ub4dc \uba54\uc2dc\uc9c0\ub97c \ucc98\ub9ac\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. EGL \uc720\ud615\uc740 Java \uc720\ud615\uacfc \ud638\ud658\ub420 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "''{0}'' \ub808\ucf54\ub4dc\ub97c \ucd08\uae30\ud654\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "''{0}'' \uac12\uc744 Calendar\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "''{0}'' \uac12\uc744 boolean\uc73c\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "''{0}'' \uac12\uc744 Byte\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "''{0}'' \uac12\uc744 short\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "''{0}'' \uac12\uc744 URI\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "EGL \uc720\ud615\uc740 \uc6f9 \uc11c\ube44\uc2a4 \ub9e4\uac1c\ubcc0\uc218\ub85c \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "\ub808\ucf54\ub4dc \ubc30\uc5f4\uc744 \uc791\uc131\ud558\ub294 \ub3d9\uc548 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {0}" },
		{ Message.SOA_E_METHOD_NOT_FOUND, "{0} \uba54\uc18c\ub4dc\uac00 {1} \uc11c\ube44\uc2a4\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "\uc11c\ube44\uc2a4\ub294 \uc6f9 \uc11c\ube44\uc2a4\uac00 \uc544\ub2d9\ub2c8\ub2e4." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "{1} \uc6f9 \uc11c\ube44\uc2a4\uc5d0\uc11c {0} \ud568\uc218\ub97c \ud638\ucd9c\ud560 \ub54c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "{1} EGL \uc11c\ube44\uc2a4\uc5d0\uc11c {0} \ud568\uc218\ub97c \ud638\ucd9c\ud560 \ub54c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "{2}:{3}\uc744(\ub97c) \uc0ac\uc6a9\ud558\ub294 {1} EGL \uc11c\ube44\uc2a4\uc5d0\uc11c {0} \ud568\uc218\ub97c \ud638\ucd9c\ud560 \ub54c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "\uc11c\ube44\uc2a4\uac00 tcpip \uc11c\ube44\uc2a4\uac00 \uc544\ub2d9\ub2c8\ub2e4." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "{1} \uc2dc\uc791\uc810\uc5d0\uc11c {0} \ud568\uc218\ub97c \ud638\ucd9c\ud560 \ub54c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "\uc11c\ube44\uc2a4 \ubc14\uc778\ub529 \ud30c\uc77c {0} \ub85c\ub4dc \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "CICS \uc11c\ube44\uc2a4 {1}\uc5d0\uc11c {0} \ud568\uc218\ub97c \ud638\ucd9c\ud560 \ub54c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958 \ucf54\ub4dc: {2}, \uba54\uc2dc\uc9c0: {3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "iSeries \uc11c\ube44\uc2a4 {1}\uc5d0\uc11c {0} \ud568\uc218 \ud638\ucd9c \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc624\ub958 \ucf54\ub4dc: {2}, \uba54\uc2dc\uc9c0: {3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "\uc11c\ube44\uc2a4\uac00 CICS \uc11c\ube44\uc2a4\uac00 \uc544\ub2d9\ub2c8\ub2e4." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "\uc6d0\uaca9 \uc11c\ube44\uc2a4 {0}, \ub0a0\uc9dc {1}, \uc2dc\uac04 {2}, \uc2dc\uc2a4\ud15c {3}\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "\uc2dc\uc2a4\ud15c {1}\uc758 \uc6d0\uaca9 \uc11c\ube44\uc2a4 {0}\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "{1} \uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 {0} \uc2dc\uc2a4\ud15c\uc5d0 \ubc1c\uc0dd\ud55c \uc751\uc6a9\ud504\ub85c\uadf8\ub7a8 \uc624\ub958\ub85c \uc778\ud574 \uc2e4\ud589 \uc7a5\uce58\uac00 \uc885\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uba54\uc2dc\uc9c0: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "{3} \uc2dc\uc2a4\ud15c\uc5d0\uc11c {2} \uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \ub3d9\uc548 AS400Toolbox \uc2e4\ud589 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {0}, {1}" },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "\uc9c0\uc6d0\ub418\uc9c0 \uc54a\ub294 \uc11c\ube44\uc2a4 \ud074\ub77c\uc774\uc5b8\ud2b8 \ubc14\uc778\ub529\uc785\ub2c8\ub2e4. {0}\uc774(\uac00) Websphere\uc5d0 \ub300\ud574 \uc0dd\uc131\ub418\uc5c8\uc9c0\ub9cc \ube44J2EE \ud658\uacbd\uc5d0\uc11c \ud638\ucd9c \uc911\uc785\ub2c8\ub2e4. \ube44J2EE \ud504\ub85c\uc81d\ud2b8\uc5d0 \ub2e4\uc2dc \uc0dd\uc131\ud558\uc2ed\uc2dc\uc624." },
		{ Message.SOA_E_USER_ID_NOT_SET, "\uc6f9 \uc11c\ube44\uc2a4: {0} \ud568\uc218: {1}\uc744(\ub97c) \ud638\ucd9c\ud558\ub824\uba74 \uc6d0\uaca9 \uc0ac\uc6a9\uc790 ID \ubc0f \uc554\ud638\ub97c \uc124\uc815\ud574\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "\uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "\uc11c\ube44\uc2a4\uc640 \ud1b5\uc2e0\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "REST \uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ubc14\uc778\ub529: {0}, \uc624\ud37c\ub808\uc774\uc158: {0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "SOAP \uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ubc14\uc778\ub529: {0}, \uc11c\ube44\uc2a4: {1}, \ud3ec\ud2b8: {2}, WSDL \uc704\uce58: {3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "JSON\uc5d0\uc11c \uc804\ud658\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9e4\uac1c\ubcc0\uc218: {0}, json: {1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "JSON\uc73c\ub85c \uc804\ud658\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9e4\uac1c\ubcc0\uc218: {0}, \uac12: {1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "REST-RPC \uc11c\ube44\uc2a4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "\uc11c\ube44\uc2a4\uc5d0\uc11c \uc751\ub2f5\uc744 \uc218\uc2e0\ud558\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4. URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "\uc694\uccad\uc744 \uc11c\ube44\uc2a4 \ud638\ucd9c\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc218\uc2e0\ub41c \uc694\uccad\uc740 ''{0}''\uc785\ub2c8\ub2e4. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "\uc11c\ube44\uc2a4 \ud638\ucd9c \uc2dc\uac04\uc774 \uc81c\ud55c\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc608\uc678: \uc5f0\uacb0 \uc77d\uae30 \uc81c\ud55c\uc2dc\uac04 \uc624\ub958. URL: {0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "\uc11c\ube44\uc2a4\ub294 REST \uc11c\ube44\uc2a4\uac00 \uc544\ub2d9\ub2c8\ub2e4. " },
		{ Message.SOA_E_REST_SERVICE, "REST \uc11c\ube44\uc2a4 \ud638\ucd9c\uc5d0 \ub300\ud55c \ud638\ucd9c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \ubc14\uc778\ub529: {0}, \uc624\ud37c\ub808\uc774\uc158: {1}, HTTP \uba54\uc18c\ub4dc: {2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "\ub370\uc774\ud130\ub97c EGL \ub9e4\uac1c\ubcc0\uc218\ub85c \ubcc0\ud658\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ubc14\uc778\ub529: {0}, \ubcc0\ud658\ud560 \ub370\uc774\ud130 {1}, \uc608\uc678: {2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "REST \uc11c\ube44\uc2a4 \ud638\ucd9c\uc774 \ube44REST \uc11c\ube44\uc2a4 \ucc38\uc870\ub85c \uc791\uc131\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc11c\ube44\uc2a4 \ucc38\uc870: {0}, \uc624\ud37c\ub808\uc774\uc158 {1}, HTTP \uba54\uc18c\ub4dc: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "XML\uc5d0\uc11c \ubcc0\ud658\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ud544\uc218 \uc694\uc18c {0}\uc774(\uac00) \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. " },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "XML\uc5d0\uc11c \ubcc0\ud658\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9e4\uac1c\ubcc0\uc218: {0}, xml: {1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "XML\uc73c\ub85c \ubcc0\ud658\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub9e4\uac1c\ubcc0\uc218: {0}, \uac12: {1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "{0}\uc744(\ub97c) XML\uc5d0\uc11c \ubcc0\ud658\ud558\ub294 \uc911\uc5d0 XML \uad6c\ubb38 \ubd84\uc11d \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. " },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "{0}\uc744(\ub97c) XML\ub85c \ubcc0\ud658\ud558\ub294 \uc911\uc5d0 XML \ubcc0\ud658 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. " },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "\uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \ub370 \uc0ac\uc6a9\ud55c URL ''{0}''\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. http:// protocol\uc774 \ube60\uc838\uc788\uc2b5\ub2c8\ub2e4. " },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "\uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \ub370 \uc0ac\uc6a9\ud55c URL ''{0}''\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "\uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \ub370 \uc0ac\uc6a9\ud55c URL\uc774 \uacf5\ubc31\uc785\ub2c8\ub2e4. \uc11c\ube44\uc2a4\ub97c \uc9c0\uc815\ud558\ub294 URL\uc744 \uc791\uc131\ud558\uc2ed\uc2dc\uc624. " },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "{0} \uc5f0\uacb0\uc744 \uc0ac\uc6a9\ud558\uc5ec \ubcf4\uace0\uc11c\ub97c \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "{0} SQL \ubb38\uc744 \uc0ac\uc6a9\ud558\uc5ec \ubcf4\uace0\uc11c\ub97c \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "{0} \ub3d9\uc801 \ubc30\uc5f4\uc744 \uc0ac\uc6a9\ud558\uc5ec \ubcf4\uace0\uc11c\ub97c \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.REPORT_E_FILL_ERROR , "{0} \ubcf4\uace0\uc11c\ub97c \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.REPORT_E_EXPORT_ERROR, "{0} \ubcf4\uace0\uc11c\ub97c \ub0b4\ubcf4\ub0bc \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "EGL {0}\uacfc(\uc640) Java {1} \uc720\ud615 \uac04 \ubcc0\ud658\uc774 \ubd88\uac00\ub2a5\ud569\ub2c8\ub2e4." },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "Java {0}\uacfc(\uc640) EGL {1} \uc720\ud615 \uac04 \ubcc0\ud658\uc774 \ubd88\uac00\ub2a5\ud569\ub2c8\ub2e4." },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "\ubcf4\uace0\uc11c \ub9e4\uac1c\ubcc0\uc218\ub97c \ucd94\uac00\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "\ubcf4\uace0\uc11c \ub9e4\uac1c\ubcc0\uc218 \ubaa9\ub85d\uc744 \uc7ac\uc124\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "\ud544\ub4dc \uc774\ub984 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "\ud558\uc704 \ubcf4\uace0\uc11c \uc774\ub984 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "\ubcf4\uace0\uc11c\uc5d0 \uc0ac\uc6a9 \uc911\uc778 \uc720\ud615\uc740 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "\uc774 \ud568\uc218\uc5d0 \ubcf5\ud569 \uc720\ud615\uc744 \uc804\ub2ec\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "getParameterDefaultValue() \ud568\uc218\ub97c \ud638\ucd9c\ud558\ub824\uba74 \ub514\uc790\uc778 \ud30c\uc77c\uc744 \uc124\uc815\ud574\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "{0} \ub9e4\uac1c\ubcc0\uc218\uc758 \uae30\ubcf8\uac12\uc744 \uac00\uc838\uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "\uc774\ub984\uc774 {0}\uc778 \ubcf4\uace0\uc11c \ub9e4\uac1c\ubcc0\uc218\uac00 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "createReportFromDesign() \ub610\ub294 createDocument() \ud568\uc218\ub97c \ud638\ucd9c\ud558\ub824\uba74 \ub514\uc790\uc778 \ud30c\uc77c\uc744 \uc124\uc815\ud574\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "createReportFromDocument() \ud568\uc218\ub97c \ud638\ucd9c\ud558\ub824\uba74 \ubb38\uc11c \ud30c\uc77c \uc774\ub984\uc744 \uc124\uc815\ud574\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "\ubcf4\uace0\uc11c \ubb38\uc11c \ud30c\uc77c\uc744 \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "\ub514\uc790\uc778 \ud30c\uc77c\uc5d0\uc11c \ubcf4\uace0\uc11c\ub97c \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "\ubb38\uc11c \ud30c\uc77c\uc5d0\uc11c \ubcf4\uace0\uc11c\ub97c \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "BirtReport\uc5d0 \uc9c0\uc815\ub41c \ud578\ub4e4\ub7ec \uc624\ube0c\uc81d\ud2b8\uac00 BirtHandler \uc720\ud615\uc774\uc5b4\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "\ubcf4\uace0\uc11c \ub514\uc790\uc778\uc5d0 {0} \uc694\uc18c\uac00 \uc5c6\uac70\ub098 \uc9c0\uc815\ub41c \uc720\ud615\uc774 \uc544\ub2d9\ub2c8\ub2e4." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "{0} \ud589 \ubc88\ud638 {1}\uc774(\uac00) {2} \ud14c\uc774\ube14\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "\ud589 \ubc88\ud638 {0}\uc774(\uac00) \ub208\uae08 \uc694\uc18c {1}\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "{0} \uadf8\ub8f9\uc774 {1} \ud14c\uc774\ube14\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "{0} \ud589 \ubc88\ud638 {1}\uc774(\uac00) {3} \ud14c\uc774\ube14\uc758 {2} \uadf8\ub8f9\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "\uc5f4 \ubc88\ud638 {0}\uc774(\uac00) {2} \ud45c\uc758 {1} \ud589\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "\uc5f4 \ubc88\ud638 {0}\uc774(\uac00) {1} \ub208\uae08\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "\uc5f4 \ubc88\ud638 {0}\uc774(\uac00) {3} \ud14c\uc774\ube14 {2} \uadf8\ub8f9\uc758 {1} \uc5f4\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "{0} \ud14c\uc774\ube14\uc758 \ud589 \ub610\ub294 \uc140\uc5d0 \uc774\ubca4\ud2b8 \ud578\ub4e4\ub7ec \ud568\uc218\uc5d0 \ub300\ud574 ''RowType'' \ud2b9\uc131\uc744 \uc9c0\uc815\ud574\uc57c \ud569\ub2c8\ub2e4." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "Java \uc720\ud615 {0}\uc744(\ub97c) EGL \uc720\ud615\uc73c\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "EGL \uc720\ud615 {0}\uc744(\ub97c) Java \uc720\ud615\uc73c\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "\ubcf4\uace0\uc11c \ub514\uc790\uc778\uc5d0 \ub370\uc774\ud130 \uc138\ud2b8 {0}\uc774(\uac00) \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "\ub370\uc774\ud130 \uc138\ud2b8 {0}\uc774(\uac00) \uc2a4\ud06c\ub9bd\ud2b8\ub41c \ub370\uc774\ud130 \uc138\ud2b8\uc774\uc9c0\ub9cc \ub2e4\uc74c \uc774\ubca4\ud2b8 \uc720\ud615\uc774 \ucc98\ub9ac\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "\ubcf4\uace0\uc11c \ub514\uc790\uc778\uc5d0 \ub370\uc774\ud130 \uc18c\uc2a4 {0}\uc774(\uac00) \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "\ub370\uc774\ud130 \uc18c\uc2a4 {0}\uc774(\uac00) \uc2a4\ud06c\ub9bd\ud2b8\ub41c \ub370\uc774\ud130 \uc18c\uc2a4\uc774\uc9c0\ub9cc \ub2e4\uc74c \uc774\ubca4\ud2b8 \uc720\ud615\uc774 \ucc98\ub9ac\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "\uc5f4 \ubc88\ud638 {0}\uc774(\uac00) \ub370\uc774\ud130 \uc138\ud2b8 {1}\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "\ub370\uc774\ud130 \uc138\ud2b8 {1}\uc5d0\uc11c {0} \uc5f4\uc744 \uac00\uc838\uc624\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "\uc2a4\ud06c\ub9bd\ud2b8\ub41c \ub370\uc774\ud130 \uc138\ud2b8 {1}\uc758 {0} \uc5f4\uc744 \uc124\uc815\ud558\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "\uc5f4 \ubc14\uc778\ub529 {0}\uc744(\ub97c) \uac00\uc838\uc624\ub294 \uc911\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "\ud2b9\uc131 vgj.defaultI4GLNativeLibrary\ub97c \uc9c0\uc815\ud558\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4." },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "{0} \ub77c\uc774\ube0c\ub7ec\ub9ac \ub85c\ub4dc\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4({1})." },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "\ub9ac\ud134\ub41c \ub9e4\uac1c\ubcc0\uc218\uac00 \ud568\uc218\uc640 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "\uba54\ubaa8\ub9ac\ub97c \ud560\ub2f9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "\uc720\ud615 \uac04 \ubcc0\ud658\uc774 \ubd88\uac00\ub2a5\ud569\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "Datetime \ub610\ub294 Interval \uc815\ubc00\ub3c4\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "\ubb38\uc790 \ud638\uc2a4\ud2b8 \ubcc0\uc218\uac00 \ub370\uc774\ud130\uc5d0 \ube44\ud574 \ub108\ubb34 \uc9e7\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "\uae30\ud638 \ud14c\uc774\ube14\uc5d0\uc11c \ud568\uc218\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "\uc774 \ucee8\ud14d\uc2a4\ud2b8\uc5d0\ub294 TEXT \ub610\ub294 BYTE \ub370\uc774\ud130 \uc720\ud615\uc744 \uc785\ub825\ud574\uc57c \ud569\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "\uc2a4\ud0dd\uc758 \uac12\uc744 \uac12 \uc720\ud615\uc73c\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "\uc2a4\ud0dd\uc758 \uac12\uc744 ANY\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_POP_ERROR, "{0} \uc720\ud615\uc758 \uac12\uc744 \uc2a4\ud0dd\uc5d0\uc11c \ube7c\ub0bc \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_PUSH_ERROR, "{1} \uc720\ud615\uc758 \uac12\uc744 \uc2a4\ud0dd\uc5d0 \ubc00\uc5b4\ub123\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "\ubc00\uc5b4\ub123\uac70\ub098/\ube7c\ub0bc \ub0b4\uc6a9\uc774 \uc5c6\uc74c"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "Locator \uac12\uc744 \uc2a4\ud0dd\uc73c\ub85c \ube7c\ub0bc \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "\uc2a4\ud0dd\uc774 \ube44\uc5b4 \uc788\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "\uc704\uce58 \uc9c0\uc815\uc790\ub97c \ubcf5\uc0ac\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "\ub110(null) \ucc38\uc870\ub97c \uc2a4\ud0dd\uc5d0 \ub123\uc5c8\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "Any \uac12\uc744 \uc2a4\ud0dd\uc73c\ub85c \ubc00\uc5b4\ub123\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "\uc2a4\ud0dd \uc694\uc18c\ub97c Any \uc720\ud615\uc73c\ub85c \uc9c0\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "\ub9ac\ud134 \uc720\ud615\uc774 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4."},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "\ub9e4\uac1c\ubcc0\uc218 \uc720\ud615\uc774 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4."},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "EGL \uc18c\uc2a4 \ud30c\uc77c {0}\uc744(\ub97c) \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc0dd\uc131\ub41c \ucf54\ub4dc\uac00 \ub300\uc2e0 \uc2e4\ud589\ub429\ub2c8\ub2e4." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "\uc774\ub984\uc774 {0}\uc778 \uc6f9 \ud2b8\ub79c\uc7ad\uc158\uc5d0 \ub300\ud574 EGL \uc18c\uc2a4 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "\"{1}\" \uc591\uc2dd\uc744 \ud45c\uc2dc\ud558\ub294 \uc911\uc5d0 \"{0}\" \ud544\ub4dc\uc5d0\uc11c \ub2e4\uc74c\uc758 \ud615\uc2dd\ud654 \ubb38\uc81c\uc810\uc774 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. " },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\n\ud544\ub4dc\uc758 \uc608\uc0c1 \ub0b4\ubd80 \ud615\uc2dd\uc740 \"{1}\"\uc785\ub2c8\ub2e4. \ub514\ubc84\uadf8 \ube4c\ub4dc \uc124\uba85\uc790 \ub610\ub294 \ub0a0\uc9dc \ud615\uc2dd\uc5d0 \uc601\ud5a5\uc744 \uc8fc\ub294 \uc0ac\uc6a9\uc790 JDBC \ud2b9\uc131 \ub0b4\uc5d0 \uc788\ub294 EGL Java \ub7f0\ud0c0\uc784 \ud2b9\uc131\uc758 \ub0a0\uc9dc \ud615\uc2dd \ud2b9\uc131\uc744 \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\n\ud544\ub4dc\uc758 \ud45c\uc2dc \ud615\uc2dd\uc740 \"{1}\"\uc785\ub2c8\ub2e4. \ud615\uc2dd \ud544\ub4dc\uc5d0\uc11c \"{2}\" \ud2b9\uc131\uc744 \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "{0} \ud504\ub85c\uadf8\ub7a8\uc744 \uc6f9 \ud2b8\ub79c\uc7ad\uc158\uc73c\ub85c \uc2e4\ud589\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "\uc774 \uc6f9 \ud2b8\ub79c\uc7ad\uc158\uc740 \uc785\ub825 UI \ub808\ucf54\ub4dc {1}(\uc73c)\ub85c \uc815\uc758\ub418\uc5c8\ub294\ub370 \uc785\ub825 UI \ub808\ucf54\ub4dc {0}\uc774(\uac00) \uc81c\uacf5\ub418\uc5c8\uc2b5\ub2c8\ub2e4." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "\ubd80\uc6b8 \ud544\ub4dc\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \uc785\ub825\uc785\ub2c8\ub2e4." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "{0} \ud504\ub85c\uadf8\ub7a8\uc5d0\uc11c \ud65c\ub3d9\uc774 \uc5c6\uc5b4\uc11c \uc81c\ud55c\uc2dc\uac04 \ucd08\uacfc\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "\uc0ac\uc6a9\uc790 \uc778\ud130\ud398\uc774\uc2a4 \ub808\ucf54\ub4dc {0}\uc5d0 \uac8c\uc774\ud2b8\uc6e8\uc774 Servlet\uc73c\ub85c \ubcf4\ub0bc \ub370\uc774\ud130\uac00 \ub108\ubb34 \ub9ce\uc2b5\ub2c8\ub2e4." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "\ud504\ub85c\uadf8\ub7a8\uc5d0\uc11c \uac8c\uc774\ud2b8\uc6e8\uc774 Servlet\uc758 \ub370\uc774\ud130\ub97c \ud655\uc778\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ub370\uc774\ud130 ID\ub294 {0}\uc785\ub2c8\ub2e4." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "\ubc30\uc5f4 \ub7a9\ud37c {0}\uc744(\ub97c) \ucd5c\ub300 \ud06c\uae30 \uc774\uc0c1\uc73c\ub85c \ud655\uc7a5\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. {1} \uba54\uc18c\ub4dc\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0}\uc740(\ub294) \ubc30\uc5f4 \ub7a9\ud37c {1}\uc5d0 \ub300\ud574 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \uc0c9\uc778\uc785\ub2c8\ub2e4. \ucd5c\ub300 \ud06c\uae30: {2}. \ud604\uc7ac \ud06c\uae30: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0}\uc740(\ub294) \ubc30\uc5f4 \ub7a9\ud37c {1}\uc5d0 \ub300\ud574 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \ucd5c\ub300 \ud06c\uae30\uc785\ub2c8\ub2e4." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0}\uc740(\ub294) {1} \uc720\ud615\uc758 \ubc30\uc5f4 \ub7a9\ud37c\uc5d0 \ucd94\uac00\ud558\uae30\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \uc624\ube0c\uc81d\ud2b8 \uc720\ud615\uc785\ub2c8\ub2e4." },
		
		{ Message.IMS_HOST_ABORT, "\uc6d0\uaca9 \ud638\uc2a4\ud2b8\uc5d0\uc11c \ud328\ud0b7 \uc911\ub2e8\uc744 \uc218\uc2e0\ud588\uc2b5\ub2c8\ub2e4. "},
		{ Message.IMS_HOST_TCPIP_ERROR, "\uc6d0\uaca9 \ud638\uc2a4\ud2b8\uc5d0\uc11c TCPIP \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc139\uc158: {0}, TCPIP-\uc624\ud37c\ub808\uc774\uc158: {1}, TCPIP-RETCODE: {2}, TCPIP-ERRNO: {3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "\ud638\ucd9c\ud558\ub294 \uc911\uc5d0 \ud638\uc2a4\ud2b8\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "\ud638\uc2a4\ud2b8\uc5d0\uc11c \uc798\ubabb\ub41c \uc751\ub2f5 \ud328\ud0b7\uc744 \uc218\uc2e0\ud588\uc2b5\ub2c8\ub2e4. \uc608\uc0c1: {0}, \uc218\uc2e0: {1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "\uc2a4\ud1a0\uc5b4\ub4dc \ud504\ub85c\uc2dc\uc800\ub97c \uc2e4\ud589\ud558\ub294 \uc911\uc5d0 I/O \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "\uc2a4\ud1a0\uc5b4\ub4dc \ud504\ub85c\uc2dc\uc800\ub97c \uc2e4\ud589\ud558\ub294 \uc911\uc5d0 SQL \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "\uc6d0\uaca9 \ud638\uc2a4\ud2b8 \uc2e4\ud589 \uc911 \uc624\ub958 \ubc1c\uc0dd: {0} RETCODE: {1} DLI \ud504\ub85d\uc2dc \uc791\uc5c5 ID: {2}"},
		{ Message.IMS_HOST_DLI_ERROR, "\uc6d0\uaca9 \ud638\uc2a4\ud2b8\uc5d0\uc11c DLI \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. DLI \uae30\ub2a5: {0} AIB-\ub9ac\ud134: 0x{1} AIB-\uc774\uc720: 0x{2} \uc0c1\ud0dc \ucf54\ub4dc: {3} DLI \ud504\ub85d\uc2dc \uc791\uc5c5 ID: {4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "\uc6d0\uaca9 \ud638\uc2a4\ud2b8\uc5d0\uc11c DLI \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. DLI \uae30\ub2a5: {0} AIB-\ub9ac\ud134: 0x{1} AIB-\uc774\uc720: 0x{2} DLIVar.statusCode: {3} DLIVar.DbName: {4} DLIVar.SegmentName: {5} DLIVar.SegmentLevel: {6} DLI \ud504\ub85d\uc2dc \uc791\uc5c5 ID: {7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "AIB-\ub9ac\ud134 \ucf54\ub4dc\uac00 PCB-\uc0c1\ud0dc \ucf54\ub4dc\ub97c \ud45c\uc2dc\ud558\uc9c0\ub9cc, PCB\uac00 \ub9ac\ud134\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4. AIB-\uae30\ub2a5: {0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "\uc6d0\uaca9 \ud638\uc2a4\ud2b8\uc758 CALL EZEDBTCP\uc5d0\uc11c \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc139\uc158: {0}, TCPIP-\uc624\ud37c\ub808\uc774\uc158: {1}, TCPIP-RETCODE: {2}, TCPIP-ERRNO: {3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "\uc6d0\uaca9 \ud638\uc2a4\ud2b8\uc5d0\uc11c \uc774\uc0c1 \uc885\ub8cc\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub8e8\ud2f4: {0}, \uba54\uc2dc\uc9c0: {1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "\uc6d0\uaca9 \ud638\uc2a4\ud2b8\uc5d0\uc11c \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ud638\ucd9c: {0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "\ub514\ubc84\uac70\uac00 DLI \uae30\ub2a5\uc744 \uc9c0\uc6d0\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uae30\ub2a5: {0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "DL/I \ud638\ucd9c\uc774 \uc2e4\ud589\ub418\uc5c8\uc9c0\ub9cc DL/I \uc561\uc138\uc2a4\ub97c \uc704\ud55c \ube4c\ub4dc \uc124\uba85\uc790\uac00 \uad6c\uc131\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "\uc6d0\uaca9 \uc608\uc678: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "PSB \ud560\ub2f9 \uc2dc\ub3c4 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. IMSID\ub294 DL/I \uc561\uc138\uc2a4\uac00 \uc788\ub294 \uac83\uc744 \ud45c\uc2dc\ud558\ub3c4\ub85d \uc124\uc815\ub418\uc5c8\uc9c0\ub9cc \uc9c0\uc815\ub41c PSB\uac00 \uc5c6\uc2b5\ub2c8\ub2e4."},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "RBD \ud074\ub77c\uc774\uc5b8\ud2b8 \ubc0f \ud638\uc2a4\ud2b8 \ubc84\uc804\uc774 \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. RBD \ud074\ub77c\uc774\uc5b8\ud2b8 \ubc84\uc804: {0} \ud638\uc2a4\ud2b8 \ubc84\uc804: {1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "\ud638\ucd9c\uc5d0\uc11c \ud638\uc2a4\ud2b8 \ud504\ub85c\uadf8\ub7a8\uc73c\ub85c \ub9ac\ud134\ub41c \ub370\uc774\ud130\ub97c \uac80\uc0c9\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "PCB \uc774\ub984\uc744 \uac80\uc0c9\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. PCB \uc0c9\uc778: {0}, PCB \uc218: {1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
