/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_pl extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "{0}: B\u0142\u0105d." },
		{ Message.FUNCTION_ERROR_INFO, "{0}: B\u0142\u0105d podczas przetwarzania funkcji {1}." },
		{ Message.FILE_ERROR_INFO, "{0}: B\u0142\u0105d podczas przetwarzania funkcji {1} w wierszu {2}." },
		{ Message.PROPERTIES_FILE_MISSING, "Nie mo\u017cna za\u0142adowa\u0107 pliku w\u0142a\u015bciwo\u015bci {0}." },
		{ Message.LOAD_LIBRARY_FAILED, "Nie mo\u017cna za\u0142adowa\u0107 biblioteki {0}. Wyst\u0105pi\u0142 nast\u0119puj\u0105cy b\u0142\u0105d: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas tworzenia obiektu typu {0}. Wyst\u0105pi\u0142 nast\u0119puj\u0105cy b\u0142\u0105d: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas tworzenia obiektu InitialContext lub wyszukiwania \u015brodowiska java:comp/env. Wyst\u0105pi\u0142 nast\u0119puj\u0105cy b\u0142\u0105d: {0}" },
		{ Message.LISTENER_ERROR, "Wyst\u0105pi\u0142 nast\u0119puj\u0105cy wyj\u0105tek z komunikatem. Wyj\u0105tek: {0}. Komunikat: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "Wymagana jest warto\u015b\u0107 dla w\u0142a\u015bciwo\u015bci {0}." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "Brak zale\u017cno\u015bci zewn\u0119trznej. Wyst\u0105pi\u0142 nast\u0119puj\u0105cy wyj\u0105tek. Wyj\u0105tek: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "Nie mo\u017cna por\u00f3wna\u0107 operand\u00f3w {0} i {1}." },
		{ Message.ASSIGNMENT_OVERFLOW, "Wyst\u0105pi\u0142 b\u0142\u0105d przepe\u0142nienia podczas przypisywania warto\u015bci {0} do {1}." },
		{ Message.EXPRESSION_OVERFLOW, "Wyst\u0105pi\u0142 b\u0142\u0105d przepe\u0142nienia podczas obliczania nast\u0119puj\u0105cego wyra\u017cenia: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "Operator {0} nie jest obs\u0142ugiwany dla operand\u00f3w {1} i {2}." },
		{ Message.UNSUPPORTED_OPERAND, "Operator {0} nie jest obs\u0142ugiwany dla operandu {1} typu {2}." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "Operator indeksu dolnego nie jest obs\u0142ugiwany dla operandu {0} typu {1}." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "Operator pod\u0142a\u0144cucha nie jest obs\u0142ugiwany dla operandu {0} typu {1}." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "Instrukcja SET EMPTY nie jest obs\u0142ugiwana dla operandu {0} typu {1}." },
		{ Message.INVALID_REGULAR_EXPRESSION, "Wyst\u0105pi\u0142 b\u0142\u0105d w wyra\u017ceniu regularnym {0}. B\u0142\u0105d: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "Podczas korzystania z protoko\u0142u CICSSSL nale\u017cy poda\u0107 zar\u00f3wno warto\u015b\u0107 ctgKeyStore, jak i warto\u015b\u0107 ctgKeyStorePassword." },
		{ Message.INVALID_CTGPORT, "Warto\u015b\u0107 {0} dla wpisu ctgport nie jest poprawna." },
		{ Message.CTG_CONNECT_FAILED, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia z bram\u0105 CTG. Po\u0142o\u017cenie CTG to {0}. Port CTG to {1}. Wyst\u0105pi\u0142 nast\u0119puj\u0105cy b\u0142\u0105d: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas roz\u0142\u0105czania z bram\u0105 CTG. Po\u0142o\u017cenie CTG to {0}. Port CTG to {1}. Wyst\u0105pi\u0142 nast\u0119puj\u0105cy b\u0142\u0105d: {2}" },
		{ Message.NO_CICS, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania programu {0}, kt\u00f3ry korzysta z interfejsu CICS ECI. Kod powrotu to -3 (ECI_ERR_NO_CICS). Identyfikator systemowy CICS to {1}." },
		{ Message.CICS_DIED, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania programu {0}, kt\u00f3ry korzysta z interfejsu CICS ECI. Kod powrotu to -4 (ECI_ERR_CICS_DIED). Identyfikator systemowy CICS to {1}." },
		{ Message.CICS_TIMEOUT, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania programu {0}, kt\u00f3ry korzysta z interfejsu CICS ECI. Kod powrotu to -6 (ECI_ERR_RESPONSE_TIMEOUT). Identyfikator systemowy CICS to {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania programu {0}, kt\u00f3ry korzysta z interfejsu CICS ECI. Kod powrotu to -7 (ECI_ERR_TRANSACTION_ABEND). Identyfikator systemowy CICS to {1}. Kod nieprawid\u0142owego zako\u0144czenia to {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania programu {0}, kt\u00f3ry korzysta z interfejsu CICS ECI. Kod powrotu to -22 (ECI_ERR_UNKNOWN_SERVER). Identyfikator systemowy CICS to {1}." },
		{ Message.CICS_SECURITY_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania programu {0}, kt\u00f3ry korzysta z interfejsu CICS ECI. Kod powrotu to -27 (ECI_ERR_SECURITY_ERROR). Identyfikator systemowy CICS to {1}." },
		{ Message.CICS_MAX_SYSTEMS, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania programu {0}, kt\u00f3ry korzysta z interfejsu CICS ECI. Kod powrotu to -28 (ECI_ERR_MAX_SYSTEMS). Identyfikator systemowy CICS to {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania programu {0} w systemie {1} dla u\u017cytkownika o nazwie {2}. Z wywo\u0142ania interfejsu CICS ECI zwr\u00f3cony zosta\u0142 kod powrotu {3} i kod nieprawid\u0142owego zako\u0144czenia {4}." },
		{ Message.CICS_COMMIT_FAILED, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania interfejsu CICS ECI w celu zatwierdzenia jednostki pracy. Kod powrotu CICS: {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania interfejsu CICS ECI w celu wycofania jednostki pracy. Kod powrotu CICS: {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "Wyst\u0105pi\u0142 wyj\u0105tek zwi\u0105zany z przep\u0142ywem \u017c\u0105dania ECI wys\u0142anego do systemu CICS {0}. Wyj\u0105tek: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "B\u0142\u0105d d\u0142ugo\u015bci parametru. Strumie\u0144 ma parametry w liczbie {0}, a funkcja lokalna ma parametry w liczbie {1}." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "Przekroczono maksymaln\u0105 wielko\u015b\u0107 tablicy {0}." },
		{ Message.WRONG_NUMBER_OF_PARMS, "Wywo\u0142ywany program {0} oczekiwa\u0142 parametr\u00f3w w liczbie {1}, ale przekazano {2}." },
		{ Message.FUNCTION_NOT_FOUND, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas uzyskiwania adresu punktu wej\u015bcia {0} w bibliotece wsp\u00f3\u0142u\u017cytkowanej {1}. Kod powrotu: {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142adowania biblioteki wsp\u00f3\u0142u\u017cytkowanej {0}. Kod powrotu: {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "Wywo\u0142any program zako\u0144czony niepowodzeniem z kodem powrotu {0}." },
		{ Message.REMOTE_PROGRAM_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d w programie zdalnym {0} w systemie {3}. B\u0142\u0105d wyst\u0105pi\u0142 w {1} na {2}. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "Wyst\u0105pi\u0142 b\u0142\u0105d w programie zdalnym {0} w systemie {1}. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "Nazwa hosta {0} jest nieznan\u0105 nazw\u0105 hosta TCP/IP." },
		{ Message.SERVERID_IS_INVALID_PORT, "Identyfikator serwera {0} nie jest poprawnym numerem portu." },
		{ Message.TCPIP_SERVER_ERROR, "Klient odebra\u0142 powiadomienie o braku mo\u017cliwo\u015bci uruchomienia na serwerze zdalnego programu wywo\u0142anego. Kod przyczyny: {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "Brak warto\u015bci remoteComType lub jest ona niepoprawna." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "Nie mo\u017cna otworzy\u0107 pliku w\u0142a\u015bciwo\u015bci \u0142\u0105czenia {0}." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "W pliku w\u0142a\u015bciwo\u015bci \u0142\u0105czenia {1} nie mo\u017cna znale\u017a\u0107 wpisu dla wywo\u0142ywanego programu {0}." },
		{ Message.AS400_UNKNOWN_HOST, "Nie mo\u017cna znale\u017a\u0107 hosta {0} lub jest on nieznany." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "Has\u0142o lub identyfikator u\u017cytkownika s\u0105 niepoprawne do \u0142\u0105czenia si\u0119 z systemem {0}. B\u0142\u0105d: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "Wyst\u0105pi\u0142 b\u0142\u0105d wykonania AS400Toolbox {0} podczas wywo\u0142ywania programu {2} w systemie {3}. B\u0142\u0105d: {1}" },
		{ Message.AS400_NO_AUTHORITY, "Wyst\u0105pi\u0142 b\u0142\u0105d bezpiecze\u0144stwa zdalnego dost\u0119pu do systemu {0} dla u\u017cytkownika {1}. B\u0142\u0105d: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "Dzia\u0142anie funkcji zatwierdzania nie powiod\u0142o si\u0119 w systemie {0}. B\u0142\u0105d: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "Dzia\u0142anie funkcji wycofywania nie powiod\u0142o si\u0119 w systemie {0}. B\u0142\u0105d: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d zdalnego po\u0142\u0105czenia podczas uzyskiwania dost\u0119pu do systemu {0}. B\u0142\u0105d: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "Wyst\u0105pi\u0142 b\u0142\u0105d EGL us\u0142ug hosta OS/400. W systemie {0} nie znaleziono wymaganych plik\u00f3w." },
		{ Message.AS400_APPLICATION_ERROR, "Jednostka uruchamiania zosta\u0142a zatrzymana z powodu b\u0142\u0119du aplikacji w systemie {0}, kt\u00f3ry wyst\u0105pi\u0142 podczas pr\u00f3by wywo\u0142ania programu {1}. Komunikat: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "Zmienna odniesienia o nazwie {0} ma warto\u015b\u0107 NULL." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "Wyst\u0105pi\u0142 nieobs\u0142ugiwany b\u0142\u0105d. B\u0142\u0105d: {0}." },
		{ Message.DATA_FORMAT_ERROR, "Warto\u015b\u0107 zmiennej {0} nie ma poprawnego formatu." },
		{ Message.CONVERSION_ERROR, "Warto\u015bci {0} typu {1} nie mo\u017cna przekszta\u0142ci\u0107 w typ {2}." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "Wzorzec formatu daty {0} jest niepoprawny." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "Wzorzec formatu godziny {0} jest niepoprawny." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "Wzorzec formatu datownika {0} jest niepoprawny." },
		{ Message.NULL_REFERENCE, "Zosta\u0142o u\u017cyte odniesienie o warto\u015bci NULL." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "Dost\u0119p dynamiczny nie jest obs\u0142ugiwany dla {0}." },
		{ Message.DYNAMIC_ACCESS_FAILED, "W {1} nie mo\u017cna znale\u017a\u0107 pola o identyfikatorze {0}." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "Wzorzec formatu liczbowego {0} jest niepoprawny." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas przypisywania warto\u015bci {0} do {1}. B\u0142\u0105d: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "B\u0142\u0105d w instrukcji SET {0} EMPTY. B\u0142\u0105d: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "Wyst\u0105pi\u0142 b\u0142\u0105d {0} podczas wywo\u0142ywania metody o sygnaturze {1}." },
		{ Message.RUN_COMMAND_FAILED, "B\u0142\u0105d podczas uruchamiania komendy {0}.  B\u0142\u0105d: {1}." },
		{ Message.MDY_ERROR, "Funkcja DateTimeLib.mdy nie mo\u017ce przekszta\u0142ci\u0107 warto\u015bci {0}, {1} i {2} w miesi\u0105c, dzie\u0144 i rok." },
		{ Message.NON_NUMERIC_STRING, "Do funkcji {0} przekazano \u0142a\u0144cuch nieliczbowy {1}. Wszystkie znaki w porcji \u0142a\u0144cucha zdefiniowanej przy u\u017cyciu argumentu length musz\u0105 by\u0107 warto\u015bci\u0105 liczbow\u0105." },
		{ Message.SYSTEM_FUNCTION_ERROR, "Operacja {0} nie powiod\u0142a si\u0119 z komunikatem o b\u0142\u0119dzie {1}." },
		{ Message.INT_AS_CHAR_ERROR, "Argument funkcji StrLib.intAsChar musi by\u0107 liczb\u0105 z zakresu od 0 do 255." },
		{ Message.INVALID_LOB_LENGTH, "Warto\u015b\u0107 {0} nie jest poprawn\u0105 d\u0142ugo\u015bci\u0105 dla elementu {1}, kt\u00f3ry ma wielko\u015b\u0107 {2}." },
		{ Message.INVALID_LOB_POSITION, "Warto\u015b\u0107 {0} nie jest poprawnym po\u0142o\u017ceniem dla {1}. Wielko\u015b\u0107: {2}." },
		{ Message.LOB_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas przetwarzania elementu Blob lub Clob.  Komunikat o b\u0142\u0119dzie: {0}" },
		{ Message.START_TRANSACTION_ERROR, "Wykonanie funkcji VGLib.startTransaction dla klasy {0} nie powiod\u0142o si\u0119. Wyj\u0105tek: {1}" },
		{ Message.INT_AS_UNICODE_ERROR, "Argument funkcji StrLib.intAsUnicode musi by\u0107 liczb\u0105 z zakresu od 0 do 65535." },
		{ Message.INVALID_ARRAY_SIZE, "Warto\u015b\u0107 wielko\u015bci {0} nie jest poprawna dla tablicy {1}. Maksymalna wielko\u015b\u0107 to {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "Indeks {0} jest poza zakresem dla tablicy {1}. Wielko\u015b\u0107 tablicy to {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "Niepoprawne indeksy pod\u0142a\u0144cucha {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "Argument podany do funkcji dla tablicy {0} jest niepoprawny." },
		{ Message.INDEX_OUT_OF_BOUNDS, "Warto\u015b\u0107 indeksu {0} jest poza zakresem." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} jest nieobs\u0142ugiwan\u0105 tabel\u0105 konwersji." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "Nie mo\u017cna odczyta\u0107 pliku csouidpwd.properties. B\u0142\u0105d: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "Bufor dla klienta jest zbyt ma\u0142y, aby mo\u017cna by\u0142o zapisa\u0107 w nim dane przekazywane w wywo\u0142aniu. \u0141\u0105czna wielko\u015b\u0107 przekazywanych parametr\u00f3w wynosi {0} bajt\u00f3w i jest wi\u0119ksza ni\u017c maksymalna dozwolona wielko\u015b\u0107 danych, kt\u00f3ra wynosi {1} bajt\u00f3w." },
		{ Message.INVALID_PARMFORM, "W\u0142a\u015bciwo\u015b\u0107 parmForm dotycz\u0105ca \u0142\u0105czenia musi by\u0107 ustawiona na warto\u015b\u0107 COMMPTR, aby mo\u017cliwe by\u0142o wywo\u0142anie programu {0}, poniewa\u017c wyst\u0119puje co najmniej jeden parametr, kt\u00f3ry jest tablic\u0105 dynamiczn\u0105." },
		{ Message.PARM_PASSING_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas przekazywania parametr\u00f3w do wywo\u0142ywanego programu {0}. B\u0142\u0105d: {1}" },
		{ Message.CALL_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wywo\u0142ywania programu {0}. B\u0142\u0105d: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "Warto\u015b\u0107 {0} nie jest obs\u0142ugiwanym typem parametru dla program\u00f3w us\u0142ugi System i." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "Warto\u015b\u0107 {0} nie jest obs\u0142ugiwanym typem zwracanym dla program\u00f3w us\u0142ugi System i." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "Nie mo\u017cna pobra\u0107 obiektu ConnectionFactory. Wyj\u0105tek: {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "Nie mo\u017cna zamkn\u0105\u0107 interakcji lub po\u0142\u0105czenia. B\u0142\u0105d: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "Nie mo\u017cna nawi\u0105za\u0107 po\u0142\u0105czenia. B\u0142\u0105d: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "Nie mo\u017cna uzyska\u0107 interakcji. Wyj\u0105tek: {0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "Nie mo\u017cna ustawi\u0107 komendy interakcji. Wyj\u0105tek: {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "Nie mo\u017cna uzyska\u0107 obiektu LocalTransaction dla jednostki pracy klienta. Wyj\u0105tek: {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "Nie mo\u017cna ustawi\u0107 warto\u015bci limitu czasu w wywo\u0142aniu CICSJ2C. Wyj\u0105tek: {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by nawi\u0105zania komunikacji z systemem CICS. Wyj\u0105tek: {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "Pr\u00f3ba wykonania zdalnej transakcji CICS nie powiod\u0142a si\u0119." },
		{ Message.EXCEPTION_CALLING_IMS, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by nawi\u0105zania komunikacji z systemem IMS. Wyj\u0105tek: {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by nawi\u0105zania komunikacji z systemem IMS." },
		{ Message.MATH_DOMAIN_ERROR, "Wykonanie {0} nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 8 (b\u0142\u0105d domeny). Argument podany dla danej funkcji jest niepoprawny." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "Wykonanie {0} nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 8 (b\u0142\u0105d domeny). Wymagany jest argument o warto\u015bci z zakresu od -1 do 1." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "Wykonanie {0} nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 8 (b\u0142\u0105d domeny). Drugim argumentem funkcji nie mo\u017ce by\u0107 zero." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "Wykonanie {0} nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 8 (b\u0142\u0105d domeny). Wymagany jest argument o warto\u015bci wi\u0119kszej ni\u017c zero." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "Wykonanie funkcji MathLib.pow nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 8 (b\u0142\u0105d domeny). Je\u015bli pierwszy argument ma warto\u015b\u0107 zero, w\u00f3wczas drugi argument musi mie\u0107 warto\u015b\u0107 wi\u0119ksz\u0105 ni\u017c zero." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "Wykonanie funkcji MathLib.pow nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 8 (b\u0142\u0105d domeny). Je\u015bli warto\u015b\u0107 pierwszego argumentu jest mniejsza ni\u017c zero, w\u00f3wczas warto\u015b\u0107 drugiego argumentu musi by\u0107 warto\u015bci\u0105 ca\u0142kowit\u0105." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "Wykonanie funkcji MathLib.sqrt nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 8 (b\u0142\u0105d domeny). Wymagany jest argument o warto\u015bci wi\u0119kszej lub r\u00f3wnej zero." },
		{ Message.MATH_RANGE_ERROR, "Wykonanie {0} nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 12 (b\u0142\u0105d zakresu)." },		
		{ Message.STRING_INDEX_ERROR, "Wykonanie {0} nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 8. Wymagana jest warto\u015b\u0107 indeksu z zakresu od 1 do warto\u015bci odpowiadaj\u0105cej d\u0142ugo\u015bci okre\u015blonego \u0142a\u0144cucha." },
		{ Message.STRING_LENGTH_ERROR, "Wykonanie {0} nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 12. Wymagany jest parametr length o warto\u015bci wi\u0119kszej ni\u017c zero." },
		{ Message.STRING_NULT_ERROR, "Wykonanie funkcji StrLib.setNullTerminator nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 16. Ostatnim bajtem \u0142a\u0144cucha docelowego musi by\u0107 odst\u0119p lub znak o kodzie zero." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "Wykonanie {0} nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 20. Warto\u015b\u0107 indeksu pod\u0142a\u0144cucha typu STRING, DBCHAR lub UNICODE musi by\u0107 nieparzysta, aby indeks identyfikowa\u0142 pierwszy bajt znaku." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "Wykonanie {0} nie powiod\u0142o si\u0119; zwr\u00f3cony zosta\u0142 kod b\u0142\u0119du 24. D\u0142ugo\u015b\u0107 pod\u0142a\u0144cucha typu STRING, DBCHAR lub UNICODE musi by\u0107 parzysta, aby zawiera\u0142a pe\u0142n\u0105 liczb\u0119 znak\u00f3w." },
		{ Message.NO_DEBUG_LISTENER, "Nie mo\u017cna nawi\u0105za\u0107 po\u0142\u0105czenia z debugerem EGL na ho\u015bcie o nazwie {0}, port {1}. Wyj\u0105tek: {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas komunikowania si\u0119 z debugerem EGL na ho\u015bcie o nazwie {0}, port {1}. Wyj\u0105tek: {2}" },
		{ Message.NOT_DEBUG_MODE, "W wi\u0105zaniu okre\u015blono wywo\u0142anie DEBUG na serwerze J2EE. Wywo\u0142anie to nie zosta\u0142o wykonane na serwerze J2EE. Serwer J2EE nie znajduje si\u0119 w trybie debugowania lub nie zosta\u0142a na nim w\u0142\u0105czona obs\u0142uga debugowania kodu EGL." },
		{ Message.LIBRARY_NOT_SPECIFIED, "W wi\u0105zaniu okre\u015blono wywo\u0142anie DEBUG do funkcji nas\u0142uchiwania EGL, ale nie okre\u015blono w\u0142a\u015bciwo\u015bci library." },
		
		{ Message.FILETYPE_MISSING, "Nie mo\u017cna znale\u017a\u0107 w\u0142a\u015bciwo\u015bci \u015brodowiska wykonawczego vgj.ra.fileName.fileType dla pliku {0}." },
		{ Message.FILETYPE_INVALID, "Warto\u015b\u0107 w\u0142a\u015bciwo\u015bci \u015brodowiska wykonawczego vgj.ra.fileName.fileType jest niepoprawna dla pliku {0}." },
		{ Message.INVALID_RECORD_LENGTH, "W elemencie length rekordu musi wyst\u0119powa\u0107 warto\u015b\u0107 rozdzielaj\u0105ca dane inne ni\u017c dane znakowe na ko\u0144cach element\u00f3w." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "Warto\u015b\u0107 parametru occursItem lub lengthItem jest zbyt du\u017ca." },
		{ Message.IO_ERROR, "{0}: Operacja we/wy dla {1} nie powiod\u0142a si\u0119; przyczyna: {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: Nie znaleziono przygotowanej instrukcji {1} [stan sqlstate: {2}][kod sqlcode: {3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: Nie znaleziono tabeli wynikowej {1} [stan sqlstate: {2}][kod sqlcode: {3}]" },
		{ Message.SQL_ERROR, "{0}: B\u0142\u0105d [stan sqlstate: {1}][kod sqlcode: {2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [stan sqlstate: 02000][kod sqlcode: 100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[stan sqlstate: {2}][kod sqlcode: {3}]" },
		{ Message.SQL_CONNECTION_FAILED, "Nie mo\u017cna po\u0142\u0105czy\u0107 si\u0119 z {0}: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "Nie mo\u017cna po\u0142\u0105czy\u0107 si\u0119 z {0}, adres URL bazy danych mo\u017ce by\u0107 niepoprawny: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142adowania sterownik\u00f3w JDBC.  B\u0142\u0105d: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "Nie mo\u017cna przewija\u0107 tabeli wynikowej {0}." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "Nie mo\u017cna nawi\u0105za\u0107 po\u0142\u0105czenia z domy\u015bln\u0105 baz\u0105 danych. Nie okre\u015blono nazwy domy\u015blnej bazy danych." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "Przed wykonaniem operacji SQL we/wy musi zosta\u0107 ustanowione po\u0142\u0105czenie z baz\u0105 danych." },
		{ Message.SQL_DISCONNECT_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas roz\u0142\u0105czania z baz\u0105 danych {0}. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "Nie mo\u017cna ustawi\u0107 po\u0142\u0105czenia z baz\u0105 danych {0}. Okre\u015blone po\u0142\u0105czenie nie istnieje." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d SQL w funkcji SQLLib.{0}: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d inny ni\u017c SQL w funkcji SQLLib.{0}: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "Z bazy danych odebrano warto\u015b\u0107 NULL, ale zmienna hosta {0} nie dopuszcza warto\u015bci NULL." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "Nie odebrano danych wej\u015bciowych dla wymaganego pola - nale\u017cy je wprowadzi\u0107 ponownie." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "W danych wej\u015bciowych wyst\u0105pi\u0142 b\u0142\u0105d typu danych - dane nale\u017cy wprowadzi\u0107 ponownie." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "Przekroczono dozwolon\u0105 maksymaln\u0105 liczb\u0119 cyfr znacz\u0105cych - nale\u017cy ponownie wprowadzi\u0107 warto\u015b\u0107." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "Dane wej\u015bciowe nie nale\u017c\u0105 do zdefiniowanego zakresu od {0} do {1} - nale\u017cy je wprowadzi\u0107 ponownie." },
		{ Message.EDIT_VALID_VALUES_ERR, "Dane wej\u015bciowe nie nale\u017c\u0105 do zdefiniowanej listy poprawnych warto\u015bci - nale\u017cy je wprowadzi\u0107 ponownie." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "Okre\u015blony format daty i godziny elementu {0} jest niepoprawny." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "B\u0142\u0105d dotycz\u0105cy minimalnej d\u0142ugo\u015bci wprowadzonych danych - nale\u017cy ponownie wprowadzi\u0107 dane." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "B\u0142\u0105d dotycz\u0105cy maksymalnej d\u0142ugo\u015bci wprowadzonych danych - nale\u017cy ponownie wprowadzi\u0107 dane." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "B\u0142\u0105d sprawdzania poprawno\u015bci edycji tabeli - nale\u017cy ponownie wprowadzi\u0107 dane." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "W danych wej\u015bciowych wyst\u0105pi\u0142 b\u0142\u0105d sprawdzania modulo - nale\u017cy ponownie wprowadzi\u0107 dane." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "Niepoprawne dane wej\u015bciowe dla zdefiniowanego formatu daty lub godziny {0}." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "Dane wej\u015bciowe s\u0105 niepoprawne dla pola danych typu boolowskiego." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "Wprowadzona warto\u015b\u0107 jest niepoprawna, poniewa\u017c jest niezgodna z ustawionym wzorcem." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "Tabela edycji {0} nie zosta\u0142a zdefiniowana dla {1}." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "Dane szesnastkowe s\u0105 niepoprawne." },
		{ Message.EDIT_VALIDATION_ERR, "Wyst\u0105pi\u0142 b\u0142\u0105d sprawdzania poprawno\u015bci strony.  B\u0142\u0105d: {0}." },
		{ Message.EDIT_INPUT_ERR, "B\u0142\u0105d podczas analizowania warto\u015bci wej\u015bciowej."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "B\u0142\u0105d podczas formatowania warto\u015bci do wy\u015bwietlenia: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "Dane wej\u015bciowe ze znakami SO/SI s\u0105 zbyt d\u0142ugie dla zdefiniowanej d\u0142ugo\u015bci elementu."},
		
		{ Message.ACTION_REQUEST_ERROR, "Funkcja RequestAttr J2EELib nie powiod\u0142a si\u0119 z kluczem {0}. B\u0142\u0105d: {1}" },
		{ Message.ACTION_SESSION_ERROR, "Funkcja SessionAttr J2EELib nie powiod\u0142a si\u0119 z kluczem {0}. B\u0142\u0105d: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "Funkcja ApplicationAttr J2EELib nie powiod\u0142a si\u0119 z kluczem {0}. B\u0142\u0105d: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "Biblioteki J2EELib mo\u017cna u\u017cywa\u0107 wy\u0142\u0105cznie w \u015brodowisku J2EE." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "Funkcja PortalLib PortletSessionAttr nie powiod\u0142a si\u0119 z kluczem {0}. B\u0142\u0105d: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "Wykonanie funkcji PortalLib setPortletMode nie powiod\u0142o si\u0119. B\u0142\u0105d: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "Wykonanie funkcji PortalLib setWindowState nie powiod\u0142o si\u0119. B\u0142\u0105d: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "Niedozwolona pr\u00f3ba zmiany trybu portletu podczas \u017c\u0105dania renderowania" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "Niedozwolona pr\u00f3ba zmiany stanu okna portletu podczas \u017c\u0105dania renderowania" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "Nie powiod\u0142o si\u0119 pobranie obiektu PortletSession" }, 
		{ Message.PORTALLIB_INVALIDKEY, "Przekazano niepoprawny klucz do funkcji {0}" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "Nie powiod\u0142o si\u0119 pobranie obiektu PortletRequest" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "Funkcja PortalLib resetPreferenceValue nie powiod\u0142a si\u0119 z kluczem {0}. B\u0142\u0105d: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "Wykonanie funkcji PortalLib savePreferences nie powiod\u0142o si\u0119. B\u0142\u0105d: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "Nie powiod\u0142o si\u0119 ustawienie preferencji dla klucza {0} przez bibliotek\u0119 PortalLib. B\u0142\u0105d: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "Nie powiod\u0142o si\u0119 pobranie preferencji dla klucza {0} przez bibliotek\u0119 PortalLib. B\u0142\u0105d: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "Nie powi\u00f3d\u0142 si\u0119 dost\u0119p do us\u0142ugi skarbca referencji. B\u0142\u0105d: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "Nie powi\u00f3d\u0142 si\u0119 dost\u0119p do \u017c\u0105danej referencji w gnie\u017adzie {0}. B\u0142\u0105d: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "Nie powiod\u0142o si\u0119 utworzenie gniazda skarbca referencji w przestrzeni u\u017cytkownika. B\u0142\u0105d: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "Nie powiod\u0142o si\u0119 usuni\u0119cie gniazda skarbca referencji w przestrzeni u\u017cytkownika. B\u0142\u0105d: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "Nie powiod\u0142o si\u0119 ustawienie warto\u015bci referencji. B\u0142\u0105d: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "Operacja {0} nie powiod\u0142a si\u0119. Pr\u00f3ba wywo\u0142ania metody lub uzyskania dost\u0119pu do pola o nazwie {1} spowodowa\u0142a wyst\u0105pienie nieobs\u0142ugiwanego b\u0142\u0119du. Komunikat o b\u0142\u0119dzie: {2}" },
		{ Message.JAVALIB_NULL_ID, "Operacja {0} nie powiod\u0142a si\u0119. {1} to nie jest identyfikator lub jest to identyfikator obiektu o warto\u015bci NULL." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "Operacja {0} nie powiod\u0142a si\u0119. Publiczna metoda, pole lub klasa o nazwie {1} nie istnieje lub nie mo\u017cna jej za\u0142adowa\u0107 albo u\u017cyto niepoprawnej liczby parametr\u00f3w lub typ\u00f3w parametr\u00f3w. Komunikat o b\u0142\u0119dzie: {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "Operacja {0} nie powiod\u0142a si\u0119. Typ warto\u015bci okre\u015blonej w j\u0119zyku EGL jest niezgodny z typem oczekiwanym dla {1} w \u015brodowisku Java. Komunikat o b\u0142\u0119dzie: {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "Operacja {0} nie powiod\u0142a si\u0119. Celem jest metoda, kt\u00f3ra zwr\u00f3ci\u0142a warto\u015b\u0107 NULL, metoda, kt\u00f3ra nie zwraca \u017cadnej warto\u015bci, lub pole, w kt\u00f3rym wpisana jest warto\u015b\u0107 NULL." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "Operacja {0} nie powiod\u0142a si\u0119. Nie mo\u017cna za\u0142adowa\u0107 klasy {1} dla argumentu NULL. Komunikat o b\u0142\u0119dzie: {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "Operacja {0} nie powiod\u0142a si\u0119. Nie mo\u017cna uzyska\u0107 informacji o metodzie lub polu o nazwie {1} albo wyst\u0105pi\u0142a pr\u00f3ba ustawienia warto\u015bci pola, kt\u00f3re jest zadeklarowane przy u\u017cyciu deklaratora final. Komunikat o b\u0142\u0119dzie: {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "Operacja {0} nie powiod\u0142a si\u0119. {1} to interfejs lub klasa abstrakcyjna, dlatego nie mo\u017cna wywo\u0142a\u0107 jej konstruktora." },
		{ Message.JAVALIB_NOT_STATIC, "Operacja {0} nie powiod\u0142a si\u0119. Metoda lub pole {1} nie jest statyczne. Zamiast nazwy klasy nale\u017cy u\u017cy\u0107 identyfikatora." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "Pole dzia\u0142ania {0} nie istnieje." },
		{ Message.CUI_E_ARRAY_FULL, "Nie mo\u017cna wstawi\u0107 kolejnego wiersza, poniewa\u017c tablica wej\u015bciowa jest zape\u0142niona." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "Nie mo\u017cna znale\u017a\u0107 tablicy {0}." },
		{ Message.CUI_E_ASSIGN_RESULT, "Nie powiod\u0142o si\u0119 przypisanie do zmiennej wyniku z wiersza komend." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "Wielko\u015b\u0107 {0} dla pola tablicy ekranu jest niepoprawna."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "Parametry DrawBox s\u0105 poza zakresem." },
		{ Message.CUI_E_BAD_COORDINATES, "Wsp\u00f3\u0142rz\u0119dne ekranu s\u0105 poza obramowaniem okna." },
		{ Message.CUI_E_BAD_KEYNAME, "Zniekszta\u0142cona nazwa klawisza ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "Nie mo\u017cna u\u017cy\u0107 danej funkcji edycji, poniewa\u017c istnieje ju\u017c obraz." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "Nie mo\u017cna znale\u017a\u0107 okna ''{0}''." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "Warto\u015bci nowego po\u0142o\u017cenia okna [{0},{1}]/wymiar [{2},{3}] s\u0105 niepoprawne." },
		{ Message.CUI_E_CMDSTACK_SYNC, "Nast\u0105pi\u0142a utrata synchronizacji stosu komend." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "Biblioteka interfejsu u\u017cytkownika konsoli nie jest zainicjowana." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "Niedozwolony typ pola dla instrukcji construct." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "Nie mo\u017cna wywo\u0142a\u0107 funkcji ConstructQuery z list\u0105 zmiennych." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "Nie mo\u017cna wy\u0142\u0105czy\u0107 niewidocznego elementu menu." },
		{ Message.CUI_E_EDIT_FAILED, "Dzia\u0142anie edycji nie powiod\u0142o si\u0119." },
		{ Message.CUI_E_EXEC_HOTKEY, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wykonywania dzia\u0142ania zwi\u0105zanego z klawiszem skr\u00f3tu." },
		{ Message.CUI_E_EXIT_NO_CMD, "Brak aktywnej komendy, z kt\u00f3rej mog\u0142oby nast\u0105pi\u0107 wyj\u015bcie." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "Brak aktywnej komendy, kt\u00f3rej wykonywanie mog\u0142oby by\u0107 kontynuowane." },
		{ Message.CUI_E_FATALERROR, "B\u0142\u0105d krytyczny: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "Pole {0} nie istnieje." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "Pole tablicy ekranu {0} nie jest tablic\u0105." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "Nie mo\u017cna znale\u017a\u0107 pola {0}." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "Nie mo\u017cna utworzy\u0107 pola ConsoleField bez okna." },
		{ Message.CUI_E_FIELD_COUNT, "Niezgodno\u015b\u0107 liczby p\u00f3l tablicy." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "Formularz {0} nie istnieje." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "Formularz {0} nie mie\u015bci si\u0119 w oknie {1}." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "Listy p\u00f3l nie s\u0105 zgodne." },
		{ Message.CUI_E_FORM_IN_USE, "Formularz {0} jest zaj\u0119ty." },
		{ Message.CUI_E_FORM_NAME_USED, "Formularz o nazwie {0} ju\u017c istnieje." },
		{ Message.CUI_E_FORM_NOT_OPEN, "Formularz {0} nie jest otwarty." },
		{ Message.CUI_E_FORM_NO_WINDOW, "Nie mo\u017cna utworzy\u0107 formularza ConsoleForm bez okna." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "Nie mo\u017cna u\u017cy\u0107 funkcji KeyObject.getChar() dla klawiszy wirtualnych." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "Nie mo\u017cna u\u017cy\u0107 funkcji KeyObject.getCookedChar() dla klawiszy wirtualnych." },
		{ Message.CUI_E_INTERNAL, "B\u0141\u0104D WEWN\u0118TRZNY: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "Odebrany zosta\u0142 sygna\u0142 INTERRUPT." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "Niewidoczny element menu nie mo\u017ce wyst\u0119powa\u0107 bez akceleratora." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "Nie mo\u017cna utworzy\u0107 obiektu ConsoleLabel bez okna." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "Element menu {0} nie mie\u015bci si\u0119 w oknie." },
		{ Message.CUI_E_MISSING_ITEM, "Element menu {0} nie istnieje." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "Konflikt mnemonik\u00f3w menu (klucz={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "Brak aktywnego formularza." },
		{ Message.CUI_E_NO_EDITOR, "Nie okre\u015blono edytora obiekt\u00f3w BLOB." },
		{ Message.CUI_E_NO_HELP_FILE, "Nie okre\u015blono pliku pomocy." },
		{ Message.CUI_E_NO_HELP_MSG, "Nie okre\u015blono komunikatu pomocy." },
		{ Message.CUI_E_NO_NUMPAGES, "Nie okre\u015blono uk\u0142adu menu." },
		{ Message.CUI_E_NO_SCREENARRAY, "Brak aktywnej tablicy ekranu." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "Brak widocznych element\u00f3w menu." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "Dla nowego okna okre\u015blono nazw\u0119 o warto\u015bci NULL." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "Nast\u0105pi\u0142a pr\u00f3ba otwarcia okna o warto\u015bci null." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "W wierszu komend wyst\u0105pi\u0142 wyj\u0105tek." },
		{ Message.CUI_E_QUIT_RECEIVED, "Odebrany zosta\u0142 sygna\u0142 QUIT." },
		{ Message.CUI_E_SCROLL_FAILED, "Nie mo\u017cna przewin\u0105\u0107 menu do bie\u017c\u0105cego elementu." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "Nieznany atrybut ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "B\u0142\u0105d w polu {0}." },
		{ Message.CUI_E_VAR_LIST_SHORT, "Podano niewystarczaj\u0105c\u0105 liczb\u0119 zmiennych." },
		{ Message.CUI_E_WINDOW_NAME_USED, "Nazwa okna {0} jest ju\u017c u\u017cywana." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "Wielko\u015b\u0107 okna jest zbyt ma\u0142a, aby wy\u015bwietli\u0107 ekran pomocy." },
		{ Message.CUI_E_VALID_VALUES, "Podana warto\u015b\u0107 nie jest warto\u015bci\u0105 poprawn\u0105." },
		{ Message.CUI_W_NO_MORE_FIELDS, "W kierunku, w kt\u00f3rym przemieszcza si\u0119 u\u017cytkownik, nie ma ju\u017c wi\u0119cej p\u00f3l." },
		{ Message.CUI_W_NO_MORE_ROWS, "W kierunku, w kt\u00f3rym przemieszcza si\u0119 u\u017cytkownik, nie ma ju\u017c wi\u0119cej wierszy." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "Zawarto\u015b\u0107 tablicy ekranu {0} jest niepoprawna." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "Tablica ekranu {0} nie mo\u017ce zawiera\u0107 posegmentowanego pola {1}."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "Tablica ekranu {0} nie jest zgodna z tablic\u0105 danych." },
		{ Message.CUI_E_FIELD_NAME_DUP, "Nazwa pola {0} jest u\u017cyta wi\u0119cej ni\u017c jeden raz." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "D\u0142ugo\u015b\u0107 pola konsoli {0} jest niepoprawna." },
		{ Message.CUI_E_LABEL_NOT_FIT, "Etykieta o wsp\u00f3\u0142rz\u0119dnych [{0}, {1}] nie mie\u015bci si\u0119 w dost\u0119pnym obszarze." },
		{ Message.CUI_E_FIELD_NOT_FIT, "Segment pola {0} o wsp\u00f3\u0142rz\u0119dnych ({1}, {2}) nie mie\u015bci si\u0119 w dost\u0119pnym obszarze." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"\u0141a\u0144cuch wiersza komend jest zbyt d\u0142ugi dla aktywnego okna."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"Argumenty tablicy OpenUI s\u0105 niepoprawne."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "Argumenty pola OpenUI s\u0105 niepoprawne."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "Z instrukcj\u0105 wiersza komend mo\u017ce by\u0107 powi\u0105zana tylko pojedyncza zmienna." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "Nie mo\u017cna okre\u015bli\u0107 powi\u0105zania danych dla pola konsoli {0}." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "Ostrze\u017cenie: W danych typu clob wyst\u0119puj\u0105 znaki NULL." },
		{ Message.CUI_I_STR_WINDOWTITLE , "Okno Konsola EGL" },
		{ Message.CUI_E_MISSING_FORMAT , "Dla pola {0} nie jest okre\u015blony \u017caden obiekt formatu." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "Dwa podane wpisy nie by\u0142y takie same -- spr\u00f3buj ponownie." },
		{ Message.CUI_I_STR_VERIFY_INPUT, "Wprowad\u017a ponownie dane w celu sprawdzenia poprawno\u015bci." },
		{ Message.CUI_I_STR_HELP,"Pomoc"},
		{ Message.CUI_I_STR_RESUME,"Wzn\u00f3w"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"Powoduje zako\u0144czenie tej sesji Pomocy."},
		{ Message.CUI_I_STR_SCROLL , "Przewi\u0144" },
		{ Message.CUI_I_STR_LAST_PAGE, "Osi\u0105gni\u0119ty zosta\u0142 koniec tekstu Pomocy. Naci\u015bnij klawisz RETURN, aby kontynuowa\u0107."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "Wy\u015bwietla nast\u0119pn\u0105 stron\u0119 tekstu Pomocy."},
		{ Message.CUI_I_STR_SELECT , "WYBIERZ"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "Wyst\u0105pi\u0142 b\u0142\u0105d podczas wstawiania pierwszego wiersza do pustej tablicy."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 nie zaimplementowane."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "WEWN\u0118TRZNY: F25-64 nie zaimplementowane." },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "Nie mo\u017cna u\u017cywa\u0107 wielu instancji obiektu CursesCanvas." },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "Nie zainicjowano obiektu CursesCanvas." },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "Obiekt CursesCanvas jest za ma\u0142y."},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "Nie zaimplementowano wy\u015bwietlania p\u00f3l wed\u0142ug nazw."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "Wymagane wprowadzenie minimalnej ilo\u015bci danych {0} - nale\u017cy ponownie wprowadzi\u0107 dane." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "Przekroczono maksymaln\u0105 liczb\u0119 danych wej\u015bciowych, {0} - nale\u017cy ponownie wprowadzi\u0107 dane." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "Nie mo\u017cna otworzy\u0107 pliku skryptu ''{0}''." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "Nie mo\u017cna odczyta\u0107 pliku skryptu."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "W\u0142a\u015bciwo\u015b\u0107 automation.scenario ''{0}'' nie jest katalogiem."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "Zniekszta\u0142cona dyrektywa <click> w skrypcie odtwarzania."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "Nie mo\u017cna uzyska\u0107 w\u0142a\u015bciwo\u015bci automatyzacji ''{0}''."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "Niepoprawna nazwa klawisza awaryjnego ''{0}''"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "Wyst\u0105pi\u0142 wyj\u0105tek w <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "Nie mo\u017cna otworzy\u0107 pliku obrazu stanu ''{0}''."},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "W\u0142a\u015bciwo\u015b\u0107 ustawiona dla warto\u015bci automation.scriptdir ''{0}'' nie istnieje."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "Nie mo\u017cna utworzy\u0107 w\u0142a\u015bciwo\u015bci ustawionej dla katalogu automation.scenario ''{0}''."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "Niepoprawna nazwa klawisza obrazu stanu ''{0}''"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "Por\u00f3wnanie zosta\u0142o wykonane pomy\u015blnie."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "Korzystanie z operacji we/wy ekranu nie jest dozwolone podczas dzia\u0142ania w trybie RCP."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "Komunikat o identyfikatorze {0} nie istnieje w tabeli komunikat\u00f3w {1}." },
		{ Message.MSG_TBL_LOAD_ERR, "Nie mo\u017cna za\u0142adowa\u0107 pliku tabeli komunikat\u00f3w {0}." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "Dla rekordu VGUIRecord {0} nie ma zdefiniowanej tabeli komunikat\u00f3w u\u017cytkownika." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "Pole ''{0}'' na pozycji ({1}, {2}) znajduje si\u0119 poza obszarem formularza." },
		{ Message.TUI_E_FIELD_OVERLAP, "Pole ''{0}'' nak\u0142ada si\u0119 na ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "B\u0142\u0105d wewn\u0119trzny: nie mo\u017cna okre\u015bli\u0107 grupy formularza." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "Formularza ''{0}'' nie mo\u017cna wy\u015bwietli\u0107 w \u017cadnym przemieszczalnym obszarze." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "Wsp\u00f3\u0142rz\u0119dne pola ''{0}'' s\u0105 niepoprawne." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "Nie mo\u017cna uzyska\u0107 powi\u0105zania wydruku." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "Brak odpowiedniego urz\u0105dzenia wydruku przystosowanego do tworzenia wydruk\u00f3w o okre\u015blonej wielko\u015bci." },
		{ Message.TUI_E_NO_DISPLAY, "Nie ma urz\u0105dzenia graficznego dla formularzy." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "Nie istnieje definicja wielko\u015bci urz\u0105dzenia zgodnej z wy\u015bwietlanymi formularzami." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "Klasa formularza pomocy ''{0}'' nie istnieje." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "Nieznany atrybut ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "Warto\u015b\u0107 okre\u015blona w atrybucie poprawnych warto\u015bci jest niepoprawna i nie mo\u017cna jej przeanalizowa\u0107." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "Nie mo\u017cna utworzy\u0107 formularza pomocy ''{0}''" },
		{ Message.TUI_E_INTERNAL, "B\u0141\u0104D WEWN\u0118TRZNY: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "Brak dost\u0119pnej drukarki." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "Brak drukarki domy\u015blnej." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "Nie mo\u017cna znale\u017a\u0107 drukarki ''{0}''.\nDost\u0119pne s\u0105 nast\u0119puj\u0105ce drukarki:\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "B\u0142\u0105d podczas \u0142adowania komunikatu ''{0}''" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "Zawarto\u015bci {0} nie mo\u017cna u\u017cy\u0107 jako pola." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "Nie mo\u017cna znale\u017a\u0107 drukarki ''{0}''" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "Program {0} oczekiwa\u0142 formularza tekstowego {1}, a w instrukcji show przekazany zosta\u0142 formularz tekstowy {2}." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "Nast\u0119pna" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "Strona {0} z {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "Poprzednia" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "Drukuj" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "Podgl\u0105d wydruku - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "Zapisz" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "Zapisz zadanie drukowania - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "B\u0142\u0105d podczas drukowania do pliku: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "B\u0142\u0105d podczas drukowania za pomoc\u0105 drukarki: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "Ustawienie EZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "Sprawdzanie poprawno\u015bci pola ''{0}''" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "Sprawdzanie poprawno\u015bci formularza tekstowego (textForm)." },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "Sprawdzanie poprawno\u015bci formularza tekstowego (textForm) - uruchamianie funkcji analizatora poprawno\u015bci ''{0}''." },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "Nie mo\u017cna utworzy\u0107 elementu zapisuj\u0105cego dane w dzienniku." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "Parametru rejestrowania ''{0}'' nie mo\u017cna ustawi\u0107 po uruchomieniu." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "Katalog dziennika {0} nie istnieje." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "Nie mo\u017cna zapisa\u0107 danych w katalogu dziennika ''{0}''." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "Nie mo\u017cna utworzy\u0107 pliku dziennika ''{0}''." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "Nie mo\u017cna zapisa\u0107 danych w pliku dziennika ''{0}''." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Wyst\u0105pi\u0142 problem podczas \u0142adowania us\u0142ugi dla komponentu/us\u0142ugi zewn\u0119trznej {0}." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas tworzenia po\u0142\u0105czenia z operacj\u0105 us\u0142ugi Web Service ''{0}''.  {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pobierania operacji ''{0}'' z pliku wsdl ''{1}''." },
		{ Message.SOA_E_WS_MALFORMED_URL, "Docelowy adres URL dla operacji us\u0142ugi Web Service {1} jest niepoprawny. Adres URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142adowania us\u0142ugi {0}. B\u0142\u0105d: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by za\u0142adowania us\u0142ugi Web Service. Nie mo\u017cna przet\u0142umaczy\u0107 portu WSDL dla us\u0142ugi zewn\u0119trznej {0}." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "W komponencie {0} brakuje w\u0142a\u015bciwo\u015bci {1} wymaganej przez implementacj\u0119 us\u0142ugi." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "Odniesienie us\u0142ugi ''{0}'' nie wyst\u0119puje albo nie ma warto\u015bci docelowej." },
		{ Message.SOA_E_MISSING_BINDING, "Powi\u0105zanie us\u0142ugi ''{0}'' nie istnieje w deskryptorze wdra\u017cania ''{1}''" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by przekszta\u0142cenia rekordu ''{0}'' w komunikat SOAP.  W rekordzie nie mo\u017cna znale\u017a\u0107 pola ''{1}''." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by przekszta\u0142cenia ''{0}'' w komunikat SOAP."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas przetwarzania komunikatu przychodz\u0105cego z us\u0142ugi Web Service. Typ Java jest niezgodny z typem EGL." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas przetwarzania komunikatu wychodz\u0105cego do us\u0142ugi Web Service. Typ EGL jest niezgodny z typem Java." },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "Nie mo\u017cna zainicjowa\u0107 rekordu ''{0}''." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "Nie mo\u017cna przekszta\u0142ci\u0107 warto\u015bci ''{0}'' w warto\u015b\u0107 kalendarzow\u0105." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "Nie mo\u017cna przekszta\u0142ci\u0107 warto\u015bci ''{0}'' w warto\u015b\u0107 boolowsk\u0105." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "Nie mo\u017cna przekszta\u0142ci\u0107 warto\u015bci ''{0}'' w warto\u015b\u0107 bajtow\u0105." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "Nie mo\u017cna przekszta\u0142ci\u0107 warto\u015bci ''{0}'' w warto\u015b\u0107 kr\u00f3tk\u0105." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "Nie mo\u017cna przekszta\u0142ci\u0107 warto\u015bci ''{0}'' w identyfikator URI." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "Typ EGL nie jest obs\u0142ugiwany jako parametr us\u0142ugi Web Service." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by utworzenia tablicy rekord\u00f3w. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "Nie znaleziono metody {0} w us\u0142udze {1}." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "Dana us\u0142uga nie jest us\u0142ug\u0105 Web Service." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by wywo\u0142ania funkcji: {0} dla us\u0142ugi Web Service: {1}." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by wywo\u0142ania funkcji: {0} dla us\u0142ugi EGL: {1}." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by wywo\u0142ania funkcji: {0} dla us\u0142ugi EGL: {1} przy u\u017cyciu {2}:{3}." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "Dana us\u0142uga nie jest us\u0142ug\u0105 tcpip." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by wywo\u0142ania funkcji: {0} dla punktu wej\u015bcia: {1}." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by za\u0142adowania pliku powi\u0105zania us\u0142ugi {0}. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by wywo\u0142ania funkcji: {0} dla us\u0142ugi CICS: {1}. Kod b\u0142\u0119du: {2}, Komunikat: {3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by wywo\u0142ania funkcji {0} dla us\u0142ugi iSeries {1}. Kod b\u0142\u0119du: {2}, Komunikat: {3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "Dana us\u0142uga nie jest us\u0142ug\u0105 CICS." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d w us\u0142udze zdalnej {0}, data {1}, godzina {2}, w systemie {3}." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "Wyst\u0105pi\u0142 b\u0142\u0105d w us\u0142udze zdalnej {0}, w systemie {1}." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "Zako\u0144czenie dzia\u0142ania jednostki uruchamiania z powodu b\u0142\u0119du aplikacji w systemie {0} podczas pr\u00f3by wywo\u0142ania us\u0142ugi {1}. Komunikat: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "B\u0142\u0105d wykonania pakietu AS400Toolbox: {0}, {1} podczas wywo\u0142ywania us\u0142ugi {2} w systemie {3}." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "Nieobs\u0142ugiwane powi\u0105zanie klienta us\u0142ugi. {0} wygenerowano dla Websphere, ale wywo\u0142anie pochodzi ze \u015brodowiska innego ni\u017c J2EE. Wygeneruj ponownie dla projektu innego ni\u017c J2EE." },
		{ Message.SOA_E_USER_ID_NOT_SET, "Przed wywo\u0142aniem us\u0142ugi WebService:{0} (funkcja:{1}) nale\u017cy ustawi\u0107 identyfikator i has\u0142o zdalnego u\u017cytkownika." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "Wyst\u0105pi\u0142 wyj\u0105tek podczas wywo\u0142ywania us\u0142ugi." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "Wyst\u0105pi\u0142 wyj\u0105tek podczas komunikowania si\u0119 z us\u0142ug\u0105. Adres URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "Wyst\u0105pi\u0142 wyj\u0105tek w wywo\u0142aniu REST us\u0142ugi. Powi\u0105zanie: {0}, Operacja: {0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "Wyst\u0105pi\u0142 wyj\u0105tek w wywo\u0142aniu SOAP us\u0142ugi. Powi\u0105zanie: {0}, Us\u0142uga: {1}, Port:{2}, Po\u0142o\u017cenie WSDL: {3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "Wyst\u0105pi\u0142 wyj\u0105tek podczas przekszta\u0142cania z formatu JSON. Parametr: {0}, JSON: {1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "Wyst\u0105pi\u0142 wyj\u0105tek podczas przekszta\u0142cania w format JSON. Parametr: {0}, Warto\u015b\u0107: {1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "Nie znaleziono us\u0142ugi REST-RPC. Adres URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "Nie otrzymano odpowiedzi z us\u0142ugi. Adres URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "Nie mo\u017cna przekszta\u0142ci\u0107 \u017c\u0105dania w wywo\u0142anie us\u0142ugi. Otrzymane \u017c\u0105danie to ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "Wywo\u0142anie us\u0142ugi przekroczy\u0142o limit czasu. Wyj\u0105tek: B\u0142\u0105d przekroczenia limitu czasu po\u0142\u0105czenia. Adres url: {0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "Dana us\u0142uga nie jest us\u0142ug\u0105 rest." },
		{ Message.SOA_E_REST_SERVICE, "Odwo\u0142anie do wywo\u0142ania us\u0142ugi REST nie powiod\u0142o si\u0119. Powi\u0105zanie: {0}, Operacja:{1}, Metoda HTTP: {2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "Wyst\u0105pi\u0142 wyj\u0105tek podczas przekszta\u0142cania danych w parametry EGL. Powi\u0105zanie: {0}, dane do przekszta\u0142cenia {1}, wyj\u0105tek:{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "Dla odwo\u0142ania do us\u0142ugi innej ni\u017c REST wykonano wywo\u0142anie us\u0142ugi REST. Odwo\u0142anie do us\u0142ugi: {0}, Operacja {1}, Metoda HTTP: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "Wyst\u0105pi\u0142 wyj\u0105tek podczas przekszta\u0142cania z formatu XML. Brak wymaganego sk\u0142adnika {0}." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "Wyst\u0105pi\u0142 wyj\u0105tek podczas przekszta\u0142cania z formatu XML. paramter:{0}, xml:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "Wyst\u0105pi\u0142 wyj\u0105tek podczas przekszta\u0142cania w format XML. Parametr: {0}, Warto\u015b\u0107: {1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "Wyst\u0105pi\u0142 wyj\u0105tek analizowania XML podczas przekszta\u0142cania {0} z formatu XML. " },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "Wyst\u0105pi\u0142 wyj\u0105tek przekszta\u0142cania XML podczas przekszta\u0142cania {0} do formatu XML. " },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "Adres URL ''{0}'' u\u017cyty do wywo\u0142ania us\u0142ugi jest niepoprawny. Nie zawiera oznaczenia protoko\u0142u http://." },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "Adres URL ''{0}'' u\u017cyty do wywo\u0142ania us\u0142ugi jest niepoprawny. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "Adres URL u\u017cyty do wywo\u0142ania us\u0142ugi jest pusty. Podaj adres URL, kt\u00f3ry wskazuje us\u0142ug\u0119." },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "Nie mo\u017cna wype\u0142ni\u0107 raportu za pomoc\u0105 po\u0142\u0105czenia {0}"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "Nie mo\u017cna wype\u0142ni\u0107 raportu za pomoc\u0105 instrukcji SQL {0}"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "Nie mo\u017cna wype\u0142ni\u0107 raportu za pomoc\u0105 tablicy dynamicznej {0}"},
		{ Message.REPORT_E_FILL_ERROR , "Nie mo\u017cna wype\u0142ni\u0107 raportu {0}"},
		{ Message.REPORT_E_EXPORT_ERROR, "Nie mo\u017cna wyeksportowa\u0107 raportu {0}" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "Nie mo\u017cna dokona\u0107 konwersji mi\u0119dzy typami EGL {0} i Java {1}." },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "Nie mo\u017cna dokona\u0107 konwersji mi\u0119dzy typami Java {0} i EGL {1}." },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "Nie mo\u017cna doda\u0107 parametru raportu." },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "Nie mo\u017cna zresetowa\u0107 listy parametr\u00f3w raportu." },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "Niepoprawna nazwa pola {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "Niepoprawna nazwa raportu podrz\u0119dnego {0}" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "Do raportowania zosta\u0142 u\u017cyty nieobs\u0142ugiwany typ." },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "Do tej funkcji nie mo\u017cna przekazywa\u0107 typ\u00f3w z\u0142o\u017conych." },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "Nazwa pliku projektu powinna zosta\u0107 ustawiona przed wywo\u0142aniem funkcji getParameterDefaultValue()." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "Nie mo\u017cna pobra\u0107 domy\u015blnej warto\u015bci dla parametru {0}. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "Parametr raportu o nazwie {0} nie istnieje." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "Nazwa pliku projektu powinna zosta\u0107 ustawiona przed wywo\u0142aniem funkcji createReportFromDesign() lub createDocument()." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "Nazwa pliku dokumentu powinna zosta\u0107 ustawiona przed wywo\u0142aniem funkcji createReportFromDocument()." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "Nie mo\u017cna utworzy\u0107 pliku dokumentu raportu. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "Nie mo\u017cna utworzy\u0107 raportu z pliku projektu. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "Nie mo\u017cna utworzy\u0107 raportu z pliku dokumentu. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "Obiekt procedury obs\u0142ugi okre\u015blony dla raportu BirtReport musi mie\u0107 typ BirtHandler." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "Element {0} nie istnieje w projekcie raportu lub nie ma okre\u015blonego typu." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "{0} numer wiersza {1} nie istnieje w tabeli {2}." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "Numer wiersza {0} nie istnieje w elemencie siatki {1}." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "Grupa {0} nie istnieje w tabeli {1}." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "{0} numer wiersza {1} nie istnieje w grupie {2} w tabeli {3}." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "Numer kolumny {0} nie istnieje w wierszu {1} w tabeli {2}." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "Numer kolumny {0} nie istnieje w siatce {1}." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "Numer kolumny {0} nie istnieje w wierszu {1} w grupie {2} w tabeli {3}." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "Dla funkcji obs\u0142ugi zdarze\u0144 dla wiersza lub kom\u00f3rki w tabeli {0} musi by\u0107 okre\u015blona w\u0142a\u015bciwo\u015b\u0107 RowType." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "Nie mo\u017cna przekszta\u0142ci\u0107 typu Java {0} w typ EGL." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "Nie mo\u017cna przekszta\u0142ci\u0107 typu EGL {0} w typ Java." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "Zestaw danych {0} nie istnieje w projekcie raportu." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "Zestaw danych {0} jest skryptowym zestawem danych, ale nie s\u0105 obs\u0142ugiwane \u017cadne z nast\u0119puj\u0105cych typ\u00f3w eventTypes: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "\u0179r\u00f3d\u0142o danych {0} nie istnieje w projekcie raportu." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "\u0179r\u00f3d\u0142o danych {0} jest skryptowym \u017ar\u00f3d\u0142em danych, ale nie s\u0105 obs\u0142ugiwane \u017cadne z nast\u0119puj\u0105cych typ\u00f3w eventTypes: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "Numer kolumny {0} nie istnieje w zestawie danych {1}." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "Wyst\u0105pi\u0142 wyj\u0105tek podczas pobierania kolumny {0} z zestawu danych {1}. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "Wyst\u0105pi\u0142 wyj\u0105tek podczas ustawiania kolumny {0} skryptowego zestawu danych {1}. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "Wyst\u0105pi\u0142 wyj\u0105tek podczas pobierania powi\u0105zania kolumny {0}. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "Nie zosta\u0142a okre\u015blona w\u0142a\u015bciwo\u015b\u0107 vgj.defaultI4GLNativeLibrary." },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "Za\u0142adowanie biblioteki {0} nie powiod\u0142o si\u0119 {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "Zwr\u00f3cone parametry nie odpowiadaj\u0105 funkcji" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "Nie mo\u017cna przydzieli\u0107 pami\u0119ci"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "Nie mo\u017cna dokona\u0107 konwersji typ\u00f3w"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "Niepoprawna dok\u0142adno\u015b\u0107 daty/godziny lub odst\u0119pu czasu"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "Znakowa zmienna j\u0119zyka macierzystego jest zbyt kr\u00f3tka dla okre\u015blonych danych"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "Nie mo\u017cna znale\u017a\u0107 funkcji w tabeli symboli."},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "W tym kontek\u015bcie okre\u015blony musi zosta\u0107 typ danych TEXT lub BYTE"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "Nie mo\u017cna przekszta\u0142ci\u0107 warto\u015bci ze stosu w typ warto\u015bci"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "Nie mo\u017cna przekszta\u0142ci\u0107 warto\u015bci ze stosu w typ ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "Ze stosu nie mo\u017cna zdj\u0105\u0107 warto\u015bci typu {0}"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "Na stos nie mo\u017cna wstawi\u0107 warto\u015bci typu {1}"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "Nie ma warto\u015bci do wstawienia/pobrania ze stosu"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "Ze stosu nie mo\u017cna zdj\u0105\u0107 warto\u015bci typu Locator"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "Stos jest pusty"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "Nie mo\u017cna skopiowa\u0107 wska\u017anika"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "Na stos zosta\u0142o wstawione odniesienie o warto\u015bci null"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "Na stos nie mo\u017cna wstawi\u0107 typu Any"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "Elementu stosu nie mo\u017cna przypisa\u0107 do typu Any"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "Niezgodno\u015b\u0107 typu zwracanego"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "Niezgodno\u015b\u0107 typu parametru"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "Nie mo\u017cna znale\u017a\u0107 pliku \u017ar\u00f3d\u0142owego EGL {0}.  Alternatywnie zostanie uruchomiony wygenerowany kod." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "Nie mo\u017cna znale\u017a\u0107 pliku \u017ar\u00f3d\u0142owego EGL dla transakcji WWW o nazwie {0}." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "W trakcie wy\u015bwietlania formularza \"{1}\", dla pola \"{0}\" wyst\u0105pi\u0142 nast\u0119puj\u0105cy problem zwi\u0105zany z formatowaniem:" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\nOczekiwany format wewn\u0119trzny pola to \"{1}\". Sprawd\u017a preferencje formatowania dat we w\u0142a\u015bciwo\u015bciach \u015brodowiska wykonawczego Java EGL w deskryptorze budowania dla debugowania lub we w\u0142a\u015bciwo\u015bciach JDBC, kt\u00f3re dotycz\u0105 format\u00f3w dat." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\nFormat wy\u015bwietlania pola to \"{1}\". Sprawd\u017a w\u0142a\u015bciwo\u015b\u0107 \"{2}\" w polu formularza." },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "Nie mo\u017cna uruchomi\u0107 programu {0} jako transakcji WWW." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "Do transakcji WWW przekazano wej\u015bciowy rekord interfejsu u\u017cytkownika {0}, lecz zosta\u0142a ona zdefiniowana z wej\u015bciowym rekordem interfejsu u\u017cytkownika {1}." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "Dane wej\u015bciowe s\u0105 niepoprawne dla pola danych typu boolowskiego." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "W programie {0} nast\u0105pi\u0142o przekroczenie limitu czasu z powodu braku aktywno\u015bci." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "Rekord interfejsu u\u017cytkownika {0} zawiera zbyt du\u017co danych do wys\u0142ania do serwletu bramy." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "Program nie m\u00f3g\u0142 sprawdzi\u0107 poprawno\u015bci danych pochodz\u0105cych z serwletu bramy.  Identyfikator danych to {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "Opakowanie tablicy {0} nie mo\u017ce by\u0107 wi\u0119ksze ni\u017c okre\u015blona wielko\u015b\u0107 maksymalna. Wyst\u0105pi\u0142 b\u0142\u0105d w metodzie {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "Warto\u015b\u0107 {0} to niepoprawny indeks dla opakowania tablicy {1}. Maksymalna wielko\u015b\u0107: {2}. Bie\u017c\u0105ca wielko\u015b\u0107: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "Warto\u015b\u0107 {0} nie jest poprawn\u0105 wielko\u015bci\u0105 maksymaln\u0105 dla opakowania tablicy {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} to niepoprawny typ obiektu i nie mo\u017ce zosta\u0107 dodany do opakowania tablicy typu {1}." },
		
		{ Message.IMS_HOST_ABORT, "Ze zdalnego hosta odebrano pakiet przerwania. "},
		{ Message.IMS_HOST_TCPIP_ERROR, "Na zdalnym ho\u015bcie wyst\u0105pi\u0142 b\u0142\u0105d TCPIP. Sekcja: {0}, operacja TCPIP: {1}, kod powrotu TCPIP: {2}, nr b\u0142\u0119du TCPIP: {3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "Wyst\u0105pi\u0142 b\u0142\u0105d na ho\u015bcie podczas wywo\u0142ywania: {0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "Otrzymano niepoprawny pakiet odpowiedzi z hosta. Oczekiwano: {0}, otrzymano: {1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "B\u0142\u0105d we/wy podczas wykonywania procedury sk\u0142adowanej. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "B\u0142\u0105d SQL podczas wykonywania procedury sk\u0142adowanej. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "B\u0142\u0105d na zdalnym ho\u015bcie podczas wykonywania: {0}, kod powrotu: {1} identyfikator zadania proxy DLI:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "B\u0142\u0105d DLI na zdalnym ho\u015bcie. Funkcja DLI: {0}, powr\u00f3t AIB: 0x{1}, przyczyna AIB: 0x{2}, kod statusu:{3} identyfikator zadania proxy DLI: {4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "B\u0142\u0105d DLI na zdalnym ho\u015bcie. Funkcja DLI: {0}, powr\u00f3t AIB: 0x{1}, przyczyna AIB: 0x{2}, DLIVar.statusCode: {3}, DLIVar.DbName: {4}, DLIVar.SegmentName: {5}, DLIVar.SegmentLevel: {6}, identyfikator zadania proxy DLI: {7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "Kod powrotu AIB wskazuje kod statusu PCB, ale \u017caden blok PCB nie zosta\u0142 zwr\u00f3cony. Funkcja AIB: {0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "Wyst\u0105pi\u0142 wyj\u0105tek w funkcji CALL EZEDBTCP na zdalnym ho\u015bcie. Sekcja: {0}, operacja TCPIP: {1}, kod powrotu TCPIP: {2}, nr b\u0142\u0119du TCPIP: {3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "Wyst\u0105pi\u0142 kod nieprawid\u0142owego zako\u0144czenia ABEND na zdalnym ho\u015bcie. Procedura: {0}, komunikat: {1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "Wyst\u0105pi\u0142 wyj\u0105tek na zdalnym ho\u015bcie. CALL: {0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "Debuger nie obs\u0142uguje funkcji DLI. Funkcja: {0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "Trwa generowanie wywo\u0142ania DL/I, ale deskryptor budowania nie zosta\u0142 skonfigurowany dla dost\u0119pu do DL/I."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "Wyj\u0105tek zdalny: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pr\u00f3by przydzielania bloku PSB. Ustawienie opcji IMSID wskazuje, \u017ce istnieje dost\u0119p do DL/I , ale nie podano bloku PSB"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "Wersje klienta i hosta RBD s\u0105 niezgodne. Wersja klienta RBD: {0}, wersja hosta: {1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pobierania danych zwr\u00f3conych z wywo\u0142ania programu hosta. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas pobierania nazwy bloku PCB. Indeks bloku PCB: {0}, liczba blok\u00f3w PCB: {1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
