/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_pt_BR extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "O erro ocorreu em {0}." },
		{ Message.FUNCTION_ERROR_INFO, "O erro ocorreu em {0} ao processar a fun\u00e7\u00e3o {1}." },
		{ Message.FILE_ERROR_INFO, "O erro ocorreu em {0} ao processar a fun\u00e7\u00e3o {1} na linha {2}." },
		{ Message.PROPERTIES_FILE_MISSING, "O arquivo de propriedades {0} n\u00e3o p\u00f4de ser carregado." },
		{ Message.LOAD_LIBRARY_FAILED, "A biblioteca {0} n\u00e3o pode ser carregada. Ocorreu o seguinte erro: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "Ocorreu um erro ao criar um objeto do tipo {0}. Ocorreu o seguinte erro: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "Ocorreu um erro enquanto era criado o InitialContext ou durante a procura do ambiente java:comp/env. Ocorreu o seguinte erro: {0}" },
		{ Message.LISTENER_ERROR, "Ocorreram as seguintes exce\u00e7\u00e3o e mensagem. Exce\u00e7\u00e3o: {0}. Mensagem: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "Um valor para a propriedade {0} \u00e9 necess\u00e1rio." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "Uma depend\u00eancia externa est\u00e1 faltando. Ocorreu a seguinte exce\u00e7\u00e3o. Exce\u00e7\u00e3o: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "Os operandos {0} e {1} n\u00e3o podem ser comparados." },
		{ Message.ASSIGNMENT_OVERFLOW, "Ocorreu um erro de excesso de fluxo ao designar um valor {0} a {1}." },
		{ Message.EXPRESSION_OVERFLOW, "Ocorreu um erro de excesso de fluxo ao calcular a seguinte express\u00e3o: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "O operador {0} n\u00e3o \u00e9 suportado para os operandos {1} e {2}." },
		{ Message.UNSUPPORTED_OPERAND, "O operador {0} n\u00e3o \u00e9 suportado para o operando {1} do tipo {2}." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "O operador de subscript n\u00e3o \u00e9 suportado para o operando {0} do tipo {1}." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "O operador de subccadeia n\u00e3o \u00e9 suportado para o operando {0} do tipo {1}." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "A instru\u00e7\u00e3o SET EMPTY n\u00e3o \u00e9 suportada para o operando {0} do tipo {1}." },
		{ Message.INVALID_REGULAR_EXPRESSION, "Ocorreu um erro na express\u00e3o comum {0}. Erro: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "Ao utilizar o protocolo CICSSSL, tanto ctgKeyStore como ctgKeyStorePassword devem ser especificados." },
		{ Message.INVALID_CTGPORT, "O valor {0} para a entrada ctgport n\u00e3o est\u00e1 correto." },
		{ Message.CTG_CONNECT_FAILED, "Ocorreu um erro ao se conectar ao CTG. O local CTG \u00e9 {0}. A porta CTG \u00e9 {1}. Ocorreu o seguinte erro: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "Ocorreu um erro ao se desconectar do CTG. O local CTG \u00e9 {0}. A porta CTG \u00e9 {1}. Ocorreu o seguinte erro: {2}" },
		{ Message.NO_CICS, "Ocorreu um erro ao chamar o programa {0} que utiliza o ECI CICS. O c\u00f3digo de retorno \u00e9 -3 (ECI_ERR_NO_CICS). O identificador do sistema CICS \u00e9 {1}." },
		{ Message.CICS_DIED, "Ocorreu um erro ao chamar o programa {0} que utiliza o ECI CICS. O c\u00f3digo de retorno \u00e9 -4 (ECI_ERR_CICS_DIED). O identificador do sistema CICS \u00e9 {1}." },
		{ Message.CICS_TIMEOUT, "Ocorreu um erro ao chamar o programa {0} que utiliza o ECI CICS. O c\u00f3digo de retorno \u00e9 -6 (ECI_ERR_RESPONSE_TIMEOUT). O identificador do sistema CICS \u00e9 {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "Ocorreu um erro ao chamar o programa {0} que utiliza o ECI CICS. O c\u00f3digo de retorno \u00e9 -7 (ECI_ERR_TRANSACTION_ABEND). O identificador do sistema CICS \u00e9 {1}. O c\u00f3digo de encerramento de forma anormal \u00e9 {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "Ocorreu um erro ao chamar o programa {0} que utiliza o CICS ECI. O c\u00f3digo de retorno \u00e9 -22 (ECI_ERR_UNKNOWN_SERVER). O identificador do sistema CICS \u00e9 {1}." },
		{ Message.CICS_SECURITY_ERROR, "Ocorreu um erro ao chamar o programa {0} que utiliza o ECI CICS. O c\u00f3digo de retorno \u00e9 -27 (ECI_ERR_SECURITY_ERROR). O identificador do sistema CICS \u00e9 {1}." },
		{ Message.CICS_MAX_SYSTEMS, "Ocorreu um erro ao chamar o programa {0} que utiliza o ECI CICS. O c\u00f3digo de retorno \u00e9 -28 (ECI_ERR_MAX_SYSTEMS). O identificador do sistema CICS \u00e9 {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "Ocorreu um erro ao chamar o programa {0} no sistema {1} para o usu\u00e1rio denominado {2}. Um c\u00f3digo de retorno {3} e {4} c\u00f3digo de encerramento de forma anormal foi retornado da chamada ECI CICS." },
		{ Message.CICS_COMMIT_FAILED, "Ocorreu um erro ao chamar o ECI CICS para confirmar uma unidade de trabalho. O c\u00f3digo de retorno de CICS \u00e9 {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "Ocorreu um erro ao chamar o ECI CICS para recuperar uma unidade de trabalho. O c\u00f3digo de retorno de CICS \u00e9 {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "Uma exce\u00e7\u00e3o ocorreu no fluxo de um Pedido ECI para o Sistema CICS {0}. Exce\u00e7\u00e3o: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "Ocorreu um erro de comprimento de par\u00e2metro. O fluxo possui {0} par\u00e2metros e a fun\u00e7\u00e3o local possui {1} par\u00e2metros." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "O tamanho m\u00e1ximo foi excedido para a matriz {0}." },
		{ Message.WRONG_NUMBER_OF_PARMS, "O programa chamado {0} esperava {1} par\u00e2metros, mas foram passados {2}." },
		{ Message.FUNCTION_NOT_FOUND, "Ocorreu um erro ao obter o endere\u00e7o do ponto de entrada {0} dentro da biblioteca compartilhada {1}. O c\u00f3digo de retorno \u00e9 {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "Ocorreu um erro ao carregar a biblioteca compartilhada {0}. O c\u00f3digo de retorno \u00e9 {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "O programa chamado falhou com um c\u00f3digo de retorno {0}." },
		{ Message.REMOTE_PROGRAM_ERROR, "Ocorreu um erro no programa remoto {0} no sistema {3}. O erro ocorreu em {1} em {2}. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "Ocorreu um erro no programa remoto {0} no sistema {1}. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "O nome do host {0} \u00e9 um TCP/IP desconhecido." },
		{ Message.SERVERID_IS_INVALID_PORT, "O ServerID  {0} n\u00e3o \u00e9 um n\u00famero de porta v\u00e1lido." },
		{ Message.TCPIP_SERVER_ERROR, "O cliente recebeu notifica\u00e7\u00e3o de que o servidor n\u00e3o pode iniciar o programa de chamada remota. C\u00f3digo de raz\u00e3o: {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "O valor de remoteComType est\u00e1 faltando ou n\u00e3o \u00e9 correto." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "O arquivo de propriedades de liga\u00e7\u00e3o {0} n\u00e3o pode ser aberto." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "Uma entrada do programa chamado {0} n\u00e3o pode ser localizada no arquivo de propriedades de liga\u00e7\u00e3o {1}." },
		{ Message.AS400_UNKNOWN_HOST, "O host {0} n\u00e3o pode ser localizado ou n\u00e3o \u00e9 conhecido." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "A senha ou ID do usu\u00e1rio n\u00e3o est\u00e1 correto para conex\u00e3o ao sistema {0}. Erro: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "Ocorreu um erro de execu\u00e7\u00e3o AS400Toolbox {0} ao chamar o programa {2} no sistema {3}. Erro: {1}" },
		{ Message.AS400_NO_AUTHORITY, "Ocorreu um erro de seguran\u00e7a de acesso remoto ao sistema {0} para o usu\u00e1rio {1}. Erro: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "Ocorreu uma falha na fun\u00e7\u00e3o de confirma\u00e7\u00e3o no sistema {0}. Erro: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "Ocorreu uma falha na fun\u00e7\u00e3o de recupera\u00e7\u00e3o no sistema {0}. Erro: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "Ocorreu um erro de conex\u00e3o remota ao acessar o sistema {0}. Erro: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "Ocorreu um erro de Servi\u00e7os do Host EGL OS/400. Os arquivos necess\u00e1rios n\u00e3o foram localizados no sistema {0}." },
		{ Message.AS400_APPLICATION_ERROR, "A unidade de execu\u00e7\u00e3o foi parada, porque ocorreu um erro de aplicativo no sistema {0} ao tentar chamar o programa {1}. Mensagem: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "A vari\u00e1vel de refer\u00eancia denominada {0} \u00e9 nula." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "Ocorreu um erro n\u00e3o manipulado. Erro: {0}." },
		{ Message.DATA_FORMAT_ERROR, "O valor da vari\u00e1vel {0} n\u00e3o est\u00e1 no formato correto." },
		{ Message.CONVERSION_ERROR, "O valor {0} do tipo {1} n\u00e3o pode ser convertido para o tipo {2}." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "O padr\u00e3o do formato de data {0} n\u00e3o \u00e9 v\u00e1lido." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "O padr\u00e3o do formato de hora {0} n\u00e3o \u00e9 v\u00e1lido." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "O padr\u00e3o do formato de registro de data e hora {0} n\u00e3o \u00e9 v\u00e1lido." },
		{ Message.NULL_REFERENCE, "Uma refer\u00eancia nula foi utilizada." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "O acesso din\u00e2mico n\u00e3o \u00e9 suportado para {0}." },
		{ Message.DYNAMIC_ACCESS_FAILED, "Um campo com o identificador {0} n\u00e3o pode ser localizado em {1}." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "O padr\u00e3o de formato num\u00e9rico {0} n\u00e3o \u00e9 v\u00e1lido." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "Ocorreu um erro ao atribuir {0} a {1}. Erro: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "Ocorreu um erro na instru\u00e7\u00e3o SET {0} EMPTY. Erro: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "Ocorreu um erro {0} ao chamar o m\u00e9todo com uma assinatura {1}." },
		{ Message.RUN_COMMAND_FAILED, "Ocorreu um erro ao executar o comando {0}.  Erro: {1}." },
		{ Message.MDY_ERROR, "A fun\u00e7\u00e3o DateTimeLib.mdy n\u00e3o pode converter os valores {0}, {1} e {2} em m\u00eas, dia e ano." },
		{ Message.NON_NUMERIC_STRING, "{0} foi informado em cadeia n\u00e3o num\u00e9rica {1}. Todos os caracteres na parte da cadeia definido pelo argumento length devem ser num\u00e9ricos." },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} falhou com mensagem de erro {1}." },
		{ Message.INT_AS_CHAR_ERROR, "O argumento como StrLib.intAsChar deve ser um n\u00famero entre 0 e 255." },
		{ Message.INVALID_LOB_LENGTH, "{0} n\u00e3o \u00e9 um comprimento v\u00e1lido para {1} que possui um tamanho de {2}." },
		{ Message.INVALID_LOB_POSITION, "{0} n\u00e3o \u00e9 uma posi\u00e7\u00e3o v\u00e1lida para {1}. Seu tamanho \u00e9 {2}." },
		{ Message.LOB_ERROR, "Ocorreu um erro ao processar um item Blob ou Clob.  A mensagem de erro \u00e9 {0}" },
		{ Message.START_TRANSACTION_ERROR, "VGLib.startTransaction para classe {0} falhou. A exce\u00e7\u00e3o \u00e9 {1}" },
		{ Message.INT_AS_UNICODE_ERROR, "O argumento para StrLib.intAsUnicode deve ser um n\u00famero entre 0 e 65535." },
		{ Message.INVALID_ARRAY_SIZE, "O valor do tamanho {0} n\u00e3o \u00e9 v\u00e1lido para a matriz {1}. O tamanho m\u00e1ximo \u00e9 {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "O \u00edndice {0} est\u00e1 fora dos limites para a matriz {1}. O tamanho da matriz \u00e9 {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "\u00cdndices de subcadeia inv\u00e1lida {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "O argumento na fun\u00e7\u00e3o para a matriz {0} n\u00e3o \u00e9 v\u00e1lido." },
		{ Message.INDEX_OUT_OF_BOUNDS, "O valor de \u00edndice {0} est\u00e1 fora dos limites." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} \u00e9 uma tabela de convers\u00e3o n\u00e3o suportada." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "O arquivo csouidpwd.properties n\u00e3o pode ser lido. Erro: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "O buffer do cliente \u00e9 muito pequeno para a quantidade de dados que estava sendo transmitida na chamada. O tamanho cumulativo dos par\u00e2metros que est\u00e3o sendo transmitidos \u00e9 de {0} bytes e excede o m\u00e1ximo permitido, que \u00e9 de {1} bytes." },
		{ Message.INVALID_PARMFORM, "A propriedade de liga\u00e7\u00e3o parmForm deve ser definida para COMMPTR para o programa de chamada {0} pois h\u00e1 pelo menos um par\u00e2metro que \u00e9 uma matriz din\u00e2mica." },
		{ Message.PARM_PASSING_ERROR, "Ocorreu um erro durante a passagem de par\u00e2metros para o programa chamado {0}. Erro: {1}" },
		{ Message.CALL_ERROR, "Ocorreu um erro ao chamar o programa {0}. Erro: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} \u00e9 um tipo de par\u00e2metro n\u00e3o suportado para programas de servi\u00e7os do System i." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} \u00e9 um tipo de retorno n\u00e3o suportado para programas de servi\u00e7os do System i." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "Imposs\u00edvel obter um ConnectionFactory. Exce\u00e7\u00e3o \u00e9 {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "A Intera\u00e7\u00e3o ou Conex\u00e3o n\u00e3o pode ser fechada. Erro: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "Uma conex\u00e3o n\u00e3o pode ser estabelecida. Erro: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "Imposs\u00edvel obter uma Intera\u00e7\u00e3o. A exce\u00e7\u00e3o \u00e9: {0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "Imposs\u00edvel definir um verbo de intera\u00e7\u00e3o. Exce\u00e7\u00e3o \u00e9 {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "Imposs\u00edvel obter um LocalTransaction para a unidade de trabalho cliente. Exce\u00e7\u00e3o \u00e9 {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "Imposs\u00edvel definir o valor de tempo limite em uma chamada CICSJ2C. Exce\u00e7\u00e3o \u00e9 {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "Ocorreu um erro durante uma tentativa de comunica\u00e7\u00e3o com CICS. Exce\u00e7\u00e3o \u00e9 {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "A tentativa de executar a transa\u00e7\u00e3o CICS remota falhou." },
		{ Message.EXCEPTION_CALLING_IMS, "Ocorreu um erro durante uma tentativa de comunicar-se com o IMS. Exce\u00e7\u00e3o \u00e9 {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "Ocorreu um erro durante uma tentativa de comunicar-se com o IMS." },
		{ Message.MATH_DOMAIN_ERROR, "{0} falhou com o c\u00f3digo de erro 8 (erro de dom\u00ednio). Um argumento n\u00e3o \u00e9 v\u00e1lido para a fun\u00e7\u00e3o." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} falhou com o c\u00f3digo de erro 8 (erro de dom\u00ednio). O argumento deve estar entre -1 e 1." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} falhou com o c\u00f3digo de erro 8 (erro de dom\u00ednio). O segundo argumento n\u00e3o deve ser zero." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} falhou com o c\u00f3digo de erro 8 (erro de dom\u00ednio). O argumento deve ser maior que zero." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "MathLib.pow falhou com o c\u00f3digo de erro 8 (erro de dom\u00ednio). Se o primeiro argumento for zero, o segundo dever\u00e1 ser maior que zero." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "MathLib.pow falhou com o c\u00f3digo de erro 8 (erro de dom\u00ednio). Se o primeiro argumento for menor que zero, o segundo dever\u00e1 ser um inteiro." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "MathLib.sqrt falhou com o c\u00f3digo de erro 8 (erro de dom\u00ednio). O argumento deve ser maior ou igual a zero." },
		{ Message.MATH_RANGE_ERROR, "{0} falhou com c\u00f3digo de erro 12 (erro de intervalo)." },		
		{ Message.STRING_INDEX_ERROR, "{0} falhou com c\u00f3digo de erro 8. O \u00edndice deve estar entre 1 e o comprimento da cadeia." },
		{ Message.STRING_LENGTH_ERROR, "{0} falhou com c\u00f3digo de erro 12. O comprimento deve ser maior que zero." },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator falhou com c\u00f3digo de erro 16. O \u00faltimo byte da cadeia de destino deve ser um espa\u00e7o em branco ou um caractere nulo." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} falhou com c\u00f3digo de erro 20. O \u00edndice de uma subcadeia STRING, DBCHAR ou UNICODE deve ser \u00edmpar, para que o \u00edndice identifique o primeiro byte de um caractere." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} falhou com c\u00f3digo de erro 24. O comprimento de uma subcadeia STRING, DBCHAR ou UNICODE deve ser par, para que se refira a um n\u00famero inteiro de caracteres." },
		{ Message.NO_DEBUG_LISTENER, "N\u00e3o \u00e9 poss\u00edvel entrar em contato com o depurador EGL no nome de host {0} e porta {1}. Exce\u00e7\u00e3o \u00e9 {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "Ocorreu um erro durante a comunica\u00e7\u00e3o com o depurador EGL no nome de host {0} e porta {1}. Exce\u00e7\u00e3o \u00e9 {2}" },
		{ Message.NOT_DEBUG_MODE, "A execu\u00e7\u00e3o de link especificou uma chamada DEBUG em um servidor J2EE. A chamada n\u00e3o foi realizada em um servidor J2EE, o servidor J2EE n\u00e3o est\u00e1 no modo de depura\u00e7\u00e3o ou o servidor J2EE n\u00e3o foi ativado para depura\u00e7\u00e3o de EGL." },
		{ Message.LIBRARY_NOT_SPECIFIED, "A liga\u00e7\u00e3o especificou uma chamada DEBUG para um listener EGL mas n\u00e3o especificou a propriedade library." },
		
		{ Message.FILETYPE_MISSING, "A propriedade de tempo de execu\u00e7\u00e3o vgj.ra.fileName.fileType n\u00e3o p\u00f4de ser encontrada para o arquivo {0}." },
		{ Message.FILETYPE_INVALID, "O valor da propriedade de tempo de execu\u00e7\u00e3o vgj.ra.fileName.fileType n\u00e3o \u00e9 v\u00e1lido para o arquivo {0}." },
		{ Message.INVALID_RECORD_LENGTH, "O item de comprimento do registro deve conter um valor que divide dados que n\u00e3o s\u00e3o de caracteres nos limites do item." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "O valor no occursItem ou lengthItem \u00e9 muito grande." },
		{ Message.IO_ERROR, "{0}: A E/S com {1} falhou por este motivo: {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: instru\u00e7\u00e3o preparada {1} n\u00e3o localizada [sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: conjunto de resultados {1} n\u00e3o localizado[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0}: erro[sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "N\u00e3o \u00e9 poss\u00edvel conectar a {0}: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "N\u00e3o \u00e9 poss\u00edvel conectar a {0}, o banco de dados URL pode estar errado: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "Ocorreu um erro ao carregar os drivers JDBC.  Erro: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "O ResultSet {0} n\u00e3o \u00e9 rol\u00e1vel." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "N\u00e3o \u00e9 poss\u00edvel conectar ao banco de dados padr\u00e3o. O nome do banco de dados padr\u00e3o n\u00e3o foi especificado." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "Uma conex\u00e3o com o banco de dados deve ser estabelecida antes de uma opera\u00e7\u00e3o de E/S SQL." },
		{ Message.SQL_DISCONNECT_ERROR, "Ocorreu um erro ao se desconectar do banco de dados {0}. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "N\u00e3o \u00e9 poss\u00edvel definir a conex\u00e3o com o banco de dados {0}. A conex\u00e3o n\u00e3o existe." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "Ocorreu um erro SQL na fun\u00e7\u00e3o SQLLib.{0}: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "Ocorreu um erro n\u00e3o SQL na fun\u00e7\u00e3o SQLLib.{0}: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "Foi recebido Null a partir do banco de dados, mas a vari\u00e1vel de host {0} n\u00e3o \u00e9 anul\u00e1vel." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "Nenhuma entrada recebida para o campo necess\u00e1rio - digite novamente." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "Erro no tipo de dados na entrada - digite novamente." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "N\u00famero de d\u00edgitos significativos permitido excedido - digite novamente." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "A entrada n\u00e3o est\u00e1 dentro do intervalo definido de {0} a {1} - digite novamente." },
		{ Message.EDIT_VALID_VALUES_ERR, "A entrada n\u00e3o est\u00e1 dentro da lista definida de valores v\u00e1lidos - digite novamente." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "O formato especificado de data e hora de {0} n\u00e3o \u00e9 v\u00e1lido." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "Erro de comprimento m\u00ednimo de entrada - digite novamente." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "Erro de comprimento m\u00e1ximo de entrada - digite novamente." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "Erro de validade de edi\u00e7\u00e3o na tabela - digite novamente." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "Erro de verifica\u00e7\u00e3o de m\u00f3dulo na entrada - digite novamente." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "A entrada n\u00e3o \u00e9 v\u00e1lida para o formato definido de data e hora {0}." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "Entrada n\u00e3o v\u00e1lida para campo booleano." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "O valor digitado \u00e9 inv\u00e1lido pois n\u00e3o corresponde ao padr\u00e3o que est\u00e1 definido." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "A tabela de edi\u00e7\u00e3o {0} n\u00e3o est\u00e1 definida para {1}." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "Dados hexadecimais n\u00e3o s\u00e3o v\u00e1lidos." },
		{ Message.EDIT_VALIDATION_ERR, "Ocorreu um erro de valida\u00e7\u00e3o de p\u00e1gina.  Erro: {0}." },
		{ Message.EDIT_INPUT_ERR, "Erro ao analisar o valor de entrada."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "Erro ao formatar o valor para exibi\u00e7\u00e3o: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "Os dados de entrada com caracteres SO/SI s\u00e3o muito longos para o comprimento do item definido."},
		
		{ Message.ACTION_REQUEST_ERROR, "A fun\u00e7\u00e3o J2EELib RequestAttr falhou com a chave, {0}. Erro: {1}" },
		{ Message.ACTION_SESSION_ERROR, "A fun\u00e7\u00e3o J2EELib SessionAttr falhou com a chave, {0}. Erro: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "A fun\u00e7\u00e3o J2EELib ApplicationAttr falhou com a chave, {0}. Erro: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib s\u00f3 pode ser utilizada no ambiente J2EE." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "A fun\u00e7\u00e3o PortalLib PortletSessionAttr falhou com a chave {0}. Erro: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode falhou. Erro: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState falhou. Erro: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "Tentativa ilegal de alterar o modo do Portlet durante o pedido de renderiza\u00e7\u00e3o" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "Tentativa ilegal de alterar o estado da janela do Portlet durante o pedido de renderiza\u00e7\u00e3o" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "Falha ao obter PortletSession" }, 
		{ Message.PORTALLIB_INVALIDKEY, "Uma chave inv\u00e1lida foi informada para a fun\u00e7\u00e3o {0}" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "Falha ao obter PortletRequest" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "A fun\u00e7\u00e3o PortalLib resetPreferenceValue falhou com a chave {0}. Erro: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "A fun\u00e7\u00e3o PortalLib savePreferences falhou. Erro: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib falhou ao configurar a prefer\u00eancia para a chave {0}. Erro: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib falhou ao obter a prefer\u00eancia para a chave {0}. Erro: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "Falha ao acessar o Servi\u00e7o \u00c1rea Segura da Credencial. Erro: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "Falha ao acessar a Credencial solicitada no slot {0}. Erro: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "Falha ao criar o slot da \u00c1rea Segura da Credencial no espa\u00e7o do usu\u00e1rio. Erro: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "Falha ao excluir o slot da \u00c1rea Segura da Credencial no espa\u00e7o do usu\u00e1rio. Erro: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "Falha ao definir os valores da Credencial. Erro: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} falhou. A chamada de um m\u00e9todo ou o acesso a um campo denominado {1} resultou em um erro n\u00e3o manipulado. A mensagem de erro \u00e9 {2}" },
		{ Message.JAVALIB_NULL_ID, "{0} falhou. {1} n\u00e3o \u00e9 um identificador ou \u00e9 o identificador de um objeto nulo." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} falhou. Um m\u00e9todo, um campo ou uma classe p\u00fablico denominado {1} n\u00e3o existe ou n\u00e3o pode ser carregado, ou o n\u00famero de tipos de par\u00e2metros est\u00e1 incorreto. A mensagem de erro \u00e9 {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} falhou. O tipo de um valor em EGL n\u00e3o corresponde ao tipo esperado em Java para {1}. A mensagem de erro \u00e9 {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "{0} falhou. O destino \u00e9 um m\u00e9todo que retornou nulo, um m\u00e9todo que n\u00e3o retorna um valor ou um campo cujo valor \u00e9 nulo." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} falhou. A classe {1} de um argumento nulo n\u00e3o p\u00f4de ser carregada. A mensagem de erro \u00e9 {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} falhou. N\u00e3o foi poss\u00edvel obter informa\u00e7\u00f5es sobre o m\u00e9todo ou o campo denominado {1}, ou uma tentativa foi feita para definir o valor de um campo final declarado. A mensagem de erro \u00e9 {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} falhou. {1} \u00e9 uma interface ou classe abstrata, de modo que o construtor n\u00e3o pode ser chamado." },
		{ Message.JAVALIB_NOT_STATIC, "{0} falhou. O m\u00e9todo ou o campo {1} n\u00e3o \u00e9 est\u00e1tico. Um identificador dever\u00e1 ser utilizado em vez de um nome de classe." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "O campo de a\u00e7\u00e3o {0} n\u00e3o existe." },
		{ Message.CUI_E_ARRAY_FULL, "N\u00e3o \u00e9 poss\u00edvel inserir outra linha, porque a matriz de entrada est\u00e1 cheia." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "A matriz {0} n\u00e3o pode ser localizada." },
		{ Message.CUI_E_ASSIGN_RESULT, "Falha na designa\u00e7\u00e3o da vari\u00e1vel de resultado do prompt." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "O tamanho {0} para o campo Matriz da Tela n\u00e3o est\u00e1 correto."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "Os par\u00e2metros DrawBox est\u00e3o fora do intervalo." },
		{ Message.CUI_E_BAD_COORDINATES, "As coordenadas de exibi\u00e7\u00e3o est\u00e3o fora dos limites da janela." },
		{ Message.CUI_E_BAD_KEYNAME, "Nome de chave mal-formado ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "Voc\u00ea n\u00e3o pode utilizar esse recurso de edi\u00e7\u00e3o porque existe uma imagem." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "Imposs\u00edvel localizar a janela ''{0}''." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "Os valores da nova posi\u00e7\u00e3o da janela[{0},{1}]/dimens\u00e3o[{2},{3}] n\u00e3o s\u00e3o v\u00e1lidos." },
		{ Message.CUI_E_CMDSTACK_SYNC, "A pilha de comando est\u00e1 fora de sincronia." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "A biblioteca UI do Console n\u00e3o est\u00e1 inicializada." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "Tipo de campo ilegal para constru\u00e7\u00e3o." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "ConstructQuery n\u00e3o pode ser chamado com uma lista de vari\u00e1vel." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "N\u00e3o \u00e9 poss\u00edvel desativar um item de menu invis\u00edvel." },
		{ Message.CUI_E_EDIT_FAILED, "A a\u00e7\u00e3o de edi\u00e7\u00e3o falhou." },
		{ Message.CUI_E_EXEC_HOTKEY, "Ocorreu um erro durante a execu\u00e7\u00e3o da a\u00e7\u00e3o da tecla de acesso r\u00e1pido." },
		{ Message.CUI_E_EXIT_NO_CMD, "N\u00e3o h\u00e1 comando ativo do qual sair." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "N\u00e3o h\u00e1 comando ativo para continuar." },
		{ Message.CUI_E_FATALERROR, "Erro fatal: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "O campo {0} n\u00e3o existe." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "O campo de matriz de tela {0} n\u00e3o \u00e9 uma matriz." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "O campo {0} n\u00e3o pode ser localizado." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "N\u00e3o \u00e9 poss\u00edvel criar ConsoleField sem uma janela." },
		{ Message.CUI_E_FIELD_COUNT, "Incompatibilidade de contagem no campo da matriz." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "O formul\u00e1rio {0} n\u00e3o existe." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "O formul\u00e1rio {0} n\u00e3o se ajusta \u00e0 janela {1}." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "As listas de campo n\u00e3o correspondem." },
		{ Message.CUI_E_FORM_IN_USE, "O formul\u00e1rio {0} est\u00e1 ocupado." },
		{ Message.CUI_E_FORM_NAME_USED, "J\u00e1 existe um formul\u00e1rio com o nome {0}." },
		{ Message.CUI_E_FORM_NOT_OPEN, "O formul\u00e1rio {0} n\u00e3o est\u00e1 aberto." },
		{ Message.CUI_E_FORM_NO_WINDOW, "O ConsoleForm n\u00e3o pode ser criado sem uma janela." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "N\u00e3o \u00e9 poss\u00edvel utilizar KeyObject.getChar() para chaves virtuais." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "N\u00e3o \u00e9 poss\u00edvel utilizar KeyObject.getCookedChar() para chaves virtuais." },
		{ Message.CUI_E_INTERNAL, "ERRO INTERNO: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "Foi recebido um aviso INTERRUPT." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "N\u00e3o \u00e9 poss\u00edvel ter um item de menu invis\u00edvel sem acelerador." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "ConsoleLabel n\u00e3o pode ser criado sem uma janela." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "O item de menu {0} n\u00e3o se ajusta \u00e0 janela." },
		{ Message.CUI_E_MISSING_ITEM, "O item de menu {0} n\u00e3o existe." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "Conflito de mnem\u00f4nicos de menu (chave={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "N\u00e3o h\u00e1 um formul\u00e1rio ativo." },
		{ Message.CUI_E_NO_EDITOR, "O editor de blob n\u00e3o foi especificado." },
		{ Message.CUI_E_NO_HELP_FILE, "Um arquivo de ajuda n\u00e3o foi especificado." },
		{ Message.CUI_E_NO_HELP_MSG, "Uma mensagem de ajuda n\u00e3o foi especificada." },
		{ Message.CUI_E_NO_NUMPAGES, "O menu n\u00e3o est\u00e1 posicionado." },
		{ Message.CUI_E_NO_SCREENARRAY, "N\u00e3o h\u00e1 matriz de tela ativa." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "N\u00e3o h\u00e1 itens de menu vis\u00edveis." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "O nome da nova janela era nulo." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "Tentativa de abrir uma janela nula." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "Ocorreu uma exce\u00e7\u00e3o no prompt." },
		{ Message.CUI_E_QUIT_RECEIVED, "Um aviso QUIT foi recebido." },
		{ Message.CUI_E_SCROLL_FAILED, "O menu n\u00e3o pode rolar para o item atual." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "Atributo desconhecido ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "H\u00e1 um erro no campo {0}." },
		{ Message.CUI_E_VAR_LIST_SHORT, "N\u00e3o foram fornecidas vari\u00e1veis suficientes." },
		{ Message.CUI_E_WINDOW_NAME_USED, "O nome da janela {0} j\u00e1 est\u00e1 sendo utilizado." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "O tamanho da janela \u00e9 pequeno demais para a tela de ajuda." },
		{ Message.CUI_E_VALID_VALUES, "O valor especificado n\u00e3o \u00e9 v\u00e1lido." },
		{ Message.CUI_W_NO_MORE_FIELDS, "N\u00e3o h\u00e1 mais campos na dire\u00e7\u00e3o que voc\u00ea est\u00e1 indo." },
		{ Message.CUI_W_NO_MORE_ROWS, "N\u00e3o h\u00e1 mais linhas na dire\u00e7\u00e3o que voc\u00ea est\u00e1 indo." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "O conte\u00fado de matriz de tela {0} n\u00e3o \u00e9 v\u00e1lido." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "A matriz de tela {0} n\u00e3o pode conter o campo segmentado {1}."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "A matriz de tela {0} n\u00e3o \u00e9 compat\u00edvel com a matriz de dados." },
		{ Message.CUI_E_FIELD_NAME_DUP, "O nome do campo {0} est\u00e1 sendo utilizado mais de uma vez." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "O comprimento do campo de console {0} n\u00e3o \u00e9 v\u00e1lido." },
		{ Message.CUI_E_LABEL_NOT_FIT, "A etiqueta em [{0}, {1}] n\u00e3o se ajusta no espa\u00e7o dispon\u00edvel." },
		{ Message.CUI_E_FIELD_NOT_FIT, "O segmento do campo {0} em ({1}, {2}) n\u00e3o se ajusta no espa\u00e7o dispon\u00edvel." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"A cadeia do prompt \u00e9 grande demais para a janela ativa."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"Os argumentos da matriz OpenUI n\u00e3o s\u00e3o v\u00e1lidos."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "Os argumentos do campo OpenUI n\u00e3o s\u00e3o v\u00e1lidos."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "Somente uma \u00fanica vari\u00e1vel pode estar no limite de uma instru\u00e7\u00e3o do prompt." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "A liga\u00e7\u00e3o de dados para o campo de console {0} n\u00e3o pode ser determinada." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "Aviso: Caracteres NUL localizados nos dados de clob" },
		{ Message.CUI_I_STR_WINDOWTITLE , "Janela de Console do EGL" },
		{ Message.CUI_E_MISSING_FORMAT , "O campo {0} n\u00e3o possui objeto de formato." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "As duas entradas n\u00e3o eram a mesma -- tente novamente" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "Digite nova mente para verifica\u00e7\u00e3o" },
		{ Message.CUI_I_STR_HELP,"Ajuda"},
		{ Message.CUI_I_STR_RESUME,"Retomar"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"Finaliza esta sess\u00e3o de Ajuda."},
		{ Message.CUI_I_STR_SCROLL , "Rolar" },
		{ Message.CUI_I_STR_LAST_PAGE, "Voc\u00ea alcan\u00e7ou o fim do texto de ajuda. Pressione RETURN para continuar."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "Exibe a pr\u00f3xima p\u00e1gina do texto de Ajuda."},
		{ Message.CUI_I_STR_SELECT , "SELECT"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "Erro ao inserir primeira linha em matriz vazia."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 n\u00e3o implementadas."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "INTERNO: F25-64 n\u00e3o implementado" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "N\u00e3o \u00e9 poss\u00edvel ter m\u00faltiplas inst\u00e2ncias de CursesCanvas" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas n\u00e3o inicializado" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas \u00e9 muito pequeno"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "Exibir campos por nome n\u00e3o implementado."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "Entrada m\u00ednima {0} requerida - digite novamente." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "Entrada m\u00e1xima {0} excedida - digite novamente." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "N\u00e3o \u00e9 poss\u00edvel abrir arquivo de script ''{0}''." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "N\u00e3o \u00e9 poss\u00edvel ler arquivo de script."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "A propriedade automation.scenario ''{0}'' n\u00e3o \u00e9 um diret\u00f3rio."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "Diretiva <click> malformada no script de reprodu\u00e7\u00e3o."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "N\u00e3o \u00e9 poss\u00edvel obter propriedade de automa\u00e7\u00e3o ''{0}''."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "Nome de tecla de p\u00e2nico ''{0}'' inv\u00e1lido"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "Exce\u00e7\u00e3o em <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "N\u00e3o \u00e9 poss\u00edvel abrir arquivo de captura instant\u00e2nea ''{0}''"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "A propriedade configurada para automation.scriptdir ''{0}'' n\u00e3o existe."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "A propriedade configurada para o diret\u00f3rio ''{0}'' de automation.scenario n\u00e3o pode ser criada."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "Nome da tecla de captura instant\u00e2nea ''{0}'' inv\u00e1lido"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "Compara\u00e7\u00e3o OK."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "A utiliza\u00e7\u00e3o de opera\u00e7\u00f5es de E/S de exibi\u00e7\u00e3o n\u00e3o \u00e9 permitida ao executar no modo RCP."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "Uma mensagem com o ID {0} n\u00e3o existe na tabela de mensagens {1}." },
		{ Message.MSG_TBL_LOAD_ERR, "O arquivo da tabela de mensagens {0} n\u00e3o pode ser carregado." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "N\u00e3o h\u00e1 uma tabela de mensagens do usu\u00e1rio definida para o VGUIRecord {0}." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "O campo ''{0}'' na posi\u00e7\u00e3o ({1},{2}) n\u00e3o est\u00e1 dentro do formul\u00e1rio." },
		{ Message.TUI_E_FIELD_OVERLAP, "O campo ''{0}'' se sobrep\u00f5e a ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "Erro interno: N\u00e3o \u00e9 poss\u00edvel determinar o grupo de formul\u00e1rios." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "O formul\u00e1rio ''{0}'' n\u00e3o cabe em nenhuma \u00e1rea flutuante." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "As coordenadas do campo ''{0}'' s\u00e3o inv\u00e1lidas." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "N\u00e3o \u00e9 poss\u00edvel obter associa\u00e7\u00e3o de impress\u00e3o." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "N\u00e3o existe nenhum tamanho de dispositivo de impress\u00e3o adequado." },
		{ Message.TUI_E_NO_DISPLAY, "N\u00e3o existe nenhum dispositivo de exibi\u00e7\u00e3o para os formul\u00e1rios." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "N\u00e3o existe nenhum tamanho de dispositivo compat\u00edvel para os formul\u00e1rios exibidos." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "A classe de formul\u00e1rio de ajuda ''{0}'' n\u00e3o existe." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "Atributo desconhecido ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "O valor especificado no atributo de valores v\u00e1lidos est\u00e1 incorreto e n\u00e3o pode ser analisado." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "N\u00e3o \u00e9 poss\u00edvel criar o formul\u00e1rio de ajuda ''{0}''" },
		{ Message.TUI_E_INTERNAL, "ERRO INTERNO: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "N\u00e3o h\u00e1 impressoras dispon\u00edveis." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "N\u00e3o h\u00e1 impressora padr\u00e3o." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "A impressora ''{0}'' n\u00e3o foi localizada.\nEstas impressoras est\u00e3o dispon\u00edveis:\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "Erro ao carregar a mensagem ''{0}''" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "O conte\u00fado de {0} n\u00e3o pode ser utilizado como um campo." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "A impressora ''{0}'' n\u00e3o foi localizada" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "O programa {0} esperava formul\u00e1rio de texto {1}, mas foi fornecido formul\u00e1rio de texto {2} em uma instru\u00e7\u00e3o show." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "Avan\u00e7ar" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "P\u00e1gina {0} de {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "Ant" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "Imprimir" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "Visualiza\u00e7\u00e3o da Impress\u00e3o - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "Salvar" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "Salvar PrintJob - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "Erro ao imprimir para arquivo: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "Erro ao imprimir para impressora: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "Definindo EZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "Validando o campo ''{0}''" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "Validando textform" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "Validando textform - executando fun\u00e7\u00e3o de validador ''{0}''" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "N\u00e3o \u00e9 poss\u00edvel criar logwriter." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "O par\u00e2metro de log ''{0}'' n\u00e3o pode ser definido ap\u00f3s a inicializa\u00e7\u00e3o." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "Logdir ''{0}'' n\u00e3o existe." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "N\u00e3o \u00e9 poss\u00edvel gravar no logdir ''{0}''." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "N\u00e3o \u00e9 poss\u00edvel criar logfile ''{0}''." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "N\u00e3o \u00e9 poss\u00edvel gravar no logfile ''{0}''." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Problema ao carregar servi\u00e7o para Component/ExternalService {0}." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "Ocorreu um erro ao criar uma conex\u00e3o para a opera\u00e7\u00e3o de servi\u00e7o da Web ''{0}''.  {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "Ocorreu um erro ao obter a opera\u00e7\u00e3o:''{0}'' do arquivo WSDL:''{1}''." },
		{ Message.SOA_E_WS_MALFORMED_URL, "A URL de destino para a opera\u00e7\u00e3o de servi\u00e7o da Web {1} n\u00e3o \u00e9 v\u00e1lida. URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "Ocorreu um erro ao carregar o servi\u00e7o {0}. Erro: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "Ocorreu um erro ao tentar carregar um servi\u00e7o da Web. N\u00e3o foi poss\u00edvel resolver a porta WSDL para o servi\u00e7o externo {0}." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "O componente {0} n\u00e3o tem a propriedade {1}, que \u00e9 necess\u00e1ria para a implementa\u00e7\u00e3o do servi\u00e7o." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "A refer\u00eancia do servi\u00e7o ''{0}'' est\u00e1 faltando ou n\u00e3o tem um valor de destino." },
		{ Message.SOA_E_MISSING_BINDING, "A liga\u00e7\u00e3o de servi\u00e7o:''{0}'' n\u00e3o existe no descritor de implementa\u00e7\u00e3o:''{1}''" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "Ocorreu um erro ao tentar converter o registro ''{0}'' em uma mensagem SOAP.  N\u00e3o foi poss\u00edvel localizar o campo ''{1}'' no registro." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "Ocorreu um erro ao tentar converter ''{0}'' em uma mensagem SOAP."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "Ocorreu um erro ao processar uma mensagem no limite de um servi\u00e7o da Web. O tipo Java \u00e9 incompat\u00edvel com o tipo EGL." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "Ocorreu um erro ao processar uma mensagem fora do limite para um servi\u00e7o da Web. O tipo EGL \u00e9 incompat\u00edvel com o tipo Java" },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "N\u00e3o foi poss\u00edvel inicializar o registro ''{0}''." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "Imposs\u00edvel converter o valor ''{0}'' em um Calendar." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "Imposs\u00edvel converter o valor ''{0}'' em um boolean." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "Imposs\u00edvel converter o valor ''{0}'' em um Byte." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "Imposs\u00edvel converter o valor ''{0}'' em um short." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "Imposs\u00edvel converter o valor ''{0}'' em um URI." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "O tipo EGL n\u00e3o \u00e9 suportado como um par\u00e2metro de servi\u00e7o da Web." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "Ocorreu um erro ao tentar criar uma matriz de registro. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "M\u00e9todo {0} n\u00e3o localizado no servi\u00e7o {1}." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "O servi\u00e7o n\u00e3o \u00e9 um servi\u00e7o da Web." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "Ocorreu um erro ao tentar chamar a fun\u00e7\u00e3o:{0} no WebService:{1}." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "Ocorreu um erro ao tentar chamar a fun\u00e7\u00e3o:{0} no Servi\u00e7o EGL:{1}." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "Ocorreu um erro ao tentar chamar a fun\u00e7\u00e3o:{0} no Servi\u00e7o EGL:{1} utilizando {2}:{3}." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "O servi\u00e7o n\u00e3o \u00e9 um servi\u00e7o tcpip." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "Ocorreu um erro ao tentar chamar a fun\u00e7\u00e3o:{0} no ponto de entrada:{1}." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "Ocorreu um erro ao tentar carregar o arquivo de liga\u00e7\u00e3o de servi\u00e7o {0}. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "Ocorreu um erro ao tentar chamar a fun\u00e7\u00e3o:{0} no Servi\u00e7o CICS:{1}. C\u00f3digo de Erro:{2}, Mensagem:{3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "Ocorreu um erro ao tentar chamar a fun\u00e7\u00e3o:{0} no Servi\u00e7o iSeries:{1}. C\u00f3digo de Erro:{2}, Mensagem:{3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "O servi\u00e7o n\u00e3o \u00e9 um servi\u00e7o CICS." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "Ocorreu um erro no servi\u00e7o remoto {0}, data {1}, hora {2}, no sistema {3}." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "Ocorreu um erro no servi\u00e7o remoto {0}, no sistema {1}." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "A unidade de execu\u00e7\u00e3o foi finalizada por um erro de aplicativo no sistema {0} ao tentar chamar o servi\u00e7o {1}. Mensagem: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "Erro de execu\u00e7\u00e3o AS400Toolbox: {0}, {1} ao chamar o servi\u00e7o {2} no sistema {3}." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "Liga\u00e7\u00e3o com o Cliente de Servi\u00e7o n\u00e3o Suportada. {0} foi gerado para o Websphere, mas est\u00e1 sendo chamado de um ambiente n\u00e3o J2EE. Regenere em um projeto n\u00e3o J2EE." },
		{ Message.SOA_E_USER_ID_NOT_SET, "O ID de usu\u00e1rio e a senha remotos devem ser configurados antes de chamar o WebService:{0} fun\u00e7\u00e3o:{1}." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "Ocorreu uma exce\u00e7\u00e3o ao chamar um servi\u00e7o." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "Ocorreu uma exce\u00e7\u00e3o ao comunicar-se com o servi\u00e7o. URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "Ocorreu uma exce\u00e7\u00e3o durante uma chamada de servi\u00e7o REST. Liga\u00e7\u00e3o:{0}, Opera\u00e7\u00e3o:{0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "Ocorreu uma exce\u00e7\u00e3o durante uma chamada de servi\u00e7o SOAP. Liga\u00e7\u00e3o:{0}, Servi\u00e7o:{1}, Porta:{2}, Local do WSDL:{3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "Ocorreu uma exce\u00e7\u00e3o ao converter a partir de JSON. par\u00e2metro:{0}, json:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "Ocorreu uma exce\u00e7\u00e3o ao converter em JSON. par\u00e2metro:{0}, valor:{1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "Nenhum servi\u00e7o REST-RPC foi localizado. URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "Nenhuma resposta foi recebida do servi\u00e7o. URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "O pedido n\u00e3o p\u00f4de ser convertido em uma chamada de servi\u00e7o. O pedido recebido foi ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "A invoca\u00e7\u00e3o de servi\u00e7o expirou. Exce\u00e7\u00e3o: Erro de expira\u00e7\u00e3o de leitura de conex\u00e3o. url:{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "O servi\u00e7o n\u00e3o \u00e9 um servi\u00e7o REST." },
		{ Message.SOA_E_REST_SERVICE, "A chamada para a invoca\u00e7\u00e3o de servi\u00e7o REST falhou. Liga\u00e7\u00e3o:{0}, Opera\u00e7\u00e3o:{1}, m\u00e9todo de HTTP:{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "Ocorreu uma exce\u00e7\u00e3o ao converter dados para par\u00e2metros EGL. Liga\u00e7\u00e3o:{0}, dados para converter{1}, exce\u00e7\u00e3o:{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "Uma invoca\u00e7\u00e3o de servi\u00e7o REST foi feita em uma refer\u00eancia de servi\u00e7o n\u00e3o REST. Refer\u00eancia de Servi\u00e7o: {0}, Opera\u00e7\u00e3o {1}, M\u00e9todo de HTTP: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "Ocorreu uma exce\u00e7\u00e3o ao converter a partir de XML. O elemento necess\u00e1rio {0} est\u00e1 ausente." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "Ocorreu uma exce\u00e7\u00e3o ao converter a partir de XML. par\u00e2metro:{0}, xml:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "Ocorreu uma exce\u00e7\u00e3o ao converter para XML. par\u00e2metro:{0}, valor:{1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "Ocorreu uma exce\u00e7\u00e3o de an\u00e1lise XML ao converter {0} a partir de XML." },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "Ocorreu uma exce\u00e7\u00e3o de convers\u00e3o XML ao converter {0} para XML." },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "A URL ''{0}'' usada para invocar o servi\u00e7o \u00e9 inv\u00e1lida. Ela n\u00e3o cont\u00e9m o protocolohttp:// ." },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "A URL ''{0}'' usada para invocar o servi\u00e7o \u00e9 inv\u00e1lida. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "A URL usada para invocar o servi\u00e7o est\u00e1 em branco. Especifique uma URL que aponta para o servi\u00e7o." },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "N\u00e3o foi poss\u00edvel preencher o relat\u00f3rio utilizando conex\u00e3o {0}"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "N\u00e3o foi poss\u00edvel preencher relat\u00f3rio utilizando instru\u00e7\u00e3o sql {0}"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "N\u00e3o foi poss\u00edvel preencher relat\u00f3rio utilizando matriz din\u00e2mica {0}"},
		{ Message.REPORT_E_FILL_ERROR , "N\u00e3o foi poss\u00edvel preencher relat\u00f3rio {0}"},
		{ Message.REPORT_E_EXPORT_ERROR, "N\u00e3o foi poss\u00edvel exportar relat\u00f3rio {0}" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "N\u00e3o foi poss\u00edvel converter entre tipos EGL {0} e Java {1}" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "N\u00e3o foi poss\u00edvel converter entre tipos Java {0} e EGL {1}" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "N\u00e3o foi poss\u00edvel incluir par\u00e2metro de relat\u00f3rio" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "N\u00e3o foi poss\u00edvel reconfigurar lista de par\u00e2metros de relat\u00f3rio" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "Nome de campo incorreto {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "Nome de sub-relat\u00f3rio incorreto {0}" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "Tipo n\u00e3o suportado sendo utilizado no relat\u00f3rio" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "N\u00e3o \u00e9 poss\u00edvel transmitir tipos complexos para essa fun\u00e7\u00e3o" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "O nome do arquivo de design deve ser definido antes de chamar a fun\u00e7\u00e3o getParameterDefaultValue()." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "N\u00e3o foi poss\u00edvel obter o valor padr\u00e3o para o par\u00e2metro {0}. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "Um par\u00e2metro de relat\u00f3rio denominado {0} n\u00e3o existe." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "O nome do arquivo de design deve ser definido antes de chamar a fun\u00e7\u00e3o createReportFromDesign() ou createDocument()." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "O nome do arquivo de documento deve ser definido antes de chamar a fun\u00e7\u00e3o createReportFromDocument()." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "N\u00e3o foi poss\u00edvel criar o arquivo de documento do relat\u00f3rio. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "N\u00e3o foi poss\u00edvel criar o relat\u00f3rio a partir do arquivo de design. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "N\u00e3o foi poss\u00edvel criar o relat\u00f3rio a partir do arquivo de documento. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "O objeto de manipulador especificado para um BirtReport deve ser do tipo BirtHandler." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "O elemento {0} n\u00e3o existe no design do relat\u00f3rio ou n\u00e3o \u00e9 do tipo especificado." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "O n\u00famero da linha {0} {1} n\u00e3o existe na tabela {2}." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "O n\u00famero da linha {0} n\u00e3o existe no elemento de grade {1}." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "O grupo {0} n\u00e3o existe na tabela {1}." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "O n\u00famero da linha {0} {1} n\u00e3o existe no grupo {2} na tabela {3}." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "O n\u00famero da coluna {0} n\u00e3o existe em uma linha {1} na tabela {2}." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "O n\u00famero da coluna {0} n\u00e3o existe na grade {1}." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "O n\u00famero da coluna {0} n\u00e3o existe na linha {1} no grupo {2} na tabela {3}." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "A propriedade ''RowType'' deve ser especificada para uma fun\u00e7\u00e3o de manipulador de eventos para linha(s) ou c\u00e9lula(s) na tabela {0}." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "N\u00e3o foi poss\u00edvel converter o tipo Java {0} para um tipo EGL." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "N\u00e3o foi poss\u00edvel converter o tipo EGL {0} para um tipo Java." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "O conjunto de dados {0} n\u00e3o existe no design de relat\u00f3rio." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "O conjunto de dados {0} \u00e9 de script, mas nenhum dos seguintes eventTypes foi manipulado: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "A origem de dados {0} n\u00e3o existe no design de relat\u00f3rio." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "A origem de dados {0} \u00e9 de script, mas nenhum dos seguintes eventTypes foi manipulado: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "O n\u00famero da coluna {0} n\u00e3o existe no conjunto de dados {1}." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "Exce\u00e7\u00e3o ocorrida ao obter a coluna {0} do conjunto de dados {1}. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "Exce\u00e7\u00e3o ocorrida ao definir a coluna {0} do conjunto de dados de script {1}. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "Exce\u00e7\u00e3o ocorrida ao obter a liga\u00e7\u00e3o de colunas {0}. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "Propriedade vgj.defaultI4GLNativeLibrary n\u00e3o especificada" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "Biblioteca {0} com falha no carregamento {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "Os par\u00e2metros retornados n\u00e3o correspondem \u00e0 fun\u00e7\u00e3o" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "N\u00e3o foi poss\u00edvel alocar mem\u00f3ria"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "N\u00e3o foi poss\u00edvel converter entre tipos"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "Precis\u00e3o de data/hora ou Intervalo inv\u00e1lida"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "A vari\u00e1vel de host de caracteres \u00e9 pequena demais para os dados"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "A fun\u00e7\u00e3o n\u00e3o pode ser localizada na tabela de s\u00edmbolos"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "Um tipo de dados TEXT ou BYTE deve ser fornecido dentro deste contexto"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "O valor na pilha n\u00e3o p\u00f4de ser convertido para um tipo de valor"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "O valor na pilha n\u00e3o p\u00f4de ser convertido para ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "N\u00e3o foi poss\u00edvel retirar um valor do tipo {0} da pilha"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "N\u00e3o foi poss\u00edvel inserir um valor do tipo {1} na pilha"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "Nada a ativar/retirar"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "N\u00e3o foi poss\u00edvel retirar o Localizador da pilha"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "A pilha est\u00e1 vazia"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "N\u00e3o foi poss\u00edvel copiar o localizador"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "Uma refer\u00eancia nula foi enviada na pilha"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "N\u00e3o foi poss\u00edvel ativar Any para a pilha"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "N\u00e3o foi poss\u00edvel atribuir o elemento pilha para o tipo Any"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "Incompatibilidade do tipo de retorno"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "Incompatibilidade do tipo de par\u00e2metro"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "N\u00e3o foi poss\u00edvel localizar o arquivo EGL de origem {0}.  O c\u00f3digo gerado ser\u00e1 executado no lugar." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "N\u00e3o foi poss\u00edvel localizar o arquivo EGL de origem para a transa\u00e7\u00e3o da Web chamada{0}." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "O seguinte problema de formata\u00e7\u00e3o ocorreu no campo \"{0}\" ao exibir o formul\u00e1rio \"{1}\":" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\nO formato interno esperado do campo \u00e9 \"{1}\". Verifique as propriedades de formato de data nas propriedades do EGL Java Runtime dentro do descritor de Build de depura\u00e7\u00e3o ou as propriedades JDBC que afetam formatos de data." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\nO formato de exibi\u00e7\u00e3o do campo \u00e9 \"{1}\". Verifique a propriedade \"{2}\" no campo de formul\u00e1rio." },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "N\u00e3o foi poss\u00edvel executar o programa {0} como uma transa\u00e7\u00e3o da Web." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "A transa\u00e7\u00e3o da Web recebeu um registro UI de entrada {0}, mas foi definida com o registro UI de entrada {1}." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "Entrada n\u00e3o v\u00e1lida para campo booleano." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "Ocorreu um tempo limite no programa {0} devido \u00e0 inatividade." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "O registro da Interface com o Usu\u00e1rio {0} cont\u00e9m muitos dados a serem enviados para o servlet do gateway." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "O programa n\u00e3o p\u00f4de verificar os dados do servlet do gateway.  O identificador de dados \u00e9 {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "O wrapper da matriz {0} n\u00e3o pode ser expandido al\u00e9m do seu tamanho m\u00e1ximo. O erro ocorreu no m\u00e9todo {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} \u00e9 um \u00edndice inv\u00e1lido para o wrapper da matriz {1}. Tamanho m\u00e1ximo: {2}. Tamanho atual: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} n\u00e3o \u00e9 um tamanho m\u00e1ximo v\u00e1lido para o wrapper da matriz {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} \u00e9 um tipo de objeto inv\u00e1lido a ser inclu\u00eddo em um wrapper de matriz do tipo {1}." },
		
		{ Message.IMS_HOST_ABORT, "O pacote de interrup\u00e7\u00e3o foi recebido do host remoto."},
		{ Message.IMS_HOST_TCPIP_ERROR, "Erro TCPIP ocorrido no host remoto. Se\u00e7\u00e3o:{0} TCPIP-Operation:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "Ocorreu um erro no host durante a chamada:{0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "O pacote de resposta errado foi recebido do host. Esperado:{0} Recebido:{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "Erro de E/S ao executar o procedimento armazenado. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "Erro de SQL ao executar o procedimento armazenado. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "Erro no host remoto ao executar:{0} RETCODE:{1} ID da tarefa DLI Proxy:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "Erro DLI no host remoto. Fun\u00e7\u00e3o DLI:{0} AIB-return:0x{1} AIB-reason:0x{2} statusCode:{3} ID da tarefa DLI Proxy:{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "Erro DLI no host remoto. Fun\u00e7\u00e3o DLI:{0} AIB-return:0x{1} AIB-reason:0x{2} DLIVar.statusCode:{3} DLIVar.DbName:{4} DLIVar.SegmentName:{5} DLIVar.SegmentLevel:{6} ID da tarefa DLI Proxy:{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "AIB-return code indica um c\u00f3digo de status PCB, mas nenhum PCB retornado. AIB-function:{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "Exce\u00e7\u00e3o ocorrida em CALL EZEDBTCP no host remoto. Se\u00e7\u00e3o:{0} TCPIP-Operation:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "ABEND ocorrido no host remoto. Rotina:{0} Mensagem:{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "Exce\u00e7\u00e3o ocorrida no host remoto. CHAMADA:{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "O depurador n\u00e3o suporta a fun\u00e7\u00e3o DLI. Fun\u00e7\u00e3o:{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "Uma chamada DL/I est\u00e1 sendo emitida, mas o descritor de constru\u00e7\u00e3o n\u00e3o est\u00e1 configurado para acesso de DL/I."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "Exce\u00e7\u00e3o remota: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "Ocorreu um erro ao tentar alocar um PSB. O IMSID \u00e9 configurado indicando que h\u00e1 acesso de DL/I, mas n\u00e3o h\u00e1 PSB especificado"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "O cliente RBD e as vers\u00f5es de host n\u00e3o s\u00e3o compat\u00edveis. Vers\u00e3o do cliente RBD:{0} Vers\u00e3o do Host:{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "Ocorreu um erro ao recuperar os dados retornados de uma chamada a um programa de host. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "Ocorreu um erro ao recuperar o nome do PCB. \u00cdndice do PCB:{0}, n\u00famero dos PCBs:{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
