/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_ru extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 {0}." },
		{ Message.FUNCTION_ERROR_INFO, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 {0} \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 {1}." },
		{ Message.FILE_ERROR_INFO, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 {0} \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 {1}, \u0441\u0442\u0440\u043e\u043a\u0430 {2}." },
		{ Message.PROPERTIES_FILE_MISSING, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0441\u0432\u043e\u0439\u0441\u0442\u0432 {0}." },
		{ Message.LOAD_LIBRARY_FAILED, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0443 {0}. \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0442\u0438\u043f\u0430 {0}. \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 InitialContext \u0438\u043b\u0438 \u043f\u043e\u0438\u0441\u043a\u0435 \u0441\u0440\u0435\u0434\u044b java:comp/env. \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.LISTENER_ERROR, "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f: {0}. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 {0}." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u043d\u0435\u0448\u043d\u044f\u044f \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c. \u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "\u041e\u043f\u0435\u0440\u0430\u043d\u0434\u044b {0} \u0438 {1} \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u0440\u0430\u0432\u043d\u0438\u0442\u044c." },
		{ Message.ASSIGNMENT_OVERFLOW, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0432 \u0445\u043e\u0434\u0435 \u043f\u0440\u0438\u0441\u0432\u043e\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 {0} \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0443 {1}." },
		{ Message.EXPRESSION_OVERFLOW, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0432 \u0445\u043e\u0434\u0435 \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 {0} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u043d\u0434\u043e\u0432 {1} \u0438 {2}." },
		{ Message.UNSUPPORTED_OPERAND, "\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 {0} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u043d\u0434\u0430 {1} \u0442\u0438\u043f\u0430 {2}." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u043d\u0434\u0430 {0} \u0442\u0438\u043f\u0430 {1}." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 \u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0438 \u0441 \u043e\u043f\u0435\u0440\u0430\u043d\u0434\u043e\u043c {0} \u0442\u0438\u043f\u0430 {1} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 SET EMPTY \u0441 \u043e\u043f\u0435\u0440\u0430\u043d\u0434\u043e\u043c {0} \u0442\u0438\u043f\u0430 {1} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f." },
		{ Message.INVALID_REGULAR_EXPRESSION, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "\u041f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 CICSSSL \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0437\u0430\u0434\u0430\u043d\u043e \u043a\u0430\u043a ctgKeyStore, \u0442\u0430\u043a \u0438 ctgKeyStorePassword." },
		{ Message.INVALID_CTGPORT, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 ctgport {0}." },
		{ Message.CTG_CONNECT_FAILED, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043a CTG. \u0420\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 CTG: {0}. \u041f\u043e\u0440\u0442 CTG: {1}. \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043e\u0442 CTG. \u0420\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 CTG: {0}. \u041f\u043e\u0440\u0442 CTG: {1}. \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: {2}" },
		{ Message.NO_CICS, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0}, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0435\u0439 ECI CICS. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: -3 (ECI_ERR_NO_CICS). \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0438\u0441\u0442\u0435\u043c\u044b CICS: {1}." },
		{ Message.CICS_DIED, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0}, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0435\u0439 ECI CICS. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: -4 (ECI_ERR_CICS_DIED). \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0438\u0441\u0442\u0435\u043c\u044b CICS: {1}." },
		{ Message.CICS_TIMEOUT, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0}, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0435\u0439 ECI CICS. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: -6 (ECI_ERR_RESPONSE_TIMEOUT). \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0438\u0441\u0442\u0435\u043c\u044b CICS: {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0}, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0435\u0439 ECI CICS. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: -7 (ECI_ERR_TRANSACTION_ABEND). \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0438\u0441\u0442\u0435\u043c\u044b CICS: {1}. \u041a\u043e\u0434 \u0430\u0432\u0430\u0440\u0438\u0439\u043d\u043e\u0433\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f: {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0}, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0435\u0439 ECI CICS. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: -22 (ECI_ERR_UNKNOWN_SERVER). \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0438\u0441\u0442\u0435\u043c\u044b CICS: {1}." },
		{ Message.CICS_SECURITY_ERROR, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0}, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0435\u0439 ECI CICS. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: -27 (ECI_ERR_SECURITY_ERROR). \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0438\u0441\u0442\u0435\u043c\u044b CICS: {1}." },
		{ Message.CICS_MAX_SYSTEMS, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0}, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0435\u0439 ECI CICS. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: -28 (ECI_ERR_MAX_SYSTEMS). \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0438\u0441\u0442\u0435\u043c\u044b CICS: {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0} \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {1} \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {2}. \u0412 \u0445\u043e\u0434\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 ECI CICS \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u043a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 {3} \u0438 \u043a\u043e\u0434 \u0430\u0432\u0430\u0440\u0438\u0439\u043d\u043e\u0433\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f {4}." },
		{ Message.CICS_COMMIT_FAILED, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 CICS ECI \u0434\u043b\u044f \u0444\u0438\u043a\u0441\u0430\u0446\u0438\u0438 \u0435\u0434\u0438\u043d\u0438\u0446\u044b \u0440\u0430\u0431\u043e\u0442\u044b. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0438\u0437 CICS - {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 CICS ECI \u0434\u043b\u044f \u043e\u0442\u043a\u0430\u0442\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u044b \u0440\u0430\u0431\u043e\u0442\u044b. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0438\u0437 CICS - {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 ECI \u0441\u0438\u0441\u0442\u0435\u043c\u0435 CICS {0}. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430. \u0427\u0438\u0441\u043b\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u043e\u0442\u043e\u043a\u0430: {0}, \u0447\u0438\u0441\u043b\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u0444\u0443\u043d\u043a\u0446\u0438\u0438: {1}." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 {0}." },
		{ Message.WRONG_NUMBER_OF_PARMS, "\u0412\u044b\u0437\u0432\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 {0} \u043e\u0436\u0438\u0434\u0430\u0435\u0442 {1} \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432; \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {2} \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432." },
		{ Message.FUNCTION_NOT_FOUND, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0430\u0434\u0440\u0435\u0441\u0430 \u0442\u043e\u0447\u043a\u0438 \u0432\u0445\u043e\u0434\u0430 {0} \u0432 \u043e\u0431\u0449\u0435\u0439 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0435 {1}. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 - {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043e\u0431\u0449\u0435\u0439 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 {0}. \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 - {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u0432\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b; \u043a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: {0}." },
		{ Message.REMOTE_PROGRAM_ERROR, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 {0} \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b {3}. \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 {1} \u0438\u0437 {2}. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 {0} \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b {1}. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0445\u043e\u0441\u0442\u0430 TCP/IP {0}." },
		{ Message.SERVERID_IS_INVALID_PORT, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0440\u0442\u0430 ServerID {0}." },
		{ Message.TCPIP_SERVER_ERROR, "\u041a\u043b\u0438\u0435\u043d\u0442 \u043f\u043e\u043b\u0443\u0447\u0438\u043b \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u0442\u043e\u043c \u0447\u0442\u043e \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e \u0432\u044b\u0437\u0432\u0430\u043d\u043d\u0443\u044e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443. \u041a\u043e\u0434 \u043f\u0440\u0438\u0447\u0438\u043d\u044b: {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 remoteComType \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u0441\u0432\u044f\u0437\u0438 {0}." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "\u0417\u0430\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u043c\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0444\u0430\u0439\u043b\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u0441\u0432\u044f\u0437\u0438 {1}." },
		{ Message.AS400_UNKNOWN_HOST, "\u0425\u043e\u0441\u0442 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "\u041f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {2} \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {3} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 AS400Toolbox {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.AS400_NO_AUTHORITY, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {1} \u043a \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u0444\u0438\u043a\u0441\u0430\u0446\u0438\u0438 \u0432 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u043e\u0442\u043a\u0430\u0442\u0430 \u0432 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 EGL OS/400 Host Services. \u0412 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u044b\u0435 \u0444\u0430\u0439\u043b\u044b." },
		{ Message.AS400_APPLICATION_ERROR, "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {0} \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {1}. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0441\u0441\u044b\u043b\u043e\u0447\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c {0} \u043f\u0443\u0441\u0442\u0430." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430. \u041e\u0448\u0438\u0431\u043a\u0430: {0}." },
		{ Message.DATA_FORMAT_ERROR, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 {0}." },
		{ Message.CONVERSION_ERROR, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 {0} \u0442\u0438\u043f\u0430 {1} \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0432 \u0442\u0438\u043f {2}." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u0434\u0430\u0442\u044b {0}." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 {0}." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 {0}." },
		{ Message.NULL_REFERENCE, "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0430 \u043f\u0443\u0441\u0442\u0430\u044f \u0441\u0441\u044b\u043b\u043a\u0430." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u043e\u0441\u0442\u0443\u043f \u043a {0} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f." },
		{ Message.DYNAMIC_ACCESS_FAILED, "\u0412 {1} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u043b\u0435 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c {0}." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d \u0447\u0438\u0441\u043b\u043e\u0432\u043e\u0433\u043e \u0444\u043e\u0440\u043c\u0430\u0442\u0430 {0}." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0445\u043e\u0434\u0435 \u043f\u0440\u0438\u0441\u0432\u043e\u0435\u043d\u0438\u044f {1} \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0435 SET {0} EMPTY. \u041e\u0448\u0438\u0431\u043a\u0430: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 {0} \u0432 \u0445\u043e\u0434\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 \u0441 \u0441\u0438\u0433\u043d\u0430\u0442\u0443\u0440\u043e\u0439 {1}." },
		{ Message.RUN_COMMAND_FAILED, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b {0}.  \u041e\u0448\u0438\u0431\u043a\u0430: {1}." },
		{ Message.MDY_ERROR, "\u0424\u0443\u043d\u043a\u0446\u0438\u044f DateTimeLib.mdy \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c {0}, {1} \u0438 {2} \u0432 \u043c\u0435\u0441\u044f\u0446, \u0434\u0435\u043d\u044c \u0438 \u0433\u043e\u0434." },
		{ Message.NON_NUMERIC_STRING, "\u0412 {0} \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u0430 \u043d\u0435\u0447\u0438\u0441\u043b\u043e\u0432\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430 {1}. \u041a\u0430\u0436\u0434\u044b\u0439 \u0441\u0438\u043c\u0432\u043e\u043b \u0432 \u0442\u043e\u0439 \u0447\u0430\u0441\u0442\u0438 \u0441\u0442\u0440\u043e\u043a\u0438, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u043c \u0434\u043b\u0438\u043d\u044b, \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c." },
		{ Message.SYSTEM_FUNCTION_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0}. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 - {1}." },
		{ Message.INT_AS_CHAR_ERROR, "\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442 StrLib.intAsChar \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c \u043e\u0442 0 \u0434\u043e 255." },
		{ Message.INVALID_LOB_LENGTH, "\u0414\u043b\u0438\u043d\u0430 {0} \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430 \u0434\u043b\u044f {1} \u0441 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c {2}." },
		{ Message.INVALID_LOB_POSITION, "{0} - \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u044f \u0434\u043b\u044f {1}. \u0420\u0430\u0437\u043c\u0435\u0440 - {2}." },
		{ Message.LOB_ERROR, "\u041f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 Blob \u0438\u043b\u0438 Clob \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.  \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 - {0}" },
		{ Message.START_TRANSACTION_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c VGLib.startTransaction \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 {0}. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f: {1}." },
		{ Message.INT_AS_UNICODE_ERROR, "\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u043c StrLib.intAsUnicode \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e \u043e\u0442 0 \u0434\u043e 65535." },
		{ Message.INVALID_ARRAY_SIZE, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 {1}: {0}. \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440: {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "\u0418\u043d\u0434\u0435\u043a\u0441 {0} \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 {1}. \u0420\u0430\u0437\u043c\u0435\u0440 \u043c\u0430\u0441\u0441\u0438\u0432\u0430: {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u044b {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u0434\u043b\u044f \u043c\u0430\u0441\u0441\u0438\u0432\u0430 {0}." },
		{ Message.INDEX_OUT_OF_BOUNDS, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 {0} \u043b\u0435\u0436\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0433\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0430\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f {0}." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b csouidpwd.properties. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "\u0411\u0443\u0444\u0435\u0440 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043e\u0431\u044a\u0435\u043c\u0430 \u0434\u0430\u043d\u043d\u044b\u0445. \u0421\u0443\u043c\u043c\u0430\u0440\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0440\u0430\u0432\u0435\u043d {0} \u0438 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440, \u0440\u0430\u0432\u043d\u044b\u0439 {1} \u0431\u0430\u0439\u0442\u0430\u043c." },
		{ Message.INVALID_PARMFORM, "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0441\u0432\u044f\u0437\u0438 parmForm \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0432 COMMPTR \u0434\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0}, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u0435\u0441\u0442\u044c \u043f\u043e \u043a\u0440\u0430\u0439\u043d\u0435\u0439 \u043c\u0435\u0440\u0435 \u043e\u0434\u0438\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440, \u044f\u0432\u043b\u044f\u044e\u0449\u0438\u0439\u0441\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u043c \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c." },
		{ Message.PARM_PASSING_ERROR, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u043c\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.CALL_ERROR, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "\u0422\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 {0} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0441\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0445 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c System i." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f {0} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0441\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0445 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c System i." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c ConnectionFactory. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f - {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044c Interaction \u0438\u043b\u0438 Connection. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f: {0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f - {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c LocalTransaction \u0434\u043b\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u044b \u0440\u0430\u0431\u043e\u0442\u044b \u043a\u043b\u0438\u0435\u043d\u0442\u0430. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f - {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0442\u0430\u0439\u043c-\u0430\u0443\u0442\u0430 \u0434\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 CICSJ2C. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f - {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "\u041f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0441\u0432\u044f\u0437\u0438 \u0441 CICS \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f - {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "\u041f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e CICS \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430." },
		{ Message.EXCEPTION_CALLING_IMS, "\u041f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0441\u0432\u044f\u0437\u0438 \u0441 IMS \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f - {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "\u041f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0441\u0432\u044f\u0437\u0438 \u0441 IMS \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430." },
		{ Message.MATH_DOMAIN_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0} , \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 8 (\u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u043c\u0435\u043d\u0430). \u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u0438." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0} , \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 8 (\u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u043c\u0435\u043d\u0430). \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u044c\u0441\u044f \u043c\u0435\u0436\u0434\u0443 -1 \u0438 1." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0} , \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 8 (\u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u043c\u0435\u043d\u0430). \u0412\u0442\u043e\u0440\u043e\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0} , \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 8 (\u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u043c\u0435\u043d\u0430). \u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "\u0412 MathLib.pow \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u0435\u043b \u0441\u0431\u043e\u0439 \u0441 \u043a\u043e\u0434\u043e\u043c \u043e\u0448\u0438\u0431\u043a\u0438 8 (\u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u043c\u0435\u043d\u0430). \u0415\u0441\u043b\u0438 \u043f\u0435\u0440\u0432\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u044e, \u0442\u043e \u0432\u0442\u043e\u0440\u043e\u0439 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "\u0412 MathLib.pow \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u0435\u043b \u0441\u0431\u043e\u0439 \u0441 \u043a\u043e\u0434\u043e\u043c \u043e\u0448\u0438\u0431\u043a\u0438 8 (\u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u043c\u0435\u043d\u0430). \u0415\u0441\u043b\u0438 \u043f\u0435\u0440\u0432\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u043c\u0435\u043d\u044c\u0448\u0435 \u043d\u0443\u043b\u044f, \u0442\u043e \u0432\u0442\u043e\u0440\u043e\u0439 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0446\u0435\u043b\u044b\u043c." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "\u0412 MathLib.sqrt \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u0435\u043b \u0441\u0431\u043e\u0439 \u0441 \u043a\u043e\u0434\u043e\u043c \u043e\u0448\u0438\u0431\u043a\u0438 8 (\u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u043c\u0435\u043d\u0430). \u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u044e." },
		{ Message.MATH_RANGE_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0}, \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 12 (\u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430)." },		
		{ Message.STRING_INDEX_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0}, \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 8. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u0436\u0434\u0443 \u0435\u0434\u0438\u043d\u0438\u0446\u0435\u0439 \u0438 \u0434\u043b\u0438\u043d\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0438." },
		{ Message.STRING_LENGTH_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0}, \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 12. \u0414\u043b\u0438\u043d\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f." },
		{ Message.STRING_NULT_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c StrLib.setNullTerminator, \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 16. \u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0431\u0430\u0439\u0442 \u0446\u0435\u043b\u0435\u0432\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u044b\u043c \u0441\u0438\u043c\u0432\u043e\u043b\u0443 null." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0}, \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 20. \u0418\u043d\u0434\u0435\u043a\u0441 \u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0438 STRING, DBCHAR \u0438\u043b\u0438 UNICODE \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435\u0447\u0435\u0442\u043d\u044b\u043c, \u0447\u0442\u043e\u0431\u044b \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u043f\u0435\u0440\u0432\u044b\u0439 \u0431\u0430\u0439\u0442 \u0441\u0438\u043c\u0432\u043e\u043b\u0430." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c {0}, \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 24. \u0414\u043b\u0438\u043d\u0430 \u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0438 STRING, DBCHAR \u0438\u043b\u0438 UNICODE \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0447\u0435\u0442\u043d\u043e\u0439, \u0447\u0442\u043e\u0431\u044b \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u0446\u0435\u043b\u043e\u0435 \u0447\u0438\u0441\u043b\u043e \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432." },
		{ Message.NO_DEBUG_LISTENER, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a \u043e\u0442\u043b\u0430\u0434\u0447\u0438\u043a\u0443 EGL \u043d\u0430 \u0445\u043e\u0441\u0442\u0435 {0} \u0447\u0435\u0440\u0435\u0437 \u043f\u043e\u0440\u0442 {1}. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f - {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "\u041f\u0440\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043a \u043e\u0442\u043b\u0430\u0434\u0447\u0438\u043a\u0443 EGL \u043d\u0430 \u0445\u043e\u0441\u0442\u0435 {0} \u0447\u0435\u0440\u0435\u0437 \u043f\u043e\u0440\u0442 {1} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f - {2}" },
		{ Message.NOT_DEBUG_MODE, "\u0412 \u0441\u0432\u044f\u0437\u0438 \u0437\u0430\u0434\u0430\u043d \u0432\u044b\u0437\u043e\u0432 DEBUG \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 J2EE. \u0412\u044b\u0437\u043e\u0432 \u0431\u044b\u043b \u0441\u0434\u0435\u043b\u0430\u043d \u043d\u0435 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440 J2EE, \u0441\u0435\u0440\u0432\u0435\u0440 J2EE \u043d\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u043e\u0442\u043b\u0430\u0434\u043a\u0438, \u0438\u043b\u0438 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 J2EE \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u043e\u0442\u043b\u0430\u0434\u043a\u0430 EGL." },
		{ Message.LIBRARY_NOT_SPECIFIED, "\u0412 \u0441\u0432\u044f\u0437\u0438 \u0437\u0430\u0434\u0430\u043d \u0432\u044b\u0437\u043e\u0432 DEBUG \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 EGL, \u043e\u0434\u043d\u0430\u043a\u043e \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438." },
		
		{ Message.FILETYPE_MISSING, "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f vgj.ra.fileName.fileType \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0444\u0430\u0439\u043b\u0435 {0}." },
		{ Message.FILETYPE_INVALID, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f vgj.ra.fileName.fileType \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e \u0434\u043b\u044f \u0444\u0430\u0439\u043b\u0430 {0}." },
		{ Message.INVALID_RECORD_LENGTH, "\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u043b\u0438\u043d\u044b \u0437\u0430\u043f\u0438\u0441\u0438 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0440\u0430\u0437\u0434\u0435\u043b\u044f\u0435\u0442 \u043d\u0435\u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u0433\u0440\u0430\u043d\u0438\u0446\u0430\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 occursItem \u0438\u043b\u0438 lengthItem \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u0435\u043b\u0438\u043a\u043e." },
		{ Message.IO_ERROR, "{0}: \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0441 {1} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0439 \u043f\u0440\u0438\u0447\u0438\u043d\u0435: {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 {1} [sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u0430\u0431\u043e\u0440 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 {1} [sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0}: \u043e\u0448\u0438\u0431\u043a\u0430 [sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a {0}: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a {0}, URL \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0435\u0432\u0435\u0440\u0435\u043d: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u043e\u0432 JDBC.  \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "ResultSet {0} \u043d\u0435 \u0434\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442 \u043f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0443." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e. \u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "\u041f\u0435\u0440\u0435\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 SQL \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445." },
		{ Message.SQL_DISCONNECT_ERROR, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043e\u0442 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445 {0}. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 {0}. \u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "\u0412 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 SQLLib.{0} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 SQL: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "\u0412 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 SQLLib.{0} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430, \u043d\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u0430\u044f \u0441 SQL: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "Null \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0438\u0437 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445, \u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0445\u043e\u0441\u0442\u0430 {0} \u043d\u0435 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 null." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0432\u0445\u043e\u0434\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0438\u043f\u0430 \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u043d\u0430\u0447\u0430\u0449\u0438\u0445 \u0446\u0438\u0444\u0440 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "\u0412\u0445\u043e\u0434\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043b\u0435\u0436\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 {0} - {1} - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.EDIT_VALID_VALUES_ERR, "\u0412\u0445\u043e\u0434\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u0447\u0438\u0441\u043b\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b \u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 {0}." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0434\u043b\u0438\u043d\u044b \u0432\u0432\u043e\u0434\u0430 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0434\u043b\u0438\u043d\u044b \u0432\u0432\u043e\u0434\u0430 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446\u044b - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c\u0443 \u0444\u043e\u0440\u043c\u0430\u0442\u0443 \u0434\u0430\u0442\u044b \u0438\u043b\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 {0}." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "\u0412\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b \u0434\u043b\u044f \u0431\u0443\u043b\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u043b\u044f." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u043e\u043d\u043e \u043d\u0435 \u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u044f\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u043c\u0443 \u0448\u0430\u0431\u043b\u043e\u043d\u0443." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0434\u043b\u044f {1}." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u0435\u0440\u0438\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435." },
		{ Message.EDIT_VALIDATION_ERR, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0445\u043e\u0434\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b.  \u041e\u0448\u0438\u0431\u043a\u0430: {0}." },
		{ Message.EDIT_INPUT_ERR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0430\u043d\u0430\u043b\u0438\u0437\u0430 \u0432\u0445\u043e\u0434\u043d\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0430\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "\u0412\u0445\u043e\u0434\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b SO/SI, \u0438\u043c\u0435\u044e\u0442 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u0443\u044e \u0434\u043b\u0438\u043d\u0443 \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0434\u043b\u0438\u043d\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430."},
		
		{ Message.ACTION_REQUEST_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e J2EELib RequestAttr \u0441 \u043a\u043b\u044e\u0447\u043e\u043c, {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.ACTION_SESSION_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e J2EELib SessionAttr \u0441 \u043a\u043b\u044e\u0447\u043e\u043c, {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e J2EELib ApplicationAttr \u0441 \u043a\u043b\u044e\u0447\u043e\u043c, {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u0441\u0440\u0435\u0434\u0435 J2EE." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e PortalLib PortletSessionAttr \u0441 \u043a\u043b\u044e\u0447\u043e\u043c {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c PortalLib setPortletMode. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c PortalLib setWindowState. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u0436\u0438\u043c\u0430 \u043f\u043e\u0440\u0442\u043b\u0435\u0442\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0430 \u0432\u044b\u0432\u043e\u0434" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043e\u043a\u043d\u0430 \u043f\u043e\u0440\u0442\u043b\u0435\u0442\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0430 \u0432\u044b\u0432\u043e\u0434" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c PortletSession" }, 
		{ Message.PORTALLIB_INVALIDKEY, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u043a\u043b\u044e\u0447 \u043f\u0435\u0440\u0435\u0434\u0430\u043d \u0444\u0443\u043d\u043a\u0446\u0438\u0438 {0}" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c PortletRequest" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e PortalLib resetPreferenceValue \u0441 \u043a\u043b\u044e\u0447\u043e\u043c {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e PortalLib savePreferences. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0434\u0430\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u0434\u043b\u044f \u043a\u043b\u044e\u0447\u0430 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u0434\u043b\u044f \u043a\u043b\u044e\u0447\u0430 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u0441\u043b\u0443\u0436\u0431\u0435 \u043d\u0430\u0431\u043e\u0440\u0430 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0439. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u0437\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043d\u043e\u043c\u0443 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044e \u0432 \u044f\u0447\u0435\u0439\u043a\u0435 {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443 \u0441 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f\u043c\u0438 \u0432 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u043c \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0435. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443 \u0441 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f\u043c\u0438 \u0438\u0437 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0430. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0434\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0439. \u041e\u0448\u0438\u0431\u043a\u0430: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "\u0412 {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u0412\u044b\u0437\u043e\u0432 \u043c\u0435\u0442\u043e\u0434\u0430 \u0438\u043b\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u043f\u043e\u043b\u044e {1} \u043f\u0440\u0438\u0432\u0435\u043b\u043e \u043a \u043d\u0435\u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u0439 \u043e\u0448\u0438\u0431\u043a\u0435. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 - {2}" },
		{ Message.JAVALIB_NULL_ID, "\u0412 {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. {1} \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c, \u0438\u043b\u0438 \u044d\u0442\u043e \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "\u0412 {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043c\u0435\u0442\u043e\u0434, \u043f\u043e\u043b\u0435 \u0438\u043b\u0438 \u043a\u043b\u0430\u0441\u0441 {1} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442\u0441\u044f, \u0438\u043b\u0438 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0438 \u0442\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043d\u0435\u0432\u0435\u0440\u043d\u044b. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 - {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "\u0412 {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u0422\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0432 EGL \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0438\u043f\u0443, \u043e\u0436\u0438\u0434\u0430\u0435\u043c\u043e\u043c\u0443 \u0432 Java \u0434\u043b\u044f {1}. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 - {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "\u0412 {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043c\u0435\u0442\u043e\u0434, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442 \u043d\u0443\u043b\u0435\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435, \u043c\u0435\u0442\u043e\u0434, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442 \u043d\u0438\u043a\u0430\u043a\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, \u0438\u043b\u0438 \u043f\u043e\u043b\u0435 \u0441 \u043d\u0443\u043b\u0435\u0432\u044b\u043c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "\u0412 {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043b\u0430\u0441\u0441 {1} \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 - {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "\u0412 {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u043c\u0435\u0442\u043e\u0434\u0435 \u0438\u043b\u0438 \u043f\u043e\u043b\u0435 {1}, \u0438\u043b\u0438 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430 \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f, \u043e\u0431\u044a\u044f\u0432\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043a\u0430\u043a final. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 - {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "\u0412 {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. {1} \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u043c \u0438\u043b\u0438 \u0430\u0431\u0441\u0442\u0440\u0430\u043a\u0442\u043d\u044b\u043c \u043a\u043b\u0430\u0441\u0441\u043e\u043c, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u0437\u0432\u0430\u043d." },
		{ Message.JAVALIB_NOT_STATIC, "\u0412 {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u041c\u0435\u0442\u043e\u0434 \u0438\u043b\u0438 \u043f\u043e\u043b\u0435 {1} \u043d\u0435 \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u043c\u0438. \u0412\u043c\u0435\u0441\u0442\u043e \u0438\u043c\u0435\u043d\u0438 \u043a\u043b\u0430\u0441\u0441\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "\u041f\u043e\u043b\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.CUI_E_ARRAY_FULL, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0443, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u0432\u0445\u043e\u0434\u043d\u043e\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043c\u0430\u0441\u0441\u0438\u0432 {0}." },
		{ Message.CUI_E_ASSIGN_RESULT, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u0440\u0438\u0441\u0432\u0430\u0438\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u043f\u0440\u0438\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f \u041c\u0430\u0441\u0441\u0438\u0432 \u044d\u043a\u0440\u0430\u043d\u0430: {0}."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b DrawBox \u043b\u0435\u0436\u0430\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0433\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430." },
		{ Message.CUI_E_BAD_COORDINATES, "\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u0432\u044b\u0432\u043e\u0434\u0430 \u043d\u0430\u0445\u043e\u0434\u044f\u0442\u0441\u044f \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u0430\u043c\u0438 \u043e\u043a\u043d\u0430." },
		{ Message.CUI_E_BAD_KEYNAME, "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0438\u043c\u044f \u043a\u043b\u044e\u0447\u0430 ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "\u042d\u0442\u0443 \u0444\u0443\u043d\u043a\u0446\u0438\u044e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u043a\u043d\u043e ''{0}''." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043d\u043e\u0432\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u043e\u043a\u043d\u0430 [{0},{1}]/dimension[{2},{3}]." },
		{ Message.CUI_E_CMDSTACK_SYNC, "\u0421\u0442\u0435\u043a \u043a\u043e\u043c\u0430\u043d\u0434 \u043d\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u0438 \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0430." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u044b." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "ConstructQuery \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u0437\u0432\u0430\u043d \u0441\u043e \u0441\u043f\u0438\u0441\u043a\u043e\u043c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043d\u0435\u0432\u0438\u0434\u0438\u043c\u044b\u0439 \u043f\u0443\u043d\u043a\u0442 \u043c\u0435\u043d\u044e." },
		{ Message.CUI_E_EDIT_FAILED, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435." },
		{ Message.CUI_E_EXEC_HOTKEY, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0438 \u0431\u044b\u0441\u0442\u0440\u043e\u0433\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u0430." },
		{ Message.CUI_E_EXIT_NO_CMD, "\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b. \u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u044f." },
		{ Message.CUI_E_FATALERROR, "\u041d\u0435\u0443\u0441\u0442\u0440\u0430\u043d\u0438\u043c\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "\u041f\u043e\u043b\u0435 {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "\u041f\u043e\u043b\u0435 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u044d\u043a\u0440\u0430\u043d\u0430 {0} \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "\u041f\u043e\u043b\u0435 {0} \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c ConsoleField \u0431\u0435\u0437 \u043e\u043a\u043d\u0430." },
		{ Message.CUI_E_FIELD_COUNT, "\u041d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0447\u0438\u0441\u043b\u0430 \u043f\u043e\u043b\u0435\u0439 \u043c\u0430\u0441\u0441\u0438\u0432\u0430." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "\u0424\u043e\u0440\u043c\u0430 {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "\u0424\u043e\u0440\u043c\u0430 {0} \u043d\u0435 \u043f\u043e\u043c\u0435\u0449\u0430\u0435\u0442\u0441\u044f \u0432 \u043e\u043a\u043d\u0435 {1}." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "\u0421\u043f\u0438\u0441\u043a\u0438 \u043f\u043e\u043b\u0435\u0439 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442." },
		{ Message.CUI_E_FORM_IN_USE, "\u0424\u043e\u0440\u043c\u0430 {0} \u0437\u0430\u043d\u044f\u0442\u0430." },
		{ Message.CUI_E_FORM_NAME_USED, "\u0424\u043e\u0440\u043c\u0430 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c {0} \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.CUI_E_FORM_NOT_OPEN, "\u0424\u043e\u0440\u043c\u0430 {0} \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u0430." },
		{ Message.CUI_E_FORM_NO_WINDOW, "ConsoleForm \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0431\u0435\u0437 \u043e\u043a\u043d\u0430." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c KeyObject.getChar() \u0434\u043b\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0445 \u043a\u043b\u044e\u0447\u0435\u0439." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c KeyObject.getCookedChar() \u0434\u043b\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0445 \u043a\u043b\u044e\u0447\u0435\u0439." },
		{ Message.CUI_E_INTERNAL, "\u0412\u041d\u0423\u0422\u0420\u0415\u041d\u041d\u042f\u042f \u041e\u0428\u0418\u0411\u041a\u0410: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "\u0411\u044b\u043b \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u0438\u0433\u043d\u0430\u043b INTERRUPT." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "\u041d\u0435\u0432\u0438\u0434\u0438\u043c\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043c\u0435\u043d\u044e \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u043a\u043b\u0430\u0432\u0438\u0448\u0443 \u0431\u044b\u0441\u0442\u0440\u043e\u0433\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u0430." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "ConsoleForm \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0431\u0435\u0437 \u043e\u043a\u043d\u0430." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "\u041f\u0443\u043d\u043a\u0442 \u043c\u0435\u043d\u044e {0} \u043d\u0435 \u043f\u043e\u043c\u0435\u0449\u0430\u0435\u0442\u0441\u044f \u0432 \u043e\u043a\u043d\u0435." },
		{ Message.CUI_E_MISSING_ITEM, "\u041f\u0443\u043d\u043a\u0442 \u043c\u0435\u043d\u044e {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u043d\u0435\u043c\u043e\u043d\u0438\u043a \u043c\u0435\u043d\u044e (\u043a\u043b\u044e\u0447={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430." },
		{ Message.CUI_E_NO_EDITOR, "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 blob." },
		{ Message.CUI_E_NO_HELP_FILE, "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u044b\u0439 \u0444\u0430\u0439\u043b." },
		{ Message.CUI_E_NO_HELP_MSG, "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435." },
		{ Message.CUI_E_NO_NUMPAGES, "\u041c\u0435\u043d\u044e \u043d\u0435 \u0432\u044b\u0437\u0432\u0430\u043d\u043e." },
		{ Message.CUI_E_NO_SCREENARRAY, "\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u044d\u043a\u0440\u0430\u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043c\u0435\u043d\u044e." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "\u041f\u0443\u0441\u0442\u043e\u0435 \u0438\u043c\u044f \u0434\u043b\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u043e\u043a\u043d\u0430." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u043e\u0435 \u043e\u043a\u043d\u043e." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "\u0412 \u043f\u0440\u0438\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f." },
		{ Message.CUI_E_QUIT_RECEIVED, "\u0411\u044b\u043b \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u0438\u0433\u043d\u0430\u043b QUIT." },
		{ Message.CUI_E_SCROLL_FAILED, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u0442\u0435\u043a\u0443\u0449\u0435\u043c\u0443 \u043f\u0443\u043d\u043a\u0442\u0443 \u043c\u0435\u043d\u044e." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043f\u043e\u043b\u0435 {0}." },
		{ Message.CUI_E_VAR_LIST_SHORT, "\u041f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445." },
		{ Message.CUI_E_WINDOW_NAME_USED, "\u0418\u043c\u044f \u043e\u043a\u043d\u0430 {0} \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "\u0420\u0430\u0437\u043c\u0435\u0440 \u043e\u043a\u043d\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u0435\u043d \u0434\u043b\u044f \u044d\u043a\u0440\u0430\u043d\u0430 \u0441\u043f\u0440\u0430\u0432\u043a\u0438." },
		{ Message.CUI_E_VALID_VALUES, "\u0423\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435." },
		{ Message.CUI_W_NO_MORE_FIELDS, "\u0412 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u0435\u0439 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u0442." },
		{ Message.CUI_W_NO_MORE_ROWS, "\u0412 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0440\u043e\u043a \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u0442." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u044d\u043a\u0440\u0430\u043d\u0430 {0}." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "\u041c\u0430\u0441\u0441\u0438\u0432 \u044d\u043a\u0440\u0430\u043d\u0430 {0} \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 {1}."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "\u041c\u0430\u0441\u0441\u0438\u0432 \u044d\u043a\u0440\u0430\u043d\u0430 {0} \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445." },
		{ Message.CUI_E_FIELD_NAME_DUP, "\u0418\u043c\u044f \u043f\u043e\u043b\u044f {0} \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0437." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043f\u043e\u043b\u044f \u043a\u043e\u043d\u0441\u043e\u043b\u0438 {0}." },
		{ Message.CUI_E_LABEL_NOT_FIT, "\u041c\u0435\u0442\u043a\u0430 [{0}, {1}] \u043d\u0435 \u043f\u043e\u043c\u0435\u0449\u0430\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u043c \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0435." },
		{ Message.CUI_E_FIELD_NOT_FIT, "\u041f\u043e\u043b\u0435 {0}, \u0441\u0435\u0433\u043c\u0435\u043d\u0442 ({1}, {2}) \u043d\u0435 \u043f\u043e\u043c\u0435\u0449\u0430\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u043c \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0435." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"\u0421\u0442\u0440\u043e\u043a\u0430 \u043f\u0440\u0438\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043b\u0438\u043d\u043d\u0430 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043e\u043a\u043d\u0430."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b OpenUI."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u043f\u043e\u043b\u044f OpenUI."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "\u0422\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u043d\u0430 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u0432\u044f\u0437\u0430\u043d\u0430 \u0441 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u043e\u043c \u043f\u0440\u0438\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u043e\u043b\u044f \u043a\u043e\u043d\u0441\u043e\u043b\u0438 {0}." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435: \u0432 \u0434\u0430\u043d\u043d\u044b\u0445 clob \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u0441\u0438\u043c\u0432\u043e\u043b\u044b NUL" },
		{ Message.CUI_I_STR_WINDOWTITLE , "\u041e\u043a\u043d\u043e \u043a\u043e\u043d\u0441\u043e\u043b\u0438 EGL" },
		{ Message.CUI_E_MISSING_FORMAT , "\u0412 \u043f\u043e\u043b\u0435 {0} \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u044a\u0435\u043a\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u0430." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "\u042d\u0442\u0438 \u0434\u0432\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 \u043e\u043a\u0430\u0437\u0430\u043b\u0438\u0441\u044c \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u043c\u0438 - \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0435\u0449\u0435 \u0440\u0430\u0437 \u0434\u043b\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f" },
		{ Message.CUI_I_STR_HELP,"\u0421\u043f\u0440\u0430\u0432\u043a\u0430"},
		{ Message.CUI_I_STR_RESUME,"\u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"\u0417\u0430\u0432\u0435\u0440\u0448\u0430\u0435\u0442 \u044d\u0442\u043e\u0442 \u0441\u0435\u0430\u043d\u0441 \u0441\u043f\u0440\u0430\u0432\u043a\u0438."},
		{ Message.CUI_I_STR_SCROLL , "\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430" },
		{ Message.CUI_I_STR_LAST_PAGE, "\u0412\u044b \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u0438 \u043a\u043e\u043d\u0446\u0430 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430. \u0414\u043b\u044f \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u044f \u043d\u0430\u0436\u043c\u0438\u0442\u0435 RETURN."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430."},
		{ Message.CUI_I_STR_SELECT , "\u0412\u042b\u0411\u0420\u0410\u0422\u042c"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0441\u0442\u0430\u0432\u043a\u0435 \u043f\u0435\u0440\u0432\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0438 \u0432 \u043f\u0443\u0441\u0442\u043e\u0439 \u043c\u0430\u0441\u0441\u0438\u0432."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u044b."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "\u0412\u041d\u0423\u0422\u0420\u0415\u041d\u041d\u042f\u042f \u041e\u0428\u0418\u0411\u041a\u0410: F25-64 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u044b" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "\u0423 CursesCanvas \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u043e\u0432" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "\u041f\u043e\u043a\u0430\u0437 \u043f\u043e\u043b\u0435\u0439 \u043f\u043e \u0438\u043c\u0435\u043d\u0438 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0432\u0432\u043e\u0434 {0} - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0430 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u0432\u0432\u043e\u0434\u0430 {0} - \u0443\u043a\u0430\u0436\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0435\u0449\u0435 \u0440\u0430\u0437." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f ''{0}'' \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "\u041f\u0440\u043e\u0447\u0435\u0441\u0442\u044c \u0444\u0430\u0439\u043b \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 automation.scenario ''{0}'' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u043e\u043c."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0438\u0440\u0435\u043a\u0442\u0438\u0432\u044b <click> \u0432 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u0430."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e automation ''{0}'' \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0438\u043c\u044f \u043a\u043b\u044e\u0447\u0430 panic ''{0}''"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u0432 <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b \u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438 ''{0}'' \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "\u041d\u0430\u0431\u043e\u0440 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u0434\u043b\u044f automation.scriptdir ''{0}'' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u0430\u0431\u043e\u0440 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u0434\u043b\u044f \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430 automation.scenario ''{0}''."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0438\u043c\u044f \u043a\u043b\u044e\u0447\u0430 snapshot ''{0}''"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "\u0421\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "\u0412 \u0440\u0435\u0436\u0438\u043c\u0435 RCP \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0432\u0432\u043e\u0434\u0430-\u0432\u044b\u0432\u043e\u0434\u0430 \u0434\u0438\u0441\u043f\u043b\u0435\u044f."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0441 \u0418\u0414 {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 {1}." },
		{ Message.MSG_TBL_LOAD_ERR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 {0}." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "\u0414\u043b\u044f VGUIRecord {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "\u041f\u043e\u043b\u0435 ''{0}'' \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 ({1},{2}) \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0444\u043e\u0440\u043c\u044b." },
		{ Message.TUI_E_FIELD_OVERLAP, "\u041f\u043e\u043b\u0435 ''{0}'' \u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0441 ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u0444\u043e\u0440\u043c\u044b." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "\u0424\u043e\u0440\u043c\u0430 ''{0}'' \u043d\u0435 \u0443\u043c\u0435\u0449\u0430\u0435\u0442\u0441\u044f \u043d\u0438 \u0432 \u043e\u0434\u043d\u043e\u0439 \u043f\u043b\u0430\u0432\u0430\u044e\u0449\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u043f\u043e\u043b\u044f ''{0}''." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0432\u044f\u0437\u044c \u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u043e\u043c." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "\u041d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u0430." },
		{ Message.TUI_E_NO_DISPLAY, "\u041d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u0438\u0441\u043f\u043b\u0435\u0439\u043d\u043e\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0434\u043b\u044f \u0444\u043e\u0440\u043c." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "\u041d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u0441 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u043c\u0438 \u0440\u0430\u0437\u043c\u0435\u0440\u0430\u043c\u0438 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u044b\u0445 \u0444\u043e\u0440\u043c." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "\u041a\u043b\u0430\u0441\u0441 \u0444\u043e\u0440\u043c\u044b \u0441\u043f\u0440\u0430\u0432\u043a\u0438 ''{0}''." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0435 \u0432 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0435 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439, \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043e." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u043e\u0440\u043c\u0443 \u0441\u043f\u0440\u0430\u0432\u043a\u0438 ''{0}''" },
		{ Message.TUI_E_INTERNAL, "\u0412\u041d\u0423\u0422\u0420\u0415\u041d\u041d\u042f\u042f \u041e\u0428\u0418\u0411\u041a\u0410: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u043e\u0432." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "\u041f\u0440\u0438\u043d\u0442\u0435\u0440 ''{0}'' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.\n\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u044b:\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f ''{0}''" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 {0} \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u043a\u0430\u043a \u043f\u043e\u043b\u0435." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "\u041f\u0440\u0438\u043d\u0442\u0435\u0440 ''{0}'' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043e\u0439 {0} \u043e\u0436\u0438\u0434\u0430\u043b\u0430\u0441\u044c \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u0430\u044f \u0444\u043e\u0440\u043c\u0430 {1}, \u043e\u0434\u043d\u0430\u043a\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u0430\u044f \u0444\u043e\u0440\u043c\u0430 {2} \u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0435 show." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "\u0414\u0430\u043b\u0435\u0435" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 {0} \u0438\u0437 {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "\u041d\u0430\u0437\u0430\u0434" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "\u041f\u0435\u0447\u0430\u0442\u044c" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "\u041f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043f\u0435\u0447\u0430\u0442\u0438 - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u043f\u0435\u0447\u0430\u0442\u0438 - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0432 \u0444\u0430\u0439\u043b: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0432\u043e\u0434\u0435 \u043d\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 EZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u043e\u043b\u044f ''{0}''" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0439 \u0444\u043e\u0440\u043c\u044b" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0439 \u0444\u043e\u0440\u043c\u044b - \u0437\u0430\u043f\u0443\u0441\u043a \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 ''{0}''" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 ''{0}'' \u043d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043f\u0443\u0441\u043a\u0430." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 ''{0}'' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 ''{0}''." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 ''{0}''." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 ''{0}''." },
		
		{ Message.SOA_E_LOAD_SERVICE, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u043b\u0443\u0436\u0431\u0443 \u0434\u043b\u044f Component/ExternalService {0}." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 Web-\u0441\u043b\u0443\u0436\u0431\u043e\u0439 ''{0}''.  {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 ''{0}'' \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 wsdl ''{1}''." },
		{ Message.SOA_E_WS_MALFORMED_URL, "\u0414\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 Web-\u0441\u043b\u0443\u0436\u0431\u044b {1} \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0446\u0435\u043b\u0435\u0432\u043e\u0439 URL. URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u043b\u0443\u0436\u0431\u044b {0}. \u041e\u0448\u0438\u0431\u043a\u0430: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c Web-\u0441\u043b\u0443\u0436\u0431\u0443. \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043f\u043e\u0440\u0442 WSDL \u0434\u043b\u044f \u0432\u043d\u0435\u0448\u043d\u0435\u0439 \u0441\u043b\u0443\u0436\u0431\u044b {0}." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "\u0412 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0435 {0} \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e {1}, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0435 \u0434\u043b\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0441\u043b\u0443\u0436\u0431\u044b." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0441\u043b\u0443\u0436\u0431\u0443 ''{0}'' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f." },
		{ Message.SOA_E_MISSING_BINDING, "\u0421\u0432\u044f\u0437\u044c \u0441\u043e \u0441\u043b\u0443\u0436\u0431\u043e\u0439 ''{0}'' \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0432 \u0444\u0430\u0439\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f ''{1}''" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c ''{0}'' \u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 SOAP.  \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u043b\u0435 ''{1}'' \u0432 \u0437\u0430\u043f\u0438\u0441\u0438." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c ''{0}'' \u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 SOAP."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f Web-\u0441\u043b\u0443\u0436\u0431\u044b. \u0422\u0438\u043f Java \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0442\u0438\u043f\u043e\u043c EGL." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0434\u043b\u044f Web-\u0441\u043b\u0443\u0436\u0431\u044b. \u0422\u0438\u043f EGL \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0442\u0438\u043f\u043e\u043c Java." },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c ''{0}''." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 ''{0}'' \u0432 Calendar." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 ''{0}'' \u0432 boolean." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 ''{0}'' \u0432 Byte." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 ''{0}'' \u0432 short." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 ''{0}'' \u0432 URI." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "\u0422\u0438\u043f EGL \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 Web-\u0441\u043b\u0443\u0436\u0431\u044b." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0437\u0430\u043f\u0438\u0441\u0438 \u043c\u0430\u0441\u0441\u0438\u0432\u0430. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "\u041c\u0435\u0442\u043e\u0434 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0441\u043b\u0443\u0436\u0431\u0435 {1}." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "\u042d\u0442\u0430 \u0441\u043b\u0443\u0436\u0431\u0430 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f Web-\u0441\u043b\u0443\u0436\u0431\u043e\u0439." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "\u041f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u0437\u0432\u0430\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e {0} \u0432 Web-\u0441\u043b\u0443\u0436\u0431\u0435 {1} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "\u041f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u0437\u0432\u0430\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e {0} \u0432 \u0441\u043b\u0443\u0436\u0431\u0435 EGL {1} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "\u041f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u0437\u0432\u0430\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e {0} \u0432 \u0441\u043b\u0443\u0436\u0431\u0435 EGL {1} \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e {2}:{3} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u0447\u0438\u0441\u043b\u043e \u0441\u043b\u0443\u0436\u0431 tcpip." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "\u041f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u0437\u0432\u0430\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e {0} \u0432 \u0442\u043e\u0447\u043a\u0435 \u0432\u0445\u043e\u0434\u0430 {1} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441\u0432\u044f\u0437\u0438 \u0441\u043e \u0441\u043b\u0443\u0436\u0431\u043e\u0439 {0}. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "\u041f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u0437\u0432\u0430\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e {0} \u0441\u043b\u0443\u0436\u0431\u044b CICS {1} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 - {2}, \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 - {3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 {0} \u0432 \u0441\u043b\u0443\u0436\u0431\u0435 iSeries {1}. \u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 - {2}, \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 - {3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u0447\u0438\u0441\u043b\u043e \u0441\u043b\u0443\u0436\u0431 CICS." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u0441\u043b\u0443\u0436\u0431\u0435 {0}, \u0434\u0430\u0442\u0430: {1}, \u0432\u0440\u0435\u043c\u044f: {2}, \u0441\u0438\u0441\u0442\u0435\u043c\u0430: {3}." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u0441\u043b\u0443\u0436\u0431\u0435 {0}, \u0441\u0438\u0441\u0442\u0435\u043c\u0430: {1}." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {0} \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431\u044b {1}. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f AS400Toolbox: {0}, {1} \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u0441\u043b\u0443\u0436\u0431\u044b {2} \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {3}." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0430\u044f \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0441\u043b\u0443\u0436\u0431\u044b. {0} \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043b\u0430\u0441\u044c \u0434\u043b\u044f Websphere, \u043d\u043e \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0438\u0437 \u0441\u0440\u0435\u0434\u044b, \u043e\u0442\u043b\u0438\u0447\u043d\u043e\u0439 \u043e\u0442 J2EE. \u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u0443\u044e \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044e \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430, \u043e\u0442\u043b\u0438\u0447\u043d\u043e\u0433\u043e \u043e\u0442 J2EE." },
		{ Message.SOA_E_USER_ID_NOT_SET, "\u041f\u0435\u0440\u0435\u0434 \u0432\u044b\u0437\u043e\u0432\u043e\u043c WebService:{0} function:{1} \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u0418\u0414 \u0438 \u043f\u0430\u0440\u043e\u043b\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u0441\u043b\u0443\u0436\u0431\u044b." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u043c\u0435\u043d\u0430 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0441\u043e \u0441\u043b\u0443\u0436\u0431\u043e\u0439 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u0441\u043b\u0443\u0436\u0431\u044b REST. \u0421\u0432\u044f\u0437\u044c: {0}, \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f: {0}." },
		{ Message.SOA_E_WS_PROXY_SOAP, "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u0441\u043b\u0443\u0436\u0431\u044b SOAP. \u0421\u0432\u044f\u0437\u044c: {0}, \u0441\u043b\u0443\u0436\u0431\u0430: {1}, \u043f\u043e\u0440\u0442: {2}, \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 WSDL: {3}." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437 JSON \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: {0}, json: {1}." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0432 JSON \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: {0}, \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f: {1}." },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "\u0421\u043b\u0443\u0436\u0431\u0430 REST-RPC \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430. URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "\u041e\u0442 \u0441\u043b\u0443\u0436\u0431\u044b \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442. URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0432 \u0432\u044b\u0437\u043e\u0432 \u0441\u043b\u0443\u0436\u0431\u044b. \u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0437\u0430\u043f\u0440\u043e\u0441 ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "\u0422\u0430\u0439\u043c-\u0430\u0443\u0442 \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431\u044b. \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f: \u043e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u043f\u043e \u0442\u0430\u0439\u043c-\u0430\u0443\u0442\u0443. url:{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "\u0421\u043b\u0443\u0436\u0431\u0430 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u043b\u0443\u0436\u0431\u043e\u0439 REST." },
		{ Message.SOA_E_REST_SERVICE, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431\u044b REST. \u0421\u0432\u044f\u0437\u044c:{0}, \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f:{1}, \u043c\u0435\u0442\u043e\u0434 HTTP:{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b EGL \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. \u0421\u0432\u044f\u0437\u044c:{0}, \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f {1}, \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f:{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "\u0412\u044b\u0437\u043e\u0432 \u0441\u043b\u0443\u0436\u0431\u044b REST \u0431\u044b\u043b \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0430 \u0434\u0440\u0443\u0433\u0443\u044e \u0441\u043b\u0443\u0436\u0431\u0443. \u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0441\u043b\u0443\u0436\u0431\u0443: {0}, \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f: {1}, \u043c\u0435\u0442\u043e\u0434 HTTP: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437 XML \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 {0}." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437 XML \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440:{0}, xml:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0432 XML \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: {0}, \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f: {1}." },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0438\u0437 XML \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u0430\u043d\u0430\u043b\u0438\u0437\u0430 XML." },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0432 XML \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f XML." },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "URL ''{0}'', \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u0434\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431\u044b, \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c. \u0412 \u043d\u0435\u043c \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b http://." },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "URL ''{0}'', \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u0434\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431\u044b, \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "URL, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u0434\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431\u044b, \u043f\u0443\u0441\u0442. \u0412\u0432\u0435\u0434\u0438\u0442\u0435 URL, \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u044e\u0449\u0438\u0439 \u043d\u0430 \u0441\u043b\u0443\u0436\u0431\u0443." },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f {0}"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 SQL {0}"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043c\u0430\u0441\u0441\u0438\u0432\u0430 {0}"},
		{ Message.REPORT_E_FILL_ERROR , "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 {0}"},
		{ Message.REPORT_E_EXPORT_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 {0}" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0438\u043f EGL {0} \u0432 \u0442\u0438\u043f Java {1}" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0438\u043f Java {0} \u0432 \u0442\u0438\u043f EGL {1}" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043e\u0442\u0447\u0435\u0442\u0430" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043e\u0442\u0447\u0435\u0442\u0430" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044f {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u0434\u0447\u0438\u043d\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0447\u0435\u0442\u0430 {0}" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "\u0412 \u043e\u0442\u0447\u0435\u0442\u0435 \u0431\u044b\u043b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0442\u044c \u044d\u0442\u043e\u0439 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u0441\u043b\u043e\u0436\u043d\u044b\u0435 \u0442\u0438\u043f\u044b" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u044d\u0441\u043a\u0438\u0437\u0430 \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u0442\u044c \u0434\u043e \u0432\u044b\u0437\u043e\u0432\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 getParameterDefaultValue()." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 {0} \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043e\u0442\u0447\u0435\u0442\u0430 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u044d\u0441\u043a\u0438\u0437\u0430 \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u0442\u044c \u0434\u043e \u0432\u044b\u0437\u043e\u0432\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 createReportFromDesign() \u0438\u043b\u0438 createDocument()." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u0442\u044c \u0434\u043e \u0432\u044b\u0437\u043e\u0432\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 createReportFromDocument()." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e\u0442\u0447\u0435\u0442\u043e\u0432. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 \u044d\u0441\u043a\u0438\u0437\u043e\u0432. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "\u041e\u0431\u044a\u0435\u043a\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u043b\u044f BirtReport, \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0442\u0438\u043f BirtHandler." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "\u042d\u043b\u0435\u043c\u0435\u043d\u0442 {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u044d\u0441\u043a\u0438\u0437 \u043e\u0442\u0447\u0435\u0442\u0430, \u043b\u0438\u0431\u043e \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "\u0421\u0442\u0440\u043e\u043a\u0430 {0} \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {1} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 {2}." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "\u0421\u0442\u0440\u043e\u043a\u0430 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b {1}." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "\u0413\u0440\u0443\u043f\u043f\u0430 {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 {1}." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "\u0421\u0442\u0440\u043e\u043a\u0430 {0} \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {1} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0433\u0440\u0443\u043f\u043f\u0435 {2} \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 {3}." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "\u041d\u043e\u043c\u0435\u0440 \u0441\u0442\u043e\u043b\u0431\u0446\u0430 {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 {1} \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 {2}." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "\u0421\u0442\u043e\u043b\u0431\u0435\u0446 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 {1}." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "\u041d\u043e\u043c\u0435\u0440 \u0441\u0442\u043e\u043b\u0431\u0446\u0430 {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 {1} \u0432 \u0433\u0440\u0443\u043f\u043f\u0435 {2} \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 {3}." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e ''RowType'' \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0434\u043b\u044f \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u0434\u043b\u044f \u0441\u0442\u0440\u043e\u043a \u0438\u043b\u0438 \u044f\u0447\u0435\u0435\u043a \u0442\u0430\u0431\u043b\u0438\u0446\u044b {0}." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0438\u043f Java {0} \u0432 \u0442\u0438\u043f EGL." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0438\u043f EGL {0} \u0432 \u0442\u0438\u043f Java." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "\u041d\u0430\u0431\u043e\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u044d\u0441\u043a\u0438\u0437\u0435 \u043e\u0442\u0447\u0435\u0442\u0430." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "\u041d\u0430\u0431\u043e\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 {0} \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0438, \u043e\u0434\u043d\u0430\u043a\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u044f eventType \u043d\u0435 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u043b\u0438\u0441\u044c: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u044d\u0441\u043a\u0438\u0437\u0435 \u043e\u0442\u0447\u0435\u0442\u0430." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 {0} \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0438, \u043e\u0434\u043d\u0430\u043a\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u044f eventType \u043d\u0435 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u043b\u0438\u0441\u044c: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "\u0421\u0442\u043e\u043b\u0431\u0435\u0446 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0} \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043d\u0430\u0431\u043e\u0440\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 {1}." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u043e\u043b\u0431\u0446\u0430 {0} \u0438\u0437 \u043d\u0430\u0431\u043e\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 {1}. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u043e\u043b\u0431\u0446\u0430 {0} \u0438\u0437 \u043d\u0430\u0431\u043e\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0435\u0432 {1}. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u043d\u0438\u044f \u0441\u0442\u043e\u043b\u0431\u0446\u0430 {0}. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e vgj.defaultI4GLNativeLibrary \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0443 {0} {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u0438" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0430\u043c\u044f\u0442\u044c"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0438\u043f\u044b"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0442\u043e\u0447\u043d\u043e\u0441\u0442\u044c Datetime \u0438\u043b\u0438 Interval"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "\u0414\u043b\u0438\u043d\u0430 \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0445\u043e\u0441\u0442\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b\u0430 \u0434\u043b\u044f \u044d\u0442\u0438\u0445 \u0434\u0430\u043d\u043d\u044b\u0445"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u0432"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "\u0412 \u044d\u0442\u043e\u043c \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435 \u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0442\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445 TEXT \u0438\u043b\u0438 BYTE"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0441\u0442\u0435\u043a\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0432 \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0441\u0442\u0435\u043a\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0432 \u0442\u0438\u043f ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 {0} \u0438\u0437 \u0441\u0442\u0435\u043a\u0430"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 {1} \u0432 \u0441\u0442\u0435\u043a"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "\u041d\u0435\u0447\u0435\u0433\u043e \u043f\u043e\u043c\u0435\u0449\u0430\u0442\u044c \u0432 \u0441\u0442\u0435\u043a \u0438\u043b\u0438 \u0438\u0437\u0432\u043b\u0435\u043a\u0430\u0442\u044c \u0438\u0437 \u043d\u0435\u0433\u043e"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u0432\u043b\u0435\u0447\u044c \u0438\u0437 \u0441\u0442\u0435\u043a\u0430 Locator"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "\u0421\u0442\u0435\u043a \u043f\u0443\u0441\u0442"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c locator"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "\u0412 \u0441\u0442\u0435\u043a \u0431\u044b\u043b\u0430 \u043f\u043e\u043c\u0435\u0449\u0435\u043d\u0430 \u0441\u0441\u044b\u043b\u043a\u0430 null"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432 \u0441\u0442\u0435\u043a Any"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0443 \u0441\u0442\u0435\u043a\u0430 \u0442\u0438\u043f Any"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "\u041d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0442\u0438\u043f\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "\u041d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0442\u0438\u043f\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0444\u0430\u0439\u043b EGL {0}.  \u0412\u043c\u0435\u0441\u0442\u043e \u043d\u0435\u0433\u043e \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u0434." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0444\u0430\u0439\u043b EGL \u0434\u043b\u044f Web-\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 {0}." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "\u0412 \u043f\u043e\u043b\u0435 \"{0}\" \u043f\u0440\u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0444\u043e\u0440\u043c\u044b \"{1}\" \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0430\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f:" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\n\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u043e\u043b\u044f \"{1}\". \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u0434\u0430\u0442\u044b \u0432 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u0445 EGL Java Runtime \u0432 \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u043e\u043c \u043e\u043f\u0438\u0441\u0430\u0442\u0435\u043b\u0435 Build \u0438\u043b\u0438 \u0432 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u0445 \u0441\u0432\u043e\u0435\u0433\u043e JDBC, \u0432\u043b\u0438\u044f\u044e\u0449\u0438\u0445 \u043d\u0430 \u0444\u043e\u0440\u043c\u0430\u0442\u044b \u0434\u0430\u0442." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\n\u0424\u043e\u0440\u043c\u0430\u0442 \u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u043e\u043b\u044f \"{1}\". \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \"{2}\" \u0432 \u043f\u043e\u043b\u0435 \u0444\u043e\u0440\u043c\u044b." },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 {0} \u043a\u0430\u043a Web-\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "Web-\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u0430 \u0432\u0445\u043e\u0434\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c {0} \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f, \u043e\u0434\u043d\u0430\u043a\u043e \u043e\u043d\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0441 \u0432\u0445\u043e\u0434\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u044c\u044e {1}." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "\u0412\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b \u0434\u043b\u044f \u0431\u0443\u043b\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u043b\u044f." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "\u0422\u0430\u0439\u043c-\u0430\u0443\u0442 \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 {0} \u0432\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u0435 \u0431\u0435\u0437\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "\u0417\u0430\u043f\u0438\u0441\u044c {0} \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u0435\u0440\u0432\u043b\u0435\u0442\u0443 \u0448\u043b\u044e\u0437\u0430." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0441\u0435\u0440\u0432\u043b\u0435\u0442\u0430 \u0448\u043b\u044e\u0437\u0430.  \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 - {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u043e\u0431\u043e\u043b\u043e\u0447\u043a\u0443 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 {0} \u0441\u0432\u044b\u0448\u0435 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u0430. \u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043c\u0435\u0442\u043e\u0434\u0435 {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} - \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441 \u0434\u043b\u044f \u043e\u0431\u043e\u043b\u043e\u0447\u043a\u0438 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 {1}. \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440: {2}. \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0440\u0430\u0437\u043c\u0435\u0440: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} - \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0434\u043b\u044f \u043e\u0431\u043e\u043b\u043e\u0447\u043a\u0438 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} - \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u043e\u0431\u043e\u043b\u043e\u0447\u043a\u0443 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u0442\u0438\u043f\u0430 {1}." },
		
		{ Message.IMS_HOST_ABORT, "\u041e\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0445\u043e\u0441\u0442\u0430 \u0431\u044b\u043b \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043f\u0430\u043a\u0435\u0442 \u043f\u0440\u0435\u0440\u044b\u0432\u0430\u043d\u0438\u044f."},
		{ Message.IMS_HOST_TCPIP_ERROR, "\u0412 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0445\u043e\u0441\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 TCPIP. \u0420\u0430\u0437\u0434\u0435\u043b:{0} TCPIP-Operation:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "\u0412 \u0445\u043e\u0441\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435: {0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "\u041e\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0445\u043e\u0441\u0442\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043e\u0442\u0432\u0435\u0442\u0430. \u041e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c:{0} \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e:{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430-\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0445\u0440\u0430\u043d\u0438\u043c\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 SQL \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0445\u0440\u0430\u043d\u0438\u043c\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0445\u043e\u0441\u0442\u0435 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438:{0} RETCODE:{1} \u0418\u0414 \u0437\u0430\u0434\u0430\u043d\u0438\u044f Proxy DLI:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "\u0412 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0445\u043e\u0441\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 DLI. \u0424\u0443\u043d\u043a\u0446\u0438\u044f DLI:{0} AIB-return:0x{1} AIB-reason:0x{2} statusCode:{3} \u0418\u0414 \u0437\u0430\u0434\u0430\u043d\u0438\u044f Proxy DLI:{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "\u0412 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0445\u043e\u0441\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 DLI. \u0424\u0443\u043d\u043a\u0446\u0438\u044f DLI:{0} AIB-return:0x{1} AIB-reason:0x{2} DLIVar.statusCode:{3} DLIVar.DbName:{4} DLIVar.SegmentName:{5} DLIVar.SegmentLevel:{6} \u0418\u0414 \u0437\u0430\u0434\u0430\u043d\u0438\u044f Proxy DLI:{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "\u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 AIB \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u043a\u043e\u0434 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f PCB, \u043e\u0434\u043d\u0430\u043a\u043e PCB \u043d\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d. AIB-\u0444\u0443\u043d\u043a\u0446\u0438\u044f:{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "\u0412 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0445\u043e\u0441\u0442\u0435 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f CALL EZEDBTCP. \u0420\u0430\u0437\u0434\u0435\u043b:{0} TCPIP-Operation:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "\u0412 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0445\u043e\u0441\u0442\u0435 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u043e \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 ABEND. \u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430:{0} \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435:{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "\u0412 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0445\u043e\u0441\u0442\u0435 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f. CALL:{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "\u0424\u0443\u043d\u043a\u0446\u0438\u044f DLI \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043e\u0442\u043b\u0430\u0434\u0447\u0438\u043a\u043e\u043c. \u0424\u0443\u043d\u043a\u0446\u0438\u044f:{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "\u0412\u044b\u0437\u043e\u0432 DL/I \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u0443\u0435\u0442\u0441\u044f, \u043d\u043e \u0434\u0435\u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0440 \u043a\u043e\u043c\u043f\u043e\u043d\u043e\u0432\u043a\u0438 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a DL/I."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u0430\u044f \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u044c PSB. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 IMSID \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442, \u0447\u0442\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f DL/I, \u043d\u043e \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d PSB"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "\u0412\u0435\u0440\u0441\u0438\u0438 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 RBD \u0438 \u0445\u043e\u0441\u0442\u0430 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b. \u0412\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 RBD:{0} \u0412\u0435\u0440\u0441\u0438\u044f \u0445\u043e\u0441\u0442\u0430:{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445, \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u043d\u044b\u0445 \u0432\u044b\u0437\u043e\u0432\u043e\u043c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0445\u043e\u0441\u0442\u0430. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u0438 \u0438\u043c\u0435\u043d\u0438 PCB. \u0418\u043d\u0434\u0435\u043a\u0441 PCB:{0}, \u0447\u0438\u0441\u043b\u043e PCB:{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
