/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.runtime.java.egl.lang;

import org.eclipse.edt.javart.Constants;
import org.eclipse.edt.javart.JavartException;

public class DynamicAccessException extends AnyException {
	private static final long serialVersionUID = Constants.SERIAL_VERSION_UID;

	public String key;

	public DynamicAccessException() throws JavartException {
		key = "";
	}

	public DynamicAccessException(Exception ex) {
		super(ex);
	}

	public DynamicAccessException(String key) throws JavartException {
		this.key = key;
	}

	public Object clone() throws java.lang.CloneNotSupportedException {
		DynamicAccessException ezeClone = (DynamicAccessException) super.clone();
		ezeClone.key = key;
		return ezeClone;
	}
}
