/*
 * Decompiled with CFR 0.152.
 */
package eglx.json;

import eglx.json.EGLToJSONConverter;
import eglx.services.ServiceKind;
import eglx.services.ServiceUtilities;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.json.NameValuePairNode;
import org.eclipse.edt.javart.json.ObjectNode;
import org.eclipse.edt.javart.json.StringNode;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.runtime.java.egl.lang.AnyException;

public class JsonUtilities {
    private static String JSON_RPC_ERROR_ID = "error";
    private static String JSON_RPC_ERROR_NAME_ID = "name";
    public static String JSON_RPC_ERROR_NAME_VALUE = "JSONRPCError";
    private static String JSON_RPC_ERROR_MESSAGE_ID = "message";
    private static String JSON_RPC_ERROR_CODE_ID = "code";

    private JsonUtilities() {
    }

    public static String trimJSON(String json) {
        if (json == null || json.equals("")) {
            return json;
        }
        if (json.charAt(0) == '{') {
            int curlyCount = 1;
            boolean ignoreCurlyBraces = false;
            int n = 1;
            while (n < json.length()) {
                switch (json.charAt(n)) {
                    case '\"': {
                        if (!ignoreCurlyBraces) {
                            ignoreCurlyBraces = true;
                            break;
                        }
                        if (json.charAt(n - 1) == '\\') break;
                        ignoreCurlyBraces = false;
                        break;
                    }
                    case '{': {
                        if (ignoreCurlyBraces) break;
                        ++curlyCount;
                        break;
                    }
                    case '}': {
                        if (ignoreCurlyBraces) break;
                        --curlyCount;
                    }
                }
                if (curlyCount == 0) {
                    json = json.substring(0, n + 1);
                }
                ++n;
            }
        }
        return json;
    }

    public static String createJsonJavartException(ExecutableBase program, JavartException jrte) {
        ObjectNode wrapper = new ObjectNode();
        ObjectNode error = new ObjectNode();
        error.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_NAME_ID, true), new StringNode(JSON_RPC_ERROR_NAME_VALUE, false)));
        error.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_CODE_ID, true), new StringNode(jrte.getMessageID(), false)));
        error.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_MESSAGE_ID, true), new StringNode(ServiceUtilities.getMessage(jrte), false)));
        wrapper.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_ID, true), error));
        if (jrte instanceof AnyException) {
            ObjectNode eglException;
            AnyException record = (AnyException)jrte;
            try {
                eglException = (ObjectNode)EGLToJSONConverter.convertToJson(program, record);
            }
            catch (JavartException javartException) {
                eglException = new ObjectNode();
            }
            error.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_ID, true), eglException));
            eglException.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_NAME_ID, true), new StringNode(record.getClass().getName(), false)));
        }
        return wrapper.toJson();
    }

    static String buildJsonServiceInvocationException(ExecutableBase program, String id, Object[] params, Throwable t, ServiceKind serviceKind) {
        return JsonUtilities.createJsonJavartException(program, ServiceUtilities.buildServiceInvocationException(program, id, params, t, serviceKind));
    }
}

