/*
 * Decompiled with CFR 0.152.
 */
package eglx.services;

import eglx.services.ServiceInvocationException;
import eglx.services.ServiceKind;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.util.JavartUtil;

public class ServiceUtilities {
    public static String UTF8 = "UTF-8";

    private ServiceUtilities() {
    }

    public static JavartException buildServiceInvocationException(ExecutableBase program, String id, Object[] params, Throwable t, ServiceKind serviceKind) {
        String message = JavartUtil.errorMessage(program, id, params);
        JavartException jrte = null;
        try {
            jrte = ServiceUtilities.buildInvocationException(program, id, message, "", "", "", t, serviceKind);
        }
        catch (JavartException javartException) {
            jrte = new ServiceInvocationException(t);
        }
        return jrte;
    }

    private static JavartException buildInvocationException(ExecutableBase prog, String id, String message, String detail1, String detail2, String detail3, Throwable t, ServiceKind serviceKind) {
        ServiceInvocationException sie;
        while (t instanceof InvocationTargetException && ((InvocationTargetException)t).getCause() != null) {
            t = ((InvocationTargetException)t).getCause();
        }
        ServiceInvocationException serviceInvocationException = sie = t == null ? new ServiceInvocationException() : new ServiceInvocationException(t);
        if (detail3 == null || detail3.length() == 0) {
            detail3 = ServiceUtilities.getMessage(t);
        }
        sie.setMessage(message == null ? "" : message);
        sie.setMessageID(id == null ? "" : id);
        sie.setDetail1(detail1 == null ? "" : detail1);
        sie.setDetail2(detail2 == null ? "" : detail2);
        sie.setDetail3(detail3 == null ? "" : detail3);
        sie.setServiceKind(serviceKind);
        return sie;
    }

    public static String getMessage(Throwable t) {
        while (t instanceof InvocationTargetException && ((InvocationTargetException)t).getCause() != null) {
            t = ((InvocationTargetException)t).getCause();
        }
        if (t instanceof JavartException) {
            return t.getMessage();
        }
        if (t != null && t.getMessage() != null) {
            return String.valueOf(t.getClass().getName()) + ":" + t.getMessage();
        }
        if (t != null && t.toString() != null) {
            return t.toString();
        }
        return "";
    }

    static String convert(Map<?, ?> map) {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() != null) {
                buffer.append(entry.getKey().toString());
                buffer.append(':');
            }
            if (entry.getValue() instanceof Map) {
                buffer.append('(');
                buffer.append(ServiceUtilities.convert((Map)entry.getValue()));
                buffer.append(')');
            } else if (entry.getValue() != null) {
                buffer.append(entry.getValue().toString());
            }
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

