/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.json;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.json.JsonVisitor;
import org.eclipse.edt.javart.json.ValueNode;

public class StringNode
extends ValueNode {
    String jsonValue;
    String javaValue;

    public StringNode(String value, boolean json) {
        if (json) {
            this.jsonValue = value;
        } else {
            this.javaValue = value;
        }
    }

    public StringNode(byte[] value, boolean json) {
        if (json) {
            this.jsonValue = new String(value);
        } else {
            this.javaValue = new String(value);
        }
    }

    public StringNode(Calendar value, boolean json) {
        if (json) {
            this.jsonValue = new SimpleDateFormat("yyyyMMddHHmmss").format(value.getTime());
        } else {
            this.javaValue = new SimpleDateFormat("yyyyMMddHHmmss").format(value.getTime());
        }
    }

    @Override
    public void accept(JsonVisitor visitor) throws JavartException {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void visitChildren(JsonVisitor visitor) {
    }

    public String getJavaValue() {
        if (this.javaValue == null) {
            this.javaValue = StringNode.convertJsonToJava(this.jsonValue);
        }
        return this.javaValue;
    }

    public String getJsonValue() {
        if (this.jsonValue == null) {
            this.jsonValue = StringNode.convertJavaToJson(this.javaValue);
        }
        return this.jsonValue;
    }

    public static String convertJavaToJson(String value) {
        StringBuilder inBuf = new StringBuilder(value);
        StringBuilder outBuf = new StringBuilder();
        int idx = 0;
        while (idx < inBuf.length()) {
            char currentChar = inBuf.charAt(idx);
            switch (currentChar) {
                case '\\': {
                    outBuf.append("\\\\");
                    break;
                }
                case '\"': {
                    outBuf.append("\\\"");
                    break;
                }
                case '/': {
                    outBuf.append("\\/");
                    break;
                }
                case '\b': {
                    outBuf.append("\\b");
                    break;
                }
                case '\f': {
                    outBuf.append("\\f");
                    break;
                }
                case '\n': {
                    outBuf.append("\\n");
                    break;
                }
                case '\r': {
                    outBuf.append("\\r");
                    break;
                }
                case '\t': {
                    outBuf.append("\\t");
                    break;
                }
                default: {
                    if (Character.isISOControl(currentChar)) {
                        String controlEsc = "0000";
                        controlEsc = String.valueOf(controlEsc) + Integer.toHexString(currentChar);
                        outBuf.append("\\u");
                        outBuf.append(controlEsc.substring(controlEsc.length() - 4));
                        break;
                    }
                    outBuf.append(currentChar);
                }
            }
            ++idx;
        }
        return outBuf.toString();
    }

    public static String convertJsonToJava(String value) {
        String str = StringNode.replaceUnicodeEscapes(value);
        StringBuilder inBuf = new StringBuilder(str);
        StringBuilder outBuf = new StringBuilder();
        int idx = 0;
        while (idx < inBuf.length()) {
            char currentChar = inBuf.charAt(idx);
            if (currentChar == '\\' && ++idx < inBuf.length()) {
                currentChar = inBuf.charAt(idx);
                switch (currentChar) {
                    case '\\': {
                        outBuf.append('\\');
                        break;
                    }
                    case '\"': {
                        outBuf.append('\"');
                        break;
                    }
                    case '/': {
                        outBuf.append('/');
                        break;
                    }
                    case 'b': {
                        outBuf.append('\b');
                        break;
                    }
                    case 'f': {
                        outBuf.append('\f');
                        break;
                    }
                    case 'n': {
                        outBuf.append('\n');
                        break;
                    }
                    case 'r': {
                        outBuf.append('\r');
                        break;
                    }
                    case 't': {
                        outBuf.append('\t');
                        break;
                    }
                    default: {
                        outBuf.append('\\');
                        outBuf.append(currentChar);
                        break;
                    }
                }
            } else {
                outBuf.append(currentChar);
            }
            ++idx;
        }
        return outBuf.toString();
    }

    private static String replaceUnicodeEscapes(String str) {
        int index = str.indexOf("\\u");
        if (index < 0) {
            return str;
        }
        StringBuilder buff = new StringBuilder();
        int previousChar = 120;
        if (index > 0) {
            buff.append(str.substring(0, index));
            previousChar = str.charAt(index - 1);
        }
        int i = index;
        while (i < str.length()) {
            if (i < str.length() - 5 && previousChar != 92 && str.charAt(i) == '\\' && str.charAt(i + 1) == 'u') {
                String hex = str.substring(i + 2, i + 6);
                int hexInt = Integer.parseInt(hex, 16);
                buff.append((char)hexInt);
                i += 5;
                previousChar = 120;
            } else {
                previousChar = str.charAt(i);
                buff.append((char)previousChar);
            }
            ++i;
        }
        return buff.toString();
    }

    @Override
    public String toJson() {
        return "\"" + this.getJsonValue() + "\"";
    }

    @Override
    public String toString() {
        return this.getJavaValue();
    }

    @Override
    public String toJava() {
        return this.getJavaValue();
    }

    public Calendar toCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new SimpleDateFormat("yyyyMMddHHmmss").parse(this.getJavaValue(), new ParsePosition(0)));
        return calendar;
    }
}

