/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.resources.RecoverableResource;
import org.eclipse.edt.javart.resources.RunUnitBase;

public class ResourceManager
implements Serializable {
    private static final long serialVersionUID = 10L;
    private ArrayList resourceList = new ArrayList(7);

    public ArrayList getResourceList() {
        return this.resourceList;
    }

    public void commit(RunUnitBase ru) throws JavartException {
        if (this.resourceList.size() > 0) {
            Iterator i = new ArrayList(this.resourceList).iterator();
            while (i.hasNext()) {
                ((RecoverableResource)i.next()).commit(ru);
            }
        }
    }

    public void rollback(RunUnitBase ru) throws JavartException {
        if (this.resourceList.size() > 0) {
            Iterator i = new ArrayList(this.resourceList).iterator();
            while (i.hasNext()) {
                ((RecoverableResource)i.next()).rollback(ru);
            }
        }
    }

    public void exit(RunUnitBase ru) throws JavartException {
        if (this.resourceList.size() > 0) {
            Iterator i = new ArrayList(this.resourceList).iterator();
            while (i.hasNext()) {
                ((RecoverableResource)i.next()).exit(ru);
            }
        }
    }

    public void transferCleanup(RunUnitBase ru, boolean toTransaction) throws JavartException {
        if (this.resourceList.size() > 0) {
            Iterator i = new ArrayList(this.resourceList).iterator();
            while (i.hasNext()) {
                ((RecoverableResource)i.next()).transferCleanup(ru, toTransaction);
            }
        }
    }

    public boolean isRegistered(RecoverableResource rs) {
        return this.resourceList.contains(rs);
    }

    public void register(RecoverableResource rs) {
        if (!this.resourceList.contains(rs)) {
            this.resourceList.add(rs);
        }
    }

    public void unregister(RecoverableResource rs) {
        this.resourceList.remove(rs);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.resourceList.size() > 0) {
            for (RecoverableResource next : new ArrayList(this.resourceList)) {
                if (next instanceof Serializable) continue;
                this.unregister(next);
            }
        }
        out.defaultWriteObject();
    }
}

