/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.bindings;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.eclipse.edt.javart.services.bindings.EGLBinding;
import org.eclipse.edt.javart.services.bindings.NativeBinding;
import org.eclipse.edt.javart.services.bindings.ProtocolCICSECI;
import org.eclipse.edt.javart.services.bindings.ProtocolCICSJ2C;
import org.eclipse.edt.javart.services.bindings.ProtocolCICSSSL;
import org.eclipse.edt.javart.services.bindings.ProtocolJAVA400;
import org.eclipse.edt.javart.services.bindings.ProtocolJAVA400J2C;
import org.eclipse.edt.javart.services.bindings.ProtocolLOCAL;
import org.eclipse.edt.javart.services.bindings.ProtocolRef;
import org.eclipse.edt.javart.services.bindings.ProtocolTCPIP;
import org.eclipse.edt.javart.services.bindings.RestBinding;
import org.eclipse.edt.javart.services.bindings.RuntimeBindings;
import org.eclipse.edt.javart.services.bindings.WebBinding;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BindXMLParser
extends DefaultHandler
implements Serializable {
    private static final long serialVersionUID = 70L;
    private RuntimeBindings bindings;
    private EGLBinding currentEGLBinding;
    private NativeBinding currentNativeBinding;

    public RuntimeBindings parse(RuntimeBindings bindings, String path) throws Exception {
        this.bindings = bindings;
        return this.parse(new InputSource(new FileReader(path)));
    }

    public RuntimeBindings parse(RuntimeBindings bindings, InputStream is) throws Exception {
        this.bindings = bindings;
        return this.parse(new InputSource(is));
    }

    private RuntimeBindings parse(InputSource source) throws IOException, SAXException {
        this.currentEGLBinding = null;
        XMLReader xr = XMLReaderFactory.createXMLReader();
        xr.setContentHandler(this);
        xr.setErrorHandler(this);
        xr.parse(source);
        return this.bindings;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equals("eglBinding")) {
            this.currentEGLBinding = new EGLBinding(attributes.getValue("name"), attributes.getValue("serviceName"), attributes.getValue("alias"));
            this.bindings.addBinding(this.currentEGLBinding);
        } else if (localName.equals("nativeBinding")) {
            this.currentNativeBinding = new NativeBinding(attributes.getValue("name"));
            this.bindings.addBinding(this.currentNativeBinding);
        } else if (localName.equals("webBinding")) {
            this.bindings.addBinding(new WebBinding(attributes.getValue("name"), attributes.getValue("interface"), attributes.getValue("wsdlLocation"), attributes.getValue("wsdlPort"), attributes.getValue("wsdlService"), attributes.getValue("uri"), attributes.getValue("SOAPLevel")));
        } else if (localName.equals("restBinding")) {
            this.bindings.addBinding(new RestBinding(attributes.getValue("name"), attributes.getValue("baseURI"), attributes.getValue("sessionCookieId")));
        } else if (localName.equals("protocol.ref")) {
            ProtocolRef protocol = new ProtocolRef(attributes.getValue("ref"));
            if (this.currentEGLBinding != null) {
                this.currentEGLBinding.setProtocol(protocol);
            } else if (this.currentNativeBinding != null) {
                this.currentNativeBinding.setProtocol(protocol);
            }
        } else if (localName.equals("protocol.local")) {
            ProtocolLOCAL protocol = new ProtocolLOCAL(attributes.getValue("name"));
            if (this.currentEGLBinding != null) {
                this.currentEGLBinding.setProtocol(protocol);
            } else {
                this.bindings.addProtocol(protocol);
            }
        } else if (localName.equals("protocol.cicseci")) {
            ProtocolCICSECI protocol = new ProtocolCICSECI(attributes.getValue("name"), attributes.getValue("conversionTable"), attributes.getValue("ctgLocation"), attributes.getValue("ctgPort"), attributes.getValue("location"), attributes.getValue("serverID"));
            if (this.currentEGLBinding != null) {
                this.currentEGLBinding.setProtocol(protocol);
            } else {
                this.bindings.addProtocol(protocol);
            }
        } else if (localName.equals("protocol.cicsssl")) {
            ProtocolCICSSSL protocol = new ProtocolCICSSSL(attributes.getValue("name"), attributes.getValue("conversionTable"), attributes.getValue("ctgLocation"), attributes.getValue("ctgPort"), attributes.getValue("location"), attributes.getValue("serverID"), attributes.getValue("ctgKeyStore"), attributes.getValue("ctgKeyStorePassword"));
            if (this.currentEGLBinding != null) {
                this.currentEGLBinding.setProtocol(protocol);
            } else {
                this.bindings.addProtocol(protocol);
            }
        } else if (localName.equals("protocol.cicsj2c")) {
            ProtocolCICSJ2C protocol = new ProtocolCICSJ2C(attributes.getValue("name"), attributes.getValue("conversionTable"), attributes.getValue("location"));
            if (this.currentEGLBinding != null) {
                this.currentEGLBinding.setProtocol(protocol);
            } else {
                this.bindings.addProtocol(protocol);
            }
        } else if (localName.equals("protocol.java400")) {
            ProtocolJAVA400 protocol = new ProtocolJAVA400(attributes.getValue("name"), attributes.getValue("library"), attributes.getValue("location"), attributes.getValue("conversionTable"), attributes.getValue("password"), attributes.getValue("userID"));
            if (this.currentEGLBinding != null) {
                this.currentEGLBinding.setProtocol(protocol);
            } else if (this.currentNativeBinding != null) {
                this.currentNativeBinding.setProtocol(protocol);
            } else {
                this.bindings.addProtocol(protocol);
            }
        } else if (localName.equals("protocol.tcpip")) {
            ProtocolTCPIP protocol = new ProtocolTCPIP(attributes.getValue("name"), attributes.getValue("location"), attributes.getValue("serverID"));
            if (this.currentEGLBinding != null) {
                this.currentEGLBinding.setProtocol(protocol);
            } else {
                this.bindings.addProtocol(protocol);
            }
        } else if (localName.equals("protocol.java400j2c")) {
            ProtocolJAVA400J2C protocol = new ProtocolJAVA400J2C(attributes.getValue("name"), attributes.getValue("libraries"), attributes.getValue("currentLibrary"), attributes.getValue("location"), attributes.getValue("conversionTable"), attributes.getValue("password"), attributes.getValue("userID"));
            if (this.currentEGLBinding != null) {
                this.currentEGLBinding.setProtocol(protocol);
            } else if (this.currentNativeBinding != null) {
                this.currentNativeBinding.setProtocol(protocol);
            } else {
                this.bindings.addProtocol(protocol);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("eglBinding")) {
            this.currentEGLBinding = null;
        } else if (localName.equals("nativeBinding")) {
            this.currentNativeBinding = null;
        }
    }
}

