/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet;

import eglx.http.HttpRequest;
import eglx.http.HttpResponse;
import eglx.http.HttpUtilities;
import eglx.json.JsonUtilities;
import eglx.services.ServiceKind;
import eglx.services.ServiceUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.json.ParseException;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.resources.RunUnitBase;
import org.eclipse.edt.javart.resources.StartupInfo;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.services.servlet.ServletUtilities;
import org.eclipse.edt.javart.services.servlet.proxy.RuiBrowserHttpRequest;

public abstract class Servlet
extends HttpServlet
implements javax.servlet.Servlet {
    private static final long serialVersionUID = 10L;
    private static final String EGL_HTTP_SESSION_ID_KEY = "egl.gateway.session.id";
    private ExecutableBase program;
    private Trace tracer;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected Trace tracer() {
        if (this.tracer == null) {
            this.tracer = this.program()._runUnit().getTrace();
        }
        return this.tracer;
    }

    protected abstract String programName();

    protected ExecutableBase program() {
        if (this.program == null) {
            try {
                this.program = new ExecutableBase(new RunUnitBase(new StartupInfo(this.programName(), "", true))){
                    private static final long serialVersionUID = 10L;
                };
            }
            catch (JavartException javartException) {}
        }
        return this.program;
    }

    protected void trace(String msg) {
        if (this.tracer().traceIsOn(1)) {
            this.tracer().put(msg);
        }
    }

    protected void doPost(HttpServletRequest httpServletReq, HttpServletResponse httpServletRes) throws ServletException, IOException {
        this.doHttp(httpServletReq, httpServletRes);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doHttp(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doHttp(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doHttp(req, resp);
    }

    private void doHttp(HttpServletRequest httpServletReq, HttpServletResponse httpServletRes) {
        HttpSession session = httpServletReq.getSession();
        this.trace("HttpServletRequest.getContextPath():" + httpServletReq.getContextPath());
        this.trace("HttpServletRequest.getPathInfo():" + httpServletReq.getPathInfo());
        String url = null;
        ServiceKind serviceKind = null;
        RuiBrowserHttpRequest xmlRequest = null;
        HttpResponse outerResponse = null;
        try {
            this.trace(String.valueOf(this.programName()) + " sessionId:" + (session == null ? "null" : session.getId()));
            xmlRequest = RuiBrowserHttpRequest.createNewRequest(httpServletReq);
            if (xmlRequest != null) {
                url = xmlRequest.getURL();
                if (this.tracer().traceIsOn(1)) {
                    this.tracer().put("REQUEST:");
                    this.tracer().put("    URL:" + url != null ? url : "null");
                    this.tracer().put("    content:" + xmlRequest.getContent() != null ? xmlRequest.getContent() : "null");
                    this.tracer().put("    httpMethod:" + xmlRequest.getMethod() != null ? xmlRequest.getMethod() : "null");
                }
                outerResponse = this.processRequest(url, xmlRequest, ServletUtilities.createHttpRequest(this.program(), xmlRequest.getContent()));
            }
        }
        catch (Throwable t) {
            outerResponse = this.buildResponse(this.program(), httpServletReq.getRequestURL().toString(), t, xmlRequest != null && xmlRequest.getContent() != null ? xmlRequest.getContent() : "", serviceKind);
        }
        String content = outerResponse.getBody();
        this.log(content, outerResponse);
        String sessionId = (String)outerResponse.getHeaders().get(EGL_HTTP_SESSION_ID_KEY);
        if (sessionId != null) {
            httpServletRes.setHeader(EGL_HTTP_SESSION_ID_KEY, sessionId);
        }
        this.write(httpServletRes, content, outerResponse.getStatus());
    }

    protected abstract HttpResponse processRequest(String var1, RuiBrowserHttpRequest var2, HttpRequest var3) throws Exception;

    private HttpResponse buildResponse(ExecutableBase program, String url, Throwable t, String requestContent, ServiceKind serviceKind) {
        HttpResponse outerResponse = new HttpResponse();
        JavartException jrte = t instanceof ParseException ? ServiceUtilities.buildServiceInvocationException(program, "EGL1546E", new String[]{requestContent}, t, serviceKind) : (t instanceof IOException ? ServiceUtilities.buildServiceInvocationException(program, "EGL1539E", new String[]{url}, t, serviceKind) : ServiceUtilities.buildServiceInvocationException(program, "EGL1538E", new Object[0], t, serviceKind));
        HttpResponse innerResponse = new HttpResponse();
        ServletUtilities.setBody(this.program(), innerResponse, jrte);
        innerResponse.setStatus(500);
        innerResponse.setStatusMessage("FAILED");
        ServletUtilities.setBody(this.program(), outerResponse, innerResponse);
        outerResponse.setStatus(200);
        outerResponse.setStatusMessage("OK");
        return outerResponse;
    }

    private void log(String content, HttpResponse response) {
    }

    private void write(HttpServletResponse httpServletRes, String content, int status) {
        block5: {
            try {
                httpServletRes.setContentType(HttpUtilities.getContentType("text"));
                if (status == 200) {
                    PrintWriter pw = httpServletRes.getWriter();
                    pw.write(content);
                    pw.flush();
                    httpServletRes.setStatus(status);
                    httpServletRes.flushBuffer();
                    break block5;
                }
                try {
                    httpServletRes.setHeader(JsonUtilities.JSON_RPC_ERROR_NAME_VALUE, URLEncoder.encode(content, ServiceUtilities.UTF8));
                }
                catch (Exception exception) {}
                httpServletRes.sendError(status);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }
}

