/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import egl.lang.EDictionary;
import eglx.http.HttpRequest;
import eglx.http.HttpResponse;
import eglx.http.HttpUtilities;
import eglx.json.JsonUtilities;
import eglx.services.ServiceKind;
import eglx.services.ServiceUtilities;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.services.servlet.ServletUtilities;
import org.eclipse.edt.javart.util.JavartUtil;

public class HttpServiceHandler {
    private ExecutableBase program;
    private static final String USE_CONTENT_TYPE_CHARSET = "useContentTypeCharset";
    private static final String RESPONSE_CHARSET_PROPERTY_KEY = "com.ibm.egl.service.rest.invocation.response.charset";
    private static final String SESSION_ID = "JSESSIONID";
    private static final String EGL_SESSION_ID = "egl_statefulsessionid";
    private static final String COOKIE_ID = "SET-COOKIE";

    HttpServiceHandler(ExecutableBase program) {
        this.program = program;
    }

    HttpResponse invokeRestService(HttpRequest restRequest, HttpURLConnection connection) throws InterruptedException, Exception {
        HttpResponse response;
        EDictionary headers = restRequest.getHeaders();
        try {
            response = new HttpResponse();
            try {
                connection.setRequestMethod(HttpUtilities.httpMethodToString(restRequest.getMethod()));
                Trace tracer = this.program._runUnit().getTrace();
                if (tracer.traceIsOn(1)) {
                    tracer.put("REST request URL:" + restRequest.getUri());
                }
                for (Map.Entry entry : headers.entrySet()) {
                    connection.setRequestProperty((String)entry.getKey(), entry.getValue().toString());
                }
                byte[] resource = restRequest.getBody().getBytes(ServiceUtilities.UTF8);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                long startTime = System.currentTimeMillis();
                if (resource != null && resource.length > 0) {
                    connection.setDoOutput(true);
                    DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                    os.write(resource, 0, resource.length);
                    os.flush();
                    os.close();
                }
                HttpStreamReader httpsr = new HttpStreamReader(connection);
                Future<?> threadResult = JavartUtil.getThreadPool().submit(httpsr);
                Thread.yield();
                if (!httpsr.isDoneReading()) {
                    long expireTime = -1L;
                    boolean infinite = true;
                    try {
                        expireTime = Integer.parseInt((String)headers.get("EGL_TIMEOUT"));
                        expireTime += System.currentTimeMillis();
                        infinite = false;
                    }
                    catch (Exception exception) {}
                    while (!httpsr.isDoneReading() && (infinite || expireTime > System.currentTimeMillis())) {
                        Thread.sleep(50L);
                    }
                    if (!httpsr.isDoneReading()) {
                        threadResult.cancel(true);
                        httpsr.close();
                        connection.disconnect();
                        connection = null;
                        String message = JavartUtil.errorMessage(this.program, "EGL1547E", (Object[])new String[]{restRequest.getUri()});
                        throw new IOException(message);
                    }
                    if (httpsr.exception()) {
                        throw httpsr.getException();
                    }
                }
                if (tracer.traceIsOn(1)) {
                    tracer.put("Service response time:" + String.valueOf(System.currentTimeMillis() - startTime));
                }
                response.setBody(httpsr.getReadValue());
                response.setStatus(connection.getResponseCode());
                response.setStatusMessage(connection.getResponseMessage());
                Map<String, List<String>> header = connection.getHeaderFields();
                if (header != null) {
                    this.populate(response, header);
                    this.setServiceSessionId(response, header, headers.get(EGL_SESSION_ID));
                }
            }
            catch (IOException ioe) {
                boolean bodyIsSet;
                block27: {
                    boolean useConnection = false;
                    try {
                        useConnection = connection != null && connection.getResponseCode() != -1;
                    }
                    catch (Throwable throwable) {}
                    bodyIsSet = false;
                    if (useConnection) {
                        try {
                            response.setStatus(connection.getResponseCode());
                            response.setStatusMessage(connection.getResponseMessage());
                            String eglException = connection.getHeaderField(JsonUtilities.JSON_RPC_ERROR_NAME_VALUE);
                            if (eglException == null) break block27;
                            try {
                                eglException = URLDecoder.decode(eglException, ServiceUtilities.UTF8);
                                response.setBody(eglException);
                                bodyIsSet = true;
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (IOException iOException) {
                            response.setStatus(500);
                            response.setStatusMessage("FAILED");
                        }
                    } else {
                        response.setStatus(500);
                        response.setStatusMessage("FAILED");
                    }
                }
                if (!bodyIsSet) {
                    ServletUtilities.setBody(this.program, response, ServiceUtilities.buildServiceInvocationException(this.program, "EGL1539E", new String[]{restRequest.getUri()}, ioe, ServiceKind.REST));
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    private void populate(HttpResponse response, Map<String, List<String>> header) {
        for (Map.Entry<String, List<String>> entry : header.entrySet()) {
            response.getHeaders().put(entry.getKey() == null ? null : entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
    }

    private void setServiceSessionId(HttpResponse response, Map<String, List<String>> header, Object sessionKey) {
        if (sessionKey == null || sessionKey instanceof String && ((String)sessionKey).length() == 0) {
            sessionKey = SESSION_ID;
        }
        for (Map.Entry<String, List<String>> entry : header.entrySet()) {
            String sessionId;
            if (!(entry.getKey() instanceof String) || !entry.getKey().equalsIgnoreCase(COOKIE_ID) || (sessionId = this.getSessionId(entry.getValue(), sessionKey.toString())) == null) continue;
            response.getHeaders().put(EGL_SESSION_ID, sessionId);
            break;
        }
    }

    private String getSessionId(Object value, String sessionKey) {
        String str;
        block3: {
            block4: {
                str = null;
                if (!(value instanceof Collection)) break block4;
                Iterator itr = ((Collection)value).iterator();
                while (itr.hasNext()) {
                    str = this.getSessionId(itr.next(), sessionKey);
                    if (str == null) {
                        continue;
                    }
                    break block3;
                }
                break block3;
            }
            if (!(value instanceof String) || ((String)value).indexOf(sessionKey) <= -1) break block3;
            StringTokenizer subStrings = new StringTokenizer((String)value, ";");
            while (subStrings.hasMoreElements()) {
                String id = subStrings.nextToken();
                if (id.indexOf(sessionKey) <= -1) continue;
                str = (String)value;
                break;
            }
        }
        return str;
    }

    private String getResponseCharset(ExecutableBase program) {
        return program._runUnit().getProperties().get(RESPONSE_CHARSET_PROPERTY_KEY);
    }

    private class HttpStreamReader
    implements Runnable {
        private URLConnection connection;
        private InputStream is;
        private boolean doneReading;
        private String value;
        private Exception e;
        BufferedReader reader;

        public HttpStreamReader(URLConnection connection) {
            this.connection = connection;
            this.doneReading = false;
        }

        @Override
        public void run() {
            block19: {
                this.e = null;
                StringBuilder body = new StringBuilder();
                this.reader = null;
                try {
                    try {
                        this.is = this.connection.getInputStream();
                        String responseCharset = HttpServiceHandler.this.getResponseCharset(HttpServiceHandler.this.program);
                        if (responseCharset != null && responseCharset.length() > 0) {
                            try {
                                int idx;
                                String contentType;
                                if (HttpServiceHandler.USE_CONTENT_TYPE_CHARSET.equalsIgnoreCase(responseCharset) && (contentType = this.connection.getContentType()) != null && (idx = contentType.toLowerCase().indexOf("charset=")) != -1) {
                                    responseCharset = contentType.substring(idx + 8);
                                }
                                this.reader = new BufferedReader(new InputStreamReader(this.is, responseCharset));
                            }
                            catch (Throwable throwable) {}
                        }
                        if (this.reader == null) {
                            this.reader = new BufferedReader(new InputStreamReader(this.is, ServiceUtilities.UTF8));
                        }
                        int charCnt = 0;
                        int nRead = this.reader.read();
                        while (charCnt < Integer.MAX_VALUE && nRead != -1) {
                            body.append((char)nRead);
                            nRead = this.reader.read();
                            ++charCnt;
                        }
                        this.value = body.toString();
                    }
                    catch (Exception e) {
                        this.e = e;
                        if (this.reader == null) break block19;
                        try {
                            this.reader.close();
                        }
                        catch (IOException iOException) {}
                        this.reader = null;
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (this.reader != null) {
                        try {
                            this.reader.close();
                        }
                        catch (IOException iOException) {}
                        this.reader = null;
                    }
                    throw throwable;
                }
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {}
                    this.reader = null;
                }
            }
            this.doneReading = true;
        }

        public void close() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
                this.reader = null;
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
                this.is = null;
            }
        }

        public boolean exception() {
            return this.e != null;
        }

        public boolean isDoneReading() {
            return this.doneReading;
        }

        public String getReadValue() {
            return this.value;
        }

        public Exception getException() {
            return this.e;
        }
    }
}

