/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import eglx.http.HttpRequest;
import eglx.http.HttpResponse;
import eglx.services.Encoding;
import eglx.services.ServiceKind;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.services.servlet.ServletUtilities;
import org.eclipse.edt.javart.services.servlet.proxy.RuiBrowserHttpRequest;
import org.eclipse.edt.javart.services.servlet.proxy.ServiceInvoker;

public class LocalServiceInvoker
extends ServiceInvoker {
    private long elapseTime;

    public LocalServiceInvoker(ExecutableBase program) {
        super(program);
    }

    @Override
    HttpResponse invoke(RuiBrowserHttpRequest ruiRequest, HttpRequest innerRequest) throws Exception {
        if (this.trace()) {
            this.tracer().put("Dedicated service.");
        }
        String ruiRequestBody = ruiRequest.getContent();
        HttpResponse innerResponse = new HttpResponse();
        HttpRequest request = ServletUtilities.createHttpRequest(this.program(), ruiRequestBody);
        this.traceElapsedTime(true);
        ServiceInvoker.FunctionInfo info = this.getFunctionInfo(Encoding.JSON, Encoding.JSON, request.getBody());
        if (this.trace()) {
            this.tracer().put("  invoking function " + info != null && info.getFunctionName() != null ? info.getFunctionName() : "null");
        }
        String result = this.wrapperProxyReturn(this.invokeEglService(info));
        this.traceElapsedTime(false);
        if (this.trace()) {
            this.tracer().put("return data from dedicated service:" + result == null ? "null" : result);
        }
        innerResponse.setBody(result);
        boolean failed = this.resultContainsError(result);
        innerResponse.setStatus(failed ? 500 : 200);
        innerResponse.setStatusMessage(failed ? "FAILED" : "OK");
        return innerResponse;
    }

    private String wrapperProxyReturn(Object returnVal) {
        return returnVal == null ? "{}" : returnVal.toString();
    }

    protected void traceElapsedTime(boolean start) {
        if (start) {
            this.elapseTime = System.currentTimeMillis();
        } else {
            this.elapseTime = System.currentTimeMillis() - this.elapseTime;
            if (this.trace()) {
                this.tracer().put("Service response time:" + String.valueOf(this.elapseTime));
            }
        }
    }

    protected boolean resultContainsError(String result) {
        return result.indexOf("{\"error\" : {") != -1;
    }

    @Override
    ServiceKind getServiceKind(HttpRequest innerRequest) {
        return ServiceKind.EGL;
    }
}

