/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import eglx.http.HttpRequest;
import eglx.http.HttpResponse;
import eglx.services.ServiceBindingException;
import eglx.services.ServiceInvocationException;
import eglx.services.ServiceUtilities;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.services.servlet.ServletUtilities;
import org.eclipse.edt.javart.services.servlet.proxy.HttpServiceInvoker;
import org.eclipse.edt.javart.services.servlet.proxy.Invoker;
import org.eclipse.edt.javart.services.servlet.proxy.LocalServiceInvoker;
import org.eclipse.edt.javart.services.servlet.proxy.ProxyUtilities;
import org.eclipse.edt.javart.services.servlet.proxy.RuiBrowserHttpRequest;

public class ProxyEventHandler {
    private ExecutableBase program;
    private Trace tracer;

    public ProxyEventHandler(ExecutableBase program) {
        this.program = program;
    }

    protected ExecutableBase program() {
        return this.program;
    }

    /*
     * Loose catch block
     */
    public HttpResponse runProxy(String urlString, RuiBrowserHttpRequest ruiRequest, HttpRequest innerRequest) {
        HttpResponse outerResponse;
        block15: {
            if (this.trace()) {
                this.tracer.put(" Request URL:" + ruiRequest.getURL() + " method:" + ruiRequest.getMethod() + " header:" + ProxyUtilities.convert(ruiRequest.getHeaders()) + " content:" + ruiRequest.getContent());
            }
            Invoker invoker = null;
            if (urlString.indexOf("___proxy") != -1 && ProxyUtilities.isEGLDedicatedCall(innerRequest)) {
                invoker = new LocalServiceInvoker(this.program());
            } else if (urlString.indexOf("___proxy") != -1) {
                invoker = new HttpServiceInvoker(this.program);
            }
            outerResponse = new HttpResponse();
            if (invoker != null) {
                HttpResponse innerResponse = null;
                try {
                    innerResponse = invoker.invoke(ruiRequest, innerRequest);
                }
                catch (ServiceBindingException sbe) {
                    outerResponse.setStatus(500);
                    outerResponse.setStatusMessage("FAILED");
                    ServletUtilities.setBody(this.program(), outerResponse, sbe);
                    outerResponse.setStatus(200);
                    outerResponse.setStatusMessage("OK");
                    ServletUtilities.setBody(this.program(), outerResponse, innerResponse);
                    break block15;
                }
                catch (ServiceInvocationException sie) {
                    innerResponse.setStatus(500);
                    innerResponse.setStatusMessage("FAILED");
                    ServletUtilities.setBody(this.program(), innerResponse, sie);
                    break block15;
                }
                catch (Throwable t) {
                    ServletUtilities.setBody(this.program(), innerResponse, ServiceUtilities.buildServiceInvocationException(this.program(), "EGL1538E", new Object[0], t, invoker.getServiceKind(innerRequest)));
                    innerResponse.setStatus(500);
                    innerResponse.setStatusMessage("FAILED");
                    outerResponse.setStatus(200);
                    outerResponse.setStatusMessage("OK");
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    ServletUtilities.setBody(this.program(), outerResponse, innerResponse);
                    break block15;
                }
                {
                    finally {
                        outerResponse.setStatus(200);
                        outerResponse.setStatusMessage("OK");
                        ServletUtilities.setBody(this.program(), outerResponse, innerResponse);
                    }
                }
                outerResponse.setStatus(200);
                outerResponse.setStatusMessage("OK");
                ServletUtilities.setBody(this.program(), outerResponse, innerResponse);
            }
        }
        if (this.trace()) {
            this.tracer.put(" Response Status:" + String.valueOf(outerResponse.getStatus()) + " status msg:" + outerResponse.getStatusMessage() + " header:" + ProxyUtilities.convert(outerResponse.getHeaders()) + " body:" + outerResponse.getBody());
        }
        return outerResponse;
    }

    private Trace tracer() {
        if (this.tracer == null) {
            this.tracer = this.program()._runUnit().getTrace();
        }
        return this.tracer;
    }

    private boolean trace() {
        return this.tracer().traceIsOn(1);
    }
}

