/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import egl.lang.EDictionary;
import eglx.http.HttpRequest;
import java.util.Map;

class ProxyUtilities {
    private static final String EGL_DEDICATED_CALL = "EGLDEDICATED";
    public static final String EGL_SOAP_CALL = "EGLSOAP";

    private ProxyUtilities() {
    }

    static boolean isEGLDedicatedCall(HttpRequest innerRequest) {
        EDictionary headers = innerRequest.getHeaders();
        return headers != null && headers.containsKey(EGL_DEDICATED_CALL);
    }

    static String convert(Map<?, ?> map) {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() != null) {
                buffer.append(entry.getKey().toString());
                buffer.append(':');
            }
            if (entry.getValue() instanceof Map) {
                buffer.append('(');
                buffer.append(ProxyUtilities.convert((Map)entry.getValue()));
                buffer.append(')');
            } else if (entry.getValue() != null) {
                buffer.append(entry.getValue().toString());
            }
            buffer.append(' ');
        }
        return buffer.toString();
    }

    static boolean isSoapCall(HttpRequest innerRequest) {
        EDictionary headers = innerRequest.getHeaders();
        return headers != null && headers.containsKey(EGL_SOAP_CALL);
    }
}

