/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import eglx.json.JsonUtilities;
import eglx.services.Encoding;
import eglx.services.ServiceInvocationException;
import eglx.services.ServiceKind;
import eglx.services.ServiceUtilities;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.json.ArrayNode;
import org.eclipse.edt.javart.json.JsonParser;
import org.eclipse.edt.javart.json.ObjectNode;
import org.eclipse.edt.javart.json.ParseException;
import org.eclipse.edt.javart.json.StringNode;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.services.ServiceReference;
import org.eclipse.edt.javart.services.bindings.Binding;
import org.eclipse.edt.javart.services.bindings.EGLBinding;
import org.eclipse.edt.javart.services.bindings.ProtocolLOCAL;
import org.eclipse.edt.javart.services.bindings.WebBinding;
import org.eclipse.edt.javart.services.servlet.proxy.Invoker;

public abstract class ServiceInvoker
extends Invoker {
    public static final String REST_SERVICE_SESSION_ID = "com.ibm.javart.services.Rest.restfulService.session";
    private static String EGL_PARAMETER_ORDER = "EGL_PARAMETER_ORDER";
    private static final int ENCODING_JSON = 0;
    private static final int ENCODING_XML = 1;
    public static String JSON_RPC_BINDINGNAME_ID = "bindingName";
    public static String JSON_RPC_METHOD_ID = "method";
    public static String JSON_RPC_PARAMETER_ID = "params";
    public static String JSON_RPC_RESULT_ID = "result";
    private String userId;
    private String password;
    private int timeout = -1;

    ServiceInvoker(ExecutableBase program) {
        super(program);
    }

    FunctionInfo getFunctionInfo(Encoding inEncoding, Encoding outEncoding, String body, EGLBinding binding) {
        JsonFunctionInfo info = null;
        if (inEncoding.equals(0)) {
            info = new JsonFunctionInfo(body, outEncoding);
            info.setBinding(binding);
        }
        return info;
    }

    FunctionInfo getFunctionInfo(Encoding inEncoding, Encoding outEncoding, String body) {
        JsonFunctionInfo info = null;
        if (inEncoding.equals(0)) {
            info = new JsonFunctionInfo(body, outEncoding);
            this.setFomBindingNode(info);
        }
        return info;
    }

    private void setFomBindingNode(FunctionInfo info) {
        Binding binding = null;
        ObjectNode bindingNode = (ObjectNode)org.eclipse.edt.javart.json.JsonUtilities.getValueNode((ObjectNode)info.parsedObject(), org.eclipse.edt.javart.json.JsonUtilities.BINDING_ID, new ObjectNode());
        String name = org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.BINDING_NAME_ID, new StringNode("", false)).toJava().trim();
        if (bindingNode != null) {
            String bindingType = org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.BINDING_TYPE_ID, new StringNode("webbinding", false)).toJava();
            if (bindingType.equalsIgnoreCase(org.eclipse.edt.javart.json.JsonUtilities.BINDING_WEBTYPE_ID)) {
                String interfaceName = org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.WEB_BINDING_INTERFACE_ID, new StringNode("", false)).toJava();
                if (name == null || name.length() == 0) {
                    int partNameIdx = interfaceName.lastIndexOf(".") + 1;
                    name = partNameIdx == 0 ? interfaceName : interfaceName.substring(partNameIdx);
                }
                binding = new WebBinding(name, interfaceName, org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.WEB_BINDING_WSDL_LOCATION_ID, new StringNode("", false)).toJava(), org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.WEB_BINDING_WSDL_PORT_ID, new StringNode("", false)).toJava(), org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.WEB_BINDING_WSDL_SERVICE_ID, new StringNode("", false)).toJava(), org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.WEB_BINDING_URI_ID, new StringNode("", false)).toJava());
            } else if (bindingType.equalsIgnoreCase(org.eclipse.edt.javart.json.JsonUtilities.BINDING_EGLTYPE_ID)) {
                binding = new EGLBinding(org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.BINDING_NAME_ID, new StringNode("", false)).toJava(), org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.EGL_BINDING_SERVICE_NAME_ID, new StringNode("", false)).toJava(), org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.EGL_BINDING_ALIAS_ID, new StringNode("", false)).toJava());
                String protocol = org.eclipse.edt.javart.json.JsonUtilities.getValueNode(bindingNode, org.eclipse.edt.javart.json.JsonUtilities.PROTOCOL_ID, new StringNode("", false)).toJava();
                if (protocol.equalsIgnoreCase(org.eclipse.edt.javart.json.JsonUtilities.PROTOCOL_LOCAL_ID)) {
                    binding.setProtocol(new ProtocolLOCAL(""));
                }
            }
        }
        info.setBinding(binding);
    }

    public String invokeEglService(FunctionInfo info) throws ServiceInvocationException {
        String returnVal = null;
        ExecutableBase program = this.program();
        try {
            this.getServiceReference(info);
            if ("eze_endStatefulServiceSession".equalsIgnoreCase(info.getFunctionName())) {
                this.endSession(this.program()._runUnit());
                returnVal = "{}";
            }
        }
        catch (ServiceInvocationException sie) {
            throw sie;
        }
        catch (Throwable t) {
            JavartException sie = info == null ? ServiceUtilities.buildServiceInvocationException(program, "EGL1540E", new String[]{"unknown", "unknown"}, t, ServiceKind.REST) : ServiceUtilities.buildServiceInvocationException(program, "EGL1540E", new String[]{info.getBinding().getName(), info.getFunctionName()}, t, ServiceKind.REST);
            if (sie instanceof ServiceInvocationException) {
                throw (ServiceInvocationException)sie;
            }
            returnVal = JsonUtilities.createJsonJavartException(program, sie);
        }
        return returnVal;
    }

    protected ServiceReference getServiceReference(FunctionInfo info) throws Exception {
        return null;
    }

    protected void setSession(RunUnit runUnit) {
    }

    protected void endSession(RunUnit runUnit) {
    }

    protected void removeSession(RunUnit runUnit) {
    }

    public String invokeRestService(String className, String functionName, int inEncoding, int outEncoding, String body) {
        String returnVal = null;
        try {
            Object response = null;
            if (response != null) {
                returnVal = "{}";
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    private ObjectNode getJsonParameters(String body) {
        ObjectNode payload;
        try {
            payload = JsonParser.parse(body);
        }
        catch (ParseException parseException) {
            payload = new ObjectNode();
        }
        return payload;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected abstract class FunctionInfo {
        protected String body;
        protected String serviceName;
        protected String serviceAlias;
        protected Object parsedObject;
        protected String parameterOrder;
        protected String functionName;
        protected Object jsParameters;
        protected Binding binding;
        protected Encoding outEncoding;

        FunctionInfo(String body, Encoding outEncoding) {
            this.body = body;
            this.outEncoding = outEncoding;
        }

        FunctionInfo(String body, String serviceName, String serviceAlias) {
            this.body = body;
            this.serviceName = serviceName;
            this.serviceAlias = serviceAlias;
        }

        protected abstract Object parsedObject();

        protected String getFunctionName() {
            this.functionName = org.eclipse.edt.javart.json.JsonUtilities.getValueNode((ObjectNode)this.parsedObject(), JSON_RPC_METHOD_ID, new StringNode("", false)).toJava();
            return this.functionName;
        }

        protected abstract Object getJsParameters();

        protected Binding getBinding() {
            return this.binding;
        }

        protected void setBinding(Binding binding) {
            this.binding = binding;
        }

        protected abstract String getParameterOrder();
    }

    private class JsonFunctionInfo
    extends FunctionInfo {
        JsonFunctionInfo(String body, Encoding outEncoding) {
            super(body, outEncoding);
        }

        @Override
        protected Object parsedObject() {
            if (this.parsedObject == null) {
                this.parsedObject = ServiceInvoker.this.getJsonParameters(this.body);
            }
            return this.parsedObject;
        }

        @Override
        protected String getParameterOrder() {
            if (this.parameterOrder == null) {
                this.parameterOrder = org.eclipse.edt.javart.json.JsonUtilities.getValueNode((ObjectNode)this.parsedObject(), EGL_PARAMETER_ORDER, new StringNode("", false)).toJava();
            }
            return this.parameterOrder;
        }

        @Override
        protected Object getJsParameters() {
            if (this.jsParameters == null) {
                this.jsParameters = (ArrayNode)org.eclipse.edt.javart.json.JsonUtilities.getValueNode((ObjectNode)this.parsedObject(), JSON_RPC_PARAMETER_ID, new ArrayNode());
            }
            return this.jsParameters;
        }
    }
}

