/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.rest.rpc;

import eglx.services.Encoding;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

class RestServiceProjectInfo
implements Serializable {
    private static final long serialVersionUID = 10L;
    private String contextRoot;
    private URL[] classpath;
    private Map<String, Map<Integer, Map<String, ServiceFunctionInfo>>> httpMethods;

    private static String encoding(Encoding encoding) {
        if (Encoding.XML.equals((Object)encoding)) {
            return "Encoding.XML";
        }
        if (Encoding.JSON.equals((Object)encoding)) {
            return "Encoding.JSON";
        }
        if (Encoding.NONE.equals((Object)encoding)) {
            return "Encoding.NONE";
        }
        if (Encoding._FORM.equals((Object)encoding)) {
            return "Encoding._FORM";
        }
        return "Encoding.USE_CONTENTTYPE";
    }

    RestServiceProjectInfo(String contextRoot, URL[] classpath) {
        this.classpath = classpath;
        this.httpMethods = new HashMap<String, Map<Integer, Map<String, ServiceFunctionInfo>>>();
        this.contextRoot = contextRoot;
    }

    String getContextRoot() {
        return this.contextRoot;
    }

    URL[] getClasspath() {
        return this.classpath;
    }

    void setClasspath(URL[] classpath) {
        this.classpath = classpath;
    }

    private static Map<Integer, Map<String, ServiceFunctionInfo>> httpMethod(RestServiceProjectInfo projectInfo, String httpMethodName) {
        Map<Integer, Map<String, ServiceFunctionInfo>> httpMethodMap = projectInfo.httpMethods.get(httpMethodName.toLowerCase());
        if (httpMethodMap == null) {
            httpMethodMap = new HashMap<Integer, Map<String, ServiceFunctionInfo>>();
            projectInfo.httpMethods.put(httpMethodName.toLowerCase(), httpMethodMap);
        }
        return httpMethodMap;
    }

    private static void addURI(String uri, Map<Integer, Map<String, ServiceFunctionInfo>> httpMethodMap, ServiceFunctionInfo serviceFunction) {
        StringTokenizer tokens = new StringTokenizer(uri, "/");
        Integer tokenCount = tokens.countTokens();
        Map<String, ServiceFunctionInfo> uris = httpMethodMap.get(tokenCount);
        if (uris == null) {
            uris = new HashMap<String, ServiceFunctionInfo>();
            httpMethodMap.put(tokenCount, uris);
        }
        uris.put(uri.toLowerCase(), serviceFunction);
    }

    void addURI(String uri, String httpMethodName, String className, boolean isStatefulService, boolean isHostProgramService, String eglFunction, String inEncoding, String outEncoding) {
        RestServiceProjectInfo restServiceProjectInfo = this;
        restServiceProjectInfo.getClass();
        ServiceFunctionInfo serviceFunctionInfo = restServiceProjectInfo.new ServiceFunctionInfo(uri, className, isStatefulService, isHostProgramService, eglFunction, this.convertEncoding(inEncoding), this.convertEncoding(outEncoding));
        Map<Integer, Map<String, ServiceFunctionInfo>> httpMethodMap = RestServiceProjectInfo.httpMethod(this, httpMethodName);
        RestServiceProjectInfo.addURI(uri, httpMethodMap, serviceFunctionInfo);
    }

    private Encoding convertEncoding(String encoding) {
        Encoding retEncoding = String.valueOf((Object)Encoding.XML).equals(encoding) ? Encoding.XML : (String.valueOf((Object)Encoding.JSON).equals(encoding) ? Encoding.JSON : (String.valueOf((Object)Encoding.NONE).equals(encoding) ? Encoding.NONE : (String.valueOf((Object)Encoding._FORM).equals(encoding) ? Encoding._FORM : Encoding.USE_CONTENTTYPE)));
        return retEncoding;
    }

    ServiceFunctionInfo getServiceFunctionInfo(String uri, String httpMethodName) {
        ServiceFunctionInfo serviceFunction;
        StringTokenizer tokens;
        Integer tokenCount;
        Map<String, ServiceFunctionInfo> uris;
        ServiceFunctionInfo serviceFunctionInfo = null;
        Map<Integer, Map<String, ServiceFunctionInfo>> httpMethodMap = this.httpMethods.get(httpMethodName.toLowerCase());
        if (httpMethodMap != null && (uris = httpMethodMap.get(tokenCount = Integer.valueOf((tokens = new StringTokenizer(uri, "/")).countTokens()))) != null && (serviceFunction = uris.get(uri.toLowerCase())) != null) {
            serviceFunctionInfo = serviceFunction;
        }
        return serviceFunctionInfo;
    }

    public String toString() {
        String indent = "    ";
        String returnVal = "ContextRoot:" + this.contextRoot + "\n";
        if (this.classpath != null && this.classpath.length > 0) {
            returnVal = String.valueOf(returnVal) + indent + "Classpath:";
            int idx = 0;
            while (idx < this.classpath.length) {
                if (idx > 1) {
                    returnVal = String.valueOf(returnVal) + ';';
                }
                returnVal = String.valueOf(returnVal) + this.classpath[idx].toString();
                ++idx;
            }
            returnVal = String.valueOf(returnVal) + '\n';
        }
        returnVal = String.valueOf(returnVal) + RestServiceProjectInfo.methodsToString(this.httpMethods, String.valueOf(indent) + "    ");
        return returnVal;
    }

    private static String methodsToString(Map<String, Map<Integer, Map<String, ServiceFunctionInfo>>> httpMethods, String indent) {
        String returnVal = "";
        for (Map.Entry<String, Map<Integer, Map<String, ServiceFunctionInfo>>> methodMapEntry : httpMethods.entrySet()) {
            returnVal = String.valueOf(returnVal) + "HTTP Method:" + methodMapEntry.getKey() + '\n';
            returnVal = String.valueOf(returnVal) + RestServiceProjectInfo.urisToString(methodMapEntry.getValue(), String.valueOf(indent) + "    ");
        }
        return returnVal;
    }

    private static String urisToString(Map<Integer, Map<String, ServiceFunctionInfo>> urisMap, String indent) {
        String returnVal = "";
        for (Map<String, ServiceFunctionInfo> uris : urisMap.values()) {
            for (Map.Entry<String, ServiceFunctionInfo> uriFunction : uris.entrySet()) {
                returnVal = String.valueOf(returnVal) + indent + uriFunction.getValue().toString() + '\n';
            }
        }
        return returnVal;
    }

    class ServiceFunctionInfo
    implements Serializable {
        private static final long serialVersionUID = 75L;
        private String className;
        private String uri;
        private String functionName;
        private Encoding inEncoding;
        private Encoding outEncoding;
        private boolean isStatefulService;
        private boolean isHostProgramService;

        ServiceFunctionInfo(String uri, String className, boolean isStatefulService, boolean isHostProgramService, String functionName, Encoding inEncoding, Encoding outEncoding) {
            this.className = className;
            this.uri = uri;
            this.functionName = functionName;
            this.inEncoding = inEncoding;
            this.outEncoding = outEncoding;
            this.isStatefulService = isStatefulService;
            this.isHostProgramService = isHostProgramService;
        }

        String getClassName() {
            return this.className;
        }

        String getFunctionName() {
            return this.functionName;
        }

        Encoding getInEncoding() {
            return this.inEncoding;
        }

        Encoding getOutEncoding() {
            return this.outEncoding;
        }

        public boolean isStatefulService() {
            return this.isStatefulService;
        }

        public String toString() {
            return String.valueOf(this.uri) + " - " + this.className + '.' + this.functionName + " inEncoding:" + RestServiceProjectInfo.encoding(this.inEncoding) + " outEncoding:" + RestServiceProjectInfo.encoding(this.outEncoding) + (this.isStatefulService ? " stateful" : "");
        }

        boolean isHostProgramService() {
            return this.isHostProgramService;
        }
    }
}

