/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.rest.rpc;

import eglx.http.HttpRequest;
import eglx.http.HttpResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.eclipse.edt.javart.services.servlet.Servlet;
import org.eclipse.edt.javart.services.servlet.proxy.RuiBrowserHttpRequest;
import org.eclipse.edt.javart.services.servlet.rest.rpc.RestRpcUtilities;
import org.eclipse.edt.javart.services.servlet.rest.rpc.RestServiceProjectInfo;

public class ServiceServlet
extends Servlet {
    private static final long serialVersionUID = 10L;
    static final String SERVICE_SERVLET = "EGL REST Service servlet";
    private static final String URIXML_ID = "urixml";
    private String urixml;
    private RestServiceProjectInfo restServiceProjectInfo;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.urixml = config.getInitParameter(URIXML_ID);
        this.restServiceProjectInfo = RestRpcUtilities.getRestServiceInfo(this.urixml);
        this.traceInfos();
    }

    @Override
    protected String programName() {
        return SERVICE_SERVLET;
    }

    @Override
    protected HttpResponse processRequest(String url, RuiBrowserHttpRequest xmlRequest, HttpRequest createHttpRequest) throws Exception {
        return null;
    }

    private void traceInfos() {
        if (this.tracer().traceIsOn(1)) {
            StringBuilder buf = new StringBuilder();
            String servlet = this.getContext();
            buf.append("EGL REST service servlet " + servlet + " starting" + '\n');
            buf.append(this.restServiceProjectInfo.toString());
            this.trace(buf.toString());
        }
    }

    private String getContext() {
        return this.urixml.substring(0, this.urixml.indexOf(".xml"));
    }
}

