/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import java.util.Calendar;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.JavartUtil;
import org.eclipse.edt.runtime.java.egl.lang.TypeCastException;

public class DateTimeLib
extends ExecutableBase {
    private static final long serialVersionUID = 10L;

    public DateTimeLib(RunUnit ru) throws JavartException {
        super(ru);
    }

    public static Calendar dateFromInt(Integer dateint) throws JavartException {
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis(dateint * 1000 * 86400);
        return cal;
    }

    public static Calendar dateValueFromGregorian(Integer gregorianIntDate) throws JavartException {
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.set(1, gregorianIntDate / 10000);
        cal.set(2, gregorianIntDate % 10000 / 100 - 1);
        cal.set(5, gregorianIntDate % 100);
        try {
            cal.get(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String message = JavartUtil.errorMessage(null, "EGL0117E", new Object[]{"DateTimeLib.dateValueFromJulian", String.valueOf(gregorianIntDate)});
            throw new TypeCastException("EGL0101E", message);
        }
        return cal;
    }

    public static Calendar dateValueFromJulian(Integer julianIntDate) throws JavartException {
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.add(1, 1);
        cal.set(1, julianIntDate / 1000);
        cal.set(6, julianIntDate % 1000);
        try {
            cal.get(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String message = JavartUtil.errorMessage(null, "EGL0117E", new Object[]{"DateTimeLib.dateValueFromJulian", String.valueOf(julianIntDate)});
            throw new TypeCastException("EGL0101E", message);
        }
        return cal;
    }

    public static Calendar mdy(Integer month, Integer day, Integer year) throws JavartException {
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        try {
            cal.get(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String message = JavartUtil.errorMessage(null, "EGL0117E", new Object[]{"DateTimeLib.mdy", String.valueOf(month), String.valueOf(day), String.valueOf(year)});
            throw new TypeCastException("EGL0101E", message);
        }
        return cal;
    }
}

