/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import egl.lang.AnyNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.runtime.java.egl.lang.EDecimal;
import org.eclipse.edt.runtime.java.egl.lang.EString;
import org.eclipse.edt.runtime.java.egl.lang.EglAny;
import org.eclipse.edt.runtime.java.egl.lang.NullValueException;

public class EInt
extends AnyBoxedObject<Integer>
implements AnyNumber {
    private static final long serialVersionUID = 10L;
    private static final int DefaultValue = 0;
    private static final int Precision = 9;

    private EInt(Integer value) {
        super(value);
    }

    public static EInt ezeBox(Integer value) {
        return new EInt(value);
    }

    public static Integer ezeCast(Object value) throws JavartException {
        return (Integer)EglAny.ezeCast(value, "asInt", EInt.class, null, null);
    }

    public static boolean ezeIsa(Object value) {
        return value instanceof EInt;
    }

    public static Integer asInt(Short value) throws JavartException {
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public static Integer asInt(Integer value) throws JavartException {
        if (value == null) {
            return null;
        }
        return (int)value;
    }

    public static Integer asInt(Long value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        int result = 0;
        result = throwOverflowExceptions ? BigDecimal.valueOf(value).intValueExact() : Long.valueOf(value).intValue();
        return result;
    }

    public static Integer asInt(BigInteger value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        int result = 0;
        result = throwOverflowExceptions ? new BigDecimal(value).intValueExact() : value.intValue();
        return result;
    }

    public static Integer asInt(Float value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        int result = 0;
        result = throwOverflowExceptions ? BigDecimal.valueOf(value.floatValue()).intValueExact() : value.intValue();
        return result;
    }

    public static Integer asInt(Double value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        int result = 0;
        result = throwOverflowExceptions ? BigDecimal.valueOf(value).intValueExact() : value.intValue();
        return result;
    }

    public static Integer asInt(BigDecimal value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        int result = 0;
        result = throwOverflowExceptions ? value.intValueExact() : value.intValue();
        return result;
    }

    public static Integer asInt(String value, Integer ... length) throws JavartException {
        if (value == null) {
            return null;
        }
        return EInt.asInt(EDecimal.asDecimal(EString.asString(value, length), new Integer[0]));
    }

    public static BigDecimal asNumber(Integer value) throws JavartException {
        if (value == null) {
            return null;
        }
        return EDecimal.asDecimal(value, new Integer[0]);
    }

    public static int defaultValue() {
        return 0;
    }

    public static int precision() {
        return 9;
    }

    public static Integer plus(Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            return null;
        }
        return BigDecimal.valueOf((long)op1.intValue() + (long)op2.intValue()).intValueExact();
    }

    public static Integer minus(Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            return null;
        }
        return BigDecimal.valueOf((long)op1.intValue() - (long)op2.intValue()).intValueExact();
    }

    public static BigDecimal divide(Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            return null;
        }
        return BigDecimal.valueOf(op1.intValue()).divide(BigDecimal.valueOf(op2.intValue()), 32, 4);
    }

    public static Integer multiply(Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            return null;
        }
        return BigDecimal.valueOf((long)op1.intValue() * (long)op2.intValue()).intValueExact();
    }

    public static Integer remainder(Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            return null;
        }
        return op1 % op2;
    }

    public static Double power(Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            return null;
        }
        return StrictMath.pow(op1.intValue(), op2.intValue());
    }

    public static int compareTo(Integer op1, Integer op2) throws JavartException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        if (op1 != null && op2 == null || op1 == null && op2 != null) {
            throw new NullValueException();
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Integer op1, Integer op2) {
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.equals(op2);
    }

    public static boolean notEquals(Integer op1, Integer op2) {
        if (op1 == null || op2 == null) {
            return false;
        }
        return !op1.equals(op2);
    }
}

