/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.regex.PatternSyntaxException;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.JavartDateFormat;
import org.eclipse.edt.runtime.java.egl.lang.EDecimal;
import org.eclipse.edt.runtime.java.egl.lang.EglAny;
import org.eclipse.edt.runtime.java.egl.lang.IndexOutOfBoundsException;
import org.eclipse.edt.runtime.java.egl.lang.InvalidPatternException;
import org.eclipse.edt.runtime.java.egl.lang.TimestampFormatException;

public class EString
extends AnyBoxedObject<String> {
    private static final long serialVersionUID = 10L;
    protected static final String DefaultValue = "";
    private int maxLength;

    public int getLength() {
        return this.maxLength;
    }

    private EString(String value) {
        super(value);
        this.maxLength = -1;
    }

    private EString(String value, int length) {
        super(value);
        this.maxLength = length;
    }

    public static EString ezeBox(String value) {
        return new EString(value);
    }

    public static EString ezeBox(String value, int length) {
        return new EString(value, length);
    }

    public static String ezeCast(Object value, Integer ... args) throws JavartException {
        return (String)EglAny.ezeCast(value, "asString", EString.class, new Class[]{Integer[].class}, args);
    }

    public static boolean ezeIsa(Object value, Integer ... length) {
        boolean isa = value instanceof EString;
        if (isa && length.length != 0) {
            isa = ((EString)value).getLength() == length[0].intValue();
        }
        return isa;
    }

    public static String asString(Boolean value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(Short value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(Integer value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(Long value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(Float value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(Double value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(BigDecimal value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(String value, Integer ... length) {
        if (length.length != 0 && value.length() > length[0]) {
            value = value.substring(0, length[0]);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String asString(Calendar value, Integer ... length) {
        String format = "yyyy-MM-dd HH:mm:ss.SSSSSS";
        boolean reset = false;
        byte[] byArray = DateTimeUtil.LOCK;
        synchronized (DateTimeUtil.LOCK) {
            JavartDateFormat formatter = DateTimeUtil.getDateFormat(format);
            int micros = value.get(14) * 1000;
            if (micros < 0) {
                reset = true;
                value.add(13, -1);
                micros += 1000000;
            }
            formatter.setCentury(value.get(1) / 100 + 1);
            formatter.setMicrosecond(micros);
            try {
                String string = EString.asString(formatter.format(value.getTime()), length);
                // ** MonitorExit[byArray] (shouldn't be in output)
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new TimestampFormatException();
            }
            finally {
                if (reset) {
                    value.add(13, 1);
                }
            }
        }
    }

    public static BigDecimal asNumber(String value, Integer ... length) throws JavartException {
        if (value == null) {
            return null;
        }
        return EDecimal.asDecimal(EString.asString(value, length), new Integer[0]);
    }

    public static String plus(String op1, String op2) throws JavartException {
        return EString.concat(op1, op2);
    }

    public static String concat(String op1, String op2) throws JavartException {
        if (op1 == null) {
            op1 = DefaultValue;
        }
        if (op2 == null) {
            op2 = DefaultValue;
        }
        return String.valueOf(op1) + op2;
    }

    public static String concatNull(String op1, String op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        return String.valueOf(op1) + op2;
    }

    public static boolean equals(String op1, String op2) throws JavartException {
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.equals(op2);
    }

    public static boolean notEquals(String op1, String op2) throws JavartException {
        if (op1 == null || op2 == null) {
            return false;
        }
        return !op1.equals(op2);
    }

    public static String substring(String str, Integer startIndex, Integer endIndex) throws JavartException {
        if (str == null || startIndex == null || endIndex == null) {
            return null;
        }
        int start = startIndex;
        int end = endIndex;
        int max = str.length();
        if (start < 1 || start > max) {
            IndexOutOfBoundsException ex = new IndexOutOfBoundsException();
            ex.indexValue = start;
            throw ex;
        }
        if (end < start || end < 1 || end > max) {
            IndexOutOfBoundsException ex = new IndexOutOfBoundsException();
            ex.indexValue = end;
            throw ex;
        }
        return str.substring(start - 1, end);
    }

    public static Integer length(String source, Integer ... length) {
        return EString.asString(source, length).length();
    }

    public static String trim(String source, Integer ... length) {
        return EString.clip(EString.clipLeading(EString.asString(source, length), new Integer[0]), new Integer[0]);
    }

    public static String clipLeading(String source, Integer ... length) {
        String value = EString.asString(source, length);
        int lth = value.length();
        if (lth > 0) {
            int startingIdx = 0;
            boolean charsDeleted = false;
            while (startingIdx < lth) {
                char c = value.charAt(startingIdx);
                if (c > ' ' && c != '\u3000') break;
                charsDeleted = true;
                ++startingIdx;
            }
            if (charsDeleted) {
                return value.substring(startingIdx, lth);
            }
        }
        return value;
    }

    public static String clip(String source, Integer ... length) {
        String value = EString.asString(source, length);
        int lth = value.length();
        if (lth > 0) {
            int startingIdx = lth - 1;
            boolean charsDeleted = false;
            while (startingIdx >= 0) {
                char c = value.charAt(startingIdx);
                if (c > ' ' && c != '\u3000') break;
                charsDeleted = true;
                --startingIdx;
            }
            if (charsDeleted) {
                return value.substring(0, startingIdx + 1);
            }
        }
        return value;
    }

    public static String toLowerCase(String source, Integer ... length) {
        return EString.asString(source, length).toLowerCase();
    }

    public static String toUpperCase(String source, Integer ... length) {
        return EString.asString(source, length).toUpperCase();
    }

    public static Boolean startsWith(String source, String value) {
        return source.startsWith(value);
    }

    public static Boolean startsWith(String source, Integer length, String value) {
        return EString.asString(source, length).startsWith(value);
    }

    public static Boolean endsWith(String source, String value) {
        return source.endsWith(value);
    }

    public static Boolean endsWith(String source, Integer length, String value) {
        return EString.asString(source, length).endsWith(value);
    }

    public static Integer indexOf(String source, String value) {
        return source.indexOf(value);
    }

    public static Integer indexOf(String source, Integer length, String value) {
        return EString.asString(source, length).indexOf(value);
    }

    public static Integer indexOf(String source, String value, Integer start) {
        return source.indexOf(value, (int)start);
    }

    public static Integer indexOf(String source, Integer length, String value, Integer start) {
        return EString.asString(source, length).indexOf(value, (int)start);
    }

    public static Integer lastIndexOf(String source, String value) {
        return source.lastIndexOf(value);
    }

    public static Integer lastIndexOf(String source, Integer length, String value) {
        return EString.asString(source, length).lastIndexOf(value);
    }

    public static String replaceStr(String source, String search, String replacement) {
        return source.replace(search, replacement);
    }

    public static String replaceStr(String source, Integer length, String search, String replacement) {
        return EString.asString(source, length).replace(search, replacement);
    }

    public static Integer charCodeAt(String source, Integer index) {
        return source.charAt(index);
    }

    public static Integer charCodeAt(String source, Integer length, Integer index) {
        return EString.asString(source, length).charAt(index);
    }

    public static Boolean isLike(String source, String pattern) {
        return EString.isLike(source, pattern, "\\");
    }

    public static Boolean isLike(String source, String pattern, String escape) {
        if (source == null || pattern == null || escape == null) {
            return false;
        }
        char escapeChar = escape.length() > 0 ? (char)escape.charAt(0) : (char)'\\';
        String escapeThese = "$[]^{}+|?().*";
        StringBuilder regex = new StringBuilder();
        source = EString.clip(source, new Integer[0]);
        pattern = EString.clip(pattern, new Integer[0]);
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch == '\\' && escapeChar != '\\') {
                regex.append("\\\\");
            } else if (ch == escapeChar) {
                char nch = pattern.charAt(i + 1);
                if (nch == '_' || nch == '%') {
                    regex.append(nch);
                } else if (nch == escapeChar) {
                    if (escapeChar == '\\' || escapeThese.indexOf(escapeChar) != -1) {
                        regex.append('\\');
                    }
                    regex.append(escapeChar);
                } else if (escapeChar == '\\') {
                    regex.append("\\" + nch);
                } else {
                    regex.append(nch);
                }
                ++i;
            } else if (ch == '%') {
                regex.append(".*");
            } else if (ch == '_') {
                regex.append('.');
            } else if (escapeThese.indexOf(ch) != -1) {
                regex.append("\\" + ch);
            } else {
                regex.append(ch);
            }
            ++i;
        }
        try {
            return source.matches(regex.toString());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new InvalidPatternException();
        }
    }

    public static Boolean matchesPattern(String source, String pattern) {
        return EString.matchesPattern(source, pattern, "\\");
    }

    public static Boolean matchesPattern(String source, String pattern, String escape) {
        if (source == null || pattern == null || escape == null) {
            return false;
        }
        char escapeChar = escape.length() > 0 ? (char)escape.charAt(0) : (char)'\\';
        String escapeThese = "${}+|&().";
        StringBuilder regex = new StringBuilder();
        boolean withinBrackets = false;
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch == '\\' && escapeChar != '\\') {
                regex.append("\\\\");
            } else if (ch == escapeChar) {
                char nch = pattern.charAt(i + 1);
                if (nch == '*' || nch == '?' || nch == '[' || nch == ']' || nch == '^') {
                    regex.append("\\" + nch);
                } else if (nch == escapeChar) {
                    if (escapeChar == '\\' || escapeThese.indexOf(escapeChar) != -1) {
                        regex.append('\\');
                    }
                    regex.append(escapeChar);
                } else if (escapeChar == '\\') {
                    regex.append("\\" + nch);
                } else {
                    regex.append(nch);
                }
                ++i;
            } else if (ch == '[') {
                withinBrackets = true;
                regex.append(ch);
            } else if (ch == ']') {
                withinBrackets = false;
                regex.append(ch);
            } else if (ch == '*' && !withinBrackets) {
                regex.append(".*");
            } else if (ch == '?' && !withinBrackets) {
                regex.append('.');
            } else if (ch == '^' && !withinBrackets) {
                regex.append("\\^");
            } else if (escapeThese.indexOf(ch) != -1) {
                regex.append("\\" + ch);
            } else {
                regex.append(ch);
            }
            ++i;
        }
        if (withinBrackets) {
            int pos = regex.lastIndexOf("[");
            regex.insert(pos, '\\');
            if (pos + 2 < regex.length() && regex.charAt(pos + 2) == '^') {
                regex.insert(pos + 2, '\\');
            }
        }
        try {
            return source.matches(regex.toString());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new InvalidPatternException();
        }
    }
}

