/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.resources.ExecutableBase;

public class MathLib
extends ExecutableBase {
    private static final long serialVersionUID = 10L;
    private static final double LOG_OF_10 = 2.302585092994046;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final int DOUBLE_MANTISSA_LENGTH = 52;
    private static final long DOUBLE_NO_EXPONENT_MASK = -9218868437227405313L;
    private static final int DOUBLE_MAX_EXPONENT = 2046;
    private static final int DOUBLE_EXPONENT_BIAS = 1022;
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_ZERO_EXPONENT = 4602678819172646912L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final int INT_PRECISION = 9;
    private static final int SHORT_PRECISION = 4;
    private static final int LONG_PRECISION = 18;
    private static final int FLOAT_PRECISION = 6;
    private static final int DOUBLE_PRECISION = 15;

    public MathLib(RunUnit ru) throws JavartException {
        super(ru);
    }

    public static Short abs(Short numericField) {
        if (numericField < 0) {
            return new Short((short)(0 - numericField));
        }
        return numericField;
    }

    public static Integer abs(Integer numericField) {
        if (numericField < 0) {
            return new Integer(0 - numericField);
        }
        return numericField;
    }

    public static Long abs(Long numericField) {
        if (numericField < 0L) {
            return new Long(0L - numericField);
        }
        return numericField;
    }

    public static Double abs(Double numericField) {
        return StrictMath.abs(numericField);
    }

    public static Double abs(Float numericField) {
        return StrictMath.abs(numericField.doubleValue());
    }

    public static BigDecimal abs(BigDecimal numericField) {
        return numericField.abs();
    }

    public static Double acos(Double numericField) throws JavartException {
        if (numericField < -1.0 || numericField > 1.0) {
            return Double.NaN;
        }
        return StrictMath.acos(numericField);
    }

    public static Double asin(Double numericField) throws JavartException {
        if (numericField < -1.0 || numericField > 1.0) {
            return Double.NaN;
        }
        return StrictMath.asin(numericField);
    }

    public static Double atan(Double numericField) throws JavartException {
        return StrictMath.atan(numericField);
    }

    public static Double atan2(Double numericField1, Double numericField2) {
        return StrictMath.atan2(numericField1, numericField2);
    }

    public static Double ceiling(Double numericField) {
        return StrictMath.ceil(numericField);
    }

    public static BigDecimal ceiling(BigDecimal numericField) {
        return numericField.setScale(0, 2);
    }

    public static Double cos(Double numericField) {
        return StrictMath.cos(numericField);
    }

    public static Double cosh(Double numericField) throws JavartException {
        return StrictMath.cosh(numericField);
    }

    public static int decimals(BigDecimal numericField) {
        return numericField.scale();
    }

    public static Double exp(Double numericField) {
        return StrictMath.exp(numericField);
    }

    public static Double floor(Double numericField) {
        return StrictMath.floor(numericField);
    }

    public static BigDecimal floor(BigDecimal numericField) {
        return numericField.setScale(0, 3);
    }

    public static Double frexp(Double numericField, AnyBoxedObject<Integer> exponent) throws JavartException {
        double value = numericField;
        long bits = Double.doubleToLongBits(numericField);
        int exp = (int)((bits & 0x7FF0000000000000L) >> 52);
        if (exp > 0 && exp <= 2046) {
            exponent.ezeCopy(exp -= 1022);
            long mantissa = bits & 0x800FFFFFFFFFFFFFL;
            value = Double.longBitsToDouble(mantissa |= 0x3FE0000000000000L);
        } else {
            exponent.ezeCopy(0);
        }
        return value;
    }

    public static Double ldexp(Double numericField, Integer pow) throws JavartException {
        double value = numericField;
        long bits = Double.doubleToLongBits(value);
        long exp = (bits & 0x7FF0000000000000L) >> 52;
        bits &= 0x800FFFFFFFFFFFFFL;
        if ((exp += (long)pow.intValue()) < 0L || exp > 2046L) {
            return Double.NaN;
        }
        return Double.longBitsToDouble(bits |= exp << 52);
    }

    public static Double log(Double numericField) throws JavartException {
        if (numericField <= 0.0) {
            return Double.NaN;
        }
        return StrictMath.log(numericField);
    }

    public static Double log10(Double numericField) throws JavartException {
        if (numericField <= 0.0) {
            return Double.NaN;
        }
        return StrictMath.log(numericField) / 2.302585092994046;
    }

    public static Short max(Short numericField1, Short numericField2) {
        if (numericField1 < numericField2) {
            return numericField2;
        }
        return numericField1;
    }

    public static Integer max(Integer numericField1, Integer numericField2) {
        if (numericField1 < numericField2) {
            return numericField2;
        }
        return numericField1;
    }

    public static Long max(Long numericField1, Long numericField2) {
        if (numericField1 < numericField2) {
            return numericField2;
        }
        return numericField1;
    }

    public static Double max(Double numericField1, Double numericField2) {
        return StrictMath.max(numericField1, numericField2);
    }

    public static Float max(Float numericField1, Float numericField2) {
        return Float.valueOf(StrictMath.max(numericField1.floatValue(), numericField2.floatValue()));
    }

    public static BigDecimal max(BigDecimal numericField1, BigDecimal numericField2) {
        return numericField1.max(numericField2);
    }

    public static Short min(Short numericField1, Short numericField2) {
        if (numericField1 < numericField2) {
            return numericField1;
        }
        return numericField2;
    }

    public static Integer min(Integer numericField1, Integer numericField2) {
        if (numericField1 < numericField2) {
            return numericField1;
        }
        return numericField2;
    }

    public static Long min(Long numericField1, Long numericField2) {
        if (numericField1 < numericField2) {
            return numericField1;
        }
        return numericField2;
    }

    public static Double min(Double numericField1, Double numericField2) {
        return StrictMath.min(numericField1, numericField2);
    }

    public static Float min(Float numericField1, Float numericField2) {
        return Float.valueOf(StrictMath.min(numericField1.floatValue(), numericField2.floatValue()));
    }

    public static BigDecimal min(BigDecimal numericField1, BigDecimal numericField2) {
        return numericField1.min(numericField2);
    }

    public static Double modf(Double numericField1, AnyBoxedObject<Long> numericField2) throws JavartException {
        BigDecimal bd = new BigDecimal(numericField1);
        BigInteger intPart = bd.toBigInteger();
        BigDecimal fractPart = new BigDecimal(intPart).subtract(bd).negate();
        numericField2.ezeCopy(intPart.longValue());
        return fractPart.doubleValue();
    }

    public static Double pow(Double op1, Double op2) throws JavartException {
        if (op1 == 0.0 && op2 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (op1 < 0.0 && op2 > StrictMath.floor(op2)) {
            return Double.NaN;
        }
        return StrictMath.pow(op1, op2);
    }

    public static int precision(Short numericField) {
        return 4;
    }

    public static int precision(Integer numericField) {
        return 9;
    }

    public static int precision(Long numericField) {
        return 18;
    }

    public static int precision(Float numericField) {
        return 6;
    }

    public static int precision(Double numericField) {
        return 15;
    }

    public static int precision(BigDecimal numericField) {
        return numericField.precision() - numericField.scale();
    }

    public static Float random() {
        return new Float(Math.random());
    }

    public static Float round(Float value, Integer exp) {
        BigDecimal rounder;
        if (exp > 0) {
            rounder = BigDecimal.valueOf(5L);
            rounder = rounder.movePointRight(exp - 1);
        } else {
            rounder = BigDecimal.valueOf(5L, -exp.intValue() + 1);
        }
        value = value.floatValue() >= 0.0f ? Float.valueOf(value.floatValue() + rounder.floatValue()) : Float.valueOf(value.floatValue() - rounder.floatValue());
        value = new Float(Math.pow(value.floatValue(), -exp.intValue()));
        value = new Float(value.longValue());
        value = new Float(Math.pow(value.floatValue(), exp.intValue()));
        return value;
    }

    public static Double round(Double value, Integer exp) {
        BigDecimal rounder;
        if (exp > 0) {
            rounder = BigDecimal.valueOf(5L);
            rounder = rounder.movePointRight(exp - 1);
        } else {
            rounder = BigDecimal.valueOf(5L, -exp.intValue() + 1);
        }
        value = value >= 0.0 ? Double.valueOf(value + (double)rounder.floatValue()) : Double.valueOf(value - (double)rounder.floatValue());
        value = new Double(Math.pow(value, -exp.intValue()));
        value = new Double(value.longValue());
        value = new Double(Math.pow(value, exp.intValue()));
        return value;
    }

    public static BigDecimal round(BigDecimal value, Integer exp) {
        BigDecimal rounder;
        if (exp > 0) {
            rounder = BigDecimal.valueOf(5L);
            rounder = rounder.movePointRight(exp - 1);
        } else {
            rounder = BigDecimal.valueOf(5L, -exp.intValue() + 1);
        }
        value = value.signum() >= 0 ? value.add(rounder) : value.subtract(rounder);
        if (exp > 0) {
            value = value.movePointLeft(exp);
            value = new BigDecimal(value.toBigInteger());
            value = value.movePointRight(exp);
        } else {
            value = value.movePointRight(-exp.intValue());
            value = new BigDecimal(value.toBigInteger());
            value = value.movePointLeft(-exp.intValue());
        }
        return value;
    }

    public static Double sin(Double numericField) {
        return StrictMath.sin(numericField);
    }

    public static Double sinh(Double numericField) throws JavartException {
        return StrictMath.sinh(numericField);
    }

    public static Double sqrt(Double numericField) throws JavartException {
        if (numericField < 0.0) {
            return Double.NaN;
        }
        return StrictMath.sqrt(numericField);
    }

    public static Double tan(Double numericField) {
        return StrictMath.tan(numericField);
    }

    public static Double tanh(Double numericField) throws JavartException {
        return StrictMath.tanh(numericField);
    }
}

