/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.TimestampData;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.JavartDateFormat;
import org.eclipse.edt.javart.util.JavartUtil;
import org.eclipse.edt.javart.util.NumberFormatter;
import org.eclipse.edt.runtime.java.egl.lang.IndexOutOfBoundsException;

public class StrLib
extends ExecutableBase {
    private static final long serialVersionUID = 10L;
    public static String defaultTimeStampFormat;

    public StrLib(RunUnit ru) throws JavartException {
        super(ru);
    }

    public static String format(RunUnit ru, BigDecimal number, String format) {
        return NumberFormatter.fmtNum(number, format, ru.getLocalizedText());
    }

    public static String format(RunUnit ru, Short number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number.shortValue()), format, ru.getLocalizedText());
    }

    public static String format(RunUnit ru, Integer number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number), format, ru.getLocalizedText());
    }

    public static String format(RunUnit ru, Long number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number), format, ru.getLocalizedText());
    }

    public static String format(RunUnit ru, Float number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number.floatValue()), format, ru.getLocalizedText());
    }

    public static String format(RunUnit ru, Double number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number), format, ru.getLocalizedText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(RunUnit ru, Calendar timestampValue, String timestampFormat) {
        if (timestampValue == null) {
            return null;
        }
        String format = timestampFormat;
        if (format.length() == 0) {
            format = defaultTimeStampFormat;
        }
        TimestampData data = new TimestampData(timestampValue, 0);
        boolean reset = false;
        int micros = data.microseconds;
        if (micros < 0) {
            reset = true;
            data.calendar.add(13, -1);
            micros += 1000000;
        }
        try {
            int century = data.calendar.get(1) / 100 + 1;
            Date date = data.calendar.getTime();
            byte[] byArray = DateTimeUtil.LOCK;
            synchronized (DateTimeUtil.LOCK) {
                JavartDateFormat formatter = DateTimeUtil.getDateFormat(format);
                formatter.setCentury(century);
                formatter.setMicrosecond(micros);
                String string = formatter.format(date);
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return string;
            }
        }
        finally {
            if (reset) {
                data.calendar.add(13, 1);
            }
        }
    }

    public static String getNextToken(String source, AnyBoxedObject<Integer> index, String delimiters) throws JavartException {
        int start = index.ezeUnbox();
        byte[] sourceBytes = source.getBytes();
        if (start < 1 || start > sourceBytes.length) {
            JavartUtil.errorMessage(null, "EGL0117E", new Object[]{"StrLib.getNextToken", String.valueOf(start)});
            throw new IndexOutOfBoundsException();
        }
        int tokenStart = start - 1;
        int searchEnd = sourceBytes.length;
        byte[] delimiterBytes = delimiters.getBytes();
        while (tokenStart != searchEnd && StrLib.indexOf(sourceBytes[tokenStart], delimiterBytes) != -1) {
            ++tokenStart;
        }
        if (tokenStart >= searchEnd) {
            return null;
        }
        int tokenEnd = tokenStart + 1;
        while (tokenEnd != searchEnd && StrLib.indexOf(sourceBytes[tokenEnd], delimiterBytes) == -1) {
            ++tokenEnd;
        }
        index.ezeCopy(tokenEnd + 1);
        int tokenLength = tokenEnd - tokenStart;
        byte[] tokenData = new byte[tokenLength];
        System.arraycopy(sourceBytes, tokenStart, tokenData, 0, tokenLength);
        return tokenData.toString();
    }

    private static int indexOf(byte b, byte[] data) {
        int i = 0;
        while (i < data.length) {
            if (data[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getTokenCount(String source, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(source, delimiters);
        return tokenizer.countTokens();
    }

    public static String fromCharCode(Character character) {
        return Character.toString(character.charValue());
    }

    public static String spaces(Integer characterCount) {
        String retVal;
        if (characterCount <= 0) {
            retVal = "";
        } else if (characterCount < 50) {
            retVal = "                                                  ".substring(0, characterCount);
        } else {
            StringBuilder buf = new StringBuilder(characterCount);
            buf.append("                                                  ");
            while (characterCount >= 50) {
                buf.append("                                                  ");
                characterCount = characterCount - 50;
            }
            if (characterCount > 0) {
                buf.append("                                                  ".substring(0, characterCount));
            }
            retVal = buf.toString();
        }
        return retVal;
    }
}

