/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import egl.lang.EglList;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;
import org.eclipse.edt.javart.EglException;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.resources.Platform;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.util.JavartUtil;
import org.eclipse.edt.runtime.java.egl.lang.RuntimeException;

public class SysLib
extends ExecutableBase {
    private static final long serialVersionUID = 10L;
    private static transient PrintWriter outputStream = null;
    public EglException currentException = null;

    public SysLib(RunUnit ru) throws JavartException {
        super(ru);
    }

    public static String getProperty(RunUnit ru, String propertyName) {
        String value = ru.getProperties().get(propertyName.trim());
        if (value == null) {
            value = System.getProperty(propertyName.trim());
        }
        return value;
    }

    public static void wait(BigDecimal time) {
        time = time.movePointRight(2);
        time = new BigDecimal(BigInteger.valueOf(time.longValue()));
        try {
            Thread.sleep(time.longValue() * 10L);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void startLog(String filename) throws JavartException {
        try {
            outputStream = new PrintWriter((Writer)new BufferedWriter(new FileWriter(filename, true)), true);
        }
        catch (IOException e) {
            JavartUtil.throwRuntimeException("EGL0117E", JavartUtil.errorMessage(null, "EGL0117E", new Object[]{"SysLib.startLog", e}), null);
        }
    }

    public static void errorLog(RunUnit ru, String errorMsg) {
        if (outputStream == null) {
            return;
        }
        outputStream.println(ru.getLocalizedText().getDateFormatter().format(new Date()));
        outputStream.println(errorMsg);
    }

    public static boolean _errorLogIsOn() {
        return outputStream != null;
    }

    public static void callCmd(String commandString) throws JavartException {
        SysLib.runCommand(commandString, true, true);
    }

    public static void startCmd(String commandString) throws JavartException {
        SysLib.runCommand(commandString, true, true);
    }

    private static void runCommand(String commandString, boolean lineMode, boolean wait) throws JavartException {
        Process proc;
        try {
            proc = Platform.SYSTEM_TYPE == "WIN     " ? Runtime.getRuntime().exec(new String[]{"cmd", "/c", commandString}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", commandString});
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (wait) {
            new Thread(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getErrorStream();
                    try {
                        while (inputStream.read() != -1) {
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getInputStream();
                    try {
                        while (inputStream.read() != -1) {
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            try {
                proc.waitFor();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static String getMessage(RunUnit ru, String key) {
        return SysLib.getMessage(ru, key, null);
    }

    public static String getMessage(RunUnit ru, String key, EglList<String> inserts) {
        Object[] insertStrings = null;
        if (inserts != null) {
            insertStrings = new String[inserts.size()];
            int i = 0;
            while (i < insertStrings.length) {
                insertStrings[i] = (String)inserts.get(i);
                ++i;
            }
        }
        key = key.trim();
        String message = ru.getLocalizedText().getMessage(key, insertStrings);
        return message;
    }

    public static void commit(RunUnit ru) throws JavartException {
        block13: {
            RuntimeException errorException = null;
            Trace trace = ru.getTrace();
            boolean tracing = trace.traceIsOn(1);
            try {
                try {
                    if (tracing) {
                        trace.put("commit()");
                        trace.put("    committing Recoverable Resources ...");
                    }
                    ru.commit();
                }
                catch (JavartException jx) {
                    String message = JavartUtil.errorMessage(null, "EGL0117E", new Object[]{"SysLib.commit", jx.getMessage()});
                    errorException = new RuntimeException("EGL0117E", message);
                    if (errorException == null) {
                        if (tracing) {
                            trace.put("<-- commit()   rc = 0");
                        }
                        break block13;
                    }
                    if (tracing) {
                        trace.put("<-- commit()   rc <> 0 ");
                    }
                    throw errorException;
                }
            }
            finally {
                if (errorException == null) {
                    if (tracing) {
                        trace.put("<-- commit()   rc = 0");
                    }
                } else {
                    if (tracing) {
                        trace.put("<-- commit()   rc <> 0 ");
                    }
                    throw errorException;
                }
            }
        }
    }

    public static void rollback(RunUnit ru) throws JavartException {
        block13: {
            RuntimeException errorException = null;
            Trace trace = ru.getTrace();
            boolean tracing = trace.traceIsOn(1);
            try {
                try {
                    if (tracing) {
                        trace.put("rollBack()");
                        trace.put("    resetting Recoverable Resources ...");
                    }
                    ru.rollback();
                }
                catch (JavartException jx) {
                    String message = JavartUtil.errorMessage(null, "EGL0117E", new Object[]{"SysLib.rollBack", jx.getMessage()});
                    errorException = new RuntimeException("EGL0117E", message);
                    if (errorException == null) {
                        if (tracing) {
                            trace.put("<-- rollBack()   rc = 0");
                        }
                        break block13;
                    }
                    if (tracing) {
                        trace.put("<-- rollBack()   rc <> 0");
                    }
                    throw errorException;
                }
            }
            finally {
                if (errorException == null) {
                    if (tracing) {
                        trace.put("<-- rollBack()   rc = 0");
                    }
                } else {
                    if (tracing) {
                        trace.put("<-- rollBack()   rc <> 0");
                    }
                    throw errorException;
                }
            }
        }
    }

    public static void setLocale(RunUnit ru, String languageCode) {
        Locale locale = new Locale(languageCode);
        ru.switchLocale(locale);
    }

    public static void setLocale(RunUnit ru, String languageCode, String countryCode) {
        Locale locale = new Locale(languageCode, countryCode);
        ru.switchLocale(locale);
    }

    public static void setLocale(RunUnit ru, String languageCode, String countryCode, String variant) {
        Locale locale = new Locale(languageCode, countryCode, variant);
        ru.switchLocale(locale);
    }

    public static void writeStdout(String output) {
        System.out.println(output);
    }

    public static void writeStderr(String output) {
        System.err.println(output);
    }
}

