/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.compiler.BaseCompiler;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.IGenerator;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.StatementValidator;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.osgi.framework.Bundle;

public class IDEBaseCompiler
implements IIDECompiler {
    protected ISystemEnvironment systemEnvironment;
    protected ICompiler baseCompiler = new BaseCompiler();
    protected IIDECompiler parentCompiler;
    protected String preferencePageId;

    @Override
    public void setPreferencePageId(String id) {
        this.preferencePageId = id;
    }

    @Override
    public String getPreferencePageId() {
        return this.preferencePageId;
    }

    protected String getPathToPluginDirectory(String pluginID, String subDir) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        try {
            String file = FileLocator.resolve((URL)bundle.getEntry("/")).getFile();
            file = file.replace('/', File.separatorChar);
            file = String.valueOf(file) + subDir;
            return file;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public String getSystemEnvironmentPath() {
        if (this.parentCompiler == null) {
            return this.getSystemEnvironmentPathEntry();
        }
        return String.valueOf(this.getSystemEnvironmentPathEntry()) + ";" + this.parentCompiler.getSystemEnvironmentPath();
    }

    public List<String> getAllImplicitlyUsedEnumerations() {
        return this.baseCompiler.getAllImplicitlyUsedEnumerations();
    }

    public String getId() {
        return this.baseCompiler.getId();
    }

    public void setId(String id) {
        this.baseCompiler.setId(id);
    }

    public String getName() {
        return this.baseCompiler.getName();
    }

    public void setName(String name) {
        this.baseCompiler.setName(name);
    }

    public List<IGenerator> getGenerators() {
        return this.baseCompiler.getGenerators();
    }

    public void addGenerator(IGenerator generator) {
        this.baseCompiler.addGenerator(generator);
    }

    public void setVersion(String version) {
        this.baseCompiler.setVersion(version);
    }

    public String getVersion() {
        return this.baseCompiler.getVersion();
    }

    public List<String> getImplicitlyUsedEnumerations() {
        return this.baseCompiler.getImplicitlyUsedEnumerations();
    }

    protected String getSystemEnvironmentPathEntry() {
        return this.getPathToPluginDirectory("org.eclipse.edt.mof.egl", "lib");
    }

    protected ISystemEnvironment createSystemEnvironment(IBuildNotifier notifier) {
        ISystemEnvironment parentEnv = null;
        if (this.parentCompiler != null) {
            parentEnv = this.parentCompiler.getSystemEnvironment(notifier);
        }
        return SystemEnvironmentManager.getSystemEnvironment(this.getSystemEnvironmentPathEntry(), parentEnv, this.getImplicitlyUsedEnumerations(), notifier, this);
    }

    public ISystemEnvironment getSystemEnvironment(IBuildNotifier notifier) {
        if (this.systemEnvironment == null) {
            this.systemEnvironment = this.createSystemEnvironment(notifier);
        }
        return this.systemEnvironment;
    }

    public StatementValidator getValidatorFor(Statement stmt) {
        return this.baseCompiler.getValidatorFor(stmt);
    }
}

