/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.internal.builder.AbstractMarkerProblemRequestor;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class AbstractPartMarkerProblemRequestor
extends AbstractMarkerProblemRequestor {
    protected String partName;
    private String containerContextName;

    public AbstractPartMarkerProblemRequestor(IFile file, String partName, String containerContextName) {
        super(file, "VAL");
        this.partName = partName;
        this.containerContextName = containerContextName;
    }

    @Override
    protected IMarker createMarker(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) throws CoreException {
        IMarker marker;
        if (messagesWithLineNumberInserts.contains(new Integer(problemKind))) {
            inserts = AbstractPartMarkerProblemRequestor.shiftInsertsIfNeccesary((int)problemKind, (String[])inserts);
            inserts[0] = this.containerContextName;
            int lineNumber = this.getLineNumberOfOffset(startOffset);
            inserts[inserts.length - 2] = Integer.toString(lineNumber + 1);
            inserts[inserts.length - 1] = this.file.getFullPath().toOSString();
            marker = super.createMarker(startOffset, endOffset, lineNumber, severity, problemKind, inserts);
        } else {
            marker = super.createMarker(startOffset, endOffset, severity, problemKind, inserts);
        }
        marker.setAttribute("partName", (Object)this.partName);
        return marker;
    }

    @Override
    protected boolean shouldRemoveMarker(IMarker marker) {
        String markerPartName = InternUtil.intern((String)marker.getAttribute("partName", ""));
        return markerPartName == this.partName;
    }
}

