/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.EGLIncompleteBuildPathSetting;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CancelledException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.NullBuildNotifier;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.internal.builder.AbstractMarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.BuildManager;
import org.eclipse.edt.ide.core.internal.builder.BuildNotifier;
import org.eclipse.edt.ide.core.internal.builder.BuilderResources;
import org.eclipse.edt.ide.core.internal.builder.CleanBatchBuilder;
import org.eclipse.edt.ide.core.internal.builder.DuplicatePartManager;
import org.eclipse.edt.ide.core.internal.builder.FullBatchBuilder;
import org.eclipse.edt.ide.core.internal.builder.IncrementalBuilder;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraphManager;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.ZipFileBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathManager;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;

public class Builder
extends IncrementalProjectBuilder {
    protected static final boolean DEBUG = false;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        ProjectBuildPath projBP = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject());
        IProject[] reqProjects = projBP.getRequiredProjects();
        boolean isOK = false;
        Object notifier = null;
        notifier = monitor == null ? NullBuildNotifier.getInstance() : new BuildNotifier(monitor);
        notifier.begin();
        try {
            try {
                notifier.checkCancel();
                IResourceDelta delta = this.getDelta(this.getProject());
                if (this.isWorthBuilding()) {
                    ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).clearReadOnly();
                    if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isReadOnly()) {
                        isOK = true;
                    } else if (kind == 6) {
                        this.doClean();
                        this.cleanBuild(delta, (IBuildNotifier)notifier);
                    } else if (!BuildManager.getInstance().getProjectState(this.getProject())) {
                        this.doClean();
                        this.cleanBuild(null, (IBuildNotifier)notifier);
                    } else if (BuildManager.getInstance().isFullBuildRequired(this.getProject())) {
                        this.fullBuild(delta, (IBuildNotifier)notifier);
                    } else if (this.hasEGLPathChanged()) {
                        this.doClean();
                        this.cleanBuild(null, (IBuildNotifier)notifier);
                    } else if (!projBP.getOutputLocation().exists()) {
                        this.doClean();
                        this.cleanBuild(null, (IBuildNotifier)notifier);
                    } else if (delta == null) {
                        this.doClean();
                        this.cleanBuild(delta, (IBuildNotifier)notifier);
                    } else if (this.incrementalBuild(delta, (IBuildNotifier)notifier)) {
                        this.fullBuild(null, (IBuildNotifier)notifier);
                    }
                    isOK = true;
                }
            }
            catch (CancelledException cancelledException) {
                throw new OperationCanceledException();
            }
            catch (BuildException e) {
                this.addUnhandledExceptionMarker();
                EDTCoreIDEPlugin.getPlugin().log("EDT Build Failure", (Exception)((Object)e));
                if (!isOK) {
                    BuildManager.getInstance().setProjectState(this.getProject(), false);
                } else {
                    BuildManager.getInstance().putProject(this.getProject(), projBP.getRequiredProjects(), projBP.getSourceLocations(), projBP.getOutputLocation(), ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getBuildPathEntries());
                }
                notifier.done();
            }
        }
        finally {
            if (!isOK) {
                BuildManager.getInstance().setProjectState(this.getProject(), false);
            } else {
                BuildManager.getInstance().putProject(this.getProject(), projBP.getRequiredProjects(), projBP.getSourceLocations(), projBP.getOutputLocation(), ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getBuildPathEntries());
            }
            notifier.done();
        }
        return reqProjects;
    }

    private void initializeOutputLocation(IContainer container) {
        if (!container.exists()) {
            this.createFolder(container);
        }
    }

    private void createFolder(IContainer folder) {
        if (!folder.exists()) {
            this.createFolder(folder.getParent());
            try {
                ((IFolder)folder).create(true, true, null);
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    protected void addUnhandledExceptionMarker() {
        try {
            this.deleteAllMarkers();
            IMarker marker = this.getProject().createMarker(AbstractMarkerProblemRequestor.BUILD_PROBLEM);
            marker.setAttribute("message", (Object)BuilderResources.buildUnhandledException);
            marker.setAttribute("severity", 2);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected boolean cleanBuild(IResourceDelta delta, IBuildNotifier notifier) {
        BuildManager.getInstance().setProjectState(this.getProject(), false);
        CleanBatchBuilder bb = new CleanBatchBuilder(this, notifier);
        return bb.build(delta);
    }

    protected boolean fullBuild(IResourceDelta delta, IBuildNotifier notifier) {
        BuildManager.getInstance().setProjectState(this.getProject(), false);
        FullBatchBuilder bb = new FullBatchBuilder(this, notifier);
        return bb.build(delta);
    }

    protected boolean incrementalBuild(IResourceDelta delta, IBuildNotifier notifier) {
        BuildManager.getInstance().setProjectState(this.getProject(), false);
        IncrementalBuilder ib = new IncrementalBuilder(this, notifier);
        return ib.build(delta);
    }

    protected void startupOnInitialize() {
    }

    protected void doClean() {
        this.initializeOutputLocation(ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getOutputLocation());
        ZipFileBuildPathEntryManager.getInstance().clear(this.getProject());
        DuplicatePartManager.getInstance().clear(this.getProject());
        FileInfoManager.getInstance().clear(this.getProject());
        ProjectEnvironmentManager.getInstance().clear(this.getProject());
        ProjectBuildPathEntryManager.getInstance().clear(this.getProject(), true);
        ProjectBuildPathManager.getInstance().clear(this.getProject());
        ProjectInfoManager.getInstance().clear(this.getProject());
        this.cleanOutputDir(this.getProject());
        DependencyGraphManager.getInstance().clear(this.getProject());
        BuildManager.getInstance().clear(this.getProject());
        this.deleteAllMarkers();
    }

    protected void clean(IProgressMonitor monitor) {
        try {
            this.doClean();
        }
        catch (Exception e) {
            EDTCoreIDEPlugin.getPlugin().log("EDT Clean Failure", e);
            BuildManager.getInstance().clear(this.getProject());
        }
    }

    protected void deleteAllMarkers() {
        try {
            this.getProject().deleteMarkers(AbstractMarkerProblemRequestor.PROBLEM, true, 2);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean hasEGLPathChanged() {
        String oldCompilerId;
        IContainer[] sourceLocations;
        IBuildPathEntry[] newPaths;
        IProject[] reqProjects;
        String[] entries = BuildManager.getInstance().getRequiredProjects(this.getProject());
        if (entries.length != (reqProjects = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getRequiredProjects()).length) {
            return true;
        }
        boolean allowIncompleteBuildPath = EGLIncompleteBuildPathSetting.getIncompleteBuildPathSetting() == 1;
        int i = 0;
        while (i < entries.length) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(entries[i]);
            IProject proj2 = ResourcesPlugin.getWorkspace().getRoot().getProject(reqProjects[i].getName());
            if (!proj.exists() && !allowIncompleteBuildPath) {
                return true;
            }
            if (!proj.equals((Object)proj2)) {
                return true;
            }
            ++i;
        }
        BuildManager.BuildPathEntry[] oldPaths = BuildManager.getInstance().getPathEntries(this.getProject());
        if (oldPaths.length != (newPaths = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getBuildPathEntries()).length) {
            return true;
        }
        int i2 = 0;
        while (i2 < oldPaths.length) {
            BuildManager.BuildPathEntry oldpath = oldPaths[i2];
            IBuildPathEntry newpath = newPaths[i2];
            if (oldpath.getType() == 1 && !newpath.isProject()) {
                return true;
            }
            if (oldpath.getType() == 2 && !newpath.isZipFile()) {
                return true;
            }
            if (oldpath.getId().compareToIgnoreCase(newpath.getID()) != 0) {
                return true;
            }
            ++i2;
        }
        entries = BuildManager.getInstance().getSourceLocations(this.getProject());
        if (entries.length != (sourceLocations = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getSourceLocations()).length) {
            return true;
        }
        int i3 = 0;
        while (i3 < entries.length) {
            Object srcLoc = null;
            srcLoc = sourceLocations[i3].getType() == 4 ? ResourcesPlugin.getWorkspace().getRoot().getProject(entries[i3]) : ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(entries[i3]));
            if (!srcLoc.exists()) {
                return true;
            }
            if (!srcLoc.equals((Object)sourceLocations[i3])) {
                return true;
            }
            ++i3;
        }
        String savedOutputLocation = BuildManager.getInstance().getOutputLocation(this.getProject());
        if (savedOutputLocation.length() == 0) {
            return true;
        }
        IFolder savedOutputLoc = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(savedOutputLocation));
        IContainer newOutputLocation = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getOutputLocation();
        if (savedOutputLoc == null || newOutputLocation == null) {
            return true;
        }
        if (!savedOutputLoc.equals((Object)newOutputLocation)) {
            return true;
        }
        IIDECompiler compiler = ProjectSettingsUtility.getCompiler(this.getProject());
        return compiler != null && !(oldCompilerId = BuildManager.getInstance().getCompilerId(this.getProject())).equals(compiler.getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isWorthBuilding() {
        if (ProjectSettingsUtility.getCompiler(this.getProject()) == null) {
            return false;
        }
        try {
            ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).updateEGLPath();
            if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isEGLPathBroken()) {
                this.getProject().deleteMarkers(AbstractMarkerProblemRequestor.PROBLEM, true, 2);
                IMarker marker = this.getProject().createMarker(AbstractMarkerProblemRequestor.BUILD_PROBLEM);
                marker.setAttribute("message", (Object)BuilderResources.buildAbortDueToEGLpathProblems);
                marker.setAttribute("severity", 2);
                marker.setAttribute("EGBuilAborted", true);
                return false;
            }
            IProject currentProject = this.getProject();
            IProject[] requiredProjects = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getRequiredProjects();
            int i = 0;
            while (true) {
                boolean cycleReferences;
                if (i >= requiredProjects.length) {
                    return true;
                }
                IProject p = requiredProjects[i];
                if (!(!p.exists() || !p.isOpen() || BuildManager.getInstance().getProjectState(p) || (cycleReferences = ProjectBuildPathManager.getInstance().getProjectBuildPath(p).hasCycle()) && EGLVAGCompatibilitySetting.isVAGCompatibility())) {
                    currentProject.deleteMarkers(AbstractMarkerProblemRequestor.PROBLEM, true, 2);
                    IMarker marker = currentProject.createMarker(AbstractMarkerProblemRequestor.PROBLEM);
                    marker.setAttribute("message", (Object)(ProjectBuildPathManager.getInstance().getProjectBuildPath(p).isEGLPathBroken() ? BuilderResources.bind((String)BuilderResources.buildPrereqProjectHasEGLpathProblems, (Object)p.getName()) : BuilderResources.bind((String)BuilderResources.buildPrereqProjectMustBeRebuilt, (Object)p.getName())));
                    marker.setAttribute("severity", 2);
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void mustPropagateStructuralChanges() {
        IProject[] projects = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getCycleParticipants();
        int i = 0;
        while (i < projects.length) {
            IProject proj = projects[i];
            if (!proj.equals((Object)this.getProject()) && this.hasBeenBuilt(proj)) {
                this.needRebuild();
                return;
            }
            ++i;
        }
    }

    protected void cleanOutputDir(IProject project) {
        IContainer container;
        if (!WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isReadOnly() && (container = ProjectBuildPathManager.getInstance().getProjectBuildPath(project).getOutputLocation()).getType() != 4) {
            try {
                IResource[] children = container.members();
                int i = 0;
                while (i < children.length) {
                    IResource child = children[i];
                    child.delete(true, null);
                    ++i;
                }
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }
}

