/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntryFactory;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.SystemIREnvironment;
import org.eclipse.edt.compiler.SystemPackageBuildPathEntryFactory;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.mof2binding.Mof2Binding;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class SystemEnvironmentManager {
    private static Map<String, ISystemEnvironment> systemMap = new HashMap<String, ISystemEnvironment>();

    public static ISystemEnvironment getSystemEnvironment(String path, ISystemEnvironment parentEnv, List<String> implicitEnums, IBuildNotifier notifier, ICompiler compiler) {
        if (systemMap.containsKey(path)) {
            return systemMap.get(path);
        }
        SystemEnvironment sysEnv = new SystemEnvironment((IEnvironment)new SystemIREnvironment(), parentEnv, implicitEnums, compiler);
        sysEnv.initializeSystemPackages(path, (ISystemPackageBuildPathEntryFactory)new SystemPackageBuildPathEntryFactory(new Mof2Binding((IBindingEnvironment)sysEnv)), notifier);
        systemMap.put(path, (ISystemEnvironment)sysEnv);
        return sysEnv;
    }

    public static ISystemEnvironment findSystemEnvironment(IProject project, IBuildNotifier notifier) {
        IIDECompiler compiler = ProjectSettingsUtility.getCompiler(project);
        if (compiler != null) {
            if (notifier != null) {
                notifier = notifier.createSubNotifier(0.2f);
            }
            return compiler.getSystemEnvironment(notifier);
        }
        return new SystemEnvironment((IEnvironment)new SystemIREnvironment(), null, new ArrayList(), (ICompiler)compiler);
    }
}

