/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.AbstractRecoverer;
import org.eclipse.edt.ide.core.internal.errors.ErrorMarkerCollector;
import org.eclipse.edt.ide.core.internal.errors.ErrorNonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.ParseTreePrinter;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.core.internal.model.document.EGLNodeNameUtility;

public class InvalidPhraseRecoverer
extends AbstractRecoverer {
    int inputDeleted;
    int contextDeleted;
    int nonTerminalSubstitution;
    boolean performDefaultReductions = true;

    @Override
    public int recoverDistance(ParseStack stack, TokenStream tokenStream) {
        if (this.performDefaultReductions) {
            stack = stack.copy();
            stack.performDefaultReductions();
        }
        int totalDeleted = 1;
        while (true) {
            this.contextDeleted = 0;
            while (this.contextDeleted <= stack.availableContext() && this.contextDeleted <= totalDeleted) {
                this.inputDeleted = totalDeleted - this.contextDeleted;
                if (this.inputDeleted <= tokenStream.numTokensLeft() && this.recoverDistance(this.inputDeleted, this.contextDeleted, stack, tokenStream) >= 3) {
                    return 3;
                }
                ++this.contextDeleted;
            }
            ++totalDeleted;
        }
    }

    private int recoverDistance(int inputDeleted, int contextDeleted, ParseStack stack, TokenStream tokenStream) {
        if (this.deletePhrase(inputDeleted, contextDeleted, stack, tokenStream) >= 3) {
            return 3;
        }
        ParseStack localStack = stack.copy();
        localStack.deleteContext(contextDeleted);
        short[] nonTerminalCandidates = this.grammar.getNonTerminalCandidates(localStack.getCurrentState());
        int i = 0;
        while (i < nonTerminalCandidates.length) {
            if (this.substitutePhrase(nonTerminalCandidates[i], inputDeleted, contextDeleted, stack, tokenStream) >= 3) {
                return 3;
            }
            ++i;
        }
        return 0;
    }

    private int deletePhrase(int inputDeleted, int contextDeleted, ParseStack stack, TokenStream tokenStream) {
        this.nonTerminalSubstitution = -1;
        stack = stack.copy();
        tokenStream = tokenStream.copy();
        stack.deleteContext(contextDeleted);
        if (!tokenStream.deleteInput(inputDeleted)) {
            return 0;
        }
        int distance = this.tryParseAhead(stack, tokenStream);
        return distance;
    }

    private int substitutePhrase(int ntSubstitute, int inputDeleted, int contextDeleted, ParseStack stack, TokenStream tokenStream) {
        this.nonTerminalSubstitution = ntSubstitute;
        stack = stack.copy();
        tokenStream = tokenStream.copy();
        stack.deleteContext(contextDeleted);
        if (!tokenStream.deleteInput(inputDeleted)) {
            return 0;
        }
        stack.shift(new ErrorNonTerminalNode(ntSubstitute));
        int distance = this.tryParseAhead(stack, tokenStream);
        return distance;
    }

    private void specialRecover(ParseStack stack, TokenStream tokenStream) {
        stack = stack.copy();
        tokenStream = tokenStream.copy();
        System.out.println("Stack Symbols:");
        ParseNode[] stackSymbols = stack.deleteContext(this.contextDeleted);
        int i = 0;
        while (i < stackSymbols.length) {
            System.out.println("   " + ParseTreePrinter.getLabel(stackSymbols[i]));
            ++i;
        }
        System.out.println("Input Symbols:");
        ParseNode[] inputSymbols = new ParseNode[this.inputDeleted];
        int i2 = 0;
        while (i2 < this.inputDeleted) {
            inputSymbols[i2] = tokenStream.lookAhead();
            System.out.println("   " + inputSymbols[i2]);
            tokenStream.shift();
            ++i2;
        }
        int[] nArray = new int[4];
        nArray[0] = 99;
        nArray[1] = 1;
        nArray[2] = 69;
    }

    @Override
    public void recover(ParseStack stack, TokenStream tokenStream) {
        if (this.performDefaultReductions) {
            stack.performDefaultReductions();
        }
        if (this.nonTerminalSubstitution == 3) {
            this.specialRecover(stack, tokenStream);
        }
        ParseNode[] deletedStackSymbols = stack.deleteContext(this.contextDeleted);
        tokenStream.deleteInput(this.inputDeleted);
        ParseNode[] deletedInputSymbols = tokenStream.getUnprocessedTerminals();
        ParseNode[] deletedSymbols = new ParseNode[deletedStackSymbols.length + deletedInputSymbols.length];
        System.arraycopy(deletedStackSymbols, 0, deletedSymbols, 0, deletedStackSymbols.length);
        System.arraycopy(deletedInputSymbols, 0, deletedSymbols, deletedStackSymbols.length, deletedInputSymbols.length);
        ParseNode deletedNode = this.chainNodes(deletedSymbols);
        if (this.nonTerminalSubstitution >= 0) {
            ErrorNonTerminalNode substitutionNode = new ErrorNonTerminalNode(this.nonTerminalSubstitution, deletedNode);
            stack.shift(substitutionNode);
        } else {
            ErrorNonTerminalNode errorNode = new ErrorNonTerminalNode(3, deletedNode);
            stack.connect(errorNode);
        }
        TerminalNode errorTerminal = this.findFirstNonWSTerminal(deletedStackSymbols);
        if (errorTerminal == null) {
            errorTerminal = this.findFirstNonWSTerminal(deletedInputSymbols);
        }
        this.errorMessage(stack, tokenStream, errorTerminal);
    }

    @Override
    public void errorMessage(ParseStack stack, TokenStream tokenStream, TerminalNode errorTerminal) {
        TerminalNode startErrorTerminal = errorTerminal;
        TerminalNode endErrorTerminal = tokenStream.previousNonWSTerminal(tokenStream.lookAhead());
        String message = "\tThe phrase \"" + errorTerminal.text + " ... " + endErrorTerminal.text;
        message = this.nonTerminalSubstitution < 0 ? String.valueOf(message) + "\" is unexpected " + this.contextDeleted + ":" + this.inputDeleted : String.valueOf(message) + "\" is not a valid " + EGLNodeNameUtility.getNonterminalName(this.nonTerminalSubstitution) + " " + this.contextDeleted + ":" + this.inputDeleted;
        ErrorMarkerCollector.instance.add(startErrorTerminal.offset, endErrorTerminal.offset + endErrorTerminal.text.length(), startErrorTerminal.line, message);
    }
}

