/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.utils.SoftLRUCache;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.lookup.ASTFileInfoWriter;
import org.eclipse.edt.ide.core.internal.lookup.CachedFileInfoReader;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;

public abstract class AbstractFileInfoManager {
    private String fileInfoFolder;
    private String fileInfoExtension;
    private HashMap fileInfoCache = new HashMap();

    public AbstractFileInfoManager(String fileInfoFolder, String fileInfoExtension) {
        this.fileInfoFolder = fileInfoFolder;
        this.fileInfoExtension = fileInfoExtension;
    }

    private FileInfoCacheEntry getFileInfoCacheEntry(IProject project) {
        FileInfoCacheEntry fileInfoEntry = (FileInfoCacheEntry)this.fileInfoCache.get(project);
        if (fileInfoEntry == null) {
            fileInfoEntry = new FileInfoCacheEntry(project);
            this.fileInfoCache.put(project, fileInfoEntry);
        }
        return fileInfoEntry;
    }

    public IFileInfo getFileInfo(IProject project, IPath projectRelativeFilePath) {
        IPath infoPath;
        FileInfoCacheEntry fileInfoCacheEntry = this.getFileInfoCacheEntry(project);
        IFileInfo cachedResult = (IFileInfo)fileInfoCacheEntry.cachedInfos.get((Object)projectRelativeFilePath);
        if (cachedResult == null && (infoPath = this.createFileInfoPath(project, projectRelativeFilePath)).toFile().exists()) {
            cachedResult = new CachedFileInfoReader(infoPath).read();
            fileInfoCacheEntry.cachedInfos.put((Object)projectRelativeFilePath, (Object)cachedResult);
        }
        return cachedResult;
    }

    public void saveFileInfo(IProject project, IPath projectRelativeFilePath, IFileInfo fileInfo) {
        FileInfoCacheEntry fileInfoCacheEntry = this.getFileInfoCacheEntry(project);
        fileInfoCacheEntry.cachedInfos.put((Object)projectRelativeFilePath, (Object)fileInfo);
        ASTFileInfoWriter.writeFileInfo(fileInfo, this.createFileInfoPath(project, projectRelativeFilePath));
    }

    public void clear(IProject project) {
        IPath fileInfoFolder = this.getSavedFileInfoFolder(project);
        this.clearSavedFileInfo(project, fileInfoFolder.toFile().listFiles());
        this.fileInfoCache.remove(project);
    }

    public void removeProject(IProject project) {
        this.fileInfoCache.remove(project);
    }

    public void removeFile(IProject project, IPath projectRelativeFilePath) {
        this.clearSavedFileInfo(project, new File[]{this.createFileInfoPath(project, projectRelativeFilePath).toFile()});
        this.getFileInfoCacheEntry(project).cachedInfos.remove((Object)projectRelativeFilePath);
    }

    public void removePackage(IProject project, IPath projectRelativePackagePath) {
        this.clearSavedFileInfo(project, new File[]{this.getSavedFileInfoFolder(project).append(projectRelativePackagePath).toFile()});
    }

    private void clearSavedFileInfo(IProject project, File[] files) {
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.clearSavedFileInfo(project, files[i].listFiles());
                }
                files[i].delete();
                ++i;
            }
        }
    }

    public IPath getSavedFileInfoFolder(IProject project) {
        return this.getFileInfoCacheEntry(project).projectLocation.append(this.fileInfoFolder);
    }

    private IPath createFileInfoPath(IProject project, IPath projectRelativeFilePath) {
        IPath fileInfoPath = this.getSavedFileInfoFolder(project).append(projectRelativeFilePath);
        return fileInfoPath.removeFileExtension().addFileExtension(this.fileInfoExtension);
    }

    private class FileInfoCacheEntry {
        private SoftLRUCache cachedInfos = new SoftLRUCache();
        private IPath projectLocation;

        public FileInfoCacheEntry(IProject project) {
            this.projectLocation = project.getWorkingLocation(EDTCoreIDEPlugin.getPlugin().getBundle().getSymbolicName());
        }
    }
}

