/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfoDifferenceNotificationRequestor;

public class FileInfoDifferencer {
    private IFileInfoDifferenceNotificationRequestor requestor;

    public FileInfoDifferencer(IFileInfoDifferenceNotificationRequestor requestor) {
        this.requestor = requestor;
    }

    public synchronized void findDifferences(IFileInfo previousVersion, IFileInfo currentVersion) {
        LinkedHashSet previousVersionPartNames = new LinkedHashSet(previousVersion.getPartNames());
        Set currentVersionPartNames = currentVersion.getPartNames();
        for (String partName : currentVersionPartNames) {
            if (previousVersionPartNames.contains(partName)) {
                previousVersionPartNames.remove(partName);
                if (previousVersion.getPartRange(partName).getLength() != currentVersion.getPartRange(partName).getLength() || previousVersion.getPartRange(partName).getOffset() != currentVersion.getPartRange(partName).getOffset()) {
                    this.requestor.partChanged(partName);
                    continue;
                }
                if (Arrays.equals(previousVersion.getMD5Key(partName), currentVersion.getMD5Key(partName))) continue;
                this.requestor.partChanged(partName);
                continue;
            }
            this.requestor.partAdded(partName);
        }
        for (String partName : previousVersionPartNames) {
            this.requestor.partRemoved(partName);
        }
    }
}

