/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;

public class WorkingCopyProjectEnvironmentManager {
    private Map<IProject, WorkingCopyProjectEnvironment> projectEnvironments = new HashMap<IProject, WorkingCopyProjectEnvironment>();
    private Map<IProject, ProjectIREnvironment> irEnvironments = new HashMap<IProject, ProjectIREnvironment>();
    private static final WorkingCopyProjectEnvironmentManager INSTANCE = new WorkingCopyProjectEnvironmentManager();

    private WorkingCopyProjectEnvironmentManager() {
    }

    public static WorkingCopyProjectEnvironmentManager getInstance() {
        return INSTANCE;
    }

    public void clear() {
        for (IProject project : this.irEnvironments.keySet()) {
            ProjectIREnvironment env = this.irEnvironments.get(project);
            env.reset();
        }
        for (IProject project : this.projectEnvironments.keySet()) {
            WorkingCopyProjectEnvironment prjEnv = this.projectEnvironments.get(project);
            prjEnv.clear();
        }
    }

    public void initialize() {
        for (IProject project : this.projectEnvironments.keySet()) {
            WorkingCopyProjectEnvironment prjEnv = this.projectEnvironments.get(project);
            prjEnv.setProjectBuildPathEntries(this.getProjectBuildPathEntriesFor(project));
        }
    }

    public WorkingCopyProjectEnvironment getProjectEnvironment(IProject project) {
        WorkingCopyProjectEnvironment result = this.projectEnvironments.get(project);
        if (result == null) {
            result = new WorkingCopyProjectEnvironment(project);
            this.projectEnvironments.put(project, result);
            result.setIREnvironment(this.getIREnvironment(project));
            result.setProjectBuildPathEntries(this.getProjectBuildPathEntriesFor(project));
            result.setDeclaringProjectBuildPathEntry(WorkingCopyProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project));
        }
        return result;
    }

    public ProjectIREnvironment getIREnvironment(IProject project) {
        ProjectIREnvironment env = this.irEnvironments.get(project);
        if (env == null) {
            env = new ProjectIREnvironment();
            this.irEnvironments.put(project, env);
        }
        return env;
    }

    private IWorkingCopyBuildPathEntry[] getProjectBuildPathEntriesFor(IProject project) {
        WorkingCopyProjectBuildPath projectBuildPath = WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(project);
        return projectBuildPath.getBuildPathEntries();
    }

    public void remove(IProject project) {
        this.projectEnvironments.remove(project);
        this.irEnvironments.remove(project);
    }
}

