/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.ide.core.internal.model.StrongLRUCache;

public class SoftLRUCache {
    private static final boolean DEBUG = false;
    private OrderedSoftReference first;
    private OrderedSoftReference last;
    private Map softReferences;
    private ReferenceQueue referenceQueue;
    private int maxSize;

    public SoftLRUCache(int maxSize) {
        this.maxSize = maxSize;
        this.softReferences = new HashMap();
        this.referenceQueue = new ReferenceQueue();
        this.first = new OrderedSoftReference();
        this.first.next = this.last = new OrderedSoftReference();
        this.last.previous = this.first;
    }

    public void put(Object key, Object value) {
        this.removeClearedReferences();
        this.softReferences.put(key, new OrderedSoftReference(key, value, this.referenceQueue, this.first, this.first.next));
        if (this.softReferences.size() > this.maxSize) {
            this.softReferences.remove(this.last.previous.remove().key);
        }
    }

    public Object get(Object key) {
        this.removeClearedReferences();
        OrderedSoftReference ref = (OrderedSoftReference)this.softReferences.get(key);
        if (ref == null) {
            return null;
        }
        Object result = ref.get();
        if (result != null) {
            ref.remove();
            ref.next = this.first.next;
            ref.previous = this.first;
            this.first.next.previous = ref;
            this.first.next = ref;
        }
        return result;
    }

    private void removeClearedReferences() {
        OrderedSoftReference ref;
        while ((ref = (OrderedSoftReference)this.referenceQueue.poll()) != null) {
            this.softReferences.remove(ref.remove().key);
        }
    }

    public static void main(String[] args) {
        StrongLRUCache cache = new StrongLRUCache(5);
        int i = 0;
        while (i < 100) {
            Integer key = new Integer((int)Math.floor(Math.random() * 100.0));
            if (Math.round(Math.random()) == 0L) {
                int sizeInKilobytes = (int)Math.floor(Math.random() * 100.0);
                int[] value = new int[sizeInKilobytes * 1024];
                cache.put(key, value);
            } else if (cache.get(key) != null) {
                System.out.println("Get: " + key);
            } else {
                System.out.println("Key Not found: " + key);
            }
            ++i;
        }
    }

    private static class OrderedSoftReference
    extends SoftReference {
        OrderedSoftReference previous;
        OrderedSoftReference next;
        Object key;

        OrderedSoftReference() {
            super(null);
        }

        OrderedSoftReference(Object key, Object referent, ReferenceQueue q, OrderedSoftReference previous, OrderedSoftReference next) {
            super(referent, q);
            this.key = key;
            this.previous = previous;
            this.next = next;
            this.previous.next = this;
            this.next.previous = this;
        }

        OrderedSoftReference remove() {
            this.previous.next = this.next;
            this.next.previous = this.previous;
            return this;
        }
    }
}

