/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.IsAExpression;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.ReturningToInvocationTargetClause;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.ShowStatement;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.IEGLDocumentAdapter;
import org.eclipse.edt.ide.core.internal.model.ISourceElementRequestor;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;

public class SourceElementParser {
    boolean doTiming = false;
    ISourceElementRequestor requestor;
    Stack partStack;
    private boolean reportReferencesInStatements;

    public SourceElementParser(ISourceElementRequestor requestor) {
        this.requestor = requestor;
        this.partStack = new Stack();
    }

    protected void traverseASTTree(File result) {
        this.requestor.enterEGLFile();
        PackageDeclaration pkgDecl = result.getPackageDeclaration();
        List imports = result.getImportDeclarations();
        List parts = result.getParts();
        try {
            if (pkgDecl != null) {
                int declStart = pkgDecl.getOffset();
                int declEnd = declStart + pkgDecl.getLength();
                this.requestor.acceptPackage(declStart, declEnd, pkgDecl.getName().getCanonicalName().toCharArray());
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Iterator iter = imports.iterator();
        while (iter.hasNext()) {
            try {
                ImportDeclaration element = (ImportDeclaration)iter.next();
                int declStart = element.getOffset();
                int declEnd = declStart + element.getLength();
                this.requestor.acceptImport(declStart, declEnd, element.getName().getCanonicalName().toCharArray(), element.isOnDemand());
                if (element.isOnDemand()) continue;
                char[][] type = Util.toCompoundChars(element.getName().getCanonicalName());
                int start = element.getOffset();
                int end = start + element.getLength();
                this.requestor.acceptPartReference(type, start, end);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.handleParts(parts);
    }

    public void parseEGLFile(EGLFile file) {
        try {
            IBuffer buffer = file.getBuffer();
            if (buffer instanceof IEGLDocumentAdapter) {
                IEGLDocumentAdapter adapter = (IEGLDocumentAdapter)((Object)file.getBuffer());
                org.eclipse.jface.text.IDocument doc = adapter.getDocument();
                if (doc instanceof IEGLDocument) {
                    IEGLDocument eglDocument = (IEGLDocument)doc;
                    this.traverseASTTree(eglDocument.getNewModelEGLFile());
                }
            } else {
                this.parseDocument(file, false);
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
    }

    public void parseDocument(IDocument file, boolean reportReferencesInStatements) {
        File result;
        this.reportReferencesInStatements = reportReferencesInStatements;
        String content = null;
        try {
            content = file.getStringContent();
        }
        catch (Exception exception) {}
        if (content == null) {
            return;
        }
        try {
            result = new EGLDocument(content).getNewModelEGLFile();
        }
        catch (Exception exception) {
            return;
        }
        this.traverseASTTree(result);
    }

    private void handleParts(List parts) {
        Iterator iter = parts.iterator();
        while (iter.hasNext()) {
            long strt = System.currentTimeMillis();
            Part part = (Part)iter.next();
            long end = System.currentTimeMillis();
            if (this.doTiming) {
                System.out.println("Access part " + part.getName().getCanonicalName() + " time: " + (end - strt));
            }
            int declEnd = 0;
            try {
                long starttotal = System.currentTimeMillis();
                declEnd = this.handleEnterPart((Node)part, part.getName(), part.isPrivate(), part.getPartType(), part.getContents());
                Iterator contentIter = part.getContents().iterator();
                while (contentIter.hasNext()) {
                    ((Node)contentIter.next()).accept((IASTVisitor)new DefaultASTVisitor(){
                        int nestedFormDeclEnd;

                        public boolean visit(NestedForm nestedForm) {
                            this.nestedFormDeclEnd = SourceElementParser.this.handleEnterPart((Node)nestedForm, nestedForm.getName(), nestedForm.isPrivate(), 4, nestedForm.getContents());
                            return true;
                        }

                        public void endVisit(NestedForm nestedForm) {
                            SourceElementParser.this.requestor.exitPart(this.nestedFormDeclEnd);
                        }

                        public boolean visit(UseStatement useStatement) {
                            SourceElementParser.this.handleUseDeclaration(useStatement);
                            return false;
                        }

                        public boolean visit(ClassDataDeclaration dataDecl) {
                            SourceElementParser.this.handleField((Node)dataDecl);
                            return false;
                        }

                        public boolean visit(NestedFunction nestedFunction) {
                            SourceElementParser.this.handleFunction(nestedFunction);
                            return false;
                        }

                        public boolean visit(StructureItem structureItem) {
                            SourceElementParser.this.handleField((Node)structureItem);
                            return false;
                        }

                        public boolean visit(ConstantFormField formField) {
                            SourceElementParser.this.handleField((Node)formField);
                            return false;
                        }

                        public boolean visit(VariableFormField formField) {
                            SourceElementParser.this.handleField((Node)formField);
                            return false;
                        }
                    });
                }
                part.accept((IASTVisitor)new DefaultASTVisitor(){

                    public boolean visit(Program program) {
                        Iterator parmIter = program.getParameters().iterator();
                        while (parmIter.hasNext()) {
                            SourceElementParser.this.handleField((Node)parmIter.next());
                        }
                        return false;
                    }

                    public boolean visit(ExternalType externalType) {
                        for (Name next : externalType.getExtendedTypes()) {
                            SourceElementParser.this.requestor.acceptUnknownReference(next.getCanonicalName().toCharArray(), next.getOffset());
                        }
                        return false;
                    }

                    public boolean visit(TopLevelFunction function) {
                        SourceElementParser.this.handleFunction(function);
                        return false;
                    }

                    public boolean visit(Delegate delegate) {
                        SourceElementParser.this.handleDelegate(delegate);
                        return false;
                    }
                });
                part.accept((IASTVisitor)new DefaultASTVisitor(){
                    char[] name = null;

                    public boolean visit(TopLevelFunction topLevelFunction) {
                        this.name = topLevelFunction.getName().getCanonicalName().toCharArray();
                        return true;
                    }

                    public boolean visit(DataItem dataItem) {
                        this.name = dataItem.getName().getCanonicalName().toCharArray();
                        return true;
                    }

                    public boolean visit(Enumeration enumNode) {
                        this.name = enumNode.getName().getCanonicalName().toCharArray();
                        return true;
                    }

                    public boolean visit(SettingsBlock settingsBlock) {
                        SourceElementParser.this.handlePropertyBlock(settingsBlock, this.name);
                        return false;
                    }
                });
                this.requestor.exitPart(declEnd);
                long endtotal = System.currentTimeMillis();
                long time = endtotal - starttotal;
                if (!this.doTiming) continue;
                System.out.println("Part " + part.getName().getCanonicalName() + " time: " + time);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private int handleEnterField(final Node decl) {
        int declStart = decl.getOffset();
        int declEnd = declStart + decl.getLength();
        final ArrayList list = new ArrayList();
        decl.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(StructureItem structureItem) {
                FieldInfo fInfo = new FieldInfo();
                Type type = structureItem.getType();
                if (structureItem.isEmbedded()) {
                    fInfo.name = type.getCanonicalName().toCharArray();
                    if (type.isNameType()) {
                        fInfo.type = ((NameType)type).getName().getCanonicalName().toCharArray();
                    }
                } else if (structureItem.isFiller()) {
                    fInfo.name = "*".toCharArray();
                    if (type != null) {
                        fInfo.type = type.getCanonicalName().toCharArray();
                    }
                } else {
                    fInfo.name = structureItem.getName().getCanonicalName().toCharArray();
                    fInfo.nameStart = decl.getOffset();
                    fInfo.nameEnd = fInfo.nameStart + fInfo.name.length;
                    if (type != null) {
                        fInfo.type = type.getCanonicalName().toCharArray();
                    }
                }
                fInfo.hasOccurs = type == null ? structureItem.hasOccurs() : type.isArrayType();
                if (structureItem.hasSettingsBlock()) {
                    SourceElementParser.this.handlePropertyBlock(structureItem.getSettingsBlock(), fInfo.name);
                }
                list.add(fInfo);
                return false;
            }

            public boolean visit(ConstantFormField constantFormField) {
                FieldInfo fInfo = new FieldInfo();
                fInfo.name = new char[]{'*'};
                fInfo.nameStart = decl.getOffset();
                fInfo.nameEnd = fInfo.nameStart + fInfo.name.length;
                list.add(fInfo);
                return false;
            }

            public boolean visit(FunctionDataDeclaration dataDecl) {
                List names = dataDecl.getNames();
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    FieldInfo fInfo = new FieldInfo();
                    Name name = (Name)iter.next();
                    fInfo.name = name.getCanonicalName().toCharArray();
                    fInfo.nameStart = name.getOffset();
                    fInfo.nameEnd = fInfo.nameStart + fInfo.name.length;
                    fInfo.type = dataDecl.getType().getCanonicalName().toCharArray();
                    if (dataDecl.hasSettingsBlock()) {
                        SourceElementParser.this.handlePropertyBlock(dataDecl.getSettingsBlockOpt(), fInfo.name);
                    }
                    list.add(fInfo);
                }
                return false;
            }

            public boolean visit(ClassDataDeclaration dataDecl) {
                List names = dataDecl.getNames();
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    FieldInfo fInfo = new FieldInfo();
                    Name name = (Name)iter.next();
                    fInfo.name = name.getCanonicalName().toCharArray();
                    fInfo.nameStart = name.getOffset();
                    fInfo.nameEnd = fInfo.nameStart + fInfo.name.length;
                    fInfo.type = dataDecl.getType().getCanonicalName().toCharArray();
                    if (dataDecl.isPrivate()) {
                        fInfo.modifiers = 2;
                    }
                    if (dataDecl.hasSettingsBlock()) {
                        SourceElementParser.this.handlePropertyBlock(dataDecl.getSettingsBlockOpt(), fInfo.name);
                    }
                    list.add(fInfo);
                }
                return false;
            }

            public boolean visit(FunctionParameter functionParameter) {
                FieldInfo fInfo = new FieldInfo();
                fInfo.name = functionParameter.getName().getCanonicalName().toCharArray();
                fInfo.nameStart = functionParameter.getName().getOffset();
                fInfo.nameEnd = fInfo.nameStart + fInfo.name.length;
                fInfo.type = functionParameter.getType().getCanonicalName().toCharArray();
                list.add(fInfo);
                return false;
            }

            public boolean visit(ProgramParameter programParameter) {
                FieldInfo fInfo = new FieldInfo();
                fInfo.name = programParameter.getName().getCanonicalName().toCharArray();
                fInfo.nameStart = programParameter.getName().getOffset();
                fInfo.nameEnd = fInfo.nameStart + fInfo.name.length;
                fInfo.type = programParameter.getType().getCanonicalName().toCharArray();
                list.add(fInfo);
                return false;
            }

            public boolean visit(VariableFormField variableFormField) {
                FieldInfo fInfo = new FieldInfo();
                fInfo.name = variableFormField.getName().getCanonicalName().toCharArray();
                fInfo.nameStart = variableFormField.getName().getOffset();
                fInfo.nameEnd = fInfo.nameStart + fInfo.name.length;
                fInfo.type = variableFormField.getType().getCanonicalName().toCharArray();
                fInfo.hasOccurs = variableFormField.getType().isArrayType();
                list.add(fInfo);
                return false;
            }
        });
        for (FieldInfo fInfo : list) {
            this.requestor.enterField(declStart, fInfo.modifiers, fInfo.type, null, fInfo.name, fInfo.nameStart, fInfo.nameEnd, fInfo.hasOccurs, declEnd);
        }
        return declEnd;
    }

    private int handleEnterPart(Node partNode, Name partName, boolean isPrivate, int partType, List partContents) {
        int declStart = partNode.getOffset();
        int declEnd = declStart + partNode.getLength();
        final PartInfo pInfo = new PartInfo();
        pInfo.name = partName.getCanonicalName().toCharArray();
        pInfo.nameStart = partName.getOffset();
        pInfo.nameEnd = pInfo.nameStart + pInfo.name.length;
        pInfo.modifier = isPrivate ? 2 : 1;
        partNode.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(Service service) {
                List implementedInterfaceNames = service.getImplementedInterfaces();
                int implementedInterfacesLength = implementedInterfaceNames.size();
                if (implementedInterfacesLength > 0) {
                    pInfo.interfaceNames = new char[implementedInterfacesLength][];
                    int i = 0;
                    Iterator iter = implementedInterfaceNames.iterator();
                    while (iter.hasNext()) {
                        pInfo.interfaceNames[i] = ((Name)iter.next()).getCanonicalName().toCharArray();
                        ++i;
                    }
                }
                return false;
            }
        });
        this.requestor.enterPart(partType, this.getSubTypeString(partNode), partNode.hashCode(), declStart, pInfo.modifier, pInfo.name, pInfo.nameStart, pInfo.nameEnd, pInfo.interfaceNames, pInfo.parameterNames, pInfo.parameterTypes, pInfo.usagePartTypes, pInfo.usagePartPackages, null);
        Iterator contentsIter = partContents.iterator();
        while (contentsIter.hasNext()) {
            ((Node)contentsIter.next()).accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(SettingsBlock settingsBlock) {
                    SourceElementParser.this.handlePropertyBlock(settingsBlock, pInfo.name);
                    return false;
                }
            });
        }
        return declEnd;
    }

    private char[] getSubTypeString(Node part) {
        final String[] result = new String[1];
        part.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(Program program) {
                result[0] = program.hasSubType() ? program.getSubType().getCanonicalName() : null;
                return false;
            }

            public boolean visit(Library library) {
                result[0] = library.hasSubType() ? library.getSubType().getCanonicalName() : null;
                return false;
            }

            public boolean visit(Record record) {
                result[0] = record.hasSubType() ? record.getSubType().getCanonicalName() : null;
                return false;
            }

            public boolean visit(DataTable datatable) {
                result[0] = datatable.hasSubType() ? datatable.getSubType().getCanonicalName() : null;
                return false;
            }

            public boolean visit(TopLevelForm form) {
                result[0] = form.hasSubType() ? form.getSubType().getCanonicalName() : null;
                return false;
            }

            public boolean visit(NestedForm form) {
                result[0] = form.hasSubType() ? form.getSubType().getCanonicalName() : null;
                return false;
            }

            public boolean visit(DataItem dataItem) {
                result[0] = dataItem.getType().getCanonicalName();
                return false;
            }

            public boolean visit(Handler handler) {
                result[0] = handler.hasSubType() ? handler.getSubType().getCanonicalName() : null;
                return false;
            }

            public boolean visit(Interface interfacePart) {
                result[0] = interfacePart.hasSubType() ? interfacePart.getSubType().getCanonicalName() : null;
                return false;
            }

            public boolean visit(ExternalType externalType) {
                result[0] = externalType.hasSubType() ? externalType.getSubType().getCanonicalName() : null;
                return false;
            }
        });
        if (result[0] != null) {
            return result[0].toCharArray();
        }
        return null;
    }

    private List getFunctionVariableDeclarations(Node funcNode) {
        final ArrayList result = new ArrayList();
        funcNode.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(TopLevelFunction topLevelFunction) {
                return true;
            }

            public boolean visit(NestedFunction nestedFunction) {
                return true;
            }

            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                result.add(functionDataDeclaration);
                return false;
            }
        });
        return result;
    }

    private int handleEnterDelegate(Delegate decl) {
        return this.handleEnterFunction((Node)decl, decl.getName(), decl.getParameters(), this.getFunctionVariableDeclarations((Node)decl), decl.hasReturnType() ? decl.getReturnType() : null, !decl.isPrivate());
    }

    private int handleEnterFunction(TopLevelFunction decl) {
        return this.handleEnterFunction((Node)decl, decl.getName(), decl.getFunctionParameters(), this.getFunctionVariableDeclarations((Node)decl), decl.hasReturnType() ? decl.getReturnType() : null, !decl.isPrivate());
    }

    private int handleEnterFunction(NestedFunction decl) {
        return this.handleEnterFunction((Node)decl, decl.getName(), decl.getFunctionParameters(), this.getFunctionVariableDeclarations((Node)decl), decl.hasReturnType() ? decl.getReturnType() : null, !decl.isPrivate());
    }

    private int handleEnterFunction(Node funcNode, Name funcName, List parms, List decls, Type returnType, boolean isPublic) {
        int declStart = funcNode.getOffset();
        int declEnd = declStart + funcNode.getLength();
        char[] name = funcName.getCanonicalName().toCharArray();
        int nameStart = funcName.getOffset();
        int nameEnd = nameStart + name.length;
        char[][] parmNames = new char[parms.size()][];
        char[][] typeNames = new char[parms.size()][];
        char[][] useTypes = new char[parms.size()][];
        boolean[] areNullable = new boolean[parms.size()];
        int i = 0;
        for (FunctionParameter parm : parms) {
            this.handleTypeReference(parm.getType());
            char[] typeName = parm.getType().getCanonicalName().toCharArray();
            char[] parmName = parm.getName().getCanonicalName().toCharArray();
            boolean isNullable = parm.getType().isNullableType();
            char[] useType = new char[]{};
            if (parm.getUseType() != null) {
                useType = parm.getUseType().toString().toCharArray();
            }
            parmNames[i] = parmName;
            typeNames[i] = typeName;
            useTypes[i] = useType;
            areNullable[i] = isNullable;
            ++i;
        }
        int modifier = isPublic ? 1 : 2;
        char[] returnTypeStr = null;
        if (returnType != null) {
            returnTypeStr = returnType.getCanonicalName().toCharArray();
            this.handleTypeReference(returnType);
        }
        if (this.reportReferencesInStatements) {
            LocalReferenceVisitor refVisitor = new LocalReferenceVisitor();
            funcNode.accept((IASTVisitor)refVisitor);
        }
        this.requestor.enterFunction(declStart, modifier, returnTypeStr, null, name, nameStart, nameEnd, typeNames, parmNames, useTypes, areNullable, null);
        for (Object element : decls) {
            this.handleField((Node)element);
        }
        return declEnd;
    }

    private void handleDelegate(Delegate delegate) {
        int end = this.handleEnterDelegate(delegate);
        this.requestor.exitFunction(end);
    }

    private void handleFunction(TopLevelFunction func) {
        int end = this.handleEnterFunction(func);
        this.requestor.exitFunction(end);
    }

    private void handleFunction(NestedFunction func) {
        int end = this.handleEnterFunction(func);
        this.requestor.exitFunction(end);
    }

    private void handleUseDeclaration(UseStatement decl) {
        int declStart = decl.getOffset();
        int declEnd = declStart + decl.getLength();
        Iterator iter = decl.getNames().iterator();
        while (iter.hasNext()) {
            char[] name = ((Name)iter.next()).getCanonicalName().toCharArray();
            this.requestor.acceptUse(declStart, declEnd, name);
        }
    }

    private void handleInitializer(Expression expr) {
        expr.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visitExpression(Expression expression) {
                return true;
            }

            private void handleType(Type type) {
                if (type.isNameType()) {
                    SourceElementParser.this.handleTypeNameReference(((NameType)type).getName(), (Node)type);
                } else {
                    SourceElementParser.this.handleTypeReference(type);
                }
            }

            public boolean visit(NewExpression newExpr) {
                this.handleType(newExpr.getType());
                return true;
            }

            public boolean visit(AsExpression newExpr) {
                if (newExpr.hasType()) {
                    this.handleType(newExpr.getType());
                }
                return true;
            }

            public boolean visit(IsAExpression newExpr) {
                this.handleType(newExpr.getType());
                return true;
            }
        });
    }

    private void handleField(final Node field) {
        int end = this.handleEnterField(field);
        field.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(StructureItem structureItem) {
                Type type = structureItem.getType();
                if (structureItem.isEmbedded()) {
                    if (type.isNameType()) {
                        SourceElementParser.this.handleTypeNameReference(((NameType)type).getName(), field);
                    }
                } else if (type != null) {
                    SourceElementParser.this.handleTypeReference(type);
                }
                if (structureItem.hasInitializer()) {
                    SourceElementParser.this.handleInitializer(structureItem.getInitializer());
                }
                return false;
            }

            public boolean visit(FunctionDataDeclaration dataDecl) {
                if (dataDecl.hasInitializer()) {
                    SourceElementParser.this.handleInitializer(dataDecl.getInitializer());
                }
                SourceElementParser.this.handleTypeReference(dataDecl.getType());
                return false;
            }

            public boolean visit(ClassDataDeclaration dataDecl) {
                if (dataDecl.hasInitializer()) {
                    SourceElementParser.this.handleInitializer(dataDecl.getInitializer());
                }
                SourceElementParser.this.handleTypeReference(dataDecl.getType());
                return false;
            }

            public boolean visit(FunctionParameter functionParameter) {
                SourceElementParser.this.handleTypeReference(functionParameter.getType());
                return false;
            }

            public boolean visit(ProgramParameter programParameter) {
                SourceElementParser.this.handleTypeReference(programParameter.getType());
                return false;
            }

            public boolean visit(VariableFormField variableFormField) {
                if (variableFormField.hasInitializer()) {
                    SourceElementParser.this.handleInitializer(variableFormField.getInitializer());
                }
                SourceElementParser.this.handleTypeReference(variableFormField.getType());
                return false;
            }
        });
        this.requestor.exitField(end);
    }

    private void handlePropertyBlock(SettingsBlock block, char[] name) {
        int start = block.getOffset();
        int end = start + block.getLength();
        this.requestor.enterPropertyBlock(start, name);
        List decls = block.getSettings();
        Iterator iter = decls.iterator();
        while (iter.hasNext()) {
            this.handleProperty((Node)iter.next());
        }
        this.requestor.exitPropertyBlock(end);
    }

    private void handleProperty(final Node decl) {
        decl.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(SetValuesExpression setValuesExpression) {
                Expression expr = setValuesExpression.getExpression();
                if (expr instanceof AnnotationExpression) {
                    Name exprName = ((AnnotationExpression)expr).getName();
                    SourceElementParser.this.requestor.acceptPropertyLiteralName(exprName.getOffset(), exprName.getOffset() + exprName.getLength(), exprName.getCanonicalString().toCharArray());
                }
                char[] name = expr.getCanonicalString().toCharArray();
                SettingsBlock block = setValuesExpression.getSettingsBlock();
                SourceElementParser.this.handlePropertyBlock(block, name);
                return false;
            }

            public boolean visit(Assignment assignment) {
                final int start = decl.getOffset();
                final int end = start + decl.getLength();
                final String lhsText = assignment.getLeftHandSide().getCanonicalString();
                assignment.getRightHandSide().accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                    public boolean visitName(Name name) {
                        char[] text = (String.valueOf(lhsText) + "=" + name.getCanonicalString()).toCharArray();
                        (this).SourceElementParser.this.requestor.acceptProperty(start, end, text);
                        return false;
                    }

                    public boolean visitLiteral(LiteralExpression expression) {
                        (this).SourceElementParser.this.requestor.acceptPropertyLiteralName(start, end, lhsText.toCharArray());
                        return false;
                    }

                    public boolean visitExpression(Expression expression) {
                        return true;
                    }
                });
                return false;
            }
        });
    }

    private void handleTypeReference(Type type) {
        Type baseType = type.getBaseType();
        if (baseType.isNameType()) {
            this.handleTypeNameReference(((NameType)baseType).getName(), (Node)baseType);
        }
    }

    private void handleTypeNameReference(Name typeName, Node node) {
        if (typeName.isSimpleName()) {
            char[] name = typeName.getCanonicalName().toCharArray();
            this.requestor.acceptPartReference(name, node.getOffset());
        } else {
            char[][] names = Util.toCompoundChars(typeName.getCanonicalName());
            int start = node.getOffset();
            int end = start + node.getLength();
            this.requestor.acceptPartReference(names, start, end);
        }
    }

    private static class FieldInfo {
        char[] type = new char[0];
        char[] name;
        int nameStart;
        int nameEnd;
        int modifiers = 1;
        boolean hasOccurs = false;

        private FieldInfo() {
        }
    }

    public class LocalReferenceVisitor
    extends AbstractASTVisitor {
        public boolean visit(final FunctionInvocation functionInvocation) {
            functionInvocation.getTarget().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(SimpleName simpleName) {
                    String functionName = simpleName.getCanonicalName();
                    ((LocalReferenceVisitor)LocalReferenceVisitor.this).SourceElementParser.this.requestor.acceptFunctionReference(functionName.toCharArray(), functionInvocation.getArguments().size(), functionInvocation.getOffset());
                    return false;
                }

                public boolean visit(QualifiedName qualifiedName) {
                    String functionName = qualifiedName.getCaseSensitiveIdentifier();
                    ((LocalReferenceVisitor)LocalReferenceVisitor.this).SourceElementParser.this.requestor.acceptFunctionReference(functionName.toCharArray(), functionInvocation.getArguments().size(), functionInvocation.getOffset());
                    Name qualifier = qualifiedName.getQualifier();
                    ((LocalReferenceVisitor)LocalReferenceVisitor.this).SourceElementParser.this.requestor.acceptUnknownReference(CharOperation.splitOn((char)'.', (char[])qualifier.getCanonicalString().toCharArray()), qualifier.getOffset(), qualifier.getOffset() + qualifier.getLength());
                    return false;
                }

                public boolean visit(FieldAccess fieldAccess) {
                    String functionName = fieldAccess.getID();
                    ((LocalReferenceVisitor)LocalReferenceVisitor.this).SourceElementParser.this.requestor.acceptFunctionReference(functionName.toCharArray(), functionInvocation.getArguments().size(), functionInvocation.getOffset());
                    Expression qualifier = fieldAccess.getPrimary();
                    ((LocalReferenceVisitor)LocalReferenceVisitor.this).SourceElementParser.this.requestor.acceptUnknownReference(CharOperation.splitOn((char)'.', (char[])qualifier.getCanonicalString().toCharArray()), qualifier.getOffset(), qualifier.getOffset() + qualifier.getLength());
                    return false;
                }
            });
            return true;
        }

        public boolean visit(SimpleName name) {
            SourceElementParser.this.requestor.acceptUnknownReference(name.getCaseSensitiveIdentifier().toCharArray(), name.getOffset());
            return false;
        }

        public boolean visit(QualifiedName qualifiedName) {
            Expression access = this.getDataAccessHelper((Expression)qualifiedName);
            if (access != null) {
                SourceElementParser.this.requestor.acceptUnknownReference(CharOperation.splitOn((char)'.', (char[])access.getCanonicalString().toCharArray()), access.getOffset(), access.getOffset() + access.getLength());
            }
            return true;
        }

        public boolean visit(ArrayAccess arrayAccess) {
            Expression access = this.getDataAccessHelper((Expression)arrayAccess);
            if (access != null) {
                SourceElementParser.this.requestor.acceptUnknownReference(CharOperation.splitOn((char)'.', (char[])access.getCanonicalString().toCharArray()), access.getOffset(), access.getOffset() + access.getLength());
            }
            return true;
        }

        public boolean visit(SubstringAccess substringAccess) {
            Expression access = this.getDataAccessHelper((Expression)substringAccess);
            if (access != null) {
                SourceElementParser.this.requestor.acceptUnknownReference(CharOperation.splitOn((char)'.', (char[])access.getCanonicalString().toCharArray()), access.getOffset(), access.getOffset() + access.getLength());
            }
            return true;
        }

        public boolean visit(FieldAccess fieldAccess) {
            Expression access = this.getDataAccessHelper((Expression)fieldAccess);
            if (access != null) {
                SourceElementParser.this.requestor.acceptUnknownReference(CharOperation.splitOn((char)'.', (char[])access.getCanonicalString().toCharArray()), access.getOffset(), access.getOffset() + access.getLength());
            }
            return true;
        }

        private Expression getDataAccessHelper(Expression dataAccess) {
            Object result = null;
            Object temp = dataAccess;
            result = dataAccess;
            while (temp != null) {
                if (temp instanceof ArrayAccess || temp instanceof SubstringAccess) {
                    Expression root = temp instanceof ArrayAccess ? ((ArrayAccess)temp).getArray() : ((SubstringAccess)temp).getPrimary();
                    if (root instanceof FieldAccess || root instanceof QualifiedName) {
                        temp = result = root;
                        continue;
                    }
                    temp = null;
                    continue;
                }
                temp = temp instanceof FieldAccess ? ((FieldAccess)temp).getPrimary() : (temp instanceof QualifiedName ? ((QualifiedName)temp).getQualifier() : null);
            }
            result = result instanceof FieldAccess ? ((FieldAccess)result).getPrimary() : (result instanceof QualifiedName ? ((QualifiedName)result).getQualifier() : null);
            return result;
        }

        public boolean visit(CallStatement callStatement) {
            Expression expr = callStatement.getInvocationTarget();
            if (expr.isName()) {
                SourceElementParser.this.handleTypeNameReference((Name)expr, (Node)expr);
            }
            return true;
        }

        public boolean visit(ShowStatement showStatement) {
            showStatement.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(ShowStatement showStatement) {
                    return true;
                }

                public boolean visit(ReturningToInvocationTargetClause returningToInvocationTargetClause) {
                    Expression expr = returningToInvocationTargetClause.getExpression();
                    if (expr.isName()) {
                        SourceElementParser.this.handleTypeNameReference((Name)expr, (Node)expr);
                    }
                    return false;
                }
            });
            return true;
        }

        public boolean visit(TransferStatement transferStatement) {
            Expression expr;
            if (transferStatement.isToProgram() && (expr = transferStatement.getInvocationTarget()).isName()) {
                SourceElementParser.this.handleTypeNameReference((Name)expr, (Node)expr);
            }
            return true;
        }

        public boolean visit(IsAExpression isa) {
            Type type = isa.getType();
            if (type.isNameType()) {
                SourceElementParser.this.handleTypeNameReference(((NameType)type).getName(), (Node)type);
            } else {
                SourceElementParser.this.handleTypeReference(type);
            }
            return false;
        }

        public boolean visit(AsExpression as) {
            if (as.hasType()) {
                Type type = as.getType();
                if (type.isNameType()) {
                    SourceElementParser.this.handleTypeNameReference(((NameType)type).getName(), (Node)type);
                } else {
                    SourceElementParser.this.handleTypeReference(type);
                }
            }
            return false;
        }

        public boolean visit(NewExpression newExpr) {
            Type type = newExpr.getType();
            if (type.isNameType()) {
                SourceElementParser.this.handleTypeNameReference(((NameType)type).getName(), (Node)type);
            } else {
                SourceElementParser.this.handleTypeReference(type);
            }
            return true;
        }
    }

    private static class PartInfo {
        char[] name;
        int nameStart;
        int nameEnd;
        int modifier;
        char[][] interfaceNames = null;
        char[][] parameterNames = null;
        char[][] parameterTypes = null;
        char[][] usagePartTypes = null;
        char[][] usagePartPackages = null;

        private PartInfo() {
        }
    }
}

