/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.MemberElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceField;
import org.eclipse.edt.ide.core.internal.model.SourceFunction;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.Flags;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;

public class SourcePartElementInfo
extends MemberElementInfo {
    protected static final IField[] NO_FIELDS = new IField[0];
    protected static final IFunction[] NO_FUNCTIONS = new IFunction[0];
    protected static final IPart[] NO_PARTS = new IPart[0];
    protected int fPartType = 0;
    protected char[] fSubType = null;
    protected char[] fEnclosingPartName = null;
    protected char[][] interfaceNames;
    protected char[][] parameterNames;
    protected char[][] parameterTypeNames;
    protected char[][] usagePartTypes;
    protected char[][] usagePartPackages;
    protected char[] fSourceFileName = null;
    protected char[] fPackageName = null;
    protected char[] fQualifiedName = null;
    protected char[][] fImports = null;
    protected IPart fHandle = null;
    protected int fContentHashCode;

    protected void addImport(char[] i) {
        if (this.fImports == null) {
            this.fImports = new char[][]{i};
        } else {
            char[][] copy = new char[this.fImports.length + 1][];
            System.arraycopy(this.fImports, 0, copy, 0, this.fImports.length);
            copy[this.fImports.length] = i;
            this.fImports = copy;
        }
    }

    public IPart getEnclosingPart() {
        IEGLElement parent = this.fHandle.getParent();
        if (parent != null && parent.getElementType() == 8) {
            try {
                return (IPart)((EGLElement)parent).getElementInfo();
            }
            catch (EGLModelException eGLModelException) {
                return null;
            }
        }
        return null;
    }

    public char[] getEnclosingPartName() {
        return this.fEnclosingPartName;
    }

    public IField[] getFields() {
        int length = this.fChildren.length;
        if (length == 0) {
            return NO_FIELDS;
        }
        IField[] fields = new IField[length];
        int fieldIndex = 0;
        int i = 0;
        while (i < length) {
            IEGLElement child = this.fChildren[i];
            if (child instanceof SourceField) {
                try {
                    IField field = (IField)((SourceField)child).getElementInfo();
                    fields[fieldIndex++] = field;
                }
                catch (EGLModelException eGLModelException) {}
            }
            ++i;
        }
        if (fieldIndex == 0) {
            return NO_FIELDS;
        }
        IField[] iFieldArray = fields;
        fields = new IField[fieldIndex];
        System.arraycopy(iFieldArray, 0, fields, 0, fieldIndex);
        return fields;
    }

    public char[] getFileName() {
        return this.fSourceFileName;
    }

    public IPart getHandle() {
        return this.fHandle;
    }

    public char[][] getImports() {
        return this.fImports;
    }

    public char[][] getInterfaceNames() {
        return this.interfaceNames;
    }

    protected void setInterfaceNames(char[][] interfaceNames) {
        this.interfaceNames = interfaceNames;
    }

    public IPart[] getMemberParts() {
        int length = this.fChildren.length;
        if (length == 0) {
            return NO_PARTS;
        }
        IPart[] memberTypes = new IPart[length];
        int typeIndex = 0;
        int i = 0;
        while (i < length) {
            IEGLElement child = this.fChildren[i];
            if (child instanceof SourcePart) {
                try {
                    IPart type = (IPart)((SourcePart)child).getElementInfo();
                    memberTypes[typeIndex++] = type;
                }
                catch (EGLModelException eGLModelException) {}
            }
            ++i;
        }
        if (typeIndex == 0) {
            return NO_PARTS;
        }
        IPart[] iPartArray = memberTypes;
        memberTypes = new IPart[typeIndex];
        System.arraycopy(iPartArray, 0, memberTypes, 0, typeIndex);
        return memberTypes;
    }

    public IFunction[] getFunctions() {
        int length = this.fChildren.length;
        if (length == 0) {
            return NO_FUNCTIONS;
        }
        IFunction[] functions = new IFunction[length];
        int functionIndex = 0;
        int i = 0;
        while (i < length) {
            IEGLElement child = this.fChildren[i];
            if (child instanceof SourceFunction) {
                try {
                    IFunction function = (IFunction)((SourceFunction)child).getElementInfo();
                    functions[functionIndex++] = function;
                }
                catch (EGLModelException eGLModelException) {}
            }
            ++i;
        }
        if (functionIndex == 0) {
            return NO_FUNCTIONS;
        }
        IFunction[] iFunctionArray = functions;
        functions = new IFunction[functionIndex];
        System.arraycopy(iFunctionArray, 0, functions, 0, functionIndex);
        return functions;
    }

    public char[] getPackageName() {
        return this.fPackageName;
    }

    public char[] getQualifiedName() {
        return this.fQualifiedName;
    }

    public boolean isBinaryType() {
        return false;
    }

    protected void setEnclosingPartName(char[] enclosingPartName) {
        this.fEnclosingPartName = enclosingPartName;
    }

    protected void setHandle(IPart handle) {
        this.fHandle = handle;
    }

    protected void setPackageName(char[] name) {
        this.fPackageName = name;
    }

    protected void setQualifiedName(char[] name) {
        this.fQualifiedName = name;
    }

    protected void setSourceFileName(char[] name) {
        this.fSourceFileName = name;
    }

    public String toString() {
        if (this.fHandle != null) {
            return "Info for " + this.fHandle.toString();
        }
        return super.toString();
    }

    public boolean isDataItem() {
        return this.fPartType == 3;
    }

    public boolean isDataTable() {
        return this.fPartType == 6;
    }

    public boolean isForm() {
        return this.fPartType == 4;
    }

    public boolean isFormGroup() {
        return this.fPartType == 5;
    }

    public boolean isFunction() {
        return this.fPartType == 2;
    }

    public boolean isLibrary() {
        return this.fPartType == 8;
    }

    public boolean isProgram() {
        return this.fPartType == 0;
    }

    public boolean isCalledProgram() {
        return this.isProgram() && this.parameterNames != null;
    }

    public boolean isPublic() {
        return Flags.isPublic(this.flags);
    }

    public boolean isExternalType() {
        return this.fPartType == 13;
    }

    public boolean isEnumeration() {
        return this.fPartType == 14;
    }

    public boolean isDelegate() {
        return this.fPartType == 12;
    }

    public boolean isRecord() {
        return this.fPartType == 1;
    }

    public boolean isHandler() {
        return this.fPartType == 9;
    }

    public boolean isService() {
        return this.fPartType == 10;
    }

    public boolean isInterface() {
        return this.fPartType == 11;
    }

    public int getPartType() {
        return this.fPartType;
    }

    public void setPartType(int i) {
        this.fPartType = i;
    }

    public String getSubTypeSignature() {
        if (this.fSubType != null) {
            return Signature.createTypeSignature(this.fSubType, false);
        }
        return null;
    }

    public char[] getSubTypeName() {
        return this.fSubType;
    }

    public void setSubTypeName(char[] string) {
        this.fSubType = string;
    }

    public int getContentHashCode() {
        return this.fContentHashCode;
    }

    public char[] getFPackageName() {
        return this.fPackageName;
    }

    public void setContentHashCode(int i) {
        this.fContentHashCode = i;
    }

    public void setFPackageName(char[] cs) {
        this.fPackageName = cs;
    }

    public char[][] getParameterNames() {
        return this.parameterNames;
    }

    protected void setParameterNames(char[][] parameterNames) {
        this.parameterNames = parameterNames;
    }

    public char[][] getParameterTypeNames() {
        return this.parameterTypeNames;
    }

    protected void setParameterTypeNames(char[][] parameterTypeNames) {
        this.parameterTypeNames = parameterTypeNames;
    }

    public char[][] getUsagePartTypes() {
        return this.usagePartTypes;
    }

    protected void setUsagePartTypes(char[][] usagePartTypes) {
        this.usagePartTypes = usagePartTypes;
    }

    public char[][] getUsagePartPackages() {
        return this.usagePartPackages;
    }

    protected void setUsagePartPackages(char[][] usagePartPackages) {
        this.usagePartPackages = usagePartPackages;
    }
}

