/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.model.BinaryElementParser;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.ide.core.internal.model.indexing.AbstractIndexer;
import org.eclipse.edt.ide.core.internal.model.indexing.BinaryIndexerRequestor;

public class BinaryIndexer
extends AbstractIndexer {
    public static final String[] FILE_TYPES = new String[]{"eglxml", "eglar"};
    private IProject project;

    public BinaryIndexer() {
        this.project = null;
    }

    public BinaryIndexer(IProject project) {
        this.project = project;
    }

    @Override
    public String[] getFileTypes() {
        return FILE_TYPES;
    }

    @Override
    protected void indexFile(IDocument document) throws IOException {
        if (document == null) {
            return;
        }
        this.output.addDocument(document);
        BinaryIndexerRequestor requestor = new BinaryIndexerRequestor(this, document);
        BinaryElementParser parser = new BinaryElementParser(requestor, this.project);
        byte[] source = null;
        char[] name = null;
        try {
            source = document.getByteContent();
            name = document.getName().toCharArray();
        }
        catch (Exception exception) {}
        if (source == null || name == null) {
            return;
        }
        try {
            parser.parseDocument(document, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setFileTypes(String[] fileTypes) {
    }
}

