/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.refactor;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class SettingUpdateResourceChangeListener
implements IResourceChangeListener {
    private static SettingUpdateResourceChangeListener INSTANCE = new SettingUpdateResourceChangeListener();

    private SettingUpdateResourceChangeListener() {
    }

    public static SettingUpdateResourceChangeListener getInstance() {
        return INSTANCE;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            switch (event.getType()) {
                case 1: 
                case 4: 
                case 16: {
                    IResourceDelta resDelta = event.getDelta();
                    if (resDelta == null) break;
                    try {
                        ResourceConfigurationChecker rcChecker = new ResourceConfigurationChecker(resDelta);
                        resDelta.accept((IResourceDeltaVisitor)rcChecker);
                    }
                    catch (CoreException coreException) {}
                    break;
                }
            }
        }
    }

    private class ResourceConfigurationChecker
    implements IResourceDeltaVisitor {
        private IResourceDelta fRootDelta;
        private HashSet fValidatedFilesSet = new HashSet();

        public ResourceConfigurationChecker(IResourceDelta rootDelta) {
            this.fRootDelta = rootDelta;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource dResource = delta.getResource();
            int rcType = dResource.getType();
            if (rcType == 4 || rcType == 2) {
                int flags = delta.getFlags();
                switch (delta.getKind()) {
                    case 2: {
                        if ((flags & 0x2000) == 0) {
                            this.handleDeleteFolder(dResource.getProject(), dResource.getFullPath());
                            break;
                        }
                    }
                    case 4: {
                        if ((flags & 0x2000) != 0) {
                            IPath path = delta.getMovedToPath();
                            if (path == null) break;
                            this.handleRenamedFolder(dResource.getProject(), dResource.getFullPath(), path);
                            break;
                        }
                        if ((flags & 0x1000) != 0) {
                            IPath path = delta.getMovedFromPath();
                            if (path == null) break;
                            this.handleRenamedFolder(dResource.getProject(), path, dResource.getFullPath());
                            break;
                        }
                        return true;
                    }
                }
                return false;
            }
            if (rcType == 1 && !dResource.isDerived()) {
                int flags = delta.getFlags();
                switch (delta.getKind()) {
                    case 2: {
                        if ((flags & 0x2000) == 0) {
                            this.handleDeleteFile(dResource.getProject(), dResource.getFullPath());
                            break;
                        }
                    }
                    case 1: 
                    case 4: {
                        IPath path;
                        if ((flags & 0x2000) != 0) {
                            IPath path2 = delta.getMovedToPath();
                            if (path2 == null) break;
                            this.handleRenamedFile(dResource.getProject(), dResource.getFullPath(), path2);
                            break;
                        }
                        if ((flags & 0x1000) == 0 || (path = delta.getMovedFromPath()) == null) break;
                        this.handleRenamedFile(dResource.getProject(), path, dResource.getFullPath());
                        break;
                    }
                }
                return false;
            }
            return true;
        }

        private void handleRenamedFile(IProject project, final IPath fromPath, final IPath toPath) {
            if (!this.fValidatedFilesSet.add(fromPath)) {
                return;
            }
            Runnable op = new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectSettingsUtility.replaceWorkspaceSettings(fromPath, toPath);
                    }
                    catch (BackingStoreException backingStoreException) {}
                }
            };
            PlatformUI.getWorkbench().getDisplay().asyncExec(op);
        }

        private void handleRenamedFolder(final IProject project, final IPath fromPath, final IPath toPath) {
            if (!this.fValidatedFilesSet.add(fromPath)) {
                return;
            }
            Runnable op = new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectSettingsUtility.replaceWorkspaceSettings(fromPath, toPath);
                        ResourceConfigurationChecker.this.handleRenamedProject(project, fromPath, toPath);
                    }
                    catch (BackingStoreException backingStoreException) {}
                }
            };
            PlatformUI.getWorkbench().getDisplay().asyncExec(op);
        }

        private void handleRenamedProject(IProject project, IPath fromPath, IPath toPath) {
            try {
                IEGLProject eglProject = EGLCore.create(project);
                IEGLProject[] referencingProjects = eglProject.getReferencingProjects();
                if (referencingProjects != null) {
                    IEGLProject[] iEGLProjectArray = referencingProjects;
                    int n = referencingProjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEGLProject referencingProject = iEGLProjectArray[n2];
                        this.renameEntryInClasspath(referencingProject, fromPath, toPath);
                        ++n2;
                    }
                }
            }
            catch (EGLModelException eGLModelException) {}
        }

        private void renameEntryInClasspath(IEGLProject eglproject, IPath fromPath, IPath toPath) throws EGLModelException {
            IEGLPathEntry[] classpath = eglproject.getRawEGLPath();
            IEGLPathEntry[] newClasspath = null;
            int cpLength = classpath.length;
            int newCPIndex = -1;
            int i = 0;
            while (i < cpLength) {
                IEGLPathEntry entry = classpath[i];
                IPath entryPath = entry.getPath();
                if (fromPath.equals((Object)entryPath)) {
                    if (newClasspath == null) {
                        newClasspath = new IEGLPathEntry[cpLength];
                        System.arraycopy(classpath, 0, newClasspath, 0, i);
                        newCPIndex = i;
                    }
                    if (entry.getEntryKind() == 2) {
                        newClasspath[newCPIndex++] = EGLCore.newProjectEntry(toPath, entry.isExported());
                    }
                } else if (newClasspath != null) {
                    newClasspath[newCPIndex++] = entry;
                }
                ++i;
            }
            if (newClasspath != null) {
                if (newCPIndex < newClasspath.length) {
                    IEGLPathEntry[] iEGLPathEntryArray = newClasspath;
                    newClasspath = new IEGLPathEntry[newCPIndex];
                    System.arraycopy(iEGLPathEntryArray, 0, newClasspath, 0, newCPIndex);
                }
                eglproject.setRawEGLPath(newClasspath, null);
            }
        }

        private void handleDeleteFile(IProject project, final IPath path) {
            if (!this.fValidatedFilesSet.add(path)) {
                return;
            }
            Runnable op = new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectSettingsUtility.removeWorkspaceSettings(path);
                    }
                    catch (BackingStoreException backingStoreException) {}
                }
            };
            PlatformUI.getWorkbench().getDisplay().asyncExec(op);
        }

        private void handleDeleteFolder(final IProject project, final IPath path) {
            if (!this.fValidatedFilesSet.add(path)) {
                return;
            }
            Runnable op = new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectSettingsUtility.removeWorkspaceSettings(path);
                        ResourceConfigurationChecker.this.handleDeletedProject(project, path);
                    }
                    catch (BackingStoreException backingStoreException) {}
                }
            };
            PlatformUI.getWorkbench().getDisplay().asyncExec(op);
        }

        private void handleDeletedProject(IProject project, IPath path) {
            try {
                IEGLProject eglProject = EGLCore.create(project);
                IEGLProject[] referencingProjects = eglProject.getReferencingProjects();
                if (referencingProjects != null) {
                    IEGLProject[] iEGLProjectArray = referencingProjects;
                    int n = referencingProjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEGLProject referencingProject = iEGLProjectArray[n2];
                        this.removeEntryFromClasspath(referencingProject, path);
                        ++n2;
                    }
                }
            }
            catch (EGLModelException eGLModelException) {}
        }

        protected void removeEntryFromClasspath(IEGLProject project, IPath rootPath) throws EGLModelException {
            IEGLPathEntry[] classpath = project.getRawEGLPath();
            IEGLPathEntry[] newClasspath = null;
            int cpLength = classpath.length;
            int newCPIndex = -1;
            int i = 0;
            while (i < cpLength) {
                IEGLPathEntry entry = classpath[i];
                if (rootPath.equals((Object)entry.getPath())) {
                    if (newClasspath == null) {
                        newClasspath = new IEGLPathEntry[cpLength];
                        System.arraycopy(classpath, 0, newClasspath, 0, i);
                        newCPIndex = i;
                    }
                } else if (newClasspath != null) {
                    newClasspath[newCPIndex++] = entry;
                }
                ++i;
            }
            if (newClasspath != null) {
                if (newCPIndex < newClasspath.length) {
                    IEGLPathEntry[] iEGLPathEntryArray = newClasspath;
                    newClasspath = new IEGLPathEntry[newCPIndex];
                    System.arraycopy(iEGLPathEntryArray, 0, newClasspath, 0, newCPIndex);
                }
                project.setRawEGLPath(newClasspath, null);
            }
        }

        private IProject findModifiedProject(final String oldProjectName) {
            IResourceDelta projectDelta = this.fRootDelta.findMember((IPath)new Path(oldProjectName));
            boolean replaced = false;
            if (projectDelta != null) {
                switch (projectDelta.getKind()) {
                    case 2: {
                        if ((projectDelta.getFlags() & 0x2000) == 0) {
                            return null;
                        }
                    }
                    case 4: {
                        IPath path;
                        if ((projectDelta.getFlags() & 0x2000) == 0 || (path = projectDelta.getMovedToPath()) == null) break;
                        return ResourcesPlugin.getWorkspace().getRoot().findMember(path).getProject();
                    }
                }
            }
            final IProject[] project = new IProject[1];
            try {
                this.fRootDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource dResource = delta.getResource();
                        int rcType = dResource.getType();
                        if (rcType == 8) {
                            return true;
                        }
                        if (rcType == 4) {
                            switch (delta.getKind()) {
                                case 1: 
                                case 4: {
                                    IPath path;
                                    if ((delta.getFlags() & 0x1000) == 0 || (path = delta.getMovedFromPath()) == null || !path.segment(0).equals(oldProjectName)) break;
                                    project[0] = dResource.getProject();
                                    break;
                                }
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException coreException) {}
            if (project[0] == null && !replaced) {
                project[0] = ResourcesPlugin.getWorkspace().getRoot().findMember(oldProjectName).getProject();
            }
            return project[0];
        }
    }
}

