/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.search.matching.SearchPattern;
import org.eclipse.edt.ide.core.model.IFunction;

public abstract class FunctionPattern
extends SearchPattern {
    protected char[] selector;
    protected char[] declaringQualification;
    protected char[] decodedSelector;
    protected int decodedParameterCount;

    public FunctionPattern(int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
    }

    public abstract String getPatternName();

    @Override
    protected boolean matchIndexEntry() {
        if (this.selector != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals((char[])this.selector, (char[])this.decodedSelector, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals((char[])this.selector, (char[])this.decodedSelector, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match((char[])this.selector, (char[])this.decodedSelector, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean needsResolve() {
        return this.declaringQualification != null;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append(this.getPatternName());
        if (this.selector != null) {
            buffer.append(this.selector);
        } else {
            buffer.append("*");
        }
        buffer.append('(');
        buffer.append(')');
        buffer.append(", ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    protected int matchLevelForType(char[] simpleNamePattern, char[] qualificationPattern, String[] packageName, String partName) {
        char[] qualifiedPackageName;
        if (partName == null) {
            return 3;
        }
        StringBuffer qualifiedPartName = new StringBuffer();
        qualifiedPartName.append(partName);
        StringBuffer result = new StringBuffer();
        if (packageName != null) {
            int i = 0;
            while (i < packageName.length) {
                result.append(packageName[i]);
                if (i + 1 < packageName.length) {
                    result.append('.');
                }
                ++i;
            }
            qualifiedPackageName = result.toString().toCharArray();
        } else {
            qualifiedPackageName = null;
        }
        char[] qualifiedSourceName = qualifiedPartName.toString().toCharArray();
        if (this.matchesType(simpleNamePattern, qualificationPattern, qualifiedPackageName == null ? qualifiedSourceName : CharOperation.concat((char[])qualifiedPackageName, (char[])qualifiedSourceName, (char)'.'))) {
            return 2;
        }
        if (qualificationPattern != null && new String(qualificationPattern).indexOf(46) == -1 && this.matchesType(CharOperation.concat((char[])qualificationPattern, (char[])simpleNamePattern, (char)'.'), null, qualifiedPackageName == null ? qualifiedSourceName : CharOperation.concat((char[])qualifiedPackageName, (char[])qualifiedSourceName, (char)'.'))) {
            return 2;
        }
        return 0;
    }

    @Override
    public int matchesFunctionPartType(Name node, IPartBinding partBinding) {
        if (partBinding != null && partBinding.getKind() == 20) {
            return this.matchLevelForType(this.selector, this.declaringQualification, partBinding);
        }
        IBinding b = node.resolveBinding();
        if (b != null && b != IBinding.NOT_FOUND_BINDING) {
            ITypeBinding typeBinding = null;
            if (b.isDataBinding()) {
                typeBinding = ((IDataBinding)b).getType();
            }
            if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING && typeBinding.getKind() == 20) {
                IPartBinding pBinding = ((IFunctionBinding)typeBinding).getDeclarer();
                String[] packageName = pBinding.getPackageName().length > 0 ? pBinding.getPackageName() : null;
                String partName = String.valueOf(pBinding.getCaseSensitiveName()) + "." + typeBinding.getCaseSensitiveName();
                return this.matchLevelForType(this.selector, this.declaringQualification, packageName, partName);
            }
        }
        return 3;
    }

    @Override
    public int matchesFunctionPartType(IFunction function) {
        if (function != null) {
            return this.matchLevelForType(this.selector, this.declaringQualification, function);
        }
        return 3;
    }
}

