/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.CompiledFileUnit;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.HandleFactory;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.WorkingCopy;
import org.eclipse.edt.ide.core.internal.search.matching.ClassFileMatchLocator;
import org.eclipse.edt.ide.core.internal.search.matching.MatchVisitor;
import org.eclipse.edt.ide.core.internal.search.matching.MatchingNodeSet;
import org.eclipse.edt.ide.core.internal.search.matching.OrPattern;
import org.eclipse.edt.ide.core.internal.search.matching.PackageDeclarationPattern;
import org.eclipse.edt.ide.core.internal.search.matching.PotentialMatch;
import org.eclipse.edt.ide.core.internal.search.matching.PotentialMatchSet;
import org.eclipse.edt.ide.core.internal.search.matching.SearchPattern;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IUseDeclaration;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.model.Signature;
import org.eclipse.edt.ide.core.search.ICompiledFileUnit;
import org.eclipse.edt.ide.core.search.IEGLSearchResultCollector;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;

public class MatchLocator2 {
    private MatchVisitor matchVisitor;
    public static final int MAX_AT_ONCE = 500;
    public static final PotentialMatch[] NO_POTENTIAL_MATCH = new PotentialMatch[0];
    private SearchPattern pattern;
    private boolean forceQualification;
    public int detailLevel;
    public boolean matchImports;
    public IEGLSearchResultCollector collector;
    public IEGLSearchScope scope;
    public IProgressMonitor progressMonitor;
    public IWorkingCopy[] workingCopies;
    public HandleFactory handleFactory;
    boolean compilationAborted;
    public PotentialMatchSet potentialMatches;
    public int parseThreshold = -1;
    public ICompiledFileUnit[] unitsToProcess;
    public PotentialMatch[] matchesToProcess;
    public int totalUnits;
    public PotentialMatch currentPotentialMatch;

    public MatchLocator2(SearchPattern pattern, boolean matchImports, boolean forceQualification, int detailLevel, IEGLSearchResultCollector collector, IEGLSearchScope scope, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.detailLevel = detailLevel;
        this.collector = collector;
        this.scope = scope;
        this.progressMonitor = progressMonitor;
        this.matchImports = matchImports;
        this.forceQualification = forceQualification;
    }

    protected void addEGLFile(PotentialMatch sourceUnit, ICompiledFileUnit parsedUnit) {
        int size = this.unitsToProcess.length;
        if (this.totalUnits == size) {
            int newSize = size == 0 ? 1 : size * 2;
            this.unitsToProcess = new ICompiledFileUnit[newSize];
            System.arraycopy(this.unitsToProcess, 0, this.unitsToProcess, 0, this.totalUnits);
            this.matchesToProcess = new PotentialMatch[newSize];
            System.arraycopy(this.matchesToProcess, 0, this.matchesToProcess, 0, this.totalUnits);
        }
        this.matchesToProcess[this.totalUnits] = sourceUnit;
        this.unitsToProcess[this.totalUnits] = parsedUnit;
        ++this.totalUnits;
    }

    void addPotentialMatch(IResource resource, Openable openable) {
        PotentialMatch potentialMatch = new PotentialMatch(this, resource, openable);
        this.potentialMatches.add(potentialMatch);
    }

    protected void createAndResolveBindings(PotentialMatch[] potentialMatches, int start, int length) {
        int i = start;
        int maxUnits = start + length;
        while (i < maxUnits) {
            block16: {
                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                PotentialMatch potentialMatch = potentialMatches[i];
                try {
                    try {
                        if (potentialMatch != null) {
                            this.matchVisitor.matchSet = potentialMatch.matchingNodeSet;
                        }
                        if (SearchEngine.VERBOSE) {
                            System.out.println("Parsing " + potentialMatch.openable.toStringWithAncestors());
                        }
                        if (potentialMatch.openable instanceof WorkingCopy) {
                            throw new RuntimeException();
                        }
                        ICompiledFileUnit searchTarget = null;
                        if (potentialMatch.openable instanceof IClassFile) {
                            searchTarget = new CompiledFileUnit();
                        } else {
                            IEGLFile eglFile = (IEGLFile)((Object)potentialMatch.openable);
                            IFile ioFile = (IFile)eglFile.getResource();
                            searchTarget = WorkingCopyCompiler.getInstance().compileFile(ioFile);
                            int j = 0;
                            while (j < searchTarget.getFileParts().size()) {
                                Node node = (Node)searchTarget.getFileParts().get(j);
                                node.accept((IASTVisitor)this.matchVisitor);
                                ++j;
                            }
                            if (this.matchImports) {
                                String fileastPartName = org.eclipse.edt.ide.core.internal.utils.Util.getFilePartName(ioFile);
                                IPackageFragment packageFragment = (IPackageFragment)eglFile.getAncestor(4);
                                String[] packageName = packageFragment.isDefaultPackage() ? new String[]{} : packageFragment.getElementName().split("\\.");
                                WorkingCopyCompiler.getInstance().compilePart(ioFile.getProject(), packageName, ioFile, new IWorkingCopy[0], fileastPartName, new IWorkingCopyCompileRequestor(){

                                    @Override
                                    public void acceptResult(WorkingCopyCompilationResult result) {
                                        result.getBoundPart().accept((IASTVisitor)new AbstractASTVisitor(){

                                            public boolean visit(ImportDeclaration importDecl) {
                                                importDecl.accept((IASTVisitor)MatchLocator2.this.matchVisitor);
                                                return false;
                                            }
                                        });
                                    }
                                });
                            }
                        }
                        this.addEGLFile(potentialMatch, searchTarget);
                        if (this.progressMonitor != null) {
                            this.progressMonitor.worked(4);
                        }
                    }
                    catch (Exception e) {
                        if (SearchEngine.VERBOSE) {
                            System.out.println("Exception occurred! See stack trace.");
                            e.printStackTrace();
                        }
                        this.matchVisitor.matchSet = null;
                        potentialMatches[i] = null;
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    this.matchVisitor.matchSet = null;
                    potentialMatches[i] = null;
                    throw throwable;
                }
                this.matchVisitor.matchSet = null;
                potentialMatches[i] = null;
            }
            ++i;
        }
    }

    public IField createFieldHandle(Node field, IPart part) {
        if (part == null) {
            return null;
        }
        final String[] fieldname = new String[1];
        field.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visitName(Name name) {
                fieldname[0] = name.getCanonicalName();
                return false;
            }
        });
        if (fieldname[0] != null) {
            return part.getField(fieldname[0]);
        }
        return null;
    }

    public IUseDeclaration createUseHandle(Name use, IPart part) {
        if (part == null) {
            return null;
        }
        return part.getUseDeclaration(use.getCanonicalName());
    }

    public IEGLElement createImportHandle(ImportDeclaration importRef) {
        Openable currentOpenable;
        char[] importName = importRef.getName().getCanonicalName().toCharArray();
        if (importRef.isOnDemand()) {
            importName = CharOperation.concat((char[])importName, (char[])".*".toCharArray());
        }
        if ((currentOpenable = this.getCurrentOpenable()) instanceof EGLFile) {
            return ((EGLFile)currentOpenable).getImport(new String(importName));
        }
        return null;
    }

    public IFunction createFunctionHandle(TopLevelFunction function, IPart part) {
        if (part == null) {
            return null;
        }
        List parameters = function.getFunctionParameters();
        int length = parameters.size();
        String[] parameterTypeSignatures = new String[length];
        int i = 0;
        while (i < length) {
            Type parameterType = ((FunctionParameter)parameters.get(i)).getType();
            char[] typeName = new char[]{};
            while (parameterType.isArrayType()) {
                typeName = CharOperation.concat((char[])typeName, (char[])"[]".toCharArray());
                parameterType = ((ArrayType)parameterType).getElementType();
            }
            typeName = CharOperation.concat((char[])parameterType.getCanonicalName().toCharArray(), (char[])typeName);
            parameterTypeSignatures[i] = Signature.createTypeSignature(typeName, false);
            ++i;
        }
        return part.getFunction(function.getName().getCanonicalName(), parameterTypeSignatures);
    }

    public IFunction createFunctionHandle(NestedFunction function, IPart part) {
        if (part == null) {
            return null;
        }
        List parameters = function.getFunctionParameters();
        int length = parameters.size();
        String[] parameterTypeSignatures = new String[length];
        int i = 0;
        while (i < length) {
            Type parameterType = ((FunctionParameter)parameters.get(i)).getType();
            char[] typeName = new char[]{};
            while (parameterType.isArrayType()) {
                typeName = CharOperation.concat((char[])typeName, (char[])"[]".toCharArray());
                parameterType = ((ArrayType)parameterType).getElementType();
            }
            typeName = CharOperation.concat((char[])parameterType.getCanonicalName().toCharArray(), (char[])typeName);
            parameterTypeSignatures[i] = Signature.createTypeSignature(typeName, false);
            ++i;
        }
        return part.getFunction(function.getName().getCanonicalName(), parameterTypeSignatures);
    }

    public IEGLElement createPartHandle(String simplePartName) {
        Openable currentOpenable = this.getCurrentOpenable();
        if (currentOpenable instanceof IEGLFile) {
            IEGLFile unit = (IEGLFile)((Object)currentOpenable);
            return unit.getPart(simplePartName);
        }
        return null;
    }

    public IEGLElement createPartHandle(IPart parent, String simpleTypeName) {
        return parent.getPart(simpleTypeName);
    }

    protected Openable getCurrentOpenable() {
        return this.currentPotentialMatch.openable;
    }

    protected IResource getCurrentResource() {
        return this.currentPotentialMatch.resource;
    }

    public void initialize(EGLProject project) throws EGLModelException {
        this.initialize(project, NO_POTENTIAL_MATCH);
    }

    public void initialize(EGLProject project, PotentialMatch[] potentialMatches) throws EGLModelException {
        this.matchVisitor = new MatchVisitor();
        this.totalUnits = 0;
        int maxUnits = potentialMatches.length;
        this.unitsToProcess = new ICompiledFileUnit[maxUnits];
        this.matchesToProcess = new PotentialMatch[maxUnits];
    }

    private void locateMatches(EGLProject eglProject) throws EGLModelException {
        PotentialMatch[] potentialMatches = this.potentialMatches.getPotentialMatches(eglProject.getPackageFragmentRoots());
        int length = potentialMatches.length;
        int index = 0;
        while (index < length) {
            int max = Math.min(500, length - index);
            this.locateMatches(eglProject, potentialMatches, index, max);
            index += max;
        }
    }

    private void locateMatches(EGLProject eglProject, PotentialMatch[] potentialMatches, int start, int length) throws EGLModelException {
        PotentialMatch[] copy = new PotentialMatch[length];
        System.arraycopy(potentialMatches, start, copy, 0, length);
        this.initialize(eglProject, copy);
        this.compilationAborted = false;
        this.createAndResolveBindings(potentialMatches, start, length);
        copy = null;
        potentialMatches = null;
        ICompiledFileUnit unit = null;
        int i = 0;
        while (i < this.totalUnits) {
            if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            unit = this.unitsToProcess[i];
            try {
                this.process(unit, i);
            }
            catch (CoreException e) {
                if (e instanceof EGLModelException) {
                    this.compilationAborted = true;
                }
                throw new EGLModelException(e);
            }
            this.unitsToProcess[i] = null;
            this.matchesToProcess[i] = null;
            if (this.progressMonitor != null) {
                this.progressMonitor.worked(5);
            }
            ++i;
        }
    }

    public void locateMatches(String[] filePaths, IWorkspace workspace, IWorkingCopy[] workingCopies) throws EGLModelException {
        int wcLength;
        if (SearchEngine.VERBOSE) {
            System.out.println("Locating matches in files [");
            int i = 0;
            int length = filePaths.length;
            while (i < length) {
                String path = filePaths[i];
                System.out.println("\t" + path);
                ++i;
            }
            System.out.println("]");
            if (workingCopies != null) {
                System.out.println("and working copies [");
                i = 0;
                length = workingCopies.length;
                while (i < length) {
                    IWorkingCopy wc = workingCopies[i];
                    System.out.println("\t" + ((EGLElement)((Object)wc)).toStringWithAncestors());
                    ++i;
                }
                System.out.println("]");
            }
        }
        if (this.handleFactory == null) {
            this.handleFactory = new HandleFactory(workspace);
        }
        this.workingCopies = workingCopies;
        HashMap<String, IWorkingCopy> wcPaths = new HashMap<String, IWorkingCopy>();
        if (workingCopies != null && (wcLength = workingCopies.length) > 0) {
            String[] newPaths = new String[wcLength];
            int i = 0;
            while (i < wcLength) {
                IWorkingCopy workingCopy = workingCopies[i];
                String path = workingCopy.getOriginalElement().getPath().toString();
                wcPaths.put(path, workingCopy);
                newPaths[i] = path;
                ++i;
            }
            int filePathsLength = filePaths.length;
            String[] stringArray = filePaths;
            filePaths = new String[filePathsLength + wcLength];
            System.arraycopy(stringArray, 0, filePaths, 0, filePathsLength);
            System.arraycopy(newPaths, 0, filePaths, filePathsLength, wcLength);
        }
        int length = filePaths.length;
        if (this.progressMonitor != null) {
            if (this.pattern.needsResolve) {
                this.progressMonitor.beginTask("", length * 10);
            } else {
                this.progressMonitor.beginTask("", length * 5);
            }
        }
        Util.sort(filePaths);
        this.potentialMatches = new PotentialMatchSet();
        EGLProject previousEGLProject = null;
        int i = 0;
        while (i < length) {
            block27: {
                IResource resource;
                Openable openable;
                block25: {
                    IWorkingCopy workingCopy;
                    block30: {
                        String pathString;
                        block29: {
                            if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            pathString = filePaths[i];
                            if (i > 0 && pathString.equals(filePaths[i - 1])) break block27;
                            workingCopy = (IWorkingCopy)wcPaths.get(pathString);
                            if (workingCopy == null) break block29;
                            openable = (Openable)((Object)workingCopy);
                            break block30;
                        }
                        openable = this.handleFactory.createOpenable(pathString);
                        if (openable == null) break block27;
                    }
                    resource = null;
                    EGLProject eglProject = null;
                    try {
                        eglProject = (EGLProject)openable.getEGLProject();
                        resource = workingCopy != null ? workingCopy.getOriginalElement().getResource() : openable.getResource();
                        if (resource == null) {
                            resource = eglProject.getProject();
                        }
                        if (eglProject.equals(previousEGLProject)) break block25;
                        if (previousEGLProject != null) {
                            block26: {
                                try {
                                    this.locateMatches(previousEGLProject);
                                }
                                catch (EGLModelException e) {
                                    if (!(e.getException() instanceof CoreException)) break block26;
                                    throw e;
                                }
                            }
                            this.potentialMatches = new PotentialMatchSet();
                        }
                        previousEGLProject = eglProject;
                    }
                    catch (EGLModelException eGLModelException) {
                        break block27;
                    }
                }
                this.addPotentialMatch(resource, openable);
                if (this.progressMonitor != null) {
                    this.progressMonitor.worked(1);
                }
            }
            ++i;
        }
        if (previousEGLProject != null) {
            block28: {
                try {
                    this.locateMatches(previousEGLProject);
                }
                catch (EGLModelException e) {
                    if (!(e.getException() instanceof CoreException)) break block28;
                    throw e;
                }
            }
            this.potentialMatches = new PotentialMatchSet();
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    public void locatePackageDeclarations(IWorkspace workspace) throws EGLModelException {
        this.locatePackageDeclarations(this.pattern, workspace);
    }

    private void locatePackageDeclarations(SearchPattern searchPattern, IWorkspace workspace) throws EGLModelException {
        if (searchPattern instanceof OrPattern) {
            OrPattern orPattern = (OrPattern)searchPattern;
            this.locatePackageDeclarations(orPattern.leftPattern, workspace);
            this.locatePackageDeclarations(orPattern.rightPattern, workspace);
        } else if (searchPattern instanceof PackageDeclarationPattern) {
            PackageDeclarationPattern pkgPattern = (PackageDeclarationPattern)searchPattern;
            IEGLProject[] projects = EGLModelManager.getEGLModelManager().getEGLModel().getEGLProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IEGLProject eglProject = projects[i];
                IPackageFragmentRoot[] roots = eglProject.getPackageFragmentRoots();
                int j = 0;
                int rootsLength = roots.length;
                while (j < rootsLength) {
                    IEGLElement[] pkgs = roots[j].getChildren();
                    int k = 0;
                    int pksLength = pkgs.length;
                    while (k < pksLength) {
                        IPackageFragment pkg = (IPackageFragment)pkgs[k];
                        if (pkg.getChildren().length > 0 && pkgPattern.matchesName(pkgPattern.pkgName, pkg.getElementName().toCharArray())) {
                            IResource resource = pkg.getResource();
                            if (resource == null) {
                                resource = eglProject.getProject();
                            }
                            this.currentPotentialMatch = new PotentialMatch(this, resource, null);
                            try {
                                this.report(-1, -2, pkg, 0);
                            }
                            catch (CoreException e) {
                                if (e instanceof EGLModelException) {
                                    throw (EGLModelException)e;
                                }
                                throw new EGLModelException(e);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(ICompiledFileUnit unit, int i) throws CoreException {
        MatchingNodeSet matchingNodeSet = null;
        try {
            this.currentPotentialMatch = this.matchesToProcess[i];
            if (this.currentPotentialMatch == null) {
                return;
            }
            matchingNodeSet = this.currentPotentialMatch.matchingNodeSet;
            if (unit == null) {
                return;
            }
            if (unit.getFile() == null && this.currentPotentialMatch.openable instanceof ClassFile) {
                ClassFile classFile = (ClassFile)this.currentPotentialMatch.openable;
                new ClassFileMatchLocator(this).locateMatches(classFile);
                return;
            }
            this.matchVisitor.matchSet = this.currentPotentialMatch.matchingNodeSet;
            matchingNodeSet.cuHasBeenResolved = this.compilationAborted;
            matchingNodeSet.reportMatching(unit);
            if (!this.pattern.needsResolve) {
                if (!matchingNodeSet.needsResolve()) return;
            }
            if (unit.getFileParts().size() <= 0) return;
            if (this.compilationAborted) return;
            if (SearchEngine.VERBOSE) {
                System.out.println("Resolving " + this.currentPotentialMatch.openable.toStringWithAncestors());
            }
            matchingNodeSet.cuHasBeenResolved = true;
            matchingNodeSet.reportMatching(unit);
            return;
        }
        finally {
            this.matchVisitor.matchSet = null;
            this.currentPotentialMatch = null;
        }
    }

    public void report(int sourceStart, int sourceEnd, IEGLElement element, int accuracy) throws CoreException {
        if (this.scope.encloses(element)) {
            if (SearchEngine.VERBOSE) {
                IResource res = this.getCurrentResource();
                System.out.println("Reporting match");
                System.out.println("\tResource: " + (res == null ? " <unknown> " : res.getFullPath().toString()));
                System.out.println("\tPositions: [" + sourceStart + ", " + sourceEnd + "]");
                System.out.println("\tJava element: " + ((EGLElement)element).toStringWithAncestors());
                if (accuracy == 0) {
                    System.out.println("\tAccuracy: EXACT_MATCH");
                } else {
                    System.out.println("\tAccuracy: POTENTIAL_MATCH");
                }
            }
            this.report(this.getCurrentResource(), sourceStart, sourceEnd, element, accuracy);
        }
    }

    public void report(IResource resource, int sourceStart, int sourceEnd, IEGLElement element, int accuracy) throws CoreException {
        this.collector.accept(resource, sourceStart, sourceEnd, element, accuracy);
    }

    public void reportField(Node field, final IEGLElement parent, final int accuracy) throws CoreException {
        field.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                try {
                    MatchLocator2.this.report(((SimpleName)classDataDeclaration.getNames().get(0)).getOffset(), ((SimpleName)classDataDeclaration.getNames().get(0)).getOffset() + ((SimpleName)classDataDeclaration.getNames().get(0)).getLength(), parent instanceof IPart ? ((IPart)parent).getField(new String(((SimpleName)classDataDeclaration.getNames().get(0)).getCanonicalName())) : parent, accuracy);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return false;
            }

            public boolean visit(NestedForm nestedForm) {
                try {
                    MatchLocator2.this.report(nestedForm.getName().getOffset(), nestedForm.getName().getOffset() + nestedForm.getName().getLength(), parent instanceof IPart ? ((IPart)parent).getPart(new String(nestedForm.getName().getCanonicalName())) : parent, accuracy);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
    }

    public void reportImport(ImportDeclaration reference, int accuracy) throws CoreException {
        IEGLElement importHandle = this.createImportHandle(reference);
        this.pattern.matchReportImportRef(reference, importHandle, accuracy, this);
    }

    public void reportPackageDeclaration(PackageDeclaration node) {
    }

    public void reportReference(Node reference, TopLevelFunction function, IEGLElement parent, int accuracy) throws CoreException {
        this.pattern.matchReportReference(reference, parent, accuracy, this);
    }

    public void reportReference(Node reference, Delegate delegate, IEGLElement parent, int accuracy) throws CoreException {
        this.pattern.matchReportReference(reference, parent, accuracy, this);
    }

    public void reportReference(Node reference, NestedFunction function, IEGLElement parent, int accuracy) throws CoreException {
        this.pattern.matchReportReference(reference, parent, accuracy, this);
    }

    public void reportReference(IPart element, IEGLElement parent, int accuracy) {
        try {
            this.collector.accept(parent == null ? element.getClassFile() : (parent instanceof BinaryPart ? ((BinaryPart)parent).getClassFile() : parent), element.getSourceRange().getOffset(), element.getSourceRange().getOffset() + element.getSourceRange().getLength(), this.getCurrentResource(), accuracy);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void reportFieldReference(Node reference, Node decl, IEGLElement parent, int accuracy) throws CoreException {
        IEGLElement enclosingElement;
        if (parent instanceof IPart) {
            enclosingElement = this.createFieldHandle(decl, (IPart)parent);
            if (enclosingElement == null) {
                return;
            }
        } else {
            enclosingElement = parent;
        }
        this.pattern.matchReportReference(reference, enclosingElement, accuracy, this);
    }

    public void reportUseReference(Node reference, Part partDeclaration, Name use, IEGLElement parent, int accuracy) throws CoreException {
        IEGLElement enclosingElement;
        if (parent instanceof IPart) {
            enclosingElement = this.createUseHandle(use, (IPart)parent);
            if (enclosingElement == null) {
                return;
            }
        } else {
            enclosingElement = parent;
        }
        this.pattern.matchReportReference(reference, enclosingElement, accuracy, this);
    }

    public void reportImplementsReference(Node reference, Part partDeclaration, Name use, IEGLElement parent, int accuracy) throws CoreException {
        this.pattern.matchReportReference(reference, parent, accuracy, this);
    }

    public void reportPartDeclaration(Part partDeclaration, IEGLElement parent, int accuracy) throws CoreException {
        Name name = partDeclaration.getName();
        this.report(name.getOffset(), name.getOffset() + name.getLength(), parent == null ? this.createPartHandle(name.getCanonicalName()) : parent, accuracy);
    }

    public void reportPartDeclaration(IPart partDeclaration, IEGLElement parent, int accuracy) throws CoreException {
        this.collector.accept(parent == null ? partDeclaration.getClassFile() : (parent instanceof BinaryPart ? ((BinaryPart)parent).getClassFile() : parent), partDeclaration.getNameRange().getOffset(), partDeclaration.getNameRange().getOffset() + partDeclaration.getNameRange().getLength(), this.getCurrentResource(), accuracy);
    }

    public void reportPartDeclaration(IMember member, IEGLElement parent, int accuracy) throws CoreException {
        this.collector.accept(parent == null ? member.getClassFile() : (parent instanceof BinaryPart ? ((BinaryPart)parent).getClassFile() : parent), 0, 0, this.getCurrentResource(), accuracy);
    }

    public void reportFunctionDeclaration(TopLevelFunction functionDeclaration, IEGLElement parent, int accuracy) throws CoreException {
        Name name = functionDeclaration.getName();
        this.report(name.getOffset(), name.getOffset() + name.getLength(), parent == null ? this.createPartHandle(name.getCanonicalName()) : parent, accuracy);
    }

    public void reportFunctionDeclaration(NestedFunction functionDeclaration, IEGLElement parent, int accuracy) throws CoreException {
        Name name = functionDeclaration.getName();
        this.report(name.getOffset(), name.getOffset() + name.getLength(), parent == null ? this.createPartHandle(name.getCanonicalName()) : parent, accuracy);
    }

    public void reportFunctionDeclaration(IFunction functionDeclaration, IEGLElement parent, int accuracy) throws CoreException {
        this.collector.accept(parent == null ? functionDeclaration.getClassFile() : (parent instanceof BinaryPart ? ((BinaryPart)parent).getClassFile() : parent), 0, 0, this.getCurrentResource(), accuracy);
    }

    public int matchContainer() {
        return this.pattern.matchContainer();
    }

    public int matchesPartType(Name node, IPartBinding partBinding) {
        return this.pattern.matchesPartType(node, partBinding, this.forceQualification);
    }

    public int matchesNestedFormPart(NestedForm node) {
        return this.pattern.matchesNestedFormPart(node);
    }

    public int matchesPart(IPart iPart) {
        return this.pattern.matchesPart(iPart);
    }

    public int matchesPart(Part node) {
        return this.pattern.matchesPart(node);
    }

    public int matchesFunctionPartType(Name node, IPartBinding partBinding) {
        return this.pattern.matchesFunctionPartType(node, partBinding);
    }

    public int matchesFunctionPart(TopLevelFunction function) {
        return this.pattern.matchesFunctionPart(function);
    }

    public int matchesAnnotationType(Name node, IAnnotationTypeBinding binding) {
        return this.pattern.matchesAnnotationType(node, binding, this.forceQualification);
    }

    protected int matchCheck(Node node) {
        return this.pattern.matchCheck(node);
    }

    protected int matchCheck(IMember part) {
        return this.pattern.matchCheck(part);
    }

    protected void matchCheck(Node node, MatchingNodeSet set) {
        this.pattern.matchCheck(node, set);
    }

    public int matchLevel(Node node, boolean resolve) {
        return this.pattern.matchLevel(node, resolve);
    }

    public SearchPattern getPattern() {
        return this.pattern;
    }
}

